/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.admin.DeviceAdminInfo;
import android.app.admin.IDevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.PowerManager;
import android.os.RecoverySystem;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.storage.ExternalStorageFormatter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.XmlUtils;
import com.android.internal.widget.LockPatternUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevicePolicyManagerService
extends IDevicePolicyManager.Stub {
    private static final String TAG = "DevicePolicyManagerService";
    private static final int REQUEST_EXPIRE_PASSWORD = 5571;
    private static final long EXPIRATION_GRACE_PERIOD_MS = 432000000L;
    protected static final String ACTION_EXPIRED_PASSWORD_NOTIFICATION = "com.android.server.ACTION_EXPIRED_PASSWORD_NOTIFICATION";
    private static final long MS_PER_DAY = 86400000L;
    final Context mContext;
    final MyPackageMonitor mMonitor;
    final PowerManager.WakeLock mWakeLock;
    IPowerManager mIPowerManager;
    int mActivePasswordQuality = 0;
    int mActivePasswordLength = 0;
    int mActivePasswordUpperCase = 0;
    int mActivePasswordLowerCase = 0;
    int mActivePasswordLetters = 0;
    int mActivePasswordNumeric = 0;
    int mActivePasswordSymbols = 0;
    int mActivePasswordNonLetter = 0;
    int mFailedPasswordAttempts = 0;
    int mPasswordOwner = -1;
    Handler mHandler = new Handler();
    final HashMap<ComponentName, ActiveAdmin> mAdminMap = new HashMap();
    final ArrayList<ActiveAdmin> mAdminList = new ArrayList();
    BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.BOOT_COMPLETED".equals(action) || DevicePolicyManagerService.ACTION_EXPIRED_PASSWORD_NOTIFICATION.equals(action)) {
                Slog.v((String)DevicePolicyManagerService.TAG, (String)("Sending password expiration notifications for action " + action));
                DevicePolicyManagerService.this.mHandler.post(new Runnable(){

                    public void run() {
                        DevicePolicyManagerService.this.handlePasswordExpirationNotification();
                    }
                });
            }
        }
    };
    public static final String SYSTEM_PROP_DISABLE_CAMERA = "sys.secpolicy.camera.disabled";

    public DevicePolicyManagerService(Context context) {
        this.mContext = context;
        this.mMonitor = new MyPackageMonitor();
        this.mMonitor.register(context, true);
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, "DPM");
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BOOT_COMPLETED");
        filter.addAction(ACTION_EXPIRED_PASSWORD_NOTIFICATION);
        context.registerReceiver(this.mReceiver, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExpirationAlarmCheckLocked(Context context) {
        long alarmTime;
        long expiration = this.getPasswordExpirationLocked(null);
        long now = System.currentTimeMillis();
        long timeToExpire = expiration - now;
        if (expiration == 0L) {
            alarmTime = 0L;
        } else if (timeToExpire <= 0L) {
            alarmTime = now + 86400000L;
        } else {
            long alarmInterval = timeToExpire % 86400000L;
            if (alarmInterval == 0L) {
                alarmInterval = 86400000L;
            }
            alarmTime = now + alarmInterval;
        }
        long token = Binder.clearCallingIdentity();
        try {
            AlarmManager am = (AlarmManager)context.getSystemService("alarm");
            PendingIntent pi = PendingIntent.getBroadcast((Context)context, (int)5571, (Intent)new Intent(ACTION_EXPIRED_PASSWORD_NOTIFICATION), (int)0x48000000);
            am.cancel(pi);
            if (alarmTime != 0L) {
                am.set(1, alarmTime, pi);
            }
            Object var15_9 = null;
        }
        catch (Throwable throwable) {
            Object var15_10 = null;
            Binder.restoreCallingIdentity((long)token);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)token);
    }

    private IPowerManager getIPowerManager() {
        if (this.mIPowerManager == null) {
            IBinder b = ServiceManager.getService((String)"power");
            this.mIPowerManager = IPowerManager.Stub.asInterface((IBinder)b);
        }
        return this.mIPowerManager;
    }

    ActiveAdmin getActiveAdminUncheckedLocked(ComponentName who) {
        ActiveAdmin admin = this.mAdminMap.get(who);
        if (admin != null && who.getPackageName().equals(admin.info.getActivityInfo().packageName) && who.getClassName().equals(admin.info.getActivityInfo().name)) {
            return admin;
        }
        return null;
    }

    ActiveAdmin getActiveAdminForCallerLocked(ComponentName who, int reqPolicy) throws SecurityException {
        int callingUid = Binder.getCallingUid();
        if (who != null) {
            ActiveAdmin admin = this.mAdminMap.get(who);
            if (admin == null) {
                throw new SecurityException("No active admin " + who);
            }
            if (admin.getUid() != callingUid) {
                throw new SecurityException("Admin " + who + " is not owned by uid " + Binder.getCallingUid());
            }
            if (!admin.info.usesPolicy(reqPolicy)) {
                throw new SecurityException("Admin " + admin.info.getComponent() + " did not specify uses-policy for: " + admin.info.getTagForPolicy(reqPolicy));
            }
            return admin;
        }
        int N = this.mAdminList.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin admin = this.mAdminList.get(i);
            if (admin.getUid() != callingUid || !admin.info.usesPolicy(reqPolicy)) continue;
            return admin;
        }
        throw new SecurityException("No active admin owned by uid " + Binder.getCallingUid() + " for policy #" + reqPolicy);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action) {
        this.sendAdminCommandLocked(admin, action, null);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action, BroadcastReceiver result) {
        Intent intent = new Intent(action);
        intent.setComponent(admin.info.getComponent());
        if (action.equals("android.app.action.ACTION_PASSWORD_EXPIRING")) {
            intent.putExtra("expiration", admin.passwordExpirationDate);
        }
        if (result != null) {
            this.mContext.sendOrderedBroadcast(intent, null, result, this.mHandler, -1, null, null);
        } else {
            this.mContext.sendBroadcast(intent);
        }
    }

    void sendAdminCommandLocked(String action, int reqPolicy) {
        int N = this.mAdminList.size();
        if (N > 0) {
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (!admin.info.usesPolicy(reqPolicy)) continue;
                this.sendAdminCommandLocked(admin, action);
            }
        }
    }

    void removeActiveAdminLocked(final ComponentName adminReceiver) {
        final ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver);
        if (admin != null) {
            this.sendAdminCommandLocked(admin, "android.app.action.DEVICE_ADMIN_DISABLED", new BroadcastReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onReceive(Context context, Intent intent) {
                    2 var3_3 = this;
                    synchronized (var3_3) {
                        boolean doProxyCleanup = admin.info.usesPolicy(5);
                        DevicePolicyManagerService.this.mAdminList.remove(admin);
                        DevicePolicyManagerService.this.mAdminMap.remove(adminReceiver);
                        DevicePolicyManagerService.this.validatePasswordOwnerLocked();
                        DevicePolicyManagerService.this.syncDeviceCapabilitiesLocked();
                        if (doProxyCleanup) {
                            DevicePolicyManagerService.this.resetGlobalProxy();
                        }
                        DevicePolicyManagerService.this.saveSettingsLocked();
                    }
                }
            });
        }
    }

    public DeviceAdminInfo findAdmin(ComponentName adminName) {
        Intent resolveIntent = new Intent();
        resolveIntent.setComponent(adminName);
        List infos = this.mContext.getPackageManager().queryBroadcastReceivers(resolveIntent, 128);
        if (infos == null || infos.size() <= 0) {
            throw new IllegalArgumentException("Unknown admin: " + adminName);
        }
        try {
            return new DeviceAdminInfo(this.mContext, (ResolveInfo)infos.get(0));
        }
        catch (XmlPullParserException e) {
            Slog.w((String)TAG, (String)("Bad device admin requested: " + adminName), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)("Bad device admin requested: " + adminName), (Throwable)e);
            return null;
        }
    }

    private static JournaledFile makeJournaledFile() {
        String base = "/data/system/device_policies.xml";
        return new JournaledFile(new File("/data/system/device_policies.xml"), new File("/data/system/device_policies.xml.tmp"));
    }

    private void saveSettingsLocked() {
        JournaledFile journal = DevicePolicyManagerService.makeJournaledFile();
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(journal.chooseForWrite(), false);
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput((OutputStream)stream, "utf-8");
            out.startDocument(null, Boolean.valueOf(true));
            out.startTag(null, "policies");
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin ap = this.mAdminList.get(i);
                if (ap == null) continue;
                out.startTag(null, "admin");
                out.attribute(null, "name", ap.info.getComponent().flattenToString());
                ap.writeToXml((XmlSerializer)out);
                out.endTag(null, "admin");
            }
            if (this.mPasswordOwner >= 0) {
                out.startTag(null, "password-owner");
                out.attribute(null, "value", Integer.toString(this.mPasswordOwner));
                out.endTag(null, "password-owner");
            }
            if (this.mFailedPasswordAttempts != 0) {
                out.startTag(null, "failed-password-attempts");
                out.attribute(null, "value", Integer.toString(this.mFailedPasswordAttempts));
                out.endTag(null, "failed-password-attempts");
            }
            if (this.mActivePasswordQuality != 0 || this.mActivePasswordLength != 0 || this.mActivePasswordUpperCase != 0 || this.mActivePasswordLowerCase != 0 || this.mActivePasswordLetters != 0 || this.mActivePasswordNumeric != 0 || this.mActivePasswordSymbols != 0 || this.mActivePasswordNonLetter != 0) {
                out.startTag(null, "active-password");
                out.attribute(null, "quality", Integer.toString(this.mActivePasswordQuality));
                out.attribute(null, "length", Integer.toString(this.mActivePasswordLength));
                out.attribute(null, "uppercase", Integer.toString(this.mActivePasswordUpperCase));
                out.attribute(null, "lowercase", Integer.toString(this.mActivePasswordLowerCase));
                out.attribute(null, "letters", Integer.toString(this.mActivePasswordLetters));
                out.attribute(null, "numeric", Integer.toString(this.mActivePasswordNumeric));
                out.attribute(null, "symbols", Integer.toString(this.mActivePasswordSymbols));
                out.attribute(null, "nonletter", Integer.toString(this.mActivePasswordNonLetter));
                out.endTag(null, "active-password");
            }
            out.endTag(null, "policies");
            out.endDocument();
            stream.close();
            journal.commit();
            this.sendChangedNotification();
        }
        catch (IOException e) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            journal.rollback();
        }
    }

    private void sendChangedNotification() {
        Intent intent = new Intent("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        intent.setFlags(0x40000000);
        this.mContext.sendBroadcast(intent);
    }

    private void loadSettingsLocked() {
        JournaledFile journal = DevicePolicyManagerService.makeJournaledFile();
        FileInputStream stream = null;
        File file = journal.chooseForRead();
        try {
            int type;
            stream = new FileInputStream(file);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)stream, null);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String tag = parser.getName();
            if (!"policies".equals(tag)) {
                throw new XmlPullParserException("Settings do not start with policies tag: found " + tag);
            }
            type = parser.next();
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                tag = parser.getName();
                if ("admin".equals(tag)) {
                    String name = parser.getAttributeValue(null, "name");
                    try {
                        DeviceAdminInfo dai = this.findAdmin(ComponentName.unflattenFromString((String)name));
                        if (dai == null) continue;
                        ActiveAdmin ap = new ActiveAdmin(dai);
                        ap.readFromXml(parser);
                        this.mAdminMap.put(ap.info.getComponent(), ap);
                        this.mAdminList.add(ap);
                    }
                    catch (RuntimeException e) {
                        Slog.w((String)TAG, (String)("Failed loading admin " + name), (Throwable)e);
                    }
                    continue;
                }
                if ("failed-password-attempts".equals(tag)) {
                    this.mFailedPasswordAttempts = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    XmlUtils.skipCurrentTag((XmlPullParser)parser);
                    continue;
                }
                if ("password-owner".equals(tag)) {
                    this.mPasswordOwner = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    XmlUtils.skipCurrentTag((XmlPullParser)parser);
                    continue;
                }
                if ("active-password".equals(tag)) {
                    this.mActivePasswordQuality = Integer.parseInt(parser.getAttributeValue(null, "quality"));
                    this.mActivePasswordLength = Integer.parseInt(parser.getAttributeValue(null, "length"));
                    this.mActivePasswordUpperCase = Integer.parseInt(parser.getAttributeValue(null, "uppercase"));
                    this.mActivePasswordLowerCase = Integer.parseInt(parser.getAttributeValue(null, "lowercase"));
                    this.mActivePasswordLetters = Integer.parseInt(parser.getAttributeValue(null, "letters"));
                    this.mActivePasswordNumeric = Integer.parseInt(parser.getAttributeValue(null, "numeric"));
                    this.mActivePasswordSymbols = Integer.parseInt(parser.getAttributeValue(null, "symbols"));
                    this.mActivePasswordNonLetter = Integer.parseInt(parser.getAttributeValue(null, "nonletter"));
                    XmlUtils.skipCurrentTag((XmlPullParser)parser);
                    continue;
                }
                Slog.w((String)TAG, (String)("Unknown tag: " + tag));
                XmlUtils.skipCurrentTag((XmlPullParser)parser);
            }
        }
        catch (NullPointerException e) {
            Slog.w((String)TAG, (String)("failed parsing " + file + " " + e));
        }
        catch (NumberFormatException e) {
            Slog.w((String)TAG, (String)("failed parsing " + file + " " + e));
        }
        catch (XmlPullParserException e) {
            Slog.w((String)TAG, (String)("failed parsing " + file + " " + (Object)((Object)e)));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)("failed parsing " + file + " " + e));
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w((String)TAG, (String)("failed parsing " + file + " " + e));
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        LockPatternUtils utils = new LockPatternUtils(this.mContext);
        if (utils.getActivePasswordQuality() < this.mActivePasswordQuality) {
            Slog.w((String)TAG, (String)("Active password quality 0x" + Integer.toHexString(this.mActivePasswordQuality) + " does not match actual quality 0x" + Integer.toHexString(utils.getActivePasswordQuality())));
            this.mActivePasswordQuality = 0;
            this.mActivePasswordLength = 0;
            this.mActivePasswordUpperCase = 0;
            this.mActivePasswordLowerCase = 0;
            this.mActivePasswordLetters = 0;
            this.mActivePasswordNumeric = 0;
            this.mActivePasswordSymbols = 0;
            this.mActivePasswordNonLetter = 0;
        }
        this.validatePasswordOwnerLocked();
        this.syncDeviceCapabilitiesLocked();
        long timeMs = this.getMaximumTimeToLock(null);
        if (timeMs <= 0L) {
            timeMs = Integer.MAX_VALUE;
        }
        try {
            this.getIPowerManager().setMaximumScreenOffTimeount((int)timeMs);
        }
        catch (RemoteException e) {
            Slog.w((String)TAG, (String)"Failure talking with power manager", (Throwable)e);
        }
    }

    static void validateQualityConstant(int quality) {
        switch (quality) {
            case 0: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 327680: 
            case 393216: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid quality constant: 0x" + Integer.toHexString(quality));
    }

    void validatePasswordOwnerLocked() {
        if (this.mPasswordOwner >= 0) {
            boolean haveOwner = false;
            for (int i = this.mAdminList.size() - 1; i >= 0; --i) {
                if (this.mAdminList.get(i).getUid() != this.mPasswordOwner) continue;
                haveOwner = true;
                break;
            }
            if (!haveOwner) {
                Slog.w((String)TAG, (String)("Previous password owner " + this.mPasswordOwner + " no longer active; disabling"));
                this.mPasswordOwner = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncDeviceCapabilitiesLocked() {
        boolean systemState = SystemProperties.getBoolean((String)SYSTEM_PROP_DISABLE_CAMERA, (boolean)false);
        boolean cameraDisabled = this.getCameraDisabled(null);
        if (cameraDisabled != systemState) {
            long token = Binder.clearCallingIdentity();
            try {
                String value = cameraDisabled ? "1" : "0";
                Slog.v((String)TAG, (String)("Change in camera state [sys.secpolicy.camera.disabled] = " + value));
                SystemProperties.set((String)SYSTEM_PROP_DISABLE_CAMERA, (String)value);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                Binder.restoreCallingIdentity((long)token);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)token);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.loadSettingsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePasswordExpirationNotification() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long now = System.currentTimeMillis();
            int N = this.mAdminList.size();
            if (N <= 0) {
                return;
            }
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (!admin.info.usesPolicy(6) || admin.passwordExpirationTimeout <= 0L || admin.passwordExpirationDate <= 0L || now < admin.passwordExpirationDate - 432000000L) continue;
                this.sendAdminCommandLocked(admin, "android.app.action.ACTION_PASSWORD_EXPIRING");
            }
            this.setExpirationAlarmCheckLocked(this.mContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveAdmin(ComponentName adminReceiver, boolean refreshing) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DeviceAdminInfo info = this.findAdmin(adminReceiver);
        if (info == null) {
            throw new IllegalArgumentException("Bad admin: " + adminReceiver);
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                if (!refreshing && this.getActiveAdminUncheckedLocked(adminReceiver) != null) {
                    throw new IllegalArgumentException("Admin is already added");
                }
                ActiveAdmin newAdmin = new ActiveAdmin(info);
                this.mAdminMap.put(adminReceiver, newAdmin);
                int replaceIndex = -1;
                if (refreshing) {
                    int N = this.mAdminList.size();
                    for (int i = 0; i < N; ++i) {
                        ActiveAdmin oldAdmin = this.mAdminList.get(i);
                        if (!oldAdmin.info.getComponent().equals((Object)adminReceiver)) continue;
                        replaceIndex = i;
                        break;
                    }
                }
                if (replaceIndex == -1) {
                    this.mAdminList.add(newAdmin);
                } else {
                    this.mAdminList.set(replaceIndex, newAdmin);
                }
                this.saveSettingsLocked();
                this.sendAdminCommandLocked(newAdmin, "android.app.action.DEVICE_ADMIN_ENABLED");
                Object var13_11 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAdminActive(ComponentName adminReceiver) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getActiveAdminUncheckedLocked(adminReceiver) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGrantedPolicy(ComponentName adminReceiver, int policyId) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin administrator = this.getActiveAdminUncheckedLocked(adminReceiver);
            if (administrator == null) {
                throw new SecurityException("No active admin " + adminReceiver);
            }
            return administrator.info.usesPolicy(policyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ComponentName> getActiveAdmins() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int N = this.mAdminList.size();
            if (N <= 0) {
                return null;
            }
            ArrayList<ComponentName> res = new ArrayList<ComponentName>(N);
            for (int i = 0; i < N; ++i) {
                res.add(this.mAdminList.get((int)i).info.getComponent());
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean packageHasActiveAdmins(String packageName) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!this.mAdminList.get((int)i).info.getPackageName().equals(packageName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveAdmin(ComponentName adminReceiver) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver);
            if (admin == null) {
                return;
            }
            if (admin.getUid() != Binder.getCallingUid()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.removeActiveAdminLocked(adminReceiver);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordQuality(ComponentName who, int quality) {
        DevicePolicyManagerService.validateQualityConstant(quality);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.passwordQuality != quality) {
                ap.passwordQuality = quality;
                this.saveSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPasswordQuality(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int mode = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                int n = admin != null ? admin.passwordQuality : mode;
                return n;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (mode >= admin.passwordQuality) continue;
                mode = admin.passwordQuality;
            }
            return mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordMinimumLength(ComponentName who, int length) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLength != length) {
                ap.minimumPasswordLength = length;
                this.saveSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPasswordMinimumLength(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                int n = admin != null ? admin.minimumPasswordLength : length;
                return n;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (length >= admin.minimumPasswordLength) continue;
                length = admin.minimumPasswordLength;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordHistoryLength(ComponentName who, int length) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.passwordHistoryLength != length) {
                ap.passwordHistoryLength = length;
                this.saveSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPasswordHistoryLength(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                int n = admin != null ? admin.passwordHistoryLength : length;
                return n;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (length >= admin.passwordHistoryLength) continue;
                length = admin.passwordHistoryLength;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordExpirationTimeout(ComponentName who, long timeout) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long expiration;
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout must be >= 0 ms");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 6);
            ap.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
            ap.passwordExpirationTimeout = timeout;
            if (timeout > 0L) {
                Slog.w((String)TAG, (String)("setPasswordExpiration(): password will expire on " + DateFormat.getDateTimeInstance(2, 2).format(new Date(expiration))));
            }
            this.saveSettingsLocked();
            this.setExpirationAlarmCheckLocked(this.mContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPasswordExpirationTimeout(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                long l = admin != null ? admin.passwordExpirationTimeout : 0L;
                return l;
            }
            long timeout = 0L;
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (timeout != 0L && (admin.passwordExpirationTimeout == 0L || timeout <= admin.passwordExpirationTimeout)) continue;
                timeout = admin.passwordExpirationTimeout;
            }
            return timeout;
        }
    }

    private long getPasswordExpirationLocked(ComponentName who) {
        if (who != null) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
            return admin != null ? admin.passwordExpirationDate : 0L;
        }
        long timeout = 0L;
        int N = this.mAdminList.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin admin = this.mAdminList.get(i);
            if (timeout != 0L && (admin.passwordExpirationDate == 0L || timeout <= admin.passwordExpirationDate)) continue;
            timeout = admin.passwordExpirationDate;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPasswordExpiration(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getPasswordExpirationLocked(who);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordMinimumUpperCase(ComponentName who, int length) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordUpperCase != length) {
                ap.minimumPasswordUpperCase = length;
                this.saveSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPasswordMinimumUpperCase(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                int n = admin != null ? admin.minimumPasswordUpperCase : length;
                return n;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (length >= admin.minimumPasswordUpperCase) continue;
                length = admin.minimumPasswordUpperCase;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordMinimumLowerCase(ComponentName who, int length) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLowerCase != length) {
                ap.minimumPasswordLowerCase = length;
                this.saveSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPasswordMinimumLowerCase(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                int n = admin != null ? admin.minimumPasswordLowerCase : length;
                return n;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (length >= admin.minimumPasswordLowerCase) continue;
                length = admin.minimumPasswordLowerCase;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordMinimumLetters(ComponentName who, int length) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLetters != length) {
                ap.minimumPasswordLetters = length;
                this.saveSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPasswordMinimumLetters(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                int n = admin != null ? admin.minimumPasswordLetters : length;
                return n;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (length >= admin.minimumPasswordLetters) continue;
                length = admin.minimumPasswordLetters;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordMinimumNumeric(ComponentName who, int length) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordNumeric != length) {
                ap.minimumPasswordNumeric = length;
                this.saveSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPasswordMinimumNumeric(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                int n = admin != null ? admin.minimumPasswordNumeric : length;
                return n;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (length >= admin.minimumPasswordNumeric) continue;
                length = admin.minimumPasswordNumeric;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordMinimumSymbols(ComponentName who, int length) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordSymbols != length) {
                ap.minimumPasswordSymbols = length;
                this.saveSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPasswordMinimumSymbols(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                int n = admin != null ? admin.minimumPasswordSymbols : length;
                return n;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (length >= admin.minimumPasswordSymbols) continue;
                length = admin.minimumPasswordSymbols;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordMinimumNonLetter(ComponentName who, int length) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordNonLetter != length) {
                ap.minimumPasswordNonLetter = length;
                this.saveSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPasswordMinimumNonLetter(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                int n = admin != null ? admin.minimumPasswordNonLetter : length;
                return n;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (length >= admin.minimumPasswordNonLetter) continue;
                length = admin.minimumPasswordNonLetter;
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActivePasswordSufficient() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 0);
            if (this.mActivePasswordQuality < this.getPasswordQuality(null) || this.mActivePasswordLength < this.getPasswordMinimumLength(null)) {
                return false;
            }
            if (this.mActivePasswordQuality != 393216) {
                return true;
            }
            return this.mActivePasswordUpperCase >= this.getPasswordMinimumUpperCase(null) && this.mActivePasswordLowerCase >= this.getPasswordMinimumLowerCase(null) && this.mActivePasswordLetters >= this.getPasswordMinimumLetters(null) && this.mActivePasswordNumeric >= this.getPasswordMinimumNumeric(null) && this.mActivePasswordSymbols >= this.getPasswordMinimumSymbols(null) && this.mActivePasswordNonLetter >= this.getPasswordMinimumNonLetter(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentFailedPasswordAttempts() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 1);
            return this.mFailedPasswordAttempts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumFailedPasswordsForWipe(ComponentName who, int num) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, 4);
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 1);
            if (ap.maximumFailedPasswordsForWipe != num) {
                ap.maximumFailedPasswordsForWipe = num;
                this.saveSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumFailedPasswordsForWipe(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int count = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                int n = admin != null ? admin.maximumFailedPasswordsForWipe : count;
                return n;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (count == 0) {
                    count = admin.maximumFailedPasswordsForWipe;
                    continue;
                }
                if (admin.maximumFailedPasswordsForWipe == 0 || count <= admin.maximumFailedPasswordsForWipe) continue;
                count = admin.maximumFailedPasswordsForWipe;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetPassword(String password, int flags) {
        int quality;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 2);
            quality = this.getPasswordQuality(null);
            if (quality != 0) {
                int realQuality = LockPatternUtils.computePasswordQuality((String)password);
                if (realQuality < quality && quality != 393216) {
                    Slog.w((String)TAG, (String)("resetPassword: password quality 0x" + Integer.toHexString(quality) + " does not meet required quality 0x" + Integer.toHexString(quality)));
                    return false;
                }
                quality = Math.max(realQuality, quality);
            }
            int length = this.getPasswordMinimumLength(null);
            if (password.length() < length) {
                Slog.w((String)TAG, (String)("resetPassword: password length " + password.length() + " does not meet required length " + length));
                return false;
            }
            if (quality == 393216) {
                int letters = 0;
                int uppercase = 0;
                int lowercase = 0;
                int numbers = 0;
                int symbols = 0;
                int nonletter = 0;
                for (int i = 0; i < password.length(); ++i) {
                    char c = password.charAt(i);
                    if (c >= 'A' && c <= 'Z') {
                        ++letters;
                        ++uppercase;
                        continue;
                    }
                    if (c >= 'a' && c <= 'z') {
                        ++letters;
                        ++lowercase;
                        continue;
                    }
                    if (c >= '0' && c <= '9') {
                        ++numbers;
                        ++nonletter;
                        continue;
                    }
                    ++symbols;
                    ++nonletter;
                }
                int neededLetters = this.getPasswordMinimumLetters(null);
                if (letters < neededLetters) {
                    Slog.w((String)TAG, (String)("resetPassword: number of letters " + letters + " does not meet required number of letters " + neededLetters));
                    return false;
                }
                int neededNumbers = this.getPasswordMinimumNumeric(null);
                if (numbers < neededNumbers) {
                    Slog.w((String)TAG, (String)("resetPassword: number of numerical digits " + numbers + " does not meet required number of numerical digits " + neededNumbers));
                    return false;
                }
                int neededLowerCase = this.getPasswordMinimumLowerCase(null);
                if (lowercase < neededLowerCase) {
                    Slog.w((String)TAG, (String)("resetPassword: number of lowercase letters " + lowercase + " does not meet required number of lowercase letters " + neededLowerCase));
                    return false;
                }
                int neededUpperCase = this.getPasswordMinimumUpperCase(null);
                if (uppercase < neededUpperCase) {
                    Slog.w((String)TAG, (String)("resetPassword: number of uppercase letters " + uppercase + " does not meet required number of uppercase letters " + neededUpperCase));
                    return false;
                }
                int neededSymbols = this.getPasswordMinimumSymbols(null);
                if (symbols < neededSymbols) {
                    Slog.w((String)TAG, (String)("resetPassword: number of special symbols " + symbols + " does not meet required number of special symbols " + neededSymbols));
                    return false;
                }
                int neededNonLetter = this.getPasswordMinimumNonLetter(null);
                if (nonletter < neededNonLetter) {
                    Slog.w((String)TAG, (String)("resetPassword: number of non-letter characters " + nonletter + " does not meet required number of non-letter characters " + neededNonLetter));
                    return false;
                }
            }
        }
        int callingUid = Binder.getCallingUid();
        if (this.mPasswordOwner >= 0 && this.mPasswordOwner != callingUid) {
            Slog.w((String)TAG, (String)"resetPassword: already set by another uid and not entered by user");
            return false;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            LockPatternUtils utils = new LockPatternUtils(this.mContext);
            utils.saveLockPassword(password, quality);
            DevicePolicyManagerService devicePolicyManagerService2 = this;
            synchronized (devicePolicyManagerService2) {
                int newOwner;
                int n = newOwner = (flags & 1) != 0 ? callingUid : -1;
                if (this.mPasswordOwner != newOwner) {
                    this.mPasswordOwner = newOwner;
                    this.saveSettingsLocked();
                }
            }
            Object var21_24 = null;
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)ident);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumTimeToLock(ComponentName who, long timeMs) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 3);
            if (ap.maximumTimeToUnlock != timeMs) {
                ap.maximumTimeToUnlock = timeMs;
                long ident = Binder.clearCallingIdentity();
                try {
                    this.saveSettingsLocked();
                    timeMs = this.getMaximumTimeToLock(null);
                    if (timeMs <= 0L) {
                        timeMs = Integer.MAX_VALUE;
                    }
                    try {
                        this.getIPowerManager().setMaximumScreenOffTimeount((int)timeMs);
                    }
                    catch (RemoteException e) {
                        Slog.w((String)TAG, (String)"Failure talking with power manager", (Throwable)e);
                    }
                    Object var10_7 = null;
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    Binder.restoreCallingIdentity((long)ident);
                    throw throwable;
                }
                Binder.restoreCallingIdentity((long)ident);
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaximumTimeToLock(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long time = 0L;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                long l = admin != null ? admin.maximumTimeToUnlock : time;
                return l;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (time == 0L) {
                    time = admin.maximumTimeToUnlock;
                    continue;
                }
                if (admin.maximumTimeToUnlock == 0L || time <= admin.maximumTimeToUnlock) continue;
                time = admin.maximumTimeToUnlock;
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lockNow() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            block6: {
                this.getActiveAdminForCallerLocked(null, 3);
                long ident = Binder.clearCallingIdentity();
                try {
                    try {
                        this.mIPowerManager.goToSleepWithReason(SystemClock.uptimeMillis(), 1);
                    }
                    catch (RemoteException e) {
                        Object var6_4 = null;
                        Binder.restoreCallingIdentity((long)ident);
                        break block6;
                    }
                    Object var6_3 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    Binder.restoreCallingIdentity((long)ident);
                    throw throwable;
                }
                Binder.restoreCallingIdentity((long)ident);
            }
            return;
        }
    }

    private boolean isExtStorageEncrypted() {
        String state = SystemProperties.get((String)"vold.decrypt");
        return !"".equals(state);
    }

    void wipeDataLocked(int flags) {
        boolean wipeExtRequested;
        boolean forceExtWipe = !Environment.isExternalStorageRemovable() && this.isExtStorageEncrypted();
        boolean bl = wipeExtRequested = (flags & 1) != 0;
        if ((forceExtWipe || wipeExtRequested) && !Environment.isExternalStorageEmulated()) {
            Intent intent = new Intent("com.android.internal.os.storage.FORMAT_AND_FACTORY_RESET");
            intent.setComponent(ExternalStorageFormatter.COMPONENT_NAME);
            this.mWakeLock.acquire(10000L);
            this.mContext.startService(intent);
        } else {
            try {
                RecoverySystem.rebootWipeUserData((Context)this.mContext);
            }
            catch (IOException e) {
                Slog.w((String)TAG, (String)"Failed requesting data wipe", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wipeData(int flags) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 4);
            long ident = Binder.clearCallingIdentity();
            try {
                this.wipeDataLocked(flags);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRemoveWarning(ComponentName comp, final RemoteCallback result) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(comp);
            if (admin == null) {
                try {
                    result.sendResult(null);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return;
            }
            Intent intent = new Intent("android.app.action.DEVICE_ADMIN_DISABLE_REQUESTED");
            intent.setComponent(admin.info.getComponent());
            this.mContext.sendOrderedBroadcast(intent, null, new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    try {
                        result.sendResult(this.getResultExtras(false));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }, null, -1, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivePasswordState(int quality, int length, int letters, int uppercase, int lowercase, int numbers, int symbols, int nonletter) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService.validateQualityConstant(quality);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mActivePasswordQuality != quality || this.mActivePasswordLength != length || this.mFailedPasswordAttempts != 0 || this.mActivePasswordLetters != letters || this.mActivePasswordUpperCase != uppercase || this.mActivePasswordLowerCase != lowercase || this.mActivePasswordNumeric != numbers || this.mActivePasswordSymbols != symbols || this.mActivePasswordNonLetter != nonletter) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mActivePasswordQuality = quality;
                    this.mActivePasswordLength = length;
                    this.mActivePasswordLetters = letters;
                    this.mActivePasswordLowerCase = lowercase;
                    this.mActivePasswordUpperCase = uppercase;
                    this.mActivePasswordNumeric = numbers;
                    this.mActivePasswordSymbols = symbols;
                    this.mActivePasswordNonLetter = nonletter;
                    this.mFailedPasswordAttempts = 0;
                    this.saveSettingsLocked();
                    this.updatePasswordExpirationsLocked();
                    this.setExpirationAlarmCheckLocked(this.mContext);
                    this.sendAdminCommandLocked("android.app.action.ACTION_PASSWORD_CHANGED", 0);
                    Object var13_11 = null;
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    Binder.restoreCallingIdentity((long)ident);
                    throw throwable;
                }
                Binder.restoreCallingIdentity((long)ident);
                {
                }
            }
        }
    }

    private void updatePasswordExpirationsLocked() {
        int N = this.mAdminList.size();
        if (N > 0) {
            for (int i = 0; i < N; ++i) {
                long expiration;
                ActiveAdmin admin = this.mAdminList.get(i);
                if (!admin.info.usesPolicy(6)) continue;
                long timeout = admin.passwordExpirationTimeout;
                admin.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
            }
            this.saveSettingsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportFailedPasswordAttempt() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                ++this.mFailedPasswordAttempts;
                this.saveSettingsLocked();
                int max = this.getMaximumFailedPasswordsForWipe(null);
                if (max > 0 && this.mFailedPasswordAttempts >= max) {
                    this.wipeDataLocked(0);
                }
                this.sendAdminCommandLocked("android.app.action.ACTION_PASSWORD_FAILED", 1);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSuccessfulPasswordAttempt() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mFailedPasswordAttempts != 0 || this.mPasswordOwner >= 0) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mFailedPasswordAttempts = 0;
                    this.mPasswordOwner = -1;
                    this.saveSettingsLocked();
                    this.sendAdminCommandLocked("android.app.action.ACTION_PASSWORD_SUCCEEDED", 1);
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    Binder.restoreCallingIdentity((long)ident);
                    throw throwable;
                }
                Binder.restoreCallingIdentity((long)ident);
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentName setGlobalProxy(ComponentName who, String proxySpec, String exclusionList) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, 5);
            Set<ComponentName> compSet = this.mAdminMap.keySet();
            for (ComponentName component : compSet) {
                ActiveAdmin ap = this.mAdminMap.get(component);
                if (!ap.specifiesGlobalProxy || component.equals((Object)who)) continue;
                return component;
            }
            if (proxySpec == null) {
                admin.specifiesGlobalProxy = false;
                admin.globalProxySpec = null;
                admin.globalProxyExclusionList = null;
            } else {
                admin.specifiesGlobalProxy = true;
                admin.globalProxySpec = proxySpec;
                admin.globalProxyExclusionList = exclusionList;
            }
            long origId = Binder.clearCallingIdentity();
            this.resetGlobalProxy();
            Binder.restoreCallingIdentity((long)origId);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentName getGlobalProxyAdmin() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin ap = this.mAdminList.get(i);
                if (!ap.specifiesGlobalProxy) continue;
                return ap.info.getComponent();
            }
        }
        return null;
    }

    private void resetGlobalProxy() {
        int N = this.mAdminList.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin ap = this.mAdminList.get(i);
            if (!ap.specifiesGlobalProxy) continue;
            this.saveGlobalProxy(ap.globalProxySpec, ap.globalProxyExclusionList);
            return;
        }
        this.saveGlobalProxy(null, null);
    }

    private void saveGlobalProxy(String proxySpec, String exclusionList) {
        if (exclusionList == null) {
            exclusionList = "";
        }
        if (proxySpec == null) {
            proxySpec = "";
        }
        proxySpec = proxySpec.trim();
        String[] data = proxySpec.split(":");
        int proxyPort = 8080;
        if (data.length > 1) {
            try {
                proxyPort = Integer.parseInt(data[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        exclusionList = exclusionList.trim();
        ContentResolver res = this.mContext.getContentResolver();
        Settings.Secure.putString((ContentResolver)res, (String)"global_http_proxy_host", (String)data[0]);
        Settings.Secure.putInt((ContentResolver)res, (String)"global_http_proxy_port", (int)proxyPort);
        Settings.Secure.putString((ContentResolver)res, (String)"global_http_proxy_exclusion_list", (String)exclusionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setStorageEncryption(ComponentName who, boolean encrypt) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 7);
            if (!this.isEncryptionSupported()) {
                return 0;
            }
            if (ap.encryptionRequested != encrypt) {
                ap.encryptionRequested = encrypt;
                this.saveSettingsLocked();
            }
            boolean newRequested = false;
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                newRequested |= this.mAdminList.get((int)i).encryptionRequested;
            }
            this.setEncryptionRequested(newRequested);
            return newRequested ? 3 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getStorageEncryption(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin ap = this.getActiveAdminUncheckedLocked(who);
                boolean bl = ap != null ? ap.encryptionRequested : false;
                return bl;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!this.mAdminList.get((int)i).encryptionRequested) continue;
                return true;
            }
            return false;
        }
    }

    public int getStorageEncryptionStatus() {
        return this.getEncryptionStatus();
    }

    private boolean isEncryptionSupported() {
        return this.getEncryptionStatus() != 0;
    }

    private int getEncryptionStatus() {
        String status = SystemProperties.get((String)"ro.crypto.state", (String)"unsupported");
        if ("encrypted".equalsIgnoreCase(status)) {
            return 3;
        }
        if ("unencrypted".equalsIgnoreCase(status)) {
            return 1;
        }
        return 0;
    }

    private void setEncryptionRequested(boolean encrypt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraDisabled(ComponentName who, boolean disabled) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 8);
            if (ap.disableCamera != disabled) {
                ap.disableCamera = disabled;
                this.saveSettingsLocked();
            }
            this.syncDeviceCapabilitiesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCameraDisabled(ComponentName who) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who);
                boolean bl = admin != null ? admin.disableCamera : false;
                return bl;
            }
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = this.mAdminList.get(i);
                if (!admin.disableCamera) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump DevicePolicyManagerService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        PrintWriterPrinter p = new PrintWriterPrinter(pw);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            p.println("Current Device Policy Manager state:");
            p.println("  Enabled Device Admins:");
            int N = this.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin ap = this.mAdminList.get(i);
                if (ap == null) continue;
                pw.print("  ");
                pw.print(ap.info.getComponent().flattenToShortString());
                pw.println(":");
                ap.dump("    ", pw);
            }
            pw.println(" ");
            pw.print("  mActivePasswordQuality=0x");
            pw.println(Integer.toHexString(this.mActivePasswordQuality));
            pw.print("  mActivePasswordLength=");
            pw.println(this.mActivePasswordLength);
            pw.print("  mActivePasswordUpperCase=");
            pw.println(this.mActivePasswordUpperCase);
            pw.print("  mActivePasswordLowerCase=");
            pw.println(this.mActivePasswordLowerCase);
            pw.print("  mActivePasswordLetters=");
            pw.println(this.mActivePasswordLetters);
            pw.print("  mActivePasswordNumeric=");
            pw.println(this.mActivePasswordNumeric);
            pw.print("  mActivePasswordSymbols=");
            pw.println(this.mActivePasswordSymbols);
            pw.print("  mActivePasswordNonLetter=");
            pw.println(this.mActivePasswordNonLetter);
            pw.print("  mFailedPasswordAttempts=");
            pw.println(this.mFailedPasswordAttempts);
            pw.print("  mPasswordOwner=");
            pw.println(this.mPasswordOwner);
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSomePackagesChanged() {
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                boolean removed = false;
                for (int i = DevicePolicyManagerService.this.mAdminList.size() - 1; i >= 0; --i) {
                    ActiveAdmin aa = DevicePolicyManagerService.this.mAdminList.get(i);
                    int change = this.isPackageDisappearing(aa.info.getPackageName());
                    if (change == 3 || change == 2) {
                        Slog.w((String)DevicePolicyManagerService.TAG, (String)("Admin unexpectedly uninstalled: " + aa.info.getComponent()));
                        removed = true;
                        DevicePolicyManagerService.this.mAdminList.remove(i);
                        continue;
                    }
                    if (!this.isPackageModified(aa.info.getPackageName())) continue;
                    try {
                        DevicePolicyManagerService.this.mContext.getPackageManager().getReceiverInfo(aa.info.getComponent(), 0);
                        continue;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.w((String)DevicePolicyManagerService.TAG, (String)("Admin package change removed component: " + aa.info.getComponent()));
                        removed = true;
                        DevicePolicyManagerService.this.mAdminList.remove(i);
                    }
                }
                if (removed) {
                    DevicePolicyManagerService.this.validatePasswordOwnerLocked();
                    DevicePolicyManagerService.this.syncDeviceCapabilitiesLocked();
                    DevicePolicyManagerService.this.saveSettingsLocked();
                }
            }
        }
    }

    static class ActiveAdmin {
        final DeviceAdminInfo info;
        int passwordQuality = 0;
        static final int DEF_MINIMUM_PASSWORD_LENGTH = 0;
        int minimumPasswordLength = 0;
        static final int DEF_PASSWORD_HISTORY_LENGTH = 0;
        int passwordHistoryLength = 0;
        static final int DEF_MINIMUM_PASSWORD_UPPER_CASE = 0;
        int minimumPasswordUpperCase = 0;
        static final int DEF_MINIMUM_PASSWORD_LOWER_CASE = 0;
        int minimumPasswordLowerCase = 0;
        static final int DEF_MINIMUM_PASSWORD_LETTERS = 1;
        int minimumPasswordLetters = 1;
        static final int DEF_MINIMUM_PASSWORD_NUMERIC = 1;
        int minimumPasswordNumeric = 1;
        static final int DEF_MINIMUM_PASSWORD_SYMBOLS = 1;
        int minimumPasswordSymbols = 1;
        static final int DEF_MINIMUM_PASSWORD_NON_LETTER = 0;
        int minimumPasswordNonLetter = 0;
        static final long DEF_MAXIMUM_TIME_TO_UNLOCK = 0L;
        long maximumTimeToUnlock = 0L;
        static final int DEF_MAXIMUM_FAILED_PASSWORDS_FOR_WIPE = 0;
        int maximumFailedPasswordsForWipe = 0;
        static final long DEF_PASSWORD_EXPIRATION_TIMEOUT = 0L;
        long passwordExpirationTimeout = 0L;
        static final long DEF_PASSWORD_EXPIRATION_DATE = 0L;
        long passwordExpirationDate = 0L;
        boolean encryptionRequested = false;
        boolean disableCamera = false;
        boolean specifiesGlobalProxy = false;
        String globalProxySpec = null;
        String globalProxyExclusionList = null;

        ActiveAdmin(DeviceAdminInfo _info) {
            this.info = _info;
        }

        int getUid() {
            return this.info.getActivityInfo().applicationInfo.uid;
        }

        void writeToXml(XmlSerializer out) throws IllegalArgumentException, IllegalStateException, IOException {
            out.startTag(null, "policies");
            this.info.writePoliciesToXml(out);
            out.endTag(null, "policies");
            if (this.passwordQuality != 0) {
                out.startTag(null, "password-quality");
                out.attribute(null, "value", Integer.toString(this.passwordQuality));
                out.endTag(null, "password-quality");
                if (this.minimumPasswordLength != 0) {
                    out.startTag(null, "min-password-length");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordLength));
                    out.endTag(null, "min-password-length");
                }
                if (this.passwordHistoryLength != 0) {
                    out.startTag(null, "password-history-length");
                    out.attribute(null, "value", Integer.toString(this.passwordHistoryLength));
                    out.endTag(null, "password-history-length");
                }
                if (this.minimumPasswordUpperCase != 0) {
                    out.startTag(null, "min-password-uppercase");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordUpperCase));
                    out.endTag(null, "min-password-uppercase");
                }
                if (this.minimumPasswordLowerCase != 0) {
                    out.startTag(null, "min-password-lowercase");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordLowerCase));
                    out.endTag(null, "min-password-lowercase");
                }
                if (this.minimumPasswordLetters != 1) {
                    out.startTag(null, "min-password-letters");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordLetters));
                    out.endTag(null, "min-password-letters");
                }
                if (this.minimumPasswordNumeric != 1) {
                    out.startTag(null, "min-password-numeric");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordNumeric));
                    out.endTag(null, "min-password-numeric");
                }
                if (this.minimumPasswordSymbols != 1) {
                    out.startTag(null, "min-password-symbols");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordSymbols));
                    out.endTag(null, "min-password-symbols");
                }
                if (this.minimumPasswordNonLetter > 0) {
                    out.startTag(null, "min-password-nonletter");
                    out.attribute(null, "value", Integer.toString(this.minimumPasswordNonLetter));
                    out.endTag(null, "min-password-nonletter");
                }
            }
            if (this.maximumTimeToUnlock != 0L) {
                out.startTag(null, "max-time-to-unlock");
                out.attribute(null, "value", Long.toString(this.maximumTimeToUnlock));
                out.endTag(null, "max-time-to-unlock");
            }
            if (this.maximumFailedPasswordsForWipe != 0) {
                out.startTag(null, "max-failed-password-wipe");
                out.attribute(null, "value", Integer.toString(this.maximumFailedPasswordsForWipe));
                out.endTag(null, "max-failed-password-wipe");
            }
            if (this.specifiesGlobalProxy) {
                out.startTag(null, "specifies-global-proxy");
                out.attribute(null, "value", Boolean.toString(this.specifiesGlobalProxy));
                out.endTag(null, "specifies_global_proxy");
                if (this.globalProxySpec != null) {
                    out.startTag(null, "global-proxy-spec");
                    out.attribute(null, "value", this.globalProxySpec);
                    out.endTag(null, "global-proxy-spec");
                }
                if (this.globalProxyExclusionList != null) {
                    out.startTag(null, "global-proxy-exclusion-list");
                    out.attribute(null, "value", this.globalProxyExclusionList);
                    out.endTag(null, "global-proxy-exclusion-list");
                }
            }
            if (this.passwordExpirationTimeout != 0L) {
                out.startTag(null, "password-expiration-timeout");
                out.attribute(null, "value", Long.toString(this.passwordExpirationTimeout));
                out.endTag(null, "password-expiration-timeout");
            }
            if (this.passwordExpirationDate != 0L) {
                out.startTag(null, "password-expiration-date");
                out.attribute(null, "value", Long.toString(this.passwordExpirationDate));
                out.endTag(null, "password-expiration-date");
            }
            if (this.encryptionRequested) {
                out.startTag(null, "encryption-requested");
                out.attribute(null, "value", Boolean.toString(this.encryptionRequested));
                out.endTag(null, "encryption-requested");
            }
            if (this.disableCamera) {
                out.startTag(null, "disable-camera");
                out.attribute(null, "value", Boolean.toString(this.disableCamera));
                out.endTag(null, "disable-camera");
            }
        }

        void readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tag = parser.getName();
                if ("policies".equals(tag)) {
                    this.info.readPoliciesFromXml(parser);
                } else if ("password-quality".equals(tag)) {
                    this.passwordQuality = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-length".equals(tag)) {
                    this.minimumPasswordLength = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("password-history-length".equals(tag)) {
                    this.passwordHistoryLength = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-uppercase".equals(tag)) {
                    this.minimumPasswordUpperCase = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-lowercase".equals(tag)) {
                    this.minimumPasswordLowerCase = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-letters".equals(tag)) {
                    this.minimumPasswordLetters = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-numeric".equals(tag)) {
                    this.minimumPasswordNumeric = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-symbols".equals(tag)) {
                    this.minimumPasswordSymbols = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("min-password-nonletter".equals(tag)) {
                    this.minimumPasswordNonLetter = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("max-time-to-unlock".equals(tag)) {
                    this.maximumTimeToUnlock = Long.parseLong(parser.getAttributeValue(null, "value"));
                } else if ("max-failed-password-wipe".equals(tag)) {
                    this.maximumFailedPasswordsForWipe = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if ("specifies-global-proxy".equals(tag)) {
                    this.specifiesGlobalProxy = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                } else if ("global-proxy-spec".equals(tag)) {
                    this.globalProxySpec = parser.getAttributeValue(null, "value");
                } else if ("global-proxy-exclusion-list".equals(tag)) {
                    this.globalProxyExclusionList = parser.getAttributeValue(null, "value");
                } else if ("password-expiration-timeout".equals(tag)) {
                    this.passwordExpirationTimeout = Long.parseLong(parser.getAttributeValue(null, "value"));
                } else if ("password-expiration-date".equals(tag)) {
                    this.passwordExpirationDate = Long.parseLong(parser.getAttributeValue(null, "value"));
                } else if ("encryption-requested".equals(tag)) {
                    this.encryptionRequested = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                } else if ("disable-camera".equals(tag)) {
                    this.disableCamera = Boolean.parseBoolean(parser.getAttributeValue(null, "value"));
                } else {
                    Slog.w((String)DevicePolicyManagerService.TAG, (String)("Unknown admin tag: " + tag));
                }
                XmlUtils.skipCurrentTag((XmlPullParser)parser);
            }
        }

        void dump(String prefix, PrintWriter pw) {
            pw.print(prefix);
            pw.print("uid=");
            pw.println(this.getUid());
            pw.print(prefix);
            pw.println("policies:");
            ArrayList pols = this.info.getUsedPolicies();
            if (pols != null) {
                for (int i = 0; i < pols.size(); ++i) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(((DeviceAdminInfo.PolicyInfo)pols.get((int)i)).tag);
                }
            }
            pw.print(prefix);
            pw.print("passwordQuality=0x");
            pw.println(Integer.toHexString(this.passwordQuality));
            pw.print(prefix);
            pw.print("minimumPasswordLength=");
            pw.println(this.minimumPasswordLength);
            pw.print(prefix);
            pw.print("passwordHistoryLength=");
            pw.println(this.passwordHistoryLength);
            pw.print(prefix);
            pw.print("minimumPasswordUpperCase=");
            pw.println(this.minimumPasswordUpperCase);
            pw.print(prefix);
            pw.print("minimumPasswordLowerCase=");
            pw.println(this.minimumPasswordLowerCase);
            pw.print(prefix);
            pw.print("minimumPasswordLetters=");
            pw.println(this.minimumPasswordLetters);
            pw.print(prefix);
            pw.print("minimumPasswordNumeric=");
            pw.println(this.minimumPasswordNumeric);
            pw.print(prefix);
            pw.print("minimumPasswordSymbols=");
            pw.println(this.minimumPasswordSymbols);
            pw.print(prefix);
            pw.print("minimumPasswordNonLetter=");
            pw.println(this.minimumPasswordNonLetter);
            pw.print(prefix);
            pw.print("maximumTimeToUnlock=");
            pw.println(this.maximumTimeToUnlock);
            pw.print(prefix);
            pw.print("maximumFailedPasswordsForWipe=");
            pw.println(this.maximumFailedPasswordsForWipe);
            pw.print(prefix);
            pw.print("specifiesGlobalProxy=");
            pw.println(this.specifiesGlobalProxy);
            pw.print(prefix);
            pw.print("passwordExpirationTimeout=");
            pw.println(this.passwordExpirationTimeout);
            pw.print(prefix);
            pw.print("passwordExpirationDate=");
            pw.println(this.passwordExpirationDate);
            if (this.globalProxySpec != null) {
                pw.print(prefix);
                pw.print("globalProxySpec=");
                pw.println(this.globalProxySpec);
            }
            if (this.globalProxyExclusionList != null) {
                pw.print(prefix);
                pw.print("globalProxyEclusionList=");
                pw.println(this.globalProxyExclusionList);
            }
            pw.print(prefix);
            pw.print("encryptionRequested=");
            pw.println(this.encryptionRequested);
            pw.print(prefix);
            pw.print("disableCamera=");
            pw.println(this.disableCamera);
        }
    }
}

