/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.EventLog;
import android.util.Slog;

public class DeviceStorageMonitorService
extends Binder {
    private static final String TAG = "DeviceStorageMonitorService";
    private static final boolean DEBUG = false;
    private static final boolean localLOGV = false;
    private static final int DEVICE_MEMORY_WHAT = 1;
    private static final int MONITOR_INTERVAL = 1;
    private static final int LOW_MEMORY_NOTIFICATION_ID = 1;
    private static final int DEFAULT_THRESHOLD_PERCENTAGE = 10;
    private static final int DEFAULT_THRESHOLD_MAX_BYTES = 524288000;
    private static final int DEFAULT_FREE_STORAGE_LOG_INTERVAL_IN_MINUTES = 720;
    private static final long DEFAULT_DISK_FREE_CHANGE_REPORTING_THRESHOLD = 0x200000L;
    private static final long DEFAULT_CHECK_INTERVAL = 60000L;
    private static final int DEFAULT_FULL_THRESHOLD_BYTES = 0x100000;
    private long mFreeMem;
    private long mLastReportedFreeMem;
    private long mLastReportedFreeMemTime = 0L;
    private boolean mLowMemFlag = false;
    private boolean mMemFullFlag = false;
    private Context mContext;
    private ContentResolver mContentResolver;
    private long mTotalMemory;
    private StatFs mDataFileStats;
    private StatFs mSystemFileStats;
    private StatFs mCacheFileStats;
    private static final String DATA_PATH = "/data";
    private static final String SYSTEM_PATH = "/system";
    private static final String CACHE_PATH = "/cache";
    private long mThreadStartTime = -1L;
    private boolean mClearSucceeded = false;
    private boolean mClearingCache;
    private Intent mStorageLowIntent;
    private Intent mStorageOkIntent;
    private Intent mStorageFullIntent;
    private Intent mStorageNotFullIntent;
    private CachePackageDataObserver mClearCacheObserver;
    private static final int _TRUE = 1;
    private static final int _FALSE = 0;
    private long mMemLowThreshold;
    private int mMemFullThreshold;
    public static final String SERVICE = "devicestoragemonitor";
    Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what != 1) {
                Slog.e((String)DeviceStorageMonitorService.TAG, (String)"Will not process invalid message");
                return;
            }
            DeviceStorageMonitorService.this.checkMemory(msg.arg1 == 1);
        }
    };

    private final void restatDataDir() {
        long threshold;
        long delta;
        try {
            this.mDataFileStats.restat(DATA_PATH);
            this.mFreeMem = (long)this.mDataFileStats.getAvailableBlocks() * (long)this.mDataFileStats.getBlockSize();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String debugFreeMem = SystemProperties.get((String)"debug.freemem");
        if (!"".equals(debugFreeMem)) {
            this.mFreeMem = Long.parseLong(debugFreeMem);
        }
        long freeMemLogInterval = Settings.Secure.getLong((ContentResolver)this.mContentResolver, (String)"sys_free_storage_log_interval", (long)720L) * 60L * 1000L;
        long currTime = SystemClock.elapsedRealtime();
        if (this.mLastReportedFreeMemTime == 0L || currTime - this.mLastReportedFreeMemTime >= freeMemLogInterval) {
            this.mLastReportedFreeMemTime = currTime;
            long mFreeSystem = -1L;
            long mFreeCache = -1L;
            try {
                this.mSystemFileStats.restat(SYSTEM_PATH);
                mFreeSystem = (long)this.mSystemFileStats.getAvailableBlocks() * (long)this.mSystemFileStats.getBlockSize();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.mCacheFileStats.restat(CACHE_PATH);
                mFreeCache = (long)this.mCacheFileStats.getAvailableBlocks() * (long)this.mCacheFileStats.getBlockSize();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            EventLog.writeEvent((int)2746, (Object[])new Object[]{this.mFreeMem, mFreeSystem, mFreeCache});
        }
        if ((delta = this.mFreeMem - this.mLastReportedFreeMem) > (threshold = Settings.Secure.getLong((ContentResolver)this.mContentResolver, (String)"disk_free_change_reporting_threshold", (long)0x200000L)) || delta < -threshold) {
            this.mLastReportedFreeMem = this.mFreeMem;
            EventLog.writeEvent((int)2744, (long)this.mFreeMem);
        }
    }

    private final void clearCache() {
        if (this.mClearCacheObserver == null) {
            this.mClearCacheObserver = new CachePackageDataObserver();
        }
        this.mClearingCache = true;
        try {
            IPackageManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"package")).freeStorageAndNotify(this.mMemLowThreshold, (IPackageDataObserver)this.mClearCacheObserver);
        }
        catch (RemoteException e) {
            Slog.w((String)TAG, (String)("Failed to get handle for PackageManger Exception: " + (Object)((Object)e)));
            this.mClearingCache = false;
            this.mClearSucceeded = false;
        }
    }

    private final void checkMemory(boolean checkCache) {
        if (this.mClearingCache) {
            long diffTime = System.currentTimeMillis() - this.mThreadStartTime;
            if (diffTime > 600000L) {
                Slog.w((String)TAG, (String)"Thread that clears cache file seems to run for ever");
            }
        } else {
            this.restatDataDir();
            if (this.mFreeMem < this.mMemLowThreshold) {
                if (!this.mLowMemFlag) {
                    if (checkCache) {
                        this.mThreadStartTime = System.currentTimeMillis();
                        this.mClearSucceeded = false;
                        this.clearCache();
                    } else {
                        Slog.i((String)TAG, (String)"Running low on memory. Sending notification");
                        this.sendNotification();
                        this.mLowMemFlag = true;
                    }
                }
            } else if (this.mLowMemFlag) {
                Slog.i((String)TAG, (String)"Memory available. Cancelling notification");
                this.cancelNotification();
                this.mLowMemFlag = false;
            }
            if (this.mFreeMem < (long)this.mMemFullThreshold) {
                if (!this.mMemFullFlag) {
                    this.sendFullNotification();
                    this.mMemFullFlag = true;
                }
            } else if (this.mMemFullFlag) {
                this.cancelFullNotification();
                this.mMemFullFlag = false;
            }
        }
        this.postCheckMemoryMsg(true, 60000L);
    }

    private void postCheckMemoryMsg(boolean clearCache, long delay) {
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, clearCache ? 1 : 0, 0), delay);
    }

    private long getMemThreshold() {
        long value = Settings.Secure.getInt((ContentResolver)this.mContentResolver, (String)"sys_storage_threshold_percentage", (int)10);
        long maxValue = Settings.Secure.getInt((ContentResolver)this.mContentResolver, (String)"sys_storage_threshold_max_bytes", (int)524288000);
        return (value *= this.mTotalMemory) < maxValue ? value : maxValue;
    }

    private int getMemFullThreshold() {
        int value = Settings.Secure.getInt((ContentResolver)this.mContentResolver, (String)"sys_storage_full_threshold_bytes", (int)0x100000);
        return value;
    }

    public DeviceStorageMonitorService(Context context) {
        this.mContext = context;
        this.mContentResolver = this.mContext.getContentResolver();
        this.mDataFileStats = new StatFs(DATA_PATH);
        this.mSystemFileStats = new StatFs(SYSTEM_PATH);
        this.mCacheFileStats = new StatFs(CACHE_PATH);
        this.mTotalMemory = (long)this.mDataFileStats.getBlockCount() * (long)this.mDataFileStats.getBlockSize() / 100L;
        this.mStorageLowIntent = new Intent("android.intent.action.DEVICE_STORAGE_LOW");
        this.mStorageLowIntent.addFlags(0x10000000);
        this.mStorageOkIntent = new Intent("android.intent.action.DEVICE_STORAGE_OK");
        this.mStorageOkIntent.addFlags(0x10000000);
        this.mStorageFullIntent = new Intent("android.intent.action.DEVICE_STORAGE_FULL");
        this.mStorageFullIntent.addFlags(0x10000000);
        this.mStorageNotFullIntent = new Intent("android.intent.action.DEVICE_STORAGE_NOT_FULL");
        this.mStorageNotFullIntent.addFlags(0x10000000);
        this.mMemLowThreshold = this.getMemThreshold();
        this.mMemFullThreshold = this.getMemFullThreshold();
        this.checkMemory(true);
    }

    private final void sendNotification() {
        EventLog.writeEvent((int)2745, (long)this.mFreeMem);
        Intent lowMemIntent = new Intent("android.intent.action.MANAGE_PACKAGE_STORAGE");
        lowMemIntent.putExtra("memory", this.mFreeMem);
        lowMemIntent.addFlags(0x10000000);
        NotificationManager mNotificationMgr = (NotificationManager)this.mContext.getSystemService("notification");
        CharSequence title = this.mContext.getText(17040282);
        CharSequence details = this.mContext.getText(17040283);
        PendingIntent intent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)lowMemIntent, (int)0);
        Notification notification = new Notification();
        notification.icon = 17302766;
        notification.tickerText = title;
        notification.flags |= 0x20;
        notification.setLatestEventInfo(this.mContext, title, details, intent);
        mNotificationMgr.notify(1, notification);
        this.mContext.sendStickyBroadcast(this.mStorageLowIntent);
    }

    private final void cancelNotification() {
        NotificationManager mNotificationMgr = (NotificationManager)this.mContext.getSystemService("notification");
        mNotificationMgr.cancel(1);
        this.mContext.removeStickyBroadcast(this.mStorageLowIntent);
        this.mContext.sendBroadcast(this.mStorageOkIntent);
    }

    private final void sendFullNotification() {
        this.mContext.sendStickyBroadcast(this.mStorageFullIntent);
    }

    private final void cancelFullNotification() {
        this.mContext.removeStickyBroadcast(this.mStorageFullIntent);
        this.mContext.sendBroadcast(this.mStorageNotFullIntent);
    }

    public void updateMemory() {
        int callingUid = DeviceStorageMonitorService.getCallingUid();
        if (callingUid != 1000) {
            return;
        }
        this.postCheckMemoryMsg(true, 0L);
    }

    public long getMemoryLowThreshold() {
        return this.mMemLowThreshold;
    }

    public boolean isMemoryLow() {
        return this.mLowMemFlag;
    }

    class CachePackageDataObserver
    extends IPackageDataObserver.Stub {
        CachePackageDataObserver() {
        }

        public void onRemoveCompleted(String packageName, boolean succeeded) {
            DeviceStorageMonitorService.this.mClearSucceeded = succeeded;
            DeviceStorageMonitorService.this.mClearingCache = false;
            DeviceStorageMonitorService.this.postCheckMemoryMsg(false, 0L);
        }
    }
}

