/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.UEventObserver;
import android.provider.Settings;
import android.server.BluetoothService;
import android.util.Log;
import android.util.Slog;
import com.android.server.PowerManagerService;
import java.io.FileNotFoundException;
import java.io.FileReader;

class DockObserver
extends UEventObserver {
    private static final String TAG = DockObserver.class.getSimpleName();
    private static final boolean LOG = false;
    private static final String DOCK_UEVENT_MATCH = "DEVPATH=/devices/virtual/switch/dock";
    private static final String DOCK_STATE_PATH = "/sys/class/switch/dock/state";
    private static final int MSG_DOCK_STATE = 0;
    private int mDockState = 0;
    private int mPreviousDockState = 0;
    private boolean mSystemReady;
    private final Context mContext;
    private PowerManagerService mPowerManager;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        Slog.i((String)TAG, (String)("Dock state changed: " + DockObserver.this.mDockState));
                        ContentResolver cr = DockObserver.this.mContext.getContentResolver();
                        if (Settings.Secure.getInt((ContentResolver)cr, (String)"device_provisioned", (int)0) == 0) {
                            Slog.i((String)TAG, (String)"Device not provisioned, skipping dock broadcast");
                            return;
                        }
                        Intent intent = new Intent("android.intent.action.DOCK_EVENT");
                        intent.addFlags(0x20000000);
                        intent.putExtra("android.intent.extra.DOCK_STATE", DockObserver.this.mDockState);
                        String address = BluetoothService.readDockBluetoothAddress();
                        if (address != null) {
                            intent.putExtra("android.bluetooth.device.extra.DEVICE", (Parcelable)BluetoothAdapter.getDefaultAdapter().getRemoteDevice(address));
                        }
                        if (Settings.System.getInt((ContentResolver)cr, (String)"dock_sounds_enabled", (int)1) == 1) {
                            Ringtone sfx;
                            Uri soundUri;
                            String soundPath;
                            String whichSound = null;
                            if (DockObserver.this.mDockState == 0) {
                                if (DockObserver.this.mPreviousDockState == 1 || DockObserver.this.mPreviousDockState == 3 || DockObserver.this.mPreviousDockState == 4) {
                                    whichSound = "desk_undock_sound";
                                } else if (DockObserver.this.mPreviousDockState == 2) {
                                    whichSound = "car_undock_sound";
                                }
                            } else if (DockObserver.this.mDockState == 1 || DockObserver.this.mDockState == 3 || DockObserver.this.mDockState == 4) {
                                whichSound = "desk_dock_sound";
                            } else if (DockObserver.this.mDockState == 2) {
                                whichSound = "car_dock_sound";
                            }
                            if (whichSound != null && (soundPath = Settings.System.getString((ContentResolver)cr, (String)whichSound)) != null && (soundUri = Uri.parse((String)("file://" + soundPath))) != null && (sfx = RingtoneManager.getRingtone((Context)DockObserver.this.mContext, (Uri)soundUri)) != null) {
                                sfx.setStreamType(1);
                                sfx.play();
                            }
                        }
                        DockObserver.this.mContext.sendStickyBroadcast(intent);
                        break;
                    }
                }
            }
        }
    };

    public DockObserver(Context context, PowerManagerService pm) {
        this.mContext = context;
        this.mPowerManager = pm;
        this.init();
        this.startObserving(DOCK_UEVENT_MATCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUEvent(UEventObserver.UEvent event) {
        if (Log.isLoggable((String)TAG, (int)2)) {
            Slog.v((String)TAG, (String)("Dock UEVENT: " + event.toString()));
        }
        DockObserver dockObserver = this;
        synchronized (dockObserver) {
            try {
                int newState = Integer.parseInt(event.get("SWITCH_STATE"));
                if (newState != this.mDockState) {
                    this.mPreviousDockState = this.mDockState;
                    this.mDockState = newState;
                    if (this.mSystemReady) {
                        if (this.mPreviousDockState != 1 && this.mPreviousDockState != 3 && this.mPreviousDockState != 4 || this.mDockState != 0) {
                            this.mPowerManager.userActivityWithForce(SystemClock.uptimeMillis(), false, true);
                        }
                        this.update();
                    }
                }
            }
            catch (NumberFormatException e) {
                Slog.e((String)TAG, (String)("Could not parse switch state from event " + event));
            }
        }
    }

    private final void init() {
        char[] buffer = new char[1024];
        try {
            FileReader file = new FileReader(DOCK_STATE_PATH);
            int len = file.read(buffer, 0, 1024);
            file.close();
            this.mPreviousDockState = this.mDockState = Integer.valueOf(new String(buffer, 0, len).trim()).intValue();
        }
        catch (FileNotFoundException e) {
            Slog.w((String)TAG, (String)"This kernel does not have dock station support");
        }
        catch (Exception e) {
            Slog.e((String)TAG, (String)"", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        DockObserver dockObserver = this;
        synchronized (dockObserver) {
            if (this.mDockState != 0) {
                this.update();
            }
            this.mSystemReady = true;
        }
    }

    private final void update() {
        this.mHandler.sendEmptyMessage(0);
    }
}

