/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.server.RandomBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EntropyService
extends Binder {
    private static final String TAG = "EntropyService";
    private static final int ENTROPY_WHAT = 1;
    private static final int ENTROPY_WRITE_PERIOD = 10800000;
    private static final long START_TIME = System.currentTimeMillis();
    private static final long START_NANOTIME = System.nanoTime();
    private final String randomDevice;
    private final String entropyFile;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what != 1) {
                Slog.e((String)EntropyService.TAG, (String)"Will not process invalid message");
                return;
            }
            EntropyService.this.writeEntropy();
            EntropyService.this.scheduleEntropyWriter();
        }
    };

    public EntropyService() {
        this(EntropyService.getSystemDir() + "/entropy.dat", "/dev/urandom");
    }

    public EntropyService(String entropyFile, String randomDevice) {
        if (randomDevice == null) {
            throw new NullPointerException("randomDevice");
        }
        if (entropyFile == null) {
            throw new NullPointerException("entropyFile");
        }
        this.randomDevice = randomDevice;
        this.entropyFile = entropyFile;
        this.loadInitialEntropy();
        this.addDeviceSpecificEntropy();
        this.writeEntropy();
        this.scheduleEntropyWriter();
    }

    private void scheduleEntropyWriter() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, 10800000L);
    }

    private void loadInitialEntropy() {
        try {
            RandomBlock.fromFile(this.entropyFile).toFile(this.randomDevice, false);
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)"unable to load initial entropy (first boot?)", (Throwable)e);
        }
    }

    private void writeEntropy() {
        try {
            RandomBlock.fromFile(this.randomDevice).toFile(this.entropyFile, true);
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)"unable to write entropy", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeviceSpecificEntropy() {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileOutputStream(this.randomDevice));
                out.println("Copyright (C) 2009 The Android Open Source Project");
                out.println("All Your Randomness Are Belong To Us");
                out.println(START_TIME);
                out.println(START_NANOTIME);
                out.println(SystemProperties.get((String)"ro.serialno"));
                out.println(SystemProperties.get((String)"ro.bootmode"));
                out.println(SystemProperties.get((String)"ro.baseband"));
                out.println(SystemProperties.get((String)"ro.carrier"));
                out.println(SystemProperties.get((String)"ro.bootloader"));
                out.println(SystemProperties.get((String)"ro.hardware"));
                out.println(SystemProperties.get((String)"ro.revision"));
                out.println(new Object().hashCode());
                out.println(System.currentTimeMillis());
                out.println(System.nanoTime());
            }
            catch (IOException e) {
                Slog.w((String)TAG, (String)"Unable to add device specific data to the entropy pool", (Throwable)e);
                Object var4_3 = null;
                if (out != null) {
                    out.close();
                }
            }
            Object var4_2 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
    }

    private static String getSystemDir() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        systemDir.mkdirs();
        return systemDir.toString();
    }
}

