/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.util.EventLog;

public class EventLogTags {
    public static final int BATTERY_LEVEL = 2722;
    public static final int BATTERY_STATUS = 2723;
    public static final int BATTERY_DISCHARGE = 2730;
    public static final int POWER_SLEEP_REQUESTED = 2724;
    public static final int POWER_SCREEN_BROADCAST_SEND = 2725;
    public static final int POWER_SCREEN_BROADCAST_DONE = 2726;
    public static final int POWER_SCREEN_BROADCAST_STOP = 2727;
    public static final int POWER_SCREEN_STATE = 2728;
    public static final int POWER_PARTIAL_WAKE_STATE = 2729;
    public static final int FREE_STORAGE_CHANGED = 2744;
    public static final int LOW_STORAGE = 2745;
    public static final int FREE_STORAGE_LEFT = 2746;
    public static final int NOTIFICATION_ENQUEUE = 2750;
    public static final int NOTIFICATION_CANCEL = 2751;
    public static final int NOTIFICATION_CANCEL_ALL = 2752;
    public static final int WATCHDOG = 2802;
    public static final int WATCHDOG_PROC_PSS = 2803;
    public static final int WATCHDOG_SOFT_RESET = 2804;
    public static final int WATCHDOG_HARD_RESET = 2805;
    public static final int WATCHDOG_PSS_STATS = 2806;
    public static final int WATCHDOG_PROC_STATS = 2807;
    public static final int WATCHDOG_SCHEDULED_REBOOT = 2808;
    public static final int WATCHDOG_MEMINFO = 2809;
    public static final int WATCHDOG_VMSTAT = 2810;
    public static final int WATCHDOG_REQUESTED_REBOOT = 2811;
    public static final int BACKUP_DATA_CHANGED = 2820;
    public static final int BACKUP_START = 2821;
    public static final int BACKUP_TRANSPORT_FAILURE = 2822;
    public static final int BACKUP_AGENT_FAILURE = 2823;
    public static final int BACKUP_PACKAGE = 2824;
    public static final int BACKUP_SUCCESS = 2825;
    public static final int BACKUP_RESET = 2826;
    public static final int BACKUP_INITIALIZE = 2827;
    public static final int RESTORE_START = 2830;
    public static final int RESTORE_TRANSPORT_FAILURE = 2831;
    public static final int RESTORE_AGENT_FAILURE = 2832;
    public static final int RESTORE_PACKAGE = 2833;
    public static final int RESTORE_SUCCESS = 2834;
    public static final int BOOT_PROGRESS_SYSTEM_RUN = 3010;
    public static final int BOOT_PROGRESS_PMS_START = 3060;
    public static final int BOOT_PROGRESS_PMS_SYSTEM_SCAN_START = 3070;
    public static final int BOOT_PROGRESS_PMS_DATA_SCAN_START = 3080;
    public static final int BOOT_PROGRESS_PMS_SCAN_END = 3090;
    public static final int BOOT_PROGRESS_PMS_READY = 3100;
    public static final int WM_NO_SURFACE_MEMORY = 31000;
    public static final int IMF_FORCE_RECONNECT_IME = 32000;
    public static final int CONNECTIVITY_STATE_CHANGED = 50020;
    public static final int NETSTATS_MOBILE_SAMPLE = 51100;
    public static final int NETSTATS_WIFI_SAMPLE = 51101;

    private EventLogTags() {
    }

    public static void writeBatteryLevel(int level, int voltage, int temperature) {
        EventLog.writeEvent((int)2722, (Object[])new Object[]{level, voltage, temperature});
    }

    public static void writeBatteryStatus(int status, int health, int present, int plugged, String technology) {
        EventLog.writeEvent((int)2723, (Object[])new Object[]{status, health, present, plugged, technology});
    }

    public static void writeBatteryDischarge(long duration, int minlevel, int maxlevel) {
        EventLog.writeEvent((int)2730, (Object[])new Object[]{duration, minlevel, maxlevel});
    }

    public static void writePowerSleepRequested(int wakelockscleared) {
        EventLog.writeEvent((int)2724, (int)wakelockscleared);
    }

    public static void writePowerScreenBroadcastSend(int wakelockcount) {
        EventLog.writeEvent((int)2725, (int)wakelockcount);
    }

    public static void writePowerScreenBroadcastDone(int on, long broadcastduration, int wakelockcount) {
        EventLog.writeEvent((int)2726, (Object[])new Object[]{on, broadcastduration, wakelockcount});
    }

    public static void writePowerScreenBroadcastStop(int which, int wakelockcount) {
        EventLog.writeEvent((int)2727, (Object[])new Object[]{which, wakelockcount});
    }

    public static void writePowerScreenState(int offoron, int becauseofuser, long totaltouchdowntime, int touchcycles) {
        EventLog.writeEvent((int)2728, (Object[])new Object[]{offoron, becauseofuser, totaltouchdowntime, touchcycles});
    }

    public static void writePowerPartialWakeState(int releasedoracquired, String tag) {
        EventLog.writeEvent((int)2729, (Object[])new Object[]{releasedoracquired, tag});
    }

    public static void writeFreeStorageChanged(long data) {
        EventLog.writeEvent((int)2744, (long)data);
    }

    public static void writeLowStorage(long data) {
        EventLog.writeEvent((int)2745, (long)data);
    }

    public static void writeFreeStorageLeft(long data, long system, long cache) {
        EventLog.writeEvent((int)2746, (Object[])new Object[]{data, system, cache});
    }

    public static void writeNotificationEnqueue(String pkg, int id, String tag, String notification) {
        EventLog.writeEvent((int)2750, (Object[])new Object[]{pkg, id, tag, notification});
    }

    public static void writeNotificationCancel(String pkg, int id, String tag, int requiredFlags, int forbiddenFlags) {
        EventLog.writeEvent((int)2751, (Object[])new Object[]{pkg, id, tag, requiredFlags, forbiddenFlags});
    }

    public static void writeNotificationCancelAll(String pkg, int requiredFlags, int forbiddenFlags) {
        EventLog.writeEvent((int)2752, (Object[])new Object[]{pkg, requiredFlags, forbiddenFlags});
    }

    public static void writeWatchdog(String service) {
        EventLog.writeEvent((int)2802, (String)service);
    }

    public static void writeWatchdogProcPss(String process, int pid, int pss) {
        EventLog.writeEvent((int)2803, (Object[])new Object[]{process, pid, pss});
    }

    public static void writeWatchdogSoftReset(String process, int pid, int maxpss, int pss, String skip) {
        EventLog.writeEvent((int)2804, (Object[])new Object[]{process, pid, maxpss, pss, skip});
    }

    public static void writeWatchdogHardReset(String process, int pid, int maxpss, int pss) {
        EventLog.writeEvent((int)2805, (Object[])new Object[]{process, pid, maxpss, pss});
    }

    public static void writeWatchdogPssStats(int emptypss, int emptycount, int backgroundpss, int backgroundcount, int servicepss, int servicecount, int visiblepss, int visiblecount, int foregroundpss, int foregroundcount, int nopsscount) {
        EventLog.writeEvent((int)2806, (Object[])new Object[]{emptypss, emptycount, backgroundpss, backgroundcount, servicepss, servicecount, visiblepss, visiblecount, foregroundpss, foregroundcount, nopsscount});
    }

    public static void writeWatchdogProcStats(int deathsinone, int deathsintwo, int deathsinthree, int deathsinfour, int deathsinfive) {
        EventLog.writeEvent((int)2807, (Object[])new Object[]{deathsinone, deathsintwo, deathsinthree, deathsinfour, deathsinfive});
    }

    public static void writeWatchdogScheduledReboot(long now, int interval, int starttime, int window, String skip) {
        EventLog.writeEvent((int)2808, (Object[])new Object[]{now, interval, starttime, window, skip});
    }

    public static void writeWatchdogMeminfo(int memfree, int buffers, int cached, int active, int inactive, int anonpages, int mapped, int slab, int sreclaimable, int sunreclaim, int pagetables) {
        EventLog.writeEvent((int)2809, (Object[])new Object[]{memfree, buffers, cached, active, inactive, anonpages, mapped, slab, sreclaimable, sunreclaim, pagetables});
    }

    public static void writeWatchdogVmstat(long runtime, int pgfree, int pgactivate, int pgdeactivate, int pgfault, int pgmajfault) {
        EventLog.writeEvent((int)2810, (Object[])new Object[]{runtime, pgfree, pgactivate, pgdeactivate, pgfault, pgmajfault});
    }

    public static void writeWatchdogRequestedReboot(int nowait, int scheduleinterval, int recheckinterval, int starttime, int window, int minscreenoff, int minnextalarm) {
        EventLog.writeEvent((int)2811, (Object[])new Object[]{nowait, scheduleinterval, recheckinterval, starttime, window, minscreenoff, minnextalarm});
    }

    public static void writeBackupDataChanged(String package_) {
        EventLog.writeEvent((int)2820, (String)package_);
    }

    public static void writeBackupStart(String transport) {
        EventLog.writeEvent((int)2821, (String)transport);
    }

    public static void writeBackupTransportFailure(String package_) {
        EventLog.writeEvent((int)2822, (String)package_);
    }

    public static void writeBackupAgentFailure(String package_, String message) {
        EventLog.writeEvent((int)2823, (Object[])new Object[]{package_, message});
    }

    public static void writeBackupPackage(String package_, int size) {
        EventLog.writeEvent((int)2824, (Object[])new Object[]{package_, size});
    }

    public static void writeBackupSuccess(int packages, int time) {
        EventLog.writeEvent((int)2825, (Object[])new Object[]{packages, time});
    }

    public static void writeBackupReset(String transport) {
        EventLog.writeEvent((int)2826, (String)transport);
    }

    public static void writeBackupInitialize() {
        EventLog.writeEvent((int)2827, (Object[])new Object[0]);
    }

    public static void writeRestoreStart(String transport, long source) {
        EventLog.writeEvent((int)2830, (Object[])new Object[]{transport, source});
    }

    public static void writeRestoreTransportFailure() {
        EventLog.writeEvent((int)2831, (Object[])new Object[0]);
    }

    public static void writeRestoreAgentFailure(String package_, String message) {
        EventLog.writeEvent((int)2832, (Object[])new Object[]{package_, message});
    }

    public static void writeRestorePackage(String package_, int size) {
        EventLog.writeEvent((int)2833, (Object[])new Object[]{package_, size});
    }

    public static void writeRestoreSuccess(int packages, int time) {
        EventLog.writeEvent((int)2834, (Object[])new Object[]{packages, time});
    }

    public static void writeBootProgressSystemRun(long time) {
        EventLog.writeEvent((int)3010, (long)time);
    }

    public static void writeBootProgressPmsStart(long time) {
        EventLog.writeEvent((int)3060, (long)time);
    }

    public static void writeBootProgressPmsSystemScanStart(long time) {
        EventLog.writeEvent((int)3070, (long)time);
    }

    public static void writeBootProgressPmsDataScanStart(long time) {
        EventLog.writeEvent((int)3080, (long)time);
    }

    public static void writeBootProgressPmsScanEnd(long time) {
        EventLog.writeEvent((int)3090, (long)time);
    }

    public static void writeBootProgressPmsReady(long time) {
        EventLog.writeEvent((int)3100, (long)time);
    }

    public static void writeWmNoSurfaceMemory(String window, int pid, String operation) {
        EventLog.writeEvent((int)31000, (Object[])new Object[]{window, pid, operation});
    }

    public static void writeImfForceReconnectIme(Object[] ime, long timeSinceConnect, int showing) {
        EventLog.writeEvent((int)32000, (Object[])new Object[]{ime, timeSinceConnect, showing});
    }

    public static void writeConnectivityStateChanged(int custom) {
        EventLog.writeEvent((int)50020, (int)custom);
    }

    public static void writeNetstatsMobileSample(long devRxBytes, long devTxBytes, long devRxPkts, long devTxPkts, long xtRxBytes, long xtTxBytes, long xtRxPkts, long xtTxPkts, long uidRxBytes, long uidTxBytes, long uidRxPkts, long uidTxPkts, long trustedTime, long devHistoryStart) {
        EventLog.writeEvent((int)51100, (Object[])new Object[]{devRxBytes, devTxBytes, devRxPkts, devTxPkts, xtRxBytes, xtTxBytes, xtRxPkts, xtTxPkts, uidRxBytes, uidTxBytes, uidRxPkts, uidTxPkts, trustedTime, devHistoryStart});
    }

    public static void writeNetstatsWifiSample(long devRxBytes, long devTxBytes, long devRxPkts, long devTxPkts, long xtRxBytes, long xtTxBytes, long xtRxPkts, long xtTxPkts, long uidRxBytes, long uidTxBytes, long uidRxPkts, long uidTxPkts, long trustedTime, long devHistoryStart) {
        EventLog.writeEvent((int)51101, (Object[])new Object[]{devRxBytes, devTxBytes, devRxPkts, devTxPkts, xtRxBytes, xtTxBytes, xtRxPkts, xtTxPkts, uidRxBytes, uidTxBytes, uidRxPkts, uidTxPkts, trustedTime, devHistoryStart});
    }
}

