/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.style.SuggestionSpan;
import android.util.EventLog;
import android.util.LruCache;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Printer;
import android.util.Slog;
import android.util.Xml;
import android.view.IWindowManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.RadioButton;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.AtomicFile;
import com.android.internal.os.HandlerCaller;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethod;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.InputBindResult;
import com.android.server.StatusBarManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputMethodManagerService
extends IInputMethodManager.Stub
implements ServiceConnection,
Handler.Callback {
    static final boolean DEBUG = false;
    static final String TAG = "InputManagerService";
    static final int MSG_SHOW_IM_PICKER = 1;
    static final int MSG_SHOW_IM_SUBTYPE_PICKER = 2;
    static final int MSG_SHOW_IM_SUBTYPE_ENABLER = 3;
    static final int MSG_SHOW_IM_CONFIG = 4;
    static final int MSG_UNBIND_INPUT = 1000;
    static final int MSG_BIND_INPUT = 1010;
    static final int MSG_SHOW_SOFT_INPUT = 1020;
    static final int MSG_HIDE_SOFT_INPUT = 1030;
    static final int MSG_ATTACH_TOKEN = 1040;
    static final int MSG_CREATE_SESSION = 1050;
    static final int MSG_START_INPUT = 2000;
    static final int MSG_RESTART_INPUT = 2010;
    static final int MSG_UNBIND_METHOD = 3000;
    static final int MSG_BIND_METHOD = 3010;
    static final long TIME_TO_RECONNECT = 10000L;
    static final int SECURE_SUGGESTION_SPANS_MAX_SIZE = 20;
    private static final int NOT_A_SUBTYPE_ID = -1;
    private static final String NOT_A_SUBTYPE_ID_STR = String.valueOf(-1);
    private static final String SUBTYPE_MODE_KEYBOARD = "keyboard";
    private static final String SUBTYPE_MODE_VOICE = "voice";
    private static final String TAG_TRY_SUPPRESSING_IME_SWITCHER = "TrySuppressingImeSwitcher";
    final Context mContext;
    final Resources mRes;
    final Handler mHandler;
    final InputMethodSettings mSettings;
    final SettingsObserver mSettingsObserver;
    final IWindowManager mIWindowManager;
    final HandlerCaller mCaller;
    private final InputMethodFileManager mFileManager;
    final InputBindResult mNoBinding = new InputBindResult(null, null, -1);
    final ArrayList<InputMethodInfo> mMethodList = new ArrayList();
    final HashMap<String, InputMethodInfo> mMethodMap = new HashMap();
    private final LruCache<SuggestionSpan, InputMethodInfo> mSecureSuggestionSpans = new LruCache(20);
    final ServiceConnection mVisibleConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    };
    boolean mVisibleBound = false;
    private NotificationManager mNotificationManager;
    private KeyguardManager mKeyguardManager;
    private StatusBarManagerService mStatusBar;
    private Notification mImeSwitcherNotification;
    private PendingIntent mImeSwitchPendingIntent;
    private boolean mShowOngoingImeSwitcherForPhones;
    private boolean mNotificationShown;
    final HashMap<IBinder, ClientState> mClients = new HashMap();
    boolean mSystemReady;
    String mCurMethodId;
    int mCurSeq;
    ClientState mCurClient;
    IBinder mCurFocusedWindow;
    IInputContext mCurInputContext;
    EditorInfo mCurAttribute;
    String mCurId;
    private InputMethodSubtype mCurrentSubtype;
    private final HashMap<InputMethodInfo, ArrayList<InputMethodSubtype>> mShortcutInputMethodsAndSubtypes = new HashMap();
    boolean mHaveConnection;
    boolean mShowRequested;
    boolean mShowExplicitlyRequested;
    boolean mShowForced;
    boolean mInputShown;
    Intent mCurIntent;
    IBinder mCurToken;
    IInputMethod mCurMethod;
    long mLastBindTime;
    boolean mBoundToMethod;
    SessionState mEnabledSession;
    boolean mScreenOn = true;
    int mBackDisposition = 0;
    int mImeWindowVis;
    private AlertDialog.Builder mDialogBuilder;
    private AlertDialog mSwitchingDialog;
    private InputMethodInfo[] mIms;
    private int[] mSubtypeIds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputMethodManagerService(Context context) {
        this.mContext = context;
        this.mRes = context.getResources();
        this.mHandler = new Handler((Handler.Callback)this);
        this.mIWindowManager = IWindowManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"window"));
        this.mCaller = new HandlerCaller(context, new HandlerCaller.Callback(){

            public void executeMessage(Message msg) {
                InputMethodManagerService.this.handleMessage(msg);
            }
        });
        this.mImeSwitcherNotification = new Notification();
        this.mImeSwitcherNotification.icon = 17302332;
        this.mImeSwitcherNotification.when = 0L;
        this.mImeSwitcherNotification.flags = 2;
        this.mImeSwitcherNotification.tickerText = null;
        this.mImeSwitcherNotification.defaults = 0;
        this.mImeSwitcherNotification.sound = null;
        this.mImeSwitcherNotification.vibrate = null;
        Intent intent = new Intent("android.settings.SHOW_INPUT_METHOD_PICKER");
        this.mImeSwitchPendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
        this.mShowOngoingImeSwitcherForPhones = false;
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.mFileManager = new InputMethodFileManager(this.mMethodMap);
        }
        new MyPackageMonitor().register(this.mContext, true);
        IntentFilter screenOnOffFilt = new IntentFilter();
        screenOnOffFilt.addAction("android.intent.action.SCREEN_ON");
        screenOnOffFilt.addAction("android.intent.action.SCREEN_OFF");
        screenOnOffFilt.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        this.mContext.registerReceiver((BroadcastReceiver)new ScreenOnOffReceiver(), screenOnOffFilt);
        this.mNotificationShown = false;
        this.mSettings = new InputMethodSettings(this.mRes, context.getContentResolver(), this.mMethodMap, this.mMethodList);
        this.buildInputMethodListLocked(this.mMethodList, this.mMethodMap);
        this.mSettings.enableAllIMEsIfThereIsNoEnabledIME();
        if (TextUtils.isEmpty((CharSequence)Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"default_input_method"))) {
            InputMethodInfo defIm = null;
            for (InputMethodInfo imi : this.mMethodList) {
                if (defIm != null || imi.getIsDefaultResourceId() == 0) continue;
                try {
                    Resources res = context.createPackageContext(imi.getPackageName(), 0).getResources();
                    if (!res.getBoolean(imi.getIsDefaultResourceId())) continue;
                    defIm = imi;
                    Slog.i((String)TAG, (String)("Selected default: " + imi.getId()));
                }
                catch (PackageManager.NameNotFoundException ex) {
                }
                catch (Resources.NotFoundException ex) {}
            }
            if (defIm == null && this.mMethodList.size() > 0) {
                defIm = this.getMostApplicableDefaultIMELocked();
                Slog.i((String)TAG, (String)("No default found, using " + defIm.getId()));
            }
            if (defIm != null) {
                this.setSelectedInputMethodAndSubtypeLocked(defIm, -1, false);
            }
        }
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.updateFromSettingsLocked();
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.e((String)TAG, (String)"Input Method Manager Crash", (Throwable)e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(StatusBarManagerService statusBar) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (!this.mSystemReady) {
                this.mSystemReady = true;
                this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
                this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
                this.mStatusBar = statusBar;
                statusBar.setIconVisibility("ime", false);
                this.updateImeWindowStatusLocked();
                this.mShowOngoingImeSwitcherForPhones = this.mRes.getBoolean(0x1110003);
                try {
                    this.startInputInnerLocked();
                }
                catch (RuntimeException e) {
                    Slog.w((String)TAG, (String)"Unexpected exception", (Throwable)e);
                }
            }
        }
    }

    private void setImeWindowVisibilityStatusHiddenLocked() {
        this.mImeWindowVis = 0;
        this.updateImeWindowStatusLocked();
    }

    private void refreshImeWindowVisibilityLocked() {
        Configuration conf = this.mRes.getConfiguration();
        boolean haveHardKeyboard = conf.keyboard != 1;
        boolean hardKeyShown = haveHardKeyboard && conf.hardKeyboardHidden != 2;
        boolean isScreenLocked = this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked() && this.mKeyguardManager.isKeyguardSecure();
        this.mImeWindowVis = !isScreenLocked && (this.mInputShown || hardKeyShown) ? 3 : 0;
        this.updateImeWindowStatusLocked();
    }

    private void updateImeWindowStatusLocked() {
        this.setImeWindowStatus(this.mCurToken, this.mImeWindowVis, this.mBackDisposition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputMethodInfo> getInputMethodList() {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            return new ArrayList<InputMethodInfo>(this.mMethodList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputMethodInfo> getEnabledInputMethodList() {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            return this.mSettings.getEnabledInputMethodListLocked();
        }
    }

    private HashMap<InputMethodInfo, List<InputMethodSubtype>> getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked() {
        HashMap<InputMethodInfo, List<InputMethodSubtype>> enabledInputMethodAndSubtypes = new HashMap<InputMethodInfo, List<InputMethodSubtype>>();
        for (InputMethodInfo imi : this.getEnabledInputMethodList()) {
            enabledInputMethodAndSubtypes.put(imi, this.getEnabledInputMethodSubtypeListLocked(imi, true));
        }
        return enabledInputMethodAndSubtypes;
    }

    public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(InputMethodInfo imi, boolean allowsImplicitlySelectedSubtypes) {
        if (imi == null && this.mCurMethodId != null) {
            imi = this.mMethodMap.get(this.mCurMethodId);
        }
        List<InputMethodSubtype> enabledSubtypes = this.mSettings.getEnabledInputMethodSubtypeListLocked(imi);
        if (allowsImplicitlySelectedSubtypes && enabledSubtypes.isEmpty()) {
            enabledSubtypes = InputMethodManagerService.getImplicitlyApplicableSubtypesLocked(this.mRes, imi);
        }
        return InputMethodSubtype.sort((Context)this.mContext, (int)0, (InputMethodInfo)imi, enabledSubtypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(InputMethodInfo imi, boolean allowsImplicitlySelectedSubtypes) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            return this.getEnabledInputMethodSubtypeListLocked(imi, allowsImplicitlySelectedSubtypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(IInputMethodClient client, IInputContext inputContext, int uid, int pid) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.mClients.put(client.asBinder(), new ClientState(client, inputContext, uid, pid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(IInputMethodClient client) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.mClients.remove(client.asBinder());
        }
    }

    void executeOrSendMessage(IInterface target, Message msg) {
        if (target.asBinder() instanceof Binder) {
            this.mCaller.sendMessage(msg);
        } else {
            this.handleMessage(msg);
            msg.recycle();
        }
    }

    void unbindCurrentClientLocked() {
        if (this.mCurClient != null) {
            if (this.mBoundToMethod) {
                this.mBoundToMethod = false;
                if (this.mCurMethod != null) {
                    this.executeOrSendMessage((IInterface)this.mCurMethod, this.mCaller.obtainMessageO(1000, (Object)this.mCurMethod));
                }
            }
            this.executeOrSendMessage((IInterface)this.mCurClient.client, this.mCaller.obtainMessageIO(3000, this.mCurSeq, (Object)this.mCurClient.client));
            this.mCurClient.sessionRequested = false;
            try {
                this.mCurClient.client.setActive(false);
            }
            catch (RemoteException e) {
                Slog.w((String)TAG, (String)("Got RemoteException sending setActive(false) notification to pid " + this.mCurClient.pid + " uid " + this.mCurClient.uid));
            }
            this.mCurClient = null;
            this.hideInputMethodMenuLocked();
        }
    }

    private int getImeShowFlags() {
        int flags = 0;
        if (this.mShowForced) {
            flags |= 3;
        } else if (this.mShowExplicitlyRequested) {
            flags |= 1;
        }
        return flags;
    }

    private int getAppShowFlags() {
        int flags = 0;
        if (this.mShowForced) {
            flags |= 2;
        } else if (!this.mShowExplicitlyRequested) {
            flags |= 1;
        }
        return flags;
    }

    InputBindResult attachNewInputLocked(boolean initial, boolean needResult) {
        if (!this.mBoundToMethod) {
            this.executeOrSendMessage((IInterface)this.mCurMethod, this.mCaller.obtainMessageOO(1010, (Object)this.mCurMethod, (Object)this.mCurClient.binding));
            this.mBoundToMethod = true;
        }
        SessionState session = this.mCurClient.curSession;
        if (initial) {
            this.executeOrSendMessage((IInterface)session.method, this.mCaller.obtainMessageOOO(2000, (Object)session, (Object)this.mCurInputContext, (Object)this.mCurAttribute));
        } else {
            this.executeOrSendMessage((IInterface)session.method, this.mCaller.obtainMessageOOO(2010, (Object)session, (Object)this.mCurInputContext, (Object)this.mCurAttribute));
        }
        if (this.mShowRequested) {
            this.showCurrentInputLocked(this.getAppShowFlags(), null);
        }
        return needResult ? new InputBindResult(session.session, this.mCurId, this.mCurSeq) : null;
    }

    InputBindResult startInputLocked(IInputMethodClient client, IInputContext inputContext, EditorInfo attribute, boolean initial, boolean needResult) {
        if (this.mCurMethodId == null) {
            return this.mNoBinding;
        }
        ClientState cs = this.mClients.get(client.asBinder());
        if (cs == null) {
            throw new IllegalArgumentException("unknown client " + client.asBinder());
        }
        try {
            if (!this.mIWindowManager.inputMethodClientHasFocus(cs.client)) {
                Slog.w((String)TAG, (String)("Starting input on non-focused client " + cs.client + " (uid=" + cs.uid + " pid=" + cs.pid + ")"));
                return null;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (this.mCurClient != cs) {
            this.unbindCurrentClientLocked();
            if (this.mScreenOn) {
                try {
                    cs.client.setActive(this.mScreenOn);
                }
                catch (RemoteException e) {
                    Slog.w((String)TAG, (String)("Got RemoteException sending setActive notification to pid " + cs.pid + " uid " + cs.uid));
                }
            }
        }
        ++this.mCurSeq;
        if (this.mCurSeq <= 0) {
            this.mCurSeq = 1;
        }
        this.mCurClient = cs;
        this.mCurInputContext = inputContext;
        this.mCurAttribute = attribute;
        if (this.mCurId != null && this.mCurId.equals(this.mCurMethodId)) {
            if (cs.curSession != null) {
                return this.attachNewInputLocked(initial, needResult);
            }
            if (this.mHaveConnection) {
                if (this.mCurMethod != null) {
                    if (!cs.sessionRequested) {
                        cs.sessionRequested = true;
                        this.executeOrSendMessage((IInterface)this.mCurMethod, this.mCaller.obtainMessageOO(1050, (Object)this.mCurMethod, (Object)new MethodCallback(this.mCurMethod, this)));
                    }
                    return new InputBindResult(null, this.mCurId, this.mCurSeq);
                }
                if (SystemClock.uptimeMillis() < this.mLastBindTime + 10000L) {
                    return new InputBindResult(null, this.mCurId, this.mCurSeq);
                }
                EventLog.writeEvent((int)32000, (Object[])new Object[]{this.mCurMethodId, SystemClock.uptimeMillis() - this.mLastBindTime, 0});
            }
        }
        return this.startInputInnerLocked();
    }

    InputBindResult startInputInnerLocked() {
        if (this.mCurMethodId == null) {
            return this.mNoBinding;
        }
        if (!this.mSystemReady) {
            return new InputBindResult(null, this.mCurMethodId, this.mCurSeq);
        }
        InputMethodInfo info = this.mMethodMap.get(this.mCurMethodId);
        if (info == null) {
            throw new IllegalArgumentException("Unknown id: " + this.mCurMethodId);
        }
        this.unbindCurrentMethodLocked(false);
        this.mCurIntent = new Intent("android.view.InputMethod");
        this.mCurIntent.setComponent(info.getComponent());
        this.mCurIntent.putExtra("android.intent.extra.client_label", 17040445);
        this.mCurIntent.putExtra("android.intent.extra.client_intent", (Parcelable)PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)new Intent("android.settings.INPUT_METHOD_SETTINGS"), (int)0));
        if (this.mContext.bindService(this.mCurIntent, (ServiceConnection)this, 0x40000001)) {
            this.mLastBindTime = SystemClock.uptimeMillis();
            this.mHaveConnection = true;
            this.mCurId = info.getId();
            this.mCurToken = new Binder();
            try {
                this.mIWindowManager.addWindowToken(this.mCurToken, 2011);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return new InputBindResult(null, this.mCurId, this.mCurSeq);
        }
        this.mCurIntent = null;
        Slog.w((String)TAG, (String)("Failure connecting to input method service: " + this.mCurIntent));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputBindResult startInput(IInputMethodClient client, IInputContext inputContext, EditorInfo attribute, boolean initial, boolean needResult) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputBindResult inputBindResult;
            long ident = Binder.clearCallingIdentity();
            try {
                inputBindResult = this.startInputLocked(client, inputContext, attribute, initial, needResult);
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
            return inputBindResult;
        }
    }

    public void finishInput(IInputMethodClient client) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName name, IBinder service) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurIntent != null && name.equals((Object)this.mCurIntent.getComponent())) {
                this.mCurMethod = IInputMethod.Stub.asInterface((IBinder)service);
                if (this.mCurToken == null) {
                    Slog.w((String)TAG, (String)"Service connected without a token!");
                    this.unbindCurrentMethodLocked(false);
                    return;
                }
                this.executeOrSendMessage((IInterface)this.mCurMethod, this.mCaller.obtainMessageOO(1040, (Object)this.mCurMethod, (Object)this.mCurToken));
                if (this.mCurClient != null) {
                    this.executeOrSendMessage((IInterface)this.mCurMethod, this.mCaller.obtainMessageOO(1050, (Object)this.mCurMethod, (Object)new MethodCallback(this.mCurMethod, this)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSessionCreated(IInputMethod method, IInputMethodSession session) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurMethod != null && method != null && this.mCurMethod.asBinder() == method.asBinder() && this.mCurClient != null) {
                this.mCurClient.curSession = new SessionState(this.mCurClient, method, session);
                this.mCurClient.sessionRequested = false;
                InputBindResult res = this.attachNewInputLocked(true, true);
                if (res.method != null) {
                    this.executeOrSendMessage((IInterface)this.mCurClient.client, this.mCaller.obtainMessageOO(3010, (Object)this.mCurClient.client, (Object)res));
                }
            }
        }
    }

    void unbindCurrentMethodLocked(boolean reportToClient) {
        if (this.mVisibleBound) {
            this.mContext.unbindService(this.mVisibleConnection);
            this.mVisibleBound = false;
        }
        if (this.mHaveConnection) {
            this.mContext.unbindService((ServiceConnection)this);
            this.mHaveConnection = false;
        }
        if (this.mCurToken != null) {
            try {
                this.mIWindowManager.removeWindowToken(this.mCurToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mCurToken = null;
        }
        this.mCurId = null;
        this.clearCurMethodLocked();
        if (reportToClient && this.mCurClient != null) {
            this.executeOrSendMessage((IInterface)this.mCurClient.client, this.mCaller.obtainMessageIO(3000, this.mCurSeq, (Object)this.mCurClient.client));
        }
    }

    private void finishSession(SessionState sessionState) {
        if (sessionState != null && sessionState.session != null) {
            try {
                sessionState.session.finishSession();
            }
            catch (RemoteException e) {
                Slog.w((String)TAG, (String)"Session failed to close due to remote exception", (Throwable)e);
                this.setImeWindowVisibilityStatusHiddenLocked();
            }
        }
    }

    void clearCurMethodLocked() {
        if (this.mCurMethod != null) {
            for (ClientState cs : this.mClients.values()) {
                cs.sessionRequested = false;
                this.finishSession(cs.curSession);
                cs.curSession = null;
            }
            this.finishSession(this.mEnabledSession);
            this.mEnabledSession = null;
            this.mCurMethod = null;
        }
        if (this.mStatusBar != null) {
            this.mStatusBar.setIconVisibility("ime", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceDisconnected(ComponentName name) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurMethod != null && this.mCurIntent != null && name.equals((Object)this.mCurIntent.getComponent())) {
                this.clearCurMethodLocked();
                this.mLastBindTime = SystemClock.uptimeMillis();
                this.mShowRequested = this.mInputShown;
                this.mInputShown = false;
                if (this.mCurClient != null) {
                    this.executeOrSendMessage((IInterface)this.mCurClient.client, this.mCaller.obtainMessageIO(3000, this.mCurSeq, (Object)this.mCurClient.client));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateStatusIcon(IBinder token, String packageName, int iconId) {
        long ident;
        block13: {
            block12: {
                int uid = Binder.getCallingUid();
                ident = Binder.clearCallingIdentity();
                try {
                    if (token == null || this.mCurToken != token) {
                        Slog.w((String)TAG, (String)("Ignoring setInputMethod of uid " + uid + " token: " + token));
                        Object var12_6 = null;
                        break block12;
                    }
                    HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                    synchronized (hashMap) {
                        if (iconId == 0) {
                            if (this.mStatusBar != null) {
                                this.mStatusBar.setIconVisibility("ime", false);
                            }
                        } else if (packageName != null) {
                            CharSequence contentDescription = null;
                            try {
                                PackageManager packageManager = this.mContext.getPackageManager();
                                contentDescription = packageManager.getApplicationLabel(packageManager.getApplicationInfo(packageName, 0));
                            }
                            catch (PackageManager.NameNotFoundException nnfe) {
                                // empty catch block
                            }
                            if (this.mStatusBar != null) {
                                this.mStatusBar.setIcon("ime", packageName, iconId, 0, contentDescription != null ? ((Object)contentDescription).toString() : null);
                                this.mStatusBar.setIconVisibility("ime", true);
                            }
                        }
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var12_8 = null;
                    Binder.restoreCallingIdentity((long)ident);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity((long)ident);
            return;
        }
        Object var12_7 = null;
        Binder.restoreCallingIdentity((long)ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needsToShowImeSwitchOngoingNotification() {
        if (!this.mShowOngoingImeSwitcherForPhones) {
            return false;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            List<InputMethodInfo> imis = this.mSettings.getEnabledInputMethodListLocked();
            int N = imis.size();
            if (N > 2) {
                return true;
            }
            if (N < 1) {
                return false;
            }
            int nonAuxCount = 0;
            int auxCount = 0;
            InputMethodSubtype nonAuxSubtype = null;
            InputMethodSubtype auxSubtype = null;
            for (int i = 0; i < N; ++i) {
                InputMethodInfo imi = imis.get(i);
                List<InputMethodSubtype> subtypes = this.getEnabledInputMethodSubtypeListLocked(imi, true);
                int subtypeCount = subtypes.size();
                if (subtypeCount == 0) {
                    ++nonAuxCount;
                    continue;
                }
                for (int j = 0; j < subtypeCount; ++j) {
                    InputMethodSubtype subtype = subtypes.get(j);
                    if (!subtype.isAuxiliary()) {
                        ++nonAuxCount;
                        nonAuxSubtype = subtype;
                        continue;
                    }
                    ++auxCount;
                    auxSubtype = subtype;
                }
            }
            if (nonAuxCount > 1 || auxCount > 1) {
                return true;
            }
            if (nonAuxCount == 1 && auxCount == 1) {
                return nonAuxSubtype == null || auxSubtype == null || !nonAuxSubtype.getLocale().equals(auxSubtype.getLocale()) && !auxSubtype.overridesImplicitlyEnabledSubtype() && !nonAuxSubtype.overridesImplicitlyEnabledSubtype() || !nonAuxSubtype.containsExtraValueKey(TAG_TRY_SUPPRESSING_IME_SWITCHER);
                {
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setImeWindowStatus(IBinder token, int vis, int backDisposition) {
        long ident;
        block11: {
            block10: {
                int uid = Binder.getCallingUid();
                ident = Binder.clearCallingIdentity();
                try {
                    if (token == null || this.mCurToken != token) {
                        Slog.w((String)TAG, (String)("Ignoring setImeWindowStatus of uid " + uid + " token: " + token));
                        Object var16_6 = null;
                        break block10;
                    }
                    HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                    synchronized (hashMap) {
                        this.mImeWindowVis = vis;
                        this.mBackDisposition = backDisposition;
                        if (this.mStatusBar != null) {
                            this.mStatusBar.setImeWindowStatus(token, vis, backDisposition);
                        }
                        boolean iconVisibility = (vis & 1) != 0;
                        InputMethodInfo imi = this.mMethodMap.get(this.mCurMethodId);
                        if (imi != null && iconVisibility && this.needsToShowImeSwitchOngoingNotification()) {
                            PackageManager pm = this.mContext.getPackageManager();
                            CharSequence title = this.mRes.getText(17040405);
                            CharSequence imiLabel = imi.loadLabel(pm);
                            CharSequence summary = this.mCurrentSubtype != null ? TextUtils.concat((CharSequence[])new CharSequence[]{this.mCurrentSubtype.getDisplayName(this.mContext, imi.getPackageName(), imi.getServiceInfo().applicationInfo), TextUtils.isEmpty((CharSequence)imiLabel) ? "" : " - " + imiLabel}) : imiLabel;
                            this.mImeSwitcherNotification.setLatestEventInfo(this.mContext, title, summary, this.mImeSwitchPendingIntent);
                            if (this.mNotificationManager != null) {
                                this.mNotificationManager.notify(17040405, this.mImeSwitcherNotification);
                                this.mNotificationShown = true;
                            }
                        } else if (this.mNotificationShown && this.mNotificationManager != null) {
                            this.mNotificationManager.cancel(17040405);
                            this.mNotificationShown = false;
                        }
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var16_8 = null;
                    Binder.restoreCallingIdentity((long)ident);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity((long)ident);
            return;
        }
        Object var16_7 = null;
        Binder.restoreCallingIdentity((long)ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSuggestionSpansForNotification(SuggestionSpan[] spans) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo currentImi = this.mMethodMap.get(this.mCurMethodId);
            for (int i = 0; i < spans.length; ++i) {
                SuggestionSpan ss = spans[i];
                if (TextUtils.isEmpty((CharSequence)ss.getNotificationTargetClassName())) continue;
                this.mSecureSuggestionSpans.put((Object)ss, (Object)currentImi);
                InputMethodInfo targetImi = (InputMethodInfo)this.mSecureSuggestionSpans.get((Object)ss);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifySuggestionPicked(SuggestionSpan span, String originalString, int index) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo targetImi = (InputMethodInfo)this.mSecureSuggestionSpans.get((Object)span);
            if (targetImi != null) {
                String[] suggestions = span.getSuggestions();
                if (index < 0 || index >= suggestions.length) {
                    return false;
                }
                String className = span.getNotificationTargetClassName();
                Intent intent = new Intent();
                intent.setClassName(targetImi.getPackageName(), className);
                intent.setAction("android.text.style.SUGGESTION_PICKED");
                intent.putExtra("before", originalString);
                intent.putExtra("after", suggestions[index]);
                intent.putExtra("hashcode", span.hashCode());
                this.mContext.sendBroadcast(intent);
                return true;
            }
        }
        return false;
    }

    void updateFromSettingsLocked() {
        String id = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"default_input_method");
        if (TextUtils.isEmpty((CharSequence)id) && this.chooseNewDefaultIMELocked()) {
            id = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"default_input_method");
        }
        if (!TextUtils.isEmpty((CharSequence)id)) {
            try {
                this.setInputMethodLocked(id, this.getSelectedInputMethodSubtypeId(id));
            }
            catch (IllegalArgumentException e) {
                Slog.w((String)TAG, (String)("Unknown input method from prefs: " + id), (Throwable)e);
                this.mCurMethodId = null;
                this.unbindCurrentMethodLocked(true);
            }
            this.mShortcutInputMethodsAndSubtypes.clear();
        } else {
            this.mCurMethodId = null;
            this.unbindCurrentMethodLocked(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInputMethodLocked(String id, int subtypeId) {
        InputMethodInfo info = this.mMethodMap.get(id);
        if (info == null) {
            throw new IllegalArgumentException("Unknown id: " + id);
        }
        if (id.equals(this.mCurMethodId)) {
            InputMethodSubtype subtype = null;
            if (subtypeId >= 0 && subtypeId < info.getSubtypeCount()) {
                subtype = info.getSubtypeAt(subtypeId);
            }
            if (subtype != this.mCurrentSubtype) {
                HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                synchronized (hashMap) {
                    if (subtype != null) {
                        this.setSelectedInputMethodAndSubtypeLocked(info, subtypeId, true);
                    }
                    if (this.mCurMethod != null) {
                        try {
                            this.refreshImeWindowVisibilityLocked();
                            if (subtype == null) {
                                subtype = this.getCurrentInputMethodSubtype();
                            }
                            this.mCurMethod.changeInputMethodSubtype(subtype);
                        }
                        catch (RemoteException e) {
                            return;
                        }
                    }
                }
            }
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.setSelectedInputMethodAndSubtypeLocked(info, subtypeId, false);
            this.mCurMethodId = id;
            if (ActivityManagerNative.isSystemReady()) {
                Intent intent = new Intent("android.intent.action.INPUT_METHOD_CHANGED");
                intent.addFlags(0x20000000);
                intent.putExtra("input_method_id", id);
                this.mContext.sendBroadcast(intent);
            }
            this.unbindCurrentClientLocked();
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean showSoftInput(IInputMethodClient client, int flags, ResultReceiver resultReceiver) {
        boolean bl;
        long ident;
        block12: {
            boolean bl2;
            block11: {
                int uid = Binder.getCallingUid();
                ident = Binder.clearCallingIdentity();
                try {
                    HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                    synchronized (hashMap) {
                        block10: {
                            if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                                try {
                                    if (this.mIWindowManager.inputMethodClientHasFocus(client)) break block10;
                                    Slog.w((String)TAG, (String)("Ignoring showSoftInput of uid " + uid + ": " + client));
                                    bl2 = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 2, 5, 9] lbl12 : MonitorExitStatement: MONITOREXIT : var7_6
                                }
                                catch (RemoteException e) {
                                    boolean bl3 = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var7_6
                                    Object var12_11 = null;
                                    Binder.restoreCallingIdentity((long)ident);
                                    return bl3;
                                }
                                Object var12_10 = null;
                                break block11;
                            }
                        }
                        bl = this.showCurrentInputLocked(flags, resultReceiver);
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    Binder.restoreCallingIdentity((long)ident);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity((long)ident);
            return bl2;
        }
        Object var12_12 = null;
        Binder.restoreCallingIdentity((long)ident);
        return bl;
    }

    boolean showCurrentInputLocked(int flags, ResultReceiver resultReceiver) {
        this.mShowRequested = true;
        if ((flags & 1) == 0) {
            this.mShowExplicitlyRequested = true;
        }
        if ((flags & 2) != 0) {
            this.mShowExplicitlyRequested = true;
            this.mShowForced = true;
        }
        if (!this.mSystemReady) {
            return false;
        }
        boolean res = false;
        if (this.mCurMethod != null) {
            this.executeOrSendMessage((IInterface)this.mCurMethod, this.mCaller.obtainMessageIOO(1020, this.getImeShowFlags(), (Object)this.mCurMethod, (Object)resultReceiver));
            this.mInputShown = true;
            if (this.mHaveConnection && !this.mVisibleBound) {
                this.mContext.bindService(this.mCurIntent, this.mVisibleConnection, 1);
                this.mVisibleBound = true;
            }
            res = true;
        } else if (this.mHaveConnection && SystemClock.uptimeMillis() >= this.mLastBindTime + 10000L) {
            EventLog.writeEvent((int)32000, (Object[])new Object[]{this.mCurMethodId, SystemClock.uptimeMillis() - this.mLastBindTime, 1});
            Slog.w((String)TAG, (String)"Force disconnect/connect to the IME in showCurrentInputLocked()");
            this.mContext.unbindService((ServiceConnection)this);
            this.mContext.bindService(this.mCurIntent, (ServiceConnection)this, 0x40000001);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hideSoftInput(IInputMethodClient client, int flags, ResultReceiver resultReceiver) {
        boolean bl;
        long ident;
        block12: {
            boolean bl2;
            block11: {
                int uid = Binder.getCallingUid();
                ident = Binder.clearCallingIdentity();
                try {
                    HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                    synchronized (hashMap) {
                        block10: {
                            if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                                try {
                                    if (this.mIWindowManager.inputMethodClientHasFocus(client)) break block10;
                                    this.setImeWindowVisibilityStatusHiddenLocked();
                                    bl2 = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 2, 5, 9] lbl11 : MonitorExitStatement: MONITOREXIT : var7_6
                                }
                                catch (RemoteException e) {
                                    this.setImeWindowVisibilityStatusHiddenLocked();
                                    boolean bl3 = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var7_6
                                    Object var12_11 = null;
                                    Binder.restoreCallingIdentity((long)ident);
                                    return bl3;
                                }
                                Object var12_10 = null;
                                break block11;
                            }
                        }
                        bl = this.hideCurrentInputLocked(flags, resultReceiver);
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    Binder.restoreCallingIdentity((long)ident);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity((long)ident);
            return bl2;
        }
        Object var12_12 = null;
        Binder.restoreCallingIdentity((long)ident);
        return bl;
    }

    boolean hideCurrentInputLocked(int flags, ResultReceiver resultReceiver) {
        boolean res;
        if ((flags & 1) != 0 && (this.mShowExplicitlyRequested || this.mShowForced)) {
            return false;
        }
        if (this.mShowForced && (flags & 2) != 0) {
            return false;
        }
        if (this.mInputShown && this.mCurMethod != null) {
            this.executeOrSendMessage((IInterface)this.mCurMethod, this.mCaller.obtainMessageOO(1030, (Object)this.mCurMethod, (Object)resultReceiver));
            res = true;
        } else {
            res = false;
        }
        if (this.mHaveConnection && this.mVisibleBound) {
            this.mContext.unbindService(this.mVisibleConnection);
            this.mVisibleBound = false;
        }
        this.mInputShown = false;
        this.mShowRequested = false;
        this.mShowExplicitlyRequested = false;
        this.mShowForced = false;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void windowGainedFocus(IInputMethodClient client, IBinder windowToken, boolean viewHasFocus, boolean isTextEditor, int softInputMode, boolean first, int windowFlags) {
        long ident;
        block23: {
            block22: {
                block21: {
                    ident = Binder.clearCallingIdentity();
                    try {
                        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
                        synchronized (hashMap) {
                            block20: {
                                if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                                    try {
                                        if (this.mIWindowManager.inputMethodClientHasFocus(client)) break block20;
                                        Slog.w((String)TAG, (String)("Client not active, ignoring focus gain of: " + client));
                                        // MONITOREXIT @DISABLED, blocks:[0, 2, 19, 5] lbl10 : MonitorExitStatement: MONITOREXIT : var10_9
                                    }
                                    catch (RemoteException e) {
                                        // empty catch block
                                        break block20;
                                    }
                                    Object var14_10 = null;
                                    break block21;
                                }
                            }
                            if (this.mCurFocusedWindow == windowToken) {
                                Slog.w((String)TAG, (String)("Window already focused, ignoring focus gain of: " + client));
                                // MONITOREXIT @DISABLED, blocks:[0, 18, 5] lbl22 : MonitorExitStatement: MONITOREXIT : var10_9
                                break block22;
                            }
                            this.mCurFocusedWindow = windowToken;
                            boolean doAutoShow = (softInputMode & 0xF0) == 16 || this.mRes.getConfiguration().isLayoutSizeAtLeast(3);
                            switch (softInputMode & 0xF) {
                                case 0: {
                                    if (!isTextEditor || !doAutoShow) {
                                        if (!WindowManager.LayoutParams.mayUseInputMethod((int)windowFlags)) break;
                                        this.hideCurrentInputLocked(2, null);
                                        break;
                                    }
                                    if (!isTextEditor || !doAutoShow || (softInputMode & 0x100) == 0) break;
                                    this.showCurrentInputLocked(1, null);
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    if ((softInputMode & 0x100) == 0) break;
                                    this.hideCurrentInputLocked(0, null);
                                    break;
                                }
                                case 3: {
                                    this.hideCurrentInputLocked(0, null);
                                    break;
                                }
                                case 4: {
                                    if ((softInputMode & 0x100) == 0) break;
                                    this.showCurrentInputLocked(1, null);
                                    break;
                                }
                                case 5: {
                                    this.showCurrentInputLocked(1, null);
                                    break;
                                }
                            }
                        }
                        break block23;
                    }
                    catch (Throwable throwable) {
                        Object var14_13 = null;
                        Binder.restoreCallingIdentity((long)ident);
                        throw throwable;
                    }
                }
                Binder.restoreCallingIdentity((long)ident);
                return;
            }
            Object var14_11 = null;
            Binder.restoreCallingIdentity((long)ident);
            return;
        }
        Object var14_12 = null;
        Binder.restoreCallingIdentity((long)ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showInputMethodPickerFromClient(IInputMethodClient client) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                Slog.w((String)TAG, (String)("Ignoring showInputMethodPickerFromClient of uid " + Binder.getCallingUid() + ": " + client));
            }
            this.mHandler.sendEmptyMessage(2);
        }
    }

    public void setInputMethod(IBinder token, String id) {
        this.setInputMethodWithSubtypeId(token, id, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputMethodAndSubtype(IBinder token, String id, InputMethodSubtype subtype) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (subtype != null) {
                this.setInputMethodWithSubtypeId(token, id, this.getSubtypeIdFromHashCode(this.mMethodMap.get(id), subtype.hashCode()));
            } else {
                this.setInputMethod(token, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient client, String inputMethodId) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (this.mCurClient == null || client == null || this.mCurClient.client.asBinder() != client.asBinder()) {
                Slog.w((String)TAG, (String)("Ignoring showInputMethodAndSubtypeEnablerFromClient of: " + client));
            }
            this.executeOrSendMessage((IInterface)this.mCurMethod, this.mCaller.obtainMessageO(3, (Object)inputMethodId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean switchToLastInputMethod(IBinder token) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            List<InputMethodInfo> enabled;
            Pair<String, String> lastIme = this.mSettings.getLastInputMethodAndSubtypeLocked();
            InputMethodInfo lastImi = lastIme != null ? this.mMethodMap.get(lastIme.first) : null;
            String targetLastImiId = null;
            int subtypeId = -1;
            if (lastIme != null && lastImi != null) {
                int currentSubtypeHash;
                boolean imiIdIsSame = lastImi.getId().equals(this.mCurMethodId);
                int lastSubtypeHash = Integer.valueOf((String)lastIme.second);
                int n = currentSubtypeHash = this.mCurrentSubtype == null ? -1 : this.mCurrentSubtype.hashCode();
                if (!imiIdIsSame || lastSubtypeHash != currentSubtypeHash) {
                    targetLastImiId = (String)lastIme.first;
                    subtypeId = this.getSubtypeIdFromHashCode(lastImi, lastSubtypeHash);
                }
            }
            if (TextUtils.isEmpty(targetLastImiId) && !this.canAddToLastInputMethod(this.mCurrentSubtype) && (enabled = this.mSettings.getEnabledInputMethodListLocked()) != null) {
                int N = enabled.size();
                String locale = this.mCurrentSubtype == null ? this.mRes.getConfiguration().locale.toString() : this.mCurrentSubtype.getLocale();
                for (int i = 0; i < N; ++i) {
                    InputMethodSubtype keyboardSubtype;
                    InputMethodInfo imi = enabled.get(i);
                    if (imi.getSubtypeCount() <= 0 || !this.isSystemIme(imi) || (keyboardSubtype = InputMethodManagerService.findLastResortApplicableSubtypeLocked(this.mRes, InputMethodManagerService.getSubtypes(imi), SUBTYPE_MODE_KEYBOARD, locale, true)) == null) continue;
                    targetLastImiId = imi.getId();
                    subtypeId = this.getSubtypeIdFromHashCode(imi, keyboardSubtype.hashCode());
                    if (keyboardSubtype.getLocale().equals(locale)) break;
                }
            }
            if (!TextUtils.isEmpty(targetLastImiId)) {
                this.setInputMethodWithSubtypeId(token, targetLastImiId, subtypeId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputMethodSubtype getLastInputMethodSubtype() {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            Pair<String, String> lastIme = this.mSettings.getLastInputMethodAndSubtypeLocked();
            if (lastIme == null || TextUtils.isEmpty((CharSequence)((CharSequence)lastIme.first)) || TextUtils.isEmpty((CharSequence)((CharSequence)lastIme.second))) {
                return null;
            }
            InputMethodInfo lastImi = this.mMethodMap.get(lastIme.first);
            if (lastImi == null) {
                return null;
            }
            try {
                int lastSubtypeHash = Integer.valueOf((String)lastIme.second);
                int lastSubtypeId = this.getSubtypeIdFromHashCode(lastImi, lastSubtypeHash);
                if (lastSubtypeId < 0 || lastSubtypeId >= lastImi.getSubtypeCount()) {
                    return null;
                }
                return lastImi.getSubtypeAt(lastSubtypeId);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdditionalInputMethodSubtypes(String imiId, InputMethodSubtype[] subtypes) {
        if (TextUtils.isEmpty((CharSequence)imiId) || subtypes == null || subtypes.length == 0) {
            return;
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo imi = this.mMethodMap.get(imiId);
            if (imi == null) {
                return;
            }
            PackageManager pm = this.mContext.getPackageManager();
            String[] packageInfos = pm.getPackagesForUid(Binder.getCallingUid());
            if (packageInfos != null) {
                int packageNum = packageInfos.length;
                for (int i = 0; i < packageNum; ++i) {
                    if (!packageInfos[i].equals(imi.getPackageName())) continue;
                    this.mFileManager.addInputMethodSubtypes(imi, subtypes);
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.buildInputMethodListLocked(this.mMethodList, this.mMethodMap);
                        Object var12_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_11 = null;
                        Binder.restoreCallingIdentity((long)ident);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity((long)ident);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInputMethodWithSubtypeId(IBinder token, String id, int subtypeId) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (token == null) {
                if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                    throw new SecurityException("Using null token requires permission android.permission.WRITE_SECURE_SETTINGS");
                }
            } else if (this.mCurToken != token) {
                Slog.w((String)TAG, (String)("Ignoring setInputMethod of uid " + Binder.getCallingUid() + " token: " + token));
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.setInputMethodLocked(id, subtypeId);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideMySoftInput(IBinder token, int flags) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (token == null || this.mCurToken != token) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.hideCurrentInputLocked(flags, null);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMySoftInput(IBinder token, int flags) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (token == null || this.mCurToken != token) {
                Slog.w((String)TAG, (String)("Ignoring showMySoftInput of uid " + Binder.getCallingUid() + " token: " + token));
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.showCurrentInputLocked(flags, null);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    void setEnabledSessionInMainThread(SessionState session) {
        if (this.mEnabledSession != session) {
            if (this.mEnabledSession != null) {
                try {
                    this.mEnabledSession.method.setSessionEnabled(this.mEnabledSession.session, false);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.mEnabledSession = session;
            try {
                session.method.setSessionEnabled(session.session, true);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.showInputMethodMenu();
                return true;
            }
            case 2: {
                this.showInputMethodSubtypeMenu();
                return true;
            }
            case 3: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                this.showInputMethodAndSubtypeEnabler((String)args.arg1);
                return true;
            }
            case 4: {
                this.showConfigureInputMethods();
                return true;
            }
            case 1000: {
                try {
                    ((IInputMethod)msg.obj).unbindInput();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 1010: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).bindInput((InputBinding)args.arg2);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 1020: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).showSoftInput(msg.arg1, (ResultReceiver)args.arg2);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 1030: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).hideSoftInput(0, (ResultReceiver)args.arg2);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 1040: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).attachToken((IBinder)args.arg2);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 1050: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                try {
                    ((IInputMethod)args.arg1).createSession((IInputMethodCallback)args.arg2);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 2000: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                try {
                    SessionState session = (SessionState)args.arg1;
                    this.setEnabledSessionInMainThread(session);
                    session.method.startInput((IInputContext)args.arg2, (EditorInfo)args.arg3);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 2010: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                try {
                    SessionState session = (SessionState)args.arg1;
                    this.setEnabledSessionInMainThread(session);
                    session.method.restartInput((IInputContext)args.arg2, (EditorInfo)args.arg3);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 3000: {
                try {
                    ((IInputMethodClient)msg.obj).onUnbindMethod(msg.arg1);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return true;
            }
            case 3010: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                try {
                    ((IInputMethodClient)args.arg1).onBindMethod((InputBindResult)args.arg2);
                }
                catch (RemoteException e) {
                    Slog.w((String)TAG, (String)("Client died receiving input method " + args.arg2));
                }
                return true;
            }
        }
        return false;
    }

    private boolean isSystemIme(InputMethodInfo inputMethod) {
        return (inputMethod.getServiceInfo().applicationInfo.flags & 1) != 0;
    }

    private static ArrayList<InputMethodSubtype> getSubtypes(InputMethodInfo imi) {
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            subtypes.add(imi.getSubtypeAt(i));
        }
        return subtypes;
    }

    private static ArrayList<InputMethodSubtype> getOverridingImplicitlyEnabledSubtypes(InputMethodInfo imi, String mode) {
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            InputMethodSubtype subtype = imi.getSubtypeAt(i);
            if (!subtype.overridesImplicitlyEnabledSubtype() || !subtype.getMode().equals(mode)) continue;
            subtypes.add(subtype);
        }
        return subtypes;
    }

    private InputMethodInfo getMostApplicableDefaultIMELocked() {
        List<InputMethodInfo> enabled = this.mSettings.getEnabledInputMethodListLocked();
        if (enabled != null && enabled.size() > 0) {
            InputMethodInfo imi;
            int i = enabled.size();
            while (i > 0 && (!this.isSystemIme(imi = enabled.get(--i)) || imi.isAuxiliaryIme())) {
            }
            return enabled.get(i);
        }
        return null;
    }

    private boolean chooseNewDefaultIMELocked() {
        InputMethodInfo imi = this.getMostApplicableDefaultIMELocked();
        if (imi != null) {
            this.resetSelectedInputMethodAndSubtypeLocked(imi.getId());
            return true;
        }
        return false;
    }

    void buildInputMethodListLocked(ArrayList<InputMethodInfo> list, HashMap<String, InputMethodInfo> map) {
        list.clear();
        map.clear();
        PackageManager pm = this.mContext.getPackageManager();
        Configuration config = this.mRes.getConfiguration();
        boolean haveHardKeyboard = config.keyboard == 2;
        String disabledSysImes = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"disabled_system_input_methods");
        if (disabledSysImes == null) {
            disabledSysImes = "";
        }
        List services = pm.queryIntentServices(new Intent("android.view.InputMethod"), 128);
        HashMap<String, List<InputMethodSubtype>> additionalSubtypes = this.mFileManager.getAllAdditionalInputMethodSubtypes();
        for (int i = 0; i < services.size(); ++i) {
            ResolveInfo ri = (ResolveInfo)services.get(i);
            ServiceInfo si = ri.serviceInfo;
            ComponentName compName = new ComponentName(si.packageName, si.name);
            if (!"android.permission.BIND_INPUT_METHOD".equals(si.permission)) {
                Slog.w((String)TAG, (String)("Skipping input method " + compName + ": it does not require the permission " + "android.permission.BIND_INPUT_METHOD"));
                continue;
            }
            try {
                InputMethodInfo p = new InputMethodInfo(this.mContext, ri, additionalSubtypes);
                list.add(p);
                String id = p.getId();
                map.put(id, p);
                if (!this.isSystemIme(p) || haveHardKeyboard && disabledSysImes.indexOf(id) >= 0) continue;
                this.setInputMethodEnabledLocked(id, true);
                continue;
            }
            catch (XmlPullParserException e) {
                Slog.w((String)TAG, (String)("Unable to load input method " + compName), (Throwable)e);
                continue;
            }
            catch (IOException e) {
                Slog.w((String)TAG, (String)("Unable to load input method " + compName), (Throwable)e);
            }
        }
        String defaultIme = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"default_input_method");
        if (!TextUtils.isEmpty((CharSequence)defaultIme) && !map.containsKey(defaultIme) && this.chooseNewDefaultIMELocked()) {
            this.updateFromSettingsLocked();
        }
    }

    private void showInputMethodMenu() {
        this.showInputMethodMenuInternal(false);
    }

    private void showInputMethodSubtypeMenu() {
        this.showInputMethodMenuInternal(true);
    }

    private void showInputMethodAndSubtypeEnabler(String inputMethodId) {
        Intent intent = new Intent("android.settings.INPUT_METHOD_SUBTYPE_SETTINGS");
        intent.setFlags(337641472);
        if (!TextUtils.isEmpty((CharSequence)inputMethodId)) {
            intent.putExtra("input_method_id", inputMethodId);
        }
        this.mContext.startActivity(intent);
    }

    private void showConfigureInputMethods() {
        Intent intent = new Intent("android.settings.INPUT_METHOD_SETTINGS");
        intent.setFlags(337641472);
        this.mContext.startActivity(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInputMethodMenuInternal(boolean showSubtypes) {
        Context context = this.mContext;
        final PackageManager pm = context.getPackageManager();
        boolean isScreenLocked = this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked() && this.mKeyguardManager.isKeyguardSecure();
        String lastInputMethodId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"default_input_method");
        int lastInputMethodSubtypeId = this.getSelectedInputMethodSubtypeId(lastInputMethodId);
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            HashMap<InputMethodInfo, List<InputMethodSubtype>> immis = this.getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked();
            if (immis == null || immis.size() == 0) {
                return;
            }
            this.hideInputMethodMenuLocked();
            TreeMap<InputMethodInfo, List<InputMethodSubtype>> sortedImmis = new TreeMap<InputMethodInfo, List<InputMethodSubtype>>(new Comparator<InputMethodInfo>(){

                @Override
                public int compare(InputMethodInfo imi1, InputMethodInfo imi2) {
                    if (imi2 == null) {
                        return 0;
                    }
                    if (imi1 == null) {
                        return 1;
                    }
                    if (pm == null) {
                        return imi1.getId().compareTo(imi2.getId());
                    }
                    String imiId1 = imi1.loadLabel(pm) + "/" + imi1.getId();
                    String imiId2 = imi2.loadLabel(pm) + "/" + imi2.getId();
                    return imiId1.toString().compareTo(imiId2.toString());
                }
            });
            sortedImmis.putAll(immis);
            ArrayList<ImeSubtypeListItem> imList = new ArrayList<ImeSubtypeListItem>();
            for (InputMethodInfo imi : sortedImmis.keySet()) {
                if (imi == null) continue;
                List<InputMethodSubtype> explicitlyOrImplicitlyEnabledSubtypeList = immis.get(imi);
                HashSet<String> enabledSubtypeSet = new HashSet<String>();
                for (InputMethodSubtype subtype : explicitlyOrImplicitlyEnabledSubtypeList) {
                    enabledSubtypeSet.add(String.valueOf(subtype.hashCode()));
                }
                ArrayList<InputMethodSubtype> subtypes = InputMethodManagerService.getSubtypes(imi);
                CharSequence imeLabel = imi.loadLabel(pm);
                if (showSubtypes && enabledSubtypeSet.size() > 0) {
                    int subtypeCount = imi.getSubtypeCount();
                    for (int j = 0; j < subtypeCount; ++j) {
                        InputMethodSubtype subtype = imi.getSubtypeAt(j);
                        String subtypeHashCode = String.valueOf(subtype.hashCode());
                        if (!enabledSubtypeSet.contains(subtypeHashCode) || (!this.mInputShown || isScreenLocked) && subtype.isAuxiliary()) continue;
                        CharSequence subtypeLabel = subtype.overridesImplicitlyEnabledSubtype() ? null : subtype.getDisplayName(context, imi.getPackageName(), imi.getServiceInfo().applicationInfo);
                        imList.add(new ImeSubtypeListItem(imeLabel, subtypeLabel, imi, j));
                        enabledSubtypeSet.remove(subtypeHashCode);
                    }
                    continue;
                }
                imList.add(new ImeSubtypeListItem(imeLabel, null, imi, -1));
            }
            int N = imList.size();
            this.mIms = new InputMethodInfo[N];
            this.mSubtypeIds = new int[N];
            int checkedItem = 0;
            for (int i = 0; i < N; ++i) {
                int subtypeId;
                ImeSubtypeListItem item = (ImeSubtypeListItem)imList.get(i);
                this.mIms[i] = item.mImi;
                this.mSubtypeIds[i] = item.mSubtypeId;
                if (!this.mIms[i].getId().equals(lastInputMethodId) || (subtypeId = this.mSubtypeIds[i]) != -1 && (lastInputMethodSubtypeId != -1 || subtypeId != 0) && subtypeId != lastInputMethodSubtypeId) continue;
                checkedItem = i;
            }
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.DialogPreference, 16842845, 0);
            this.mDialogBuilder = new AlertDialog.Builder(context).setTitle(17040405).setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    InputMethodManagerService.this.hideInputMethodMenu();
                }
            }).setIcon(a.getDrawable(0));
            a.recycle();
            ImeSubtypeListAdapter adapter = new ImeSubtypeListAdapter(context, 17367190, imList, checkedItem);
            this.mDialogBuilder.setSingleChoiceItems((ListAdapter)adapter, checkedItem, new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClick(DialogInterface dialog, int which) {
                    HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
                    synchronized (hashMap) {
                        if (InputMethodManagerService.this.mIms == null || InputMethodManagerService.this.mIms.length <= which || InputMethodManagerService.this.mSubtypeIds == null || InputMethodManagerService.this.mSubtypeIds.length <= which) {
                            return;
                        }
                        InputMethodInfo im = InputMethodManagerService.this.mIms[which];
                        int subtypeId = InputMethodManagerService.this.mSubtypeIds[which];
                        InputMethodManagerService.this.hideInputMethodMenu();
                        if (im != null) {
                            if (subtypeId < 0 || subtypeId >= im.getSubtypeCount()) {
                                subtypeId = -1;
                            }
                            InputMethodManagerService.this.setInputMethodLocked(im.getId(), subtypeId);
                        }
                    }
                }
            });
            if (showSubtypes && !isScreenLocked) {
                this.mDialogBuilder.setPositiveButton(17040406, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        InputMethodManagerService.this.showConfigureInputMethods();
                    }
                });
            }
            this.mSwitchingDialog = this.mDialogBuilder.create();
            this.mSwitchingDialog.setCanceledOnTouchOutside(true);
            this.mSwitchingDialog.getWindow().setType(2012);
            this.mSwitchingDialog.getWindow().getAttributes().setTitle((CharSequence)"Select input method");
            this.mSwitchingDialog.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideInputMethodMenu() {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            this.hideInputMethodMenuLocked();
        }
    }

    void hideInputMethodMenuLocked() {
        if (this.mSwitchingDialog != null) {
            this.mSwitchingDialog.dismiss();
            this.mSwitchingDialog = null;
        }
        this.mDialogBuilder = null;
        this.mIms = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setInputMethodEnabled(String id, boolean enabled) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            boolean bl;
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
            long ident = Binder.clearCallingIdentity();
            try {
                bl = this.setInputMethodEnabledLocked(id, enabled);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
            return bl;
        }
    }

    boolean setInputMethodEnabledLocked(String id, boolean enabled) {
        InputMethodInfo imm = this.mMethodMap.get(id);
        if (imm == null) {
            throw new IllegalArgumentException("Unknown id: " + this.mCurMethodId);
        }
        List enabledInputMethodsList = this.mSettings.getEnabledInputMethodsAndSubtypeListLocked();
        if (enabled) {
            for (Pair pair : enabledInputMethodsList) {
                if (!((String)pair.first).equals(id)) continue;
                return true;
            }
            this.mSettings.appendAndPutEnabledInputMethodLocked(id, false);
            return false;
        }
        StringBuilder builder = new StringBuilder();
        if (this.mSettings.buildAndPutEnabledInputMethodsStrRemovingIdLocked(builder, enabledInputMethodsList, id)) {
            String selId = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"default_input_method");
            if (id.equals(selId) && !this.chooseNewDefaultIMELocked()) {
                Slog.i((String)TAG, (String)"Can't find new IME, unsetting the current input method.");
                this.resetSelectedInputMethodAndSubtypeLocked("");
            }
            return true;
        }
        return false;
    }

    private boolean canAddToLastInputMethod(InputMethodSubtype subtype) {
        if (subtype == null) {
            return true;
        }
        return !subtype.isAuxiliary();
    }

    private void saveCurrentInputMethodAndSubtypeToHistory() {
        String subtypeId = NOT_A_SUBTYPE_ID_STR;
        if (this.mCurrentSubtype != null) {
            subtypeId = String.valueOf(this.mCurrentSubtype.hashCode());
        }
        if (this.canAddToLastInputMethod(this.mCurrentSubtype)) {
            this.mSettings.addSubtypeToHistory(this.mCurMethodId, subtypeId);
        }
    }

    private void setSelectedInputMethodAndSubtypeLocked(InputMethodInfo imi, int subtypeId, boolean setSubtypeOnly) {
        this.saveCurrentInputMethodAndSubtypeToHistory();
        if (imi == null || subtypeId < 0) {
            this.mSettings.putSelectedSubtype(-1);
            this.mCurrentSubtype = null;
        } else if (subtypeId < imi.getSubtypeCount()) {
            InputMethodSubtype subtype = imi.getSubtypeAt(subtypeId);
            this.mSettings.putSelectedSubtype(subtype.hashCode());
            this.mCurrentSubtype = subtype;
        } else {
            this.mSettings.putSelectedSubtype(-1);
            this.mCurrentSubtype = null;
        }
        if (!setSubtypeOnly) {
            this.mSettings.putSelectedInputMethod(imi != null ? imi.getId() : "");
        }
    }

    private void resetSelectedInputMethodAndSubtypeLocked(String newDefaultIme) {
        String subtypeHashCode;
        InputMethodInfo imi = this.mMethodMap.get(newDefaultIme);
        int lastSubtypeId = -1;
        if (imi != null && !TextUtils.isEmpty((CharSequence)newDefaultIme) && (subtypeHashCode = this.mSettings.getLastSubtypeForInputMethodLocked(newDefaultIme)) != null) {
            try {
                lastSubtypeId = this.getSubtypeIdFromHashCode(imi, Integer.valueOf(subtypeHashCode));
            }
            catch (NumberFormatException e) {
                Slog.w((String)TAG, (String)("HashCode for subtype looks broken: " + subtypeHashCode), (Throwable)e);
            }
        }
        this.setSelectedInputMethodAndSubtypeLocked(imi, lastSubtypeId, false);
    }

    private int getSelectedInputMethodSubtypeId(String id) {
        int subtypeId;
        InputMethodInfo imi = this.mMethodMap.get(id);
        if (imi == null) {
            return -1;
        }
        try {
            subtypeId = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"selected_input_method_subtype");
        }
        catch (Settings.SettingNotFoundException e) {
            return -1;
        }
        return this.getSubtypeIdFromHashCode(imi, subtypeId);
    }

    private int getSubtypeIdFromHashCode(InputMethodInfo imi, int subtypeHashCode) {
        if (imi != null) {
            int subtypeCount = imi.getSubtypeCount();
            for (int i = 0; i < subtypeCount; ++i) {
                InputMethodSubtype ims = imi.getSubtypeAt(i);
                if (subtypeHashCode != ims.hashCode()) continue;
                return i;
            }
        }
        return -1;
    }

    private static ArrayList<InputMethodSubtype> getImplicitlyApplicableSubtypesLocked(Resources res, InputMethodInfo imi) {
        InputMethodSubtype lastResortKeyboardSubtype;
        InputMethodSubtype subtype;
        int i;
        ArrayList<InputMethodSubtype> subtypes = InputMethodManagerService.getSubtypes(imi);
        String systemLocale = res.getConfiguration().locale.toString();
        if (TextUtils.isEmpty((CharSequence)systemLocale)) {
            return new ArrayList<InputMethodSubtype>();
        }
        HashMap<String, InputMethodSubtype> applicableModeAndSubtypesMap = new HashMap<String, InputMethodSubtype>();
        int N = subtypes.size();
        boolean containsKeyboardSubtype = false;
        for (i = 0; i < N; ++i) {
            String mode;
            subtype = (InputMethodSubtype)subtypes.get(i);
            if (!subtype.overridesImplicitlyEnabledSubtype() || applicableModeAndSubtypesMap.containsKey(mode = subtype.getMode())) continue;
            applicableModeAndSubtypesMap.put(mode, subtype);
        }
        if (applicableModeAndSubtypesMap.size() > 0) {
            return new ArrayList<InputMethodSubtype>(applicableModeAndSubtypesMap.values());
        }
        for (i = 0; i < N; ++i) {
            InputMethodSubtype applicableSubtype;
            subtype = (InputMethodSubtype)subtypes.get(i);
            String locale = subtype.getLocale();
            String mode = subtype.getMode();
            if (!systemLocale.startsWith(locale) || (applicableSubtype = (InputMethodSubtype)applicableModeAndSubtypesMap.get(mode)) != null && (systemLocale.equals(applicableSubtype.getLocale()) || !systemLocale.equals(locale))) continue;
            applicableModeAndSubtypesMap.put(mode, subtype);
            if (containsKeyboardSubtype || !SUBTYPE_MODE_KEYBOARD.equalsIgnoreCase(subtype.getMode())) continue;
            containsKeyboardSubtype = true;
        }
        ArrayList<InputMethodSubtype> applicableSubtypes = new ArrayList<InputMethodSubtype>(applicableModeAndSubtypesMap.values());
        if (!containsKeyboardSubtype && (lastResortKeyboardSubtype = InputMethodManagerService.findLastResortApplicableSubtypeLocked(res, subtypes, SUBTYPE_MODE_KEYBOARD, systemLocale, true)) != null) {
            applicableSubtypes.add(lastResortKeyboardSubtype);
        }
        return applicableSubtypes;
    }

    private static InputMethodSubtype findLastResortApplicableSubtypeLocked(Resources res, List<InputMethodSubtype> subtypes, String mode, String locale, boolean canIgnoreLocaleAsLastResort) {
        if (subtypes == null || subtypes.size() == 0) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)locale)) {
            locale = res.getConfiguration().locale.toString();
        }
        String language = locale.substring(0, 2);
        boolean partialMatchFound = false;
        InputMethodSubtype applicableSubtype = null;
        InputMethodSubtype firstMatchedModeSubtype = null;
        int N = subtypes.size();
        for (int i = 0; i < N; ++i) {
            InputMethodSubtype subtype = subtypes.get(i);
            String subtypeLocale = subtype.getLocale();
            if (mode != null && !subtypes.get(i).getMode().equalsIgnoreCase(mode)) continue;
            if (firstMatchedModeSubtype == null) {
                firstMatchedModeSubtype = subtype;
            }
            if (locale.equals(subtypeLocale)) {
                applicableSubtype = subtype;
                break;
            }
            if (partialMatchFound || !subtypeLocale.startsWith(language)) continue;
            applicableSubtype = subtype;
            partialMatchFound = true;
        }
        if (applicableSubtype == null && canIgnoreLocaleAsLastResort) {
            return firstMatchedModeSubtype;
        }
        return applicableSubtype;
    }

    private Pair<InputMethodInfo, InputMethodSubtype> findLastResortApplicableShortcutInputMethodAndSubtypeLocked(String mode) {
        List<InputMethodInfo> imis = this.mSettings.getEnabledInputMethodListLocked();
        InputMethodInfo mostApplicableIMI = null;
        InputMethodSubtype mostApplicableSubtype = null;
        boolean foundInSystemIME = false;
        for (InputMethodInfo imi : imis) {
            ArrayList<InputMethodSubtype> overridingImplicitlyEnabledSubtypes;
            ArrayList<InputMethodSubtype> subtypesForSearch;
            String imiId = imi.getId();
            if (foundInSystemIME && !imiId.equals(this.mCurMethodId)) continue;
            InputMethodSubtype subtype = null;
            List<InputMethodSubtype> enabledSubtypes = this.getEnabledInputMethodSubtypeList(imi, true);
            if (this.mCurrentSubtype != null) {
                subtype = InputMethodManagerService.findLastResortApplicableSubtypeLocked(this.mRes, enabledSubtypes, mode, this.mCurrentSubtype.getLocale(), false);
            }
            if (subtype == null) {
                subtype = InputMethodManagerService.findLastResortApplicableSubtypeLocked(this.mRes, enabledSubtypes, mode, null, true);
            }
            ArrayList<InputMethodSubtype> arrayList = subtypesForSearch = (overridingImplicitlyEnabledSubtypes = InputMethodManagerService.getOverridingImplicitlyEnabledSubtypes(imi, mode)).isEmpty() ? InputMethodManagerService.getSubtypes(imi) : overridingImplicitlyEnabledSubtypes;
            if (subtype == null && this.mCurrentSubtype != null) {
                subtype = InputMethodManagerService.findLastResortApplicableSubtypeLocked(this.mRes, subtypesForSearch, mode, this.mCurrentSubtype.getLocale(), false);
            }
            if (subtype == null) {
                subtype = InputMethodManagerService.findLastResortApplicableSubtypeLocked(this.mRes, subtypesForSearch, mode, null, true);
            }
            if (subtype == null) continue;
            if (imiId.equals(this.mCurMethodId)) {
                mostApplicableIMI = imi;
                mostApplicableSubtype = subtype;
                break;
            }
            if (foundInSystemIME) continue;
            mostApplicableIMI = imi;
            mostApplicableSubtype = subtype;
            if ((imi.getServiceInfo().applicationInfo.flags & 1) == 0) continue;
            foundInSystemIME = true;
        }
        if (mostApplicableIMI != null) {
            return new Pair(mostApplicableIMI, mostApplicableSubtype);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputMethodSubtype getCurrentInputMethodSubtype() {
        boolean subtypeIsSelected = false;
        try {
            subtypeIsSelected = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"selected_input_method_subtype") != -1;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            if (!subtypeIsSelected || this.mCurrentSubtype == null) {
                String lastInputMethodId = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"default_input_method");
                int subtypeId = this.getSelectedInputMethodSubtypeId(lastInputMethodId);
                if (subtypeId == -1) {
                    InputMethodInfo imi = this.mMethodMap.get(lastInputMethodId);
                    if (imi != null) {
                        List<InputMethodSubtype> explicitlyOrImplicitlyEnabledSubtypes = this.getEnabledInputMethodSubtypeList(imi, true);
                        if (explicitlyOrImplicitlyEnabledSubtypes.size() == 1) {
                            this.mCurrentSubtype = explicitlyOrImplicitlyEnabledSubtypes.get(0);
                        } else if (explicitlyOrImplicitlyEnabledSubtypes.size() > 1) {
                            this.mCurrentSubtype = InputMethodManagerService.findLastResortApplicableSubtypeLocked(this.mRes, explicitlyOrImplicitlyEnabledSubtypes, SUBTYPE_MODE_KEYBOARD, null, true);
                            if (this.mCurrentSubtype == null) {
                                this.mCurrentSubtype = InputMethodManagerService.findLastResortApplicableSubtypeLocked(this.mRes, explicitlyOrImplicitlyEnabledSubtypes, null, null, true);
                            }
                        }
                    }
                } else {
                    this.mCurrentSubtype = InputMethodManagerService.getSubtypes(this.mMethodMap.get(lastInputMethodId)).get(subtypeId);
                }
            }
            return this.mCurrentSubtype;
        }
    }

    private void addShortcutInputMethodAndSubtypes(InputMethodInfo imi, InputMethodSubtype subtype) {
        if (this.mShortcutInputMethodsAndSubtypes.containsKey(imi)) {
            this.mShortcutInputMethodsAndSubtypes.get(imi).add(subtype);
        } else {
            ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
            subtypes.add(subtype);
            this.mShortcutInputMethodsAndSubtypes.put(imi, subtypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getShortcutInputMethodsAndSubtypes() {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            ArrayList<Object> ret = new ArrayList<Object>();
            if (this.mShortcutInputMethodsAndSubtypes.size() == 0) {
                Pair<InputMethodInfo, InputMethodSubtype> info = this.findLastResortApplicableShortcutInputMethodAndSubtypeLocked(SUBTYPE_MODE_VOICE);
                if (info != null) {
                    ret.add(info.first);
                    ret.add(info.second);
                }
                return ret;
            }
            for (InputMethodInfo imi : this.mShortcutInputMethodsAndSubtypes.keySet()) {
                ret.add(imi);
                for (InputMethodSubtype subtype : this.mShortcutInputMethodsAndSubtypes.get(imi)) {
                    ret.add(subtype);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentInputMethodSubtype(InputMethodSubtype subtype) {
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            InputMethodInfo imi;
            int subtypeId;
            if (subtype != null && this.mCurMethodId != null && (subtypeId = this.getSubtypeIdFromHashCode(imi = this.mMethodMap.get(this.mCurMethodId), subtype.hashCode())) != -1) {
                this.setInputMethodLocked(this.mCurMethodId, subtypeId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IInputMethod method;
        ClientState client;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump InputMethodManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        PrintWriterPrinter p = new PrintWriterPrinter(pw);
        HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
        synchronized (hashMap) {
            p.println("Current Input Method Manager state:");
            int N = this.mMethodList.size();
            p.println("  Input Methods:");
            for (int i = 0; i < N; ++i) {
                InputMethodInfo info = this.mMethodList.get(i);
                p.println("  InputMethod #" + i + ":");
                info.dump((Printer)p, "    ");
            }
            p.println("  Clients:");
            for (ClientState ci : this.mClients.values()) {
                p.println("  Client " + ci + ":");
                p.println("    client=" + ci.client);
                p.println("    inputContext=" + ci.inputContext);
                p.println("    sessionRequested=" + ci.sessionRequested);
                p.println("    curSession=" + ci.curSession);
            }
            p.println("  mCurMethodId=" + this.mCurMethodId);
            client = this.mCurClient;
            p.println("  mCurClient=" + client + " mCurSeq=" + this.mCurSeq);
            p.println("  mCurFocusedWindow=" + this.mCurFocusedWindow);
            p.println("  mCurId=" + this.mCurId + " mHaveConnect=" + this.mHaveConnection + " mBoundToMethod=" + this.mBoundToMethod);
            p.println("  mCurToken=" + this.mCurToken);
            p.println("  mCurIntent=" + this.mCurIntent);
            method = this.mCurMethod;
            p.println("  mCurMethod=" + this.mCurMethod);
            p.println("  mEnabledSession=" + this.mEnabledSession);
            p.println("  mShowRequested=" + this.mShowRequested + " mShowExplicitlyRequested=" + this.mShowExplicitlyRequested + " mShowForced=" + this.mShowForced + " mInputShown=" + this.mInputShown);
            p.println("  mSystemReady=" + this.mSystemReady + " mScreenOn=" + this.mScreenOn);
        }
        p.println(" ");
        if (client != null) {
            pw.flush();
            try {
                client.client.asBinder().dump(fd, args);
            }
            catch (RemoteException e) {
                p.println("Input method client dead: " + (Object)((Object)e));
            }
        } else {
            p.println("No input method client.");
        }
        p.println(" ");
        if (method != null) {
            pw.flush();
            try {
                method.asBinder().dump(fd, args);
            }
            catch (RemoteException e) {
                p.println("Input method service dead: " + (Object)((Object)e));
            }
        } else {
            p.println("No input method service.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputMethodFileManager {
        private static final String SYSTEM_PATH = "system";
        private static final String INPUT_METHOD_PATH = "inputmethod";
        private static final String ADDITIONAL_SUBTYPES_FILE_NAME = "subtypes.xml";
        private static final String NODE_SUBTYPES = "subtypes";
        private static final String NODE_SUBTYPE = "subtype";
        private static final String NODE_IMI = "imi";
        private static final String ATTR_ID = "id";
        private static final String ATTR_LABEL = "label";
        private static final String ATTR_ICON = "icon";
        private static final String ATTR_IME_SUBTYPE_LOCALE = "imeSubtypeLocale";
        private static final String ATTR_IME_SUBTYPE_MODE = "imeSubtypeMode";
        private static final String ATTR_IME_SUBTYPE_EXTRA_VALUE = "imeSubtypeExtraValue";
        private static final String ATTR_IS_AUXILIARY = "isAuxiliary";
        private final AtomicFile mAdditionalInputMethodSubtypeFile;
        private final HashMap<String, InputMethodInfo> mMethodMap;
        private final HashMap<String, List<InputMethodSubtype>> mSubtypesMap = new HashMap();

        public InputMethodFileManager(HashMap<String, InputMethodInfo> methodMap) {
            if (methodMap == null) {
                throw new NullPointerException("methodMap is null");
            }
            this.mMethodMap = methodMap;
            File systemDir = new File(Environment.getDataDirectory(), SYSTEM_PATH);
            File inputMethodDir = new File(systemDir, INPUT_METHOD_PATH);
            if (!inputMethodDir.mkdirs()) {
                Slog.w((String)InputMethodManagerService.TAG, (String)("Couldn't create dir.: " + inputMethodDir.getAbsolutePath()));
            }
            File subtypeFile = new File(inputMethodDir, ADDITIONAL_SUBTYPES_FILE_NAME);
            this.mAdditionalInputMethodSubtypeFile = new AtomicFile(subtypeFile);
            if (!subtypeFile.exists()) {
                InputMethodFileManager.writeAdditionalInputMethodSubtypes(this.mSubtypesMap, this.mAdditionalInputMethodSubtypeFile, methodMap);
            } else {
                InputMethodFileManager.readAdditionalInputMethodSubtypes(this.mSubtypesMap, this.mAdditionalInputMethodSubtypeFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteAllInputMethodSubtypes(String imiId) {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                this.mSubtypesMap.remove(imiId);
                InputMethodFileManager.writeAdditionalInputMethodSubtypes(this.mSubtypesMap, this.mAdditionalInputMethodSubtypeFile, this.mMethodMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInputMethodSubtypes(InputMethodInfo imi, InputMethodSubtype[] additionalSubtypes) {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
                for (InputMethodSubtype subtype : additionalSubtypes) {
                    if (subtypes.contains(subtype)) continue;
                    subtypes.add(subtype);
                }
                this.mSubtypesMap.put(imi.getId(), subtypes);
                InputMethodFileManager.writeAdditionalInputMethodSubtypes(this.mSubtypesMap, this.mAdditionalInputMethodSubtypeFile, this.mMethodMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HashMap<String, List<InputMethodSubtype>> getAllAdditionalInputMethodSubtypes() {
            HashMap<String, InputMethodInfo> hashMap = this.mMethodMap;
            synchronized (hashMap) {
                return this.mSubtypesMap;
            }
        }

        private static void writeAdditionalInputMethodSubtypes(HashMap<String, List<InputMethodSubtype>> allSubtypes, AtomicFile subtypesFile, HashMap<String, InputMethodInfo> methodMap) {
            block5: {
                boolean isSetMethodMap = methodMap != null && methodMap.size() > 0;
                FileOutputStream fos = null;
                try {
                    fos = subtypesFile.startWrite();
                    FastXmlSerializer out = new FastXmlSerializer();
                    out.setOutput((OutputStream)fos, "utf-8");
                    out.startDocument(null, Boolean.valueOf(true));
                    out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                    out.startTag(null, NODE_SUBTYPES);
                    for (String imiId : allSubtypes.keySet()) {
                        if (isSetMethodMap && !methodMap.containsKey(imiId)) {
                            Slog.w((String)InputMethodManagerService.TAG, (String)("IME uninstalled or not valid.: " + imiId));
                            continue;
                        }
                        out.startTag(null, NODE_IMI);
                        out.attribute(null, ATTR_ID, imiId);
                        List<InputMethodSubtype> subtypesList = allSubtypes.get(imiId);
                        int N = subtypesList.size();
                        for (int i = 0; i < N; ++i) {
                            InputMethodSubtype subtype = subtypesList.get(i);
                            out.startTag(null, NODE_SUBTYPE);
                            out.attribute(null, ATTR_ICON, String.valueOf(subtype.getIconResId()));
                            out.attribute(null, ATTR_LABEL, String.valueOf(subtype.getNameResId()));
                            out.attribute(null, ATTR_IME_SUBTYPE_LOCALE, subtype.getLocale());
                            out.attribute(null, ATTR_IME_SUBTYPE_MODE, subtype.getMode());
                            out.attribute(null, ATTR_IME_SUBTYPE_EXTRA_VALUE, subtype.getExtraValue());
                            out.attribute(null, ATTR_IS_AUXILIARY, String.valueOf(subtype.isAuxiliary() ? 1 : 0));
                            out.endTag(null, NODE_SUBTYPE);
                        }
                        out.endTag(null, NODE_IMI);
                    }
                    out.endTag(null, NODE_SUBTYPES);
                    out.endDocument();
                    subtypesFile.finishWrite(fos);
                }
                catch (IOException e) {
                    Slog.w((String)InputMethodManagerService.TAG, (String)"Error writing subtypes", (Throwable)e);
                    if (fos == null) break block5;
                    subtypesFile.failWrite(fos);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void readAdditionalInputMethodSubtypes(HashMap<String, List<InputMethodSubtype>> allSubtypes, AtomicFile subtypesFile) {
            if (allSubtypes == null || subtypesFile == null) {
                return;
            }
            allSubtypes.clear();
            FileInputStream fis = null;
            fis = subtypesFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)fis, null);
            int type = parser.getEventType();
            while ((type = parser.next()) != 2 && type != 1) {
            }
            String firstNodeName = parser.getName();
            if (!NODE_SUBTYPES.equals(firstNodeName)) {
                throw new XmlPullParserException("Xml doesn't start with subtypes");
            }
            int depth = parser.getDepth();
            String currentImiId = null;
            ArrayList<InputMethodSubtype> tempSubtypesArray = null;
            while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                if (type != 2) continue;
                String nodeName = parser.getName();
                if (NODE_IMI.equals(nodeName)) {
                    currentImiId = parser.getAttributeValue(null, ATTR_ID);
                    if (TextUtils.isEmpty((CharSequence)currentImiId)) {
                        Slog.w((String)InputMethodManagerService.TAG, (String)"Invalid imi id found in subtypes.xml");
                        continue;
                    }
                    tempSubtypesArray = new ArrayList<InputMethodSubtype>();
                    allSubtypes.put(currentImiId, tempSubtypesArray);
                    continue;
                }
                if (!NODE_SUBTYPE.equals(nodeName)) continue;
                if (TextUtils.isEmpty((CharSequence)currentImiId) || tempSubtypesArray == null) {
                    Slog.w((String)InputMethodManagerService.TAG, (String)("IME uninstalled or not valid.: " + currentImiId));
                    continue;
                }
                int icon = Integer.valueOf(parser.getAttributeValue(null, ATTR_ICON));
                int label = Integer.valueOf(parser.getAttributeValue(null, ATTR_LABEL));
                String imeSubtypeLocale = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_LOCALE);
                String imeSubtypeMode = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_MODE);
                String imeSubtypeExtraValue = parser.getAttributeValue(null, ATTR_IME_SUBTYPE_EXTRA_VALUE);
                boolean isAuxiliary = "1".equals(String.valueOf(parser.getAttributeValue(null, ATTR_IS_AUXILIARY)));
                InputMethodSubtype subtype = new InputMethodSubtype(label, icon, imeSubtypeLocale, imeSubtypeMode, imeSubtypeExtraValue, isAuxiliary);
                tempSubtypesArray.add(subtype);
            }
            Object var18_20 = null;
            if (fis == null) return;
            try {
                fis.close();
                return;
            }
            catch (IOException e1) {
                Slog.w((String)InputMethodManagerService.TAG, (String)"Failed to close.");
            }
            return;
            {
                catch (XmlPullParserException e) {
                    Slog.w((String)InputMethodManagerService.TAG, (String)("Error reading subtypes: " + (Object)((Object)e)));
                    Object var18_21 = null;
                    if (fis == null) return;
                    try {
                        fis.close();
                        return;
                    }
                    catch (IOException e1) {
                        Slog.w((String)InputMethodManagerService.TAG, (String)"Failed to close.");
                    }
                    return;
                }
                catch (IOException e) {
                    Slog.w((String)InputMethodManagerService.TAG, (String)("Error reading subtypes: " + e));
                    Object var18_22 = null;
                    if (fis == null) return;
                    try {
                        fis.close();
                        return;
                    }
                    catch (IOException e1) {
                        Slog.w((String)InputMethodManagerService.TAG, (String)"Failed to close.");
                    }
                    return;
                }
                catch (NumberFormatException e) {
                    Slog.w((String)InputMethodManagerService.TAG, (String)("Error reading subtypes: " + e));
                    Object var18_23 = null;
                    if (fis == null) return;
                    try {
                        fis.close();
                        return;
                    }
                    catch (IOException e1) {
                        Slog.w((String)InputMethodManagerService.TAG, (String)"Failed to close.");
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var18_24 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException e1) {
                    Slog.w((String)InputMethodManagerService.TAG, (String)"Failed to close.");
                }
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputMethodSettings {
        private static final char INPUT_METHOD_SEPARATER = ':';
        private static final char INPUT_METHOD_SUBTYPE_SEPARATER = ';';
        private final TextUtils.SimpleStringSplitter mInputMethodSplitter = new TextUtils.SimpleStringSplitter(':');
        private final TextUtils.SimpleStringSplitter mSubtypeSplitter = new TextUtils.SimpleStringSplitter(';');
        private final Resources mRes;
        private final ContentResolver mResolver;
        private final HashMap<String, InputMethodInfo> mMethodMap;
        private final ArrayList<InputMethodInfo> mMethodList;
        private String mEnabledInputMethodsStrCache;

        private static void buildEnabledInputMethodsSettingString(StringBuilder builder, Pair<String, ArrayList<String>> pair) {
            String id = (String)pair.first;
            ArrayList subtypes = (ArrayList)pair.second;
            builder.append(id);
            for (String subtypeId : subtypes) {
                builder.append(';').append(subtypeId);
            }
        }

        public InputMethodSettings(Resources res, ContentResolver resolver, HashMap<String, InputMethodInfo> methodMap, ArrayList<InputMethodInfo> methodList) {
            this.mRes = res;
            this.mResolver = resolver;
            this.mMethodMap = methodMap;
            this.mMethodList = methodList;
        }

        public List<InputMethodInfo> getEnabledInputMethodListLocked() {
            return this.createEnabledInputMethodListLocked(this.getEnabledInputMethodsAndSubtypeListLocked());
        }

        public List<Pair<InputMethodInfo, ArrayList<String>>> getEnabledInputMethodAndSubtypeHashCodeListLocked() {
            return this.createEnabledInputMethodAndSubtypeHashCodeListLocked(this.getEnabledInputMethodsAndSubtypeListLocked());
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(InputMethodInfo imi) {
            List<Pair<String, ArrayList<String>>> imsList = this.getEnabledInputMethodsAndSubtypeListLocked();
            ArrayList<InputMethodSubtype> enabledSubtypes = new ArrayList<InputMethodSubtype>();
            if (imi != null) {
                for (Pair<String, ArrayList<String>> imsPair : imsList) {
                    InputMethodInfo info = this.mMethodMap.get(imsPair.first);
                    if (info == null || !info.getId().equals(imi.getId())) continue;
                    int subtypeCount = info.getSubtypeCount();
                    for (int i = 0; i < subtypeCount; ++i) {
                        InputMethodSubtype ims = info.getSubtypeAt(i);
                        for (String s : (ArrayList)imsPair.second) {
                            if (!String.valueOf(ims.hashCode()).equals(s)) continue;
                            enabledSubtypes.add(ims);
                        }
                    }
                }
            }
            return enabledSubtypes;
        }

        public void enableAllIMEsIfThereIsNoEnabledIME() {
            if (TextUtils.isEmpty((CharSequence)this.getEnabledInputMethodsStr())) {
                StringBuilder sb = new StringBuilder();
                int N = this.mMethodList.size();
                for (int i = 0; i < N; ++i) {
                    InputMethodInfo imi = this.mMethodList.get(i);
                    Slog.i((String)InputMethodManagerService.TAG, (String)("Adding: " + imi.getId()));
                    if (i > 0) {
                        sb.append(':');
                    }
                    sb.append(imi.getId());
                }
                this.putEnabledInputMethodsStr(sb.toString());
            }
        }

        private List<Pair<String, ArrayList<String>>> getEnabledInputMethodsAndSubtypeListLocked() {
            ArrayList<Pair<String, ArrayList<String>>> imsList = new ArrayList<Pair<String, ArrayList<String>>>();
            String enabledInputMethodsStr = this.getEnabledInputMethodsStr();
            if (TextUtils.isEmpty((CharSequence)enabledInputMethodsStr)) {
                return imsList;
            }
            this.mInputMethodSplitter.setString(enabledInputMethodsStr);
            while (this.mInputMethodSplitter.hasNext()) {
                String nextImsStr = this.mInputMethodSplitter.next();
                this.mSubtypeSplitter.setString(nextImsStr);
                if (!this.mSubtypeSplitter.hasNext()) continue;
                ArrayList<String> subtypeHashes = new ArrayList<String>();
                String imeId = this.mSubtypeSplitter.next();
                while (this.mSubtypeSplitter.hasNext()) {
                    subtypeHashes.add(this.mSubtypeSplitter.next());
                }
                imsList.add((Pair<String, ArrayList<String>>)new Pair((Object)imeId, subtypeHashes));
            }
            return imsList;
        }

        public void appendAndPutEnabledInputMethodLocked(String id, boolean reloadInputMethodStr) {
            if (reloadInputMethodStr) {
                this.getEnabledInputMethodsStr();
            }
            if (TextUtils.isEmpty((CharSequence)this.mEnabledInputMethodsStrCache)) {
                this.putEnabledInputMethodsStr(id);
            } else {
                this.putEnabledInputMethodsStr(this.mEnabledInputMethodsStrCache + ':' + id);
            }
        }

        public boolean buildAndPutEnabledInputMethodsStrRemovingIdLocked(StringBuilder builder, List<Pair<String, ArrayList<String>>> imsList, String id) {
            boolean isRemoved = false;
            boolean needsAppendSeparator = false;
            for (Pair<String, ArrayList<String>> ims : imsList) {
                String curId = (String)ims.first;
                if (curId.equals(id)) {
                    isRemoved = true;
                    continue;
                }
                if (needsAppendSeparator) {
                    builder.append(':');
                } else {
                    needsAppendSeparator = true;
                }
                InputMethodSettings.buildEnabledInputMethodsSettingString(builder, ims);
            }
            if (isRemoved) {
                this.putEnabledInputMethodsStr(builder.toString());
            }
            return isRemoved;
        }

        private List<InputMethodInfo> createEnabledInputMethodListLocked(List<Pair<String, ArrayList<String>>> imsList) {
            ArrayList<InputMethodInfo> res = new ArrayList<InputMethodInfo>();
            for (Pair<String, ArrayList<String>> ims : imsList) {
                InputMethodInfo info = this.mMethodMap.get(ims.first);
                if (info == null) continue;
                res.add(info);
            }
            return res;
        }

        private List<Pair<InputMethodInfo, ArrayList<String>>> createEnabledInputMethodAndSubtypeHashCodeListLocked(List<Pair<String, ArrayList<String>>> imsList) {
            ArrayList<Pair<InputMethodInfo, ArrayList<String>>> res = new ArrayList<Pair<InputMethodInfo, ArrayList<String>>>();
            for (Pair<String, ArrayList<String>> ims : imsList) {
                InputMethodInfo info = this.mMethodMap.get(ims.first);
                if (info == null) continue;
                res.add((Pair<InputMethodInfo, ArrayList<String>>)new Pair((Object)info, ims.second));
            }
            return res;
        }

        private void putEnabledInputMethodsStr(String str) {
            Settings.Secure.putString((ContentResolver)this.mResolver, (String)"enabled_input_methods", (String)str);
            this.mEnabledInputMethodsStrCache = str;
        }

        private String getEnabledInputMethodsStr() {
            this.mEnabledInputMethodsStrCache = Settings.Secure.getString((ContentResolver)this.mResolver, (String)"enabled_input_methods");
            return this.mEnabledInputMethodsStrCache;
        }

        private void saveSubtypeHistory(List<Pair<String, String>> savedImes, String newImeId, String newSubtypeId) {
            StringBuilder builder = new StringBuilder();
            boolean isImeAdded = false;
            if (!TextUtils.isEmpty((CharSequence)newImeId) && !TextUtils.isEmpty((CharSequence)newSubtypeId)) {
                builder.append(newImeId).append(';').append(newSubtypeId);
                isImeAdded = true;
            }
            for (Pair<String, String> ime : savedImes) {
                String imeId = (String)ime.first;
                String subtypeId = (String)ime.second;
                if (TextUtils.isEmpty((CharSequence)subtypeId)) {
                    subtypeId = NOT_A_SUBTYPE_ID_STR;
                }
                if (isImeAdded) {
                    builder.append(':');
                } else {
                    isImeAdded = true;
                }
                builder.append(imeId).append(';').append(subtypeId);
            }
            this.putSubtypeHistoryStr(builder.toString());
        }

        public void addSubtypeToHistory(String imeId, String subtypeId) {
            List<Pair<String, String>> subtypeHistory = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> ime : subtypeHistory) {
                if (!((String)ime.first).equals(imeId)) continue;
                subtypeHistory.remove(ime);
                break;
            }
            this.saveSubtypeHistory(subtypeHistory, imeId, subtypeId);
        }

        private void putSubtypeHistoryStr(String str) {
            Settings.Secure.putString((ContentResolver)this.mResolver, (String)"input_methods_subtype_history", (String)str);
        }

        public Pair<String, String> getLastInputMethodAndSubtypeLocked() {
            return this.getLastSubtypeForInputMethodLockedInternal(null);
        }

        public String getLastSubtypeForInputMethodLocked(String imeId) {
            Pair<String, String> ime = this.getLastSubtypeForInputMethodLockedInternal(imeId);
            if (ime != null) {
                return (String)ime.second;
            }
            return null;
        }

        private Pair<String, String> getLastSubtypeForInputMethodLockedInternal(String imeId) {
            List<Pair<String, ArrayList<String>>> enabledImes = this.getEnabledInputMethodsAndSubtypeListLocked();
            List<Pair<String, String>> subtypeHistory = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> imeAndSubtype : subtypeHistory) {
                String subtypeInTheHistory;
                String subtypeHashCode;
                String imeInTheHistory = (String)imeAndSubtype.first;
                if (!TextUtils.isEmpty((CharSequence)imeId) && !imeInTheHistory.equals(imeId) || TextUtils.isEmpty((CharSequence)(subtypeHashCode = this.getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(enabledImes, imeInTheHistory, subtypeInTheHistory = (String)imeAndSubtype.second)))) continue;
                return new Pair((Object)imeInTheHistory, (Object)subtypeHashCode);
            }
            return null;
        }

        private String getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(List<Pair<String, ArrayList<String>>> enabledImes, String imeId, String subtypeHashCode) {
            for (Pair<String, ArrayList<String>> enabledIme : enabledImes) {
                if (!((String)enabledIme.first).equals(imeId)) continue;
                ArrayList explicitlyEnabledSubtypes = (ArrayList)enabledIme.second;
                if (explicitlyEnabledSubtypes.size() == 0) {
                    ArrayList implicitlySelectedSubtypes;
                    InputMethodInfo imi = this.mMethodMap.get(imeId);
                    if (imi != null && imi.getSubtypeCount() > 0 && (implicitlySelectedSubtypes = InputMethodManagerService.getImplicitlyApplicableSubtypesLocked(this.mRes, imi)) != null) {
                        int N = implicitlySelectedSubtypes.size();
                        for (int i = 0; i < N; ++i) {
                            InputMethodSubtype st = (InputMethodSubtype)implicitlySelectedSubtypes.get(i);
                            if (!String.valueOf(st.hashCode()).equals(subtypeHashCode)) continue;
                            return subtypeHashCode;
                        }
                    }
                } else {
                    for (String s : explicitlyEnabledSubtypes) {
                        if (!s.equals(subtypeHashCode)) continue;
                        return s;
                    }
                }
                return NOT_A_SUBTYPE_ID_STR;
            }
            return null;
        }

        private List<Pair<String, String>> loadInputMethodAndSubtypeHistoryLocked() {
            ArrayList<Pair<String, String>> imsList = new ArrayList<Pair<String, String>>();
            String subtypeHistoryStr = this.getSubtypeHistoryStr();
            if (TextUtils.isEmpty((CharSequence)subtypeHistoryStr)) {
                return imsList;
            }
            this.mInputMethodSplitter.setString(subtypeHistoryStr);
            while (this.mInputMethodSplitter.hasNext()) {
                String nextImsStr = this.mInputMethodSplitter.next();
                this.mSubtypeSplitter.setString(nextImsStr);
                if (!this.mSubtypeSplitter.hasNext()) continue;
                String subtypeId = NOT_A_SUBTYPE_ID_STR;
                String imeId = this.mSubtypeSplitter.next();
                if (this.mSubtypeSplitter.hasNext()) {
                    subtypeId = this.mSubtypeSplitter.next();
                }
                imsList.add((Pair<String, String>)new Pair((Object)imeId, (Object)subtypeId));
            }
            return imsList;
        }

        private String getSubtypeHistoryStr() {
            return Settings.Secure.getString((ContentResolver)this.mResolver, (String)"input_methods_subtype_history");
        }

        public void putSelectedInputMethod(String imeId) {
            Settings.Secure.putString((ContentResolver)this.mResolver, (String)"default_input_method", (String)imeId);
        }

        public void putSelectedSubtype(int subtypeId) {
            Settings.Secure.putInt((ContentResolver)this.mResolver, (String)"selected_input_method_subtype", (int)subtypeId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImeSubtypeListAdapter
    extends ArrayAdapter<ImeSubtypeListItem> {
        private final LayoutInflater mInflater;
        private final int mTextViewResourceId;
        private final List<ImeSubtypeListItem> mItemsList;
        private final int mCheckedItem;

        public ImeSubtypeListAdapter(Context context, int textViewResourceId, List<ImeSubtypeListItem> itemsList, int checkedItem) {
            super(context, textViewResourceId, itemsList);
            this.mTextViewResourceId = textViewResourceId;
            this.mItemsList = itemsList;
            this.mCheckedItem = checkedItem;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View view;
            View view2 = view = convertView != null ? convertView : this.mInflater.inflate(this.mTextViewResourceId, null);
            if (position < 0 || position >= this.mItemsList.size()) {
                return view;
            }
            ImeSubtypeListItem item = this.mItemsList.get(position);
            CharSequence imeName = item.mImeName;
            CharSequence subtypeName = item.mSubtypeName;
            TextView firstTextView = (TextView)view.findViewById(16908308);
            TextView secondTextView = (TextView)view.findViewById(16908309);
            if (TextUtils.isEmpty((CharSequence)subtypeName)) {
                firstTextView.setText(imeName);
                secondTextView.setVisibility(8);
            } else {
                firstTextView.setText(subtypeName);
                secondTextView.setText(imeName);
                secondTextView.setVisibility(0);
            }
            RadioButton radioButton = (RadioButton)view.findViewById(16908989);
            radioButton.setChecked(position == this.mCheckedItem);
            return view;
        }
    }

    private static class ImeSubtypeListItem {
        public final CharSequence mImeName;
        public final CharSequence mSubtypeName;
        public final InputMethodInfo mImi;
        public final int mSubtypeId;

        public ImeSubtypeListItem(CharSequence imeName, CharSequence subtypeName, InputMethodInfo imi, int subtypeId) {
            this.mImeName = imeName;
            this.mSubtypeName = subtypeName;
            this.mImi = imi;
            this.mSubtypeId = subtypeId;
        }
    }

    private static class MethodCallback
    extends IInputMethodCallback.Stub {
        private final IInputMethod mMethod;
        private final InputMethodManagerService mParentIMMS;

        MethodCallback(IInputMethod method, InputMethodManagerService imms) {
            this.mMethod = method;
            this.mParentIMMS = imms;
        }

        public void finishedEvent(int seq, boolean handled) throws RemoteException {
        }

        public void sessionCreated(IInputMethodSession session) throws RemoteException {
            this.mParentIMMS.onSessionCreated(this.mMethod, session);
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                String curInputMethodId = Settings.Secure.getString((ContentResolver)InputMethodManagerService.this.mContext.getContentResolver(), (String)"default_input_method");
                int N = InputMethodManagerService.this.mMethodList.size();
                if (curInputMethodId != null) {
                    for (int i = 0; i < N; ++i) {
                        InputMethodInfo imi = InputMethodManagerService.this.mMethodList.get(i);
                        if (!imi.getId().equals(curInputMethodId)) continue;
                        for (String pkg : packages) {
                            if (!imi.getPackageName().equals(pkg)) continue;
                            if (!doit) {
                                return true;
                            }
                            InputMethodManagerService.this.resetSelectedInputMethodAndSubtypeLocked("");
                            InputMethodManagerService.this.chooseNewDefaultIMELocked();
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSomePackagesChanged() {
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                int change;
                InputMethodInfo curIm = null;
                String curInputMethodId = Settings.Secure.getString((ContentResolver)InputMethodManagerService.this.mContext.getContentResolver(), (String)"default_input_method");
                int N = InputMethodManagerService.this.mMethodList.size();
                if (curInputMethodId != null) {
                    for (int i = 0; i < N; ++i) {
                        InputMethodInfo imi = InputMethodManagerService.this.mMethodList.get(i);
                        String imiId = imi.getId();
                        if (imiId.equals(curInputMethodId)) {
                            curIm = imi;
                        }
                        int change2 = this.isPackageDisappearing(imi.getPackageName());
                        if (this.isPackageModified(imi.getPackageName())) {
                            InputMethodManagerService.this.mFileManager.deleteAllInputMethodSubtypes(imiId);
                        }
                        if (change2 != 2 && change2 != 3) continue;
                        Slog.i((String)InputMethodManagerService.TAG, (String)("Input method uninstalled, disabling: " + imi.getComponent()));
                        InputMethodManagerService.this.setInputMethodEnabledLocked(imi.getId(), false);
                    }
                }
                InputMethodManagerService.this.buildInputMethodListLocked(InputMethodManagerService.this.mMethodList, InputMethodManagerService.this.mMethodMap);
                boolean changed = false;
                if (curIm != null && ((change = this.isPackageDisappearing(curIm.getPackageName())) == 2 || change == 3)) {
                    ServiceInfo si = null;
                    try {
                        si = InputMethodManagerService.this.mContext.getPackageManager().getServiceInfo(curIm.getComponent(), 0);
                    }
                    catch (PackageManager.NameNotFoundException ex) {
                        // empty catch block
                    }
                    if (si == null) {
                        Slog.i((String)InputMethodManagerService.TAG, (String)("Current input method removed: " + curInputMethodId));
                        InputMethodManagerService.this.setImeWindowVisibilityStatusHiddenLocked();
                        if (!InputMethodManagerService.this.chooseNewDefaultIMELocked()) {
                            changed = true;
                            curIm = null;
                            Slog.i((String)InputMethodManagerService.TAG, (String)"Unsetting current input method");
                            InputMethodManagerService.this.resetSelectedInputMethodAndSubtypeLocked("");
                        }
                    }
                }
                if (curIm == null) {
                    changed = InputMethodManagerService.this.chooseNewDefaultIMELocked();
                }
                if (changed) {
                    InputMethodManagerService.this.updateFromSettingsLocked();
                }
            }
        }
    }

    class ScreenOnOffReceiver
    extends BroadcastReceiver {
        ScreenOnOffReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
                InputMethodManagerService.this.mScreenOn = true;
                InputMethodManagerService.this.refreshImeWindowVisibilityLocked();
            } else if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                InputMethodManagerService.this.mScreenOn = false;
                InputMethodManagerService.this.setImeWindowVisibilityStatusHiddenLocked();
            } else {
                if (intent.getAction().equals("android.intent.action.CLOSE_SYSTEM_DIALOGS")) {
                    InputMethodManagerService.this.hideInputMethodMenu();
                    return;
                }
                Slog.w((String)InputMethodManagerService.TAG, (String)("Unexpected intent " + intent));
            }
            try {
                if (InputMethodManagerService.this.mCurClient != null && InputMethodManagerService.this.mCurClient.client != null) {
                    InputMethodManagerService.this.mCurClient.client.setActive(InputMethodManagerService.this.mScreenOn);
                }
            }
            catch (RemoteException e) {
                Slog.w((String)InputMethodManagerService.TAG, (String)("Got RemoteException sending 'screen on/off' notification to pid " + InputMethodManagerService.this.mCurClient.pid + " uid " + InputMethodManagerService.this.mCurClient.uid));
            }
        }
    }

    class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
            ContentResolver resolver = InputMethodManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"default_input_method"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"enabled_input_methods"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"selected_input_method_subtype"), false, (ContentObserver)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange) {
            HashMap<String, InputMethodInfo> hashMap = InputMethodManagerService.this.mMethodMap;
            synchronized (hashMap) {
                InputMethodManagerService.this.updateFromSettingsLocked();
            }
        }
    }

    class ClientState {
        final IInputMethodClient client;
        final IInputContext inputContext;
        final int uid;
        final int pid;
        final InputBinding binding;
        boolean sessionRequested;
        SessionState curSession;

        public String toString() {
            return "ClientState{" + Integer.toHexString(System.identityHashCode(this)) + " uid " + this.uid + " pid " + this.pid + "}";
        }

        ClientState(IInputMethodClient _client, IInputContext _inputContext, int _uid, int _pid) {
            this.client = _client;
            this.inputContext = _inputContext;
            this.uid = _uid;
            this.pid = _pid;
            this.binding = new InputBinding(null, this.inputContext.asBinder(), this.uid, this.pid);
        }
    }

    class SessionState {
        final ClientState client;
        final IInputMethod method;
        final IInputMethodSession session;

        public String toString() {
            return "SessionState{uid " + this.client.uid + " pid " + this.client.pid + " method " + Integer.toHexString(System.identityHashCode(this.method)) + " session " + Integer.toHexString(System.identityHashCode(this.session)) + "}";
        }

        SessionState(ClientState _client, IInputMethod _method, IInputMethodSession _session) {
            this.client = _client;
            this.method = _method;
            this.session = _session;
        }
    }
}

