/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.util.FastImmutableArraySet;
import android.util.PrintWriterPrinter;
import android.util.Printer;
import android.util.Slog;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntentResolver<F extends IntentFilter, R> {
    private static final String TAG = "IntentResolver";
    private static final boolean DEBUG = false;
    private static final boolean localLOGV = false;
    private static final Comparator mResolvePrioritySorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            int q2;
            int q1 = ((IntentFilter)o1).getPriority();
            return q1 > (q2 = ((IntentFilter)o2).getPriority()) ? -1 : (q1 < q2 ? 1 : 0);
        }
    };
    private final HashSet<F> mFilters = new HashSet();
    private final HashMap<String, ArrayList<F>> mTypeToFilter = new HashMap();
    private final HashMap<String, ArrayList<F>> mBaseTypeToFilter = new HashMap();
    private final HashMap<String, ArrayList<F>> mWildTypeToFilter = new HashMap();
    private final HashMap<String, ArrayList<F>> mSchemeToFilter = new HashMap();
    private final HashMap<String, ArrayList<F>> mActionToFilter = new HashMap();
    private final HashMap<String, ArrayList<F>> mTypedActionToFilter = new HashMap();

    public void addFilter(F f) {
        this.mFilters.add(f);
        int numS = this.register_intent_filter(f, f.schemesIterator(), this.mSchemeToFilter, "      Scheme: ");
        int numT = this.register_mime_types(f, "      Type: ");
        if (numS == 0 && numT == 0) {
            this.register_intent_filter(f, f.actionsIterator(), this.mActionToFilter, "      Action: ");
        }
        if (numT != 0) {
            this.register_intent_filter(f, f.actionsIterator(), this.mTypedActionToFilter, "      TypedAction: ");
        }
    }

    public void removeFilter(F f) {
        this.removeFilterInternal(f);
        this.mFilters.remove(f);
    }

    void removeFilterInternal(F f) {
        int numS = this.unregister_intent_filter(f, f.schemesIterator(), this.mSchemeToFilter, "      Scheme: ");
        int numT = this.unregister_mime_types(f, "      Type: ");
        if (numS == 0 && numT == 0) {
            this.unregister_intent_filter(f, f.actionsIterator(), this.mActionToFilter, "      Action: ");
        }
        if (numT != 0) {
            this.unregister_intent_filter(f, f.actionsIterator(), this.mTypedActionToFilter, "      TypedAction: ");
        }
    }

    boolean dumpMap(PrintWriter out, String titlePrefix, String title, String prefix, Map<String, ArrayList<F>> map, String packageName, boolean printFilter) {
        String eprefix = prefix + "  ";
        String fprefix = prefix + "    ";
        boolean printedSomething = false;
        PrintWriterPrinter printer = null;
        for (Map.Entry<String, ArrayList<F>> e : map.entrySet()) {
            ArrayList<F> a = e.getValue();
            int N = a.size();
            boolean printedHeader = false;
            for (int i = 0; i < N; ++i) {
                IntentFilter filter = (IntentFilter)a.get(i);
                if (packageName != null && !packageName.equals(this.packageForFilter(filter))) continue;
                if (title != null) {
                    out.print(titlePrefix);
                    out.println(title);
                    title = null;
                }
                if (!printedHeader) {
                    out.print(eprefix);
                    out.print(e.getKey());
                    out.println(":");
                    printedHeader = true;
                }
                printedSomething = true;
                this.dumpFilter(out, fprefix, filter);
                if (!printFilter) continue;
                if (printer == null) {
                    printer = new PrintWriterPrinter(out);
                }
                filter.dump((Printer)printer, fprefix + "  ");
            }
        }
        return printedSomething;
    }

    public boolean dump(PrintWriter out, String title, String prefix, String packageName, boolean printFilter) {
        String innerPrefix = prefix + "  ";
        String sepPrefix = "\n" + prefix;
        String curPrefix = title + "\n" + prefix;
        if (this.dumpMap(out, curPrefix, "Full MIME Types:", innerPrefix, this.mTypeToFilter, packageName, printFilter)) {
            curPrefix = sepPrefix;
        }
        if (this.dumpMap(out, curPrefix, "Base MIME Types:", innerPrefix, this.mBaseTypeToFilter, packageName, printFilter)) {
            curPrefix = sepPrefix;
        }
        if (this.dumpMap(out, curPrefix, "Wild MIME Types:", innerPrefix, this.mWildTypeToFilter, packageName, printFilter)) {
            curPrefix = sepPrefix;
        }
        if (this.dumpMap(out, curPrefix, "Schemes:", innerPrefix, this.mSchemeToFilter, packageName, printFilter)) {
            curPrefix = sepPrefix;
        }
        if (this.dumpMap(out, curPrefix, "Non-Data Actions:", innerPrefix, this.mActionToFilter, packageName, printFilter)) {
            curPrefix = sepPrefix;
        }
        if (this.dumpMap(out, curPrefix, "MIME Typed Actions:", innerPrefix, this.mTypedActionToFilter, packageName, printFilter)) {
            curPrefix = sepPrefix;
        }
        return curPrefix == sepPrefix;
    }

    public Iterator<F> filterIterator() {
        return new IteratorWrapper(this.mFilters.iterator());
    }

    public Set<F> filterSet() {
        return Collections.unmodifiableSet(this.mFilters);
    }

    public List<R> queryIntentFromList(Intent intent, String resolvedType, boolean defaultOnly, ArrayList<ArrayList<F>> listCut) {
        ArrayList resultList = new ArrayList();
        boolean debug = (intent.getFlags() & 8) != 0;
        FastImmutableArraySet<String> categories = IntentResolver.getFastIntentCategories(intent);
        String scheme = intent.getScheme();
        int N = listCut.size();
        for (int i = 0; i < N; ++i) {
            this.buildResolveList(intent, categories, debug, defaultOnly, resolvedType, scheme, (List)listCut.get(i), resultList);
        }
        this.sortResults(resultList);
        return resultList;
    }

    public List<R> queryIntent(Intent intent, String resolvedType, boolean defaultOnly) {
        int slashpos;
        boolean debug;
        String scheme = intent.getScheme();
        ArrayList finalList = new ArrayList();
        boolean bl = debug = (intent.getFlags() & 8) != 0;
        if (debug) {
            Slog.v((String)TAG, (String)("Resolving type " + resolvedType + " scheme " + scheme + " of intent " + intent));
        }
        ArrayList<F> firstTypeCut = null;
        ArrayList<F> secondTypeCut = null;
        ArrayList<F> thirdTypeCut = null;
        ArrayList<F> schemeCut = null;
        if (resolvedType != null && (slashpos = resolvedType.indexOf(47)) > 0) {
            String baseType = resolvedType.substring(0, slashpos);
            if (!baseType.equals("*")) {
                if (resolvedType.length() != slashpos + 2 || resolvedType.charAt(slashpos + 1) != '*') {
                    firstTypeCut = this.mTypeToFilter.get(resolvedType);
                    if (debug) {
                        Slog.v((String)TAG, (String)("First type cut: " + firstTypeCut));
                    }
                    secondTypeCut = this.mWildTypeToFilter.get(baseType);
                    if (debug) {
                        Slog.v((String)TAG, (String)("Second type cut: " + secondTypeCut));
                    }
                } else {
                    firstTypeCut = this.mBaseTypeToFilter.get(baseType);
                    if (debug) {
                        Slog.v((String)TAG, (String)("First type cut: " + firstTypeCut));
                    }
                    secondTypeCut = this.mWildTypeToFilter.get(baseType);
                    if (debug) {
                        Slog.v((String)TAG, (String)("Second type cut: " + secondTypeCut));
                    }
                }
                thirdTypeCut = this.mWildTypeToFilter.get("*");
                if (debug) {
                    Slog.v((String)TAG, (String)("Third type cut: " + thirdTypeCut));
                }
            } else if (intent.getAction() != null) {
                firstTypeCut = this.mTypedActionToFilter.get(intent.getAction());
                if (debug) {
                    Slog.v((String)TAG, (String)("Typed Action list: " + firstTypeCut));
                }
            }
        }
        if (scheme != null) {
            schemeCut = this.mSchemeToFilter.get(scheme);
            if (debug) {
                Slog.v((String)TAG, (String)("Scheme list: " + schemeCut));
            }
        }
        if (resolvedType == null && scheme == null && intent.getAction() != null) {
            firstTypeCut = this.mActionToFilter.get(intent.getAction());
            if (debug) {
                Slog.v((String)TAG, (String)("Action list: " + firstTypeCut));
            }
        }
        FastImmutableArraySet<String> categories = IntentResolver.getFastIntentCategories(intent);
        if (firstTypeCut != null) {
            this.buildResolveList(intent, categories, debug, defaultOnly, resolvedType, scheme, firstTypeCut, finalList);
        }
        if (secondTypeCut != null) {
            this.buildResolveList(intent, categories, debug, defaultOnly, resolvedType, scheme, secondTypeCut, finalList);
        }
        if (thirdTypeCut != null) {
            this.buildResolveList(intent, categories, debug, defaultOnly, resolvedType, scheme, thirdTypeCut, finalList);
        }
        if (schemeCut != null) {
            this.buildResolveList(intent, categories, debug, defaultOnly, resolvedType, scheme, schemeCut, finalList);
        }
        this.sortResults(finalList);
        if (debug) {
            Slog.v((String)TAG, (String)"Final result list:");
            for (Object r : finalList) {
                Slog.v((String)TAG, (String)("  " + r));
            }
        }
        return finalList;
    }

    protected boolean allowFilterResult(F filter, List<R> dest) {
        return true;
    }

    protected boolean isFilterStopped(F filter) {
        return false;
    }

    protected abstract String packageForFilter(F var1);

    protected R newResult(F filter, int match) {
        return (R)filter;
    }

    protected void sortResults(List<R> results) {
        Collections.sort(results, mResolvePrioritySorter);
    }

    protected void dumpFilter(PrintWriter out, String prefix, F filter) {
        out.print(prefix);
        out.println(filter);
    }

    private final int register_mime_types(F filter, String prefix) {
        Iterator i = filter.typesIterator();
        if (i == null) {
            return 0;
        }
        int num = 0;
        while (i.hasNext()) {
            String name = (String)i.next();
            ++num;
            String baseName = name;
            int slashpos = name.indexOf(47);
            if (slashpos > 0) {
                baseName = name.substring(0, slashpos).intern();
            } else {
                name = name + "/*";
            }
            ArrayList<Object> array = this.mTypeToFilter.get(name);
            if (array == null) {
                array = new ArrayList();
                this.mTypeToFilter.put(name, array);
            }
            array.add(filter);
            if (slashpos > 0) {
                array = this.mBaseTypeToFilter.get(baseName);
                if (array == null) {
                    array = new ArrayList();
                    this.mBaseTypeToFilter.put(baseName, array);
                }
                array.add(filter);
                continue;
            }
            array = this.mWildTypeToFilter.get(baseName);
            if (array == null) {
                array = new ArrayList();
                this.mWildTypeToFilter.put(baseName, array);
            }
            array.add(filter);
        }
        return num;
    }

    private final int unregister_mime_types(F filter, String prefix) {
        Iterator i = filter.typesIterator();
        if (i == null) {
            return 0;
        }
        int num = 0;
        while (i.hasNext()) {
            String name = (String)i.next();
            ++num;
            String baseName = name;
            int slashpos = name.indexOf(47);
            if (slashpos > 0) {
                baseName = name.substring(0, slashpos).intern();
            } else {
                name = name + "/*";
            }
            if (!this.remove_all_objects((List)this.mTypeToFilter.get(name), filter)) {
                this.mTypeToFilter.remove(name);
            }
            if (slashpos > 0) {
                if (this.remove_all_objects((List)this.mBaseTypeToFilter.get(baseName), filter)) continue;
                this.mBaseTypeToFilter.remove(baseName);
                continue;
            }
            if (this.remove_all_objects((List)this.mWildTypeToFilter.get(baseName), filter)) continue;
            this.mWildTypeToFilter.remove(baseName);
        }
        return num;
    }

    private final int register_intent_filter(F filter, Iterator<String> i, HashMap<String, ArrayList<F>> dest, String prefix) {
        if (i == null) {
            return 0;
        }
        int num = 0;
        while (i.hasNext()) {
            String name = i.next();
            ++num;
            ArrayList<Object> array = dest.get(name);
            if (array == null) {
                array = new ArrayList();
                dest.put(name, array);
            }
            array.add(filter);
        }
        return num;
    }

    private final int unregister_intent_filter(F filter, Iterator<String> i, HashMap<String, ArrayList<F>> dest, String prefix) {
        if (i == null) {
            return 0;
        }
        int num = 0;
        while (i.hasNext()) {
            String name = i.next();
            ++num;
            if (this.remove_all_objects((List)dest.get(name), filter)) continue;
            dest.remove(name);
        }
        return num;
    }

    private final boolean remove_all_objects(List<F> list, Object object) {
        if (list != null) {
            int N = list.size();
            for (int idx = 0; idx < N; ++idx) {
                if (list.get(idx) != object) continue;
                list.remove(idx);
                --idx;
                --N;
            }
            return N > 0;
        }
        return false;
    }

    private static FastImmutableArraySet<String> getFastIntentCategories(Intent intent) {
        Set categories = intent.getCategories();
        if (categories == null) {
            return null;
        }
        return new FastImmutableArraySet((Object[])categories.toArray(new String[categories.size()]));
    }

    private void buildResolveList(Intent intent, FastImmutableArraySet<String> categories, boolean debug, boolean defaultOnly, String resolvedType, String scheme, List<F> src, List<R> dest) {
        String action = intent.getAction();
        Uri data = intent.getData();
        String packageName = intent.getPackage();
        boolean excludingStopped = intent.isExcludingStopped();
        int N = src != null ? src.size() : 0;
        boolean hasNonDefaults = false;
        for (int i = 0; i < N; ++i) {
            String reason;
            IntentFilter filter = (IntentFilter)src.get(i);
            if (debug) {
                Slog.v((String)TAG, (String)("Matching against filter " + filter));
            }
            if (excludingStopped && this.isFilterStopped(filter)) {
                if (!debug) continue;
                Slog.v((String)TAG, (String)"  Filter's target is stopped; skipping");
                continue;
            }
            if (packageName != null && !packageName.equals(this.packageForFilter(filter))) {
                if (!debug) continue;
                Slog.v((String)TAG, (String)("  Filter is not from package " + packageName + "; skipping"));
                continue;
            }
            if (!this.allowFilterResult(filter, dest)) {
                if (!debug) continue;
                Slog.v((String)TAG, (String)"  Filter's target already added");
                continue;
            }
            int match = filter.match(action, resolvedType, scheme, data, categories, TAG);
            if (match >= 0) {
                if (debug) {
                    Slog.v((String)TAG, (String)("  Filter matched!  match=0x" + Integer.toHexString(match)));
                }
                if (!defaultOnly || filter.hasCategory("android.intent.category.DEFAULT")) {
                    R oneResult = this.newResult(filter, match);
                    if (oneResult == null) continue;
                    dest.add(oneResult);
                    continue;
                }
                hasNonDefaults = true;
                continue;
            }
            if (!debug) continue;
            switch (match) {
                case -3: {
                    reason = "action";
                    break;
                }
                case -4: {
                    reason = "category";
                    break;
                }
                case -2: {
                    reason = "data";
                    break;
                }
                case -1: {
                    reason = "type";
                    break;
                }
                default: {
                    reason = "unknown reason";
                }
            }
            Slog.v((String)TAG, (String)("  Filter did not match: " + reason));
        }
        if (dest.size() == 0 && hasNonDefaults) {
            Slog.w((String)TAG, (String)"resolveIntent failed: found match, but none with Intent.CATEGORY_DEFAULT");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorWrapper
    implements Iterator<F> {
        private final Iterator<F> mI;
        private F mCur;

        IteratorWrapper(Iterator<F> it) {
            this.mI = it;
        }

        @Override
        public boolean hasNext() {
            return this.mI.hasNext();
        }

        @Override
        public F next() {
            this.mCur = (IntentFilter)this.mI.next();
            return this.mCur;
        }

        @Override
        public void remove() {
            if (this.mCur != null) {
                IntentResolver.this.removeFilterInternal(this.mCur);
            }
            this.mI.remove();
        }
    }
}

