/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.IHardwareService;
import android.os.Message;
import android.os.ServiceManager;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class LightsService {
    private static final String TAG = "LightsService";
    private static final boolean DEBUG = false;
    static final int LIGHT_ID_BACKLIGHT = 0;
    static final int LIGHT_ID_KEYBOARD = 1;
    static final int LIGHT_ID_BUTTONS = 2;
    static final int LIGHT_ID_BATTERY = 3;
    static final int LIGHT_ID_NOTIFICATIONS = 4;
    static final int LIGHT_ID_ATTENTION = 5;
    static final int LIGHT_ID_BLUETOOTH = 6;
    static final int LIGHT_ID_WIFI = 7;
    static final int LIGHT_ID_COUNT = 8;
    static final int LIGHT_FLASH_NONE = 0;
    static final int LIGHT_FLASH_TIMED = 1;
    static final int LIGHT_FLASH_HARDWARE = 2;
    static final int BRIGHTNESS_MODE_USER = 0;
    static final int BRIGHTNESS_MODE_SENSOR = 1;
    private final Light[] mLights = new Light[8];
    private final IHardwareService.Stub mLegacyFlashlightHack = new IHardwareService.Stub(){
        private static final String FLASHLIGHT_FILE = "/sys/class/leds/spotlight/brightness";

        public boolean getFlashlightEnabled() {
            try {
                FileInputStream fis = new FileInputStream(FLASHLIGHT_FILE);
                int result = fis.read();
                fis.close();
                return result != 48;
            }
            catch (Exception e) {
                return false;
            }
        }

        public void setFlashlightEnabled(boolean on) {
            if (LightsService.this.mContext.checkCallingOrSelfPermission("android.permission.FLASHLIGHT") != 0 && LightsService.this.mContext.checkCallingOrSelfPermission("android.permission.HARDWARE_TEST") != 0) {
                throw new SecurityException("Requires FLASHLIGHT or HARDWARE_TEST permission");
            }
            try {
                FileOutputStream fos = new FileOutputStream(FLASHLIGHT_FILE);
                byte[] bytes = new byte[]{(byte)(on ? 49 : 48), 10};
                fos.write(bytes);
                fos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private Handler mH = new Handler(){

        public void handleMessage(Message msg) {
            Light light = (Light)msg.obj;
            light.stopFlashing();
        }
    };
    private final Context mContext;
    private int mNativePointer = LightsService.init_native();

    LightsService(Context context) {
        this.mContext = context;
        ServiceManager.addService((String)"hardware", (IBinder)this.mLegacyFlashlightHack);
        for (int i = 0; i < 8; ++i) {
            this.mLights[i] = new Light(i);
        }
    }

    protected void finalize() throws Throwable {
        LightsService.finalize_native(this.mNativePointer);
        super.finalize();
    }

    public Light getLight(int id) {
        return this.mLights[id];
    }

    private static native int init_native();

    private static native void finalize_native(int var0);

    private static native void setLight_native(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public final class Light {
        private int mId;
        private int mColor;
        private int mMode;
        private int mOnMS;
        private int mOffMS;
        private boolean mFlashing;

        private Light(int id) {
            this.mId = id;
        }

        public void setBrightness(int brightness) {
            this.setBrightness(brightness, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBrightness(int brightness, int brightnessMode) {
            Light light = this;
            synchronized (light) {
                int color = brightness & 0xFF;
                color = 0xFF000000 | color << 16 | color << 8 | color;
                this.setLightLocked(color, 0, 0, 0, brightnessMode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setColor(int color) {
            Light light = this;
            synchronized (light) {
                this.setLightLocked(color, 0, 0, 0, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFlashing(int color, int mode, int onMS, int offMS) {
            Light light = this;
            synchronized (light) {
                this.setLightLocked(color, mode, onMS, offMS, 0);
            }
        }

        public void pulse() {
            this.pulse(0xFFFFFF, 7);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pulse(int color, int onMS) {
            Light light = this;
            synchronized (light) {
                if (this.mColor == 0 && !this.mFlashing) {
                    this.setLightLocked(color, 2, onMS, 1000, 0);
                    LightsService.this.mH.sendMessageDelayed(Message.obtain((Handler)LightsService.this.mH, (int)1, (Object)this), (long)onMS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void turnOff() {
            Light light = this;
            synchronized (light) {
                this.setLightLocked(0, 0, 0, 0, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopFlashing() {
            Light light = this;
            synchronized (light) {
                this.setLightLocked(this.mColor, 0, 0, 0, 0);
            }
        }

        private void setLightLocked(int color, int mode, int onMS, int offMS, int brightnessMode) {
            if (color != this.mColor || mode != this.mMode || onMS != this.mOnMS || offMS != this.mOffMS) {
                this.mColor = color;
                this.mMode = mode;
                this.mOnMS = onMS;
                this.mOffMS = offMS;
                LightsService.setLight_native(LightsService.this.mNativePointer, this.mId, color, mode, onMS, offMS, brightnessMode);
            }
        }
    }
}

