/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentQueryMap;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.location.Address;
import android.location.Criteria;
import android.location.GeocoderParams;
import android.location.IGpsStatusListener;
import android.location.IGpsStatusProvider;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.INetInitiatedListener;
import android.location.Location;
import android.net.NetworkInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.util.Printer;
import android.util.Slog;
import com.android.internal.content.PackageMonitor;
import com.android.server.location.GeocoderProxy;
import com.android.server.location.GpsLocationProvider;
import com.android.server.location.LocationProviderInterface;
import com.android.server.location.LocationProviderProxy;
import com.android.server.location.MockProvider;
import com.android.server.location.PassiveProvider;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationManagerService
extends ILocationManager.Stub
implements Runnable {
    private static final String TAG = "LocationManagerService";
    private static final boolean LOCAL_LOGV = false;
    private HashMap<String, Long> mLastWriteTime = new HashMap();
    private static final String ACCESS_FINE_LOCATION = "android.permission.ACCESS_FINE_LOCATION";
    private static final String ACCESS_COARSE_LOCATION = "android.permission.ACCESS_COARSE_LOCATION";
    private static final String ACCESS_MOCK_LOCATION = "android.permission.ACCESS_MOCK_LOCATION";
    private static final String ACCESS_LOCATION_EXTRA_COMMANDS = "android.permission.ACCESS_LOCATION_EXTRA_COMMANDS";
    private static final String INSTALL_LOCATION_PROVIDER = "android.permission.INSTALL_LOCATION_PROVIDER";
    private final Set<String> mEnabledProviders = new HashSet<String>();
    private final Set<String> mDisabledProviders = new HashSet<String>();
    private final HashMap<String, MockProvider> mMockProviders = new HashMap();
    private static boolean sProvidersLoaded = false;
    private final Context mContext;
    private final String mNetworkLocationProviderPackageName;
    private final String mGeocodeProviderPackageName;
    private GeocoderProxy mGeocodeProvider;
    private IGpsStatusProvider mGpsStatusProvider;
    private INetInitiatedListener mNetInitiatedListener;
    private LocationWorkerHandler mLocationHandler;
    LocationProviderProxy mNetworkLocationProvider;
    LocationProviderInterface mGpsLocationProvider;
    private static final int MESSAGE_LOCATION_CHANGED = 1;
    private static final int MESSAGE_PACKAGE_UPDATED = 2;
    private static final String WAKELOCK_KEY = "LocationManagerService";
    private PowerManager.WakeLock mWakeLock = null;
    private int mPendingBroadcasts;
    private final HashMap<Object, Receiver> mReceivers = new HashMap();
    private final ArrayList<LocationProviderInterface> mProviders = new ArrayList();
    private final HashMap<String, LocationProviderInterface> mProvidersByName = new HashMap();
    private final Object mLock = new Object();
    private final HashMap<String, ArrayList<UpdateRecord>> mRecordsByProvider = new HashMap();
    private final WorkSource mTmpWorkSource = new WorkSource();
    private Receiver mProximityReceiver = null;
    private ILocationListener mProximityListener = null;
    private HashMap<PendingIntent, ProximityAlert> mProximityAlerts = new HashMap();
    private HashSet<ProximityAlert> mProximitiesEntered = new HashSet();
    private HashMap<String, Location> mLastKnownLocation = new HashMap();
    private int mNetworkState = 1;
    private ContentQueryMap mSettings;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            boolean queryRestart = action.equals("android.intent.action.QUERY_PACKAGE_RESTART");
            if (queryRestart || action.equals("android.intent.action.PACKAGE_REMOVED") || action.equals("android.intent.action.PACKAGE_RESTARTED") || action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE")) {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    int[] uidList = null;
                    uidList = action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE") ? intent.getIntArrayExtra("android.intent.extra.changed_uid_list") : new int[]{intent.getIntExtra("android.intent.extra.UID", -1)};
                    if (uidList == null || uidList.length == 0) {
                        return;
                    }
                    for (int uid : uidList) {
                        if (uid < 0) continue;
                        ArrayList<Receiver> removedRecs = null;
                        for (ArrayList i : LocationManagerService.this.mRecordsByProvider.values()) {
                            for (int j = i.size() - 1; j >= 0; --j) {
                                UpdateRecord ur = (UpdateRecord)i.get(j);
                                if (!ur.mReceiver.isPendingIntent() || ur.mUid != uid) continue;
                                if (queryRestart) {
                                    this.setResultCode(-1);
                                    return;
                                }
                                if (removedRecs == null) {
                                    removedRecs = new ArrayList<Receiver>();
                                }
                                if (removedRecs.contains(ur.mReceiver)) continue;
                                removedRecs.add(ur.mReceiver);
                            }
                        }
                        ArrayList<ProximityAlert> removedAlerts = null;
                        for (ProximityAlert i : LocationManagerService.this.mProximityAlerts.values()) {
                            if (i.mUid != uid) continue;
                            if (queryRestart) {
                                this.setResultCode(-1);
                                return;
                            }
                            if (removedAlerts == null) {
                                removedAlerts = new ArrayList<ProximityAlert>();
                            }
                            if (removedAlerts.contains(i)) continue;
                            removedAlerts.add(i);
                        }
                        if (removedRecs != null) {
                            for (int i = removedRecs.size() - 1; i >= 0; --i) {
                                LocationManagerService.this.removeUpdatesLocked((Receiver)removedRecs.get(i));
                            }
                        }
                        if (removedAlerts == null) continue;
                        for (int i = removedAlerts.size() - 1; i >= 0; --i) {
                            LocationManagerService.this.removeProximityAlertLocked(((ProximityAlert)removedAlerts.get((int)i)).mIntent);
                        }
                    }
                }
            }
            if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
                if (!noConnectivity) {
                    LocationManagerService.this.mNetworkState = 2;
                } else {
                    LocationManagerService.this.mNetworkState = 1;
                }
                NetworkInfo info = (NetworkInfo)intent.getExtra("networkInfo");
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    for (int i = LocationManagerService.this.mProviders.size() - 1; i >= 0; --i) {
                        LocationProviderInterface provider = (LocationProviderInterface)LocationManagerService.this.mProviders.get(i);
                        if (!provider.requiresNetwork()) continue;
                        provider.updateNetworkState(LocationManagerService.this.mNetworkState, info);
                    }
                }
            }
        }
    };
    private final PackageMonitor mPackageMonitor = new PackageMonitor(){

        public void onPackageUpdateFinished(String packageName, int uid) {
            Message.obtain((Handler)LocationManagerService.this.mLocationHandler, (int)2, (Object)packageName).sendToTarget();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locationCallbackFinished(ILocationListener listener) {
        IBinder binder = listener.asBinder();
        Receiver receiver = this.mReceivers.get(binder);
        if (receiver != null) {
            Receiver receiver2 = receiver;
            synchronized (receiver2) {
                long identity = Binder.clearCallingIdentity();
                receiver.decrementPendingBroadcastsLocked();
                Binder.restoreCallingIdentity((long)identity);
            }
        }
    }

    private void addProvider(LocationProviderInterface provider) {
        this.mProviders.add(provider);
        this.mProvidersByName.put(provider.getName(), provider);
    }

    private void removeProvider(LocationProviderInterface provider) {
        this.mProviders.remove(provider);
        this.mProvidersByName.remove(provider.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProviders() {
        Object object = this.mLock;
        synchronized (object) {
            if (sProvidersLoaded) {
                return;
            }
            this.loadProvidersLocked();
            sProvidersLoaded = true;
        }
    }

    private void loadProvidersLocked() {
        try {
            this._loadProvidersLocked();
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"Exception loading providers:", (Throwable)e);
        }
    }

    private void _loadProvidersLocked() {
        if (GpsLocationProvider.isSupported()) {
            GpsLocationProvider gpsProvider = new GpsLocationProvider(this.mContext, (ILocationManager)this);
            this.mGpsStatusProvider = gpsProvider.getGpsStatusProvider();
            this.mNetInitiatedListener = gpsProvider.getNetInitiatedListener();
            this.addProvider(gpsProvider);
            this.mGpsLocationProvider = gpsProvider;
        }
        PassiveProvider passiveProvider = new PassiveProvider((ILocationManager)this);
        this.addProvider(passiveProvider);
        this.mEnabledProviders.add(passiveProvider.getName());
        PackageManager pm = this.mContext.getPackageManager();
        if (this.mNetworkLocationProviderPackageName != null && pm.resolveService(new Intent(this.mNetworkLocationProviderPackageName), 0) != null) {
            this.mNetworkLocationProvider = new LocationProviderProxy(this.mContext, "network", this.mNetworkLocationProviderPackageName, this.mLocationHandler);
            this.addProvider(this.mNetworkLocationProvider);
        }
        if (this.mGeocodeProviderPackageName != null && pm.resolveService(new Intent(this.mGeocodeProviderPackageName), 0) != null) {
            this.mGeocodeProvider = new GeocoderProxy(this.mContext, this.mGeocodeProviderPackageName);
        }
        this.updateProvidersLocked();
    }

    public LocationManagerService(Context context) {
        this.mContext = context;
        Resources resources = context.getResources();
        this.mNetworkLocationProviderPackageName = resources.getString(17039388);
        this.mGeocodeProviderPackageName = resources.getString(17039389);
        this.mPackageMonitor.register(context, true);
    }

    void systemReady() {
        Thread thread = new Thread(null, this, "LocationManagerService");
        thread.start();
    }

    private void initialize() {
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, "LocationManagerService");
        this.loadProviders();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addAction("android.intent.action.PACKAGE_RESTARTED");
        intentFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        this.mContext.registerReceiver(this.mBroadcastReceiver, intentFilter);
        IntentFilter sdFilter = new IntentFilter("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mBroadcastReceiver, sdFilter);
        ContentResolver resolver = this.mContext.getContentResolver();
        Cursor settingsCursor = resolver.query(Settings.Secure.CONTENT_URI, null, "(name=?)", new String[]{"location_providers_allowed"}, null);
        this.mSettings = new ContentQueryMap(settingsCursor, "name", true, (Handler)this.mLocationHandler);
        SettingsObserver settingsObserver = new SettingsObserver();
        this.mSettings.addObserver((Observer)settingsObserver);
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        Looper.prepare();
        this.mLocationHandler = new LocationWorkerHandler();
        this.initialize();
        Looper.loop();
    }

    private boolean isAllowedBySettingsLocked(String provider) {
        if (this.mEnabledProviders.contains(provider)) {
            return true;
        }
        if (this.mDisabledProviders.contains(provider)) {
            return false;
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        return Settings.Secure.isLocationProviderEnabled((ContentResolver)resolver, (String)provider);
    }

    private String checkPermissionsSafe(String provider, String lastPermission) {
        if ("gps".equals(provider) || "passive".equals(provider)) {
            if (this.mContext.checkCallingOrSelfPermission(ACCESS_FINE_LOCATION) != 0) {
                throw new SecurityException("Provider " + provider + " requires ACCESS_FINE_LOCATION permission");
            }
            return ACCESS_FINE_LOCATION;
        }
        if (this.mContext.checkCallingOrSelfPermission(ACCESS_COARSE_LOCATION) == 0) {
            return ACCESS_FINE_LOCATION.equals(lastPermission) ? lastPermission : ACCESS_COARSE_LOCATION;
        }
        if (this.mContext.checkCallingOrSelfPermission(ACCESS_FINE_LOCATION) == 0) {
            return ACCESS_FINE_LOCATION;
        }
        throw new SecurityException("Provider " + provider + " requires ACCESS_FINE_LOCATION or ACCESS_COARSE_LOCATION permission");
    }

    private boolean isAllowedProviderSafe(String provider) {
        if (("gps".equals(provider) || "passive".equals(provider)) && this.mContext.checkCallingOrSelfPermission(ACCESS_FINE_LOCATION) != 0) {
            return false;
        }
        return !"network".equals(provider) || this.mContext.checkCallingOrSelfPermission(ACCESS_FINE_LOCATION) == 0 || this.mContext.checkCallingOrSelfPermission(ACCESS_COARSE_LOCATION) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllProviders() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                return this._getAllProvidersLocked();
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"getAllProviders got exception:", (Throwable)e);
            return null;
        }
    }

    private List<String> _getAllProvidersLocked() {
        ArrayList<String> out = new ArrayList<String>(this.mProviders.size());
        for (int i = this.mProviders.size() - 1; i >= 0; --i) {
            LocationProviderInterface p = this.mProviders.get(i);
            out.add(p.getName());
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getProviders(Criteria criteria, boolean enabledOnly) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                return this._getProvidersLocked(criteria, enabledOnly);
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"getProviders got exception:", (Throwable)e);
            return null;
        }
    }

    private List<String> _getProvidersLocked(Criteria criteria, boolean enabledOnly) {
        ArrayList<String> out = new ArrayList<String>(this.mProviders.size());
        for (int i = this.mProviders.size() - 1; i >= 0; --i) {
            LocationProviderInterface p = this.mProviders.get(i);
            String name = p.getName();
            if (!this.isAllowedProviderSafe(name) || enabledOnly && !this.isAllowedBySettingsLocked(name) || criteria != null && !p.meetsCriteria(criteria)) continue;
            out.add(name);
        }
        return out;
    }

    private int nextPower(int power) {
        switch (power) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    private int nextAccuracy(int accuracy) {
        if (accuracy == 1) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocationProviderInterface best(List<String> providerNames) {
        int idx;
        ArrayList<LocationProviderInterface> providers;
        Object object = this.mLock;
        synchronized (object) {
            providers = new ArrayList<LocationProviderInterface>(providerNames.size());
            for (String name : providerNames) {
                providers.add(this.mProvidersByName.get(name));
            }
        }
        if (providers.size() < 2) {
            return (LocationProviderInterface)providers.get(0);
        }
        Collections.sort(providers, new LpPowerComparator());
        int power = ((LocationProviderInterface)providers.get(0)).getPowerRequirement();
        if (power < ((LocationProviderInterface)providers.get(1)).getPowerRequirement()) {
            return (LocationProviderInterface)providers.get(0);
        }
        ArrayList tmp = new ArrayList();
        int size = providers.size();
        for (idx = 0; idx < size && ((LocationProviderInterface)providers.get(idx)).getPowerRequirement() == power; ++idx) {
            tmp.add(providers.get(idx));
        }
        Collections.sort(tmp, new LpAccuracyComparator());
        int acc = ((LocationProviderInterface)tmp.get(0)).getAccuracy();
        if (acc < ((LocationProviderInterface)tmp.get(1)).getAccuracy()) {
            return (LocationProviderInterface)tmp.get(0);
        }
        ArrayList tmp2 = new ArrayList();
        size = tmp.size();
        for (idx = 0; idx < size && ((LocationProviderInterface)tmp.get(idx)).getAccuracy() == acc; ++idx) {
            tmp2.add(tmp.get(idx));
        }
        Collections.sort(tmp2, new LpCapabilityComparator());
        return (LocationProviderInterface)tmp2.get(0);
    }

    public String getBestProvider(Criteria criteria, boolean enabledOnly) {
        List<String> goodProviders = this.getProviders(criteria, enabledOnly);
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        criteria = new Criteria(criteria);
        int power = criteria.getPowerRequirement();
        while (goodProviders.isEmpty() && power != 0) {
            power = this.nextPower(power);
            criteria.setPowerRequirement(power);
            goodProviders = this.getProviders(criteria, enabledOnly);
        }
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        int accuracy = criteria.getAccuracy();
        while (goodProviders.isEmpty() && accuracy != 0) {
            accuracy = this.nextAccuracy(accuracy);
            criteria.setAccuracy(accuracy);
            goodProviders = this.getProviders(criteria, enabledOnly);
        }
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        criteria.setBearingRequired(false);
        goodProviders = this.getProviders(criteria, enabledOnly);
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        criteria.setSpeedRequired(false);
        goodProviders = this.getProviders(criteria, enabledOnly);
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        criteria.setAltitudeRequired(false);
        goodProviders = this.getProviders(criteria, enabledOnly);
        if (!goodProviders.isEmpty()) {
            return this.best(goodProviders).getName();
        }
        return null;
    }

    public boolean providerMeetsCriteria(String provider, Criteria criteria) {
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            throw new IllegalArgumentException("provider=" + provider);
        }
        return p.meetsCriteria(criteria);
    }

    private void updateProvidersLocked() {
        boolean changesMade = false;
        for (int i = this.mProviders.size() - 1; i >= 0; --i) {
            LocationProviderInterface p = this.mProviders.get(i);
            boolean isEnabled = p.isEnabled();
            String name = p.getName();
            boolean shouldBeEnabled = this.isAllowedBySettingsLocked(name);
            if (isEnabled && !shouldBeEnabled) {
                this.updateProviderListenersLocked(name, false);
                changesMade = true;
                continue;
            }
            if (isEnabled || !shouldBeEnabled) continue;
            this.updateProviderListenersLocked(name, true);
            changesMade = true;
        }
        if (changesMade) {
            this.mContext.sendBroadcast(new Intent("android.location.PROVIDERS_CHANGED"));
        }
    }

    private void updateProviderListenersLocked(String provider, boolean enabled) {
        int listeners = 0;
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            return;
        }
        ArrayList<Receiver> deadReceivers = null;
        ArrayList<UpdateRecord> records = this.mRecordsByProvider.get(provider);
        if (records != null) {
            int N = records.size();
            for (int i = 0; i < N; ++i) {
                UpdateRecord record = records.get(i);
                if (!record.mReceiver.callProviderEnabledLocked(provider, enabled)) {
                    if (deadReceivers == null) {
                        deadReceivers = new ArrayList<Receiver>();
                    }
                    deadReceivers.add(record.mReceiver);
                }
                ++listeners;
            }
        }
        if (deadReceivers != null) {
            for (int i = deadReceivers.size() - 1; i >= 0; --i) {
                this.removeUpdatesLocked((Receiver)deadReceivers.get(i));
            }
        }
        if (enabled) {
            p.enable();
            if (listeners > 0) {
                p.setMinTime(this.getMinTimeLocked(provider), this.mTmpWorkSource);
                p.enableLocationTracking(true);
            }
        } else {
            p.enableLocationTracking(false);
            p.disable();
        }
    }

    private long getMinTimeLocked(String provider) {
        long minTime = Long.MAX_VALUE;
        ArrayList<UpdateRecord> records = this.mRecordsByProvider.get(provider);
        this.mTmpWorkSource.clear();
        if (records != null) {
            for (int i = records.size() - 1; i >= 0; --i) {
                UpdateRecord ur = records.get(i);
                long curTime = ur.mMinTime;
                if (curTime >= minTime) continue;
                minTime = curTime;
            }
            long inclTime = minTime * 3L / 2L;
            for (int i = records.size() - 1; i >= 0; --i) {
                UpdateRecord ur = records.get(i);
                if (ur.mMinTime > inclTime) continue;
                this.mTmpWorkSource.add(ur.mUid);
            }
        }
        return minTime;
    }

    private Receiver getReceiver(ILocationListener listener) {
        IBinder binder = listener.asBinder();
        Receiver receiver = this.mReceivers.get(binder);
        if (receiver == null) {
            receiver = new Receiver(listener);
            this.mReceivers.put(binder, receiver);
            try {
                if (receiver.isListener()) {
                    receiver.getListener().asBinder().linkToDeath((IBinder.DeathRecipient)receiver, 0);
                }
            }
            catch (RemoteException e) {
                Slog.e((String)"LocationManagerService", (String)"linkToDeath failed:", (Throwable)e);
                return null;
            }
        }
        return receiver;
    }

    private Receiver getReceiver(PendingIntent intent) {
        Receiver receiver = this.mReceivers.get(intent);
        if (receiver == null) {
            receiver = new Receiver(intent);
            this.mReceivers.put(intent, receiver);
        }
        return receiver;
    }

    private boolean providerHasListener(String provider, int uid, Receiver excludedReceiver) {
        ArrayList<UpdateRecord> records = this.mRecordsByProvider.get(provider);
        if (records != null) {
            for (int i = records.size() - 1; i >= 0; --i) {
                UpdateRecord record = records.get(i);
                if (record.mUid != uid || record.mReceiver == excludedReceiver) continue;
                return true;
            }
        }
        for (ProximityAlert alert : this.mProximityAlerts.values()) {
            if (alert.mUid != uid) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(String provider, Criteria criteria, long minTime, float minDistance, boolean singleShot, ILocationListener listener) {
        if (criteria != null && (provider = this.getBestProvider(criteria, true)) == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.requestLocationUpdatesLocked(provider, minTime, minDistance, singleShot, this.getReceiver(listener));
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"requestUpdates got exception:", (Throwable)e);
        }
    }

    void validatePendingIntent(PendingIntent intent) {
        if (intent.isTargetedToPackage()) {
            return;
        }
        Slog.i((String)"LocationManagerService", (String)("Given Intent does not require a specific package: " + intent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdatesPI(String provider, Criteria criteria, long minTime, float minDistance, boolean singleShot, PendingIntent intent) {
        this.validatePendingIntent(intent);
        if (criteria != null && (provider = this.getBestProvider(criteria, true)) == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.requestLocationUpdatesLocked(provider, minTime, minDistance, singleShot, this.getReceiver(intent));
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"requestUpdates got exception:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestLocationUpdatesLocked(String provider, long minTime, float minDistance, boolean singleShot, Receiver receiver) {
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            throw new IllegalArgumentException("provider=" + provider);
        }
        receiver.requiredPermissions = this.checkPermissionsSafe(provider, receiver.requiredPermissions);
        int callingUid = Binder.getCallingUid();
        boolean newUid = !this.providerHasListener(provider, callingUid, null);
        long identity = Binder.clearCallingIdentity();
        try {
            boolean isProviderEnabled;
            UpdateRecord r = new UpdateRecord(provider, minTime, minDistance, singleShot, receiver, callingUid);
            UpdateRecord oldRecord = receiver.mUpdateRecords.put(provider, r);
            if (oldRecord != null) {
                oldRecord.disposeLocked();
            }
            if (newUid) {
                p.addListener(callingUid);
            }
            if (isProviderEnabled = this.isAllowedBySettingsLocked(provider)) {
                long minTimeForProvider = this.getMinTimeLocked(provider);
                p.setMinTime(minTimeForProvider, this.mTmpWorkSource);
                if (!singleShot || !p.requestSingleShotFix()) {
                    p.enableLocationTracking(true);
                }
            } else {
                receiver.callProviderEnabledLocked(provider, false);
            }
            Object var18_14 = null;
        }
        catch (Throwable throwable) {
            Object var18_15 = null;
            Binder.restoreCallingIdentity((long)identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdates(ILocationListener listener) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.removeUpdatesLocked(this.getReceiver(listener));
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"removeUpdates got exception:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdatesPI(PendingIntent intent) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.removeUpdatesLocked(this.getReceiver(intent));
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"removeUpdates got exception:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUpdatesLocked(Receiver receiver) {
        int callingUid = Binder.getCallingUid();
        long identity = Binder.clearCallingIdentity();
        try {
            if (this.mReceivers.remove(receiver.mKey) != null && receiver.isListener()) {
                receiver.getListener().asBinder().unlinkToDeath((IBinder.DeathRecipient)receiver, 0);
                Receiver receiver2 = receiver;
                synchronized (receiver2) {
                    if (receiver.mPendingBroadcasts > 0) {
                        this.decrementPendingBroadcasts();
                        receiver.mPendingBroadcasts = 0;
                    }
                }
            }
            HashSet<String> providers = new HashSet<String>();
            HashMap<String, UpdateRecord> oldRecords = receiver.mUpdateRecords;
            if (oldRecords != null) {
                for (UpdateRecord record : oldRecords.values()) {
                    LocationProviderInterface p;
                    if (!this.providerHasListener(record.mProvider, callingUid, receiver) && (p = this.mProvidersByName.get(record.mProvider)) != null) {
                        p.removeListener(callingUid);
                    }
                    record.disposeLocked();
                }
                providers.addAll(oldRecords.keySet());
            }
            for (String provider : providers) {
                LocationProviderInterface p;
                if (!this.isAllowedBySettingsLocked(provider)) continue;
                boolean hasOtherListener = false;
                ArrayList<UpdateRecord> recordsForProvider = this.mRecordsByProvider.get(provider);
                if (recordsForProvider != null && recordsForProvider.size() > 0) {
                    hasOtherListener = true;
                }
                if ((p = this.mProvidersByName.get(provider)) == null) continue;
                if (hasOtherListener) {
                    p.setMinTime(this.getMinTimeLocked(provider), this.mTmpWorkSource);
                    continue;
                }
                p.enableLocationTracking(false);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            Binder.restoreCallingIdentity((long)identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)identity);
    }

    public boolean addGpsStatusListener(IGpsStatusListener listener) {
        if (this.mGpsStatusProvider == null) {
            return false;
        }
        if (this.mContext.checkCallingOrSelfPermission(ACCESS_FINE_LOCATION) != 0) {
            throw new SecurityException("Requires ACCESS_FINE_LOCATION permission");
        }
        try {
            this.mGpsStatusProvider.addGpsStatusListener(listener);
        }
        catch (RemoteException e) {
            Slog.e((String)"LocationManagerService", (String)"mGpsStatusProvider.addGpsStatusListener failed", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGpsStatusListener(IGpsStatusListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mGpsStatusProvider.removeGpsStatusListener(listener);
            }
            catch (Exception e) {
                Slog.e((String)"LocationManagerService", (String)"mGpsStatusProvider.removeGpsStatusListener failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendExtraCommand(String provider, String command, Bundle extras) {
        if (provider == null) {
            throw new NullPointerException();
        }
        this.checkPermissionsSafe(provider, null);
        if (this.mContext.checkCallingOrSelfPermission(ACCESS_LOCATION_EXTRA_COMMANDS) != 0) {
            throw new SecurityException("Requires ACCESS_LOCATION_EXTRA_COMMANDS permission");
        }
        Object object = this.mLock;
        synchronized (object) {
            LocationProviderInterface p = this.mProvidersByName.get(provider);
            if (p == null) {
                return false;
            }
            return p.sendExtraCommand(command, extras);
        }
    }

    public boolean sendNiResponse(int notifId, int userResponse) {
        if (Binder.getCallingUid() != Process.myUid()) {
            throw new SecurityException("calling sendNiResponse from outside of the system is not allowed");
        }
        try {
            return this.mNetInitiatedListener.sendNiResponse(notifId, userResponse);
        }
        catch (RemoteException e) {
            Slog.e((String)"LocationManagerService", (String)"RemoteException in LocationManagerService.sendNiResponse");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProximityAlert(double latitude, double longitude, float radius, long expiration, PendingIntent intent) {
        this.validatePendingIntent(intent);
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.addProximityAlertLocked(latitude, longitude, radius, expiration, intent);
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"addProximityAlert got exception:", (Throwable)e);
        }
    }

    private void addProximityAlertLocked(double latitude, double longitude, float radius, long expiration, PendingIntent intent) {
        if (!this.isAllowedProviderSafe("gps") || !this.isAllowedProviderSafe("network")) {
            throw new SecurityException("Requires ACCESS_FINE_LOCATION permission");
        }
        if (expiration != -1L) {
            expiration += System.currentTimeMillis();
        }
        ProximityAlert alert = new ProximityAlert(Binder.getCallingUid(), latitude, longitude, radius, expiration, intent);
        this.mProximityAlerts.put(intent, alert);
        if (this.mProximityReceiver == null) {
            this.mProximityListener = new ProximityListener();
            this.mProximityReceiver = new Receiver(this.mProximityListener);
            for (int i = this.mProviders.size() - 1; i >= 0; --i) {
                LocationProviderInterface provider = this.mProviders.get(i);
                this.requestLocationUpdatesLocked(provider.getName(), 1000L, 1.0f, false, this.mProximityReceiver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProximityAlert(PendingIntent intent) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.removeProximityAlertLocked(intent);
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"removeProximityAlert got exception:", (Throwable)e);
        }
    }

    private void removeProximityAlertLocked(PendingIntent intent) {
        this.mProximityAlerts.remove(intent);
        if (this.mProximityAlerts.size() == 0) {
            this.removeUpdatesLocked(this.mProximityReceiver);
            this.mProximityReceiver = null;
            this.mProximityListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getProviderInfo(String provider) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                return this._getProviderInfoLocked(provider);
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"_getProviderInfo got exception:", (Throwable)e);
            return null;
        }
    }

    private Bundle _getProviderInfoLocked(String provider) {
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            return null;
        }
        this.checkPermissionsSafe(provider, null);
        Bundle b = new Bundle();
        b.putBoolean("network", p.requiresNetwork());
        b.putBoolean("satellite", p.requiresSatellite());
        b.putBoolean("cell", p.requiresCell());
        b.putBoolean("cost", p.hasMonetaryCost());
        b.putBoolean("altitude", p.supportsAltitude());
        b.putBoolean("speed", p.supportsSpeed());
        b.putBoolean("bearing", p.supportsBearing());
        b.putInt("power", p.getPowerRequirement());
        b.putInt("accuracy", p.getAccuracy());
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProviderEnabled(String provider) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                return this._isProviderEnabledLocked(provider);
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"isProviderEnabled got exception:", (Throwable)e);
            return false;
        }
    }

    public void reportLocation(Location location, boolean passive) {
        if (this.mContext.checkCallingOrSelfPermission(INSTALL_LOCATION_PROVIDER) != 0) {
            throw new SecurityException("Requires INSTALL_LOCATION_PROVIDER permission");
        }
        this.mLocationHandler.removeMessages(1, location);
        Message m = Message.obtain((Handler)this.mLocationHandler, (int)1, (Object)location);
        m.arg1 = passive ? 1 : 0;
        this.mLocationHandler.sendMessageAtFrontOfQueue(m);
    }

    private boolean _isProviderEnabledLocked(String provider) {
        this.checkPermissionsSafe(provider, null);
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            return false;
        }
        return this.isAllowedBySettingsLocked(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLastKnownLocation(String provider) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                return this._getLastKnownLocationLocked(provider);
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            Slog.e((String)"LocationManagerService", (String)"getLastKnownLocation got exception:", (Throwable)e);
            return null;
        }
    }

    private Location _getLastKnownLocationLocked(String provider) {
        this.checkPermissionsSafe(provider, null);
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            return null;
        }
        if (!this.isAllowedBySettingsLocked(provider)) {
            return null;
        }
        return this.mLastKnownLocation.get(provider);
    }

    private static boolean shouldBroadcastSafe(Location loc, Location lastLoc, UpdateRecord record) {
        if (lastLoc == null) {
            return true;
        }
        if (loc.getTime() == lastLoc.getTime()) {
            return false;
        }
        double minDistance = record.mMinDistance;
        return !(minDistance > 0.0) || !((double)loc.distanceTo(lastLoc) <= minDistance);
    }

    private void handleLocationChangedLocked(Location location, boolean passive) {
        int i;
        String provider = passive ? "passive" : location.getProvider();
        ArrayList<UpdateRecord> records = this.mRecordsByProvider.get(provider);
        if (records == null || records.size() == 0) {
            return;
        }
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            return;
        }
        Location lastLocation = this.mLastKnownLocation.get(provider);
        if (lastLocation == null) {
            this.mLastKnownLocation.put(provider, new Location(location));
        } else {
            lastLocation.set(location);
        }
        long newStatusUpdateTime = p.getStatusUpdateTime();
        Bundle extras = new Bundle();
        int status = p.getStatus(extras);
        ArrayList<Receiver> deadReceivers = null;
        int N = records.size();
        for (i = 0; i < N; ++i) {
            long prevStatusUpdateTime;
            UpdateRecord r = records.get(i);
            Receiver receiver = r.mReceiver;
            boolean receiverDead = false;
            Location lastLoc = r.mLastFixBroadcast;
            if (lastLoc == null || LocationManagerService.shouldBroadcastSafe(location, lastLoc, r)) {
                if (lastLoc == null) {
                    r.mLastFixBroadcast = lastLoc = new Location(location);
                } else {
                    lastLoc.set(location);
                }
                if (!receiver.callLocationChangedLocked(location)) {
                    Slog.w((String)"LocationManagerService", (String)("RemoteException calling onLocationChanged on " + receiver));
                    receiverDead = true;
                }
            }
            if (newStatusUpdateTime > (prevStatusUpdateTime = r.mLastStatusBroadcast) && (prevStatusUpdateTime != 0L || status != 2)) {
                r.mLastStatusBroadcast = newStatusUpdateTime;
                if (!receiver.callStatusChangedLocked(provider, status, extras)) {
                    receiverDead = true;
                    Slog.w((String)"LocationManagerService", (String)("RemoteException calling onStatusChanged on " + receiver));
                }
            }
            if (!receiverDead && !r.mSingleShot) continue;
            if (deadReceivers == null) {
                deadReceivers = new ArrayList<Receiver>();
            }
            if (deadReceivers.contains(receiver)) continue;
            deadReceivers.add(receiver);
        }
        if (deadReceivers != null) {
            for (i = deadReceivers.size() - 1; i >= 0; --i) {
                this.removeUpdatesLocked((Receiver)deadReceivers.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementPendingBroadcasts() {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            if (this.mPendingBroadcasts++ == 0) {
                try {
                    this.mWakeLock.acquire();
                    this.log("Acquired wakelock");
                }
                catch (Exception e) {
                    Slog.e((String)"LocationManagerService", (String)"exception in acquireWakeLock()", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementPendingBroadcasts() {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            if (--this.mPendingBroadcasts == 0) {
                try {
                    if (this.mWakeLock.isHeld()) {
                        this.mWakeLock.release();
                        this.log("Released wakelock");
                    } else {
                        this.log("Can't release wakelock again!");
                    }
                }
                catch (Exception e) {
                    Slog.e((String)"LocationManagerService", (String)"exception in releaseWakeLock()", (Throwable)e);
                }
            }
        }
    }

    public boolean geocoderIsPresent() {
        return this.mGeocodeProvider != null;
    }

    public String getFromLocation(double latitude, double longitude, int maxResults, GeocoderParams params, List<Address> addrs) {
        if (this.mGeocodeProvider != null) {
            return this.mGeocodeProvider.getFromLocation(latitude, longitude, maxResults, params, addrs);
        }
        return null;
    }

    public String getFromLocationName(String locationName, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, int maxResults, GeocoderParams params, List<Address> addrs) {
        if (this.mGeocodeProvider != null) {
            return this.mGeocodeProvider.getFromLocationName(locationName, lowerLeftLatitude, lowerLeftLongitude, upperRightLatitude, upperRightLongitude, maxResults, params, addrs);
        }
        return null;
    }

    private void checkMockPermissionsSafe() {
        boolean allowMocks;
        boolean bl = allowMocks = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"mock_location", (int)0) == 1;
        if (!allowMocks) {
            throw new SecurityException("Requires ACCESS_MOCK_LOCATION secure setting");
        }
        if (this.mContext.checkCallingPermission(ACCESS_MOCK_LOCATION) != 0) {
            throw new SecurityException("Requires ACCESS_MOCK_LOCATION permission");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTestProvider(String name, boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
        this.checkMockPermissionsSafe();
        if ("passive".equals(name)) {
            throw new IllegalArgumentException("Cannot mock the passive location provider");
        }
        long identity = Binder.clearCallingIdentity();
        Object object = this.mLock;
        synchronized (object) {
            LocationProviderInterface p;
            MockProvider provider = new MockProvider(name, (ILocationManager)this, requiresNetwork, requiresSatellite, requiresCell, hasMonetaryCost, supportsAltitude, supportsSpeed, supportsBearing, powerRequirement, accuracy);
            if (("gps".equals(name) || "network".equals(name)) && (p = this.mProvidersByName.get(name)) != null) {
                p.enableLocationTracking(false);
                this.removeProvider(p);
            }
            if (this.mProvidersByName.get(name) != null) {
                throw new IllegalArgumentException("Provider \"" + name + "\" already exists");
            }
            this.addProvider(provider);
            this.mMockProviders.put(name, provider);
            this.mLastKnownLocation.put(name, null);
            this.updateProvidersLocked();
        }
        Binder.restoreCallingIdentity((long)identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestProvider(String provider) {
        this.checkMockPermissionsSafe();
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            long identity = Binder.clearCallingIdentity();
            this.removeProvider(this.mProvidersByName.get(provider));
            this.mMockProviders.remove(mockProvider);
            if ("gps".equals(provider) && this.mGpsLocationProvider != null) {
                this.addProvider(this.mGpsLocationProvider);
            } else if ("network".equals(provider) && this.mNetworkLocationProvider != null) {
                this.addProvider(this.mNetworkLocationProvider);
            }
            this.mLastKnownLocation.put(provider, null);
            this.updateProvidersLocked();
            Binder.restoreCallingIdentity((long)identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestProviderLocation(String provider, Location loc) {
        this.checkMockPermissionsSafe();
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            long identity = Binder.clearCallingIdentity();
            mockProvider.setLocation(loc);
            Binder.restoreCallingIdentity((long)identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTestProviderLocation(String provider) {
        this.checkMockPermissionsSafe();
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            mockProvider.clearLocation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestProviderEnabled(String provider, boolean enabled) {
        this.checkMockPermissionsSafe();
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            long identity = Binder.clearCallingIdentity();
            if (enabled) {
                mockProvider.enable();
                this.mEnabledProviders.add(provider);
                this.mDisabledProviders.remove(provider);
            } else {
                mockProvider.disable();
                this.mEnabledProviders.remove(provider);
                this.mDisabledProviders.add(provider);
            }
            this.updateProvidersLocked();
            Binder.restoreCallingIdentity((long)identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTestProviderEnabled(String provider) {
        this.checkMockPermissionsSafe();
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            long identity = Binder.clearCallingIdentity();
            this.mEnabledProviders.remove(provider);
            this.mDisabledProviders.remove(provider);
            this.updateProvidersLocked();
            Binder.restoreCallingIdentity((long)identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestProviderStatus(String provider, int status, Bundle extras, long updateTime) {
        this.checkMockPermissionsSafe();
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            mockProvider.setStatus(status, extras, updateTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTestProviderStatus(String provider) {
        this.checkMockPermissionsSafe();
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            mockProvider.clearStatus();
        }
    }

    private void log(String log) {
        if (Log.isLoggable((String)"LocationManagerService", (int)2)) {
            Slog.d((String)"LocationManagerService", (String)log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump LocationManagerService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Current Location Manager state:");
            pw.println("  sProvidersLoaded=" + sProvidersLoaded);
            pw.println("  Listeners:");
            int N = this.mReceivers.size();
            for (int i = 0; i < N; ++i) {
                pw.println("    " + this.mReceivers.get(i));
            }
            pw.println("  Location Listeners:");
            for (Receiver receiver : this.mReceivers.values()) {
                pw.println("    " + receiver + ":");
                for (Map.Entry<String, UpdateRecord> entry : receiver.mUpdateRecords.entrySet()) {
                    pw.println("      " + entry.getKey() + ":");
                    entry.getValue().dump(pw, "        ");
                }
            }
            pw.println("  Records by Provider:");
            for (Map.Entry entry : this.mRecordsByProvider.entrySet()) {
                pw.println("    " + (String)entry.getKey() + ":");
                for (UpdateRecord updateRecord : (ArrayList)entry.getValue()) {
                    pw.println("      " + updateRecord + ":");
                    updateRecord.dump(pw, "        ");
                }
            }
            pw.println("  Last Known Locations:");
            for (Map.Entry entry : this.mLastKnownLocation.entrySet()) {
                pw.println("    " + (String)entry.getKey() + ":");
                ((Location)entry.getValue()).dump((Printer)new PrintWriterPrinter(pw), "      ");
            }
            if (this.mProximityAlerts.size() > 0) {
                pw.println("  Proximity Alerts:");
                for (Map.Entry entry : this.mProximityAlerts.entrySet()) {
                    pw.println("    " + entry.getKey() + ":");
                    ((ProximityAlert)entry.getValue()).dump(pw, "      ");
                }
            }
            if (this.mProximitiesEntered.size() > 0) {
                pw.println("  Proximities Entered:");
                for (ProximityAlert proximityAlert : this.mProximitiesEntered) {
                    pw.println("    " + proximityAlert + ":");
                    proximityAlert.dump(pw, "      ");
                }
            }
            pw.println("  mProximityReceiver=" + this.mProximityReceiver);
            pw.println("  mProximityListener=" + this.mProximityListener);
            if (this.mEnabledProviders.size() > 0) {
                pw.println("  Enabled Providers:");
                for (String string : this.mEnabledProviders) {
                    pw.println("    " + string);
                }
            }
            if (this.mDisabledProviders.size() > 0) {
                pw.println("  Disabled Providers:");
                for (String string : this.mDisabledProviders) {
                    pw.println("    " + string);
                }
            }
            if (this.mMockProviders.size() > 0) {
                pw.println("  Mock Providers:");
                for (Map.Entry entry : this.mMockProviders.entrySet()) {
                    ((MockProvider)entry.getValue()).dump(pw, "      ");
                }
            }
            for (LocationProviderInterface locationProviderInterface : this.mProviders) {
                String state = locationProviderInterface.getInternalState();
                if (state == null) continue;
                pw.println(locationProviderInterface.getName() + " Internal State:");
                pw.write(state);
            }
        }
    }

    private class LocationWorkerHandler
    extends Handler {
        private LocationWorkerHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            block12: {
                try {
                    if (msg.what == 1) {
                        Object object = LocationManagerService.this.mLock;
                        synchronized (object) {
                            boolean passive;
                            Location location = (Location)msg.obj;
                            String provider = location.getProvider();
                            boolean bl = passive = msg.arg1 == 1;
                            if (!passive) {
                                for (int i = LocationManagerService.this.mProviders.size() - 1; i >= 0; --i) {
                                    LocationProviderInterface p = (LocationProviderInterface)LocationManagerService.this.mProviders.get(i);
                                    if (provider.equals(p.getName())) continue;
                                    p.updateLocation(location);
                                }
                            }
                            if (LocationManagerService.this.isAllowedBySettingsLocked(provider)) {
                                LocationManagerService.this.handleLocationChangedLocked(location, passive);
                            }
                            break block12;
                        }
                    }
                    if (msg.what == 2) {
                        String packageName = (String)msg.obj;
                        String packageDot = packageName + ".";
                        if (LocationManagerService.this.mNetworkLocationProvider != null && LocationManagerService.this.mNetworkLocationProviderPackageName.startsWith(packageDot)) {
                            LocationManagerService.this.mNetworkLocationProvider.reconnect();
                        }
                        if (LocationManagerService.this.mGeocodeProvider != null && LocationManagerService.this.mGeocodeProviderPackageName.startsWith(packageDot)) {
                            LocationManagerService.this.mGeocodeProvider.reconnect();
                        }
                    }
                }
                catch (Exception e) {
                    Slog.e((String)"LocationManagerService", (String)"Exception in LocationWorkerHandler.handleMessage:", (Throwable)e);
                }
            }
        }
    }

    class ProximityListener
    extends ILocationListener.Stub
    implements PendingIntent.OnFinished {
        boolean isGpsAvailable = false;

        ProximityListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLocationChanged(Location loc) {
            if (loc.getProvider().equals("gps")) {
                this.isGpsAvailable = true;
            }
            if (this.isGpsAvailable && loc.getProvider().equals("network")) {
                return;
            }
            long now = System.currentTimeMillis();
            double latitude = loc.getLatitude();
            double longitude = loc.getLongitude();
            float accuracy = loc.getAccuracy();
            ArrayList<PendingIntent> intentsToRemove = null;
            for (ProximityAlert alert : LocationManagerService.this.mProximityAlerts.values()) {
                PendingIntent intent = alert.getIntent();
                long expiration = alert.getExpiration();
                if (expiration == -1L || now <= expiration) {
                    boolean entered = LocationManagerService.this.mProximitiesEntered.contains(alert);
                    boolean inProximity = alert.isInProximity(latitude, longitude, accuracy);
                    if (!entered && inProximity) {
                        LocationManagerService.this.mProximitiesEntered.add(alert);
                        Intent enteredIntent = new Intent();
                        enteredIntent.putExtra("entering", true);
                        try {
                            ProximityListener proximityListener = this;
                            synchronized (proximityListener) {
                                intent.send(LocationManagerService.this.mContext, 0, enteredIntent, (PendingIntent.OnFinished)this, (Handler)LocationManagerService.this.mLocationHandler, LocationManagerService.ACCESS_FINE_LOCATION);
                                LocationManagerService.this.incrementPendingBroadcasts();
                                continue;
                            }
                        }
                        catch (PendingIntent.CanceledException e) {
                            if (intentsToRemove == null) {
                                intentsToRemove = new ArrayList();
                            }
                            intentsToRemove.add(intent);
                            continue;
                        }
                    }
                    if (!entered || inProximity) continue;
                    LocationManagerService.this.mProximitiesEntered.remove(alert);
                    Intent exitedIntent = new Intent();
                    exitedIntent.putExtra("entering", false);
                    try {
                        ProximityListener e = this;
                        synchronized (e) {
                            intent.send(LocationManagerService.this.mContext, 0, exitedIntent, (PendingIntent.OnFinished)this, (Handler)LocationManagerService.this.mLocationHandler, LocationManagerService.ACCESS_FINE_LOCATION);
                            LocationManagerService.this.incrementPendingBroadcasts();
                            continue;
                        }
                    }
                    catch (PendingIntent.CanceledException e) {
                        if (intentsToRemove == null) {
                            intentsToRemove = new ArrayList();
                        }
                        intentsToRemove.add(intent);
                        continue;
                    }
                }
                if (intentsToRemove == null) {
                    intentsToRemove = new ArrayList<PendingIntent>();
                }
                intentsToRemove.add(alert.getIntent());
            }
            if (intentsToRemove != null) {
                for (PendingIntent i : intentsToRemove) {
                    ProximityAlert alert = (ProximityAlert)LocationManagerService.this.mProximityAlerts.get(i);
                    LocationManagerService.this.mProximitiesEntered.remove(alert);
                    LocationManagerService.this.removeProximityAlertLocked(i);
                }
            }
        }

        public void onProviderDisabled(String provider) {
            if (provider.equals("gps")) {
                this.isGpsAvailable = false;
            }
        }

        public void onProviderEnabled(String provider) {
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            if (provider.equals("gps") && status != 2) {
                this.isGpsAvailable = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
            ProximityListener proximityListener = this;
            synchronized (proximityListener) {
                LocationManagerService.this.decrementPendingBroadcasts();
            }
        }
    }

    class ProximityAlert {
        final int mUid;
        final double mLatitude;
        final double mLongitude;
        final float mRadius;
        final long mExpiration;
        final PendingIntent mIntent;
        final Location mLocation;

        public ProximityAlert(int uid, double latitude, double longitude, float radius, long expiration, PendingIntent intent) {
            this.mUid = uid;
            this.mLatitude = latitude;
            this.mLongitude = longitude;
            this.mRadius = radius;
            this.mExpiration = expiration;
            this.mIntent = intent;
            this.mLocation = new Location("");
            this.mLocation.setLatitude(latitude);
            this.mLocation.setLongitude(longitude);
        }

        long getExpiration() {
            return this.mExpiration;
        }

        PendingIntent getIntent() {
            return this.mIntent;
        }

        boolean isInProximity(double latitude, double longitude, float accuracy) {
            Location loc = new Location("");
            loc.setLatitude(latitude);
            loc.setLongitude(longitude);
            double radius = loc.distanceTo(this.mLocation);
            return radius <= (double)Math.max(this.mRadius, accuracy);
        }

        public String toString() {
            return "ProximityAlert{" + Integer.toHexString(System.identityHashCode(this)) + " uid " + this.mUid + this.mIntent + "}";
        }

        void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + this);
            pw.println(prefix + "mLatitude=" + this.mLatitude + " mLongitude=" + this.mLongitude);
            pw.println(prefix + "mRadius=" + this.mRadius + " mExpiration=" + this.mExpiration);
            pw.println(prefix + "mIntent=" + this.mIntent);
            pw.println(prefix + "mLocation:");
            this.mLocation.dump((Printer)new PrintWriterPrinter(pw), prefix + "  ");
        }
    }

    private class UpdateRecord {
        final String mProvider;
        final Receiver mReceiver;
        final long mMinTime;
        final float mMinDistance;
        final boolean mSingleShot;
        final int mUid;
        Location mLastFixBroadcast;
        long mLastStatusBroadcast;

        UpdateRecord(String provider, long minTime, float minDistance, boolean singleShot, Receiver receiver, int uid) {
            this.mProvider = provider;
            this.mReceiver = receiver;
            this.mMinTime = minTime;
            this.mMinDistance = minDistance;
            this.mSingleShot = singleShot;
            this.mUid = uid;
            ArrayList<UpdateRecord> records = (ArrayList<UpdateRecord>)LocationManagerService.this.mRecordsByProvider.get(provider);
            if (records == null) {
                records = new ArrayList<UpdateRecord>();
                LocationManagerService.this.mRecordsByProvider.put(provider, records);
            }
            if (!records.contains(this)) {
                records.add(this);
            }
        }

        void disposeLocked() {
            ArrayList records = (ArrayList)LocationManagerService.this.mRecordsByProvider.get(this.mProvider);
            if (records != null) {
                records.remove(this);
            }
        }

        public String toString() {
            return "UpdateRecord{" + Integer.toHexString(System.identityHashCode(this)) + " mProvider: " + this.mProvider + " mUid: " + this.mUid + "}";
        }

        void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + this);
            pw.println(prefix + "mProvider=" + this.mProvider + " mReceiver=" + this.mReceiver);
            pw.println(prefix + "mMinTime=" + this.mMinTime + " mMinDistance=" + this.mMinDistance);
            pw.println(prefix + "mSingleShot=" + this.mSingleShot);
            pw.println(prefix + "mUid=" + this.mUid);
            pw.println(prefix + "mLastFixBroadcast:");
            if (this.mLastFixBroadcast != null) {
                this.mLastFixBroadcast.dump((Printer)new PrintWriterPrinter(pw), prefix + "  ");
            }
            pw.println(prefix + "mLastStatusBroadcast=" + this.mLastStatusBroadcast);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LpCapabilityComparator
    implements Comparator<LocationProviderInterface> {
        private static final int ALTITUDE_SCORE = 4;
        private static final int BEARING_SCORE = 4;
        private static final int SPEED_SCORE = 4;

        private LpCapabilityComparator() {
        }

        private int score(LocationProviderInterface p) {
            return (p.supportsAltitude() ? 4 : 0) + (p.supportsBearing() ? 4 : 0) + (p.supportsSpeed() ? 4 : 0);
        }

        @Override
        public int compare(LocationProviderInterface l1, LocationProviderInterface l2) {
            return this.score(l2) - this.score(l1);
        }

        public boolean equals(LocationProviderInterface l1, LocationProviderInterface l2) {
            return this.score(l1) == this.score(l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LpAccuracyComparator
    implements Comparator<LocationProviderInterface> {
        private LpAccuracyComparator() {
        }

        @Override
        public int compare(LocationProviderInterface l1, LocationProviderInterface l2) {
            return l1.getAccuracy() - l2.getAccuracy();
        }

        public boolean equals(LocationProviderInterface l1, LocationProviderInterface l2) {
            return l1.getAccuracy() == l2.getAccuracy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LpPowerComparator
    implements Comparator<LocationProviderInterface> {
        private LpPowerComparator() {
        }

        @Override
        public int compare(LocationProviderInterface l1, LocationProviderInterface l2) {
            return l1.getPowerRequirement() - l2.getPowerRequirement();
        }

        public boolean equals(LocationProviderInterface l1, LocationProviderInterface l2) {
            return l1.getPowerRequirement() == l2.getPowerRequirement();
        }
    }

    private final class SettingsObserver
    implements Observer {
        private SettingsObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Observable o, Object arg) {
            Object object = LocationManagerService.this.mLock;
            synchronized (object) {
                LocationManagerService.this.updateProvidersLocked();
            }
        }
    }

    private final class Receiver
    implements IBinder.DeathRecipient,
    PendingIntent.OnFinished {
        final ILocationListener mListener;
        final PendingIntent mPendingIntent;
        final Object mKey;
        final HashMap<String, UpdateRecord> mUpdateRecords = new HashMap();
        int mPendingBroadcasts;
        String requiredPermissions;

        Receiver(ILocationListener listener) {
            this.mListener = listener;
            this.mPendingIntent = null;
            this.mKey = listener.asBinder();
        }

        Receiver(PendingIntent intent) {
            this.mPendingIntent = intent;
            this.mListener = null;
            this.mKey = intent;
        }

        public boolean equals(Object otherObj) {
            if (otherObj instanceof Receiver) {
                return this.mKey.equals(((Receiver)otherObj).mKey);
            }
            return false;
        }

        public int hashCode() {
            return this.mKey.hashCode();
        }

        public String toString() {
            String result = this.mListener != null ? "Receiver{" + Integer.toHexString(System.identityHashCode(this)) + " Listener " + this.mKey + "}" : "Receiver{" + Integer.toHexString(System.identityHashCode(this)) + " Intent " + this.mKey + "}";
            result = result + "mUpdateRecords: " + this.mUpdateRecords;
            return result;
        }

        public boolean isListener() {
            return this.mListener != null;
        }

        public boolean isPendingIntent() {
            return this.mPendingIntent != null;
        }

        public ILocationListener getListener() {
            if (this.mListener != null) {
                return this.mListener;
            }
            throw new IllegalStateException("Request for non-existent listener");
        }

        public PendingIntent getPendingIntent() {
            if (this.mPendingIntent != null) {
                return this.mPendingIntent;
            }
            throw new IllegalStateException("Request for non-existent intent");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean callStatusChangedLocked(String provider, int status, Bundle extras) {
            block12: {
                if (this.mListener != null) {
                    try {
                        Receiver receiver = this;
                        synchronized (receiver) {
                            this.mListener.onStatusChanged(provider, status, extras);
                            if (this.mListener != LocationManagerService.this.mProximityListener) {
                                this.incrementPendingBroadcastsLocked();
                            }
                            break block12;
                        }
                    }
                    catch (RemoteException e) {
                        return false;
                    }
                }
                Intent statusChanged = new Intent();
                statusChanged.putExtras(extras);
                statusChanged.putExtra("status", status);
                try {
                    Receiver receiver = this;
                    synchronized (receiver) {
                        this.mPendingIntent.send(LocationManagerService.this.mContext, 0, statusChanged, (PendingIntent.OnFinished)this, (Handler)LocationManagerService.this.mLocationHandler, this.requiredPermissions);
                        this.incrementPendingBroadcastsLocked();
                    }
                }
                catch (PendingIntent.CanceledException e) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean callLocationChangedLocked(Location location) {
            block12: {
                if (this.mListener != null) {
                    try {
                        Receiver receiver = this;
                        synchronized (receiver) {
                            this.mListener.onLocationChanged(location);
                            if (this.mListener != LocationManagerService.this.mProximityListener) {
                                this.incrementPendingBroadcastsLocked();
                            }
                            break block12;
                        }
                    }
                    catch (RemoteException e) {
                        return false;
                    }
                }
                Intent locationChanged = new Intent();
                locationChanged.putExtra("location", (Parcelable)location);
                try {
                    Receiver receiver = this;
                    synchronized (receiver) {
                        this.mPendingIntent.send(LocationManagerService.this.mContext, 0, locationChanged, (PendingIntent.OnFinished)this, (Handler)LocationManagerService.this.mLocationHandler, this.requiredPermissions);
                        this.incrementPendingBroadcastsLocked();
                    }
                }
                catch (PendingIntent.CanceledException e) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean callProviderEnabledLocked(String provider, boolean enabled) {
            block14: {
                if (this.mListener != null) {
                    try {
                        Receiver receiver = this;
                        synchronized (receiver) {
                            if (enabled) {
                                this.mListener.onProviderEnabled(provider);
                            } else {
                                this.mListener.onProviderDisabled(provider);
                            }
                            if (this.mListener != LocationManagerService.this.mProximityListener) {
                                this.incrementPendingBroadcastsLocked();
                            }
                            break block14;
                        }
                    }
                    catch (RemoteException e) {
                        return false;
                    }
                }
                Intent providerIntent = new Intent();
                providerIntent.putExtra("providerEnabled", enabled);
                try {
                    Receiver receiver = this;
                    synchronized (receiver) {
                        this.mPendingIntent.send(LocationManagerService.this.mContext, 0, providerIntent, (PendingIntent.OnFinished)this, (Handler)LocationManagerService.this.mLocationHandler, this.requiredPermissions);
                        this.incrementPendingBroadcastsLocked();
                    }
                }
                catch (PendingIntent.CanceledException e) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Object object = LocationManagerService.this.mLock;
            synchronized (object) {
                LocationManagerService.this.removeUpdatesLocked(this);
            }
            object = this;
            synchronized (object) {
                if (this.mPendingBroadcasts > 0) {
                    LocationManagerService.this.decrementPendingBroadcasts();
                    this.mPendingBroadcasts = 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
            Receiver receiver = this;
            synchronized (receiver) {
                this.decrementPendingBroadcastsLocked();
            }
        }

        private void incrementPendingBroadcastsLocked() {
            if (this.mPendingBroadcasts++ == 0) {
                LocationManagerService.this.incrementPendingBroadcasts();
            }
        }

        private void decrementPendingBroadcastsLocked() {
            if (--this.mPendingBroadcasts == 0) {
                LocationManagerService.this.decrementPendingBroadcasts();
            }
        }
    }
}

