/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.RecoverySystem;
import android.util.Log;
import android.util.Slog;
import java.io.IOException;

public class MasterClearReceiver
extends BroadcastReceiver {
    private static final String TAG = "MasterClear";

    public void onReceive(final Context context, Intent intent) {
        if (intent.getAction().equals("com.google.android.c2dm.intent.RECEIVE") && !"google.com".equals(intent.getStringExtra("from"))) {
            Slog.w((String)TAG, (String)"Ignoring master clear request -- not from trusted server.");
            return;
        }
        Slog.w((String)TAG, (String)"!!! FACTORY RESET !!!");
        Thread thr = new Thread("Reboot"){

            public void run() {
                try {
                    RecoverySystem.rebootWipeUserData((Context)context);
                    Log.wtf((String)MasterClearReceiver.TAG, (String)"Still running after master clear?!");
                }
                catch (IOException e) {
                    Slog.e((String)MasterClearReceiver.TAG, (String)"Can't perform master clear/factory reset", (Throwable)e);
                }
            }
        };
        thr.start();
    }
}

