/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.res.ObbInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.net.Uri;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.storage.IMountService;
import android.os.storage.IMountServiceListener;
import android.os.storage.IMountShutdownObserver;
import android.os.storage.IObbActionListener;
import android.os.storage.StorageVolume;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.app.IMediaContainerService;
import com.android.internal.util.XmlUtils;
import com.android.server.INativeDaemonConnectorCallbacks;
import com.android.server.NativeDaemonConnector;
import com.android.server.NativeDaemonConnectorException;
import com.android.server.Watchdog;
import com.android.server.am.ActivityManagerService;
import com.android.server.pm.PackageManagerService;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class MountService
extends IMountService.Stub
implements INativeDaemonConnectorCallbacks,
Watchdog.Monitor {
    private static final boolean LOCAL_LOGD = false;
    private static final boolean DEBUG_UNMOUNT = false;
    private static final boolean DEBUG_EVENTS = false;
    private static final boolean DEBUG_OBB = false;
    private static final boolean WATCHDOG_ENABLE = false;
    private static final String TAG = "MountService";
    private static final String VOLD_TAG = "VoldConnector";
    private static final int MAX_CONTAINERS = 250;
    private Context mContext;
    private NativeDaemonConnector mConnector;
    private final ArrayList<StorageVolume> mVolumes = new ArrayList();
    private StorageVolume mPrimaryVolume;
    private final HashMap<String, String> mVolumeStates = new HashMap();
    private final HashMap<String, StorageVolume> mVolumeMap = new HashMap();
    private String mExternalStoragePath;
    private PackageManagerService mPms;
    private boolean mUmsEnabling;
    private boolean mUmsAvailable = false;
    private final ArrayList<MountServiceBinderListener> mListeners = new ArrayList();
    private boolean mBooted = false;
    private boolean mReady = false;
    private boolean mSendUmsConnectedOnBoot = false;
    private boolean mEmulateExternalStorage = false;
    private final HashSet<String> mAsecMountSet = new HashSet();
    private static final int CRYPTO_ALGORITHM_KEY_SIZE = 128;
    private static final int PBKDF2_HASH_ROUNDS = 1024;
    private final Map<IBinder, List<ObbState>> mObbMounts = new HashMap<IBinder, List<ObbState>>();
    private final Map<String, ObbState> mObbPathToStateMap = new HashMap<String, ObbState>();
    private final ObbActionHandler mObbActionHandler;
    private static final int OBB_RUN_ACTION = 1;
    private static final int OBB_MCS_BOUND = 2;
    private static final int OBB_MCS_UNBIND = 3;
    private static final int OBB_MCS_RECONNECT = 4;
    private static final int OBB_FLUSH_MOUNT_STATE = 5;
    static final ComponentName DEFAULT_CONTAINER_COMPONENT = new ComponentName("com.android.defcontainer", "com.android.defcontainer.DefaultContainerService");
    private final DefaultContainerConnection mDefContainerConn = new DefaultContainerConnection();
    private IMediaContainerService mContainerService = null;
    private static final int H_UNMOUNT_PM_UPDATE = 1;
    private static final int H_UNMOUNT_PM_DONE = 2;
    private static final int H_UNMOUNT_MS = 3;
    private static final int RETRY_UNMOUNT_DELAY = 30;
    private static final int MAX_UNMOUNT_RETRIES = 4;
    private final HandlerThread mHandlerThread;
    private final Handler mHandler;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.BOOT_COMPLETED")) {
                MountService.this.mBooted = true;
                if ("simulator".equals(SystemProperties.get((String)"ro.product.device"))) {
                    MountService.this.notifyVolumeStateChange(null, "/sdcard", 0, 4);
                    return;
                }
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            String[] states;
                            String[] paths;
                            int count;
                            HashMap hashMap = MountService.this.mVolumeStates;
                            synchronized (hashMap) {
                                Set keys = MountService.this.mVolumeStates.keySet();
                                count = keys.size();
                                paths = keys.toArray(new String[count]);
                                states = new String[count];
                                for (int i = 0; i < count; ++i) {
                                    states[i] = (String)MountService.this.mVolumeStates.get(paths[i]);
                                }
                            }
                            for (int i = 0; i < count; ++i) {
                                String path = paths[i];
                                String state = states[i];
                                if (state.equals("unmounted")) {
                                    int rc = MountService.this.doMountVolume(path);
                                    if (rc == 0) continue;
                                    Slog.e((String)MountService.TAG, (String)String.format("Boot-time mount failed (%d)", rc));
                                    continue;
                                }
                                if (!state.equals("shared")) continue;
                                MountService.this.notifyVolumeStateChange(null, path, 0, 7);
                            }
                            if (MountService.this.mEmulateExternalStorage) {
                                MountService.this.notifyVolumeStateChange(null, Environment.getExternalStorageDirectory().getPath(), 0, 4);
                            }
                            if (MountService.this.mSendUmsConnectedOnBoot) {
                                MountService.this.sendUmsIntent(true);
                                MountService.this.mSendUmsConnectedOnBoot = false;
                            }
                        }
                        catch (Exception ex) {
                            Slog.e((String)MountService.TAG, (String)"Boot-time mount exception", (Throwable)ex);
                        }
                    }
                }.start();
            } else if (action.equals("android.hardware.usb.action.USB_STATE")) {
                boolean available = intent.getBooleanExtra("connected", false) && intent.getBooleanExtra("mass_storage", false);
                MountService.this.notifyShareAvailabilityChange(available);
            }
        }
    };
    private static final String TAG_STORAGE_LIST = "StorageList";
    private static final String TAG_STORAGE = "storage";

    private void waitForReady() {
        while (!this.mReady) {
            for (int retries = 5; retries > 0; --retries) {
                if (this.mReady) {
                    return;
                }
                SystemClock.sleep((long)1000L);
            }
            Slog.w((String)TAG, (String)"Waiting too long for mReady!");
        }
    }

    private void doShareUnshareVolume(String path, String method, boolean enable) {
        if (!method.equals("ums")) {
            throw new IllegalArgumentException(String.format("Method %s not supported", method));
        }
        try {
            this.mConnector.doCommand(String.format("volume %sshare %s %s", enable ? "" : "un", path, method));
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e((String)TAG, (String)"Failed to share/unshare", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePublicVolumeState(String path, String state) {
        String oldState;
        Cloneable cloneable = this.mVolumeStates;
        synchronized (cloneable) {
            oldState = this.mVolumeStates.put(path, state);
        }
        if (state.equals(oldState)) {
            Slog.w((String)TAG, (String)String.format("Duplicate state transition (%s -> %s) for %s", state, state, path));
            return;
        }
        Slog.d((String)TAG, (String)("volume state changed for " + path + " (" + oldState + " -> " + state + ")"));
        if (path.equals(this.mExternalStoragePath) && !this.mEmulateExternalStorage) {
            if ("unmounted".equals(state)) {
                this.mPms.updateExternalMediaStatus(false, false);
                this.mObbActionHandler.sendMessage(this.mObbActionHandler.obtainMessage(5, path));
            } else if ("mounted".equals(state)) {
                this.mPms.updateExternalMediaStatus(true, false);
            }
        }
        cloneable = this.mListeners;
        synchronized (cloneable) {
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                MountServiceBinderListener bl = this.mListeners.get(i);
                try {
                    bl.mListener.onStorageStateChanged(path, oldState, state);
                    continue;
                }
                catch (RemoteException rex) {
                    Slog.e((String)TAG, (String)"Listener dead");
                    this.mListeners.remove(i);
                    continue;
                }
                catch (Exception ex) {
                    Slog.e((String)TAG, (String)"Listener failed", (Throwable)ex);
                }
            }
        }
    }

    public void onDaemonConnected() {
        new Thread(){

            public void run() {
                try {
                    String[] vols;
                    for (String volstr : vols = MountService.this.mConnector.doListCommand("volume list", 110)) {
                        String[] tok = volstr.split(" ");
                        String path = tok[1];
                        String state = "removed";
                        int st = Integer.parseInt(tok[2]);
                        if (st == 0) {
                            state = "removed";
                        } else if (st == 1) {
                            state = "unmounted";
                        } else if (st == 4) {
                            state = "mounted";
                            Slog.i((String)MountService.TAG, (String)"Media already mounted on daemon connection");
                        } else if (st == 7) {
                            state = "shared";
                            Slog.i((String)MountService.TAG, (String)"Media shared on daemon connection");
                        } else {
                            throw new Exception(String.format("Unexpected state %d", st));
                        }
                        if (state == null) continue;
                        MountService.this.updatePublicVolumeState(path, state);
                    }
                }
                catch (Exception e) {
                    Slog.e((String)MountService.TAG, (String)"Error processing initial volume state", (Throwable)e);
                    MountService.this.updatePublicVolumeState(MountService.this.mExternalStoragePath, "removed");
                }
                MountService.this.mReady = true;
            }
        }.start();
    }

    public boolean onEvent(int code, String raw, String[] cooked) {
        if (code == 605) {
            this.notifyVolumeStateChange(cooked[2], cooked[3], Integer.parseInt(cooked[7]), Integer.parseInt(cooked[10]));
        } else if (code == 630 || code == 631 || code == 632) {
            String action = null;
            String label = cooked[2];
            final String path = cooked[3];
            int major = -1;
            int minor = -1;
            try {
                String devComp = cooked[6].substring(1, cooked[6].length() - 1);
                String[] devTok = devComp.split(":");
                major = Integer.parseInt(devTok[0]);
                minor = Integer.parseInt(devTok[1]);
            }
            catch (Exception ex) {
                Slog.e((String)TAG, (String)"Failed to parse major/minor", (Throwable)ex);
            }
            if (code == 630) {
                new Thread(){

                    public void run() {
                        try {
                            int rc = MountService.this.doMountVolume(path);
                            if (rc != 0) {
                                Slog.w((String)MountService.TAG, (String)String.format("Insertion mount failed (%d)", rc));
                            }
                        }
                        catch (Exception ex) {
                            Slog.w((String)MountService.TAG, (String)"Failed to mount media on insertion", (Throwable)ex);
                        }
                    }
                }.start();
            } else if (code == 631) {
                if (this.getVolumeState(path).equals("bad_removal")) {
                    return true;
                }
                this.updatePublicVolumeState(path, "unmounted");
                this.sendStorageIntent("unmounted", path);
                this.updatePublicVolumeState(path, "removed");
                action = "android.intent.action.MEDIA_REMOVED";
            } else if (code == 632) {
                this.updatePublicVolumeState(path, "unmounted");
                action = "android.intent.action.MEDIA_UNMOUNTED";
                this.updatePublicVolumeState(path, "bad_removal");
                action = "android.intent.action.MEDIA_BAD_REMOVAL";
            } else {
                Slog.e((String)TAG, (String)String.format("Unknown code {%d}", code));
            }
            if (action != null) {
                this.sendStorageIntent(action, path);
            }
        } else {
            return false;
        }
        return true;
    }

    private void notifyVolumeStateChange(String label, String path, int oldState, int newState) {
        String vs = this.getVolumeState(path);
        String action = null;
        if (oldState == 7 && newState != oldState) {
            this.sendStorageIntent("android.intent.action.MEDIA_UNSHARED", path);
        }
        if (newState != -1 && newState != 0) {
            if (newState == 1) {
                if (!(vs.equals("bad_removal") || vs.equals("nofs") || vs.equals("unmountable") || this.getUmsEnabling())) {
                    this.updatePublicVolumeState(path, "unmounted");
                    action = "android.intent.action.MEDIA_UNMOUNTED";
                }
            } else if (newState != 2) {
                if (newState == 3) {
                    this.updatePublicVolumeState(path, "checking");
                    action = "android.intent.action.MEDIA_CHECKING";
                } else if (newState == 4) {
                    this.updatePublicVolumeState(path, "mounted");
                    action = "android.intent.action.MEDIA_MOUNTED";
                } else if (newState == 5) {
                    action = "android.intent.action.MEDIA_EJECT";
                } else if (newState != 6) {
                    if (newState == 7) {
                        this.updatePublicVolumeState(path, "unmounted");
                        this.sendStorageIntent("android.intent.action.MEDIA_UNMOUNTED", path);
                        this.updatePublicVolumeState(path, "shared");
                        action = "android.intent.action.MEDIA_SHARED";
                    } else {
                        if (newState == 8) {
                            Slog.e((String)TAG, (String)"Live shared mounts not supported yet!");
                            return;
                        }
                        Slog.e((String)TAG, (String)("Unhandled VolumeState {" + newState + "}"));
                    }
                }
            }
        }
        if (action != null) {
            this.sendStorageIntent(action, path);
        }
    }

    private int doMountVolume(String path) {
        int rc;
        block8: {
            rc = 0;
            try {
                this.mConnector.doCommand(String.format("volume mount %s", path));
            }
            catch (NativeDaemonConnectorException e) {
                String action = null;
                int code = e.getCode();
                if (code == 401) {
                    rc = -2;
                } else if (code == 402) {
                    this.updatePublicVolumeState(path, "nofs");
                    action = "android.intent.action.MEDIA_NOFS";
                    rc = -3;
                } else if (code == 403) {
                    this.updatePublicVolumeState(path, "unmountable");
                    action = "android.intent.action.MEDIA_UNMOUNTABLE";
                    rc = -4;
                } else {
                    rc = -1;
                }
                if (action == null) break block8;
                this.sendStorageIntent(action, path);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doUnmountVolume(String path, boolean force, boolean removeEncryption) {
        if (!this.getVolumeState(path).equals("mounted")) {
            return 404;
        }
        Runtime.getRuntime().gc();
        this.mPms.updateExternalMediaStatus(false, false);
        try {
            String arg = removeEncryption ? " force_and_revert" : (force ? " force" : "");
            this.mConnector.doCommand(String.format("volume unmount %s%s", path, arg));
            HashSet<String> hashSet = this.mAsecMountSet;
            synchronized (hashSet) {
                this.mAsecMountSet.clear();
            }
            return 0;
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            if (code == 404) {
                return -5;
            }
            if (code == 405) {
                return -7;
            }
            return -1;
        }
    }

    private int doFormatVolume(String path) {
        try {
            String cmd = String.format("volume format %s", path);
            this.mConnector.doCommand(cmd);
            return 0;
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            if (code == 401) {
                return -2;
            }
            if (code == 403) {
                return -4;
            }
            return -1;
        }
    }

    private boolean doGetVolumeShared(String path, String method) {
        ArrayList<String> rsp;
        String cmd = String.format("volume shared %s %s", path, method);
        try {
            rsp = this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException ex) {
            Slog.e((String)TAG, (String)("Failed to read response to volume shared " + path + " " + method));
            return false;
        }
        Iterator<String> i$ = rsp.iterator();
        if (i$.hasNext()) {
            int code;
            String line = i$.next();
            String[] tok = line.split(" ");
            if (tok.length < 3) {
                Slog.e((String)TAG, (String)("Malformed response to volume shared " + path + " " + method + " command"));
                return false;
            }
            try {
                code = Integer.parseInt(tok[0]);
            }
            catch (NumberFormatException nfe) {
                Slog.e((String)TAG, (String)String.format("Error parsing code %s", tok[0]));
                return false;
            }
            if (code == 212) {
                return "enabled".equals(tok[2]);
            }
            Slog.e((String)TAG, (String)String.format("Unexpected response code %d", code));
            return false;
        }
        Slog.e((String)TAG, (String)"Got an empty response");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShareAvailabilityChange(boolean avail) {
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mUmsAvailable = avail;
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                MountServiceBinderListener bl = this.mListeners.get(i);
                try {
                    bl.mListener.onUsbMassStorageConnectionChanged(avail);
                    continue;
                }
                catch (RemoteException rex) {
                    Slog.e((String)TAG, (String)"Listener dead");
                    this.mListeners.remove(i);
                    continue;
                }
                catch (Exception ex) {
                    Slog.e((String)TAG, (String)"Listener failed", (Throwable)ex);
                }
            }
        }
        if (this.mBooted) {
            this.sendUmsIntent(avail);
        } else {
            this.mSendUmsConnectedOnBoot = avail;
        }
        final String path = Environment.getExternalStorageDirectory().getPath();
        if (!avail && this.getVolumeState(path).equals("shared")) {
            new Thread(){

                public void run() {
                    try {
                        Slog.w((String)MountService.TAG, (String)"Disabling UMS after cable disconnect");
                        MountService.this.doShareUnshareVolume(path, "ums", false);
                        int rc = MountService.this.doMountVolume(path);
                        if (rc != 0) {
                            Slog.e((String)MountService.TAG, (String)String.format("Failed to remount {%s} on UMS enabled-disconnect (%d)", path, rc));
                        }
                    }
                    catch (Exception ex) {
                        Slog.w((String)MountService.TAG, (String)"Failed to mount media on UMS enabled-disconnect", (Throwable)ex);
                    }
                }
            }.start();
        }
    }

    private void sendStorageIntent(String action, String path) {
        Intent intent = new Intent(action, Uri.parse((String)("file://" + path)));
        intent.putExtra("storage_volume", (Parcelable)this.mVolumeMap.get(path));
        Slog.d((String)TAG, (String)("sendStorageIntent " + intent));
        this.mContext.sendBroadcast(intent);
    }

    private void sendUmsIntent(boolean c) {
        this.mContext.sendBroadcast(new Intent(c ? "android.intent.action.UMS_CONNECTED" : "android.intent.action.UMS_DISCONNECTED"));
    }

    private void validatePermission(String perm) {
        if (this.mContext.checkCallingOrSelfPermission(perm) != 0) {
            throw new SecurityException(String.format("Requires %s permission", perm));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readStorageList(Resources resources) {
        int length2222;
        int id = 17760268;
        XmlResourceParser parser = resources.getXml(id);
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        try {
            try {
                XmlUtils.beginDocument((XmlPullParser)parser, (String)TAG_STORAGE_LIST);
                while (true) {
                    XmlUtils.nextElement((XmlPullParser)parser);
                    String element = parser.getName();
                    if (element == null) {
                        Object var19_19 = null;
                        length2222 = this.mVolumes.size();
                        break;
                    }
                    if (!TAG_STORAGE.equals(element)) continue;
                    TypedArray a = resources.obtainAttributes(attrs, R.styleable.Storage);
                    CharSequence path = a.getText(0);
                    CharSequence description = a.getText(1);
                    boolean primary = a.getBoolean(2, false);
                    boolean removable = a.getBoolean(3, false);
                    boolean emulated = a.getBoolean(4, false);
                    int mtpReserve = a.getInt(5, 0);
                    boolean allowMassStorage = a.getBoolean(6, false);
                    long maxFileSize = (long)a.getInt(7, 0) * 1024L * 1024L;
                    Slog.d((String)TAG, (String)("got storage path: " + path + " description: " + description + " primary: " + primary + " removable: " + removable + " emulated: " + emulated + " mtpReserve: " + mtpReserve + " allowMassStorage: " + allowMassStorage + " maxFileSize: " + maxFileSize));
                    if (path == null || description == null) {
                        Slog.e((String)TAG, (String)"path or description is null in readStorageList");
                    } else {
                        String pathString = ((Object)path).toString();
                        StorageVolume volume = new StorageVolume(pathString, ((Object)description).toString(), removable, emulated, mtpReserve, allowMassStorage, maxFileSize);
                        if (primary) {
                            if (this.mPrimaryVolume == null) {
                                this.mPrimaryVolume = volume;
                            } else {
                                Slog.e((String)TAG, (String)"multiple primary volumes in storage list");
                            }
                        }
                        if (this.mPrimaryVolume == volume) {
                            this.mVolumes.add(0, volume);
                        } else {
                            this.mVolumes.add(volume);
                        }
                        this.mVolumeMap.put(pathString, volume);
                    }
                    a.recycle();
                }
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            int length2222 = this.mVolumes.size();
            int i = 0;
            while (true) {
                if (i >= length2222) {
                    parser.close();
                    throw throwable;
                }
                this.mVolumes.get(i).setStorageId(i);
                ++i;
            }
        }
        for (int i = 0; i < length2222; ++i) {
            this.mVolumes.get(i).setStorageId(i);
        }
        parser.close();
    }

    public MountService(Context context) {
        this.mContext = context;
        Resources resources = context.getResources();
        this.readStorageList(resources);
        if (this.mPrimaryVolume != null) {
            this.mExternalStoragePath = this.mPrimaryVolume.getPath();
            this.mEmulateExternalStorage = this.mPrimaryVolume.isEmulated();
            if (this.mEmulateExternalStorage) {
                Slog.d((String)TAG, (String)"using emulated external storage");
                this.mVolumeStates.put(this.mExternalStoragePath, "mounted");
            }
        }
        this.mPms = (PackageManagerService)ServiceManager.getService((String)"package");
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BOOT_COMPLETED");
        if (this.mPrimaryVolume != null && this.mPrimaryVolume.allowMassStorage()) {
            filter.addAction("android.hardware.usb.action.USB_STATE");
        }
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter, null, null);
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new MountServiceHandler(this.mHandlerThread.getLooper());
        this.mObbActionHandler = new ObbActionHandler(this.mHandlerThread.getLooper());
        if ("simulator".equals(SystemProperties.get((String)"ro.product.device"))) {
            this.mReady = true;
            this.mUmsEnabling = true;
            return;
        }
        this.mConnector = new NativeDaemonConnector(this, "vold", 500, VOLD_TAG);
        this.mReady = false;
        Thread thread = new Thread((Runnable)this.mConnector, VOLD_TAG);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(IMountServiceListener listener) {
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            MountServiceBinderListener bl = new MountServiceBinderListener(listener);
            try {
                listener.asBinder().linkToDeath((IBinder.DeathRecipient)bl, 0);
                this.mListeners.add(bl);
            }
            catch (RemoteException rex) {
                Slog.e((String)TAG, (String)"Failed to link to listener death");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(IMountServiceListener listener) {
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (MountServiceBinderListener bl : this.mListeners) {
                if (bl.mListener != listener) continue;
                this.mListeners.remove(this.mListeners.indexOf(bl));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(IMountShutdownObserver observer) {
        this.validatePermission("android.permission.SHUTDOWN");
        Slog.i((String)TAG, (String)"Shutting down");
        HashMap<String, String> hashMap = this.mVolumeStates;
        synchronized (hashMap) {
            for (String path : this.mVolumeStates.keySet()) {
                String state = this.mVolumeStates.get(path);
                if (state.equals("shared")) {
                    this.setUsbMassStorageEnabled(false);
                } else if (state.equals("checking")) {
                    int retries = 30;
                    while (state.equals("checking") && retries-- >= 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException iex) {
                            Slog.e((String)TAG, (String)"Interrupted while waiting for media", (Throwable)iex);
                            break;
                        }
                        state = Environment.getExternalStorageState();
                    }
                    if (retries == 0) {
                        Slog.e((String)TAG, (String)"Timed out waiting for media to check");
                    }
                }
                if (state.equals("mounted")) {
                    ShutdownCallBack ucb = new ShutdownCallBack(path, observer);
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)ucb));
                    continue;
                }
                if (observer == null) continue;
                try {
                    observer.onShutDownComplete(0);
                }
                catch (RemoteException e) {
                    Slog.w((String)TAG, (String)"RemoteException when shutting down");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getUmsEnabling() {
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            return this.mUmsEnabling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUmsEnabling(boolean enable) {
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mUmsEnabling = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsbMassStorageConnected() {
        this.waitForReady();
        if (this.getUmsEnabling()) {
            return true;
        }
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            return this.mUmsAvailable;
        }
    }

    public void setUsbMassStorageEnabled(boolean enable) {
        this.waitForReady();
        this.validatePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        String path = Environment.getExternalStorageDirectory().getPath();
        String vs = this.getVolumeState(path);
        String method = "ums";
        if (enable && vs.equals("mounted")) {
            this.setUmsEnabling(enable);
            UmsEnableCallBack umscb = new UmsEnableCallBack(path, method, true);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)umscb));
            this.setUmsEnabling(false);
        }
        if (!enable) {
            this.doShareUnshareVolume(path, method, enable);
            if (this.doMountVolume(path) != 0) {
                Slog.e((String)TAG, (String)("Failed to remount " + path + " after disabling share method " + method));
            }
        }
    }

    public boolean isUsbMassStorageEnabled() {
        this.waitForReady();
        return this.doGetVolumeShared(Environment.getExternalStorageDirectory().getPath(), "ums");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVolumeState(String mountPoint) {
        HashMap<String, String> hashMap = this.mVolumeStates;
        synchronized (hashMap) {
            String state = this.mVolumeStates.get(mountPoint);
            if (state == null) {
                Slog.w((String)TAG, (String)("getVolumeState(" + mountPoint + "): Unknown volume"));
                if (SystemProperties.get((String)"vold.encrypt_progress").length() != 0) {
                    state = "removed";
                } else {
                    throw new IllegalArgumentException();
                }
            }
            return state;
        }
    }

    public boolean isExternalStorageEmulated() {
        return this.mEmulateExternalStorage;
    }

    public int mountVolume(String path) {
        this.validatePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        this.waitForReady();
        return this.doMountVolume(path);
    }

    public void unmountVolume(String path, boolean force, boolean removeEncryption) {
        this.validatePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        this.waitForReady();
        String volState = this.getVolumeState(path);
        if ("unmounted".equals(volState) || "removed".equals(volState) || "shared".equals(volState) || "unmountable".equals(volState)) {
            return;
        }
        UnmountCallBack ucb = new UnmountCallBack(path, force, removeEncryption);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)ucb));
    }

    public int formatVolume(String path) {
        this.validatePermission("android.permission.MOUNT_FORMAT_FILESYSTEMS");
        this.waitForReady();
        return this.doFormatVolume(path);
    }

    public int[] getStorageUsers(String path) {
        this.validatePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        this.waitForReady();
        try {
            String[] r = this.mConnector.doListCommand(String.format("storage users %s", path), 112);
            int[] data = new int[r.length];
            for (int i = 0; i < r.length; ++i) {
                String[] tok = r[i].split(" ");
                try {
                    data[i] = Integer.parseInt(tok[0]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    Slog.e((String)TAG, (String)String.format("Error parsing pid %s", tok[0]));
                    return new int[0];
                }
            }
            return data;
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e((String)TAG, (String)"Failed to retrieve storage users list", (Throwable)e);
            return new int[0];
        }
    }

    private void warnOnNotMounted() {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            Slog.w((String)TAG, (String)"getSecureContainerList() called when storage not mounted");
        }
    }

    public String[] getSecureContainerList() {
        this.validatePermission("android.permission.ASEC_ACCESS");
        this.waitForReady();
        this.warnOnNotMounted();
        try {
            return this.mConnector.doListCommand("asec list", 111);
        }
        catch (NativeDaemonConnectorException e) {
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createSecureContainer(String id, int sizeMb, String fstype, String key, int ownerUid) {
        this.validatePermission("android.permission.ASEC_CREATE");
        this.waitForReady();
        this.warnOnNotMounted();
        int rc = 0;
        String cmd = String.format("asec create %s %d %s %s %d", id, sizeMb, fstype, key, ownerUid);
        try {
            this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            rc = -1;
        }
        if (rc == 0) {
            HashSet<String> hashSet = this.mAsecMountSet;
            synchronized (hashSet) {
                this.mAsecMountSet.add(id);
            }
        }
        return rc;
    }

    public int finalizeSecureContainer(String id) {
        this.validatePermission("android.permission.ASEC_CREATE");
        this.warnOnNotMounted();
        int rc = 0;
        try {
            this.mConnector.doCommand(String.format("asec finalize %s", id));
        }
        catch (NativeDaemonConnectorException e) {
            rc = -1;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int destroySecureContainer(String id, boolean force) {
        this.validatePermission("android.permission.ASEC_DESTROY");
        this.waitForReady();
        this.warnOnNotMounted();
        Runtime.getRuntime().gc();
        int rc = 0;
        try {
            this.mConnector.doCommand(String.format("asec destroy %s%s", id, force ? " force" : ""));
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            rc = code == 405 ? -7 : -1;
        }
        if (rc == 0) {
            HashSet<String> hashSet = this.mAsecMountSet;
            synchronized (hashSet) {
                if (this.mAsecMountSet.contains(id)) {
                    this.mAsecMountSet.remove(id);
                }
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mountSecureContainer(String id, String key, int ownerUid) {
        int rc;
        block10: {
            this.validatePermission("android.permission.ASEC_MOUNT_UNMOUNT");
            this.waitForReady();
            this.warnOnNotMounted();
            HashSet<String> hashSet = this.mAsecMountSet;
            synchronized (hashSet) {
                if (this.mAsecMountSet.contains(id)) {
                    return -6;
                }
            }
            rc = 0;
            String cmd = String.format("asec mount %s %s %d", id, key, ownerUid);
            try {
                this.mConnector.doCommand(cmd);
            }
            catch (NativeDaemonConnectorException e) {
                int code = e.getCode();
                if (code == 405) break block10;
                rc = -1;
            }
        }
        if (rc == 0) {
            HashSet<String> hashSet = this.mAsecMountSet;
            synchronized (hashSet) {
                this.mAsecMountSet.add(id);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unmountSecureContainer(String id, boolean force) {
        this.validatePermission("android.permission.ASEC_MOUNT_UNMOUNT");
        this.waitForReady();
        this.warnOnNotMounted();
        HashSet<String> hashSet = this.mAsecMountSet;
        synchronized (hashSet) {
            if (!this.mAsecMountSet.contains(id)) {
                return -5;
            }
        }
        Runtime.getRuntime().gc();
        int rc = 0;
        String cmd = String.format("asec unmount %s%s", id, force ? " force" : "");
        try {
            this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            rc = code == 405 ? -7 : -1;
        }
        if (rc == 0) {
            HashSet<String> hashSet2 = this.mAsecMountSet;
            synchronized (hashSet2) {
                this.mAsecMountSet.remove(id);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecureContainerMounted(String id) {
        this.validatePermission("android.permission.ASEC_ACCESS");
        this.waitForReady();
        this.warnOnNotMounted();
        HashSet<String> hashSet = this.mAsecMountSet;
        synchronized (hashSet) {
            return this.mAsecMountSet.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int renameSecureContainer(String oldId, String newId) {
        this.validatePermission("android.permission.ASEC_RENAME");
        this.waitForReady();
        this.warnOnNotMounted();
        HashSet<String> hashSet = this.mAsecMountSet;
        synchronized (hashSet) {
            if (this.mAsecMountSet.contains(oldId) || this.mAsecMountSet.contains(newId)) {
                return -6;
            }
        }
        int rc = 0;
        String cmd = String.format("asec rename %s %s", oldId, newId);
        try {
            this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            rc = -1;
        }
        return rc;
    }

    public String getSecureContainerPath(String id) {
        this.validatePermission("android.permission.ASEC_ACCESS");
        this.waitForReady();
        this.warnOnNotMounted();
        try {
            ArrayList<String> rsp = this.mConnector.doCommand(String.format("asec path %s", id));
            String[] tok = rsp.get(0).split(" ");
            int code = Integer.parseInt(tok[0]);
            if (code != 211) {
                throw new IllegalStateException(String.format("Unexpected response code %d", code));
            }
            return tok[1];
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            if (code == 406) {
                Slog.i((String)TAG, (String)String.format("Container '%s' not found", id));
                return null;
            }
            throw new IllegalStateException(String.format("Unexpected response code %d", code));
        }
    }

    public String getSecureContainerFilesystemPath(String id) {
        this.validatePermission("android.permission.ASEC_ACCESS");
        this.waitForReady();
        this.warnOnNotMounted();
        try {
            ArrayList<String> rsp = this.mConnector.doCommand(String.format("asec fspath %s", id));
            String[] tok = rsp.get(0).split(" ");
            int code = Integer.parseInt(tok[0]);
            if (code != 211) {
                throw new IllegalStateException(String.format("Unexpected response code %d", code));
            }
            return tok[1];
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            if (code == 406) {
                Slog.i((String)TAG, (String)String.format("Container '%s' not found", id));
                return null;
            }
            throw new IllegalStateException(String.format("Unexpected response code %d", code));
        }
    }

    public void finishMediaUpdate() {
        this.mHandler.sendEmptyMessage(2);
    }

    private boolean isUidOwnerOfPackageOrSystem(String packageName, int callerUid) {
        if (callerUid == 1000) {
            return true;
        }
        if (packageName == null) {
            return false;
        }
        int packageUid = this.mPms.getPackageUid(packageName);
        return callerUid == packageUid;
    }

    public String getMountedObbPath(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        this.waitForReady();
        this.warnOnNotMounted();
        try {
            ArrayList<String> rsp = this.mConnector.doCommand(String.format("obb path %s", filename));
            String[] tok = rsp.get(0).split(" ");
            int code = Integer.parseInt(tok[0]);
            if (code != 211) {
                throw new IllegalStateException(String.format("Unexpected response code %d", code));
            }
            return tok[1];
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            if (code == 406) {
                return null;
            }
            throw new IllegalStateException(String.format("Unexpected response code %d", code));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObbMounted(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        Map<IBinder, List<ObbState>> map = this.mObbMounts;
        synchronized (map) {
            return this.mObbPathToStateMap.containsKey(filename);
        }
    }

    public void mountObb(String filename, String key, IObbActionListener token, int nonce) throws RemoteException {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null");
        }
        int callerUid = Binder.getCallingUid();
        ObbState obbState = new ObbState(filename, callerUid, token, nonce);
        MountObbAction action = new MountObbAction(obbState, key);
        this.mObbActionHandler.sendMessage(this.mObbActionHandler.obtainMessage(1, action));
    }

    public void unmountObb(String filename, boolean force, IObbActionListener token, int nonce) throws RemoteException {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        int callerUid = Binder.getCallingUid();
        ObbState obbState = new ObbState(filename, callerUid, token, nonce);
        UnmountObbAction action = new UnmountObbAction(obbState, force);
        this.mObbActionHandler.sendMessage(this.mObbActionHandler.obtainMessage(1, action));
    }

    public int getEncryptionState() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        this.waitForReady();
        try {
            ArrayList<String> rsp = this.mConnector.doCommand("cryptfs cryptocomplete");
            String[] tokens = rsp.get(0).split(" ");
            if (tokens == null || tokens.length != 2) {
                Slog.w((String)TAG, (String)"Unexpected result from cryptfs cryptocomplete");
                return -1;
            }
            return Integer.parseInt(tokens[1]);
        }
        catch (NumberFormatException e) {
            Slog.w((String)TAG, (String)"Unable to parse result from cryptfs cryptocomplete");
            return -1;
        }
        catch (NativeDaemonConnectorException e) {
            Slog.w((String)TAG, (String)"Error in communicating with cryptfs in validating");
            return -1;
        }
    }

    public int decryptStorage(String password) {
        if (TextUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        this.waitForReady();
        try {
            ArrayList<String> rsp = this.mConnector.doCommand("cryptfs checkpw " + password);
            String[] tokens = rsp.get(0).split(" ");
            if (tokens == null || tokens.length != 2) {
                return -1;
            }
            int code = Integer.parseInt(tokens[1]);
            if (code == 0) {
                this.mHandler.postDelayed(new Runnable(){

                    public void run() {
                        MountService.this.mConnector.doCommand(String.format("cryptfs restart", new Object[0]));
                    }
                }, 1000L);
            }
            return code;
        }
        catch (NativeDaemonConnectorException e) {
            return e.getCode();
        }
    }

    public int encryptStorage(String password) {
        if (TextUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        this.waitForReady();
        try {
            this.mConnector.doCommand(String.format("cryptfs enablecrypto inplace %s", password));
        }
        catch (NativeDaemonConnectorException e) {
            return e.getCode();
        }
        return 0;
    }

    public int changeEncryptionPassword(String password) {
        if (TextUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        this.waitForReady();
        try {
            ArrayList<String> response = this.mConnector.doCommand("cryptfs changepw " + password);
            String[] tokens = response.get(0).split(" ");
            if (tokens == null || tokens.length != 2) {
                return -1;
            }
            return Integer.parseInt(tokens[1]);
        }
        catch (NativeDaemonConnectorException e) {
            return e.getCode();
        }
    }

    public int verifyEncryptionPassword(String password) throws RemoteException {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("no permission to access the crypt keeper");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        if (TextUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        this.waitForReady();
        try {
            ArrayList<String> response = this.mConnector.doCommand("cryptfs verifypw " + password);
            String[] tokens = response.get(0).split(" ");
            if (tokens == null || tokens.length != 2) {
                String msg = "Unexpected result from cryptfs verifypw: {";
                if (tokens == null) {
                    msg = msg + "null";
                } else {
                    for (int i = 0; i < tokens.length; ++i) {
                        if (i != 0) {
                            msg = msg + ',';
                        }
                        msg = msg + tokens[i];
                    }
                }
                msg = msg + '}';
                Slog.e((String)TAG, (String)msg);
                return -1;
            }
            Slog.i((String)TAG, (String)("cryptfs verifypw => " + tokens[1]));
            return Integer.parseInt(tokens[1]);
        }
        catch (NativeDaemonConnectorException e) {
            return e.getCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parcelable[] getVolumeList() {
        ArrayList<StorageVolume> arrayList = this.mVolumes;
        synchronized (arrayList) {
            int size = this.mVolumes.size();
            Parcelable[] result = new Parcelable[size];
            for (int i = 0; i < size; ++i) {
                result[i] = (Parcelable)this.mVolumes.get(i);
            }
            return result;
        }
    }

    private void addObbStateLocked(ObbState obbState) throws RemoteException {
        IBinder binder = obbState.getBinder();
        List<ObbState> obbStates = this.mObbMounts.get(binder);
        if (obbStates == null) {
            obbStates = new ArrayList<ObbState>();
            this.mObbMounts.put(binder, obbStates);
        } else {
            for (ObbState o : obbStates) {
                if (!o.filename.equals(obbState.filename)) continue;
                throw new IllegalStateException("Attempt to add ObbState twice. This indicates an error in the MountService logic.");
            }
        }
        obbStates.add(obbState);
        try {
            obbState.link();
        }
        catch (RemoteException e) {
            obbStates.remove(obbState);
            if (obbStates.isEmpty()) {
                this.mObbMounts.remove(binder);
            }
            throw e;
        }
        this.mObbPathToStateMap.put(obbState.filename, obbState);
    }

    private void removeObbStateLocked(ObbState obbState) {
        IBinder binder = obbState.getBinder();
        List<ObbState> obbStates = this.mObbMounts.get(binder);
        if (obbStates != null) {
            if (obbStates.remove(obbState)) {
                obbState.unlink();
            }
            if (obbStates.isEmpty()) {
                this.mObbMounts.remove(binder);
            }
        }
        this.mObbPathToStateMap.remove(obbState.filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ActivityManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        Object object = this.mObbMounts;
        synchronized (object) {
            pw.println("  mObbMounts:");
            for (Map.Entry<IBinder, List<ObbState>> e : this.mObbMounts.entrySet()) {
                pw.print("    Key=");
                pw.println(e.getKey().toString());
                List<ObbState> obbStates = e.getValue();
                for (ObbState obbState : obbStates) {
                    pw.print("      ");
                    pw.println(obbState.toString());
                }
            }
            pw.println("");
            pw.println("  mObbPathToStateMap:");
            for (Map.Entry<String, ObbState> e : this.mObbPathToStateMap.entrySet()) {
                pw.print("    ");
                pw.print(e.getKey());
                pw.print(" -> ");
                pw.println(e.getValue().toString());
            }
        }
        pw.println("");
        object = this.mVolumes;
        synchronized (object) {
            pw.println("  mVolumes:");
            int N = this.mVolumes.size();
            for (int i = 0; i < N; ++i) {
                StorageVolume v = this.mVolumes.get(i);
                pw.print("    ");
                pw.println(v.toString());
            }
        }
    }

    public void monitor() {
        if (this.mConnector != null) {
            this.mConnector.monitor();
        }
    }

    class UnmountObbAction
    extends ObbAction {
        private final boolean mForceUnmount;

        UnmountObbAction(ObbState obbState, boolean force) {
            super(obbState);
            this.mForceUnmount = force;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleExecute() throws IOException {
            ObbState obbState;
            MountService.this.waitForReady();
            MountService.this.warnOnNotMounted();
            ObbInfo obbInfo = this.getObbInfo();
            Map map = MountService.this.mObbMounts;
            synchronized (map) {
                obbState = (ObbState)MountService.this.mObbPathToStateMap.get(obbInfo.filename);
            }
            if (obbState == null) {
                this.sendNewStatusOrIgnore(23);
                return;
            }
            if (obbState.callerUid != this.mObbState.callerUid) {
                Slog.w((String)MountService.TAG, (String)("Permission denied attempting to unmount OBB " + obbInfo.filename + " (owned by " + obbInfo.packageName + ")"));
                this.sendNewStatusOrIgnore(25);
                return;
            }
            this.mObbState.filename = obbInfo.filename;
            int rc = 0;
            String cmd = String.format("obb unmount %s%s", this.mObbState.filename, this.mForceUnmount ? " force" : "");
            try {
                MountService.this.mConnector.doCommand(cmd);
            }
            catch (NativeDaemonConnectorException e) {
                int code = e.getCode();
                rc = code == 405 ? -7 : (code == 406 ? 0 : -1);
            }
            if (rc == 0) {
                Map map2 = MountService.this.mObbMounts;
                synchronized (map2) {
                    MountService.this.removeObbStateLocked(obbState);
                }
                this.sendNewStatusOrIgnore(2);
            } else {
                Slog.w((String)MountService.TAG, (String)("Could not mount OBB: " + this.mObbState.filename));
                this.sendNewStatusOrIgnore(22);
            }
        }

        public void handleError() {
            this.sendNewStatusOrIgnore(20);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UnmountObbAction{");
            sb.append("filename=");
            sb.append(this.mObbState.filename != null ? this.mObbState.filename : "null");
            sb.append(",force=");
            sb.append(this.mForceUnmount);
            sb.append(",callerUid=");
            sb.append(this.mObbState.callerUid);
            sb.append(",token=");
            sb.append(this.mObbState.token != null ? this.mObbState.token.toString() : "null");
            sb.append(",binder=");
            sb.append(this.mObbState.token != null ? this.mObbState.getBinder().toString() : "null");
            sb.append('}');
            return sb.toString();
        }
    }

    class MountObbAction
    extends ObbAction {
        private final String mKey;

        MountObbAction(ObbState obbState, String key) {
            super(obbState);
            this.mKey = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleExecute() throws IOException, RemoteException {
            int rc;
            block17: {
                String hashedKey;
                boolean isMounted;
                MountService.this.waitForReady();
                MountService.this.warnOnNotMounted();
                ObbInfo obbInfo = this.getObbInfo();
                if (!MountService.this.isUidOwnerOfPackageOrSystem(obbInfo.packageName, this.mObbState.callerUid)) {
                    Slog.w((String)MountService.TAG, (String)("Denied attempt to mount OBB " + obbInfo.filename + " which is owned by " + obbInfo.packageName));
                    this.sendNewStatusOrIgnore(25);
                    return;
                }
                Map map = MountService.this.mObbMounts;
                synchronized (map) {
                    isMounted = MountService.this.mObbPathToStateMap.containsKey(obbInfo.filename);
                }
                if (isMounted) {
                    Slog.w((String)MountService.TAG, (String)("Attempt to mount OBB which is already mounted: " + obbInfo.filename));
                    this.sendNewStatusOrIgnore(24);
                    return;
                }
                this.mObbState.filename = obbInfo.filename;
                if (this.mKey == null) {
                    hashedKey = "none";
                } else {
                    try {
                        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                        PBEKeySpec ks = new PBEKeySpec(this.mKey.toCharArray(), obbInfo.salt, 1024, 128);
                        SecretKey key = factory.generateSecret(ks);
                        BigInteger bi = new BigInteger(key.getEncoded());
                        hashedKey = bi.toString(16);
                    }
                    catch (NoSuchAlgorithmException e) {
                        Slog.e((String)MountService.TAG, (String)"Could not load PBKDF2 algorithm", (Throwable)e);
                        this.sendNewStatusOrIgnore(20);
                        return;
                    }
                    catch (InvalidKeySpecException e) {
                        Slog.e((String)MountService.TAG, (String)"Invalid key spec when loading PBKDF2 algorithm", (Throwable)e);
                        this.sendNewStatusOrIgnore(20);
                        return;
                    }
                }
                rc = 0;
                String cmd = String.format("obb mount %s %s %d", this.mObbState.filename, hashedKey, this.mObbState.callerUid);
                try {
                    MountService.this.mConnector.doCommand(cmd);
                }
                catch (NativeDaemonConnectorException e) {
                    int code = e.getCode();
                    if (code == 405) break block17;
                    rc = -1;
                }
            }
            if (rc == 0) {
                Map map = MountService.this.mObbMounts;
                synchronized (map) {
                    MountService.this.addObbStateLocked(this.mObbState);
                }
                this.sendNewStatusOrIgnore(1);
            } else {
                Slog.e((String)MountService.TAG, (String)("Couldn't mount OBB file: " + rc));
                this.sendNewStatusOrIgnore(21);
            }
        }

        public void handleError() {
            this.sendNewStatusOrIgnore(20);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("MountObbAction{");
            sb.append("filename=");
            sb.append(this.mObbState.filename);
            sb.append(",callerUid=");
            sb.append(this.mObbState.callerUid);
            sb.append(",token=");
            sb.append(this.mObbState.token != null ? this.mObbState.token.toString() : "NULL");
            sb.append(",binder=");
            sb.append(this.mObbState.token != null ? this.mObbState.getBinder().toString() : "null");
            sb.append('}');
            return sb.toString();
        }
    }

    abstract class ObbAction {
        private static final int MAX_RETRIES = 3;
        private int mRetries;
        ObbState mObbState;

        ObbAction(ObbState obbState) {
            this.mObbState = obbState;
        }

        public void execute(ObbActionHandler handler) {
            try {
                ++this.mRetries;
                if (this.mRetries > 3) {
                    Slog.w((String)MountService.TAG, (String)"Failed to invoke remote methods on default container service. Giving up");
                    MountService.this.mObbActionHandler.sendEmptyMessage(3);
                    this.handleError();
                    return;
                }
                this.handleExecute();
                MountService.this.mObbActionHandler.sendEmptyMessage(3);
            }
            catch (RemoteException e) {
                MountService.this.mObbActionHandler.sendEmptyMessage(4);
            }
            catch (Exception e) {
                this.handleError();
                MountService.this.mObbActionHandler.sendEmptyMessage(3);
            }
        }

        abstract void handleExecute() throws RemoteException, IOException;

        abstract void handleError();

        protected ObbInfo getObbInfo() throws IOException {
            ObbInfo obbInfo;
            try {
                obbInfo = MountService.this.mContainerService.getObbInfo(this.mObbState.filename);
            }
            catch (RemoteException e) {
                Slog.d((String)MountService.TAG, (String)("Couldn't call DefaultContainerService to fetch OBB info for " + this.mObbState.filename));
                obbInfo = null;
            }
            if (obbInfo == null) {
                throw new IOException("Couldn't read OBB file: " + this.mObbState.filename);
            }
            return obbInfo;
        }

        protected void sendNewStatusOrIgnore(int status) {
            if (this.mObbState == null || this.mObbState.token == null) {
                return;
            }
            try {
                this.mObbState.token.onObbResult(this.mObbState.filename, this.mObbState.nonce, status);
            }
            catch (RemoteException e) {
                Slog.w((String)MountService.TAG, (String)"MountServiceListener went away while calling onObbStateChanged");
            }
        }
    }

    private class ObbActionHandler
    extends Handler {
        private boolean mBound;
        private final List<ObbAction> mActions;

        ObbActionHandler(Looper l) {
            super(l);
            this.mBound = false;
            this.mActions = new LinkedList<ObbAction>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ObbAction action = (ObbAction)msg.obj;
                    if (!this.mBound && !this.connectToService()) {
                        Slog.e((String)MountService.TAG, (String)"Failed to bind to media container service");
                        action.handleError();
                        return;
                    }
                    this.mActions.add(action);
                    break;
                }
                case 2: {
                    if (msg.obj != null) {
                        MountService.this.mContainerService = (IMediaContainerService)msg.obj;
                    }
                    if (MountService.this.mContainerService == null) {
                        Slog.e((String)MountService.TAG, (String)"Cannot bind to media container service");
                        for (ObbAction action : this.mActions) {
                            action.handleError();
                        }
                        this.mActions.clear();
                        break;
                    }
                    if (this.mActions.size() > 0) {
                        ObbAction action = this.mActions.get(0);
                        if (action == null) break;
                        action.execute(this);
                        break;
                    }
                    Slog.w((String)MountService.TAG, (String)"Empty queue");
                    break;
                }
                case 4: {
                    if (this.mActions.size() <= 0) break;
                    if (this.mBound) {
                        this.disconnectService();
                    }
                    if (this.connectToService()) break;
                    Slog.e((String)MountService.TAG, (String)"Failed to bind to media container service");
                    for (ObbAction action : this.mActions) {
                        action.handleError();
                    }
                    this.mActions.clear();
                    break;
                }
                case 3: {
                    if (this.mActions.size() > 0) {
                        this.mActions.remove(0);
                    }
                    if (this.mActions.size() == 0) {
                        if (!this.mBound) break;
                        this.disconnectService();
                        break;
                    }
                    MountService.this.mObbActionHandler.sendEmptyMessage(2);
                    break;
                }
                case 5: {
                    String path = (String)msg.obj;
                    Map map = MountService.this.mObbMounts;
                    synchronized (map) {
                        LinkedList obbStatesToRemove = new LinkedList();
                        for (Map.Entry obbEntry : MountService.this.mObbPathToStateMap.entrySet()) {
                            if (!((String)obbEntry.getKey()).startsWith(path)) continue;
                            obbStatesToRemove.add(obbEntry.getValue());
                        }
                        for (ObbState obbState : obbStatesToRemove) {
                            MountService.this.removeObbStateLocked(obbState);
                            try {
                                obbState.token.onObbResult(obbState.filename, obbState.nonce, 2);
                            }
                            catch (RemoteException e) {
                                Slog.i((String)MountService.TAG, (String)("Couldn't send unmount notification for  OBB: " + obbState.filename));
                            }
                        }
                        break;
                    }
                }
            }
        }

        private boolean connectToService() {
            Intent service = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
            if (MountService.this.mContext.bindService(service, (ServiceConnection)MountService.this.mDefContainerConn, 1)) {
                this.mBound = true;
                return true;
            }
            return false;
        }

        private void disconnectService() {
            MountService.this.mContainerService = null;
            this.mBound = false;
            MountService.this.mContext.unbindService((ServiceConnection)MountService.this.mDefContainerConn);
        }
    }

    private final class MountServiceBinderListener
    implements IBinder.DeathRecipient {
        final IMountServiceListener mListener;

        MountServiceBinderListener(IMountServiceListener listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            ArrayList arrayList = MountService.this.mListeners;
            synchronized (arrayList) {
                MountService.this.mListeners.remove(this);
                this.mListener.asBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
            }
        }
    }

    class MountServiceHandler
    extends Handler {
        ArrayList<UnmountCallBack> mForceUnmounts;
        boolean mUpdatingStatus;

        MountServiceHandler(Looper l) {
            super(l);
            this.mForceUnmounts = new ArrayList();
            this.mUpdatingStatus = false;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    UnmountCallBack ucb = (UnmountCallBack)msg.obj;
                    this.mForceUnmounts.add(ucb);
                    if (this.mUpdatingStatus) break;
                    this.mUpdatingStatus = true;
                    MountService.this.mPms.updateExternalMediaStatus(false, true);
                    break;
                }
                case 2: {
                    int i;
                    this.mUpdatingStatus = false;
                    int size = this.mForceUnmounts.size();
                    int[] sizeArr = new int[size];
                    int sizeArrN = 0;
                    ActivityManagerService ams = (ActivityManagerService)ServiceManager.getService((String)"activity");
                    for (i = 0; i < size; ++i) {
                        UnmountCallBack ucb = this.mForceUnmounts.get(i);
                        String path = ucb.path;
                        boolean done = false;
                        if (!ucb.force) {
                            done = true;
                        } else {
                            int[] pids = MountService.this.getStorageUsers(path);
                            if (pids == null || pids.length == 0) {
                                done = true;
                            } else {
                                ams.killPids(pids, "unmount media", true);
                                pids = MountService.this.getStorageUsers(path);
                                if (pids == null || pids.length == 0) {
                                    done = true;
                                }
                            }
                        }
                        if (!done && ucb.retries < 4) {
                            Slog.i((String)MountService.TAG, (String)"Retrying to kill storage users again");
                            MountService.this.mHandler.sendMessageDelayed(MountService.this.mHandler.obtainMessage(2, (Object)ucb.retries++), 30L);
                            continue;
                        }
                        if (ucb.retries >= 4) {
                            Slog.i((String)MountService.TAG, (String)"Failed to unmount media inspite of 4 retries. Forcibly killing processes now");
                        }
                        sizeArr[sizeArrN++] = i;
                        MountService.this.mHandler.sendMessage(MountService.this.mHandler.obtainMessage(3, (Object)ucb));
                    }
                    for (i = sizeArrN - 1; i >= 0; --i) {
                        this.mForceUnmounts.remove(sizeArr[i]);
                    }
                    break;
                }
                case 3: {
                    UnmountCallBack ucb = (UnmountCallBack)msg.obj;
                    ucb.handleFinished();
                    break;
                }
            }
        }
    }

    class ShutdownCallBack
    extends UnmountCallBack {
        IMountShutdownObserver observer;

        ShutdownCallBack(String path, IMountShutdownObserver observer) {
            super(path, true, false);
            this.observer = observer;
        }

        void handleFinished() {
            int ret = MountService.this.doUnmountVolume(this.path, true, this.removeEncryption);
            if (this.observer != null) {
                try {
                    this.observer.onShutDownComplete(ret);
                }
                catch (RemoteException e) {
                    Slog.w((String)MountService.TAG, (String)"RemoteException when shutting down");
                }
            }
        }
    }

    class UmsEnableCallBack
    extends UnmountCallBack {
        final String method;

        UmsEnableCallBack(String path, String method, boolean force) {
            super(path, force, false);
            this.method = method;
        }

        void handleFinished() {
            super.handleFinished();
            MountService.this.doShareUnshareVolume(this.path, this.method, true);
        }
    }

    class UnmountCallBack {
        final String path;
        final boolean force;
        final boolean removeEncryption;
        int retries = 0;

        UnmountCallBack(String path, boolean force, boolean removeEncryption) {
            this.path = path;
            this.force = force;
            this.removeEncryption = removeEncryption;
        }

        void handleFinished() {
            MountService.this.doUnmountVolume(this.path, true, this.removeEncryption);
        }
    }

    class DefaultContainerConnection
    implements ServiceConnection {
        DefaultContainerConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            IMediaContainerService imcs = IMediaContainerService.Stub.asInterface((IBinder)service);
            MountService.this.mObbActionHandler.sendMessage(MountService.this.mObbActionHandler.obtainMessage(2, imcs));
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }

    class ObbState
    implements IBinder.DeathRecipient {
        String filename;
        public final int callerUid;
        final IObbActionListener token;
        final int nonce;

        public ObbState(String filename, int callerUid, IObbActionListener token, int nonce) throws RemoteException {
            this.filename = filename;
            this.callerUid = callerUid;
            this.token = token;
            this.nonce = nonce;
        }

        public IBinder getBinder() {
            return this.token.asBinder();
        }

        public void binderDied() {
            UnmountObbAction action = new UnmountObbAction(this, true);
            MountService.this.mObbActionHandler.sendMessage(MountService.this.mObbActionHandler.obtainMessage(1, action));
        }

        public void link() throws RemoteException {
            this.getBinder().linkToDeath((IBinder.DeathRecipient)this, 0);
        }

        public void unlink() {
            this.getBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ObbState{");
            sb.append("filename=");
            sb.append(this.filename);
            sb.append(",token=");
            sb.append(this.token.toString());
            sb.append(",callerUid=");
            sb.append(this.callerUid);
            sb.append('}');
            return sb.toString();
        }
    }

    class VoldResponseCode {
        public static final int VolumeListResult = 110;
        public static final int AsecListResult = 111;
        public static final int StorageUsersListResult = 112;
        public static final int ShareStatusResult = 210;
        public static final int AsecPathResult = 211;
        public static final int ShareEnabledResult = 212;
        public static final int OpFailedNoMedia = 401;
        public static final int OpFailedMediaBlank = 402;
        public static final int OpFailedMediaCorrupt = 403;
        public static final int OpFailedVolNotMounted = 404;
        public static final int OpFailedStorageBusy = 405;
        public static final int OpFailedStorageNotFound = 406;
        public static final int VolumeStateChange = 605;
        public static final int VolumeDiskInserted = 630;
        public static final int VolumeDiskRemoved = 631;
        public static final int VolumeBadRemoval = 632;

        VoldResponseCode() {
        }
    }

    class VolumeState {
        public static final int Init = -1;
        public static final int NoMedia = 0;
        public static final int Idle = 1;
        public static final int Pending = 2;
        public static final int Checking = 3;
        public static final int Mounted = 4;
        public static final int Unmounting = 5;
        public static final int Formatting = 6;
        public static final int Shared = 7;
        public static final int SharedMnt = 8;

        VolumeState() {
        }
    }
}

