/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.util.Slog;
import com.android.server.INativeDaemonConnectorCallbacks;
import com.android.server.NativeDaemonConnectorException;
import com.android.server.Watchdog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeDaemonConnector
implements Runnable,
Handler.Callback,
Watchdog.Monitor {
    private static final boolean LOCAL_LOGD = false;
    private BlockingQueue<String> mResponseQueue;
    private OutputStream mOutputStream;
    private String TAG = "NativeDaemonConnector";
    private String mSocket;
    private INativeDaemonConnectorCallbacks mCallbacks;
    private Handler mCallbackHandler;
    private Object mDaemonLock = new Object();
    private final int BUFFER_SIZE = 4096;

    NativeDaemonConnector(INativeDaemonConnectorCallbacks callbacks, String socket, int responseQueueSize, String logTag) {
        this.mCallbacks = callbacks;
        if (logTag != null) {
            this.TAG = logTag;
        }
        this.mSocket = socket;
        this.mResponseQueue = new LinkedBlockingQueue<String>(responseQueueSize);
    }

    @Override
    public void run() {
        HandlerThread thread = new HandlerThread(this.TAG + ".CallbackHandler");
        thread.start();
        this.mCallbackHandler = new Handler(thread.getLooper(), (Handler.Callback)this);
        while (true) {
            try {
                while (true) {
                    this.listenToSocket();
                }
            }
            catch (Exception e) {
                Slog.e((String)this.TAG, (String)"Error in NativeDaemonConnector", (Throwable)e);
                SystemClock.sleep((long)5000L);
                continue;
            }
            break;
        }
    }

    public boolean handleMessage(Message msg) {
        String event = (String)msg.obj;
        try {
            if (!this.mCallbacks.onEvent(msg.what, event, event.split(" "))) {
                Slog.w((String)this.TAG, (String)String.format("Unhandled event '%s'", event));
            }
        }
        catch (Exception e) {
            Slog.e((String)this.TAG, (String)String.format("Error handling '%s'", event), (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void listenToSocket() throws IOException {
        block30: {
            int count;
            LocalSocket socket = null;
            socket = new LocalSocket();
            LocalSocketAddress address = new LocalSocketAddress(this.mSocket, LocalSocketAddress.Namespace.RESERVED);
            socket.connect(address);
            InputStream inputStream = socket.getInputStream();
            this.mOutputStream = socket.getOutputStream();
            this.mCallbacks.onDaemonConnected();
            byte[] buffer = new byte[4096];
            int start = 0;
            while ((count = inputStream.read(buffer, start, 4096 - start)) >= 0) {
                count += start;
                start = 0;
                for (int i = 0; i < count; ++i) {
                    if (buffer[i] != 0) continue;
                    String event = new String(buffer, start, i - start);
                    String[] tokens = event.split(" ", 2);
                    try {
                        int code = Integer.parseInt(tokens[0]);
                        if (code >= 600) {
                            this.mCallbackHandler.sendMessage(this.mCallbackHandler.obtainMessage(code, (Object)event));
                        } else {
                            try {
                                this.mResponseQueue.put(event);
                            }
                            catch (InterruptedException ex) {
                                Slog.e((String)this.TAG, (String)"Failed to put response onto queue", (Throwable)ex);
                            }
                        }
                    }
                    catch (NumberFormatException nfe) {
                        Slog.w((String)this.TAG, (String)String.format("Bad msg (%s)", event));
                    }
                    start = i + 1;
                }
                if (start != count) {
                    int remaining = 4096 - start;
                    System.arraycopy(buffer, start, buffer, 0, remaining);
                    start = remaining;
                    continue;
                }
                start = 0;
            }
            Object var13_14 = null;
            Object object = this.mDaemonLock;
            synchronized (object) {
                if (this.mOutputStream != null) {
                    try {
                        this.mOutputStream.close();
                    }
                    catch (IOException e) {
                        Slog.w((String)this.TAG, (String)"Failed closing output stream", (Throwable)e);
                    }
                    this.mOutputStream = null;
                }
            }
            try {
                if (socket != null) {
                    socket.close();
                }
                break block30;
            }
            catch (IOException ex) {
                Slog.w((String)this.TAG, (String)"Failed closing socket", (Throwable)ex);
            }
            break block30;
            {
                catch (IOException ex) {
                    Slog.e((String)this.TAG, (String)"Communications error", (Throwable)ex);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                Object object2 = this.mDaemonLock;
                synchronized (object2) {
                    if (this.mOutputStream != null) {
                        try {
                            this.mOutputStream.close();
                        }
                        catch (IOException e) {
                            Slog.w((String)this.TAG, (String)"Failed closing output stream", (Throwable)e);
                        }
                        this.mOutputStream = null;
                    }
                }
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException ex) {
                    Slog.w((String)this.TAG, (String)"Failed closing socket", (Throwable)ex);
                }
                throw throwable;
            }
        }
    }

    private void sendCommandLocked(String command) throws NativeDaemonConnectorException {
        this.sendCommandLocked(command, null);
    }

    private void sendCommandLocked(String command, String argument) throws NativeDaemonConnectorException {
        if (command != null && command.indexOf(0) >= 0) {
            throw new IllegalArgumentException("unexpected command: " + command);
        }
        if (argument != null && argument.indexOf(0) >= 0) {
            throw new IllegalArgumentException("unexpected argument: " + argument);
        }
        if (this.mOutputStream == null) {
            Slog.e((String)this.TAG, (String)"No connection to daemon", (Throwable)new IllegalStateException());
            throw new NativeDaemonConnectorException("No output stream!");
        }
        StringBuilder builder = new StringBuilder(command);
        if (argument != null) {
            builder.append(argument);
        }
        builder.append('\u0000');
        try {
            this.mOutputStream.write(builder.toString().getBytes());
        }
        catch (IOException ex) {
            Slog.e((String)this.TAG, (String)"IOException in sendCommand", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> doCommand(String cmd) throws NativeDaemonConnectorException {
        Object object = this.mDaemonLock;
        synchronized (object) {
            return this.doCommandLocked(cmd);
        }
    }

    private ArrayList<String> doCommandLocked(String cmd) throws NativeDaemonConnectorException {
        this.mResponseQueue.clear();
        this.sendCommandLocked(cmd);
        ArrayList<String> response = new ArrayList<String>();
        boolean complete = false;
        int code = -1;
        while (!complete) {
            try {
                String line = this.mResponseQueue.take();
                String[] tokens = line.split(" ");
                try {
                    code = Integer.parseInt(tokens[0]);
                }
                catch (NumberFormatException nfe) {
                    throw new NativeDaemonConnectorException(String.format("Invalid response from daemon (%s)", line));
                }
                if (code >= 200 && code < 600) {
                    complete = true;
                }
                response.add(line);
            }
            catch (InterruptedException ex) {
                Slog.e((String)this.TAG, (String)"Failed to process response", (Throwable)ex);
            }
        }
        if (code >= 400 && code <= 599) {
            throw new NativeDaemonConnectorException(code, cmd, response.get(response.size() - 1).substring(4));
        }
        return response;
    }

    public String[] doListCommand(String cmd, int expectedResponseCode) throws NativeDaemonConnectorException {
        ArrayList<String> rsp = this.doCommand(cmd);
        String[] rdata = new String[rsp.size() - 1];
        int idx = 0;
        for (int i = 0; i < rsp.size(); ++i) {
            String line = rsp.get(i);
            try {
                String[] tok = line.split(" ");
                int code = Integer.parseInt(tok[0]);
                if (code != expectedResponseCode) {
                    if (code == 200) {
                        int last = rsp.size() - 1;
                        if (i != last) {
                            Slog.w((String)this.TAG, (String)String.format("Recv'd %d lines after end of list {%s}", last - i, cmd));
                            for (int j = i; j <= last; ++j) {
                                Slog.w((String)this.TAG, (String)String.format("ExtraData <%s>", rsp.get(i)));
                            }
                        }
                        return rdata;
                    }
                    throw new NativeDaemonConnectorException(String.format("Expected list response %d, but got %d", expectedResponseCode, code));
                }
                rdata[idx++] = line.substring(tok[0].length() + 1);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new NativeDaemonConnectorException(String.format("Error reading code '%s'", line));
            }
        }
        throw new NativeDaemonConnectorException("Got an empty response");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mDaemonLock;
        synchronized (object) {
        }
    }

    class ResponseCode {
        public static final int ActionInitiated = 100;
        public static final int CommandOkay = 200;
        public static final int OperationFailed = 400;
        public static final int CommandSyntaxError = 500;
        public static final int CommandParameterError = 501;
        public static final int UnsolicitedInformational = 600;
        public static final int FailedRangeStart = 400;
        public static final int FailedRangeEnd = 599;

        ResponseCode() {
        }
    }
}

