/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ContentResolver;
import android.content.Context;
import android.net.INetworkManagementEventObserver;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.NetworkStats;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.wifi.WifiConfiguration;
import android.os.Binder;
import android.os.INetworkManagementService;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Log;
import android.util.Slog;
import android.util.SparseBooleanArray;
import com.android.internal.net.NetworkStatsFactory;
import com.android.server.INativeDaemonConnectorCallbacks;
import com.android.server.NativeDaemonConnector;
import com.android.server.NativeDaemonConnectorException;
import com.android.server.Watchdog;
import com.google.android.collect.Sets;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkManagementService
extends INetworkManagementService.Stub
implements Watchdog.Monitor {
    private static final String TAG = "NetworkManagementService";
    private static final boolean DBG = false;
    private static final String NETD_TAG = "NetdConnector";
    private static final int ADD = 1;
    private static final int REMOVE = 2;
    private static final String DEFAULT = "default";
    private static final String SECONDARY = "secondary";
    public static final String LIMIT_GLOBAL_ALERT = "globalAlert";
    private Context mContext;
    private NativeDaemonConnector mConnector;
    private Thread mThread;
    private final CountDownLatch mConnectedSignal = new CountDownLatch(1);
    private ArrayList<INetworkManagementEventObserver> mObservers;
    private final NetworkStatsFactory mStatsFactory = new NetworkStatsFactory();
    private Object mQuotaLock = new Object();
    private HashSet<String> mActiveQuotaIfaces = Sets.newHashSet();
    private HashSet<String> mActiveAlertIfaces = Sets.newHashSet();
    private SparseBooleanArray mUidRejectOnQuota = new SparseBooleanArray();
    private volatile boolean mBandwidthControlEnabled;

    private NetworkManagementService(Context context) {
        this.mContext = context;
        this.mObservers = new ArrayList();
        if ("simulator".equals(SystemProperties.get((String)"ro.product.device"))) {
            return;
        }
        this.mConnector = new NativeDaemonConnector(new NetdCallbackReceiver(), "netd", 10, NETD_TAG);
        this.mThread = new Thread((Runnable)this.mConnector, NETD_TAG);
        Watchdog.getInstance().addMonitor(this);
    }

    public static NetworkManagementService create(Context context) throws InterruptedException {
        NetworkManagementService service = new NetworkManagementService(context);
        service.mThread.start();
        service.mConnectedSignal.await();
        return service;
    }

    public void systemReady() {
        boolean shouldEnable;
        boolean hasKernelSupport = new File("/proc/net/xt_qtaguid/ctrl").exists();
        boolean bl = shouldEnable = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"netstats_enabled", (int)1) != 0;
        if (hasKernelSupport && shouldEnable) {
            Slog.d((String)TAG, (String)"enabling bandwidth control");
            try {
                this.mConnector.doCommand("bandwidth enable");
                this.mBandwidthControlEnabled = true;
            }
            catch (NativeDaemonConnectorException e) {
                Log.wtf((String)TAG, (String)"problem enabling bandwidth controls", (Throwable)e);
            }
        } else {
            Slog.d((String)TAG, (String)"not enabling bandwidth control");
        }
        SystemProperties.set((String)"net.qtaguid_enabled", (String)(this.mBandwidthControlEnabled ? "1" : "0"));
    }

    public void registerObserver(INetworkManagementEventObserver obs) {
        Slog.d((String)TAG, (String)"Registering observer");
        this.mObservers.add(obs);
    }

    public void unregisterObserver(INetworkManagementEventObserver obs) {
        Slog.d((String)TAG, (String)"Unregistering observer");
        this.mObservers.remove(this.mObservers.indexOf(obs));
    }

    private void notifyInterfaceStatusChanged(String iface, boolean up) {
        for (INetworkManagementEventObserver obs : this.mObservers) {
            try {
                obs.interfaceStatusChanged(iface, up);
            }
            catch (Exception ex) {
                Slog.w((String)TAG, (String)"Observer notifier failed", (Throwable)ex);
            }
        }
    }

    private void notifyInterfaceLinkStateChanged(String iface, boolean up) {
        for (INetworkManagementEventObserver obs : this.mObservers) {
            try {
                obs.interfaceLinkStateChanged(iface, up);
            }
            catch (Exception ex) {
                Slog.w((String)TAG, (String)"Observer notifier failed", (Throwable)ex);
            }
        }
    }

    private void notifyInterfaceAdded(String iface) {
        for (INetworkManagementEventObserver obs : this.mObservers) {
            try {
                obs.interfaceAdded(iface);
            }
            catch (Exception ex) {
                Slog.w((String)TAG, (String)"Observer notifier failed", (Throwable)ex);
            }
        }
    }

    private void notifyInterfaceRemoved(String iface) {
        this.mActiveAlertIfaces.remove(iface);
        this.mActiveQuotaIfaces.remove(iface);
        for (INetworkManagementEventObserver obs : this.mObservers) {
            try {
                obs.interfaceRemoved(iface);
            }
            catch (Exception ex) {
                Slog.w((String)TAG, (String)"Observer notifier failed", (Throwable)ex);
            }
        }
    }

    private void notifyLimitReached(String limitName, String iface) {
        for (INetworkManagementEventObserver obs : this.mObservers) {
            try {
                obs.limitReached(limitName, iface);
            }
            catch (Exception ex) {
                Slog.w((String)TAG, (String)"Observer notifier failed", (Throwable)ex);
            }
        }
    }

    protected void onDaemonConnected() {
        this.mConnectedSignal.countDown();
    }

    public String[] listInterfaces() throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        try {
            return this.mConnector.doListCommand("interface list", 110);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Cannot communicate with native daemon to list interfaces");
        }
    }

    public InterfaceConfiguration getInterfaceConfig(String iface) throws IllegalStateException {
        InterfaceConfiguration cfg;
        String rsp;
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        try {
            rsp = this.mConnector.doCommand("interface getcfg " + iface).get(0);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Cannot communicate with native daemon to get interface config");
        }
        Slog.d((String)TAG, (String)String.format("rsp <%s>", rsp));
        StringTokenizer st = new StringTokenizer(rsp);
        try {
            try {
                int code = Integer.parseInt(st.nextToken(" "));
                if (code != 213) {
                    throw new IllegalStateException(String.format("Expected code %d, but got %d", 213, code));
                }
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException(String.format("Invalid response from daemon (%s)", rsp));
            }
            cfg = new InterfaceConfiguration();
            cfg.hwAddr = st.nextToken(" ");
            InetAddress addr = null;
            int prefixLength = 0;
            try {
                addr = NetworkUtils.numericToInetAddress((String)st.nextToken(" "));
            }
            catch (IllegalArgumentException iae) {
                Slog.e((String)TAG, (String)"Failed to parse ipaddr", (Throwable)iae);
            }
            try {
                prefixLength = Integer.parseInt(st.nextToken(" "));
            }
            catch (NumberFormatException nfe) {
                Slog.e((String)TAG, (String)"Failed to parse prefixLength", (Throwable)nfe);
            }
            cfg.addr = new LinkAddress(addr, prefixLength);
            cfg.interfaceFlags = st.nextToken("]").trim() + "]";
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalStateException(String.format("Invalid response from daemon (%s)", rsp));
        }
        Slog.d((String)TAG, (String)String.format("flags <%s>", cfg.interfaceFlags));
        return cfg;
    }

    public void setInterfaceConfig(String iface, InterfaceConfiguration cfg) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        LinkAddress linkAddr = cfg.addr;
        if (linkAddr == null || linkAddr.getAddress() == null) {
            throw new IllegalStateException("Null LinkAddress given");
        }
        String cmd = String.format("interface setcfg %s %s %d %s", iface, linkAddr.getAddress().getHostAddress(), linkAddr.getNetworkPrefixLength(), cfg.interfaceFlags);
        try {
            this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate with native daemon to interface setcfg - " + e);
        }
    }

    public void setInterfaceDown(String iface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            InterfaceConfiguration ifcg = this.getInterfaceConfig(iface);
            ifcg.interfaceFlags = ifcg.interfaceFlags.replace("up", "down");
            this.setInterfaceConfig(iface, ifcg);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate with native daemon for interface down - " + e);
        }
    }

    public void setInterfaceUp(String iface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            InterfaceConfiguration ifcg = this.getInterfaceConfig(iface);
            ifcg.interfaceFlags = ifcg.interfaceFlags.replace("down", "up");
            this.setInterfaceConfig(iface, ifcg);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate with native daemon for interface up - " + e);
        }
    }

    public void setInterfaceIpv6PrivacyExtensions(String iface, boolean enable) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        String cmd = String.format("interface ipv6privacyextensions %s %s", iface, enable ? "enable" : "disable");
        try {
            this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate with native daemon to set ipv6privacyextensions - " + e);
        }
    }

    public void clearInterfaceAddresses(String iface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        String cmd = String.format("interface clearaddrs %s", iface);
        try {
            this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate with native daemon to interface clearallips - " + e);
        }
    }

    public void enableIpv6(String iface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            this.mConnector.doCommand(String.format("interface ipv6 %s enable", iface));
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate to native daemon for enabling ipv6");
        }
    }

    public void disableIpv6(String iface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            this.mConnector.doCommand(String.format("interface ipv6 %s disable", iface));
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate to native daemon for disabling ipv6");
        }
    }

    public void addRoute(String interfaceName, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        this.modifyRoute(interfaceName, 1, route, DEFAULT);
    }

    public void removeRoute(String interfaceName, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        this.modifyRoute(interfaceName, 2, route, DEFAULT);
    }

    public void addSecondaryRoute(String interfaceName, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        this.modifyRoute(interfaceName, 1, route, SECONDARY);
    }

    public void removeSecondaryRoute(String interfaceName, RouteInfo route) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        this.modifyRoute(interfaceName, 2, route, SECONDARY);
    }

    private void modifyRoute(String interfaceName, int action, RouteInfo route, String type) {
        StringBuilder cmd;
        switch (action) {
            case 1: {
                cmd = new StringBuilder("interface route add " + interfaceName + " " + type);
                break;
            }
            case 2: {
                cmd = new StringBuilder("interface route remove " + interfaceName + " " + type);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown action type " + action);
            }
        }
        LinkAddress la = route.getDestination();
        cmd.append(' ');
        cmd.append(la.getAddress().getHostAddress());
        cmd.append(' ');
        cmd.append(la.getNetworkPrefixLength());
        cmd.append(' ');
        if (route.getGateway() == null) {
            if (la.getAddress() instanceof Inet4Address) {
                cmd.append("0.0.0.0");
            } else {
                cmd.append("::0");
            }
        } else {
            cmd.append(route.getGateway().getHostAddress());
        }
        try {
            ArrayList<String> rsp = this.mConnector.doCommand(cmd.toString());
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate with native dameon to add routes - " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<String> readRouteList(String filename) {
        String s;
        FileInputStream fstream = null;
        ArrayList<String> list = new ArrayList<String>();
        fstream = new FileInputStream(filename);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((s = br.readLine()) != null && s.length() != 0) {
            list.add(s);
        }
        Object var8_8 = null;
        if (fstream == null) return list;
        try {
            fstream.close();
            return list;
        }
        catch (IOException ex2) {}
        return list;
        {
            catch (IOException ex) {
                Object var8_9 = null;
                if (fstream == null) return list;
                try {
                    fstream.close();
                    return list;
                }
                catch (IOException ex2) {}
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (fstream == null) throw throwable;
            try {
                fstream.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public RouteInfo[] getRoutes(String interfaceName) {
        InetAddress destAddr;
        String dest;
        String iface;
        String[] fields;
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>();
        for (String s : this.readRouteList("/proc/net/route")) {
            fields = s.split("\t");
            if (fields.length <= 7 || !interfaceName.equals(iface = fields[0])) continue;
            dest = fields[1];
            String gate = fields[2];
            String flags = fields[3];
            String mask = fields[7];
            try {
                destAddr = NetworkUtils.intToInetAddress((int)((int)Long.parseLong(dest, 16)));
                int prefixLength = NetworkUtils.netmaskIntToPrefixLength((int)((int)Long.parseLong(mask, 16)));
                LinkAddress linkAddress = new LinkAddress(destAddr, prefixLength);
                InetAddress gatewayAddr = NetworkUtils.intToInetAddress((int)((int)Long.parseLong(gate, 16)));
                RouteInfo route = new RouteInfo(linkAddress, gatewayAddr);
                routes.add(route);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error parsing route " + s + " : " + e));
            }
        }
        for (String s : this.readRouteList("/proc/net/ipv6_route")) {
            fields = s.split("\\s+");
            if (fields.length <= 9 || !interfaceName.equals(iface = fields[9].trim())) continue;
            dest = fields[0];
            String prefix = fields[1];
            String gate = fields[4];
            try {
                int prefixLength = Integer.parseInt(prefix, 16);
                destAddr = NetworkUtils.hexToInet6Address((String)dest);
                LinkAddress linkAddress = new LinkAddress(destAddr, prefixLength);
                InetAddress gateAddr = NetworkUtils.hexToInet6Address((String)gate);
                RouteInfo route = new RouteInfo(linkAddress, gateAddr);
                routes.add(route);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error parsing route " + s + " : " + e));
            }
        }
        return routes.toArray(new RouteInfo[0]);
    }

    public void shutdown() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.SHUTDOWN") != 0) {
            throw new SecurityException("Requires SHUTDOWN permission");
        }
        Slog.d((String)TAG, (String)"Shutting down");
    }

    public boolean getIpForwardingEnabled() throws IllegalStateException {
        ArrayList<String> rsp;
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        try {
            rsp = this.mConnector.doCommand("ipfwd status");
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate with native daemon to ipfwd status");
        }
        Iterator<String> i$ = rsp.iterator();
        if (i$.hasNext()) {
            String line = i$.next();
            String[] tok = line.split(" ");
            if (tok.length < 3) {
                Slog.e((String)TAG, (String)("Malformed response from native daemon: " + line));
                return false;
            }
            int code = Integer.parseInt(tok[0]);
            if (code == 211) {
                return "enabled".equals(tok[2]);
            }
            throw new IllegalStateException(String.format("Unexpected response code %d", code));
        }
        throw new IllegalStateException("Got an empty response");
    }

    public void setIpForwardingEnabled(boolean enable) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        this.mConnector.doCommand(String.format("ipfwd %sable", enable ? "en" : "dis"));
    }

    public void startTethering(String[] dhcpRange) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        String cmd = "tether start";
        for (String d : dhcpRange) {
            cmd = cmd + " " + d;
        }
        try {
            this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate to native daemon");
        }
    }

    public void stopTethering() throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            this.mConnector.doCommand("tether stop");
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate to native daemon to stop tether");
        }
    }

    public boolean isTetheringStarted() throws IllegalStateException {
        ArrayList<String> rsp;
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        try {
            rsp = this.mConnector.doCommand("tether status");
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate to native daemon to get tether status");
        }
        Iterator<String> i$ = rsp.iterator();
        if (i$.hasNext()) {
            String line = i$.next();
            String[] tok = line.split(" ");
            if (tok.length < 3) {
                throw new IllegalStateException("Malformed response for tether status: " + line);
            }
            int code = Integer.parseInt(tok[0]);
            if (code == 210) {
                return "started".equals(tok[2]);
            }
            throw new IllegalStateException(String.format("Unexpected response code %d", code));
        }
        throw new IllegalStateException("Got an empty response");
    }

    public void tetherInterface(String iface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            this.mConnector.doCommand("tether interface add " + iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate to native daemon for adding tether interface");
        }
    }

    public void untetherInterface(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            this.mConnector.doCommand("tether interface remove " + iface);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate to native daemon for removing tether interface");
        }
    }

    public String[] listTetheredInterfaces() throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        try {
            return this.mConnector.doListCommand("tether interface list", 111);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate to native daemon for listing tether interfaces");
        }
    }

    public void setDnsForwarders(String[] dns) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            String cmd = "tether dns set";
            for (String s : dns) {
                cmd = cmd + " " + NetworkUtils.numericToInetAddress((String)s).getHostAddress();
            }
            try {
                this.mConnector.doCommand(cmd);
            }
            catch (NativeDaemonConnectorException e) {
                throw new IllegalStateException("Unable to communicate to native daemon for setting tether dns");
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error resolving dns name", e);
        }
    }

    public String[] getDnsForwarders() throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        try {
            return this.mConnector.doListCommand("tether dns list", 112);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate to native daemon for listing tether dns");
        }
    }

    private void modifyNat(String cmd, String internalInterface, String externalInterface) throws SocketException {
        cmd = String.format("nat %s %s %s", cmd, internalInterface, externalInterface);
        NetworkInterface internalNetworkInterface = NetworkInterface.getByName(internalInterface);
        if (internalNetworkInterface == null) {
            cmd = cmd + " 0";
        } else {
            List<InterfaceAddress> interfaceAddresses = internalNetworkInterface.getInterfaceAddresses();
            cmd = cmd + " " + interfaceAddresses.size();
            for (InterfaceAddress ia : interfaceAddresses) {
                InetAddress addr = NetworkUtils.getNetworkPart((InetAddress)ia.getAddress(), (int)ia.getNetworkPrefixLength());
                cmd = cmd + " " + addr.getHostAddress() + "/" + ia.getNetworkPrefixLength();
            }
        }
        this.mConnector.doCommand(cmd);
    }

    public void enableNat(String internalInterface, String externalInterface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            this.modifyNat("enable", internalInterface, externalInterface);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("enableNat got Exception " + e.toString()));
            throw new IllegalStateException("Unable to communicate to native daemon for enabling NAT interface");
        }
    }

    public void disableNat(String internalInterface, String externalInterface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            this.modifyNat("disable", internalInterface, externalInterface);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("disableNat got Exception " + e.toString()));
            throw new IllegalStateException("Unable to communicate to native daemon for disabling NAT interface");
        }
    }

    public String[] listTtys() throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        try {
            return this.mConnector.doListCommand("list_ttys", 113);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Unable to communicate to native daemon for listing TTYs");
        }
    }

    public void attachPppd(String tty, String localAddr, String remoteAddr, String dns1Addr, String dns2Addr) throws IllegalStateException {
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
            this.mConnector.doCommand(String.format("pppd attach %s %s %s %s %s", tty, NetworkUtils.numericToInetAddress((String)localAddr).getHostAddress(), NetworkUtils.numericToInetAddress((String)remoteAddr).getHostAddress(), NetworkUtils.numericToInetAddress((String)dns1Addr).getHostAddress(), NetworkUtils.numericToInetAddress((String)dns2Addr).getHostAddress()));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error resolving addr", e);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating to native daemon to attach pppd", e);
        }
    }

    public void detachPppd(String tty) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            this.mConnector.doCommand(String.format("pppd detach %s", tty));
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating to native daemon to detach pppd", e);
        }
    }

    public void startAccessPoint(WifiConfiguration wifiConfig, String wlanIface, String softapIface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIFI_STATE", TAG);
        try {
            this.wifiFirmwareReload(wlanIface, "AP");
            this.mConnector.doCommand(String.format("softap start " + wlanIface, new Object[0]));
            if (wifiConfig == null) {
                this.mConnector.doCommand(String.format("softap set " + wlanIface + " " + softapIface, new Object[0]));
            } else {
                String str = String.format("softap set " + wlanIface + " " + softapIface + " %s %s %s", this.convertQuotedString(wifiConfig.SSID), this.getSecurityType(wifiConfig), this.convertQuotedString(wifiConfig.preSharedKey));
                this.mConnector.doCommand(str);
            }
            this.mConnector.doCommand(String.format("softap startap", new Object[0]));
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating to native daemon to start softap", e);
        }
    }

    private String convertQuotedString(String s) {
        if (s == null) {
            return s;
        }
        return '\"' + s.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + '\"';
    }

    private String getSecurityType(WifiConfiguration wifiConfig) {
        switch (wifiConfig.getAuthType()) {
            case 1: {
                return "wpa-psk";
            }
            case 4: {
                return "wpa2-psk";
            }
        }
        return "open";
    }

    public void wifiFirmwareReload(String wlanIface, String mode) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIFI_STATE", TAG);
        try {
            this.mConnector.doCommand(String.format("softap fwreload " + wlanIface + " " + mode, new Object[0]));
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating to native daemon ", e);
        }
    }

    public void stopAccessPoint(String wlanIface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIFI_STATE", TAG);
        try {
            this.mConnector.doCommand("softap stopap");
            this.mConnector.doCommand("softap stop " + wlanIface);
            this.wifiFirmwareReload(wlanIface, "STA");
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating to native daemon to stop soft AP", e);
        }
    }

    public void setAccessPoint(WifiConfiguration wifiConfig, String wlanIface, String softapIface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIFI_STATE", TAG);
        try {
            if (wifiConfig == null) {
                this.mConnector.doCommand(String.format("softap set " + wlanIface + " " + softapIface, new Object[0]));
            } else {
                String str = String.format("softap set " + wlanIface + " " + softapIface + " %s %s %s", this.convertQuotedString(wifiConfig.SSID), this.getSecurityType(wifiConfig), this.convertQuotedString(wifiConfig.preSharedKey));
                this.mConnector.doCommand(str);
            }
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating to native daemon to set soft AP", e);
        }
    }

    private long getInterfaceCounter(String iface, boolean rx) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        try {
            int code;
            String rsp;
            try {
                rsp = this.mConnector.doCommand(String.format("interface read%scounter %s", rx ? "rx" : "tx", iface)).get(0);
            }
            catch (NativeDaemonConnectorException e1) {
                Slog.e((String)TAG, (String)"Error communicating with native daemon", (Throwable)e1);
                return -1L;
            }
            String[] tok = rsp.split(" ");
            if (tok.length < 2) {
                Slog.e((String)TAG, (String)String.format("Malformed response for reading %s interface", rx ? "rx" : "tx"));
                return -1L;
            }
            try {
                code = Integer.parseInt(tok[0]);
            }
            catch (NumberFormatException nfe) {
                Slog.e((String)TAG, (String)String.format("Error parsing code %s", tok[0]));
                return -1L;
            }
            if (rx && code != 216 || !rx && code != 217) {
                Slog.e((String)TAG, (String)String.format("Unexpected response code %d", code));
                return -1L;
            }
            return Long.parseLong(tok[1]);
        }
        catch (Exception e) {
            Slog.e((String)TAG, (String)String.format("Failed to read interface %s counters", rx ? "rx" : "tx"), (Throwable)e);
            return -1L;
        }
    }

    public NetworkStats getNetworkStatsSummary() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        return this.mStatsFactory.readNetworkStatsSummary();
    }

    public NetworkStats getNetworkStatsDetail() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        return this.mStatsFactory.readNetworkStatsDetail(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterfaceQuota(String iface, long quotaBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (this.mActiveQuotaIfaces.contains(iface)) {
                throw new IllegalStateException("iface " + iface + " already has quota");
            }
            StringBuilder command = new StringBuilder();
            command.append("bandwidth setiquota ").append(iface).append(" ").append(quotaBytes);
            try {
                this.mConnector.doCommand(command.toString());
                this.mActiveQuotaIfaces.add(iface);
            }
            catch (NativeDaemonConnectorException e) {
                throw new IllegalStateException("Error communicating to native daemon", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterfaceQuota(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (!this.mActiveQuotaIfaces.contains(iface)) {
                return;
            }
            StringBuilder command = new StringBuilder();
            command.append("bandwidth removeiquota ").append(iface);
            this.mActiveQuotaIfaces.remove(iface);
            this.mActiveAlertIfaces.remove(iface);
            try {
                this.mConnector.doCommand(command.toString());
            }
            catch (NativeDaemonConnectorException e) {
                throw new IllegalStateException("Error communicating to native daemon", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterfaceAlert(String iface, long alertBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        if (!this.mActiveQuotaIfaces.contains(iface)) {
            throw new IllegalStateException("setting alert requires existing quota on iface");
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (this.mActiveAlertIfaces.contains(iface)) {
                throw new IllegalStateException("iface " + iface + " already has alert");
            }
            StringBuilder command = new StringBuilder();
            command.append("bandwidth setinterfacealert ").append(iface).append(" ").append(alertBytes);
            try {
                this.mConnector.doCommand(command.toString());
                this.mActiveAlertIfaces.add(iface);
            }
            catch (NativeDaemonConnectorException e) {
                throw new IllegalStateException("Error communicating to native daemon", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterfaceAlert(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (!this.mActiveAlertIfaces.contains(iface)) {
                return;
            }
            StringBuilder command = new StringBuilder();
            command.append("bandwidth removeinterfacealert ").append(iface);
            try {
                this.mConnector.doCommand(command.toString());
                this.mActiveAlertIfaces.remove(iface);
            }
            catch (NativeDaemonConnectorException e) {
                throw new IllegalStateException("Error communicating to native daemon", e);
            }
        }
    }

    public void setGlobalAlert(long alertBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        StringBuilder command = new StringBuilder();
        command.append("bandwidth setglobalalert ").append(alertBytes);
        try {
            this.mConnector.doCommand(command.toString());
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating to native daemon", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUidNetworkRules(int uid, boolean rejectOnQuotaInterfaces) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!this.mBandwidthControlEnabled) {
            return;
        }
        SparseBooleanArray sparseBooleanArray = this.mUidRejectOnQuota;
        synchronized (sparseBooleanArray) {
            boolean oldRejectOnQuota = this.mUidRejectOnQuota.get(uid, false);
            if (oldRejectOnQuota == rejectOnQuotaInterfaces) {
                return;
            }
            StringBuilder command = new StringBuilder();
            command.append("bandwidth");
            if (rejectOnQuotaInterfaces) {
                command.append(" addnaughtyapps");
            } else {
                command.append(" removenaughtyapps");
            }
            command.append(" ").append(uid);
            try {
                this.mConnector.doCommand(command.toString());
                if (rejectOnQuotaInterfaces) {
                    this.mUidRejectOnQuota.put(uid, true);
                } else {
                    this.mUidRejectOnQuota.delete(uid);
                }
            }
            catch (NativeDaemonConnectorException e) {
                throw new IllegalStateException("Error communicating to native daemon", e);
            }
        }
    }

    public boolean isBandwidthControlEnabled() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        return this.mBandwidthControlEnabled;
    }

    public NetworkStats getNetworkStatsUidDetail(int uid) {
        if (Binder.getCallingUid() != uid) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        }
        return this.mStatsFactory.readNetworkStatsDetail(uid);
    }

    public NetworkStats getNetworkStatsTethering(String[] ifacePairs) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        if (ifacePairs.length % 2 != 0) {
            throw new IllegalArgumentException("unexpected ifacePairs; length=" + ifacePairs.length);
        }
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 1);
        for (int i = 0; i < ifacePairs.length; i += 2) {
            String ifaceIn = ifacePairs[i];
            String ifaceOut = ifacePairs[i + 1];
            if (ifaceIn == null || ifaceOut == null) continue;
            stats.combineValues(this.getNetworkStatsTethering(ifaceIn, ifaceOut));
        }
        return stats;
    }

    private NetworkStats.Entry getNetworkStatsTethering(String ifaceIn, String ifaceOut) {
        int code;
        String rsp;
        StringBuilder command = new StringBuilder();
        command.append("bandwidth gettetherstats ").append(ifaceIn).append(" ").append(ifaceOut);
        try {
            rsp = this.mConnector.doCommand(command.toString()).get(0);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating to native daemon", e);
        }
        String[] tok = rsp.split(" ");
        if (tok.length != 7) {
            throw new IllegalStateException("Native daemon returned unexpected result: " + rsp);
        }
        try {
            code = Integer.parseInt(tok[0]);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Failed to parse native daemon return code for " + ifaceIn + " " + ifaceOut);
        }
        if (code != 221) {
            throw new IllegalStateException("Unexpected return code from native daemon for " + ifaceIn + " " + ifaceOut);
        }
        try {
            NetworkStats.Entry entry = new NetworkStats.Entry();
            entry.iface = ifaceIn;
            entry.uid = -5;
            entry.set = 0;
            entry.tag = 0;
            entry.rxBytes = Long.parseLong(tok[3]);
            entry.rxPackets = Long.parseLong(tok[4]);
            entry.txBytes = Long.parseLong(tok[5]);
            entry.txPackets = Long.parseLong(tok[6]);
            return entry;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("problem parsing tethering stats for " + ifaceIn + " " + ifaceOut + ": " + e);
        }
    }

    public void setInterfaceThrottle(String iface, int rxKbps, int txKbps) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            this.mConnector.doCommand(String.format("interface setthrottle %s %d %d", iface, rxKbps, txKbps));
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e((String)TAG, (String)"Error communicating with native daemon to set throttle", (Throwable)e);
        }
    }

    private int getInterfaceThrottle(String iface, boolean rx) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        try {
            int code;
            String rsp;
            try {
                rsp = this.mConnector.doCommand(String.format("interface getthrottle %s %s", iface, rx ? "rx" : "tx")).get(0);
            }
            catch (NativeDaemonConnectorException e) {
                Slog.e((String)TAG, (String)"Error communicating with native daemon to getthrottle", (Throwable)e);
                return -1;
            }
            String[] tok = rsp.split(" ");
            if (tok.length < 2) {
                Slog.e((String)TAG, (String)"Malformed response to getthrottle command");
                return -1;
            }
            try {
                code = Integer.parseInt(tok[0]);
            }
            catch (NumberFormatException nfe) {
                Slog.e((String)TAG, (String)String.format("Error parsing code %s", tok[0]));
                return -1;
            }
            if (rx && code != 218 || !rx && code != 219) {
                Slog.e((String)TAG, (String)String.format("Unexpected response code %d", code));
                return -1;
            }
            return Integer.parseInt(tok[1]);
        }
        catch (Exception e) {
            Slog.e((String)TAG, (String)String.format("Failed to read interface %s throttle value", rx ? "rx" : "tx"), (Throwable)e);
            return -1;
        }
    }

    public int getInterfaceRxThrottle(String iface) {
        return this.getInterfaceThrottle(iface, true);
    }

    public int getInterfaceTxThrottle(String iface) {
        return this.getInterfaceThrottle(iface, false);
    }

    public void setDefaultInterfaceForDns(String iface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            String cmd = "resolver setdefaultif " + iface;
            this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating with native daemon to set default interface", e);
        }
    }

    public void setDnsServersForInterface(String iface, String[] servers) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            String cmd = "resolver setifdns " + iface;
            for (String s : servers) {
                InetAddress a = NetworkUtils.numericToInetAddress((String)s);
                if (a.isAnyLocalAddress()) continue;
                cmd = cmd + " " + a.getHostAddress();
            }
            this.mConnector.doCommand(cmd);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error setting dnsn for interface", e);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating with native daemon to set dns for interface", e);
        }
    }

    public void flushDefaultDnsCache() throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            String cmd = "resolver flushdefaultif";
            this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating with native deamon to flush default interface", e);
        }
    }

    public void flushInterfaceDnsCache(String iface) throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
        try {
            String cmd = "resolver flushif " + iface;
            this.mConnector.doCommand(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            throw new IllegalStateException("Error communicating with native daemon to flush interface " + iface, e);
        }
    }

    @Override
    public void monitor() {
        if (this.mConnector != null) {
            this.mConnector.monitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        pw.print("Bandwidth control enabled: ");
        pw.println(this.mBandwidthControlEnabled);
        Object object = this.mQuotaLock;
        synchronized (object) {
            pw.print("Active quota ifaces: ");
            pw.println(this.mActiveQuotaIfaces.toString());
            pw.print("Active alert ifaces: ");
            pw.println(this.mActiveAlertIfaces.toString());
        }
        object = this.mUidRejectOnQuota;
        synchronized (object) {
            pw.print("UID reject on quota ifaces: [");
            int size = this.mUidRejectOnQuota.size();
            for (int i = 0; i < size; ++i) {
                pw.print(this.mUidRejectOnQuota.keyAt(i));
                if (i >= size - 1) continue;
                pw.print(",");
            }
            pw.println("]");
        }
    }

    class NetdCallbackReceiver
    implements INativeDaemonConnectorCallbacks {
        NetdCallbackReceiver() {
        }

        public void onDaemonConnected() {
            NetworkManagementService.this.onDaemonConnected();
        }

        public boolean onEvent(int code, String raw, String[] cooked) {
            switch (code) {
                case 600: {
                    if (cooked.length < 4 || !cooked[1].equals("Iface")) {
                        throw new IllegalStateException(String.format("Invalid event from daemon (%s)", raw));
                    }
                    if (cooked[2].equals("added")) {
                        NetworkManagementService.this.notifyInterfaceAdded(cooked[3]);
                        return true;
                    }
                    if (cooked[2].equals("removed")) {
                        NetworkManagementService.this.notifyInterfaceRemoved(cooked[3]);
                        return true;
                    }
                    if (cooked[2].equals("changed") && cooked.length == 5) {
                        NetworkManagementService.this.notifyInterfaceStatusChanged(cooked[3], cooked[4].equals("up"));
                        return true;
                    }
                    if (cooked[2].equals("linkstate") && cooked.length == 5) {
                        NetworkManagementService.this.notifyInterfaceLinkStateChanged(cooked[3], cooked[4].equals("up"));
                        return true;
                    }
                    throw new IllegalStateException(String.format("Invalid event from daemon (%s)", raw));
                }
                case 601: {
                    if (cooked.length < 5 || !cooked[1].equals("limit")) {
                        throw new IllegalStateException(String.format("Invalid event from daemon (%s)", raw));
                    }
                    if (cooked[2].equals("alert")) {
                        NetworkManagementService.this.notifyLimitReached(cooked[3], cooked[4]);
                        return true;
                    }
                    throw new IllegalStateException(String.format("Invalid event from daemon (%s)", raw));
                }
            }
            return false;
        }
    }

    class NetdResponseCode {
        public static final int InterfaceListResult = 110;
        public static final int TetherInterfaceListResult = 111;
        public static final int TetherDnsFwdTgtListResult = 112;
        public static final int TtyListResult = 113;
        public static final int TetherStatusResult = 210;
        public static final int IpFwdStatusResult = 211;
        public static final int InterfaceGetCfgResult = 213;
        public static final int SoftapStatusResult = 214;
        public static final int InterfaceRxCounterResult = 216;
        public static final int InterfaceTxCounterResult = 217;
        public static final int InterfaceRxThrottleResult = 218;
        public static final int InterfaceTxThrottleResult = 219;
        public static final int QuotaCounterResult = 220;
        public static final int TetheringStatsResult = 221;
        public static final int InterfaceChange = 600;
        public static final int BandwidthControl = 601;

        NetdResponseCode() {
        }
    }
}

