/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.NtpTrustedTime;
import android.util.TrustedTime;

public class NetworkTimeUpdateService {
    private static final String TAG = "NetworkTimeUpdateService";
    private static final boolean DBG = false;
    private static final int EVENT_AUTO_TIME_CHANGED = 1;
    private static final int EVENT_POLL_NETWORK_TIME = 2;
    private static final int EVENT_WIFI_CONNECTED = 3;
    private static final long POLLING_INTERVAL_MS = 86400000L;
    private static final long POLLING_INTERVAL_SHORTER_MS = 60000L;
    private static final int TRY_AGAIN_TIMES_MAX = 3;
    private static final int TIME_ERROR_THRESHOLD_MS = 5000;
    private static final String ACTION_POLL = "com.android.server.NetworkTimeUpdateService.action.POLL";
    private static int POLL_REQUEST = 0;
    private static final long NOT_SET = -1L;
    private long mNitzTimeSetTime = -1L;
    private long mNitzZoneSetTime = -1L;
    private Context mContext;
    private TrustedTime mTime;
    private Handler mHandler;
    private HandlerThread mThread;
    private AlarmManager mAlarmManager;
    private PendingIntent mPendingPollIntent;
    private SettingsObserver mSettingsObserver;
    private long mLastNtpFetchTime = -1L;
    private int mTryAgainCounter;
    private BroadcastReceiver mNitzReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.NETWORK_SET_TIME".equals(action)) {
                NetworkTimeUpdateService.this.mNitzTimeSetTime = SystemClock.elapsedRealtime();
            } else if ("android.intent.action.NETWORK_SET_TIMEZONE".equals(action)) {
                NetworkTimeUpdateService.this.mNitzZoneSetTime = SystemClock.elapsedRealtime();
            }
        }
    };
    private BroadcastReceiver mConnectivityReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NetworkInfo netInfo;
            String action = intent.getAction();
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action) && (netInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo")) != null && netInfo.getState() == NetworkInfo.State.CONNECTED && netInfo.getType() == 1) {
                NetworkTimeUpdateService.this.mHandler.obtainMessage(3).sendToTarget();
            }
        }
    };

    public NetworkTimeUpdateService(Context context) {
        this.mContext = context;
        this.mTime = NtpTrustedTime.getInstance((Context)context);
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent pollIntent = new Intent(ACTION_POLL, null);
        this.mPendingPollIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)POLL_REQUEST, (Intent)pollIntent, (int)0);
    }

    public void systemReady() {
        this.registerForTelephonyIntents();
        this.registerForAlarms();
        this.registerForConnectivityIntents();
        this.mThread = new HandlerThread(TAG);
        this.mThread.start();
        this.mHandler = new MyHandler(this.mThread.getLooper());
        this.mHandler.obtainMessage(2).sendToTarget();
        this.mSettingsObserver = new SettingsObserver(this.mHandler, 1);
        this.mSettingsObserver.observe(this.mContext);
    }

    private void registerForTelephonyIntents() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.NETWORK_SET_TIME");
        intentFilter.addAction("android.intent.action.NETWORK_SET_TIMEZONE");
        this.mContext.registerReceiver(this.mNitzReceiver, intentFilter);
    }

    private void registerForAlarms() {
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                NetworkTimeUpdateService.this.mHandler.obtainMessage(2).sendToTarget();
            }
        }, new IntentFilter(ACTION_POLL));
    }

    private void registerForConnectivityIntents() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver(this.mConnectivityReceiver, intentFilter);
    }

    private void onPollNetworkTime(int event) {
        if (!this.isAutomaticTimeRequested()) {
            return;
        }
        long refTime = SystemClock.elapsedRealtime();
        if (this.mNitzTimeSetTime != -1L && refTime - this.mNitzTimeSetTime < 86400000L) {
            this.resetAlarm(86400000L);
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.mLastNtpFetchTime == -1L || refTime >= this.mLastNtpFetchTime + 86400000L || event == 1) {
            if (this.mTime.getCacheAge() >= 86400000L) {
                this.mTime.forceRefresh();
            }
            if (this.mTime.getCacheAge() < 86400000L) {
                long ntp = this.mTime.currentTimeMillis();
                this.mTryAgainCounter = 0;
                this.mLastNtpFetchTime = SystemClock.elapsedRealtime();
                if (Math.abs(ntp - currentTime) > 5000L && ntp / 1000L < Integer.MAX_VALUE) {
                    SystemClock.setCurrentTimeMillis((long)ntp);
                }
            } else {
                ++this.mTryAgainCounter;
                if (this.mTryAgainCounter <= 3) {
                    this.resetAlarm(60000L);
                } else {
                    this.mTryAgainCounter = 0;
                    this.resetAlarm(86400000L);
                }
                return;
            }
        }
        this.resetAlarm(86400000L);
    }

    private void resetAlarm(long interval) {
        this.mAlarmManager.cancel(this.mPendingPollIntent);
        long now = SystemClock.elapsedRealtime();
        long next = now + interval;
        this.mAlarmManager.set(3, next, this.mPendingPollIntent);
    }

    private boolean isAutomaticTimeRequested() {
        return Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"auto_time", (int)0) != 0;
    }

    private static class SettingsObserver
    extends ContentObserver {
        private int mMsg;
        private Handler mHandler;

        SettingsObserver(Handler handler, int msg) {
            super(handler);
            this.mHandler = handler;
            this.mMsg = msg;
        }

        void observe(Context context) {
            ContentResolver resolver = context.getContentResolver();
            resolver.registerContentObserver(Settings.System.getUriFor((String)"auto_time"), false, (ContentObserver)this);
        }

        public void onChange(boolean selfChange) {
            this.mHandler.obtainMessage(this.mMsg).sendToTarget();
        }
    }

    private class MyHandler
    extends Handler {
        public MyHandler(Looper l) {
            super(l);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: 
                case 3: {
                    NetworkTimeUpdateService.this.onPollNetworkTime(msg.what);
                }
            }
        }
    }
}

