/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.ITransientNotification;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.Vibrator;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.statusbar.StatusBarNotification;
import com.android.server.LightsService;
import com.android.server.NotificationPlayer;
import com.android.server.StatusBarManagerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class NotificationManagerService
extends INotificationManager.Stub {
    private static final String TAG = "NotificationService";
    private static final boolean DBG = false;
    private static final int MAX_PACKAGE_NOTIFICATIONS = 50;
    private static final int MESSAGE_TIMEOUT = 2;
    private static final int LONG_DELAY = 3500;
    private static final int SHORT_DELAY = 2000;
    private static final long[] DEFAULT_VIBRATE_PATTERN = new long[]{0L, 250L, 250L, 250L};
    private static final int DEFAULT_STREAM_TYPE = 5;
    final Context mContext;
    final IActivityManager mAm;
    final IBinder mForegroundToken = new Binder();
    private WorkerHandler mHandler;
    private StatusBarManagerService mStatusBar;
    private LightsService.Light mNotificationLight;
    private LightsService.Light mAttentionLight;
    private int mDefaultNotificationColor;
    private int mDefaultNotificationLedOn;
    private int mDefaultNotificationLedOff;
    private NotificationRecord mSoundNotification;
    private NotificationPlayer mSound;
    private boolean mSystemReady;
    private int mDisabledNotifications;
    private NotificationRecord mVibrateNotification;
    private Vibrator mVibrator = new Vibrator();
    private boolean mScreenOn = true;
    private boolean mInCall = false;
    private boolean mNotificationPulseEnabled;
    private final ArrayList<NotificationRecord> mNotificationList = new ArrayList();
    private ArrayList<ToastRecord> mToastQueue;
    private ArrayList<NotificationRecord> mLights = new ArrayList();
    private NotificationRecord mLedNotification;
    private StatusBarManagerService.NotificationCallbacks mNotificationCallbacks = new StatusBarManagerService.NotificationCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSetDisabled(int status) {
            ArrayList arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                NotificationManagerService.this.mDisabledNotifications = status;
                if ((NotificationManagerService.this.mDisabledNotifications & 0x40000) != 0) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        NotificationManagerService.this.mSound.stop();
                        Object var6_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        Binder.restoreCallingIdentity((long)identity);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity((long)identity);
                    identity = Binder.clearCallingIdentity();
                    try {
                        NotificationManagerService.this.mVibrator.cancel();
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        Binder.restoreCallingIdentity((long)identity);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity((long)identity);
                    {
                    }
                }
            }
        }

        public void onClearAll() {
            NotificationManagerService.this.cancelAll();
        }

        public void onNotificationClick(String pkg, String tag, int id) {
            NotificationManagerService.this.cancelNotification(pkg, tag, id, 16, 64, false);
        }

        public void onNotificationClear(String pkg, String tag, int id) {
            NotificationManagerService.this.cancelNotification(pkg, tag, id, 0, 66, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPanelRevealed() {
            ArrayList arrayList = NotificationManagerService.this.mNotificationList;
            synchronized (arrayList) {
                NotificationManagerService.this.mSoundNotification = null;
                long identity = Binder.clearCallingIdentity();
                try {
                    NotificationManagerService.this.mSound.stop();
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    Binder.restoreCallingIdentity((long)identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity((long)identity);
                NotificationManagerService.this.mVibrateNotification = null;
                identity = Binder.clearCallingIdentity();
                try {
                    NotificationManagerService.this.mVibrator.cancel();
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    Binder.restoreCallingIdentity((long)identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity((long)identity);
                NotificationManagerService.this.mLights.clear();
                NotificationManagerService.this.mLedNotification = null;
                NotificationManagerService.this.updateLightsLocked();
            }
        }

        public void onNotificationError(String pkg, String tag, int id, int uid, int initialPid, String message) {
            Slog.d((String)NotificationManagerService.TAG, (String)("onNotification error pkg=" + pkg + " tag=" + tag + " id=" + id + "; will crashApplication(uid=" + uid + ", pid=" + initialPid + ")"));
            NotificationManagerService.this.cancelNotification(pkg, tag, id, 0, 0, false);
            long ident = Binder.clearCallingIdentity();
            try {
                ActivityManagerNative.getDefault().crashApplication(uid, initialPid, pkg, "Bad notification posted from package " + pkg + ": " + message);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            Binder.restoreCallingIdentity((long)ident);
        }
    };
    private BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            boolean queryRestart = false;
            if (action.equals("android.intent.action.PACKAGE_REMOVED") || action.equals("android.intent.action.PACKAGE_RESTARTED") || action.equals("android.intent.action.PACKAGE_CHANGED") || (queryRestart = action.equals("android.intent.action.QUERY_PACKAGE_RESTART")) || action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE")) {
                String[] pkgList = null;
                if (action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE")) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                } else if (queryRestart) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                } else {
                    Uri uri = intent.getData();
                    if (uri == null) {
                        return;
                    }
                    String pkgName = uri.getSchemeSpecificPart();
                    if (pkgName == null) {
                        return;
                    }
                    pkgList = new String[]{pkgName};
                }
                if (pkgList != null && pkgList.length > 0) {
                    for (String pkgName : pkgList) {
                        NotificationManagerService.this.cancelAllNotificationsInt(pkgName, 0, 0, !queryRestart);
                    }
                }
            } else if (action.equals("android.intent.action.SCREEN_ON")) {
                NotificationManagerService.this.mScreenOn = true;
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                NotificationManagerService.this.mScreenOn = false;
            } else if (action.equals("android.intent.action.PHONE_STATE")) {
                NotificationManagerService.this.mInCall = intent.getStringExtra("state").equals(TelephonyManager.EXTRA_STATE_OFFHOOK);
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.USER_PRESENT")) {
                NotificationManagerService.this.mNotificationLight.turnOff();
            }
        }
    };

    private static String idDebugString(Context baseContext, String packageName, int id) {
        Context c = null;
        if (packageName != null) {
            try {
                c = baseContext.createPackageContext(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                c = baseContext;
            }
        } else {
            c = baseContext;
        }
        Resources r = c.getResources();
        try {
            return r.getResourceName(id);
        }
        catch (Resources.NotFoundException e) {
            return "<name unknown>";
        }
    }

    NotificationManagerService(Context context, StatusBarManagerService statusBar, LightsService lights) {
        this.mContext = context;
        this.mAm = ActivityManagerNative.getDefault();
        this.mSound = new NotificationPlayer(TAG);
        this.mSound.setUsesWakeLock(context);
        this.mToastQueue = new ArrayList();
        this.mHandler = new WorkerHandler();
        this.mStatusBar = statusBar;
        statusBar.setNotificationCallbacks(this.mNotificationCallbacks);
        this.mNotificationLight = lights.getLight(4);
        this.mAttentionLight = lights.getLight(5);
        Resources resources = this.mContext.getResources();
        this.mDefaultNotificationColor = resources.getColor(17170531);
        this.mDefaultNotificationLedOn = resources.getInteger(17694742);
        this.mDefaultNotificationLedOff = resources.getInteger(17694743);
        if (0 == Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"device_provisioned", (int)0)) {
            this.mDisabledNotifications = 262144;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.PHONE_STATE");
        filter.addAction("android.intent.action.USER_PRESENT");
        this.mContext.registerReceiver(this.mIntentReceiver, filter);
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        pkgFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        pkgFilter.addAction("android.intent.action.PACKAGE_RESTARTED");
        pkgFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        pkgFilter.addDataScheme("package");
        this.mContext.registerReceiver(this.mIntentReceiver, pkgFilter);
        IntentFilter sdFilter = new IntentFilter("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mIntentReceiver, sdFilter);
        SettingsObserver observer = new SettingsObserver(this.mHandler);
        observer.observe();
    }

    void systemReady() {
        this.mSystemReady = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueueToast(String pkg, ITransientNotification callback, int duration) {
        if (pkg == null || callback == null) {
            Slog.e((String)TAG, (String)("Not doing toast. pkg=" + pkg + " callback=" + callback));
            return;
        }
        ArrayList<ToastRecord> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            long callingId;
            block11: {
                block10: {
                    int callingPid = Binder.getCallingPid();
                    callingId = Binder.clearCallingIdentity();
                    try {
                        int index = this.indexOfToastLocked(pkg, callback);
                        if (index >= 0) {
                            ToastRecord record = this.mToastQueue.get(index);
                            record.update(duration);
                        } else {
                            if (!"android".equals(pkg)) {
                                int count = 0;
                                int N = this.mToastQueue.size();
                                for (int i = 0; i < N; ++i) {
                                    ToastRecord r = this.mToastQueue.get(i);
                                    if (!r.pkg.equals(pkg) || ++count < 50) continue;
                                    Slog.e((String)TAG, (String)("Package has already posted " + count + " toasts. Not showing more. Package=" + pkg));
                                    Object var15_14 = null;
                                    break block10;
                                }
                            }
                            ToastRecord record = new ToastRecord(callingPid, pkg, callback, duration);
                            this.mToastQueue.add(record);
                            index = this.mToastQueue.size() - 1;
                            this.keepProcessAliveLocked(callingPid);
                        }
                        if (index == 0) {
                            this.showNextToastLocked();
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var15_16 = null;
                        Binder.restoreCallingIdentity((long)callingId);
                        throw throwable;
                    }
                }
                Binder.restoreCallingIdentity((long)callingId);
                return;
            }
            Object var15_15 = null;
            Binder.restoreCallingIdentity((long)callingId);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelToast(String pkg, ITransientNotification callback) {
        Slog.i((String)TAG, (String)("cancelToast pkg=" + pkg + " callback=" + callback));
        if (pkg == null || callback == null) {
            Slog.e((String)TAG, (String)("Not cancelling notification. pkg=" + pkg + " callback=" + callback));
            return;
        }
        ArrayList<ToastRecord> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            long callingId = Binder.clearCallingIdentity();
            try {
                int index = this.indexOfToastLocked(pkg, callback);
                if (index >= 0) {
                    this.cancelToastLocked(index);
                } else {
                    Slog.w((String)TAG, (String)("Toast already cancelled. pkg=" + pkg + " callback=" + callback));
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity((long)callingId);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)callingId);
        }
    }

    private void showNextToastLocked() {
        ToastRecord record = this.mToastQueue.get(0);
        while (record != null) {
            try {
                record.callback.show();
                this.scheduleTimeoutLocked(record, false);
                return;
            }
            catch (RemoteException e) {
                Slog.w((String)TAG, (String)("Object died trying to show notification " + record.callback + " in package " + record.pkg));
                int index = this.mToastQueue.indexOf(record);
                if (index >= 0) {
                    this.mToastQueue.remove(index);
                }
                this.keepProcessAliveLocked(record.pid);
                if (this.mToastQueue.size() > 0) {
                    record = this.mToastQueue.get(0);
                    continue;
                }
                record = null;
            }
        }
    }

    private void cancelToastLocked(int index) {
        ToastRecord record = this.mToastQueue.get(index);
        try {
            record.callback.hide();
        }
        catch (RemoteException e) {
            Slog.w((String)TAG, (String)("Object died trying to hide notification " + record.callback + " in package " + record.pkg));
        }
        this.mToastQueue.remove(index);
        this.keepProcessAliveLocked(record.pid);
        if (this.mToastQueue.size() > 0) {
            this.showNextToastLocked();
        }
    }

    private void scheduleTimeoutLocked(ToastRecord r, boolean immediate) {
        Message m = Message.obtain((Handler)this.mHandler, (int)2, (Object)r);
        long delay = immediate ? 0L : (long)(r.duration == 1 ? 3500 : 2000);
        this.mHandler.removeCallbacksAndMessages(r);
        this.mHandler.sendMessageDelayed(m, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(ToastRecord record) {
        ArrayList<ToastRecord> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            int index = this.indexOfToastLocked(record.pkg, record.callback);
            if (index >= 0) {
                this.cancelToastLocked(index);
            }
        }
    }

    private int indexOfToastLocked(String pkg, ITransientNotification callback) {
        IBinder cbak = callback.asBinder();
        ArrayList<ToastRecord> list = this.mToastQueue;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            ToastRecord r = list.get(i);
            if (!r.pkg.equals(pkg) || r.callback.asBinder() != cbak) continue;
            return i;
        }
        return -1;
    }

    private void keepProcessAliveLocked(int pid) {
        int toastCount = 0;
        ArrayList<ToastRecord> list = this.mToastQueue;
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ToastRecord r = list.get(i);
            if (r.pid != pid) continue;
            ++toastCount;
        }
        try {
            this.mAm.setProcessForeground(this.mForegroundToken, pid, toastCount > 0);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Deprecated
    public void enqueueNotification(String pkg, int id, Notification notification, int[] idOut) {
        this.enqueueNotificationWithTag(pkg, null, id, notification, idOut);
    }

    public void enqueueNotificationWithTag(String pkg, String tag, int id, Notification notification, int[] idOut) {
        this.enqueueNotificationInternal(pkg, Binder.getCallingUid(), Binder.getCallingPid(), tag, id, notification, idOut);
    }

    public void enqueueNotificationWithTagPriority(String pkg, String tag, int id, int priority, Notification notification, int[] idOut) {
        this.enqueueNotificationInternal(pkg, Binder.getCallingUid(), Binder.getCallingPid(), tag, id, priority, notification, idOut);
    }

    public void enqueueNotificationInternal(String pkg, int callingUid, int callingPid, String tag, int id, Notification notification, int[] idOut) {
        this.enqueueNotificationInternal(pkg, callingUid, callingPid, tag, id, (notification.flags & 2) != 0 ? StatusBarNotification.PRIORITY_ONGOING : StatusBarNotification.PRIORITY_NORMAL, notification, idOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueNotificationInternal(String pkg, int callingUid, int callingPid, String tag, int id, int priority, Notification notification, int[] idOut) {
        ArrayList<NotificationRecord> arrayList;
        this.checkIncomingCall(pkg);
        if (!"android".equals(pkg)) {
            arrayList = this.mNotificationList;
            synchronized (arrayList) {
                int count = 0;
                int N = this.mNotificationList.size();
                for (int i = 0; i < N; ++i) {
                    NotificationRecord r = this.mNotificationList.get(i);
                    if (!r.pkg.equals(pkg) || ++count < 50) continue;
                    Slog.e((String)TAG, (String)("Package has already posted " + count + " notifications.  Not showing more.  package=" + pkg));
                    return;
                }
            }
        }
        if (!pkg.equals("com.android.providers.downloads") || Log.isLoggable((String)"DownloadManager", (int)2)) {
            EventLog.writeEvent((int)2750, (Object[])new Object[]{pkg, id, tag, notification.toString()});
        }
        if (pkg == null || notification == null) {
            throw new IllegalArgumentException("null not allowed: pkg=" + pkg + " id=" + id + " notification=" + notification);
        }
        if (notification.icon != 0 && notification.contentView == null) {
            throw new IllegalArgumentException("contentView required: pkg=" + pkg + " id=" + id + " notification=" + notification);
        }
        arrayList = this.mNotificationList;
        synchronized (arrayList) {
            NotificationRecord r = new NotificationRecord(pkg, tag, id, callingUid, callingPid, priority, notification);
            NotificationRecord old = null;
            int index = this.indexOfNotificationLocked(pkg, tag, id);
            if (index < 0) {
                this.mNotificationList.add(r);
            } else {
                old = this.mNotificationList.remove(index);
                this.mNotificationList.add(index, r);
                if (old != null) {
                    notification.flags |= old.notification.flags & 0x40;
                }
            }
            if ((notification.flags & 0x40) != 0) {
                notification.flags |= 0x22;
            }
            if (notification.icon != 0) {
                block35: {
                    long identity;
                    StatusBarNotification n = new StatusBarNotification(pkg, id, tag, r.uid, r.initialPid, notification);
                    n.priority = r.priority;
                    if (old != null && old.statusBarKey != null) {
                        r.statusBarKey = old.statusBarKey;
                        identity = Binder.clearCallingIdentity();
                        try {
                            this.mStatusBar.updateNotification(r.statusBarKey, n);
                            Object var17_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_22 = null;
                            Binder.restoreCallingIdentity((long)identity);
                            throw throwable;
                        }
                        Binder.restoreCallingIdentity((long)identity);
                        {
                            break block35;
                        }
                    }
                    identity = Binder.clearCallingIdentity();
                    try {
                        r.statusBarKey = this.mStatusBar.addNotification(n);
                        this.mAttentionLight.pulse();
                        Object var19_26 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_27 = null;
                        Binder.restoreCallingIdentity((long)identity);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity((long)identity);
                    {
                    }
                }
                this.sendAccessibilityEvent(notification, pkg);
            } else {
                Slog.e((String)TAG, (String)("Ignoring notification with icon==0: " + notification));
                if (old != null && old.statusBarKey != null) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        this.mStatusBar.removeNotification(old.statusBarKey);
                        Object var21_30 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_31 = null;
                        Binder.restoreCallingIdentity((long)identity);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity((long)identity);
                    {
                    }
                }
            }
            if ((this.mDisabledNotifications & 0x40000) == 0 && (old == null || (notification.flags & 8) == 0) && this.mSystemReady) {
                boolean useDefaultVibrate;
                boolean useDefaultSound;
                AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
                boolean bl = useDefaultSound = (notification.defaults & 1) != 0;
                if (useDefaultSound || notification.sound != null) {
                    Uri uri = useDefaultSound ? Settings.System.DEFAULT_NOTIFICATION_URI : notification.sound;
                    boolean looping = (notification.flags & 4) != 0;
                    int audioStreamType = notification.audioStreamType >= 0 ? notification.audioStreamType : 5;
                    this.mSoundNotification = r;
                    if (audioManager.getStreamVolume(audioStreamType) != 0) {
                        long identity = Binder.clearCallingIdentity();
                        try {
                            this.mSound.play(this.mContext, uri, looping, audioStreamType);
                            Object var23_35 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_36 = null;
                            Binder.restoreCallingIdentity((long)identity);
                            throw throwable;
                        }
                        Binder.restoreCallingIdentity((long)identity);
                        {
                        }
                    }
                }
                boolean bl2 = useDefaultVibrate = (notification.defaults & 2) != 0;
                if ((useDefaultVibrate || notification.vibrate != null) && audioManager.shouldVibrate(1)) {
                    this.mVibrateNotification = r;
                    this.mVibrator.vibrate(useDefaultVibrate ? DEFAULT_VIBRATE_PATTERN : notification.vibrate, (notification.flags & 4) != 0 ? 0 : -1);
                }
            }
            this.mLights.remove(old);
            if (this.mLedNotification == old) {
                this.mLedNotification = null;
            }
            if ((notification.flags & 1) != 0) {
                this.mLights.add(r);
                this.updateLightsLocked();
            } else if (old != null && (old.notification.flags & 1) != 0) {
                this.updateLightsLocked();
            }
        }
        idOut[0] = id;
    }

    private void sendAccessibilityEvent(Notification notification, CharSequence packageName) {
        AccessibilityManager manager = AccessibilityManager.getInstance((Context)this.mContext);
        if (!manager.isEnabled()) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain((int)64);
        event.setPackageName(packageName);
        event.setClassName((CharSequence)Notification.class.getName());
        event.setParcelableData((Parcelable)notification);
        CharSequence tickerText = notification.tickerText;
        if (!TextUtils.isEmpty((CharSequence)tickerText)) {
            event.getText().add(tickerText);
        }
        manager.sendAccessibilityEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelNotificationLocked(NotificationRecord r, boolean sendDelete) {
        if (sendDelete && r.notification.deleteIntent != null) {
            try {
                r.notification.deleteIntent.send();
            }
            catch (PendingIntent.CanceledException ex) {
                Slog.w((String)TAG, (String)("canceled PendingIntent for " + r.pkg), (Throwable)ex);
            }
        }
        if (r.notification.icon != 0) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mStatusBar.removeNotification(r.statusBarKey);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                Binder.restoreCallingIdentity((long)identity);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)identity);
            r.statusBarKey = null;
        }
        if (this.mSoundNotification == r) {
            this.mSoundNotification = null;
            long identity = Binder.clearCallingIdentity();
            try {
                this.mSound.stop();
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                Binder.restoreCallingIdentity((long)identity);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)identity);
            {
            }
        }
        if (this.mVibrateNotification == r) {
            this.mVibrateNotification = null;
            long identity = Binder.clearCallingIdentity();
            try {
                this.mVibrator.cancel();
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                Binder.restoreCallingIdentity((long)identity);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)identity);
            {
            }
        }
        this.mLights.remove(r);
        if (this.mLedNotification == r) {
            this.mLedNotification = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelNotification(String pkg, String tag, int id, int mustHaveFlags, int mustNotHaveFlags, boolean sendDelete) {
        EventLog.writeEvent((int)2751, (Object[])new Object[]{pkg, id, tag, mustHaveFlags, mustNotHaveFlags});
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            int index = this.indexOfNotificationLocked(pkg, tag, id);
            if (index >= 0) {
                NotificationRecord r = this.mNotificationList.get(index);
                if ((r.notification.flags & mustHaveFlags) != mustHaveFlags) {
                    return;
                }
                if ((r.notification.flags & mustNotHaveFlags) != 0) {
                    return;
                }
                this.mNotificationList.remove(index);
                this.cancelNotificationLocked(r, sendDelete);
                this.updateLightsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelAllNotificationsInt(String pkg, int mustHaveFlags, int mustNotHaveFlags, boolean doit) {
        EventLog.writeEvent((int)2752, (Object[])new Object[]{pkg, mustHaveFlags, mustNotHaveFlags});
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            int N = this.mNotificationList.size();
            boolean canceledSomething = false;
            for (int i = N - 1; i >= 0; --i) {
                NotificationRecord r = this.mNotificationList.get(i);
                if ((r.notification.flags & mustHaveFlags) != mustHaveFlags || (r.notification.flags & mustNotHaveFlags) != 0 || !r.pkg.equals(pkg)) continue;
                canceledSomething = true;
                if (!doit) {
                    return true;
                }
                this.mNotificationList.remove(i);
                this.cancelNotificationLocked(r, false);
            }
            if (canceledSomething) {
                this.updateLightsLocked();
            }
            return canceledSomething;
        }
    }

    @Deprecated
    public void cancelNotification(String pkg, int id) {
        this.cancelNotificationWithTag(pkg, null, id);
    }

    public void cancelNotificationWithTag(String pkg, String tag, int id) {
        this.checkIncomingCall(pkg);
        this.cancelNotification(pkg, tag, id, 0, Binder.getCallingUid() == 1000 ? 0 : 64, false);
    }

    public void cancelAllNotifications(String pkg) {
        this.checkIncomingCall(pkg);
        this.cancelAllNotificationsInt(pkg, 0, 64, true);
    }

    void checkIncomingCall(String pkg) {
        int uid = Binder.getCallingUid();
        if (uid == 1000 || uid == 0) {
            return;
        }
        try {
            ApplicationInfo ai = this.mContext.getPackageManager().getApplicationInfo(pkg, 0);
            if (ai.uid != uid) {
                throw new SecurityException("Calling uid " + uid + " gave package" + pkg + " which is owned by uid " + ai.uid);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException("Unknown package " + pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll() {
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            int N = this.mNotificationList.size();
            for (int i = N - 1; i >= 0; --i) {
                NotificationRecord r = this.mNotificationList.get(i);
                if ((r.notification.flags & 0x22) != 0) continue;
                this.mNotificationList.remove(i);
                this.cancelNotificationLocked(r, true);
            }
            this.updateLightsLocked();
        }
    }

    private void updateLightsLocked() {
        int n;
        if (this.mLedNotification == null && (n = this.mLights.size()) > 0) {
            this.mLedNotification = this.mLights.get(n - 1);
        }
        if (this.mLedNotification == null || this.mInCall || this.mScreenOn) {
            this.mNotificationLight.turnOff();
        } else {
            int ledARGB = this.mLedNotification.notification.ledARGB;
            int ledOnMS = this.mLedNotification.notification.ledOnMS;
            int ledOffMS = this.mLedNotification.notification.ledOffMS;
            if ((this.mLedNotification.notification.defaults & 4) != 0) {
                ledARGB = this.mDefaultNotificationColor;
                ledOnMS = this.mDefaultNotificationLedOn;
                ledOffMS = this.mDefaultNotificationLedOff;
            }
            if (this.mNotificationPulseEnabled) {
                this.mNotificationLight.setFlashing(ledARGB, 1, ledOnMS, ledOffMS);
            }
        }
    }

    private int indexOfNotificationLocked(String pkg, String tag, int id) {
        ArrayList<NotificationRecord> list = this.mNotificationList;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            NotificationRecord r = list.get(i);
            if (tag != null ? !tag.equals(r.tag) : r.tag != null) continue;
            if (r.id != id || !r.pkg.equals(pkg)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationPulse() {
        ArrayList<NotificationRecord> arrayList = this.mNotificationList;
        synchronized (arrayList) {
            this.updateLightsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        int N;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump NotificationManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("Current Notification Manager state:");
        ArrayList<Object> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            N = this.mToastQueue.size();
            if (N > 0) {
                pw.println("  Toast Queue:");
                for (i = 0; i < N; ++i) {
                    this.mToastQueue.get(i).dump(pw, "    ");
                }
                pw.println("  ");
            }
        }
        arrayList = this.mNotificationList;
        synchronized (arrayList) {
            N = this.mNotificationList.size();
            if (N > 0) {
                pw.println("  Notification List:");
                for (i = 0; i < N; ++i) {
                    this.mNotificationList.get(i).dump(pw, "    ", this.mContext);
                }
                pw.println("  ");
            }
            if ((N = this.mLights.size()) > 0) {
                pw.println("  Lights List:");
                for (i = 0; i < N; ++i) {
                    this.mLights.get(i).dump(pw, "    ", this.mContext);
                }
                pw.println("  ");
            }
            pw.println("  mSoundNotification=" + this.mSoundNotification);
            pw.println("  mSound=" + this.mSound);
            pw.println("  mVibrateNotification=" + this.mVibrateNotification);
            pw.println("  mDisabledNotifications=0x" + Integer.toHexString(this.mDisabledNotifications));
            pw.println("  mSystemReady=" + this.mSystemReady);
        }
    }

    private final class WorkerHandler
    extends Handler {
        private WorkerHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    NotificationManagerService.this.handleTimeout((ToastRecord)msg.obj);
                }
            }
        }
    }

    class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
        }

        void observe() {
            ContentResolver resolver = NotificationManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.System.getUriFor((String)"notification_light_pulse"), false, (ContentObserver)this);
            this.update();
        }

        public void onChange(boolean selfChange) {
            this.update();
        }

        public void update() {
            boolean pulseEnabled;
            ContentResolver resolver = NotificationManagerService.this.mContext.getContentResolver();
            boolean bl = pulseEnabled = Settings.System.getInt((ContentResolver)resolver, (String)"notification_light_pulse", (int)0) != 0;
            if (NotificationManagerService.this.mNotificationPulseEnabled != pulseEnabled) {
                NotificationManagerService.this.mNotificationPulseEnabled = pulseEnabled;
                NotificationManagerService.this.updateNotificationPulse();
            }
        }
    }

    private static final class ToastRecord {
        final int pid;
        final String pkg;
        final ITransientNotification callback;
        int duration;

        ToastRecord(int pid, String pkg, ITransientNotification callback, int duration) {
            this.pid = pid;
            this.pkg = pkg;
            this.callback = callback;
            this.duration = duration;
        }

        void update(int duration) {
            this.duration = duration;
        }

        void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + this);
        }

        public final String toString() {
            return "ToastRecord{" + Integer.toHexString(System.identityHashCode(this)) + " pkg=" + this.pkg + " callback=" + this.callback + " duration=" + this.duration;
        }
    }

    private static final class NotificationRecord {
        final String pkg;
        final String tag;
        final int id;
        final int uid;
        final int initialPid;
        final int priority;
        final Notification notification;
        IBinder statusBarKey;

        NotificationRecord(String pkg, String tag, int id, int uid, int initialPid, int priority, Notification notification) {
            this.pkg = pkg;
            this.tag = tag;
            this.id = id;
            this.uid = uid;
            this.initialPid = initialPid;
            this.priority = priority;
            this.notification = notification;
        }

        void dump(PrintWriter pw, String prefix, Context baseContext) {
            pw.println(prefix + this);
            pw.println(prefix + "  icon=0x" + Integer.toHexString(this.notification.icon) + " / " + NotificationManagerService.idDebugString(baseContext, this.pkg, this.notification.icon));
            pw.println(prefix + "  contentIntent=" + this.notification.contentIntent);
            pw.println(prefix + "  deleteIntent=" + this.notification.deleteIntent);
            pw.println(prefix + "  tickerText=" + this.notification.tickerText);
            pw.println(prefix + "  contentView=" + this.notification.contentView);
            pw.println(prefix + "  defaults=0x" + Integer.toHexString(this.notification.defaults));
            pw.println(prefix + "  flags=0x" + Integer.toHexString(this.notification.flags));
            pw.println(prefix + "  sound=" + this.notification.sound);
            pw.println(prefix + "  vibrate=" + Arrays.toString(this.notification.vibrate));
            pw.println(prefix + "  ledARGB=0x" + Integer.toHexString(this.notification.ledARGB) + " ledOnMS=" + this.notification.ledOnMS + " ledOffMS=" + this.notification.ledOffMS);
        }

        public final String toString() {
            return "NotificationRecord{" + Integer.toHexString(System.identityHashCode(this)) + " pkg=" + this.pkg + " id=" + Integer.toHexString(this.id) + " tag=" + this.tag + " pri=" + this.priority + "}";
        }
    }
}

