/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import java.util.LinkedList;

public class NotificationPlayer
implements MediaPlayer.OnCompletionListener {
    private static final int PLAY = 1;
    private static final int STOP = 2;
    private static final boolean mDebug = false;
    private LinkedList<Command> mCmdQueue = new LinkedList();
    private Looper mLooper;
    private String mTag;
    private CmdThread mThread;
    private CreationAndCompletionThread mCompletionThread;
    private final Object mCompletionHandlingLock = new Object();
    private MediaPlayer mPlayer;
    private PowerManager.WakeLock mWakeLock;
    private AudioManager mAudioManager;
    private int mState = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSound(Command cmd) {
        try {
            Object object = this.mCompletionHandlingLock;
            synchronized (object) {
                if (this.mLooper != null && this.mLooper.getThread().getState() != Thread.State.TERMINATED) {
                    this.mLooper.quit();
                }
                CreationAndCompletionThread creationAndCompletionThread = this.mCompletionThread = new CreationAndCompletionThread(cmd);
                synchronized (creationAndCompletionThread) {
                    this.mCompletionThread.start();
                    this.mCompletionThread.wait();
                }
            }
            long delay = SystemClock.uptimeMillis() - cmd.requestTime;
            if (delay > 1000L) {
                Log.w((String)this.mTag, (String)("Notification sound delayed by " + delay + "msecs"));
            }
        }
        catch (Exception e) {
            Log.w((String)this.mTag, (String)("error loading sound for " + cmd.uri), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(MediaPlayer mp) {
        if (this.mAudioManager != null) {
            this.mAudioManager.abandonAudioFocus(null);
        }
        LinkedList<Command> linkedList = this.mCmdQueue;
        synchronized (linkedList) {
            if (this.mCmdQueue.size() == 0) {
                Object object = this.mCompletionHandlingLock;
                synchronized (object) {
                    if (this.mLooper != null) {
                        this.mLooper.quit();
                    }
                    this.mCompletionThread = null;
                }
            }
        }
    }

    public NotificationPlayer(String tag) {
        this.mTag = tag != null ? tag : "NotificationPlayer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(Context context, Uri uri, boolean looping, int stream) {
        Command cmd = new Command();
        cmd.requestTime = SystemClock.uptimeMillis();
        cmd.code = 1;
        cmd.context = context;
        cmd.uri = uri;
        cmd.looping = looping;
        cmd.stream = stream;
        LinkedList<Command> linkedList = this.mCmdQueue;
        synchronized (linkedList) {
            this.enqueueLocked(cmd);
            this.mState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LinkedList<Command> linkedList = this.mCmdQueue;
        synchronized (linkedList) {
            if (this.mState != 2) {
                Command cmd = new Command();
                cmd.requestTime = SystemClock.uptimeMillis();
                cmd.code = 2;
                this.enqueueLocked(cmd);
                this.mState = 2;
            }
        }
    }

    private void enqueueLocked(Command cmd) {
        this.mCmdQueue.add(cmd);
        if (this.mThread == null) {
            this.acquireWakeLock();
            this.mThread = new CmdThread();
            this.mThread.start();
        }
    }

    public void setUsesWakeLock(Context context) {
        if (this.mWakeLock != null || this.mThread != null) {
            throw new RuntimeException("assertion failed mWakeLock=" + this.mWakeLock + " mThread=" + this.mThread);
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, this.mTag);
    }

    private void acquireWakeLock() {
        if (this.mWakeLock != null) {
            this.mWakeLock.acquire();
        }
    }

    private void releaseWakeLock() {
        if (this.mWakeLock != null) {
            this.mWakeLock.release();
        }
    }

    private final class CmdThread
    extends Thread {
        CmdThread() {
            super("NotificationPlayer-" + NotificationPlayer.this.mTag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Command cmd = null;
                LinkedList linkedList = NotificationPlayer.this.mCmdQueue;
                synchronized (linkedList) {
                    cmd = (Command)NotificationPlayer.this.mCmdQueue.removeFirst();
                }
                switch (cmd.code) {
                    case 1: {
                        NotificationPlayer.this.startSound(cmd);
                        break;
                    }
                    case 2: {
                        if (NotificationPlayer.this.mPlayer != null) {
                            long delay = SystemClock.uptimeMillis() - cmd.requestTime;
                            if (delay > 1000L) {
                                Log.w((String)NotificationPlayer.this.mTag, (String)("Notification stop delayed by " + delay + "msecs"));
                            }
                            NotificationPlayer.this.mPlayer.stop();
                            NotificationPlayer.this.mPlayer.release();
                            NotificationPlayer.this.mPlayer = null;
                            NotificationPlayer.this.mAudioManager.abandonAudioFocus(null);
                            NotificationPlayer.this.mAudioManager = null;
                            if (NotificationPlayer.this.mLooper == null || NotificationPlayer.this.mLooper.getThread().getState() == Thread.State.TERMINATED) break;
                            NotificationPlayer.this.mLooper.quit();
                            break;
                        }
                        Log.w((String)NotificationPlayer.this.mTag, (String)"STOP command without a player");
                    }
                }
                linkedList = NotificationPlayer.this.mCmdQueue;
                synchronized (linkedList) {
                    if (NotificationPlayer.this.mCmdQueue.size() == 0) {
                        NotificationPlayer.this.mThread = null;
                        NotificationPlayer.this.releaseWakeLock();
                        return;
                    }
                }
            }
        }
    }

    private final class CreationAndCompletionThread
    extends Thread {
        public Command mCmd;

        public CreationAndCompletionThread(Command cmd) {
            this.mCmd = cmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            NotificationPlayer.this.mLooper = Looper.myLooper();
            CreationAndCompletionThread creationAndCompletionThread = this;
            synchronized (creationAndCompletionThread) {
                AudioManager audioManager = (AudioManager)this.mCmd.context.getSystemService("audio");
                try {
                    MediaPlayer player = new MediaPlayer();
                    player.setAudioStreamType(this.mCmd.stream);
                    player.setDataSource(this.mCmd.context, this.mCmd.uri);
                    player.setLooping(this.mCmd.looping);
                    player.prepare();
                    if (this.mCmd.uri != null && this.mCmd.uri.getEncodedPath() != null && this.mCmd.uri.getEncodedPath().length() > 0) {
                        if (this.mCmd.looping) {
                            audioManager.requestAudioFocus(null, this.mCmd.stream, 1);
                        } else {
                            audioManager.requestAudioFocus(null, this.mCmd.stream, 3);
                        }
                    }
                    player.setOnCompletionListener((MediaPlayer.OnCompletionListener)NotificationPlayer.this);
                    player.start();
                    if (NotificationPlayer.this.mPlayer != null) {
                        NotificationPlayer.this.mPlayer.release();
                    }
                    NotificationPlayer.this.mPlayer = player;
                }
                catch (Exception e) {
                    Log.w((String)NotificationPlayer.this.mTag, (String)("error loading sound for " + this.mCmd.uri), (Throwable)e);
                }
                NotificationPlayer.this.mAudioManager = audioManager;
                this.notify();
            }
            Looper.loop();
        }
    }

    private static final class Command {
        int code;
        Context context;
        Uri uri;
        boolean looping;
        int stream;
        long requestTime;

        private Command() {
        }

        public String toString() {
            return "{ code=" + this.code + " looping=" + this.looping + " stream=" + this.stream + " uri=" + this.uri + " }";
        }
    }
}

