/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentQueryMap;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.Cursor;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.LocalPowerManager;
import android.os.Power;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.view.WindowManagerPolicy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.app.ShutdownThread;
import com.android.server.BatteryService;
import com.android.server.LightsService;
import com.android.server.Watchdog;
import com.android.server.am.BatteryStatsService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class PowerManagerService
extends IPowerManager.Stub
implements LocalPowerManager,
Watchdog.Monitor {
    private static final String TAG = "PowerManagerService";
    static final String PARTIAL_NAME = "PowerManagerService";
    static final boolean DEBUG_SCREEN_ON = false;
    private static final boolean LOG_PARTIAL_WL = false;
    private static final boolean LOG_TOUCH_DOWNS = true;
    private static final int LOCK_MASK = 63;
    private static final int SHORT_KEYLIGHT_DELAY_DEFAULT = 6000;
    private static final int MEDIUM_KEYLIGHT_DELAY = 15000;
    private static final int LONG_KEYLIGHT_DELAY = 6000;
    private static final int LONG_DIM_TIME = 7000;
    private static final int LIGHT_SENSOR_DELAY = 2000;
    private static final int LIGHT_SENSOR_RATE = 1000000;
    private static final int PROXIMITY_SENSOR_DELAY = 1000;
    private static final float PROXIMITY_THRESHOLD = 5.0f;
    private int mShortKeylightDelay = 6000;
    private static final int DEFAULT_SCREEN_OFF_TIMEOUT = 15000;
    private static final int SCREEN_ON_BIT = 1;
    private static final int SCREEN_BRIGHT_BIT = 2;
    private static final int BUTTON_BRIGHT_BIT = 4;
    private static final int KEYBOARD_BRIGHT_BIT = 8;
    private static final int BATTERY_LOW_BIT = 16;
    private static final int SCREEN_OFF = 0;
    private static final int SCREEN_DIM = 1;
    private static final int SCREEN_BRIGHT = 3;
    private static final int SCREEN_BUTTON_BRIGHT = 7;
    private static final int ALL_BRIGHT = 15;
    private static final int LIGHTS_MASK = 14;
    boolean mAnimateScreenLights = true;
    static final int ANIM_STEPS = 15;
    static final int AUTOBRIGHTNESS_ANIM_STEPS = 60;
    static final int INITIAL_SCREEN_BRIGHTNESS = 255;
    static final int INITIAL_BUTTON_BRIGHTNESS = 0;
    static final int INITIAL_KEYBOARD_BRIGHTNESS = 0;
    private final int MY_UID;
    private final int MY_PID;
    private boolean mDoneBooting = false;
    private boolean mBootCompleted = false;
    private int mStayOnConditions = 0;
    private final int[] mBroadcastQueue = new int[]{-1, -1, -1};
    private final int[] mBroadcastWhy = new int[3];
    private boolean mPreparingForScreenOn = false;
    private boolean mSkippedScreenOn = false;
    private boolean mInitialized = false;
    private int mPartialCount = 0;
    private int mPowerState;
    private int mScreenOffReason;
    private int mUserState;
    private boolean mKeyboardVisible = false;
    private boolean mUserActivityAllowed = true;
    private int mProximityWakeLockCount = 0;
    private boolean mProximitySensorEnabled = false;
    private boolean mProximitySensorActive = false;
    private int mProximityPendingValue = -1;
    private long mLastProximityEventTime;
    private int mScreenOffTimeoutSetting;
    private int mMaximumScreenOffTimeout = Integer.MAX_VALUE;
    private int mKeylightDelay;
    private int mDimDelay;
    private int mScreenOffDelay;
    private int mWakeLockState;
    private long mLastEventTime = 0L;
    private long mScreenOffTime;
    private volatile WindowManagerPolicy mPolicy;
    private final LockList mLocks = new LockList();
    private Intent mScreenOffIntent;
    private Intent mScreenOnIntent;
    private LightsService mLightsService;
    private Context mContext;
    private LightsService.Light mLcdLight;
    private LightsService.Light mButtonLight;
    private LightsService.Light mKeyboardLight;
    private LightsService.Light mAttentionLight;
    private UnsynchronizedWakeLock mBroadcastWakeLock;
    private UnsynchronizedWakeLock mStayOnWhilePluggedInScreenDimLock;
    private UnsynchronizedWakeLock mStayOnWhilePluggedInPartialLock;
    private UnsynchronizedWakeLock mPreventScreenOnPartialLock;
    private UnsynchronizedWakeLock mProximityPartialLock;
    private HandlerThread mHandlerThread;
    private HandlerThread mScreenOffThread;
    private Handler mScreenOffHandler;
    private Handler mHandler;
    private final TimeoutTask mTimeoutTask = new TimeoutTask();
    private final BrightnessState mScreenBrightness = new BrightnessState(2);
    private boolean mStillNeedSleepNotification;
    private boolean mIsPowered = false;
    private IActivityManager mActivityService;
    private IBatteryStats mBatteryStats;
    private BatteryService mBatteryService;
    private SensorManager mSensorManager;
    private Sensor mProximitySensor;
    private Sensor mLightSensor;
    private boolean mLightSensorEnabled;
    private float mLightSensorValue = -1.0f;
    private boolean mProxIgnoredBecauseScreenTurnedOff = false;
    private int mHighestLightSensorValue = -1;
    private boolean mLightSensorPendingDecrease = false;
    private boolean mLightSensorPendingIncrease = false;
    private float mLightSensorPendingValue = -1.0f;
    private int mLightSensorScreenBrightness = -1;
    private int mLightSensorButtonBrightness = -1;
    private int mLightSensorKeyboardBrightness = -1;
    private boolean mDimScreen = true;
    private boolean mIsDocked = false;
    private long mNextTimeout;
    private volatile int mPokey = 0;
    private volatile boolean mPokeAwakeOnSet = false;
    private volatile boolean mInitComplete = false;
    private final HashMap<IBinder, PokeLock> mPokeLocks = new HashMap();
    private long mLastScreenOnTime;
    private boolean mPreventScreenOn;
    private int mScreenBrightnessOverride = -1;
    private int mButtonBrightnessOverride = -1;
    private int mScreenBrightnessDim;
    private boolean mUseSoftwareAutoBrightness;
    private boolean mAutoBrightessEnabled;
    private int[] mAutoBrightnessLevels;
    private int[] mLcdBacklightValues;
    private int[] mButtonBacklightValues;
    private int[] mKeyboardBacklightValues;
    private int mLightSensorWarmupTime;
    boolean mUnplugTurnsOnScreen;
    private int mWarningSpewThrottleCount;
    private long mWarningSpewThrottleTime;
    private int mAnimationSetting = 16;
    private static final int ANIM_SETTING_ON = 1;
    private static final int ANIM_SETTING_OFF = 16;
    private long mTotalTouchDownTime;
    private long mLastTouchDown;
    private int mTouchCycles;
    private static final boolean mSpew = false;
    private static final boolean mDebugProximitySensor = false;
    private static final boolean mDebugLightSensor = false;
    private ContentQueryMap mSettings;
    private WindowManagerPolicy.ScreenOnListener mScreenOnListener = new WindowManagerPolicy.ScreenOnListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScreenOn() {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                if (PowerManagerService.this.mPreparingForScreenOn) {
                    PowerManagerService.this.mPreparingForScreenOn = false;
                    PowerManagerService.this.updateLightsLocked(PowerManagerService.this.mPowerState, 1);
                    EventLog.writeEvent((int)2727, (Object[])new Object[]{4, ((PowerManagerService)PowerManagerService.this).mBroadcastWakeLock.mCount});
                    PowerManagerService.this.mBroadcastWakeLock.release();
                }
            }
        }
    };
    private Runnable mNotificationTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                WindowManagerPolicy policy;
                int why;
                int value;
                LockList lockList = PowerManagerService.this.mLocks;
                synchronized (lockList) {
                    value = PowerManagerService.this.mBroadcastQueue[0];
                    why = PowerManagerService.this.mBroadcastWhy[0];
                    for (int i = 0; i < 2; ++i) {
                        ((PowerManagerService)PowerManagerService.this).mBroadcastQueue[i] = PowerManagerService.this.mBroadcastQueue[i + 1];
                        ((PowerManagerService)PowerManagerService.this).mBroadcastWhy[i] = PowerManagerService.this.mBroadcastWhy[i + 1];
                    }
                    policy = PowerManagerService.this.getPolicyLocked();
                    if (value == 1 && !PowerManagerService.this.mPreparingForScreenOn) {
                        PowerManagerService.this.mPreparingForScreenOn = true;
                        PowerManagerService.this.mBroadcastWakeLock.acquire();
                        EventLog.writeEvent((int)2725, (int)((PowerManagerService)PowerManagerService.this).mBroadcastWakeLock.mCount);
                    }
                }
                if (value == 1) {
                    PowerManagerService.this.mScreenOnStart = SystemClock.uptimeMillis();
                    policy.screenTurningOn(PowerManagerService.this.mScreenOnListener);
                    try {
                        ActivityManagerNative.getDefault().wakingUp();
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    if (PowerManagerService.this.mContext != null && ActivityManagerNative.isSystemReady()) {
                        PowerManagerService.this.mContext.sendOrderedBroadcast(PowerManagerService.this.mScreenOnIntent, null, PowerManagerService.this.mScreenOnBroadcastDone, PowerManagerService.this.mHandler, 0, null, null);
                        continue;
                    }
                    LockList e = PowerManagerService.this.mLocks;
                    synchronized (e) {
                        EventLog.writeEvent((int)2727, (Object[])new Object[]{2, ((PowerManagerService)PowerManagerService.this).mBroadcastWakeLock.mCount});
                        PowerManagerService.this.mBroadcastWakeLock.release();
                    }
                }
                if (value != 0) break;
                PowerManagerService.this.mScreenOffStart = SystemClock.uptimeMillis();
                policy.screenTurnedOff(why);
                try {
                    ActivityManagerNative.getDefault().goingToSleep();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                if (PowerManagerService.this.mContext != null && ActivityManagerNative.isSystemReady()) {
                    PowerManagerService.this.mContext.sendOrderedBroadcast(PowerManagerService.this.mScreenOffIntent, null, PowerManagerService.this.mScreenOffBroadcastDone, PowerManagerService.this.mHandler, 0, null, null);
                    continue;
                }
                lockList = PowerManagerService.this.mLocks;
                synchronized (lockList) {
                    EventLog.writeEvent((int)2727, (Object[])new Object[]{3, ((PowerManagerService)PowerManagerService.this).mBroadcastWakeLock.mCount});
                    PowerManagerService.this.updateLightsLocked(PowerManagerService.this.mPowerState, 1);
                    PowerManagerService.this.mBroadcastWakeLock.release();
                }
            }
        }
    };
    long mScreenOnStart;
    private BroadcastReceiver mScreenOnBroadcastDone = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                EventLog.writeEvent((int)2726, (Object[])new Object[]{1, SystemClock.uptimeMillis() - PowerManagerService.this.mScreenOnStart, ((PowerManagerService)PowerManagerService.this).mBroadcastWakeLock.mCount});
                PowerManagerService.this.mBroadcastWakeLock.release();
            }
        }
    };
    long mScreenOffStart;
    private BroadcastReceiver mScreenOffBroadcastDone = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                EventLog.writeEvent((int)2726, (Object[])new Object[]{0, SystemClock.uptimeMillis() - PowerManagerService.this.mScreenOffStart, ((PowerManagerService)PowerManagerService.this).mBroadcastWakeLock.mCount});
                PowerManagerService.this.mBroadcastWakeLock.release();
            }
        }
    };
    private Runnable mForceReenableScreenTask = new Runnable(){

        public void run() {
            PowerManagerService.this.forceReenableScreen();
        }
    };
    private Runnable mProximityTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                if (PowerManagerService.this.mProximityPendingValue != -1) {
                    PowerManagerService.this.proximityChangedLocked(PowerManagerService.this.mProximityPendingValue == 1);
                    PowerManagerService.this.mProximityPendingValue = -1;
                }
                if (PowerManagerService.this.mProximityPartialLock.isHeld()) {
                    PowerManagerService.this.mProximityPartialLock.release();
                }
            }
        }
    };
    private Runnable mAutoBrightnessTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                if (PowerManagerService.this.mLightSensorPendingDecrease || PowerManagerService.this.mLightSensorPendingIncrease) {
                    int value = (int)PowerManagerService.this.mLightSensorPendingValue;
                    PowerManagerService.this.mLightSensorPendingDecrease = false;
                    PowerManagerService.this.mLightSensorPendingIncrease = false;
                    PowerManagerService.this.lightSensorChangedLocked(value);
                }
            }
        }
    };
    SensorEventListener mProximityListener = new SensorEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSensorChanged(SensorEvent event) {
            long milliseconds = SystemClock.elapsedRealtime();
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                boolean active;
                float distance = event.values[0];
                long timeSinceLastEvent = milliseconds - PowerManagerService.this.mLastProximityEventTime;
                PowerManagerService.this.mLastProximityEventTime = milliseconds;
                PowerManagerService.this.mHandler.removeCallbacks(PowerManagerService.this.mProximityTask);
                boolean proximityTaskQueued = false;
                boolean bl = active = (double)distance >= 0.0 && distance < 5.0f && distance < PowerManagerService.this.mProximitySensor.getMaximumRange();
                if (timeSinceLastEvent < 1000L) {
                    PowerManagerService.this.mProximityPendingValue = active ? 1 : 0;
                    PowerManagerService.this.mHandler.postDelayed(PowerManagerService.this.mProximityTask, 1000L - timeSinceLastEvent);
                    proximityTaskQueued = true;
                } else {
                    PowerManagerService.this.mProximityPendingValue = -1;
                    PowerManagerService.this.proximityChangedLocked(active);
                }
                boolean held = PowerManagerService.this.mProximityPartialLock.isHeld();
                if (!held && proximityTaskQueued) {
                    PowerManagerService.this.mProximityPartialLock.acquire();
                } else if (held && !proximityTaskQueued) {
                    PowerManagerService.this.mProximityPartialLock.release();
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };
    SensorEventListener mLightListener = new SensorEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSensorChanged(SensorEvent event) {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                if (PowerManagerService.this.isScreenTurningOffLocked()) {
                    return;
                }
                int value = (int)event.values[0];
                long milliseconds = SystemClock.elapsedRealtime();
                if (PowerManagerService.this.mLightSensorValue == -1.0f || milliseconds < PowerManagerService.this.mLastScreenOnTime + (long)PowerManagerService.this.mLightSensorWarmupTime) {
                    PowerManagerService.this.mHandler.removeCallbacks(PowerManagerService.this.mAutoBrightnessTask);
                    PowerManagerService.this.mLightSensorPendingDecrease = false;
                    PowerManagerService.this.mLightSensorPendingIncrease = false;
                    PowerManagerService.this.lightSensorChangedLocked(value);
                } else if ((float)value > PowerManagerService.this.mLightSensorValue && PowerManagerService.this.mLightSensorPendingDecrease || (float)value < PowerManagerService.this.mLightSensorValue && PowerManagerService.this.mLightSensorPendingIncrease || (float)value == PowerManagerService.this.mLightSensorValue || !PowerManagerService.this.mLightSensorPendingDecrease && !PowerManagerService.this.mLightSensorPendingIncrease) {
                    PowerManagerService.this.mHandler.removeCallbacks(PowerManagerService.this.mAutoBrightnessTask);
                    PowerManagerService.this.mLightSensorPendingDecrease = (float)value < PowerManagerService.this.mLightSensorValue;
                    PowerManagerService.this.mLightSensorPendingIncrease = (float)value > PowerManagerService.this.mLightSensorValue;
                    if (PowerManagerService.this.mLightSensorPendingDecrease || PowerManagerService.this.mLightSensorPendingIncrease) {
                        PowerManagerService.this.mLightSensorPendingValue = value;
                        PowerManagerService.this.mHandler.postDelayed(PowerManagerService.this.mAutoBrightnessTask, 2000L);
                    }
                } else {
                    PowerManagerService.this.mLightSensorPendingValue = value;
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    private native void nativeInit();

    private native void nativeSetPowerState(boolean var1, boolean var2);

    private native void nativeStartSurfaceFlingerAnimation(int var1);

    public void setStayOnSetting(int val) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SETTINGS", null);
        Settings.System.putInt((ContentResolver)this.mContext.getContentResolver(), (String)"stay_on_while_plugged_in", (int)val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumScreenOffTimeount(int timeMs) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", null);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            this.mMaximumScreenOffTimeout = timeMs;
            this.setScreenOffTimeoutsLocked();
        }
    }

    PowerManagerService() {
        long token = Binder.clearCallingIdentity();
        this.MY_UID = Process.myUid();
        this.MY_PID = Process.myPid();
        Binder.restoreCallingIdentity((long)token);
        Power.setLastUserActivityTimeout((long)604800000L);
        this.mPowerState = 0;
        this.mUserState = 0;
        Watchdog.getInstance().addMonitor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Context context, LightsService lights, IActivityManager activity, BatteryService battery) {
        this.mLightsService = lights;
        this.mContext = context;
        this.mActivityService = activity;
        this.mBatteryStats = BatteryStatsService.getService();
        this.mBatteryService = battery;
        this.mLcdLight = lights.getLight(0);
        this.mButtonLight = lights.getLight(2);
        this.mKeyboardLight = lights.getLight(1);
        this.mAttentionLight = lights.getLight(5);
        this.nativeInit();
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            this.updateNativePowerStateLocked();
        }
        this.mInitComplete = false;
        this.mScreenOffThread = new HandlerThread("PowerManagerService.mScreenOffThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onLooperPrepared() {
                PowerManagerService.this.mScreenOffHandler = new Handler();
                HandlerThread handlerThread = PowerManagerService.this.mScreenOffThread;
                synchronized (handlerThread) {
                    PowerManagerService.this.mInitComplete = true;
                    PowerManagerService.this.mScreenOffThread.notifyAll();
                }
            }
        };
        this.mScreenOffThread.start();
        lockList = this.mScreenOffThread;
        synchronized (lockList) {
            while (!this.mInitComplete) {
                try {
                    this.mScreenOffThread.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        this.mInitComplete = false;
        this.mHandlerThread = new HandlerThread("PowerManagerService"){

            protected void onLooperPrepared() {
                super.onLooperPrepared();
                PowerManagerService.this.initInThread();
            }
        };
        this.mHandlerThread.start();
        lockList = this.mHandlerThread;
        synchronized (lockList) {
            while (!this.mInitComplete) {
                try {
                    this.mHandlerThread.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        this.nativeInit();
        lockList = this.mLocks;
        synchronized (lockList) {
            this.updateNativePowerStateLocked();
            this.forceUserActivityLocked();
            this.mInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initInThread() {
        this.mHandler = new Handler();
        this.mBroadcastWakeLock = new UnsynchronizedWakeLock(1, "sleep_broadcast", true);
        this.mStayOnWhilePluggedInScreenDimLock = new UnsynchronizedWakeLock(6, "StayOnWhilePluggedIn Screen Dim", false);
        this.mStayOnWhilePluggedInPartialLock = new UnsynchronizedWakeLock(1, "StayOnWhilePluggedIn Partial", false);
        this.mPreventScreenOnPartialLock = new UnsynchronizedWakeLock(1, "PreventScreenOn Partial", false);
        this.mProximityPartialLock = new UnsynchronizedWakeLock(1, "Proximity Partial", false);
        this.mScreenOnIntent = new Intent("android.intent.action.SCREEN_ON");
        this.mScreenOnIntent.addFlags(0x40000000);
        this.mScreenOffIntent = new Intent("android.intent.action.SCREEN_OFF");
        this.mScreenOffIntent.addFlags(0x40000000);
        Resources resources = this.mContext.getResources();
        this.mAnimateScreenLights = resources.getBoolean(0x1110012);
        this.mUnplugTurnsOnScreen = resources.getBoolean(0x1110011);
        this.mScreenBrightnessDim = resources.getInteger(0x10E001E);
        this.mUseSoftwareAutoBrightness = resources.getBoolean(0x111000F);
        if (this.mUseSoftwareAutoBrightness) {
            this.mAutoBrightnessLevels = resources.getIntArray(17236005);
            this.mLcdBacklightValues = resources.getIntArray(17236006);
            this.mButtonBacklightValues = resources.getIntArray(17236007);
            this.mKeyboardBacklightValues = resources.getIntArray(17236008);
            this.mLightSensorWarmupTime = resources.getInteger(17694751);
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        Cursor settingsCursor = resolver.query(Settings.System.CONTENT_URI, null, "(name=?) or (name=?) or (name=?) or (name=?) or (name=?) or (name=?)", new String[]{"stay_on_while_plugged_in", "screen_off_timeout", "dim_screen", "screen_brightness_mode", "window_animation_scale", "transition_animation_scale"}, null);
        this.mSettings = new ContentQueryMap(settingsCursor, "name", true, this.mHandler);
        SettingsObserver settingsObserver = new SettingsObserver();
        this.mSettings.addObserver((Observer)settingsObserver);
        settingsObserver.update((Observable)this.mSettings, null);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BATTERY_CHANGED");
        this.mContext.registerReceiver((BroadcastReceiver)new BatteryReceiver(), filter);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.BOOT_COMPLETED");
        this.mContext.registerReceiver((BroadcastReceiver)new BootCompletedReceiver(), filter);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.DOCK_EVENT");
        this.mContext.registerReceiver((BroadcastReceiver)new DockReceiver(), filter);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.CONTENT_URI, true, new ContentObserver(new Handler()){

            public void onChange(boolean selfChange) {
                PowerManagerService.this.updateSettingsValues();
            }
        });
        this.updateSettingsValues();
        HandlerThread handlerThread = this.mHandlerThread;
        synchronized (handlerThread) {
            this.mInitComplete = true;
            this.mHandlerThread.notifyAll();
        }
    }

    private void updateWakeLockLocked() {
        if (this.mStayOnConditions != 0 && this.mBatteryService.isPowered(this.mStayOnConditions)) {
            this.mStayOnWhilePluggedInScreenDimLock.acquire();
            this.mStayOnWhilePluggedInPartialLock.acquire();
        } else {
            this.mStayOnWhilePluggedInScreenDimLock.release();
            this.mStayOnWhilePluggedInPartialLock.release();
        }
    }

    private boolean isScreenLock(int flags) {
        int n = flags & 0x3F;
        return n == 26 || n == 10 || n == 6 || n == 32;
    }

    void enforceWakeSourcePermission(int uid, int pid) {
        if (uid == Process.myUid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_DEVICE_STATS", pid, uid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWakeLock(int flags, IBinder lock, String tag, WorkSource ws) {
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        if (uid != Process.myUid()) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        }
        if (ws != null) {
            this.enforceWakeSourcePermission(uid, pid);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            LockList lockList = this.mLocks;
            synchronized (lockList) {
                this.acquireWakeLockLocked(flags, lock, uid, pid, tag, ws);
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteStartWakeLocked(WakeLock wl, WorkSource ws) {
        if (wl.monitorType >= 0) {
            long origId = Binder.clearCallingIdentity();
            try {
                if (ws != null) {
                    this.mBatteryStats.noteStartWakelockFromSource(ws, wl.pid, wl.tag, wl.monitorType);
                } else {
                    this.mBatteryStats.noteStartWakelock(wl.uid, wl.pid, wl.tag, wl.monitorType);
                }
            }
            catch (RemoteException e) {
            }
            finally {
                Binder.restoreCallingIdentity((long)origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteStopWakeLocked(WakeLock wl, WorkSource ws) {
        if (wl.monitorType >= 0) {
            long origId = Binder.clearCallingIdentity();
            try {
                if (ws != null) {
                    this.mBatteryStats.noteStopWakelockFromSource(ws, wl.pid, wl.tag, wl.monitorType);
                } else {
                    this.mBatteryStats.noteStopWakelock(wl.uid, wl.pid, wl.tag, wl.monitorType);
                }
            }
            catch (RemoteException e) {
            }
            finally {
                Binder.restoreCallingIdentity((long)origId);
            }
        }
    }

    public void acquireWakeLockLocked(int flags, IBinder lock, int uid, int pid, String tag, WorkSource ws) {
        WorkSource oldsource;
        boolean diffsource;
        boolean newlock;
        WakeLock wl;
        int index;
        if (ws != null && ws.size() == 0) {
            ws = null;
        }
        if ((index = this.mLocks.getIndex(lock)) < 0) {
            wl = new WakeLock(flags, lock, tag, uid, pid);
            switch (wl.flags & 0x3F) {
                case 26: {
                    if (this.mUseSoftwareAutoBrightness) {
                        wl.minState = 3;
                        break;
                    }
                    wl.minState = this.mKeyboardVisible ? 15 : 7;
                    break;
                }
                case 10: {
                    wl.minState = 3;
                    break;
                }
                case 6: {
                    wl.minState = 1;
                    break;
                }
                case 1: 
                case 32: {
                    break;
                }
                default: {
                    Slog.e((String)"PowerManagerService", (String)("bad wakelock type for lock '" + tag + "' " + " flags=" + flags));
                    return;
                }
            }
            this.mLocks.addLock(wl);
            if (ws != null) {
                wl.ws = new WorkSource(ws);
            }
            newlock = true;
            diffsource = false;
            oldsource = null;
        } else {
            wl = (WakeLock)this.mLocks.get(index);
            newlock = false;
            oldsource = wl.ws;
            if (oldsource != null) {
                if (ws == null) {
                    wl.ws = null;
                    diffsource = true;
                } else {
                    diffsource = oldsource.diff(ws);
                }
            } else {
                diffsource = ws != null;
            }
            if (diffsource) {
                wl.ws = new WorkSource(ws);
            }
        }
        if (this.isScreenLock(flags)) {
            if ((flags & 0x3F) == 32) {
                ++this.mProximityWakeLockCount;
                if (this.mProximityWakeLockCount == 1) {
                    this.enableProximityLockLocked();
                }
            } else {
                if ((wl.flags & 0x10000000) != 0) {
                    int oldWakeLockState = this.mWakeLockState;
                    this.mWakeLockState = this.mLocks.reactivateScreenLocksLocked();
                    if ((this.mWakeLockState & 1) != 0 && this.mProximitySensorActive && this.mProximityWakeLockCount == 0) {
                        this.mProximitySensorActive = false;
                    }
                } else {
                    this.mWakeLockState = (this.mUserState | this.mWakeLockState) & this.mLocks.gatherState();
                }
                this.setPowerState(this.mWakeLockState | this.mUserState);
            }
        } else if ((flags & 0x3F) == 1) {
            if (newlock) {
                ++this.mPartialCount;
                if (this.mPartialCount == 1) {
                    // empty if block
                }
            }
            Power.acquireWakeLock((int)1, (String)"PowerManagerService");
        }
        if (diffsource) {
            this.noteStopWakeLocked(wl, oldsource);
        }
        if (newlock || diffsource) {
            this.noteStartWakeLocked(wl, ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWakeLockWorkSource(IBinder lock, WorkSource ws) {
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        if (ws != null && ws.size() == 0) {
            ws = null;
        }
        if (ws != null) {
            this.enforceWakeSourcePermission(uid, pid);
        }
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            int index = this.mLocks.getIndex(lock);
            if (index < 0) {
                throw new IllegalArgumentException("Wake lock not active");
            }
            WakeLock wl = (WakeLock)this.mLocks.get(index);
            WorkSource oldsource = wl.ws;
            wl.ws = ws != null ? new WorkSource(ws) : null;
            this.noteStopWakeLocked(wl, oldsource);
            this.noteStartWakeLocked(wl, ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWakeLock(IBinder lock, int flags) {
        int uid = Binder.getCallingUid();
        if (uid != Process.myUid()) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        }
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            this.releaseWakeLockLocked(lock, flags, false);
        }
    }

    private void releaseWakeLockLocked(IBinder lock, int flags, boolean death) {
        WakeLock wl = this.mLocks.removeLock(lock);
        if (wl == null) {
            return;
        }
        if (this.isScreenLock(wl.flags)) {
            if ((wl.flags & 0x3F) == 32) {
                --this.mProximityWakeLockCount;
                if (!(this.mProximityWakeLockCount != 0 || this.mProximitySensorActive && (flags & 1) != 0)) {
                    this.disableProximityLockLocked();
                }
            } else {
                this.mWakeLockState = this.mLocks.gatherState();
                if ((wl.flags & 0x20000000) != 0) {
                    this.userActivity(SystemClock.uptimeMillis(), -1L, false, 0, false);
                }
                this.setPowerState(this.mWakeLockState | this.mUserState);
            }
        } else if ((wl.flags & 0x3F) == 1) {
            --this.mPartialCount;
            if (this.mPartialCount == 0) {
                Power.releaseWakeLock((String)"PowerManagerService");
            }
        }
        wl.binder.unlinkToDeath((IBinder.DeathRecipient)wl, 0);
        this.noteStopWakeLocked(wl, wl.ws);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPokeLock(int pokey, IBinder token, String tag) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        if (token == null) {
            Slog.e((String)"PowerManagerService", (String)("setPokeLock got null token for tag='" + tag + "'"));
            return;
        }
        if ((pokey & 6) == 6) {
            throw new IllegalArgumentException("setPokeLock can't have both POKE_LOCK_SHORT_TIMEOUT and POKE_LOCK_MEDIUM_TIMEOUT");
        }
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            if (pokey != 0) {
                PokeLock p = this.mPokeLocks.get(token);
                int oldPokey = 0;
                if (p != null) {
                    oldPokey = p.pokey;
                    p.pokey = pokey;
                } else {
                    p = new PokeLock(pokey, token, tag);
                    this.mPokeLocks.put(token, p);
                }
                int oldTimeout = oldPokey & 6;
                int newTimeout = pokey & 6;
                if ((this.mPowerState & 1) == 0 && oldTimeout != newTimeout) {
                    p.awakeOnSet = true;
                }
            } else {
                PokeLock rLock = this.mPokeLocks.remove(token);
                if (rLock != null) {
                    token.unlinkToDeath((IBinder.DeathRecipient)rLock, 0);
                }
            }
            int oldPokey = this.mPokey;
            int cumulative = 0;
            boolean oldAwakeOnSet = this.mPokeAwakeOnSet;
            boolean awakeOnSet = false;
            for (PokeLock p : this.mPokeLocks.values()) {
                cumulative |= p.pokey;
                if (!p.awakeOnSet) continue;
                awakeOnSet = true;
            }
            this.mPokey = cumulative;
            this.mPokeAwakeOnSet = awakeOnSet;
            int oldCumulativeTimeout = oldPokey & 6;
            int newCumulativeTimeout = pokey & 6;
            if (oldCumulativeTimeout != newCumulativeTimeout) {
                this.setScreenOffTimeoutsLocked();
                this.setTimeoutLocked(SystemClock.uptimeMillis(), this.mTimeoutTask.nextState);
            }
        }
    }

    private static String lockType(int type) {
        switch (type) {
            case 26: {
                return "FULL_WAKE_LOCK                ";
            }
            case 10: {
                return "SCREEN_BRIGHT_WAKE_LOCK       ";
            }
            case 6: {
                return "SCREEN_DIM_WAKE_LOCK          ";
            }
            case 1: {
                return "PARTIAL_WAKE_LOCK             ";
            }
            case 32: {
                return "PROXIMITY_SCREEN_OFF_WAKE_LOCK";
            }
        }
        return "???                           ";
    }

    private static String dumpPowerState(int state) {
        return ((state & 8) != 0 ? "KEYBOARD_BRIGHT_BIT " : "") + ((state & 2) != 0 ? "SCREEN_BRIGHT_BIT " : "") + ((state & 1) != 0 ? "SCREEN_ON_BIT " : "") + ((state & 0x10) != 0 ? "BATTERY_LOW_BIT " : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump PowerManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        long now = SystemClock.uptimeMillis();
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            pw.println("Power Manager State:");
            pw.println("  mIsPowered=" + this.mIsPowered + " mPowerState=" + this.mPowerState + " mScreenOffTime=" + (SystemClock.elapsedRealtime() - this.mScreenOffTime) + " ms");
            pw.println("  mPartialCount=" + this.mPartialCount);
            pw.println("  mWakeLockState=" + PowerManagerService.dumpPowerState(this.mWakeLockState));
            pw.println("  mUserState=" + PowerManagerService.dumpPowerState(this.mUserState));
            pw.println("  mPowerState=" + PowerManagerService.dumpPowerState(this.mPowerState));
            pw.println("  mLocks.gather=" + PowerManagerService.dumpPowerState(this.mLocks.gatherState()));
            pw.println("  mNextTimeout=" + this.mNextTimeout + " now=" + now + " " + (this.mNextTimeout - now) / 1000L + "s from now");
            pw.println("  mDimScreen=" + this.mDimScreen + " mStayOnConditions=" + this.mStayOnConditions + " mPreparingForScreenOn=" + this.mPreparingForScreenOn + " mSkippedScreenOn=" + this.mSkippedScreenOn);
            pw.println("  mScreenOffReason=" + this.mScreenOffReason + " mUserState=" + this.mUserState);
            pw.println("  mBroadcastQueue={" + this.mBroadcastQueue[0] + ',' + this.mBroadcastQueue[1] + ',' + this.mBroadcastQueue[2] + "}");
            pw.println("  mBroadcastWhy={" + this.mBroadcastWhy[0] + ',' + this.mBroadcastWhy[1] + ',' + this.mBroadcastWhy[2] + "}");
            pw.println("  mPokey=" + this.mPokey + " mPokeAwakeonSet=" + this.mPokeAwakeOnSet);
            pw.println("  mKeyboardVisible=" + this.mKeyboardVisible + " mUserActivityAllowed=" + this.mUserActivityAllowed);
            pw.println("  mKeylightDelay=" + this.mKeylightDelay + " mDimDelay=" + this.mDimDelay + " mScreenOffDelay=" + this.mScreenOffDelay);
            pw.println("  mPreventScreenOn=" + this.mPreventScreenOn + "  mScreenBrightnessOverride=" + this.mScreenBrightnessOverride + "  mButtonBrightnessOverride=" + this.mButtonBrightnessOverride);
            pw.println("  mScreenOffTimeoutSetting=" + this.mScreenOffTimeoutSetting + " mMaximumScreenOffTimeout=" + this.mMaximumScreenOffTimeout);
            pw.println("  mLastScreenOnTime=" + this.mLastScreenOnTime);
            pw.println("  mBroadcastWakeLock=" + this.mBroadcastWakeLock);
            pw.println("  mStayOnWhilePluggedInScreenDimLock=" + this.mStayOnWhilePluggedInScreenDimLock);
            pw.println("  mStayOnWhilePluggedInPartialLock=" + this.mStayOnWhilePluggedInPartialLock);
            pw.println("  mPreventScreenOnPartialLock=" + this.mPreventScreenOnPartialLock);
            pw.println("  mProximityPartialLock=" + this.mProximityPartialLock);
            pw.println("  mProximityWakeLockCount=" + this.mProximityWakeLockCount);
            pw.println("  mProximitySensorEnabled=" + this.mProximitySensorEnabled);
            pw.println("  mProximitySensorActive=" + this.mProximitySensorActive);
            pw.println("  mProximityPendingValue=" + this.mProximityPendingValue);
            pw.println("  mLastProximityEventTime=" + this.mLastProximityEventTime);
            pw.println("  mLightSensorEnabled=" + this.mLightSensorEnabled);
            pw.println("  mLightSensorValue=" + this.mLightSensorValue + " mLightSensorPendingValue=" + this.mLightSensorPendingValue);
            pw.println("  mLightSensorPendingDecrease=" + this.mLightSensorPendingDecrease + " mLightSensorPendingIncrease=" + this.mLightSensorPendingIncrease);
            pw.println("  mLightSensorScreenBrightness=" + this.mLightSensorScreenBrightness + " mLightSensorButtonBrightness=" + this.mLightSensorButtonBrightness + " mLightSensorKeyboardBrightness=" + this.mLightSensorKeyboardBrightness);
            pw.println("  mUseSoftwareAutoBrightness=" + this.mUseSoftwareAutoBrightness);
            pw.println("  mAutoBrightessEnabled=" + this.mAutoBrightessEnabled);
            this.mScreenBrightness.dump(pw, "  mScreenBrightness: ");
            int N = this.mLocks.size();
            pw.println();
            pw.println("mLocks.size=" + N + ":");
            for (int i = 0; i < N; ++i) {
                WakeLock wl = (WakeLock)this.mLocks.get(i);
                String type = PowerManagerService.lockType(wl.flags & 0x3F);
                String acquireCausesWakeup = "";
                if ((wl.flags & 0x10000000) != 0) {
                    acquireCausesWakeup = "ACQUIRE_CAUSES_WAKEUP ";
                }
                String activated = "";
                if (wl.activated) {
                    activated = " activated";
                }
                pw.println("  " + type + " '" + wl.tag + "'" + acquireCausesWakeup + activated + " (minState=" + wl.minState + ", uid=" + wl.uid + ", pid=" + wl.pid + ")");
            }
            pw.println();
            pw.println("mPokeLocks.size=" + this.mPokeLocks.size() + ":");
            for (PokeLock p : this.mPokeLocks.values()) {
                pw.println("    poke lock '" + p.tag + "':" + ((p.pokey & 1) != 0 ? " POKE_LOCK_IGNORE_TOUCH_EVENTS" : "") + ((p.pokey & 2) != 0 ? " POKE_LOCK_SHORT_TIMEOUT" : "") + ((p.pokey & 4) != 0 ? " POKE_LOCK_MEDIUM_TIMEOUT" : ""));
            }
            pw.println();
        }
    }

    private void setTimeoutLocked(long now, int nextState) {
        this.setTimeoutLocked(now, -1L, nextState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void setTimeoutLocked(long now, long originalTimeoutOverride, int nextState) {
        block14: {
            timeoutOverride = originalTimeoutOverride;
            if (!this.mBootCompleted) break block14;
            var8_5 = this.mLocks;
            synchronized (var8_5) {
                block16: {
                    block17: {
                        block15: {
                            when = 0L;
                            if (timeoutOverride > 0L) break block15;
                            switch (nextState) {
                                case 3: {
                                    when = now + (long)this.mKeylightDelay;
                                    break;
                                }
                                case 1: {
                                    if (this.mDimDelay >= 0) {
                                        when = now + (long)this.mDimDelay;
                                        break;
                                    }
                                    Slog.w((String)"PowerManagerService", (String)("mDimDelay=" + this.mDimDelay + " while trying to dim"));
                                }
                                case 0: {
                                    var11_7 = this.mLocks;
                                    synchronized (var11_7) {
                                        when = now + (long)this.mScreenOffDelay;
                                        break;
                                    }
                                }
                                default: {
                                    when = now;
                                    break;
                                }
                            }
                            break block16;
                        }
                        if (timeoutOverride > (long)this.mScreenOffDelay) break block17;
                        when = now + timeoutOverride;
                        nextState = 0;
                        break block16;
                    }
                    timeoutOverride -= (long)this.mScreenOffDelay;
                    if (this.mDimDelay < 0) ** GOTO lbl43
                    if (timeoutOverride <= (long)this.mDimDelay) {
                        when = now + timeoutOverride;
                        nextState = 1;
                    } else {
                        timeoutOverride -= (long)this.mDimDelay;
lbl43:
                        // 2 sources

                        when = now + timeoutOverride;
                        nextState = 3;
                    }
                }
                this.mHandler.removeCallbacks((Runnable)this.mTimeoutTask);
                this.mTimeoutTask.nextState = nextState;
                this.mTimeoutTask.remainingTimeoutOverride = timeoutOverride > 0L ? originalTimeoutOverride - timeoutOverride : -1L;
                this.mHandler.postAtTime((Runnable)this.mTimeoutTask, when);
                this.mNextTimeout = when;
            }
        }
    }

    private void cancelTimerLocked() {
        this.mHandler.removeCallbacks((Runnable)this.mTimeoutTask);
        this.mTimeoutTask.nextState = -1;
    }

    private void sendNotificationLocked(boolean on, int why) {
        if (!this.mInitialized) {
            return;
        }
        if (!on) {
            this.mStillNeedSleepNotification = false;
        }
        int index = 0;
        while (this.mBroadcastQueue[index] != -1) {
            ++index;
        }
        this.mBroadcastQueue[index] = on ? 1 : 0;
        this.mBroadcastWhy[index] = why;
        if (index == 2) {
            if (!on && this.mBroadcastWhy[0] > why) {
                this.mBroadcastWhy[0] = why;
            }
            this.mBroadcastQueue[0] = on ? 1 : 0;
            this.mBroadcastQueue[1] = -1;
            this.mBroadcastQueue[2] = -1;
            EventLog.writeEvent((int)2727, (Object[])new Object[]{1, this.mBroadcastWakeLock.mCount});
            this.mBroadcastWakeLock.release();
            EventLog.writeEvent((int)2727, (Object[])new Object[]{1, this.mBroadcastWakeLock.mCount});
            this.mBroadcastWakeLock.release();
            index = 0;
        }
        if (index == 1 && !on) {
            this.mBroadcastQueue[0] = -1;
            this.mBroadcastQueue[1] = -1;
            index = -1;
            EventLog.writeEvent((int)2727, (Object[])new Object[]{1, this.mBroadcastWakeLock.mCount});
            this.mBroadcastWakeLock.release();
        }
        if (this.mSkippedScreenOn) {
            this.updateLightsLocked(this.mPowerState, 1);
        }
        if (index >= 0) {
            this.mBroadcastWakeLock.acquire();
            EventLog.writeEvent((int)2725, (int)this.mBroadcastWakeLock.mCount);
            this.mHandler.post(this.mNotificationTask);
        }
    }

    void logPointerUpEvent() {
        this.mTotalTouchDownTime += SystemClock.elapsedRealtime() - this.mLastTouchDown;
        this.mLastTouchDown = 0L;
    }

    void logPointerDownEvent() {
        if (this.mLastTouchDown == 0L) {
            this.mLastTouchDown = SystemClock.elapsedRealtime();
            ++this.mTouchCycles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preventScreenOn(boolean prevent) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            if (prevent) {
                this.mPreventScreenOnPartialLock.acquire();
                this.mHandler.removeCallbacks(this.mForceReenableScreenTask);
                this.mHandler.postDelayed(this.mForceReenableScreenTask, 5000L);
                this.mPreventScreenOn = true;
            } else {
                int err;
                this.mPreventScreenOn = false;
                this.mHandler.removeCallbacks(this.mForceReenableScreenTask);
                if (!this.mProximitySensorActive && (this.mPowerState & 1) != 0 && (err = this.setScreenStateLocked(true)) != 0) {
                    Slog.w((String)"PowerManagerService", (String)("preventScreenOn: error from setScreenStateLocked(): " + err));
                }
                this.mPreventScreenOnPartialLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenBrightnessOverride(int brightness) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            if (this.mScreenBrightnessOverride != brightness) {
                this.mScreenBrightnessOverride = brightness;
                if (this.isScreenOn()) {
                    this.updateLightsLocked(this.mPowerState, 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setButtonBrightnessOverride(int brightness) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            if (this.mButtonBrightnessOverride != brightness) {
                this.mButtonBrightnessOverride = brightness;
                if (this.isScreenOn()) {
                    this.updateLightsLocked(this.mPowerState, 12);
                }
            }
        }
    }

    private void forceReenableScreen() {
        if (!this.mPreventScreenOn) {
            Slog.w((String)"PowerManagerService", (String)"forceReenableScreen: mPreventScreenOn is false, nothing to do");
            return;
        }
        Slog.w((String)"PowerManagerService", (String)"App called preventScreenOn(true) but didn't promptly reenable the screen! Forcing the screen back on...");
        this.preventScreenOn(false);
    }

    private int setScreenStateLocked(boolean on) {
        int err;
        if (on && ((this.mPowerState & 1) == 0 || this.mSkippedScreenOn)) {
            this.mScreenBrightness.forceValueLocked(0);
        }
        if ((err = Power.setScreenState((boolean)on)) == 0) {
            long l = this.mLastScreenOnTime = on ? SystemClock.elapsedRealtime() : 0L;
            if (this.mUseSoftwareAutoBrightness) {
                this.enableLightSensorLocked(on);
                if (!on) {
                    this.mButtonLight.turnOff();
                    this.mKeyboardLight.turnOff();
                    this.mLightSensorValue = -1.0f;
                    this.mHighestLightSensorValue = -1;
                }
            }
        }
        return err;
    }

    private void setPowerState(int state) {
        this.setPowerState(state, false, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPowerState(int newState, boolean noChangeLights, int reason) {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            boolean stateChanged;
            if (noChangeLights) {
                newState = newState & 0xFFFFFFF1 | this.mPowerState & 0xE;
            }
            if (this.mProximitySensorActive) {
                newState &= 0xFFFFFFFC;
            }
            newState = this.batteryIsLow() ? (newState |= 0x10) : (newState &= 0xFFFFFFEF);
            if (newState == this.mPowerState && this.mInitialized) {
                return;
            }
            if (!this.mBootCompleted && !this.mUseSoftwareAutoBrightness) {
                newState |= 0xF;
            }
            boolean oldScreenOn = (this.mPowerState & 1) != 0;
            boolean newScreenOn = (newState & 1) != 0;
            boolean bl = stateChanged = this.mPowerState != newState;
            if (oldScreenOn != newScreenOn) {
                if (newScreenOn) {
                    int err;
                    if (this.mStillNeedSleepNotification) {
                        this.sendNotificationLocked(false, 2);
                    }
                    boolean reallyTurnScreenOn = true;
                    if (this.mPreventScreenOn) {
                        reallyTurnScreenOn = false;
                    }
                    if (reallyTurnScreenOn) {
                        err = this.setScreenStateLocked(true);
                        long identity = Binder.clearCallingIdentity();
                        try {
                            this.mBatteryStats.noteScreenBrightness(this.getPreferredBrightness());
                            this.mBatteryStats.noteScreenOn();
                        }
                        catch (RemoteException e) {
                            Slog.w((String)"PowerManagerService", (String)"RemoteException calling noteScreenOn on BatteryStatsService", (Throwable)e);
                        }
                        finally {
                            Binder.restoreCallingIdentity((long)identity);
                        }
                    } else {
                        this.setScreenStateLocked(false);
                        err = 0;
                    }
                    this.mLastTouchDown = 0L;
                    this.mTotalTouchDownTime = 0L;
                    this.mTouchCycles = 0;
                    EventLog.writeEvent((int)2728, (Object[])new Object[]{1, reason, this.mTotalTouchDownTime, this.mTouchCycles});
                    if (err == 0) {
                        this.sendNotificationLocked(true, -1);
                        if (stateChanged) {
                            this.updateLightsLocked(newState, 0);
                        }
                        this.mPowerState |= 1;
                    }
                } else {
                    if (stateChanged) {
                        this.updateLightsLocked(newState, 0);
                    }
                    this.mHandler.removeCallbacks(this.mAutoBrightnessTask);
                    this.mLightSensorPendingDecrease = false;
                    this.mLightSensorPendingIncrease = false;
                    this.mScreenOffTime = SystemClock.elapsedRealtime();
                    long identity = Binder.clearCallingIdentity();
                    try {
                        this.mBatteryStats.noteScreenOff();
                    }
                    catch (RemoteException e) {
                        Slog.w((String)"PowerManagerService", (String)"RemoteException calling noteScreenOff on BatteryStatsService", (Throwable)e);
                    }
                    finally {
                        Binder.restoreCallingIdentity((long)identity);
                    }
                    this.mPowerState &= 0xFFFFFFFE;
                    this.mScreenOffReason = reason;
                    if (!this.mScreenBrightness.animating) {
                        int err = this.screenOffFinishedAnimatingLocked(reason);
                    } else {
                        boolean err = false;
                        this.mLastTouchDown = 0L;
                    }
                }
            } else if (stateChanged) {
                this.updateLightsLocked(newState, 0);
            }
            this.mPowerState = this.mPowerState & 0xFFFFFFF1 | newState & 0xE;
            this.updateNativePowerStateLocked();
        }
    }

    private void updateNativePowerStateLocked() {
        this.nativeSetPowerState((this.mPowerState & 1) != 0, (this.mPowerState & 3) == 3);
    }

    private int screenOffFinishedAnimatingLocked(int reason) {
        EventLog.writeEvent((int)2728, (Object[])new Object[]{0, reason, this.mTotalTouchDownTime, this.mTouchCycles});
        this.mLastTouchDown = 0L;
        int err = this.setScreenStateLocked(false);
        if (err == 0) {
            this.mScreenOffReason = reason;
            this.sendNotificationLocked(false, reason);
        }
        return err;
    }

    private boolean batteryIsLow() {
        return !this.mIsPowered && this.mBatteryService.getBatteryLevel() <= 10;
    }

    private boolean shouldDeferScreenOnLocked() {
        if (this.mPreparingForScreenOn) {
            return true;
        }
        for (int i = 0; i < this.mBroadcastQueue.length; ++i) {
            if (this.mBroadcastQueue[i] != 1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLightsLocked(int newState, int forceState) {
        int brightness;
        int realDifference;
        int difference;
        int oldState = this.mPowerState;
        if (((oldState & 1) == 0 || this.mSkippedScreenOn) && (this.mSkippedScreenOn = this.shouldDeferScreenOnLocked())) {
            newState &= 0xFFFFFFFC;
        }
        if ((newState & 1) != 0) {
            newState = this.applyButtonState(newState);
            newState = this.applyKeyboardState(newState);
        }
        if ((difference = (realDifference = newState ^ oldState) | forceState) == 0) {
            return;
        }
        int offMask = 0;
        int dimMask = 0;
        int onMask = 0;
        int preferredBrightness = this.getPreferredBrightness();
        if ((difference & 8) != 0) {
            if ((newState & 8) == 0) {
                offMask |= 8;
            } else {
                onMask |= 8;
            }
        }
        if ((difference & 4) != 0) {
            if ((newState & 4) == 0) {
                offMask |= 4;
            } else {
                onMask |= 4;
            }
        }
        if ((difference & 3) != 0) {
            int nominalCurrentValue = -1;
            if ((realDifference & 3) != 0) {
                switch (oldState & 3) {
                    case 3: {
                        nominalCurrentValue = preferredBrightness;
                        break;
                    }
                    case 1: {
                        nominalCurrentValue = this.mScreenBrightnessDim;
                        break;
                    }
                    case 0: {
                        nominalCurrentValue = 0;
                        break;
                    }
                    default: {
                        nominalCurrentValue = (int)this.mScreenBrightness.curValue;
                    }
                }
            }
            int brightness2 = preferredBrightness;
            int steps = 15;
            if ((newState & 2) == 0) {
                float scale = 1.5f;
                float ratio = (float)this.mScreenBrightnessDim / (float)preferredBrightness;
                if (ratio > 1.0f) {
                    ratio = 1.0f;
                }
                if ((newState & 1) == 0) {
                    steps = (oldState & 2) != 0 ? 15 : (int)(15.0f * ratio * 1.5f);
                    brightness2 = 0;
                } else {
                    steps = (oldState & 1) != 0 ? (int)(15.0f * (1.0f - ratio) * 1.5f) : (int)(15.0f * ratio);
                    if (this.mStayOnConditions != 0 && this.mBatteryService.isPowered(this.mStayOnConditions)) {
                        this.mScreenOffTime = SystemClock.elapsedRealtime();
                    }
                    brightness2 = this.mScreenBrightnessDim;
                }
            }
            long identity = Binder.clearCallingIdentity();
            try {
                this.mBatteryStats.noteScreenBrightness(brightness2);
            }
            catch (RemoteException e) {
            }
            finally {
                Binder.restoreCallingIdentity((long)identity);
            }
            if (!this.mSkippedScreenOn) {
                this.mScreenBrightness.setTargetLocked(brightness2, steps, 255, nominalCurrentValue);
            }
        }
        if (offMask != 0) {
            this.setLightBrightness(offMask, 0);
        }
        if (dimMask != 0) {
            brightness = this.mScreenBrightnessDim;
            if ((newState & 0x10) != 0 && brightness > 10) {
                brightness = 10;
            }
            this.setLightBrightness(dimMask, brightness);
        }
        if (onMask != 0) {
            brightness = this.getPreferredBrightness();
            if ((newState & 0x10) != 0 && brightness > 10) {
                brightness = 10;
            }
            this.setLightBrightness(onMask, brightness);
        }
    }

    private void setLightBrightness(int mask, int value) {
        int brightnessMode;
        int n = brightnessMode = this.mAutoBrightessEnabled ? 1 : 0;
        if ((mask & 2) != 0) {
            this.mLcdLight.setBrightness(value, brightnessMode);
        }
        if ((mask & 4) != 0) {
            this.mButtonLight.setBrightness(value);
        }
        if ((mask & 8) != 0) {
            this.mKeyboardLight.setBrightness(value);
        }
    }

    private int getPreferredBrightness() {
        try {
            if (this.mScreenBrightnessOverride >= 0) {
                return this.mScreenBrightnessOverride;
            }
            if (this.mLightSensorScreenBrightness >= 0 && this.mUseSoftwareAutoBrightness && this.mAutoBrightessEnabled) {
                return this.mLightSensorScreenBrightness;
            }
            int brightness = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"screen_brightness");
            return Math.max(brightness, this.mScreenBrightnessDim);
        }
        catch (Settings.SettingNotFoundException snfe) {
            return 255;
        }
    }

    private int applyButtonState(int state) {
        int brightness = -1;
        if ((state & 0x10) != 0) {
            return state;
        }
        if (this.mButtonBrightnessOverride >= 0) {
            brightness = this.mButtonBrightnessOverride;
        } else if (this.mLightSensorButtonBrightness >= 0 && this.mUseSoftwareAutoBrightness) {
            brightness = this.mLightSensorButtonBrightness;
        }
        if (brightness > 0) {
            return state | 4;
        }
        if (brightness == 0) {
            return state & 0xFFFFFFFB;
        }
        return state;
    }

    private int applyKeyboardState(int state) {
        int brightness = -1;
        if ((state & 0x10) != 0) {
            return state;
        }
        if (!this.mKeyboardVisible) {
            brightness = 0;
        } else if (this.mButtonBrightnessOverride >= 0) {
            brightness = this.mButtonBrightnessOverride;
        } else if (this.mLightSensorKeyboardBrightness >= 0 && this.mUseSoftwareAutoBrightness) {
            brightness = this.mLightSensorKeyboardBrightness;
        }
        if (brightness > 0) {
            return state | 8;
        }
        if (brightness == 0) {
            return state & 0xFFFFFFF7;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScreenOn() {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            return (this.mPowerState & 1) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isScreenBright() {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            return (this.mPowerState & 3) == 3;
        }
    }

    private boolean isScreenTurningOffLocked() {
        return this.mScreenBrightness.animating && this.mScreenBrightness.targetValue == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldLog(long time) {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            if (time > this.mWarningSpewThrottleTime + 3600000L) {
                this.mWarningSpewThrottleTime = time;
                this.mWarningSpewThrottleCount = 0;
                return true;
            }
            if (this.mWarningSpewThrottleCount < 30) {
                ++this.mWarningSpewThrottleCount;
                return true;
            }
            return false;
        }
    }

    private void forceUserActivityLocked() {
        if (this.isScreenTurningOffLocked()) {
            this.mScreenBrightness.animating = false;
        }
        boolean savedActivityAllowed = this.mUserActivityAllowed;
        this.mUserActivityAllowed = true;
        this.userActivity(SystemClock.uptimeMillis(), false);
        this.mUserActivityAllowed = savedActivityAllowed;
    }

    public void userActivityWithForce(long time, boolean noChangeLights, boolean force) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        this.userActivity(time, -1L, noChangeLights, 0, force);
    }

    public void userActivity(long time, boolean noChangeLights) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DEVICE_POWER") != 0) {
            if (this.shouldLog(time)) {
                Slog.w((String)"PowerManagerService", (String)("Caller does not have DEVICE_POWER permission.  pid=" + Binder.getCallingPid() + " uid=" + Binder.getCallingUid()));
            }
            return;
        }
        this.userActivity(time, -1L, noChangeLights, 0, false);
    }

    public void userActivity(long time, boolean noChangeLights, int eventType) {
        this.userActivity(time, -1L, noChangeLights, eventType, false);
    }

    public void userActivity(long time, boolean noChangeLights, int eventType, boolean force) {
        this.userActivity(time, -1L, noChangeLights, eventType, force);
    }

    public void clearUserActivityTimeout(long now, long timeout) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        Slog.i((String)"PowerManagerService", (String)("clearUserActivity for " + timeout + "ms from now"));
        this.userActivity(now, timeout, false, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userActivity(long time, long timeoutOverride, boolean noChangeLights, int eventType, boolean force) {
        if ((this.mPokey & 1) != 0 && eventType == 2) {
            return;
        }
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            if (this.isScreenTurningOffLocked()) {
                Slog.d((String)"PowerManagerService", (String)"ignoring user activity while turning off screen");
                return;
            }
            if (this.mProximitySensorActive && this.mProximityWakeLockCount == 0) {
                this.mProximitySensorActive = false;
            }
            if (this.mLastEventTime <= time || force) {
                this.mLastEventTime = time;
                if (this.mUserActivityAllowed && !this.mProximitySensorActive || force) {
                    this.mUserState = eventType == 1 && !this.mUseSoftwareAutoBrightness ? (this.mKeyboardVisible ? 15 : 7) : (this.mUserState |= 3);
                    int uid = Binder.getCallingUid();
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mBatteryStats.noteUserActivity(uid, eventType);
                    }
                    catch (RemoteException e) {
                    }
                    finally {
                        Binder.restoreCallingIdentity((long)ident);
                    }
                    this.mWakeLockState = this.mLocks.reactivateScreenLocksLocked();
                    this.setPowerState(this.mUserState | this.mWakeLockState, noChangeLights, 2);
                    this.setTimeoutLocked(time, timeoutOverride, 3);
                }
            }
        }
        if (this.mPolicy != null) {
            this.mPolicy.userActivity();
        }
    }

    private int getAutoBrightnessValue(int sensorValue, int[] values) {
        try {
            int i;
            for (i = 0; i < this.mAutoBrightnessLevels.length && sensorValue >= this.mAutoBrightnessLevels[i]; ++i) {
            }
            return values[i];
        }
        catch (Exception e) {
            Slog.e((String)"PowerManagerService", (String)"getAutoBrightnessValue", (Throwable)e);
            return 255;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dockStateChanged(int state) {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            boolean bl = this.mIsDocked = state != 0;
            if (this.mIsDocked) {
                this.mHighestLightSensorValue = -1;
            }
            if ((this.mPowerState & 1) != 0) {
                int value = (int)this.mLightSensorValue;
                this.mLightSensorValue = -1.0f;
                this.lightSensorChangedLocked(value);
            }
        }
    }

    private void lightSensorChangedLocked(int value) {
        if ((this.mPowerState & 1) == 0) {
            return;
        }
        if (this.mHighestLightSensorValue < value) {
            this.mHighestLightSensorValue = value;
        }
        if (this.mLightSensorValue != (float)value) {
            this.mLightSensorValue = value;
            if ((this.mPowerState & 0x10) == 0) {
                int lcdValue = this.getAutoBrightnessValue(this.mIsDocked ? value : this.mHighestLightSensorValue, this.mLcdBacklightValues);
                int buttonValue = this.getAutoBrightnessValue(value, this.mButtonBacklightValues);
                int keyboardValue = this.mKeyboardVisible ? this.getAutoBrightnessValue(value, this.mKeyboardBacklightValues) : 0;
                this.mLightSensorScreenBrightness = lcdValue;
                this.mLightSensorButtonBrightness = buttonValue;
                this.mLightSensorKeyboardBrightness = keyboardValue;
                if (this.mAutoBrightessEnabled && this.mScreenBrightnessOverride < 0 && !this.mSkippedScreenOn) {
                    this.mScreenBrightness.setTargetLocked(lcdValue, 60, 255, (int)this.mScreenBrightness.curValue);
                }
                if (this.mButtonBrightnessOverride < 0) {
                    this.mButtonLight.setBrightness(buttonValue);
                }
                if (this.mButtonBrightnessOverride < 0 || !this.mKeyboardVisible) {
                    this.mKeyboardLight.setBrightness(keyboardValue);
                }
            }
        }
    }

    public void goToSleep(long time) {
        this.goToSleepWithReason(time, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goToSleepWithReason(long time, int reason) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            this.goToSleepLocked(time, reason);
        }
    }

    public void reboot(String reason) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
        if (this.mHandler == null || !ActivityManagerNative.isSystemReady()) {
            throw new IllegalStateException("Too early to call reboot()");
        }
        final String finalReason = reason;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                11 var1_1 = this;
                synchronized (var1_1) {
                    ShutdownThread.reboot((Context)PowerManagerService.this.mContext, (String)finalReason, (boolean)false);
                }
            }
        };
        this.mHandler.post(runnable);
        Runnable runnable2 = runnable;
        synchronized (runnable2) {
            while (true) {
                try {
                    while (true) {
                        runnable.wait();
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
    }

    public void crash(final String message) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
        Thread t = new Thread("PowerManagerService.crash()"){

            public void run() {
                throw new RuntimeException(message);
            }
        };
        try {
            t.start();
            t.join();
        }
        catch (InterruptedException e) {
            Log.wtf((String)"PowerManagerService", (Throwable)e);
        }
    }

    private void goToSleepLocked(long time, int reason) {
        if (this.mLastEventTime <= time) {
            this.mLastEventTime = time;
            this.mWakeLockState = 0;
            int N = this.mLocks.size();
            int numCleared = 0;
            boolean proxLock = false;
            for (int i = 0; i < N; ++i) {
                WakeLock wl = (WakeLock)this.mLocks.get(i);
                if (!this.isScreenLock(wl.flags)) continue;
                if ((wl.flags & 0x3F) == 32 && reason == 4) {
                    proxLock = true;
                    continue;
                }
                ((WakeLock)this.mLocks.get((int)i)).activated = false;
                ++numCleared;
            }
            if (!proxLock) {
                this.mProxIgnoredBecauseScreenTurnedOff = true;
            }
            EventLog.writeEvent((int)2724, (int)numCleared);
            this.mStillNeedSleepNotification = true;
            this.mUserState = 0;
            this.setPowerState(0, false, reason);
            this.cancelTimerLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timeSinceScreenOn() {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            if ((this.mPowerState & 1) != 0) {
                return 0L;
            }
            return SystemClock.elapsedRealtime() - this.mScreenOffTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyboardVisibility(boolean visible) {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            if (this.mKeyboardVisible != visible) {
                this.mKeyboardVisible = visible;
                if ((this.mPowerState & 1) != 0) {
                    if (this.mUseSoftwareAutoBrightness && this.mLightSensorValue >= 0.0f) {
                        int value = (int)this.mLightSensorValue;
                        this.mLightSensorValue = -1.0f;
                        this.lightSensorChangedLocked(value);
                    }
                    this.userActivity(SystemClock.uptimeMillis(), false, 1, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableUserActivity(boolean enabled) {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            this.mUserActivityAllowed = enabled;
            if (!enabled) {
                this.setTimeoutLocked(SystemClock.uptimeMillis(), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScreenBrightnessMode(int mode) {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            boolean enabled;
            boolean bl = enabled = mode == 1;
            if (this.mUseSoftwareAutoBrightness && this.mAutoBrightessEnabled != enabled) {
                this.mAutoBrightessEnabled = enabled;
                this.enableLightSensorLocked(this.mAutoBrightessEnabled && this.isScreenOn());
            }
        }
    }

    private void setScreenOffTimeoutsLocked() {
        if ((this.mPokey & 2) != 0) {
            this.mKeylightDelay = this.mShortKeylightDelay;
            this.mDimDelay = -1;
            this.mScreenOffDelay = 0;
        } else if ((this.mPokey & 4) != 0) {
            this.mKeylightDelay = 15000;
            this.mDimDelay = -1;
            this.mScreenOffDelay = 0;
        } else {
            int totalDelay = this.mScreenOffTimeoutSetting;
            if (totalDelay > this.mMaximumScreenOffTimeout) {
                totalDelay = this.mMaximumScreenOffTimeout;
            }
            this.mKeylightDelay = 6000;
            this.mScreenOffDelay = totalDelay < 0 ? this.mMaximumScreenOffTimeout : (this.mKeylightDelay < totalDelay ? totalDelay - this.mKeylightDelay : 0);
            if (this.mDimScreen && totalDelay >= 13000) {
                this.mDimDelay = this.mScreenOffDelay - 7000;
                this.mScreenOffDelay = 7000;
            } else {
                this.mDimDelay = -1;
            }
        }
    }

    private void updateSettingsValues() {
        this.mShortKeylightDelay = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"short_keylight_delay_ms", (int)6000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolicy(WindowManagerPolicy p) {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            this.mPolicy = p;
            this.mLocks.notifyAll();
        }
    }

    WindowManagerPolicy getPolicyLocked() {
        while (this.mPolicy == null || !this.mDoneBooting) {
            try {
                this.mLocks.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.mPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        this.mSensorManager = new SensorManager(this.mHandlerThread.getLooper());
        this.mProximitySensor = this.mSensorManager.getDefaultSensor(8);
        if (this.mUseSoftwareAutoBrightness) {
            this.mLightSensor = this.mSensorManager.getDefaultSensor(5);
        }
        if (this.mUseSoftwareAutoBrightness) {
            this.setPowerState(3);
        } else {
            this.setPowerState(15);
        }
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            Slog.d((String)"PowerManagerService", (String)"system ready!");
            this.mDoneBooting = true;
            this.enableLightSensorLocked(this.mUseSoftwareAutoBrightness && this.mAutoBrightessEnabled);
            long identity = Binder.clearCallingIdentity();
            try {
                this.mBatteryStats.noteScreenBrightness(this.getPreferredBrightness());
                this.mBatteryStats.noteScreenOn();
            }
            catch (RemoteException e) {
            }
            finally {
                Binder.restoreCallingIdentity((long)identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bootCompleted() {
        Slog.d((String)"PowerManagerService", (String)"bootCompleted");
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            this.mBootCompleted = true;
            this.userActivity(SystemClock.uptimeMillis(), false, 1, true);
            this.updateWakeLockLocked();
            this.mLocks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        LockList lockList = this.mLocks;
        synchronized (lockList) {
        }
    }

    public int getSupportedWakeLockFlags() {
        int result = 31;
        if (this.mProximitySensor != null) {
            result |= 0x20;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBacklightBrightness(int brightness) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            brightness = Math.max(brightness, this.mScreenBrightnessDim);
            this.mLcdLight.setBrightness(brightness);
            this.mKeyboardLight.setBrightness(this.mKeyboardVisible ? brightness : 0);
            this.mButtonLight.setBrightness(brightness);
            long identity = Binder.clearCallingIdentity();
            try {
                this.mBatteryStats.noteScreenBrightness(brightness);
            }
            catch (RemoteException e) {
                Slog.w((String)"PowerManagerService", (String)"RemoteException calling noteScreenBrightness on BatteryStatsService", (Throwable)e);
            }
            finally {
                Binder.restoreCallingIdentity((long)identity);
            }
            LockList lockList2 = this.mLocks;
            synchronized (lockList2) {
                this.mScreenBrightness.targetValue = brightness;
                this.mScreenBrightness.jumpToTargetLocked();
            }
        }
    }

    public void setAttentionLight(boolean on, int color) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        this.mAttentionLight.setFlashing(color, 2, on ? 3 : 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableProximityLockLocked() {
        if (!this.mProximitySensorEnabled) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mSensorManager.registerListener(this.mProximityListener, this.mProximitySensor, 3);
                this.mProximitySensorEnabled = true;
            }
            finally {
                Binder.restoreCallingIdentity((long)identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableProximityLockLocked() {
        if (this.mProximitySensorEnabled) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mSensorManager.unregisterListener(this.mProximityListener);
                this.mHandler.removeCallbacks(this.mProximityTask);
                if (this.mProximityPartialLock.isHeld()) {
                    this.mProximityPartialLock.release();
                }
                this.mProximitySensorEnabled = false;
            }
            finally {
                Binder.restoreCallingIdentity((long)identity);
            }
            if (this.mProximitySensorActive) {
                this.mProximitySensorActive = false;
                if (!this.mProxIgnoredBecauseScreenTurnedOff) {
                    this.forceUserActivityLocked();
                }
            }
        }
    }

    private void proximityChangedLocked(boolean active) {
        if (!this.mProximitySensorEnabled) {
            Slog.d((String)"PowerManagerService", (String)"Ignoring proximity change after sensor is disabled");
            return;
        }
        if (active) {
            if (!this.mProxIgnoredBecauseScreenTurnedOff) {
                this.goToSleepLocked(SystemClock.uptimeMillis(), 4);
            }
            this.mProximitySensorActive = true;
        } else {
            this.mProximitySensorActive = false;
            if (!this.mProxIgnoredBecauseScreenTurnedOff) {
                this.forceUserActivityLocked();
            }
            if (this.mProximityWakeLockCount == 0) {
                this.disableProximityLockLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableLightSensorLocked(boolean enable) {
        if (!this.mAutoBrightessEnabled) {
            enable = false;
        }
        if (this.mSensorManager != null && this.mLightSensorEnabled != enable) {
            this.mLightSensorEnabled = enable;
            this.mHighestLightSensorValue = -1;
            this.mLightSensorValue = -1.0f;
            long identity = Binder.clearCallingIdentity();
            try {
                if (enable) {
                    this.mSensorManager.registerListener(this.mLightListener, this.mLightSensor, 1000000);
                } else {
                    this.mSensorManager.unregisterListener(this.mLightListener);
                    this.mHandler.removeCallbacks(this.mAutoBrightnessTask);
                }
            }
            finally {
                Binder.restoreCallingIdentity((long)identity);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LockList
    extends ArrayList<WakeLock> {
        private LockList() {
        }

        void addLock(WakeLock wl) {
            int index = this.getIndex(wl.binder);
            if (index < 0) {
                this.add(wl);
            }
        }

        WakeLock removeLock(IBinder binder) {
            int index = this.getIndex(binder);
            if (index >= 0) {
                return (WakeLock)this.remove(index);
            }
            return null;
        }

        int getIndex(IBinder binder) {
            int N = this.size();
            for (int i = 0; i < N; ++i) {
                if (((WakeLock)this.get((int)i)).binder != binder) continue;
                return i;
            }
            return -1;
        }

        int gatherState() {
            int result = 0;
            int N = this.size();
            for (int i = 0; i < N; ++i) {
                WakeLock wl = (WakeLock)this.get(i);
                if (!wl.activated || !PowerManagerService.this.isScreenLock(wl.flags)) continue;
                result |= wl.minState;
            }
            return result;
        }

        int reactivateScreenLocksLocked() {
            int result = 0;
            int N = this.size();
            for (int i = 0; i < N; ++i) {
                WakeLock wl = (WakeLock)this.get(i);
                if (!PowerManagerService.this.isScreenLock(wl.flags)) continue;
                wl.activated = true;
                result |= wl.minState;
            }
            PowerManagerService.this.mProxIgnoredBecauseScreenTurnedOff = false;
            return result;
        }
    }

    class BrightnessState
    implements Runnable {
        final int mask;
        boolean initialized;
        int targetValue;
        float curValue;
        float delta;
        boolean animating;

        BrightnessState(int m) {
            this.mask = m;
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + "animating=" + this.animating + " targetValue=" + this.targetValue + " curValue=" + this.curValue + " delta=" + this.delta);
        }

        void forceValueLocked(int value) {
            this.targetValue = -1;
            this.curValue = value;
            PowerManagerService.this.setLightBrightness(this.mask, value);
            if (this.animating) {
                this.finishAnimationLocked(false, value);
            }
        }

        void setTargetLocked(int target, int stepsToTarget, int initialValue, int nominalCurrentValue) {
            if (!this.initialized) {
                this.initialized = true;
                this.curValue = initialValue;
            } else if (this.targetValue == target) {
                return;
            }
            this.targetValue = target;
            this.delta = ((float)this.targetValue - (nominalCurrentValue >= 0 ? (float)nominalCurrentValue : this.curValue)) / (float)stepsToTarget;
            this.animating = true;
            PowerManagerService.this.mScreenOffHandler.removeCallbacks((Runnable)this);
            PowerManagerService.this.mScreenOffHandler.post((Runnable)this);
        }

        boolean stepLocked() {
            if (!this.animating) {
                return false;
            }
            this.curValue += this.delta;
            int curIntValue = (int)this.curValue;
            boolean more = true;
            if (this.delta == 0.0f) {
                curIntValue = this.targetValue;
                this.curValue = curIntValue;
                more = false;
            } else if (this.delta > 0.0f) {
                if (curIntValue >= this.targetValue) {
                    curIntValue = this.targetValue;
                    this.curValue = curIntValue;
                    more = false;
                }
            } else if (curIntValue <= this.targetValue) {
                curIntValue = this.targetValue;
                this.curValue = curIntValue;
                more = false;
            }
            PowerManagerService.this.setLightBrightness(this.mask, curIntValue);
            this.finishAnimationLocked(more, curIntValue);
            return more;
        }

        void jumpToTargetLocked() {
            PowerManagerService.this.setLightBrightness(this.mask, this.targetValue);
            int tv = this.targetValue;
            this.curValue = tv;
            this.targetValue = -1;
            this.finishAnimationLocked(false, tv);
        }

        private void finishAnimationLocked(boolean more, int curIntValue) {
            this.animating = more;
            if (!more && this.mask == 2 && curIntValue == 0) {
                PowerManagerService.this.screenOffFinishedAnimatingLocked(PowerManagerService.this.mScreenOffReason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                boolean turningOff;
                boolean bl = turningOff = this.animating && this.targetValue == 0;
                if (PowerManagerService.this.mAnimateScreenLights || !turningOff) {
                    long now = SystemClock.uptimeMillis();
                    boolean more = PowerManagerService.this.mScreenBrightness.stepLocked();
                    if (more) {
                        PowerManagerService.this.mScreenOffHandler.postAtTime((Runnable)this, now + 16L);
                    }
                } else {
                    PowerManagerService.this.nativeStartSurfaceFlingerAnimation(PowerManagerService.this.mScreenOffReason == 4 ? 0 : PowerManagerService.this.mAnimationSetting);
                    PowerManagerService.this.mScreenBrightness.jumpToTargetLocked();
                }
            }
        }
    }

    private class TimeoutTask
    implements Runnable {
        int nextState;
        long remainingTimeoutOverride;

        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                if (this.nextState == -1) {
                    return;
                }
                PowerManagerService.this.mUserState = this.nextState;
                PowerManagerService.this.setPowerState(this.nextState | PowerManagerService.this.mWakeLockState);
                long now = SystemClock.uptimeMillis();
                switch (this.nextState) {
                    case 3: {
                        if (PowerManagerService.this.mDimDelay >= 0) {
                            PowerManagerService.this.setTimeoutLocked(now, this.remainingTimeoutOverride, 1);
                            break;
                        }
                    }
                    case 1: {
                        PowerManagerService.this.setTimeoutLocked(now, this.remainingTimeoutOverride, 0);
                    }
                }
            }
        }
    }

    private class PokeLock
    implements IBinder.DeathRecipient {
        int pokey;
        IBinder binder;
        String tag;
        boolean awakeOnSet;

        PokeLock(int p, IBinder b, String t) {
            this.pokey = p;
            this.binder = b;
            this.tag = t;
            try {
                b.linkToDeath((IBinder.DeathRecipient)this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        public void binderDied() {
            PowerManagerService.this.setPokeLock(0, this.binder, this.tag);
        }
    }

    private class WakeLock
    implements IBinder.DeathRecipient {
        final int flags;
        final IBinder binder;
        final String tag;
        final int uid;
        final int pid;
        final int monitorType;
        WorkSource ws;
        boolean activated = true;
        int minState;

        WakeLock(int f, IBinder b, String t, int u, int p) {
            this.flags = f;
            this.binder = b;
            this.tag = t;
            this.uid = u == PowerManagerService.this.MY_UID ? 1000 : u;
            this.pid = p;
            this.monitorType = u != PowerManagerService.this.MY_UID || !"KEEP_SCREEN_ON_FLAG".equals(this.tag) && !"KeyInputQueue".equals(this.tag) ? ((f & 0x3F) == 1 ? 0 : 1) : -1;
            try {
                b.linkToDeath((IBinder.DeathRecipient)this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                PowerManagerService.this.releaseWakeLockLocked(this.binder, 0, true);
            }
        }
    }

    private class SettingsObserver
    implements Observer {
        private SettingsObserver() {
        }

        private int getInt(String name, int defValue) {
            ContentValues values = PowerManagerService.this.mSettings.getValues(name);
            Integer iVal = values != null ? values.getAsInteger("value") : null;
            return iVal != null ? iVal : defValue;
        }

        private float getFloat(String name, float defValue) {
            ContentValues values = PowerManagerService.this.mSettings.getValues(name);
            Float fVal = values != null ? values.getAsFloat("value") : null;
            return fVal != null ? fVal.floatValue() : defValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Observable o, Object arg) {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                PowerManagerService.this.mStayOnConditions = this.getInt("stay_on_while_plugged_in", 1);
                PowerManagerService.this.updateWakeLockLocked();
                PowerManagerService.this.mScreenOffTimeoutSetting = this.getInt("screen_off_timeout", 15000);
                PowerManagerService.this.setScreenBrightnessMode(this.getInt("screen_brightness_mode", 0));
                PowerManagerService.this.setScreenOffTimeoutsLocked();
                float windowScale = this.getFloat("window_animation_scale", 1.0f);
                float transitionScale = this.getFloat("transition_animation_scale", 1.0f);
                PowerManagerService.this.mAnimationSetting = 0;
                if (windowScale > 0.5f) {
                    PowerManagerService.this.mAnimationSetting |= 16;
                }
                if (transitionScale > 0.5f) {
                    // empty if block
                }
            }
        }
    }

    private final class DockReceiver
    extends BroadcastReceiver {
        private DockReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
            PowerManagerService.this.dockStateChanged(state);
        }
    }

    private final class BootCompletedReceiver
    extends BroadcastReceiver {
        private BootCompletedReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            PowerManagerService.this.bootCompleted();
        }
    }

    private final class BatteryReceiver
    extends BroadcastReceiver {
        private BatteryReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            LockList lockList = PowerManagerService.this.mLocks;
            synchronized (lockList) {
                boolean wasPowered = PowerManagerService.this.mIsPowered;
                PowerManagerService.this.mIsPowered = PowerManagerService.this.mBatteryService.isPowered();
                if (PowerManagerService.this.mIsPowered != wasPowered) {
                    PowerManagerService.this.updateWakeLockLocked();
                    LockList lockList2 = PowerManagerService.this.mLocks;
                    synchronized (lockList2) {
                        if (!wasPowered || (PowerManagerService.this.mPowerState & 1) != 0 || PowerManagerService.this.mUnplugTurnsOnScreen) {
                            PowerManagerService.this.forceUserActivityLocked();
                        }
                    }
                }
            }
        }
    }

    private class UnsynchronizedWakeLock {
        int mFlags;
        String mTag;
        IBinder mToken;
        int mCount = 0;
        boolean mRefCounted;
        boolean mHeld;

        UnsynchronizedWakeLock(int flags, String tag, boolean refCounted) {
            this.mFlags = flags;
            this.mTag = tag;
            this.mToken = new Binder();
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            if (!this.mRefCounted || this.mCount++ == 0) {
                long ident = Binder.clearCallingIdentity();
                try {
                    PowerManagerService.this.acquireWakeLockLocked(this.mFlags, this.mToken, PowerManagerService.this.MY_UID, PowerManagerService.this.MY_PID, this.mTag, null);
                    this.mHeld = true;
                }
                finally {
                    Binder.restoreCallingIdentity((long)ident);
                }
            }
        }

        public void release() {
            if (!this.mRefCounted || --this.mCount == 0) {
                PowerManagerService.this.releaseWakeLockLocked(this.mToken, 0, false);
                this.mHeld = false;
            }
            if (this.mCount < 0) {
                throw new RuntimeException("WakeLock under-locked " + this.mTag);
            }
        }

        public boolean isHeld() {
            return this.mHeld;
        }

        public String toString() {
            return "UnsynchronizedWakeLock(mFlags=0x" + Integer.toHexString(this.mFlags) + " mCount=" + this.mCount + " mHeld=" + this.mHeld + ")";
        }
    }
}

