/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ComponentName;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.util.Slog;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferredComponent {
    public final int mMatch;
    public final ComponentName mComponent;
    private final String[] mSetPackages;
    private final String[] mSetClasses;
    private final String[] mSetComponents;
    private final String mShortComponent;
    private String mParseError;
    private final Callbacks mCallbacks;

    public PreferredComponent(Callbacks callbacks, int match, ComponentName[] set, ComponentName component) {
        this.mCallbacks = callbacks;
        this.mMatch = match & 0xFFF0000;
        this.mComponent = component;
        this.mShortComponent = component.flattenToShortString();
        this.mParseError = null;
        if (set != null) {
            int N = set.length;
            String[] myPackages = new String[N];
            String[] myClasses = new String[N];
            String[] myComponents = new String[N];
            for (int i = 0; i < N; ++i) {
                ComponentName cn = set[i];
                if (cn == null) {
                    this.mSetPackages = null;
                    this.mSetClasses = null;
                    this.mSetComponents = null;
                    return;
                }
                myPackages[i] = cn.getPackageName().intern();
                myClasses[i] = cn.getClassName().intern();
                myComponents[i] = cn.flattenToShortString().intern();
            }
            this.mSetPackages = myPackages;
            this.mSetClasses = myClasses;
            this.mSetComponents = myComponents;
        } else {
            this.mSetPackages = null;
            this.mSetClasses = null;
            this.mSetComponents = null;
        }
    }

    public PreferredComponent(Callbacks callbacks, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        String matchStr;
        this.mCallbacks = callbacks;
        this.mShortComponent = parser.getAttributeValue(null, "name");
        this.mComponent = ComponentName.unflattenFromString((String)this.mShortComponent);
        if (this.mComponent == null) {
            this.mParseError = "Bad activity name " + this.mShortComponent;
        }
        this.mMatch = (matchStr = parser.getAttributeValue(null, "match")) != null ? Integer.parseInt(matchStr, 16) : 0;
        String setCountStr = parser.getAttributeValue(null, "set");
        int setCount = setCountStr != null ? Integer.parseInt(setCountStr) : 0;
        String[] myPackages = setCount > 0 ? new String[setCount] : null;
        String[] myClasses = setCount > 0 ? new String[setCount] : null;
        String[] myComponents = setCount > 0 ? new String[setCount] : null;
        int setPos = 0;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("set")) {
                String name = parser.getAttributeValue(null, "name");
                if (name == null) {
                    if (this.mParseError == null) {
                        this.mParseError = "No name in set tag in preferred activity " + this.mShortComponent;
                    }
                } else if (setPos >= setCount) {
                    if (this.mParseError == null) {
                        this.mParseError = "Too many set tags in preferred activity " + this.mShortComponent;
                    }
                } else {
                    ComponentName cn = ComponentName.unflattenFromString((String)name);
                    if (cn == null) {
                        if (this.mParseError == null) {
                            this.mParseError = "Bad set name " + name + " in preferred activity " + this.mShortComponent;
                        }
                    } else {
                        myPackages[setPos] = cn.getPackageName();
                        myClasses[setPos] = cn.getClassName();
                        myComponents[setPos] = name;
                        ++setPos;
                    }
                }
                XmlUtils.skipCurrentTag((XmlPullParser)parser);
                continue;
            }
            if (this.mCallbacks.onReadTag(tagName, parser)) continue;
            Slog.w((String)"PreferredComponent", (String)("Unknown element: " + parser.getName()));
            XmlUtils.skipCurrentTag((XmlPullParser)parser);
        }
        if (setPos != setCount && this.mParseError == null) {
            this.mParseError = "Not enough set tags (expected " + setCount + " but found " + setPos + ") in " + this.mShortComponent;
        }
        this.mSetPackages = myPackages;
        this.mSetClasses = myClasses;
        this.mSetComponents = myComponents;
    }

    public String getParseError() {
        return this.mParseError;
    }

    public void writeToXml(XmlSerializer serializer) throws IOException {
        int NS = this.mSetClasses != null ? this.mSetClasses.length : 0;
        serializer.attribute(null, "name", this.mShortComponent);
        if (this.mMatch != 0) {
            serializer.attribute(null, "match", Integer.toHexString(this.mMatch));
        }
        serializer.attribute(null, "set", Integer.toString(NS));
        for (int s = 0; s < NS; ++s) {
            serializer.startTag(null, "set");
            serializer.attribute(null, "name", this.mSetComponents[s]);
            serializer.endTag(null, "set");
        }
    }

    public boolean sameSet(List<ResolveInfo> query, int priority) {
        if (this.mSetPackages == null) {
            return false;
        }
        int NQ = query.size();
        int NS = this.mSetPackages.length;
        int numMatch = 0;
        for (int i = 0; i < NQ; ++i) {
            ResolveInfo ri = query.get(i);
            if (ri.priority != priority) continue;
            ActivityInfo ai = ri.activityInfo;
            boolean good = false;
            for (int j = 0; j < NS; ++j) {
                if (!this.mSetPackages[j].equals(ai.packageName) || !this.mSetClasses[j].equals(ai.name)) continue;
                ++numMatch;
                good = true;
                break;
            }
            if (good) continue;
            return false;
        }
        return numMatch == NS;
    }

    public void dump(PrintWriter out, String prefix, Object ident) {
        out.print(prefix);
        out.print(Integer.toHexString(System.identityHashCode(ident)));
        out.print(' ');
        out.print(this.mComponent.flattenToShortString());
        out.print(" match=0x");
        out.println(Integer.toHexString(this.mMatch));
        if (this.mSetComponents != null) {
            out.print(prefix);
            out.println("  Selected from:");
            for (int i = 0; i < this.mSetComponents.length; ++i) {
                out.print(prefix);
                out.print("    ");
                out.println(this.mSetComponents[i]);
            }
        }
    }

    public static interface Callbacks {
        public boolean onReadTag(String var1, XmlPullParser var2) throws XmlPullParserException, IOException;
    }
}

