/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.content.PackageMonitor;
import java.util.List;

public class RecognitionManagerService
extends Binder {
    static final String TAG = "RecognitionManagerService";
    final Context mContext;
    final MyPackageMonitor mMonitor;

    RecognitionManagerService(Context context) {
        this.mContext = context;
        this.mMonitor = new MyPackageMonitor();
        this.mMonitor.register(context, true);
    }

    public void systemReady() {
        ComponentName comp = this.getCurRecognizer();
        if (comp != null) {
            try {
                this.mContext.getPackageManager().getServiceInfo(comp, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                this.setCurRecognizer(null);
            }
        } else {
            comp = this.findAvailRecognizer(null);
            if (comp != null) {
                this.setCurRecognizer(comp);
            }
        }
    }

    ComponentName findAvailRecognizer(String prefPackage) {
        List available = this.mContext.getPackageManager().queryIntentServices(new Intent("android.speech.RecognitionService"), 0);
        int numAvailable = available.size();
        if (numAvailable == 0) {
            Slog.w((String)TAG, (String)"no available voice recognition services found");
            return null;
        }
        if (prefPackage != null) {
            for (int i = 0; i < numAvailable; ++i) {
                ServiceInfo serviceInfo = ((ResolveInfo)available.get((int)i)).serviceInfo;
                if (!prefPackage.equals(serviceInfo.packageName)) continue;
                return new ComponentName(serviceInfo.packageName, serviceInfo.name);
            }
        }
        if (numAvailable > 1) {
            Slog.w((String)TAG, (String)"more than one voice recognition service found, picking first");
        }
        ServiceInfo serviceInfo = ((ResolveInfo)available.get((int)0)).serviceInfo;
        return new ComponentName(serviceInfo.packageName, serviceInfo.name);
    }

    ComponentName getCurRecognizer() {
        String curRecognizer = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"voice_recognition_service");
        if (TextUtils.isEmpty((CharSequence)curRecognizer)) {
            return null;
        }
        return ComponentName.unflattenFromString((String)curRecognizer);
    }

    void setCurRecognizer(ComponentName comp) {
        Settings.Secure.putString((ContentResolver)this.mContext.getContentResolver(), (String)"voice_recognition_service", (String)(comp != null ? comp.flattenToShortString() : ""));
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        public void onSomePackagesChanged() {
            ComponentName comp = RecognitionManagerService.this.getCurRecognizer();
            if (comp == null) {
                if (this.anyPackagesAppearing() && (comp = RecognitionManagerService.this.findAvailRecognizer(null)) != null) {
                    RecognitionManagerService.this.setCurRecognizer(comp);
                }
                return;
            }
            int change = this.isPackageDisappearing(comp.getPackageName());
            if (change == 3 || change == 2) {
                RecognitionManagerService.this.setCurRecognizer(RecognitionManagerService.this.findAvailRecognizer(null));
            } else if (this.isPackageModified(comp.getPackageName())) {
                RecognitionManagerService.this.setCurRecognizer(RecognitionManagerService.this.findAvailRecognizer(comp.getPackageName()));
            }
        }
    }
}

