/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.accounts.AccountManagerService;
import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.IAlarmManager;
import android.app.INotificationManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentService;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.res.Configuration;
import android.media.AudioService;
import android.net.IConnectivityManager;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.wifi.p2p.WifiP2pService;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.IPowerManager;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.server.BluetoothA2dpService;
import android.server.BluetoothService;
import android.server.search.SearchManagerService;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.view.WindowManager;
import com.android.internal.app.ShutdownThread;
import com.android.internal.os.BinderInternal;
import com.android.server.AlarmManagerService;
import com.android.server.AppWidgetService;
import com.android.server.AttributeCache;
import com.android.server.BackupManagerService;
import com.android.server.BatteryService;
import com.android.server.ClipboardService;
import com.android.server.ConnectivityService;
import com.android.server.CountryDetectorService;
import com.android.server.DevicePolicyManagerService;
import com.android.server.DeviceStorageMonitorService;
import com.android.server.DiskStatsService;
import com.android.server.DockObserver;
import com.android.server.DropBoxManagerService;
import com.android.server.EntropyService;
import com.android.server.InputMethodManagerService;
import com.android.server.LightsService;
import com.android.server.LocationManagerService;
import com.android.server.MountService;
import com.android.server.NetworkManagementService;
import com.android.server.NetworkTimeUpdateService;
import com.android.server.NotificationManagerService;
import com.android.server.PowerManagerService;
import com.android.server.RecognitionManagerService;
import com.android.server.SamplingProfilerService;
import com.android.server.StatusBarManagerService;
import com.android.server.TelephonyRegistry;
import com.android.server.TextServicesManagerService;
import com.android.server.ThrottleService;
import com.android.server.UiModeManagerService;
import com.android.server.VibratorService;
import com.android.server.WallpaperManagerService;
import com.android.server.Watchdog;
import com.android.server.WifiService;
import com.android.server.WiredAccessoryObserver;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.am.ActivityManagerService;
import com.android.server.net.NetworkPolicyManagerService;
import com.android.server.net.NetworkStatsService;
import com.android.server.pm.PackageManagerService;
import com.android.server.usb.UsbService;
import com.android.server.wm.WindowManagerService;
import dalvik.system.VMRuntime;
import dalvik.system.Zygote;
import java.io.File;

class ServerThread
extends Thread {
    private static final String TAG = "SystemServer";
    private static final String ENCRYPTING_STATE = "trigger_restart_min_framework";
    private static final String ENCRYPTED_STATE = "1";
    ContentResolver mContentResolver;

    ServerThread() {
    }

    void reportWtf(String msg, Throwable e) {
        Slog.w((String)TAG, (String)"***********************************************");
        Log.wtf((String)TAG, (String)("BOOT FAILURE " + msg), (Throwable)e);
    }

    public void run() {
        boolean safeMode;
        String factoryTestStr;
        EventLog.writeEvent((int)3010, (long)SystemClock.uptimeMillis());
        Looper.prepare();
        Process.setThreadPriority((int)-2);
        BinderInternal.disableBackgroundScheduling((boolean)true);
        Process.setCanSelfBackground((boolean)false);
        String shutdownAction = SystemProperties.get((String)"sys.shutdown.requested", (String)"");
        if (shutdownAction != null && shutdownAction.length() > 0) {
            boolean reboot = shutdownAction.charAt(0) == '1';
            String reason = shutdownAction.length() > 1 ? shutdownAction.substring(1, shutdownAction.length()) : null;
            ShutdownThread.rebootOrShutdown((boolean)reboot, reason);
        }
        int factoryTest = "".equals(factoryTestStr = SystemProperties.get((String)"ro.factorytest")) ? 0 : Integer.parseInt(factoryTestStr);
        LightsService lights = null;
        PowerManagerService power = null;
        BatteryService battery = null;
        AlarmManagerService alarm = null;
        NetworkManagementService networkManagement = null;
        NetworkStatsService networkStats = null;
        NetworkPolicyManagerService networkPolicy = null;
        ConnectivityService connectivity = null;
        WifiP2pService wifiP2p = null;
        WifiService wifi = null;
        IPackageManager pm = null;
        Context context = null;
        WindowManagerService wm = null;
        BluetoothService bluetooth = null;
        BluetoothA2dpService bluetoothA2dp = null;
        DockObserver dock = null;
        UsbService usb = null;
        UiModeManagerService uiMode = null;
        RecognitionManagerService recognition = null;
        ThrottleService throttle = null;
        NetworkTimeUpdateService networkTimeUpdater = null;
        try {
            Slog.i((String)TAG, (String)"Entropy Service");
            ServiceManager.addService((String)"entropy", (IBinder)new EntropyService());
            Slog.i((String)TAG, (String)"Power Manager");
            power = new PowerManagerService();
            ServiceManager.addService((String)"power", (IBinder)power);
            Slog.i((String)TAG, (String)"Activity Manager");
            context = ActivityManagerService.main(factoryTest);
            Slog.i((String)TAG, (String)"Telephony Registry");
            ServiceManager.addService((String)"telephony.registry", (IBinder)new TelephonyRegistry(context));
            AttributeCache.init(context);
            Slog.i((String)TAG, (String)"Package Manager");
            String cryptState = SystemProperties.get((String)"vold.decrypt");
            boolean onlyCore = false;
            if (ENCRYPTING_STATE.equals(cryptState)) {
                Slog.w((String)TAG, (String)"Detected encryption in progress - only parsing core apps");
                onlyCore = true;
            } else if (ENCRYPTED_STATE.equals(cryptState)) {
                Slog.w((String)TAG, (String)"Device encrypted - only parsing core apps");
                onlyCore = true;
            }
            pm = PackageManagerService.main(context, factoryTest != 0, onlyCore);
            boolean firstBoot = false;
            try {
                firstBoot = pm.isFirstBoot();
            }
            catch (RemoteException e) {
                // empty catch block
            }
            ActivityManagerService.setSystemProcess();
            this.mContentResolver = context.getContentResolver();
            try {
                Slog.i((String)TAG, (String)"Account Manager");
                ServiceManager.addService((String)"account", (IBinder)new AccountManagerService(context));
            }
            catch (Throwable e) {
                Slog.e((String)TAG, (String)"Failure starting Account Manager", (Throwable)e);
            }
            Slog.i((String)TAG, (String)"Content Manager");
            ContentService.main((Context)context, (factoryTest == 1 ? 1 : 0) != 0);
            Slog.i((String)TAG, (String)"System Content Providers");
            ActivityManagerService.installSystemProviders();
            Slog.i((String)TAG, (String)"Lights Service");
            lights = new LightsService(context);
            Slog.i((String)TAG, (String)"Battery Service");
            battery = new BatteryService(context, lights);
            ServiceManager.addService((String)"battery", (IBinder)battery);
            Slog.i((String)TAG, (String)"Vibrator Service");
            ServiceManager.addService((String)"vibrator", (IBinder)new VibratorService(context));
            power.init(context, lights, (IActivityManager)ActivityManagerService.self(), battery);
            Slog.i((String)TAG, (String)"Alarm Manager");
            alarm = new AlarmManagerService(context);
            ServiceManager.addService((String)"alarm", (IBinder)alarm);
            Slog.i((String)TAG, (String)"Init Watchdog");
            Watchdog.getInstance().init(context, battery, power, alarm, ActivityManagerService.self());
            Slog.i((String)TAG, (String)"Window Manager");
            wm = WindowManagerService.main(context, power, factoryTest != 1, !firstBoot);
            ServiceManager.addService((String)"window", (IBinder)wm);
            ActivityManagerService.self().setWindowManager(wm);
            if (SystemProperties.get((String)"ro.kernel.qemu").equals(ENCRYPTED_STATE)) {
                Slog.i((String)TAG, (String)"No Bluetooh Service (emulator)");
            } else if (factoryTest == 1) {
                Slog.i((String)TAG, (String)"No Bluetooth Service (factory test)");
            } else {
                Slog.i((String)TAG, (String)"Bluetooth Service");
                bluetooth = new BluetoothService(context);
                ServiceManager.addService((String)"bluetooth", (IBinder)bluetooth);
                bluetooth.initAfterRegistration();
                bluetoothA2dp = new BluetoothA2dpService(context, bluetooth);
                ServiceManager.addService((String)"bluetooth_a2dp", (IBinder)bluetoothA2dp);
                bluetooth.initAfterA2dpRegistration();
                int airplaneModeOn = Settings.System.getInt((ContentResolver)this.mContentResolver, (String)"airplane_mode_on", (int)0);
                int bluetoothOn = Settings.Secure.getInt((ContentResolver)this.mContentResolver, (String)"bluetooth_on", (int)0);
                if (airplaneModeOn == 0 && bluetoothOn != 0) {
                    bluetooth.enable();
                }
            }
        }
        catch (RuntimeException e) {
            Slog.e((String)"System", (String)"******************************************");
            Slog.e((String)"System", (String)"************ Failure starting core service", (Throwable)e);
        }
        DevicePolicyManagerService devicePolicy = null;
        StatusBarManagerService statusBar = null;
        InputMethodManagerService imm = null;
        AppWidgetService appWidget = null;
        NotificationManagerService notification = null;
        WallpaperManagerService wallpaper = null;
        LocationManagerService location = null;
        CountryDetectorService countryDetector = null;
        TextServicesManagerService tsms = null;
        if (factoryTest != 1) {
            try {
                Slog.i((String)TAG, (String)"Input Method Service");
                imm = new InputMethodManagerService(context);
                ServiceManager.addService((String)"input_method", (IBinder)imm);
            }
            catch (Throwable e) {
                this.reportWtf("starting Input Manager Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"Accessibility Manager");
                ServiceManager.addService((String)"accessibility", (IBinder)new AccessibilityManagerService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting Accessibility Manager", e);
            }
        }
        try {
            wm.displayReady();
        }
        catch (Throwable e) {
            this.reportWtf("making display ready", e);
        }
        try {
            pm.performBootDexOpt();
        }
        catch (Throwable e) {
            this.reportWtf("performing boot dexopt", e);
        }
        try {
            ActivityManagerNative.getDefault().showBootMessage(context.getResources().getText(17040314), false);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (factoryTest != 1) {
            try {
                Slog.i((String)TAG, (String)"Device Policy");
                devicePolicy = new DevicePolicyManagerService(context);
                ServiceManager.addService((String)"device_policy", (IBinder)devicePolicy);
            }
            catch (Throwable e) {
                this.reportWtf("starting DevicePolicyService", e);
            }
            try {
                Slog.i((String)TAG, (String)"Status Bar");
                statusBar = new StatusBarManagerService(context, wm);
                ServiceManager.addService((String)"statusbar", (IBinder)statusBar);
            }
            catch (Throwable e) {
                this.reportWtf("starting StatusBarManagerService", e);
            }
            try {
                Slog.i((String)TAG, (String)"Clipboard Service");
                ServiceManager.addService((String)"clipboard", (IBinder)new ClipboardService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting Clipboard Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"NetworkManagement Service");
                networkManagement = NetworkManagementService.create(context);
                ServiceManager.addService((String)"network_management", (IBinder)networkManagement);
            }
            catch (Throwable e) {
                this.reportWtf("starting NetworkManagement Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"Text Service Manager Service");
                tsms = new TextServicesManagerService(context);
                ServiceManager.addService((String)"textservices", (IBinder)tsms);
            }
            catch (Throwable e) {
                this.reportWtf("starting Text Service Manager Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"NetworkStats Service");
                networkStats = new NetworkStatsService(context, (INetworkManagementService)networkManagement, (IAlarmManager)alarm);
                ServiceManager.addService((String)"netstats", (IBinder)networkStats);
            }
            catch (Throwable e) {
                this.reportWtf("starting NetworkStats Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"NetworkPolicy Service");
                networkPolicy = new NetworkPolicyManagerService(context, (IActivityManager)ActivityManagerService.self(), (IPowerManager)power, (INetworkStatsService)networkStats, (INetworkManagementService)networkManagement);
                ServiceManager.addService((String)"netpolicy", (IBinder)networkPolicy);
            }
            catch (Throwable e) {
                this.reportWtf("starting NetworkPolicy Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"Wi-Fi P2pService");
                wifiP2p = new WifiP2pService(context);
                ServiceManager.addService((String)"wifip2p", (IBinder)wifiP2p);
            }
            catch (Throwable e) {
                this.reportWtf("starting Wi-Fi P2pService", e);
            }
            try {
                Slog.i((String)TAG, (String)"Wi-Fi Service");
                wifi = new WifiService(context);
                ServiceManager.addService((String)"wifi", (IBinder)wifi);
            }
            catch (Throwable e) {
                this.reportWtf("starting Wi-Fi Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"Connectivity Service");
                connectivity = new ConnectivityService(context, (INetworkManagementService)networkManagement, (INetworkStatsService)networkStats, (INetworkPolicyManager)networkPolicy);
                ServiceManager.addService((String)"connectivity", (IBinder)connectivity);
                networkStats.bindConnectivityManager((IConnectivityManager)connectivity);
                networkPolicy.bindConnectivityManager((IConnectivityManager)connectivity);
                wifi.checkAndStartWifi();
                wifiP2p.connectivityServiceReady();
            }
            catch (Throwable e) {
                this.reportWtf("starting Connectivity Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"Throttle Service");
                throttle = new ThrottleService(context);
                ServiceManager.addService((String)"throttle", (IBinder)throttle);
            }
            catch (Throwable e) {
                this.reportWtf("starting ThrottleService", e);
            }
            try {
                Slog.i((String)TAG, (String)"Mount Service");
                ServiceManager.addService((String)"mount", (IBinder)new MountService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting Mount Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"Notification Manager");
                notification = new NotificationManagerService(context, statusBar, lights);
                ServiceManager.addService((String)"notification", (IBinder)notification);
                networkPolicy.bindNotificationManager((INotificationManager)notification);
            }
            catch (Throwable e) {
                this.reportWtf("starting Notification Manager", e);
            }
            try {
                Slog.i((String)TAG, (String)"Device Storage Monitor");
                ServiceManager.addService((String)"devicestoragemonitor", (IBinder)new DeviceStorageMonitorService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting DeviceStorageMonitor service", e);
            }
            try {
                Slog.i((String)TAG, (String)"Location Manager");
                location = new LocationManagerService(context);
                ServiceManager.addService((String)"location", (IBinder)location);
            }
            catch (Throwable e) {
                this.reportWtf("starting Location Manager", e);
            }
            try {
                Slog.i((String)TAG, (String)"Country Detector");
                countryDetector = new CountryDetectorService(context);
                ServiceManager.addService((String)"country_detector", (IBinder)countryDetector);
            }
            catch (Throwable e) {
                this.reportWtf("starting Country Detector", e);
            }
            try {
                Slog.i((String)TAG, (String)"Search Service");
                ServiceManager.addService((String)"search", (IBinder)new SearchManagerService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting Search Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"DropBox Service");
                ServiceManager.addService((String)"dropbox", (IBinder)new DropBoxManagerService(context, new File("/data/system/dropbox")));
            }
            catch (Throwable e) {
                this.reportWtf("starting DropBoxManagerService", e);
            }
            try {
                Slog.i((String)TAG, (String)"Wallpaper Service");
                wallpaper = new WallpaperManagerService(context);
                ServiceManager.addService((String)"wallpaper", (IBinder)wallpaper);
            }
            catch (Throwable e) {
                this.reportWtf("starting Wallpaper Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"Audio Service");
                ServiceManager.addService((String)"audio", (IBinder)new AudioService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting Audio Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"Dock Observer");
                dock = new DockObserver(context, power);
            }
            catch (Throwable e) {
                this.reportWtf("starting DockObserver", e);
            }
            try {
                Slog.i((String)TAG, (String)"Wired Accessory Observer");
                new WiredAccessoryObserver(context);
            }
            catch (Throwable e) {
                this.reportWtf("starting WiredAccessoryObserver", e);
            }
            try {
                Slog.i((String)TAG, (String)"USB Service");
                usb = new UsbService(context);
                ServiceManager.addService((String)"usb", (IBinder)usb);
            }
            catch (Throwable e) {
                this.reportWtf("starting UsbService", e);
            }
            try {
                Slog.i((String)TAG, (String)"UI Mode Manager Service");
                uiMode = new UiModeManagerService(context);
            }
            catch (Throwable e) {
                this.reportWtf("starting UiModeManagerService", e);
            }
            try {
                Slog.i((String)TAG, (String)"Backup Service");
                ServiceManager.addService((String)"backup", (IBinder)new BackupManagerService(context));
            }
            catch (Throwable e) {
                Slog.e((String)TAG, (String)"Failure starting Backup Service", (Throwable)e);
            }
            try {
                Slog.i((String)TAG, (String)"AppWidget Service");
                appWidget = new AppWidgetService(context);
                ServiceManager.addService((String)"appwidget", (IBinder)appWidget);
            }
            catch (Throwable e) {
                this.reportWtf("starting AppWidget Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"Recognition Service");
                recognition = new RecognitionManagerService(context);
            }
            catch (Throwable e) {
                this.reportWtf("starting Recognition Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"DiskStats Service");
                ServiceManager.addService((String)"diskstats", (IBinder)new DiskStatsService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting DiskStats Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"SamplingProfiler Service");
                ServiceManager.addService((String)"samplingprofiler", (IBinder)new SamplingProfilerService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting SamplingProfiler Service", e);
            }
            try {
                Slog.i((String)TAG, (String)"NetworkTimeUpdateService");
                networkTimeUpdater = new NetworkTimeUpdateService(context);
            }
            catch (Throwable e) {
                this.reportWtf("starting NetworkTimeUpdate service", e);
            }
        }
        if (safeMode = wm.detectSafeMode()) {
            ActivityManagerService.self().enterSafeMode();
            Zygote.systemInSafeMode = true;
            VMRuntime.getRuntime().disableJitCompilation();
        } else {
            VMRuntime.getRuntime().startJitCompilation();
        }
        if (devicePolicy != null) {
            try {
                devicePolicy.systemReady();
            }
            catch (Throwable e) {
                this.reportWtf("making Device Policy Service ready", e);
            }
        }
        if (notification != null) {
            try {
                notification.systemReady();
            }
            catch (Throwable e) {
                this.reportWtf("making Notification Service ready", e);
            }
        }
        try {
            wm.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Window Manager Service ready", e);
        }
        if (safeMode) {
            ActivityManagerService.self().showSafeModeOverlay();
        }
        Configuration config = wm.computeNewConfiguration();
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager w = (WindowManager)context.getSystemService("window");
        w.getDefaultDisplay().getMetrics(metrics);
        context.getResources().updateConfiguration(config, metrics);
        power.systemReady();
        try {
            pm.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Package Manager Service ready", e);
        }
        final Context contextF = context;
        final BatteryService batteryF = battery;
        final NetworkManagementService networkManagementF = networkManagement;
        final NetworkStatsService networkStatsF = networkStats;
        final NetworkPolicyManagerService networkPolicyF = networkPolicy;
        final ConnectivityService connectivityF = connectivity;
        final DockObserver dockF = dock;
        final UsbService usbF = usb;
        final ThrottleService throttleF = throttle;
        final UiModeManagerService uiModeF = uiMode;
        final AppWidgetService appWidgetF = appWidget;
        final WallpaperManagerService wallpaperF = wallpaper;
        final InputMethodManagerService immF = imm;
        final RecognitionManagerService recognitionF = recognition;
        final LocationManagerService locationF = location;
        final CountryDetectorService countryDetectorF = countryDetector;
        final NetworkTimeUpdateService networkTimeUpdaterF = networkTimeUpdater;
        final TextServicesManagerService textServiceManagerServiceF = tsms;
        final StatusBarManagerService statusBarF = statusBar;
        ActivityManagerService.self().systemReady(new Runnable(){

            public void run() {
                Slog.i((String)ServerThread.TAG, (String)"Making services ready");
                ServerThread.startSystemUi(contextF);
                try {
                    if (batteryF != null) {
                        batteryF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Battery Service ready", e);
                }
                try {
                    if (networkManagementF != null) {
                        networkManagementF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Network Managment Service ready", e);
                }
                try {
                    if (networkStatsF != null) {
                        networkStatsF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Network Stats Service ready", e);
                }
                try {
                    if (networkPolicyF != null) {
                        networkPolicyF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Network Policy Service ready", e);
                }
                try {
                    if (connectivityF != null) {
                        connectivityF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Connectivity Service ready", e);
                }
                try {
                    if (dockF != null) {
                        dockF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Dock Service ready", e);
                }
                try {
                    if (usbF != null) {
                        usbF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making USB Service ready", e);
                }
                try {
                    if (uiModeF != null) {
                        uiModeF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making UI Mode Service ready", e);
                }
                try {
                    if (recognitionF != null) {
                        recognitionF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Recognition Service ready", e);
                }
                Watchdog.getInstance().start();
                try {
                    if (appWidgetF != null) {
                        appWidgetF.systemReady(safeMode);
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making App Widget Service ready", e);
                }
                try {
                    if (wallpaperF != null) {
                        wallpaperF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Wallpaper Service ready", e);
                }
                try {
                    if (immF != null) {
                        immF.systemReady(statusBarF);
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Input Method Service ready", e);
                }
                try {
                    if (locationF != null) {
                        locationF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Location Service ready", e);
                }
                try {
                    if (countryDetectorF != null) {
                        countryDetectorF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Country Detector Service ready", e);
                }
                try {
                    if (throttleF != null) {
                        throttleF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Throttle Service ready", e);
                }
                try {
                    if (networkTimeUpdaterF != null) {
                        networkTimeUpdaterF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Network Time Service ready", e);
                }
                try {
                    if (textServiceManagerServiceF != null) {
                        textServiceManagerServiceF.systemReady();
                    }
                }
                catch (Throwable e) {
                    ServerThread.this.reportWtf("making Text Services Manager Service ready", e);
                }
            }
        });
        if (StrictMode.conditionallyEnableDebugLogging()) {
            Slog.i((String)TAG, (String)"Enabled StrictMode for system server main thread.");
        }
        Looper.loop();
        Slog.d((String)TAG, (String)"System ServerThread is exiting!");
    }

    static final void startSystemUi(Context context) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.SystemUIService"));
        Slog.d((String)TAG, (String)("Starting service: " + intent));
        context.startService(intent);
    }
}

