/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.backup.BackupAgentHelper;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.app.backup.FullBackup;
import android.app.backup.FullBackupDataOutput;
import android.app.backup.WallpaperBackupHelper;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.os.ServiceManager;
import android.util.Slog;
import com.android.server.WallpaperManagerService;
import java.io.File;
import java.io.IOException;

public class SystemBackupAgent
extends BackupAgentHelper {
    private static final String TAG = "SystemBackupAgent";
    private static final String WALLPAPER_IMAGE_FILENAME = "wallpaper";
    private static final String WALLPAPER_INFO_FILENAME = "wallpaper_info.xml";
    private static final String WALLPAPER_IMAGE_DIR = "/data/data/com.android.settings/files";
    private static final String WALLPAPER_IMAGE = "/data/data/com.android.settings/files/wallpaper";
    private static final String WALLPAPER_INFO_DIR = "/data/system";
    private static final String WALLPAPER_INFO = "/data/system/wallpaper_info.xml";

    public void onBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) throws IOException {
        WallpaperManagerService wallpaper = (WallpaperManagerService)ServiceManager.getService((String)WALLPAPER_IMAGE_FILENAME);
        String[] files = new String[]{WALLPAPER_IMAGE, WALLPAPER_INFO};
        if (wallpaper != null && wallpaper.mName != null && wallpaper.mName.length() > 0) {
            files = new String[]{WALLPAPER_INFO};
        }
        this.addHelper(WALLPAPER_IMAGE_FILENAME, (BackupHelper)new WallpaperBackupHelper((Context)this, files));
        super.onBackup(oldState, data, newState);
    }

    public void onFullBackup(FullBackupDataOutput data) throws IOException {
        this.fullWallpaperBackup(data);
    }

    private void fullWallpaperBackup(FullBackupDataOutput output) {
        FullBackup.backupToTar((String)this.getPackageName(), (String)"r", null, (String)WALLPAPER_INFO_DIR, (String)WALLPAPER_INFO, (BackupDataOutput)output.getData());
        FullBackup.backupToTar((String)this.getPackageName(), (String)"r", null, (String)WALLPAPER_IMAGE_DIR, (String)WALLPAPER_IMAGE, (BackupDataOutput)output.getData());
    }

    public void onRestore(BackupDataInput data, int appVersionCode, ParcelFileDescriptor newState) throws IOException {
        this.addHelper(WALLPAPER_IMAGE_FILENAME, (BackupHelper)new WallpaperBackupHelper((Context)this, new String[]{WALLPAPER_IMAGE, WALLPAPER_INFO}));
        this.addHelper("system_files", (BackupHelper)new WallpaperBackupHelper((Context)this, new String[]{WALLPAPER_IMAGE}));
        try {
            super.onRestore(data, appVersionCode, newState);
            WallpaperManagerService wallpaper = (WallpaperManagerService)ServiceManager.getService((String)WALLPAPER_IMAGE_FILENAME);
            wallpaper.settingsRestored();
        }
        catch (IOException ex) {
            Slog.d((String)TAG, (String)"restore failed", (Throwable)ex);
            new File(WALLPAPER_IMAGE).delete();
            new File(WALLPAPER_INFO).delete();
        }
    }

    public void onRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime) throws IOException {
        block8: {
            Slog.i((String)TAG, (String)("Restoring file domain=" + domain + " path=" + path));
            boolean restoredWallpaper = false;
            File outFile = null;
            if (domain.equals("r")) {
                if (path.equals(WALLPAPER_INFO_FILENAME)) {
                    outFile = new File(WALLPAPER_INFO);
                    restoredWallpaper = true;
                } else if (path.equals(WALLPAPER_IMAGE_FILENAME)) {
                    outFile = new File(WALLPAPER_IMAGE);
                    restoredWallpaper = true;
                }
            }
            try {
                if (outFile == null) {
                    Slog.w((String)TAG, (String)("Skipping unrecognized system file: [ " + domain + " : " + path + " ]"));
                }
                FullBackup.restoreFile((ParcelFileDescriptor)data, (long)size, (int)type, (long)mode, (long)mtime, (File)outFile);
                if (restoredWallpaper) {
                    WallpaperManagerService wallpaper = (WallpaperManagerService)ServiceManager.getService((String)WALLPAPER_IMAGE_FILENAME);
                    wallpaper.settingsRestored();
                }
            }
            catch (IOException e) {
                if (!restoredWallpaper) break block8;
                new File(WALLPAPER_IMAGE).delete();
                new File(WALLPAPER_INFO).delete();
            }
        }
    }
}

