/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.net.INetworkManagementEventObserver;
import android.net.IThrottleManager;
import android.net.NetworkStats;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.NtpTrustedTime;
import android.util.Slog;
import android.util.TrustedTime;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ThrottleService
extends IThrottleManager.Stub {
    private static final String TESTING_ENABLED_PROPERTY = "persist.throttle.testing";
    private static final String TAG = "ThrottleService";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private Handler mHandler;
    private HandlerThread mThread;
    private Context mContext;
    private static final int INITIAL_POLL_DELAY_SEC = 90;
    private static final int TESTING_POLLING_PERIOD_SEC = 60;
    private static final int TESTING_RESET_PERIOD_SEC = 600;
    private static final long TESTING_THRESHOLD = 0x100000L;
    private static final long MAX_NTP_CACHE_AGE = 86400000L;
    private long mMaxNtpCacheAge = 86400000L;
    private int mPolicyPollPeriodSec;
    private AtomicLong mPolicyThreshold;
    private AtomicInteger mPolicyThrottleValue;
    private int mPolicyResetDay;
    private int mPolicyNotificationsAllowedMask;
    private long mLastRead;
    private long mLastWrite;
    private static final String ACTION_POLL = "com.android.server.ThrottleManager.action.POLL";
    private static int POLL_REQUEST = 0;
    private PendingIntent mPendingPollIntent;
    private static final String ACTION_RESET = "com.android.server.ThorottleManager.action.RESET";
    private static int RESET_REQUEST = 1;
    private PendingIntent mPendingResetIntent;
    private INetworkManagementService mNMService;
    private AlarmManager mAlarmManager;
    private NotificationManager mNotificationManager;
    private DataRecorder mRecorder;
    private String mIface;
    private static final int NOTIFICATION_WARNING = 2;
    private Notification mThrottlingNotification;
    private boolean mWarningNotificationSent = false;
    private InterfaceObserver mInterfaceObserver;
    private SettingsObserver mSettingsObserver;
    private AtomicInteger mThrottleIndex;
    private static final int THROTTLE_INDEX_UNINITIALIZED = -1;
    private static final int THROTTLE_INDEX_UNTHROTTLED = 0;
    private Intent mPollStickyBroadcast;
    private TrustedTime mTime;
    private static final int EVENT_REBOOT_RECOVERY = 0;
    private static final int EVENT_POLICY_CHANGED = 1;
    private static final int EVENT_POLL_ALARM = 2;
    private static final int EVENT_RESET_ALARM = 3;
    private static final int EVENT_IFACE_UP = 4;

    private static INetworkManagementService getNetworkManagementService() {
        IBinder b = ServiceManager.getService((String)"network_management");
        return INetworkManagementService.Stub.asInterface((IBinder)b);
    }

    public ThrottleService(Context context) {
        this(context, ThrottleService.getNetworkManagementService(), (TrustedTime)NtpTrustedTime.getInstance((Context)context), context.getResources().getString(17039390));
    }

    public ThrottleService(Context context, INetworkManagementService nmService, TrustedTime time, String iface) {
        this.mContext = context;
        this.mPolicyThreshold = new AtomicLong();
        this.mPolicyThrottleValue = new AtomicInteger();
        this.mThrottleIndex = new AtomicInteger();
        this.mIface = iface;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent pollIntent = new Intent(ACTION_POLL, null);
        this.mPendingPollIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)POLL_REQUEST, (Intent)pollIntent, (int)0);
        Intent resetIntent = new Intent(ACTION_RESET, null);
        this.mPendingResetIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)RESET_REQUEST, (Intent)resetIntent, (int)0);
        this.mNMService = nmService;
        this.mTime = time;
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
    }

    private long ntpToWallTime(long ntpTime) {
        long bestNow = this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
        long localNow = System.currentTimeMillis();
        return localNow + (ntpTime - bestNow);
    }

    public long getResetTime(String iface) {
        this.enforceAccessPermission();
        long resetTime = 0L;
        if (this.mRecorder != null) {
            resetTime = this.mRecorder.getPeriodEnd();
        }
        resetTime = this.ntpToWallTime(resetTime);
        return resetTime;
    }

    public long getPeriodStartTime(String iface) {
        long startTime = 0L;
        this.enforceAccessPermission();
        if (this.mRecorder != null) {
            startTime = this.mRecorder.getPeriodStart();
        }
        startTime = this.ntpToWallTime(startTime);
        return startTime;
    }

    public long getCliffThreshold(String iface, int cliff) {
        this.enforceAccessPermission();
        if (cliff == 1) {
            return this.mPolicyThreshold.get();
        }
        return 0L;
    }

    public int getCliffLevel(String iface, int cliff) {
        this.enforceAccessPermission();
        if (cliff == 1) {
            return this.mPolicyThrottleValue.get();
        }
        return 0;
    }

    public String getHelpUri() {
        this.enforceAccessPermission();
        return Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"throttle_help_uri");
    }

    public long getByteCount(String iface, int dir, int period, int ago) {
        this.enforceAccessPermission();
        if (period == 0 && this.mRecorder != null) {
            if (dir == 0) {
                return this.mRecorder.getPeriodTx(ago);
            }
            if (dir == 1) {
                return this.mRecorder.getPeriodRx(ago);
            }
        }
        return 0L;
    }

    public int getThrottle(String iface) {
        this.enforceAccessPermission();
        if (this.mThrottleIndex.get() == 1) {
            return this.mPolicyThrottleValue.get();
        }
        return 0;
    }

    void systemReady() {
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ThrottleService.this.dispatchPoll();
            }
        }, new IntentFilter(ACTION_POLL));
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ThrottleService.this.dispatchReset();
            }
        }, new IntentFilter(ACTION_RESET));
        this.mThread = new HandlerThread(TAG);
        this.mThread.start();
        this.mHandler = new MyHandler(this.mThread.getLooper());
        this.mHandler.obtainMessage(0).sendToTarget();
        this.mInterfaceObserver = new InterfaceObserver(this.mHandler, 4, this.mIface);
        try {
            this.mNMService.registerObserver((INetworkManagementEventObserver)this.mInterfaceObserver);
        }
        catch (RemoteException e) {
            Slog.e((String)TAG, (String)("Could not register InterfaceObserver " + (Object)((Object)e)));
        }
        this.mSettingsObserver = new SettingsObserver(this.mHandler, 1);
        this.mSettingsObserver.register(this.mContext);
    }

    void shutdown() {
        if (this.mThread != null) {
            this.mThread.quit();
        }
        if (this.mSettingsObserver != null) {
            this.mSettingsObserver.unregister(this.mContext);
        }
        if (this.mPollStickyBroadcast != null) {
            this.mContext.removeStickyBroadcast(this.mPollStickyBroadcast);
        }
    }

    void dispatchPoll() {
        this.mHandler.obtainMessage(2).sendToTarget();
    }

    void dispatchReset() {
        this.mHandler.obtainMessage(3).sendToTarget();
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ThrottleService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println();
        pw.println("The threshold is " + this.mPolicyThreshold.get() + ", after which you experince throttling to " + this.mPolicyThrottleValue.get() + "kbps");
        pw.println("Current period is " + (this.mRecorder.getPeriodEnd() - this.mRecorder.getPeriodStart()) / 1000L + " seconds long " + "and ends in " + (this.getResetTime(this.mIface) - System.currentTimeMillis()) / 1000L + " seconds.");
        pw.println("Polling every " + this.mPolicyPollPeriodSec + " seconds");
        pw.println("Current Throttle Index is " + this.mThrottleIndex.get());
        pw.println("mMaxNtpCacheAge=" + this.mMaxNtpCacheAge);
        for (int i = 0; i < this.mRecorder.getPeriodCount(); ++i) {
            pw.println(" Period[" + i + "] - read:" + this.mRecorder.getPeriodRx(i) + ", written:" + this.mRecorder.getPeriodTx(i));
        }
    }

    private static class DataRecorder {
        long[] mPeriodRxData;
        long[] mPeriodTxData;
        int mCurrentPeriod;
        int mPeriodCount;
        Calendar mPeriodStart;
        Calendar mPeriodEnd;
        ThrottleService mParent;
        Context mContext;
        String mImsi = null;
        TelephonyManager mTelephonyManager;
        private static final int MAX_SIMS_SUPPORTED = 3;
        private static final int DATA_FILE_VERSION = 1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DataRecorder(Context context, ThrottleService parent) {
            this.mContext = context;
            this.mParent = parent;
            this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            ThrottleService throttleService = this.mParent;
            synchronized (throttleService) {
                this.mPeriodCount = 6;
                this.mPeriodRxData = new long[this.mPeriodCount];
                this.mPeriodTxData = new long[this.mPeriodCount];
                this.mPeriodStart = Calendar.getInstance();
                this.mPeriodEnd = Calendar.getInstance();
                this.retrieve();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setNextPeriod(Calendar start, Calendar end) {
            this.checkForSubscriberId();
            boolean startNewPeriod = true;
            if (start.equals(this.mPeriodStart) && end.equals(this.mPeriodEnd)) {
                startNewPeriod = false;
            } else {
                ThrottleService throttleService = this.mParent;
                synchronized (throttleService) {
                    ++this.mCurrentPeriod;
                    if (this.mCurrentPeriod >= this.mPeriodCount) {
                        this.mCurrentPeriod = 0;
                    }
                    this.mPeriodRxData[this.mCurrentPeriod] = 0L;
                    this.mPeriodTxData[this.mCurrentPeriod] = 0L;
                }
            }
            this.setPeriodStart(start);
            this.setPeriodEnd(end);
            this.record();
            return startNewPeriod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getPeriodEnd() {
            ThrottleService throttleService = this.mParent;
            synchronized (throttleService) {
                return this.mPeriodEnd.getTimeInMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setPeriodEnd(Calendar end) {
            ThrottleService throttleService = this.mParent;
            synchronized (throttleService) {
                this.mPeriodEnd = end;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getPeriodStart() {
            ThrottleService throttleService = this.mParent;
            synchronized (throttleService) {
                return this.mPeriodStart.getTimeInMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setPeriodStart(Calendar start) {
            ThrottleService throttleService = this.mParent;
            synchronized (throttleService) {
                this.mPeriodStart = start;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPeriodCount() {
            ThrottleService throttleService = this.mParent;
            synchronized (throttleService) {
                return this.mPeriodCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zeroData(int field) {
            ThrottleService throttleService = this.mParent;
            synchronized (throttleService) {
                for (int period = 0; period < this.mPeriodCount; ++period) {
                    this.mPeriodRxData[period] = 0L;
                    this.mPeriodTxData[period] = 0L;
                }
                this.mCurrentPeriod = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addData(long bytesRead, long bytesWritten) {
            this.checkForSubscriberId();
            ThrottleService throttleService = this.mParent;
            synchronized (throttleService) {
                int n = this.mCurrentPeriod;
                this.mPeriodRxData[n] = this.mPeriodRxData[n] + bytesRead;
                int n2 = this.mCurrentPeriod;
                this.mPeriodTxData[n2] = this.mPeriodTxData[n2] + bytesWritten;
            }
            this.record();
        }

        private File getDataFile() {
            File dataFile;
            File dataDir = Environment.getDataDirectory();
            File throttleDir = new File(dataDir, "system/throttle");
            throttleDir.mkdirs();
            String mImsi = this.mTelephonyManager.getSubscriberId();
            if (mImsi == null) {
                dataFile = this.useMRUFile(throttleDir);
            } else {
                String imsiHash = Integer.toString(mImsi.hashCode());
                dataFile = new File(throttleDir, imsiHash);
            }
            dataFile.setLastModified(System.currentTimeMillis());
            this.checkAndDeleteLRUDataFile(throttleDir);
            return dataFile;
        }

        private void checkForSubscriberId() {
            if (this.mImsi != null) {
                return;
            }
            this.mImsi = this.mTelephonyManager.getSubscriberId();
            if (this.mImsi == null) {
                return;
            }
            this.retrieve();
        }

        private void checkAndDeleteLRUDataFile(File dir) {
            File[] files = dir.listFiles();
            if (files == null || files.length <= 3) {
                return;
            }
            Slog.d((String)ThrottleService.TAG, (String)"Too many data files");
            do {
                File oldest = null;
                for (File f : files) {
                    if (oldest != null && oldest.lastModified() <= f.lastModified()) continue;
                    oldest = f;
                }
                if (oldest == null) {
                    return;
                }
                Slog.d((String)ThrottleService.TAG, (String)(" deleting " + oldest));
                oldest.delete();
            } while ((files = dir.listFiles()).length > 3);
        }

        private File useMRUFile(File dir) {
            File newest = null;
            File[] files = dir.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (newest != null && newest.lastModified() >= f.lastModified()) continue;
                    newest = f;
                }
            }
            if (newest == null) {
                newest = new File(dir, "temp");
            }
            return newest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void record() {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append(1);
            builder.append(":");
            builder.append(this.mPeriodCount);
            builder.append(":");
            for (i = 0; i < this.mPeriodCount; ++i) {
                builder.append(this.mPeriodRxData[i]);
                builder.append(":");
            }
            for (i = 0; i < this.mPeriodCount; ++i) {
                builder.append(this.mPeriodTxData[i]);
                builder.append(":");
            }
            builder.append(this.mCurrentPeriod);
            builder.append(":");
            builder.append(this.mPeriodStart.getTimeInMillis());
            builder.append(":");
            builder.append(this.mPeriodEnd.getTimeInMillis());
            BufferedWriter out = null;
            out = new BufferedWriter(new FileWriter(this.getDataFile()), 256);
            out.write(builder.toString());
            Object var5_4 = null;
            if (out == null) return;
            try {
                out.close();
                return;
            }
            catch (Exception e2) {}
            return;
            {
                catch (IOException e) {
                    Slog.e((String)ThrottleService.TAG, (String)"Error writing data file");
                    Object var5_5 = null;
                    if (out == null) return;
                    try {
                        out.close();
                        return;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void retrieve() {
            block22: {
                this.zeroData(0);
                f = this.getDataFile();
                s = null;
                try {
                    buffer = new byte[(int)f.length()];
                    s = new FileInputStream(f);
                    s.read(buffer);
                    var6_4 = null;
                    ** if (s == null) goto lbl-1000
                }
                catch (Throwable var5_14) {
                    var6_6 = null;
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw var5_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        s.close();
                    }
                    catch (Exception e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block22;
                    catch (IOException e) {
                        Slog.e((String)"ThrottleService", (String)"Error reading data file");
                        var6_5 = null;
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
            }
            if ((data = new String(buffer)) == null || data.length() == 0) {
                Slog.d((String)"ThrottleService", (String)"data file empty");
                return;
            }
            parsed = data.split(":");
            parsedUsed = 0;
            if (parsed.length < 6) {
                Slog.e((String)"ThrottleService", (String)"reading data file with insufficient length - ignoring");
                return;
            }
            try {
                if (Integer.parseInt(parsed[parsedUsed++]) != 1) {
                    Slog.e((String)"ThrottleService", (String)"reading data file with bad version - ignoring");
                    return;
                }
                if (parsed.length != 5 + 2 * (periodCount = Integer.parseInt(parsed[parsedUsed++]))) {
                    Slog.e((String)"ThrottleService", (String)("reading data file with bad length (" + parsed.length + " != " + (5 + 2 * periodCount) + ") - ignoring"));
                    return;
                }
                periodRxData = new long[periodCount];
                for (i = 0; i < periodCount; ++i) {
                    periodRxData[i] = Long.parseLong(parsed[parsedUsed++]);
                }
                periodTxData = new long[periodCount];
                for (i = 0; i < periodCount; ++i) {
                    periodTxData[i] = Long.parseLong(parsed[parsedUsed++]);
                }
                currentPeriod = Integer.parseInt(parsed[parsedUsed++]);
                periodStart = new GregorianCalendar();
                periodStart.setTimeInMillis(Long.parseLong(parsed[parsedUsed++]));
                periodEnd = new GregorianCalendar();
                periodEnd.setTimeInMillis(Long.parseLong(parsed[parsedUsed++]));
            }
            catch (Exception e) {
                Slog.e((String)"ThrottleService", (String)"Error parsing data file - ignoring");
                return;
            }
            var13_19 = this.mParent;
            synchronized (var13_19) {
                this.mPeriodCount = periodCount;
                this.mPeriodRxData = periodRxData;
                this.mPeriodTxData = periodTxData;
                this.mCurrentPeriod = currentPeriod;
                this.mPeriodStart = periodStart;
                this.mPeriodEnd = periodEnd;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getPeriodRx(int which) {
            ThrottleService throttleService = this.mParent;
            synchronized (throttleService) {
                if (which > this.mPeriodCount) {
                    return 0L;
                }
                if ((which = this.mCurrentPeriod - which) < 0) {
                    which += this.mPeriodCount;
                }
                return this.mPeriodRxData[which];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getPeriodTx(int which) {
            ThrottleService throttleService = this.mParent;
            synchronized (throttleService) {
                if (which > this.mPeriodCount) {
                    return 0L;
                }
                if ((which = this.mCurrentPeriod - which) < 0) {
                    which += this.mPeriodCount;
                }
                return this.mPeriodTxData[which];
            }
        }
    }

    private class MyHandler
    extends Handler {
        public MyHandler(Looper l) {
            super(l);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.onRebootRecovery();
                    break;
                }
                case 1: {
                    this.onPolicyChanged();
                    break;
                }
                case 2: {
                    this.onPollAlarm();
                    break;
                }
                case 3: {
                    this.onResetAlarm();
                    break;
                }
                case 4: {
                    this.onIfaceUp();
                }
            }
        }

        private void onRebootRecovery() {
            ThrottleService.this.mThrottleIndex.set(-1);
            ThrottleService.this.mRecorder = new DataRecorder(ThrottleService.this.mContext, ThrottleService.this);
            ThrottleService.this.mHandler.obtainMessage(1).sendToTarget();
            ThrottleService.this.mHandler.sendMessageDelayed(ThrottleService.this.mHandler.obtainMessage(2), 90000L);
        }

        private void onPolicyChanged() {
            boolean testing = SystemProperties.get((String)ThrottleService.TESTING_ENABLED_PROPERTY).equals("true");
            int pollingPeriod = ThrottleService.this.mContext.getResources().getInteger(17694753);
            ThrottleService.this.mPolicyPollPeriodSec = Settings.Secure.getInt((ContentResolver)ThrottleService.this.mContext.getContentResolver(), (String)"throttle_polling_sec", (int)pollingPeriod);
            long defaultThreshold = ThrottleService.this.mContext.getResources().getInteger(17694754);
            int defaultValue = ThrottleService.this.mContext.getResources().getInteger(17694755);
            long threshold = Settings.Secure.getLong((ContentResolver)ThrottleService.this.mContext.getContentResolver(), (String)"throttle_threshold_bytes", (long)defaultThreshold);
            int value = Settings.Secure.getInt((ContentResolver)ThrottleService.this.mContext.getContentResolver(), (String)"throttle_value_kbitsps", (int)defaultValue);
            ThrottleService.this.mPolicyThreshold.set(threshold);
            ThrottleService.this.mPolicyThrottleValue.set(value);
            if (testing) {
                ThrottleService.this.mPolicyPollPeriodSec = 60;
                ThrottleService.this.mPolicyThreshold.set(0x100000L);
            }
            ThrottleService.this.mPolicyResetDay = Settings.Secure.getInt((ContentResolver)ThrottleService.this.mContext.getContentResolver(), (String)"throttle_reset_day", (int)-1);
            if (ThrottleService.this.mPolicyResetDay == -1 || ThrottleService.this.mPolicyResetDay < 1 || ThrottleService.this.mPolicyResetDay > 28) {
                Random g = new Random();
                ThrottleService.this.mPolicyResetDay = 1 + g.nextInt(28);
                Settings.Secure.putInt((ContentResolver)ThrottleService.this.mContext.getContentResolver(), (String)"throttle_reset_day", (int)ThrottleService.this.mPolicyResetDay);
            }
            if (ThrottleService.this.mIface == null) {
                ThrottleService.this.mPolicyThreshold.set(0L);
            }
            int defaultNotificationType = ThrottleService.this.mContext.getResources().getInteger(17694756);
            ThrottleService.this.mPolicyNotificationsAllowedMask = Settings.Secure.getInt((ContentResolver)ThrottleService.this.mContext.getContentResolver(), (String)"throttle_notification_type", (int)defaultNotificationType);
            int maxNtpCacheAgeSec = Settings.Secure.getInt((ContentResolver)ThrottleService.this.mContext.getContentResolver(), (String)"throttle_max_ntp_cache_age_sec", (int)86400);
            ThrottleService.this.mMaxNtpCacheAge = maxNtpCacheAgeSec * 1000;
            if (ThrottleService.this.mPolicyThreshold.get() != 0L) {
                Slog.d((String)ThrottleService.TAG, (String)("onPolicyChanged testing=" + testing + ", period=" + ThrottleService.this.mPolicyPollPeriodSec + ", threshold=" + ThrottleService.this.mPolicyThreshold.get() + ", value=" + ThrottleService.this.mPolicyThrottleValue.get() + ", resetDay=" + ThrottleService.this.mPolicyResetDay + ", noteType=" + ThrottleService.this.mPolicyNotificationsAllowedMask + ", mMaxNtpCacheAge=" + ThrottleService.this.mMaxNtpCacheAge));
            }
            ThrottleService.this.mThrottleIndex.set(-1);
            this.onResetAlarm();
            this.onPollAlarm();
            Intent broadcast = new Intent("android.net.thrott.POLICY_CHANGED_ACTION");
            ThrottleService.this.mContext.sendBroadcast(broadcast);
        }

        private void onPollAlarm() {
            long now = SystemClock.elapsedRealtime();
            long next = now + (long)(ThrottleService.this.mPolicyPollPeriodSec * 1000);
            if (ThrottleService.this.mTime.getCacheAge() > ThrottleService.this.mMaxNtpCacheAge && ThrottleService.this.mTime.forceRefresh()) {
                ThrottleService.this.dispatchReset();
            }
            long incRead = 0L;
            long incWrite = 0L;
            try {
                NetworkStats stats = ThrottleService.this.mNMService.getNetworkStatsSummary();
                int index = stats.findIndex(ThrottleService.this.mIface, -1, 0, 0);
                if (index != -1) {
                    NetworkStats.Entry entry = stats.getValues(index, null);
                    incRead = entry.rxBytes - ThrottleService.this.mLastRead;
                    incWrite = entry.txBytes - ThrottleService.this.mLastWrite;
                } else {
                    Slog.w((String)ThrottleService.TAG, (String)("unable to find stats for iface " + ThrottleService.this.mIface));
                }
                if (incRead < 0L || incWrite < 0L) {
                    incRead += ThrottleService.this.mLastRead;
                    incWrite += ThrottleService.this.mLastWrite;
                    ThrottleService.this.mLastRead = 0L;
                    ThrottleService.this.mLastWrite = 0L;
                }
            }
            catch (IllegalStateException e) {
                Slog.e((String)ThrottleService.TAG, (String)("problem during onPollAlarm: " + e));
            }
            catch (RemoteException e) {
                Slog.e((String)ThrottleService.TAG, (String)("problem during onPollAlarm: " + (Object)((Object)e)));
            }
            boolean roaming = "true".equals(SystemProperties.get((String)"gsm.operator.isroaming"));
            if (!roaming) {
                ThrottleService.this.mRecorder.addData(incRead, incWrite);
            }
            long periodRx = ThrottleService.this.mRecorder.getPeriodRx(0);
            long periodTx = ThrottleService.this.mRecorder.getPeriodTx(0);
            long total = periodRx + periodTx;
            if (ThrottleService.this.mPolicyThreshold.get() != 0L) {
                Slog.d((String)ThrottleService.TAG, (String)("onPollAlarm - roaming =" + roaming + ", read =" + incRead + ", written =" + incWrite + ", new total =" + total));
            }
            ThrottleService.this.mLastRead += incRead;
            ThrottleService.this.mLastWrite += incWrite;
            this.checkThrottleAndPostNotification(total);
            Intent broadcast = new Intent("android.net.thrott.POLL_ACTION");
            broadcast.putExtra("cycleRead", periodRx);
            broadcast.putExtra("cycleWrite", periodTx);
            broadcast.putExtra("cycleStart", ThrottleService.this.getPeriodStartTime(ThrottleService.this.mIface));
            broadcast.putExtra("cycleEnd", ThrottleService.this.getResetTime(ThrottleService.this.mIface));
            ThrottleService.this.mContext.sendStickyBroadcast(broadcast);
            ThrottleService.this.mPollStickyBroadcast = broadcast;
            ThrottleService.this.mAlarmManager.cancel(ThrottleService.this.mPendingPollIntent);
            ThrottleService.this.mAlarmManager.set(3, next, ThrottleService.this.mPendingPollIntent);
        }

        private void onIfaceUp() {
            if (ThrottleService.this.mThrottleIndex.get() == 1) {
                try {
                    ThrottleService.this.mNMService.setInterfaceThrottle(ThrottleService.this.mIface, -1, -1);
                    ThrottleService.this.mNMService.setInterfaceThrottle(ThrottleService.this.mIface, ThrottleService.this.mPolicyThrottleValue.get(), ThrottleService.this.mPolicyThrottleValue.get());
                }
                catch (Exception e) {
                    Slog.e((String)ThrottleService.TAG, (String)("error setting Throttle: " + e));
                }
            }
        }

        private void checkThrottleAndPostNotification(long currentTotal) {
            long threshold = ThrottleService.this.mPolicyThreshold.get();
            if (threshold == 0L) {
                this.clearThrottleAndNotification();
                return;
            }
            if (!ThrottleService.this.mTime.hasCache()) {
                Slog.w((String)ThrottleService.TAG, (String)"missing trusted time, skipping throttle check");
                return;
            }
            if (currentTotal > threshold) {
                if (ThrottleService.this.mThrottleIndex.get() != 1) {
                    ThrottleService.this.mThrottleIndex.set(1);
                    Slog.d((String)ThrottleService.TAG, (String)("Threshold " + threshold + " exceeded!"));
                    try {
                        ThrottleService.this.mNMService.setInterfaceThrottle(ThrottleService.this.mIface, ThrottleService.this.mPolicyThrottleValue.get(), ThrottleService.this.mPolicyThrottleValue.get());
                    }
                    catch (Exception e) {
                        Slog.e((String)ThrottleService.TAG, (String)("error setting Throttle: " + e));
                    }
                    ThrottleService.this.mNotificationManager.cancel(17302839);
                    this.postNotification(17040468, 17040469, 17302839, 2);
                    Intent broadcast = new Intent("android.net.thrott.THROTTLE_ACTION");
                    broadcast.putExtra("level", ThrottleService.this.mPolicyThrottleValue.get());
                    ThrottleService.this.mContext.sendStickyBroadcast(broadcast);
                }
            } else {
                this.clearThrottleAndNotification();
                if ((ThrottleService.this.mPolicyNotificationsAllowedMask & 2) != 0) {
                    long start = ThrottleService.this.mRecorder.getPeriodStart();
                    long end = ThrottleService.this.mRecorder.getPeriodEnd();
                    long periodLength = end - start;
                    long now = System.currentTimeMillis();
                    long timeUsed = now - start;
                    long warningThreshold = 2L * threshold * timeUsed / (timeUsed + periodLength);
                    if (currentTotal > warningThreshold && currentTotal > threshold / 4L) {
                        if (!ThrottleService.this.mWarningNotificationSent) {
                            ThrottleService.this.mWarningNotificationSent = true;
                            ThrottleService.this.mNotificationManager.cancel(17302839);
                            this.postNotification(17040466, 17040467, 17302839, 0);
                        }
                    } else if (ThrottleService.this.mWarningNotificationSent) {
                        ThrottleService.this.mNotificationManager.cancel(17302839);
                        ThrottleService.this.mWarningNotificationSent = false;
                    }
                }
            }
        }

        private void postNotification(int titleInt, int messageInt, int icon, int flags) {
            Intent intent = new Intent();
            intent.setClassName("com.android.phone", "com.android.phone.DataUsage");
            intent.setFlags(0x40000000);
            PendingIntent pi = PendingIntent.getActivity((Context)ThrottleService.this.mContext, (int)0, (Intent)intent, (int)0);
            Resources r = Resources.getSystem();
            CharSequence title = r.getText(titleInt);
            CharSequence message = r.getText(messageInt);
            if (ThrottleService.this.mThrottlingNotification == null) {
                ThrottleService.this.mThrottlingNotification = new Notification();
                ((ThrottleService)ThrottleService.this).mThrottlingNotification.when = 0L;
                ((ThrottleService)ThrottleService.this).mThrottlingNotification.icon = icon;
                ((ThrottleService)ThrottleService.this).mThrottlingNotification.defaults &= 0xFFFFFFFE;
            }
            ((ThrottleService)ThrottleService.this).mThrottlingNotification.flags = flags;
            ((ThrottleService)ThrottleService.this).mThrottlingNotification.tickerText = title;
            ThrottleService.this.mThrottlingNotification.setLatestEventInfo(ThrottleService.this.mContext, title, message, pi);
            ThrottleService.this.mNotificationManager.notify(((ThrottleService)ThrottleService.this).mThrottlingNotification.icon, ThrottleService.this.mThrottlingNotification);
        }

        private void clearThrottleAndNotification() {
            if (ThrottleService.this.mThrottleIndex.get() != 0) {
                ThrottleService.this.mThrottleIndex.set(0);
                try {
                    ThrottleService.this.mNMService.setInterfaceThrottle(ThrottleService.this.mIface, -1, -1);
                }
                catch (Exception e) {
                    Slog.e((String)ThrottleService.TAG, (String)("error clearing Throttle: " + e));
                }
                Intent broadcast = new Intent("android.net.thrott.THROTTLE_ACTION");
                broadcast.putExtra("level", -1);
                ThrottleService.this.mContext.sendStickyBroadcast(broadcast);
                ThrottleService.this.mNotificationManager.cancel(17302839);
                ThrottleService.this.mWarningNotificationSent = false;
            }
        }

        private Calendar calculatePeriodEnd(long now) {
            Calendar end = GregorianCalendar.getInstance();
            end.setTimeInMillis(now);
            int day = end.get(5);
            end.set(5, ThrottleService.this.mPolicyResetDay);
            end.set(11, 0);
            end.set(12, 0);
            end.set(13, 0);
            end.set(14, 0);
            if (day >= ThrottleService.this.mPolicyResetDay) {
                int month = end.get(2);
                if (month == 11) {
                    end.set(1, end.get(1) + 1);
                    month = -1;
                }
                end.set(2, month + 1);
            }
            if (SystemProperties.get((String)ThrottleService.TESTING_ENABLED_PROPERTY).equals("true")) {
                end = GregorianCalendar.getInstance();
                end.setTimeInMillis(now);
                end.add(13, 600);
            }
            return end;
        }

        private Calendar calculatePeriodStart(Calendar end) {
            Calendar start = (Calendar)end.clone();
            int month = end.get(2);
            if (end.get(2) == 0) {
                month = 12;
                start.set(1, start.get(1) - 1);
            }
            start.set(2, month - 1);
            if (SystemProperties.get((String)ThrottleService.TESTING_ENABLED_PROPERTY).equals("true")) {
                start = (Calendar)end.clone();
                start.add(13, -600);
            }
            return start;
        }

        private void onResetAlarm() {
            if (ThrottleService.this.mPolicyThreshold.get() != 0L) {
                Slog.d((String)ThrottleService.TAG, (String)("onResetAlarm - last period had " + ThrottleService.this.mRecorder.getPeriodRx(0) + " bytes read and " + ThrottleService.this.mRecorder.getPeriodTx(0) + " written"));
            }
            if (ThrottleService.this.mTime.getCacheAge() > ThrottleService.this.mMaxNtpCacheAge) {
                ThrottleService.this.mTime.forceRefresh();
            }
            if (ThrottleService.this.mTime.hasCache()) {
                long now = ThrottleService.this.mTime.currentTimeMillis();
                Calendar end = this.calculatePeriodEnd(now);
                Calendar start = this.calculatePeriodStart(end);
                if (ThrottleService.this.mRecorder.setNextPeriod(start, end)) {
                    this.onPollAlarm();
                }
                ThrottleService.this.mAlarmManager.cancel(ThrottleService.this.mPendingResetIntent);
                long offset = end.getTimeInMillis() - now;
                ThrottleService.this.mAlarmManager.set(3, SystemClock.elapsedRealtime() + offset, ThrottleService.this.mPendingResetIntent);
            }
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private int mMsg;
        private Handler mHandler;

        SettingsObserver(Handler handler, int msg) {
            super(handler);
            this.mHandler = handler;
            this.mMsg = msg;
        }

        void register(Context context) {
            ContentResolver resolver = context.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"throttle_polling_sec"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"throttle_threshold_bytes"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"throttle_value_kbitsps"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"throttle_reset_day"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"throttle_notification_type"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"throttle_help_uri"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"throttle_max_ntp_cache_age_sec"), false, (ContentObserver)this);
        }

        void unregister(Context context) {
            ContentResolver resolver = context.getContentResolver();
            resolver.unregisterContentObserver((ContentObserver)this);
        }

        public void onChange(boolean selfChange) {
            this.mHandler.obtainMessage(this.mMsg).sendToTarget();
        }
    }

    private static class InterfaceObserver
    extends INetworkManagementEventObserver.Stub {
        private int mMsg;
        private Handler mHandler;
        private String mIface;

        InterfaceObserver(Handler handler, int msg, String iface) {
            this.mHandler = handler;
            this.mMsg = msg;
            this.mIface = iface;
        }

        public void interfaceStatusChanged(String iface, boolean up) {
            if (up && TextUtils.equals((CharSequence)iface, (CharSequence)this.mIface)) {
                this.mHandler.obtainMessage(this.mMsg).sendToTarget();
            }
        }

        public void interfaceLinkStateChanged(String iface, boolean up) {
        }

        public void interfaceAdded(String iface) {
            if (TextUtils.equals((CharSequence)iface, (CharSequence)this.mIface)) {
                this.mHandler.obtainMessage(this.mMsg).sendToTarget();
            }
        }

        public void interfaceRemoved(String iface) {
        }

        public void limitReached(String limitName, String iface) {
        }
    }
}

