/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.IUiModeManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.format.Time;
import android.util.Slog;
import com.android.internal.app.DisableCarModeActivity;
import com.android.server.TwilightCalculator;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Iterator;

class UiModeManagerService
extends IUiModeManager.Stub {
    private static final String TAG = UiModeManager.class.getSimpleName();
    private static final boolean LOG = false;
    private static final String KEY_LAST_UPDATE_INTERVAL = "LAST_UPDATE_INTERVAL";
    private static final boolean ENABLE_LAUNCH_CAR_DOCK_APP = true;
    private static final boolean ENABLE_LAUNCH_DESK_DOCK_APP = true;
    private static final int MSG_UPDATE_TWILIGHT = 0;
    private static final int MSG_ENABLE_LOCATION_UPDATES = 1;
    private static final int MSG_GET_NEW_LOCATION_UPDATE = 2;
    private static final long LOCATION_UPDATE_MS = 86400000L;
    private static final long MIN_LOCATION_UPDATE_MS = 1800000L;
    private static final float LOCATION_UPDATE_DISTANCE_METER = 20000.0f;
    private static final long LOCATION_UPDATE_ENABLE_INTERVAL_MIN = 5000L;
    private static final long LOCATION_UPDATE_ENABLE_INTERVAL_MAX = 900000L;
    private static final double FACTOR_GMT_OFFSET_LONGITUDE = 0.004166666666666667;
    private static final String ACTION_UPDATE_NIGHT_MODE = "com.android.server.action.UPDATE_NIGHT_MODE";
    private final Context mContext;
    final Object mLock = new Object();
    private int mDockState = 0;
    private int mLastBroadcastState = 0;
    private int mNightMode = 1;
    private boolean mCarModeEnabled = false;
    private boolean mCharging = false;
    private final boolean mCarModeKeepsScreenOn;
    private final boolean mDeskModeKeepsScreenOn;
    private boolean mComputedNightMode;
    private int mCurUiMode = 0;
    private int mSetUiMode = 0;
    private boolean mHoldingConfiguration = false;
    private Configuration mConfiguration = new Configuration();
    private boolean mSystemReady;
    private NotificationManager mNotificationManager;
    private AlarmManager mAlarmManager;
    private LocationManager mLocationManager;
    private Location mLocation;
    private StatusBarManager mStatusBarManager;
    private final PowerManager.WakeLock mWakeLock;
    private final BroadcastReceiver mResultReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (this.getResultCode() != -1) {
                return;
            }
            int enableFlags = intent.getIntExtra("enableFlags", 0);
            int disableFlags = intent.getIntExtra("disableFlags", 0);
            Object object = UiModeManagerService.this.mLock;
            synchronized (object) {
                String category = null;
                if (UiModeManager.ACTION_ENTER_CAR_MODE.equals(intent.getAction())) {
                    if ((enableFlags & 1) != 0) {
                        category = "android.intent.category.CAR_DOCK";
                    }
                } else if (UiModeManager.ACTION_ENTER_DESK_MODE.equals(intent.getAction())) {
                    if ((enableFlags & 1) != 0) {
                        category = "android.intent.category.DESK_DOCK";
                    }
                } else if ((disableFlags & 1) != 0) {
                    category = "android.intent.category.HOME";
                }
                if (category != null) {
                    Intent homeIntent = UiModeManagerService.buildHomeIntent(category);
                    Configuration newConfig = null;
                    if (UiModeManagerService.this.mHoldingConfiguration) {
                        UiModeManagerService.this.mHoldingConfiguration = false;
                        UiModeManagerService.this.updateConfigurationLocked(false);
                        newConfig = UiModeManagerService.this.mConfiguration;
                    }
                    try {
                        ActivityManagerNative.getDefault().startActivityWithConfig(null, homeIntent, null, null, 0, null, null, 0, false, false, newConfig);
                        UiModeManagerService.this.mHoldingConfiguration = false;
                    }
                    catch (RemoteException e) {
                        Slog.w((String)TAG, (Throwable)e.getCause());
                    }
                }
                if (UiModeManagerService.this.mHoldingConfiguration) {
                    UiModeManagerService.this.mHoldingConfiguration = false;
                    UiModeManagerService.this.updateConfigurationLocked(true);
                }
            }
        }
    };
    private final BroadcastReceiver mTwilightUpdateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (UiModeManagerService.this.isDoingNightMode() && UiModeManagerService.this.mNightMode == 0) {
                UiModeManagerService.this.mHandler.sendEmptyMessage(0);
            }
        }
    };
    private final BroadcastReceiver mDockModeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
            UiModeManagerService.this.updateDockState(state);
        }
    };
    private final BroadcastReceiver mBatteryReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UiModeManagerService.this.mCharging = intent.getIntExtra("plugged", 0) != 0;
            Object object = UiModeManagerService.this.mLock;
            synchronized (object) {
                if (UiModeManagerService.this.mSystemReady) {
                    UiModeManagerService.this.updateLocked(0, 0);
                }
            }
        }
    };
    private final BroadcastReceiver mUpdateLocationReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.AIRPLANE_MODE".equals(intent.getAction())) {
                if (!intent.getBooleanExtra("state", false)) {
                    UiModeManagerService.this.mHandler.sendEmptyMessage(2);
                }
            } else {
                UiModeManagerService.this.mHandler.sendEmptyMessage(2);
            }
        }
    };
    private final LocationListener mEmptyLocationListener = new LocationListener(){

        public void onLocationChanged(Location location) {
        }

        public void onProviderDisabled(String provider) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }
    };
    private final LocationListener mLocationListener = new LocationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLocationChanged(Location location) {
            boolean hasBetterAccuracy;
            boolean hasMoved = this.hasMoved(location);
            boolean bl = hasBetterAccuracy = UiModeManagerService.this.mLocation == null || location.getAccuracy() < UiModeManagerService.this.mLocation.getAccuracy();
            if (hasMoved || hasBetterAccuracy) {
                Object object = UiModeManagerService.this.mLock;
                synchronized (object) {
                    UiModeManagerService.this.mLocation = location;
                    if (hasMoved && UiModeManagerService.this.isDoingNightMode() && UiModeManagerService.this.mNightMode == 0) {
                        UiModeManagerService.this.mHandler.sendEmptyMessage(0);
                    }
                }
            }
        }

        public void onProviderDisabled(String provider) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        private boolean hasMoved(Location location) {
            float totalAccuracy;
            if (location == null) {
                return false;
            }
            if (UiModeManagerService.this.mLocation == null) {
                return true;
            }
            if (location.getTime() < UiModeManagerService.this.mLocation.getTime()) {
                return false;
            }
            float distance = UiModeManagerService.this.mLocation.distanceTo(location);
            return distance >= (totalAccuracy = UiModeManagerService.this.mLocation.getAccuracy() + location.getAccuracy());
        }
    };
    private final Handler mHandler = new Handler(){
        boolean mPassiveListenerEnabled;
        boolean mNetworkListenerEnabled;
        boolean mDidFirstInit;
        long mLastNetworkRegisterTime = -1800000L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    Object object = UiModeManagerService.this.mLock;
                    synchronized (object) {
                        if (UiModeManagerService.this.isDoingNightMode() && UiModeManagerService.this.mLocation != null && UiModeManagerService.this.mNightMode == 0) {
                            UiModeManagerService.this.updateTwilightLocked();
                            UiModeManagerService.this.updateLocked(0, 0);
                        }
                        break;
                    }
                }
                case 2: {
                    if (!this.mNetworkListenerEnabled) {
                        return;
                    }
                    if (this.mLastNetworkRegisterTime + 1800000L >= SystemClock.elapsedRealtime()) {
                        return;
                    }
                    this.mNetworkListenerEnabled = false;
                    UiModeManagerService.this.mLocationManager.removeUpdates(UiModeManagerService.this.mEmptyLocationListener);
                }
                case 1: {
                    boolean passiveLocationEnabled;
                    boolean networkLocationEnabled;
                    try {
                        networkLocationEnabled = UiModeManagerService.this.mLocationManager.isProviderEnabled("network");
                    }
                    catch (Exception e) {
                        networkLocationEnabled = false;
                    }
                    if (!this.mNetworkListenerEnabled && networkLocationEnabled) {
                        this.mNetworkListenerEnabled = true;
                        this.mLastNetworkRegisterTime = SystemClock.elapsedRealtime();
                        UiModeManagerService.this.mLocationManager.requestLocationUpdates("network", 86400000L, 0.0f, UiModeManagerService.this.mEmptyLocationListener);
                        if (!this.mDidFirstInit) {
                            this.mDidFirstInit = true;
                            if (UiModeManagerService.this.mLocation == null) {
                                this.retrieveLocation();
                            }
                            Object e = UiModeManagerService.this.mLock;
                            synchronized (e) {
                                if (UiModeManagerService.this.isDoingNightMode() && UiModeManagerService.this.mLocation != null && UiModeManagerService.this.mNightMode == 0) {
                                    UiModeManagerService.this.updateTwilightLocked();
                                    UiModeManagerService.this.updateLocked(0, 0);
                                }
                            }
                        }
                    }
                    try {
                        passiveLocationEnabled = UiModeManagerService.this.mLocationManager.isProviderEnabled("passive");
                    }
                    catch (Exception e) {
                        passiveLocationEnabled = false;
                    }
                    if (!this.mPassiveListenerEnabled && passiveLocationEnabled) {
                        this.mPassiveListenerEnabled = true;
                        UiModeManagerService.this.mLocationManager.requestLocationUpdates("passive", 0L, 20000.0f, UiModeManagerService.this.mLocationListener);
                    }
                    if (this.mNetworkListenerEnabled && this.mPassiveListenerEnabled) break;
                    long interval = msg.getData().getLong(UiModeManagerService.KEY_LAST_UPDATE_INTERVAL);
                    if ((interval = (long)((double)interval * 1.5)) == 0L) {
                        interval = 5000L;
                    } else if (interval > 900000L) {
                        interval = 900000L;
                    }
                    Bundle bundle = new Bundle();
                    bundle.putLong(UiModeManagerService.KEY_LAST_UPDATE_INTERVAL, interval);
                    Message newMsg = UiModeManagerService.this.mHandler.obtainMessage(1);
                    newMsg.setData(bundle);
                    UiModeManagerService.this.mHandler.sendMessageDelayed(newMsg, interval);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retrieveLocation() {
            Location location = null;
            Iterator providers = UiModeManagerService.this.mLocationManager.getProviders(new Criteria(), true).iterator();
            while (providers.hasNext()) {
                Location lastKnownLocation = UiModeManagerService.this.mLocationManager.getLastKnownLocation((String)providers.next());
                if (location != null && (lastKnownLocation == null || location.getTime() >= lastKnownLocation.getTime())) continue;
                location = lastKnownLocation;
            }
            if (location == null) {
                Time currentTime = new Time();
                currentTime.set(System.currentTimeMillis());
                double lngOffset = 0.004166666666666667 * (double)(currentTime.gmtoff - (long)(currentTime.isDst > 0 ? 3600 : 0));
                location = new Location("fake");
                location.setLongitude(lngOffset);
                location.setLatitude(0.0);
                location.setAccuracy(417000.0f);
                location.setTime(System.currentTimeMillis());
            }
            Object object = UiModeManagerService.this.mLock;
            synchronized (object) {
                UiModeManagerService.this.mLocation = location;
            }
        }
    };

    static Intent buildHomeIntent(String category) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory(category);
        intent.setFlags(0x10200000);
        return intent;
    }

    public UiModeManagerService(Context context) {
        this.mContext = context;
        ServiceManager.addService((String)"uimode", (IBinder)this);
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mLocationManager = (LocationManager)this.mContext.getSystemService("location");
        this.mContext.registerReceiver(this.mTwilightUpdateReceiver, new IntentFilter(ACTION_UPDATE_NIGHT_MODE));
        this.mContext.registerReceiver(this.mDockModeReceiver, new IntentFilter("android.intent.action.DOCK_EVENT"));
        this.mContext.registerReceiver(this.mBatteryReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        IntentFilter filter = new IntentFilter("android.intent.action.AIRPLANE_MODE");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        this.mContext.registerReceiver(this.mUpdateLocationReceiver, filter);
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(26, TAG);
        this.mConfiguration.setToDefaults();
        this.mCarModeKeepsScreenOn = context.getResources().getInteger(17694735) == 1;
        this.mDeskModeKeepsScreenOn = context.getResources().getInteger(0x10E000E) == 1;
        this.mNightMode = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"ui_night_mode", (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCarMode(int flags) {
        Object object = this.mLock;
        synchronized (object) {
            this.setCarModeLocked(false);
            if (this.mSystemReady) {
                this.updateLocked(0, flags);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCarMode(int flags) {
        Object object = this.mLock;
        synchronized (object) {
            this.setCarModeLocked(true);
            if (this.mSystemReady) {
                this.updateLocked(flags, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentModeType() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurUiMode & 0xF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNightMode(int mode) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            switch (mode) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mode: " + mode);
                }
            }
            if (!this.isDoingNightMode()) {
                return;
            }
            if (this.mNightMode != mode) {
                long ident = Binder.clearCallingIdentity();
                Settings.Secure.putInt((ContentResolver)this.mContext.getContentResolver(), (String)"ui_night_mode", (int)mode);
                Binder.restoreCallingIdentity((long)ident);
                this.mNightMode = mode;
                this.updateLocked(0, 0);
            }
        }
    }

    public int getNightMode() throws RemoteException {
        return this.mNightMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemReady = true;
            this.mCarModeEnabled = this.mDockState == 2;
            this.updateLocked(0, 0);
            this.mHandler.sendEmptyMessage(1);
        }
    }

    boolean isDoingNightMode() {
        return this.mCarModeEnabled || this.mDockState != 0;
    }

    void setCarModeLocked(boolean enabled) {
        if (this.mCarModeEnabled != enabled) {
            this.mCarModeEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDockState(int newState) {
        Object object = this.mLock;
        synchronized (object) {
            if (newState != this.mDockState) {
                this.mDockState = newState;
                this.setCarModeLocked(this.mDockState == 2);
                if (this.mSystemReady) {
                    this.updateLocked(1, 0);
                }
            }
        }
    }

    static final boolean isDeskDockState(int state) {
        switch (state) {
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    final void updateConfigurationLocked(boolean sendIt) {
        int uiMode = 1;
        if (this.mCarModeEnabled) {
            uiMode = 3;
        } else if (UiModeManagerService.isDeskDockState(this.mDockState)) {
            uiMode = 2;
        }
        if (this.mCarModeEnabled) {
            if (this.mNightMode == 0) {
                this.updateTwilightLocked();
                uiMode |= this.mComputedNightMode ? 32 : 16;
            } else {
                uiMode |= this.mNightMode << 4;
            }
        } else {
            uiMode = uiMode & 0xFFFFFFCF | 0x10;
        }
        this.mCurUiMode = uiMode;
        if (!this.mHoldingConfiguration && uiMode != this.mSetUiMode) {
            this.mSetUiMode = uiMode;
            this.mConfiguration.uiMode = uiMode;
            if (sendIt) {
                try {
                    ActivityManagerNative.getDefault().updateConfiguration(this.mConfiguration);
                }
                catch (RemoteException e) {
                    Slog.w((String)TAG, (String)"Failure communicating with activity manager", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateLocked(int enableFlags, int disableFlags) {
        long ident = Binder.clearCallingIdentity();
        try {
            boolean keepScreenOn;
            String action = null;
            String oldAction = null;
            if (this.mLastBroadcastState == 2) {
                this.adjustStatusBarCarModeLocked();
                oldAction = UiModeManager.ACTION_EXIT_CAR_MODE;
            } else if (UiModeManagerService.isDeskDockState(this.mLastBroadcastState)) {
                oldAction = UiModeManager.ACTION_EXIT_DESK_MODE;
            }
            if (this.mCarModeEnabled) {
                if (this.mLastBroadcastState != 2) {
                    this.adjustStatusBarCarModeLocked();
                    if (oldAction != null) {
                        this.mContext.sendBroadcast(new Intent(oldAction));
                    }
                    this.mLastBroadcastState = 2;
                    action = UiModeManager.ACTION_ENTER_CAR_MODE;
                }
            } else if (UiModeManagerService.isDeskDockState(this.mDockState)) {
                if (!UiModeManagerService.isDeskDockState(this.mLastBroadcastState)) {
                    if (oldAction != null) {
                        this.mContext.sendBroadcast(new Intent(oldAction));
                    }
                    this.mLastBroadcastState = this.mDockState;
                    action = UiModeManager.ACTION_ENTER_DESK_MODE;
                }
            } else {
                this.mLastBroadcastState = 0;
                action = oldAction;
            }
            if (action != null) {
                Intent intent = new Intent(action);
                intent.putExtra("enableFlags", enableFlags);
                intent.putExtra("disableFlags", disableFlags);
                this.mContext.sendOrderedBroadcast(intent, null, this.mResultReceiver, null, -1, null, null);
                this.mHoldingConfiguration = true;
            } else {
                Intent homeIntent = null;
                if (this.mCarModeEnabled) {
                    if ((enableFlags & 1) != 0) {
                        homeIntent = UiModeManagerService.buildHomeIntent("android.intent.category.CAR_DOCK");
                    }
                } else if (UiModeManagerService.isDeskDockState(this.mDockState)) {
                    if ((enableFlags & 1) != 0) {
                        homeIntent = UiModeManagerService.buildHomeIntent("android.intent.category.DESK_DOCK");
                    }
                } else if ((disableFlags & 1) != 0) {
                    homeIntent = UiModeManagerService.buildHomeIntent("android.intent.category.HOME");
                }
                if (homeIntent != null) {
                    try {
                        this.mContext.startActivity(homeIntent);
                    }
                    catch (ActivityNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            this.updateConfigurationLocked(true);
            boolean bl = keepScreenOn = this.mCharging && (this.mCarModeEnabled && this.mCarModeKeepsScreenOn || this.mCurUiMode == 2 && this.mDeskModeKeepsScreenOn);
            if (keepScreenOn != this.mWakeLock.isHeld()) {
                if (keepScreenOn) {
                    this.mWakeLock.acquire();
                } else {
                    this.mWakeLock.release();
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)ident);
    }

    private void adjustStatusBarCarModeLocked() {
        if (this.mStatusBarManager == null) {
            this.mStatusBarManager = (StatusBarManager)this.mContext.getSystemService("statusbar");
        }
        if (this.mStatusBarManager != null) {
            this.mStatusBarManager.disable(this.mCarModeEnabled ? 524288 : 0);
        }
        if (this.mNotificationManager == null) {
            this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        }
        if (this.mNotificationManager != null) {
            if (this.mCarModeEnabled) {
                Intent carModeOffIntent = new Intent(this.mContext, DisableCarModeActivity.class);
                Notification n = new Notification();
                n.icon = 17302764;
                n.defaults = 4;
                n.flags = 2;
                n.when = 0L;
                n.setLatestEventInfo(this.mContext, (CharSequence)this.mContext.getString(17040459), (CharSequence)this.mContext.getString(17040460), PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)carModeOffIntent, (int)0));
                this.mNotificationManager.notify(0, n);
            } else {
                this.mNotificationManager.cancel(0);
            }
        }
    }

    void updateTwilightLocked() {
        if (this.mLocation == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        TwilightCalculator tw = new TwilightCalculator();
        tw.calculateTwilight(currentTime, this.mLocation.getLatitude(), this.mLocation.getLongitude());
        boolean nightMode = tw.mState != 0;
        long nextUpdate = 0L;
        if (tw.mSunrise == -1L || tw.mSunset == -1L) {
            nextUpdate = currentTime + 43200000L;
        } else {
            int mLastTwilightState = tw.mState;
            nextUpdate += 60000L;
            if (currentTime > tw.mSunset) {
                tw.calculateTwilight(currentTime + 86400000L, this.mLocation.getLatitude(), this.mLocation.getLongitude());
            }
            nextUpdate = mLastTwilightState == 1 ? (nextUpdate += tw.mSunrise) : (nextUpdate += tw.mSunset);
        }
        Intent updateIntent = new Intent(ACTION_UPDATE_NIGHT_MODE);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)updateIntent, (int)0);
        this.mAlarmManager.cancel(pendingIntent);
        this.mAlarmManager.set(0, nextUpdate, pendingIntent);
        this.mComputedNightMode = nightMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump uimode service from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Current UI Mode Service state:");
            pw.print("  mDockState=");
            pw.print(this.mDockState);
            pw.print(" mLastBroadcastState=");
            pw.println(this.mLastBroadcastState);
            pw.print("  mNightMode=");
            pw.print(this.mNightMode);
            pw.print(" mCarModeEnabled=");
            pw.print(this.mCarModeEnabled);
            pw.print(" mComputedNightMode=");
            pw.println(this.mComputedNightMode);
            pw.print("  mCurUiMode=0x");
            pw.print(Integer.toHexString(this.mCurUiMode));
            pw.print(" mSetUiMode=0x");
            pw.println(Integer.toHexString(this.mSetUiMode));
            pw.print("  mHoldingConfiguration=");
            pw.print(this.mHoldingConfiguration);
            pw.print(" mSystemReady=");
            pw.println(this.mSystemReady);
            if (this.mLocation != null) {
                pw.print("  mLocation=");
                pw.println(this.mLocation);
            }
        }
    }
}

