/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IVibratorService;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.WorkSource;
import java.util.LinkedList;
import java.util.ListIterator;

public class VibratorService
extends IVibratorService.Stub {
    private static final String TAG = "VibratorService";
    private final LinkedList<Vibration> mVibrations;
    private Vibration mCurrentVibration;
    private final WorkSource mTmpWorkSource = new WorkSource();
    private final Runnable mVibrationRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = VibratorService.this.mVibrations;
            synchronized (linkedList) {
                VibratorService.this.doCancelVibrateLocked();
                VibratorService.this.startNextVibrationLocked();
            }
        }
    };
    BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                LinkedList linkedList = VibratorService.this.mVibrations;
                synchronized (linkedList) {
                    VibratorService.this.doCancelVibrateLocked();
                    int size = VibratorService.this.mVibrations.size();
                    for (int i = 0; i < size; ++i) {
                        VibratorService.this.unlinkVibration((Vibration)VibratorService.this.mVibrations.get(i));
                    }
                    VibratorService.this.mVibrations.clear();
                }
            }
        }
    };
    private Handler mH = new Handler();
    private final Context mContext;
    private final PowerManager.WakeLock mWakeLock;
    volatile VibrateThread mThread;

    VibratorService(Context context) {
        VibratorService.vibratorOff();
        this.mContext = context;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "*vibrator*");
        this.mWakeLock.setReferenceCounted(true);
        this.mVibrations = new LinkedList();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        context.registerReceiver(this.mIntentReceiver, filter);
    }

    public boolean hasVibrator() {
        return VibratorService.vibratorExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vibrate(long milliseconds, IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.VIBRATE") != 0) {
            throw new SecurityException("Requires VIBRATE permission");
        }
        int uid = Binder.getCallingUid();
        if (milliseconds <= 0L || this.mCurrentVibration != null && this.mCurrentVibration.hasLongerTimeout(milliseconds)) {
            return;
        }
        Vibration vib = new Vibration(token, milliseconds, uid);
        LinkedList<Vibration> linkedList = this.mVibrations;
        synchronized (linkedList) {
            this.removeVibrationLocked(token);
            this.doCancelVibrateLocked();
            this.mCurrentVibration = vib;
            this.startVibrationLocked(vib);
        }
    }

    private boolean isAll0(long[] pattern) {
        int N = pattern.length;
        for (int i = 0; i < N; ++i) {
            if (pattern[i] == 0L) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vibratePattern(long[] pattern, int repeat, IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.VIBRATE") != 0) {
            throw new SecurityException("Requires VIBRATE permission");
        }
        int uid = Binder.getCallingUid();
        long identity = Binder.clearCallingIdentity();
        try {
            block14: {
                if (pattern == null || pattern.length == 0 || this.isAll0(pattern) || repeat >= pattern.length) break block14;
                if (token != null) break block15;
            }
            Object var11_6 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            Binder.restoreCallingIdentity((long)identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)identity);
        {
            block15: {
                return;
            }
            Vibration vib = new Vibration(token, pattern, repeat, uid);
            try {
                token.linkToDeath((IBinder.DeathRecipient)vib, 0);
            }
            catch (RemoteException e) {
                Object var11_7 = null;
                Binder.restoreCallingIdentity((long)identity);
                return;
            }
            LinkedList<Vibration> linkedList = this.mVibrations;
            synchronized (linkedList) {
                this.removeVibrationLocked(token);
                this.doCancelVibrateLocked();
                if (repeat >= 0) {
                    this.mVibrations.addFirst(vib);
                    this.startNextVibrationLocked();
                } else {
                    this.mCurrentVibration = vib;
                    this.startVibrationLocked(vib);
                }
            }
        }
        Object var11_8 = null;
        Binder.restoreCallingIdentity((long)identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelVibrate(IBinder token) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.VIBRATE", "cancelVibrate");
        long identity = Binder.clearCallingIdentity();
        try {
            LinkedList<Vibration> linkedList = this.mVibrations;
            synchronized (linkedList) {
                Vibration vib = this.removeVibrationLocked(token);
                if (vib == this.mCurrentVibration) {
                    this.doCancelVibrateLocked();
                    this.startNextVibrationLocked();
                }
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Binder.restoreCallingIdentity((long)identity);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancelVibrateLocked() {
        if (this.mThread != null) {
            VibrateThread vibrateThread = this.mThread;
            synchronized (vibrateThread) {
                this.mThread.mDone = true;
                this.mThread.notify();
            }
            this.mThread = null;
        }
        VibratorService.vibratorOff();
        this.mH.removeCallbacks(this.mVibrationRunnable);
    }

    private void startNextVibrationLocked() {
        if (this.mVibrations.size() <= 0) {
            this.mCurrentVibration = null;
            return;
        }
        this.mCurrentVibration = this.mVibrations.getFirst();
        this.startVibrationLocked(this.mCurrentVibration);
    }

    private void startVibrationLocked(Vibration vib) {
        if (vib.mTimeout != 0L) {
            VibratorService.vibratorOn(vib.mTimeout);
            this.mH.postDelayed(this.mVibrationRunnable, vib.mTimeout);
        } else {
            this.mThread = new VibrateThread(vib);
            this.mThread.start();
        }
    }

    private Vibration removeVibrationLocked(IBinder token) {
        ListIterator<Vibration> iter = this.mVibrations.listIterator(0);
        while (iter.hasNext()) {
            Vibration vib = iter.next();
            if (vib.mToken != token) continue;
            iter.remove();
            this.unlinkVibration(vib);
            return vib;
        }
        if (this.mCurrentVibration != null && this.mCurrentVibration.mToken == token) {
            this.unlinkVibration(this.mCurrentVibration);
            return this.mCurrentVibration;
        }
        return null;
    }

    private void unlinkVibration(Vibration vib) {
        if (vib.mPattern != null) {
            vib.mToken.unlinkToDeath((IBinder.DeathRecipient)vib, 0);
        }
    }

    static native boolean vibratorExists();

    static native void vibratorOn(long var0);

    static native void vibratorOff();

    private class VibrateThread
    extends Thread {
        final Vibration mVibration;
        boolean mDone;

        VibrateThread(Vibration vib) {
            this.mVibration = vib;
            VibratorService.this.mTmpWorkSource.set(vib.mUid);
            VibratorService.this.mWakeLock.setWorkSource(VibratorService.this.mTmpWorkSource);
            VibratorService.this.mWakeLock.acquire();
        }

        private void delay(long duration) {
            if (duration > 0L) {
                long bedtime = SystemClock.uptimeMillis();
                do {
                    try {
                        this.wait(duration);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (!this.mDone && (duration = duration - SystemClock.uptimeMillis() - bedtime) > 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Process.setThreadPriority((int)-8);
            Object object = this;
            synchronized (object) {
                int index = 0;
                long[] pattern = this.mVibration.mPattern;
                int len = pattern.length;
                int repeat = this.mVibration.mRepeat;
                long duration = 0L;
                while (!this.mDone) {
                    if (index < len) {
                        duration += pattern[index++];
                    }
                    this.delay(duration);
                    if (this.mDone) break;
                    if (index < len) {
                        if ((duration = pattern[index++]) <= 0L) continue;
                        VibratorService.vibratorOn(duration);
                        continue;
                    }
                    if (repeat < 0) break;
                    index = repeat;
                    duration = 0L;
                }
                VibratorService.this.mWakeLock.release();
            }
            object = VibratorService.this.mVibrations;
            synchronized (object) {
                if (VibratorService.this.mThread == this) {
                    VibratorService.this.mThread = null;
                }
                if (!this.mDone) {
                    VibratorService.this.mVibrations.remove(this.mVibration);
                    VibratorService.this.unlinkVibration(this.mVibration);
                    VibratorService.this.startNextVibrationLocked();
                }
            }
        }
    }

    private class Vibration
    implements IBinder.DeathRecipient {
        private final IBinder mToken;
        private final long mTimeout;
        private final long mStartTime;
        private final long[] mPattern;
        private final int mRepeat;
        private final int mUid;

        Vibration(IBinder token, long millis, int uid) {
            this(token, millis, null, 0, uid);
        }

        Vibration(IBinder token, long[] pattern, int repeat, int uid) {
            this(token, 0L, pattern, repeat, uid);
        }

        private Vibration(IBinder token, long millis, long[] pattern, int repeat, int uid) {
            this.mToken = token;
            this.mTimeout = millis;
            this.mStartTime = SystemClock.uptimeMillis();
            this.mPattern = pattern;
            this.mRepeat = repeat;
            this.mUid = uid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            LinkedList linkedList = VibratorService.this.mVibrations;
            synchronized (linkedList) {
                VibratorService.this.mVibrations.remove(this);
                if (this == VibratorService.this.mCurrentVibration) {
                    VibratorService.this.doCancelVibrateLocked();
                    VibratorService.this.startNextVibrationLocked();
                }
            }
        }

        public boolean hasLongerTimeout(long millis) {
            if (this.mTimeout == 0L) {
                return false;
            }
            return this.mStartTime + this.mTimeout >= SystemClock.uptimeMillis() + millis;
        }
    }
}

