/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.PendingIntent;
import android.app.WallpaperInfo;
import android.app.backup.BackupManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Bundle;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.IInterface;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.service.wallpaper.IWallpaperConnection;
import android.service.wallpaper.IWallpaperEngine;
import android.service.wallpaper.IWallpaperService;
import android.util.Slog;
import android.util.Xml;
import android.view.Display;
import android.view.IWindowManager;
import android.view.WindowManager;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class WallpaperManagerService
extends IWallpaperManager.Stub {
    static final String TAG = "WallpaperService";
    static final boolean DEBUG = false;
    final Object mLock = new Object[0];
    static final long MIN_WALLPAPER_CRASH_TIME = 10000L;
    static final File WALLPAPER_DIR = new File("/data/data/com.android.settings/files");
    static final String WALLPAPER = "wallpaper";
    static final File WALLPAPER_FILE = new File(WALLPAPER_DIR, "wallpaper");
    private final RemoteCallbackList<IWallpaperManagerCallback> mCallbacks = new RemoteCallbackList();
    private final FileObserver mWallpaperObserver = new FileObserver(WALLPAPER_DIR.getAbsolutePath(), 1544){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(int event, String path) {
            if (path == null) {
                return;
            }
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                long origId = Binder.clearCallingIdentity();
                BackupManager bm = new BackupManager(WallpaperManagerService.this.mContext);
                bm.dataChanged();
                Binder.restoreCallingIdentity((long)origId);
                File changedFile = new File(WALLPAPER_DIR, path);
                if (WALLPAPER_FILE.equals(changedFile)) {
                    WallpaperManagerService.this.notifyCallbacksLocked();
                    if (WallpaperManagerService.this.mWallpaperComponent == null || event != 8 || WallpaperManagerService.this.mImageWallpaperPending) {
                        if (event == 8) {
                            WallpaperManagerService.this.mImageWallpaperPending = false;
                        }
                        WallpaperManagerService.this.bindWallpaperComponentLocked(WallpaperManagerService.this.mImageWallpaperComponent, true, false);
                        WallpaperManagerService.this.saveSettingsLocked();
                    }
                }
            }
        }
    };
    final Context mContext;
    final IWindowManager mIWindowManager;
    final MyPackageMonitor mMonitor;
    int mWidth = -1;
    int mHeight = -1;
    boolean mImageWallpaperPending;
    String mName = "";
    ComponentName mWallpaperComponent;
    ComponentName mNextWallpaperComponent;
    ComponentName mImageWallpaperComponent = new ComponentName("com.android.systemui", "com.android.systemui.ImageWallpaper");
    WallpaperConnection mWallpaperConnection;
    long mLastDiedTime;
    boolean mWallpaperUpdating;

    public WallpaperManagerService(Context context) {
        this.mContext = context;
        this.mIWindowManager = IWindowManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"window"));
        this.mMonitor = new MyPackageMonitor();
        this.mMonitor.register(context, true);
        WALLPAPER_DIR.mkdirs();
        this.loadSettingsLocked();
        this.mWallpaperObserver.startWatching();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.mWallpaperObserver.stopWatching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        Object object = this.mLock;
        synchronized (object) {
            RuntimeException e = null;
            try {
                if (this.bindWallpaperComponentLocked(this.mNextWallpaperComponent, false, false)) {
                    return;
                }
            }
            catch (RuntimeException e1) {
                e = e1;
            }
            Slog.w((String)TAG, (String)"Failure starting previous wallpaper", (Throwable)e);
            this.clearWallpaperLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWallpaper() {
        Object object = this.mLock;
        synchronized (object) {
            this.clearWallpaperLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearWallpaperLocked(boolean defaultFailed) {
        IllegalArgumentException e;
        block7: {
            long ident;
            block5: {
                File f = WALLPAPER_FILE;
                if (f.exists()) {
                    f.delete();
                }
                ident = Binder.clearCallingIdentity();
                e = null;
                try {
                    try {
                        this.mImageWallpaperPending = false;
                        if (!this.bindWallpaperComponentLocked(defaultFailed ? this.mImageWallpaperComponent : null, true, false)) break block5;
                        Object var8_5 = null;
                    }
                    catch (IllegalArgumentException e1) {
                        e = e1;
                        Object var8_7 = null;
                        Binder.restoreCallingIdentity((long)ident);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    Binder.restoreCallingIdentity((long)ident);
                    throw throwable;
                }
                Binder.restoreCallingIdentity((long)ident);
                return;
            }
            Object var8_6 = null;
            Binder.restoreCallingIdentity((long)ident);
        }
        Slog.e((String)TAG, (String)"Default wallpaper component not found!", (Throwable)e);
        this.clearWallpaperComponentLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimensionHints(int width, int height) throws RemoteException {
        this.checkPermission("android.permission.SET_WALLPAPER_HINTS");
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (width != this.mWidth || height != this.mHeight) {
                this.mWidth = width;
                this.mHeight = height;
                this.saveSettingsLocked();
                if (this.mWallpaperConnection != null && this.mWallpaperConnection.mEngine != null) {
                    try {
                        this.mWallpaperConnection.mEngine.setDesiredSize(width, height);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    this.notifyCallbacksLocked();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidthHint() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.mWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeightHint() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.mHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor getWallpaper(IWallpaperManagerCallback cb, Bundle outParams) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (outParams != null) {
                    outParams.putInt("width", this.mWidth);
                    outParams.putInt("height", this.mHeight);
                }
                this.mCallbacks.register((IInterface)cb);
                File f = WALLPAPER_FILE;
                if (!f.exists()) {
                    return null;
                }
                return ParcelFileDescriptor.open((File)f, (int)0x10000000);
            }
            catch (FileNotFoundException e) {
                Slog.w((String)TAG, (String)"Error getting wallpaper", (Throwable)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallpaperInfo getWallpaperInfo() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWallpaperConnection != null) {
                return this.mWallpaperConnection.mInfo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParcelFileDescriptor setWallpaper(String name) {
        this.checkPermission("android.permission.SET_WALLPAPER");
        Object object = this.mLock;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor;
            long ident = Binder.clearCallingIdentity();
            try {
                ParcelFileDescriptor pfd = this.updateWallpaperBitmapLocked(name);
                if (pfd != null) {
                    this.mImageWallpaperPending = true;
                }
                parcelFileDescriptor = pfd;
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
            return parcelFileDescriptor;
        }
    }

    ParcelFileDescriptor updateWallpaperBitmapLocked(String name) {
        if (name == null) {
            name = "";
        }
        try {
            if (!WALLPAPER_DIR.exists()) {
                WALLPAPER_DIR.mkdir();
                FileUtils.setPermissions((String)WALLPAPER_DIR.getPath(), (int)505, (int)-1, (int)-1);
            }
            ParcelFileDescriptor fd = ParcelFileDescriptor.open((File)WALLPAPER_FILE, (int)0x38000000);
            this.mName = name;
            return fd;
        }
        catch (FileNotFoundException e) {
            Slog.w((String)TAG, (String)"Error setting wallpaper", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWallpaperComponent(ComponentName name) {
        this.checkPermission("android.permission.SET_WALLPAPER_COMPONENT");
        Object object = this.mLock;
        synchronized (object) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mImageWallpaperPending = false;
                this.bindWallpaperComponentLocked(name, false, true);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    boolean bindWallpaperComponentLocked(ComponentName componentName, boolean force, boolean fromUser) {
        if (!force && this.mWallpaperConnection != null && (this.mWallpaperComponent == null ? componentName == null : this.mWallpaperComponent.equals((Object)componentName))) {
            return true;
        }
        try {
            if (componentName == null) {
                String defaultComponent = this.mContext.getString(17039387);
                if (defaultComponent != null) {
                    componentName = ComponentName.unflattenFromString((String)defaultComponent);
                }
                if (componentName == null) {
                    componentName = this.mImageWallpaperComponent;
                }
            }
            ServiceInfo si = this.mContext.getPackageManager().getServiceInfo(componentName, 4224);
            if (!"android.permission.BIND_WALLPAPER".equals(si.permission)) {
                String msg = "Selected service does not require android.permission.BIND_WALLPAPER: " + componentName;
                if (fromUser) {
                    throw new SecurityException(msg);
                }
                Slog.w((String)TAG, (String)msg);
                return false;
            }
            WallpaperInfo wi = null;
            Intent intent = new Intent("android.service.wallpaper.WallpaperService");
            if (componentName != null && !componentName.equals((Object)this.mImageWallpaperComponent)) {
                List ris = this.mContext.getPackageManager().queryIntentServices(intent, 128);
                for (int i = 0; i < ris.size(); ++i) {
                    ServiceInfo rsi = ((ResolveInfo)ris.get((int)i)).serviceInfo;
                    if (!rsi.name.equals(si.name) || !rsi.packageName.equals(si.packageName)) continue;
                    try {
                        wi = new WallpaperInfo(this.mContext, (ResolveInfo)ris.get(i));
                        break;
                    }
                    catch (XmlPullParserException e) {
                        if (fromUser) {
                            throw new IllegalArgumentException(e);
                        }
                        Slog.w((String)TAG, (Throwable)e);
                        return false;
                    }
                    catch (IOException e) {
                        if (fromUser) {
                            throw new IllegalArgumentException(e);
                        }
                        Slog.w((String)TAG, (Throwable)e);
                        return false;
                    }
                }
                if (wi == null) {
                    String msg = "Selected service is not a wallpaper: " + componentName;
                    if (fromUser) {
                        throw new SecurityException(msg);
                    }
                    Slog.w((String)TAG, (String)msg);
                    return false;
                }
            }
            WallpaperConnection newConn = new WallpaperConnection(wi);
            intent.setComponent(componentName);
            intent.putExtra("android.intent.extra.client_label", 0x1040440);
            intent.putExtra("android.intent.extra.client_intent", (Parcelable)PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)Intent.createChooser((Intent)new Intent("android.intent.action.SET_WALLPAPER"), (CharSequence)this.mContext.getText(0x1040441)), (int)0));
            if (!this.mContext.bindService(intent, (ServiceConnection)newConn, 1)) {
                String msg = "Unable to bind service: " + componentName;
                if (fromUser) {
                    throw new IllegalArgumentException(msg);
                }
                Slog.w((String)TAG, (String)msg);
                return false;
            }
            this.clearWallpaperComponentLocked();
            this.mWallpaperComponent = componentName;
            this.mWallpaperConnection = newConn;
            this.mLastDiedTime = SystemClock.uptimeMillis();
            try {
                this.mIWindowManager.addWindowToken((IBinder)newConn.mToken, 2013);
            }
            catch (RemoteException e) {}
        }
        catch (PackageManager.NameNotFoundException e) {
            String msg = "Unknown component " + componentName;
            if (fromUser) {
                throw new IllegalArgumentException(msg);
            }
            Slog.w((String)TAG, (String)msg);
            return false;
        }
        return true;
    }

    void clearWallpaperComponentLocked() {
        this.mWallpaperComponent = null;
        if (this.mWallpaperConnection != null) {
            if (this.mWallpaperConnection.mEngine != null) {
                try {
                    this.mWallpaperConnection.mEngine.destroy();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.mContext.unbindService((ServiceConnection)this.mWallpaperConnection);
            try {
                this.mIWindowManager.removeWindowToken((IBinder)this.mWallpaperConnection.mToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mWallpaperConnection.mService = null;
            this.mWallpaperConnection.mEngine = null;
            this.mWallpaperConnection = null;
        }
    }

    void attachServiceLocked(WallpaperConnection conn) {
        block2: {
            try {
                conn.mService.attach((IWallpaperConnection)conn, (IBinder)conn.mToken, 2013, false, this.mWidth, this.mHeight);
            }
            catch (RemoteException e) {
                Slog.w((String)TAG, (String)"Failed attaching wallpaper; clearing", (Throwable)e);
                if (this.mWallpaperUpdating) break block2;
                this.bindWallpaperComponentLocked(null, false, false);
            }
        }
    }

    private void notifyCallbacksLocked() {
        int n = this.mCallbacks.beginBroadcast();
        for (int i = 0; i < n; ++i) {
            try {
                ((IWallpaperManagerCallback)this.mCallbacks.getBroadcastItem(i)).onWallpaperChanged();
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mCallbacks.finishBroadcast();
        Intent intent = new Intent("android.intent.action.WALLPAPER_CHANGED");
        this.mContext.sendBroadcast(intent);
    }

    private void checkPermission(String permission) {
        if (0 != this.mContext.checkCallingOrSelfPermission(permission)) {
            throw new SecurityException("Access denied to process: " + Binder.getCallingPid() + ", must have permission " + permission);
        }
    }

    private static JournaledFile makeJournaledFile() {
        String base = "/data/system/wallpaper_info.xml";
        return new JournaledFile(new File("/data/system/wallpaper_info.xml"), new File("/data/system/wallpaper_info.xml.tmp"));
    }

    private void saveSettingsLocked() {
        JournaledFile journal = WallpaperManagerService.makeJournaledFile();
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(journal.chooseForWrite(), false);
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput((OutputStream)stream, "utf-8");
            out.startDocument(null, Boolean.valueOf(true));
            out.startTag(null, "wp");
            out.attribute(null, "width", Integer.toString(this.mWidth));
            out.attribute(null, "height", Integer.toString(this.mHeight));
            out.attribute(null, "name", this.mName);
            if (this.mWallpaperComponent != null && !this.mWallpaperComponent.equals((Object)this.mImageWallpaperComponent)) {
                out.attribute(null, "component", this.mWallpaperComponent.flattenToShortString());
            }
            out.endTag(null, "wp");
            out.endDocument();
            stream.close();
            journal.commit();
        }
        catch (IOException e) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            journal.rollback();
        }
    }

    private void loadSettingsLocked() {
        WindowManager wm;
        Display d;
        int baseSize;
        JournaledFile journal = WallpaperManagerService.makeJournaledFile();
        FileInputStream stream = null;
        File file = journal.chooseForRead();
        boolean success = false;
        try {
            int type;
            stream = new FileInputStream(file);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)stream, null);
            do {
                String tag;
                if ((type = parser.next()) != 2 || !"wp".equals(tag = parser.getName())) continue;
                this.mWidth = Integer.parseInt(parser.getAttributeValue(null, "width"));
                this.mHeight = Integer.parseInt(parser.getAttributeValue(null, "height"));
                this.mName = parser.getAttributeValue(null, "name");
                String comp = parser.getAttributeValue(null, "component");
                ComponentName componentName = this.mNextWallpaperComponent = comp != null ? ComponentName.unflattenFromString((String)comp) : null;
                if (this.mNextWallpaperComponent != null && !"android".equals(this.mNextWallpaperComponent.getPackageName())) continue;
                this.mNextWallpaperComponent = this.mImageWallpaperComponent;
            } while (type != 1);
            success = true;
        }
        catch (NullPointerException e) {
            Slog.w((String)TAG, (String)("failed parsing " + file + " " + e));
        }
        catch (NumberFormatException e) {
            Slog.w((String)TAG, (String)("failed parsing " + file + " " + e));
        }
        catch (XmlPullParserException e) {
            Slog.w((String)TAG, (String)("failed parsing " + file + " " + (Object)((Object)e)));
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)("failed parsing " + file + " " + e));
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w((String)TAG, (String)("failed parsing " + file + " " + e));
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!success) {
            this.mWidth = -1;
            this.mHeight = -1;
            this.mName = "";
        }
        if (this.mWidth < (baseSize = (d = (wm = (WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay()).getMaximumSizeDimension())) {
            this.mWidth = baseSize;
        }
        if (this.mHeight < baseSize) {
            this.mHeight = baseSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void settingsRestored() {
        boolean success = false;
        Object object = this.mLock;
        synchronized (object) {
            this.loadSettingsLocked();
            if (this.mNextWallpaperComponent != null && !this.mNextWallpaperComponent.equals((Object)this.mImageWallpaperComponent)) {
                if (!this.bindWallpaperComponentLocked(this.mNextWallpaperComponent, false, false)) {
                    this.bindWallpaperComponentLocked(null, false, false);
                }
                success = true;
            } else {
                success = "".equals(this.mName) ? true : this.restoreNamedResourceLocked();
                if (success) {
                    this.bindWallpaperComponentLocked(this.mNextWallpaperComponent, false, false);
                }
            }
        }
        if (!success) {
            Slog.e((String)TAG, (String)("Failed to restore wallpaper: '" + this.mName + "'"));
            this.mName = "";
            WALLPAPER_FILE.delete();
        }
        object = this.mLock;
        synchronized (object) {
            this.saveSettingsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean restoreNamedResourceLocked() {
        block39: {
            block34: {
                block32: {
                    block33: {
                        if (this.mName.length() <= 4) return false;
                        if ("res:".equals(this.mName.substring(0, 4)) == false) return false;
                        resName = this.mName.substring(4);
                        pkg = null;
                        colon = resName.indexOf(58);
                        if (colon > 0) {
                            pkg = resName.substring(0, colon);
                        }
                        ident = null;
                        slash = resName.lastIndexOf(47);
                        if (slash > 0) {
                            ident = resName.substring(slash + 1);
                        }
                        type = null;
                        if (colon > 0 && slash > 0 && slash - colon > 1) {
                            type = resName.substring(colon + 1, slash);
                        }
                        if (pkg == null) return false;
                        if (ident == null) return false;
                        if (type == null) return false;
                        resId = -1;
                        res = null;
                        fos = null;
                        try {
                            try {
                                c = this.mContext.createPackageContext(pkg, 4);
                                r = c.getResources();
                                resId = r.getIdentifier(resName, null, null);
                                if (resId == 0) {
                                    Slog.e((String)"WallpaperService", (String)("couldn't resolve identifier pkg=" + pkg + " type=" + type + " ident=" + ident));
                                    var12_15 = false;
                                    var16_17 = null;
                                    if (res == null) break block32;
                                    break block33;
                                }
                                res = r.openRawResource(resId);
                                if (WallpaperManagerService.WALLPAPER_FILE.exists()) {
                                    WallpaperManagerService.WALLPAPER_FILE.delete();
                                }
                                fos = new FileOutputStream(WallpaperManagerService.WALLPAPER_FILE);
                                buffer = new byte[32768];
                                while ((amt = res.read(buffer)) > 0) {
                                    fos.write(buffer, 0, amt);
                                }
                                Slog.v((String)"WallpaperService", (String)("Restored wallpaper: " + resName));
                                var14_30 = true;
                                break block34;
                            }
                            catch (PackageManager.NameNotFoundException e) {
                                Slog.e((String)"WallpaperService", (String)("Package name " + pkg + " not found"));
                                var16_19 = null;
                                if (res != null) {
                                    try {
                                        res.close();
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                                if (fos == null) return false;
                                FileUtils.sync((FileOutputStream)fos);
                                try {
                                    fos.close();
                                    return false;
                                }
                                catch (IOException ex) {
                                    return false;
                                }
                            }
                            catch (Resources.NotFoundException e) {
                                block36: {
                                    Slog.e((String)"WallpaperService", (String)("Resource not found: " + resId));
                                    var16_20 = null;
                                    if (res != null) {
                                        ** try [egrp 2[TRYBLOCK] [12 : 432->440)] { 
lbl75:
                                        // 1 sources

                                        res.close();
                                        break block36;
lbl77:
                                        // 1 sources

                                        catch (IOException ex) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (fos == null) return false;
                                FileUtils.sync((FileOutputStream)fos);
                                try {}
                                catch (IOException ex) {
                                    return false;
                                }
                                fos.close();
                                return false;
                            }
                            catch (IOException e) {
                                block37: {
                                    Slog.e((String)"WallpaperService", (String)"IOException while restoring wallpaper ", (Throwable)e);
                                    var16_21 = null;
                                    if (res != null) {
                                        ** try [egrp 2[TRYBLOCK] [12 : 432->440)] { 
lbl95:
                                        // 1 sources

                                        res.close();
                                        break block37;
lbl97:
                                        // 1 sources

                                        catch (IOException ex) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (fos == null) return false;
                                FileUtils.sync((FileOutputStream)fos);
                                try {}
                                catch (IOException ex) {
                                    return false;
                                }
                                fos.close();
                                return false;
                            }
                        }
                        catch (Throwable var15_31) {
                            block38: {
                                var16_22 = null;
                                if (res != null) {
                                    ** try [egrp 2[TRYBLOCK] [12 : 432->440)] { 
lbl113:
                                    // 1 sources

                                    res.close();
                                    break block38;
lbl115:
                                    // 1 sources

                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (fos == null) throw var15_31;
                            FileUtils.sync(fos);
                            ** try [egrp 3[TRYBLOCK] [13 : 453->461)] { 
lbl122:
                            // 1 sources

                            fos.close();
                            throw var15_31;
lbl124:
                            // 1 sources

                            catch (IOException ex) {
                                // empty catch block
                            }
                            throw var15_31;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [12 : 432->440)] { 
lbl129:
                    // 1 sources

                    res.close();
                    break block32;
lbl131:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (fos == null) return var12_15;
                FileUtils.sync((FileOutputStream)fos);
                ** try [egrp 3[TRYBLOCK] [13 : 453->461)] { 
lbl138:
                // 1 sources

                fos.close();
                return var12_15;
lbl140:
                // 1 sources

                catch (IOException ex) {
                    // empty catch block
                }
                return var12_15;
            }
            var16_18 = null;
            if (res != null) {
                ** try [egrp 2[TRYBLOCK] [12 : 432->440)] { 
lbl147:
                // 1 sources

                res.close();
                break block39;
lbl149:
                // 1 sources

                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        if (fos == null) return var14_30;
        FileUtils.sync((FileOutputStream)fos);
        try {}
        catch (IOException ex) {
            // empty catch block
            return var14_30;
        }
        fos.close();
        return var14_30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump wallpaper service from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Current Wallpaper Service state:");
            pw.print("  mWidth=");
            pw.print(this.mWidth);
            pw.print(" mHeight=");
            pw.println(this.mHeight);
            pw.print("  mName=");
            pw.println(this.mName);
            pw.print("  mWallpaperComponent=");
            pw.println(this.mWallpaperComponent);
            if (this.mWallpaperConnection != null) {
                WallpaperConnection conn = this.mWallpaperConnection;
                pw.print("  Wallpaper connection ");
                pw.print((Object)conn);
                pw.println(":");
                pw.print("    mInfo.component=");
                pw.println(conn.mInfo.getComponent());
                pw.print("    mToken=");
                pw.println(conn.mToken);
                pw.print("    mService=");
                pw.println(conn.mService);
                pw.print("    mEngine=");
                pw.println(conn.mEngine);
                pw.print("    mLastDiedTime=");
                pw.println(this.mLastDiedTime - SystemClock.uptimeMillis());
            }
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPackageUpdateFinished(String packageName, int uid) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mWallpaperComponent != null && WallpaperManagerService.this.mWallpaperComponent.getPackageName().equals(packageName)) {
                    WallpaperManagerService.this.mWallpaperUpdating = false;
                    ComponentName comp = WallpaperManagerService.this.mWallpaperComponent;
                    WallpaperManagerService.this.clearWallpaperComponentLocked();
                    if (!WallpaperManagerService.this.bindWallpaperComponentLocked(comp, false, false)) {
                        Slog.w((String)WallpaperManagerService.TAG, (String)"Wallpaper no longer available; reverting to default");
                        WallpaperManagerService.this.clearWallpaperLocked(false);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPackageModified(String packageName) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mWallpaperComponent == null || !WallpaperManagerService.this.mWallpaperComponent.getPackageName().equals(packageName)) {
                    return;
                }
            }
            this.doPackagesChanged(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPackageUpdateStarted(String packageName, int uid) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mWallpaperComponent != null && WallpaperManagerService.this.mWallpaperComponent.getPackageName().equals(packageName)) {
                    WallpaperManagerService.this.mWallpaperUpdating = true;
                }
            }
        }

        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            return this.doPackagesChanged(doit);
        }

        public void onSomePackagesChanged() {
            this.doPackagesChanged(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean doPackagesChanged(boolean doit) {
            boolean changed = false;
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                int change;
                if (WallpaperManagerService.this.mWallpaperComponent != null && ((change = this.isPackageDisappearing(WallpaperManagerService.this.mWallpaperComponent.getPackageName())) == 3 || change == 2)) {
                    changed = true;
                    if (doit) {
                        Slog.w((String)WallpaperManagerService.TAG, (String)("Wallpaper uninstalled, removing: " + WallpaperManagerService.this.mWallpaperComponent));
                        WallpaperManagerService.this.clearWallpaperLocked(false);
                    }
                }
                if (WallpaperManagerService.this.mNextWallpaperComponent != null && ((change = this.isPackageDisappearing(WallpaperManagerService.this.mNextWallpaperComponent.getPackageName())) == 3 || change == 2)) {
                    WallpaperManagerService.this.mNextWallpaperComponent = null;
                }
                if (WallpaperManagerService.this.mWallpaperComponent != null && this.isPackageModified(WallpaperManagerService.this.mWallpaperComponent.getPackageName())) {
                    try {
                        WallpaperManagerService.this.mContext.getPackageManager().getServiceInfo(WallpaperManagerService.this.mWallpaperComponent, 0);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.w((String)WallpaperManagerService.TAG, (String)("Wallpaper component gone, removing: " + WallpaperManagerService.this.mWallpaperComponent));
                        WallpaperManagerService.this.clearWallpaperLocked(false);
                    }
                }
                if (WallpaperManagerService.this.mNextWallpaperComponent != null && this.isPackageModified(WallpaperManagerService.this.mNextWallpaperComponent.getPackageName())) {
                    try {
                        WallpaperManagerService.this.mContext.getPackageManager().getServiceInfo(WallpaperManagerService.this.mNextWallpaperComponent, 0);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        WallpaperManagerService.this.mNextWallpaperComponent = null;
                    }
                }
            }
            return changed;
        }
    }

    class WallpaperConnection
    extends IWallpaperConnection.Stub
    implements ServiceConnection {
        final WallpaperInfo mInfo;
        final Binder mToken = new Binder();
        IWallpaperService mService;
        IWallpaperEngine mEngine;

        public WallpaperConnection(WallpaperInfo info) {
            this.mInfo = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mWallpaperConnection == this) {
                    WallpaperManagerService.this.mLastDiedTime = SystemClock.uptimeMillis();
                    this.mService = IWallpaperService.Stub.asInterface((IBinder)service);
                    WallpaperManagerService.this.attachServiceLocked(this);
                    WallpaperManagerService.this.saveSettingsLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                this.mService = null;
                this.mEngine = null;
                if (WallpaperManagerService.this.mWallpaperConnection == this) {
                    Slog.w((String)WallpaperManagerService.TAG, (String)("Wallpaper service gone: " + WallpaperManagerService.this.mWallpaperComponent));
                    if (!WallpaperManagerService.this.mWallpaperUpdating && WallpaperManagerService.this.mLastDiedTime + 10000L > SystemClock.uptimeMillis()) {
                        Slog.w((String)WallpaperManagerService.TAG, (String)"Reverting to built-in wallpaper!");
                        WallpaperManagerService.this.clearWallpaperLocked(true);
                    }
                }
            }
        }

        public void attachEngine(IWallpaperEngine engine) {
            this.mEngine = engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ParcelFileDescriptor setWallpaper(String name) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mWallpaperConnection == this) {
                    return WallpaperManagerService.this.updateWallpaperBitmapLocked(name);
                }
                return null;
            }
        }
    }
}

