/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Debug;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import com.android.server.AlarmManagerService;
import com.android.server.BatteryService;
import com.android.server.PowerManagerService;
import com.android.server.am.ActivityManagerService;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;

public class Watchdog
extends Thread {
    static final String TAG = "Watchdog";
    static final boolean localLOGV = false;
    static final boolean DB = false;
    static final boolean RECORD_KERNEL_THREADS = true;
    static final int MONITOR = 2718;
    static final int TIME_TO_RESTART = 60000;
    static final int TIME_TO_WAIT = 30000;
    static final int MEMCHECK_DEFAULT_MIN_SCREEN_OFF = 300;
    static final int MEMCHECK_DEFAULT_MIN_ALARM = 180;
    static final int MEMCHECK_DEFAULT_RECHECK_INTERVAL = 300;
    static final int REBOOT_DEFAULT_INTERVAL = 0;
    static final int REBOOT_DEFAULT_START_TIME = 10800;
    static final int REBOOT_DEFAULT_WINDOW = 3600;
    static final String REBOOT_ACTION = "com.android.service.Watchdog.REBOOT";
    static Watchdog sWatchdog;
    final Handler mHandler;
    final ArrayList<Monitor> mMonitors = new ArrayList();
    ContentResolver mResolver;
    BatteryService mBattery;
    PowerManagerService mPower;
    AlarmManagerService mAlarm;
    ActivityManagerService mActivity;
    boolean mCompleted;
    boolean mForceKillSystem;
    Monitor mCurrentMonitor;
    int mPhonePid;
    final Calendar mCalendar = Calendar.getInstance();
    int mMinScreenOff = 300;
    int mMinAlarm = 180;
    boolean mNeedScheduledCheck;
    PendingIntent mCheckupIntent;
    PendingIntent mRebootIntent;
    long mBootTime;
    int mRebootInterval;
    boolean mReqRebootNoWait;
    int mReqRebootInterval = -1;
    int mReqRebootStartTime = -1;
    int mReqRebootWindow = -1;
    int mReqMinScreenOff = -1;
    int mReqMinNextAlarm = -1;
    int mReqRecheckInterval = -1;

    public static Watchdog getInstance() {
        if (sWatchdog == null) {
            sWatchdog = new Watchdog();
        }
        return sWatchdog;
    }

    private Watchdog() {
        super("watchdog");
        this.mHandler = new HeartbeatHandler();
    }

    public void init(Context context, BatteryService battery, PowerManagerService power, AlarmManagerService alarm, ActivityManagerService activity) {
        this.mResolver = context.getContentResolver();
        this.mBattery = battery;
        this.mPower = power;
        this.mAlarm = alarm;
        this.mActivity = activity;
        context.registerReceiver((BroadcastReceiver)new RebootReceiver(), new IntentFilter(REBOOT_ACTION));
        this.mRebootIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(REBOOT_ACTION), (int)0);
        context.registerReceiver((BroadcastReceiver)new RebootRequestReceiver(), new IntentFilter("android.intent.action.REBOOT"), "android.permission.REBOOT", null);
        this.mBootTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStarted(String name, int pid) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            if ("com.android.phone".equals(name)) {
                this.mPhonePid = pid;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(Monitor monitor) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            if (this.isAlive()) {
                throw new RuntimeException("Monitors can't be added while the Watchdog is running");
            }
            this.mMonitors.add(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkReboot(boolean fromAlarm) {
        long realStartTime;
        int rebootInterval;
        this.mRebootInterval = rebootInterval = this.mReqRebootInterval >= 0 ? this.mReqRebootInterval : Settings.Secure.getInt((ContentResolver)this.mResolver, (String)"reboot_interval", (int)0);
        if (rebootInterval <= 0) {
            this.mAlarm.remove(this.mRebootIntent);
            return;
        }
        long rebootStartTime = this.mReqRebootStartTime >= 0 ? (long)this.mReqRebootStartTime : Settings.Secure.getLong((ContentResolver)this.mResolver, (String)"reboot_start_time", (long)10800L);
        long rebootWindowMillis = (this.mReqRebootWindow >= 0 ? (long)this.mReqRebootWindow : Settings.Secure.getLong((ContentResolver)this.mResolver, (String)"reboot_window", (long)3600L)) * 1000L;
        long recheckInterval = (this.mReqRecheckInterval >= 0 ? (long)this.mReqRecheckInterval : Settings.Secure.getLong((ContentResolver)this.mResolver, (String)"memcheck_recheck_interval", (long)300L)) * 1000L;
        this.retrieveBrutalityAmount();
        Watchdog watchdog = this;
        synchronized (watchdog) {
            long now = System.currentTimeMillis();
            realStartTime = Watchdog.computeCalendarTime(this.mCalendar, now, rebootStartTime);
            long rebootIntervalMillis = rebootInterval * 24 * 60 * 60 * 1000;
            if (this.mReqRebootNoWait || now - this.mBootTime >= rebootIntervalMillis - rebootWindowMillis) {
                if (fromAlarm && rebootWindowMillis <= 0L) {
                    EventLog.writeEvent((int)2808, (Object[])new Object[]{now, (int)rebootIntervalMillis, (int)rebootStartTime * 1000, (int)rebootWindowMillis, ""});
                    this.rebootSystem("Checkin scheduled forced");
                    return;
                }
                if (now < realStartTime) {
                    realStartTime = Watchdog.computeCalendarTime(this.mCalendar, now, rebootStartTime);
                } else if (now < realStartTime + rebootWindowMillis) {
                    String doit = this.shouldWeBeBrutalLocked(now);
                    EventLog.writeEvent((int)2808, (Object[])new Object[]{now, rebootInterval, (int)rebootStartTime * 1000, (int)rebootWindowMillis, doit != null ? doit : ""});
                    if (doit == null) {
                        this.rebootSystem("Checked scheduled range");
                        return;
                    }
                    realStartTime = now + recheckInterval >= realStartTime + rebootWindowMillis ? Watchdog.computeCalendarTime(this.mCalendar, now + rebootIntervalMillis, rebootStartTime) : now + recheckInterval;
                } else {
                    realStartTime = Watchdog.computeCalendarTime(this.mCalendar, now + rebootIntervalMillis, rebootStartTime);
                }
            }
        }
        this.mAlarm.remove(this.mRebootIntent);
        this.mAlarm.set(0, realStartTime, this.mRebootIntent);
    }

    void rebootSystem(String reason) {
        Slog.i((String)TAG, (String)("Rebooting system because: " + reason));
        PowerManagerService pms = (PowerManagerService)ServiceManager.getService((String)"power");
        pms.reboot(reason);
    }

    void retrieveBrutalityAmount() {
        this.mMinScreenOff = (this.mReqMinScreenOff >= 0 ? this.mReqMinScreenOff : Settings.Secure.getInt((ContentResolver)this.mResolver, (String)"memcheck_min_screen_off", (int)300)) * 1000;
        this.mMinAlarm = (this.mReqMinNextAlarm >= 0 ? this.mReqMinNextAlarm : Settings.Secure.getInt((ContentResolver)this.mResolver, (String)"memcheck_min_alarm", (int)180)) * 1000;
    }

    String shouldWeBeBrutalLocked(long curTime) {
        if (this.mBattery == null || !this.mBattery.isPowered()) {
            return "battery";
        }
        if (this.mMinScreenOff >= 0 && (this.mPower == null || this.mPower.timeSinceScreenOn() < (long)this.mMinScreenOff)) {
            return "screen";
        }
        if (this.mMinAlarm >= 0 && (this.mAlarm == null || this.mAlarm.timeToNextAlarm() < (long)this.mMinAlarm)) {
            return "alarm";
        }
        return null;
    }

    static long computeCalendarTime(Calendar c, long curTime, long secondsSinceMidnight) {
        c.setTimeInMillis(curTime);
        int val = (int)secondsSinceMidnight / 3600;
        c.set(11, val);
        secondsSinceMidnight -= (long)(val * 3600);
        val = (int)secondsSinceMidnight / 60;
        c.set(12, val);
        c.set(13, (int)secondsSinceMidnight - val * 60);
        c.set(14, 0);
        long newTime = c.getTimeInMillis();
        if (newTime < curTime) {
            c.add(5, 1);
            newTime = c.getTimeInMillis();
        }
        return newTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean waitedHalf = false;
        while (true) {
            this.mCompleted = false;
            this.mHandler.sendEmptyMessage(2718);
            Watchdog watchdog = this;
            synchronized (watchdog) {
                long timeout = 30000L;
                long start = SystemClock.uptimeMillis();
                while (timeout > 0L && !this.mForceKillSystem) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        Log.wtf((String)TAG, (Throwable)e);
                    }
                    timeout = 30000L - (SystemClock.uptimeMillis() - start);
                }
                if (this.mCompleted && !this.mForceKillSystem) {
                    waitedHalf = false;
                    continue;
                }
                if (!waitedHalf) {
                    ArrayList<Integer> pids = new ArrayList<Integer>();
                    pids.add(Process.myPid());
                    ActivityManagerService.dumpStackTraces(true, pids, null, null);
                    waitedHalf = true;
                    continue;
                }
            }
            final String name = this.mCurrentMonitor != null ? this.mCurrentMonitor.getClass().getName() : "null";
            EventLog.writeEvent((int)2802, (String)name);
            ArrayList<Integer> pids = new ArrayList<Integer>();
            pids.add(Process.myPid());
            if (this.mPhonePid > 0) {
                pids.add(this.mPhonePid);
            }
            final File stack = ActivityManagerService.dumpStackTraces(!waitedHalf, pids, null, null);
            SystemClock.sleep((long)2000L);
            this.dumpKernelStackTraces();
            Thread dropboxThread = new Thread("watchdogWriteToDropbox"){

                public void run() {
                    Watchdog.this.mActivity.addErrorToDropBox("watchdog", null, "system_server", null, null, name, null, stack, null);
                }
            };
            dropboxThread.start();
            try {
                dropboxThread.join(2000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            if (!Debug.isDebuggerConnected()) {
                Slog.w((String)TAG, (String)("*** WATCHDOG KILLING SYSTEM PROCESS: " + name));
                Process.killProcess((int)Process.myPid());
                System.exit(10);
            } else {
                Slog.w((String)TAG, (String)"Debugger connected: Watchdog is *not* killing the system process");
            }
            waitedHalf = false;
        }
    }

    private File dumpKernelStackTraces() {
        String tracesPath = SystemProperties.get((String)"dalvik.vm.stack-trace-file", null);
        if (tracesPath == null || tracesPath.length() == 0) {
            return null;
        }
        this.native_dumpKernelStacks(tracesPath);
        return new File(tracesPath);
    }

    private native void native_dumpKernelStacks(String var1);

    public static interface Monitor {
        public void monitor();
    }

    final class RebootRequestReceiver
    extends BroadcastReceiver {
        RebootRequestReceiver() {
        }

        public void onReceive(Context c, Intent intent) {
            Watchdog.this.mReqRebootNoWait = intent.getIntExtra("nowait", 0) != 0;
            Watchdog.this.mReqRebootInterval = intent.getIntExtra("interval", -1);
            Watchdog.this.mReqRebootStartTime = intent.getIntExtra("startTime", -1);
            Watchdog.this.mReqRebootWindow = intent.getIntExtra("window", -1);
            Watchdog.this.mReqMinScreenOff = intent.getIntExtra("minScreenOff", -1);
            Watchdog.this.mReqMinNextAlarm = intent.getIntExtra("minNextAlarm", -1);
            Watchdog.this.mReqRecheckInterval = intent.getIntExtra("recheckInterval", -1);
            EventLog.writeEvent((int)2811, (Object[])new Object[]{Watchdog.this.mReqRebootNoWait ? 1 : 0, Watchdog.this.mReqRebootInterval, Watchdog.this.mReqRecheckInterval, Watchdog.this.mReqRebootStartTime, Watchdog.this.mReqRebootWindow, Watchdog.this.mReqMinScreenOff, Watchdog.this.mReqMinNextAlarm});
            Watchdog.this.checkReboot(true);
        }
    }

    final class RebootReceiver
    extends BroadcastReceiver {
        RebootReceiver() {
        }

        public void onReceive(Context c, Intent intent) {
            Watchdog.this.checkReboot(true);
        }
    }

    final class HeartbeatHandler
    extends Handler {
        HeartbeatHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2718: {
                    int rebootInterval;
                    int n = rebootInterval = Watchdog.this.mReqRebootInterval >= 0 ? Watchdog.this.mReqRebootInterval : Settings.Secure.getInt((ContentResolver)Watchdog.this.mResolver, (String)"reboot_interval", (int)0);
                    if (Watchdog.this.mRebootInterval != rebootInterval) {
                        Watchdog.this.mRebootInterval = rebootInterval;
                        Watchdog.this.checkReboot(false);
                    }
                    int size = Watchdog.this.mMonitors.size();
                    for (int i = 0; i < size; ++i) {
                        Watchdog.this.mCurrentMonitor = Watchdog.this.mMonitors.get(i);
                        Watchdog.this.mCurrentMonitor.monitor();
                    }
                    Watchdog watchdog = Watchdog.this;
                    synchronized (watchdog) {
                        Watchdog.this.mCompleted = true;
                        Watchdog.this.mCurrentMonitor = null;
                        break;
                    }
                }
            }
        }
    }
}

