/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.wifi.IWifiManager;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiStateMachine;
import android.net.wifi.WifiWatchdogStateMachine;
import android.net.wifi.WpsInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.Slog;
import com.android.internal.app.IBatteryStats;
import com.android.internal.util.AsyncChannel;
import com.android.server.am.BatteryStatsService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WifiService
extends IWifiManager.Stub {
    private static final String TAG = "WifiService";
    private static final boolean DBG = false;
    private final WifiStateMachine mWifiStateMachine;
    private Context mContext;
    private AlarmManager mAlarmManager;
    private PendingIntent mIdleIntent;
    private static final int IDLE_REQUEST = 0;
    private boolean mScreenOff;
    private boolean mDeviceIdle;
    private boolean mEmergencyCallbackMode = false;
    private int mPluggedType;
    private final boolean mBackgroundScanSupported;
    private final LockList mLocks = new LockList();
    private int mFullHighPerfLocksAcquired;
    private int mFullHighPerfLocksReleased;
    private int mFullLocksAcquired;
    private int mFullLocksReleased;
    private int mScanLocksAcquired;
    private int mScanLocksReleased;
    private final List<Multicaster> mMulticasters = new ArrayList<Multicaster>();
    private int mMulticastEnabled;
    private int mMulticastDisabled;
    private final IBatteryStats mBatteryStats;
    private boolean mEnableTrafficStatsPoll = false;
    private int mTrafficStatsPollToken = 0;
    private long mTxPkts;
    private long mRxPkts;
    private int mDataActivity;
    private String mInterfaceName;
    private static final int POLL_TRAFFIC_STATS_INTERVAL_MSECS = 1000;
    private static final long DEFAULT_IDLE_MS = 900000L;
    private static final String ACTION_DEVICE_IDLE = "com.android.server.WifiManager.action.DEVICE_IDLE";
    private static final int WIFI_DISABLED = 0;
    private static final int WIFI_ENABLED = 1;
    private static final int WIFI_ENABLED_AIRPLANE_OVERRIDE = 2;
    private static final int WIFI_DISABLED_AIRPLANE_ON = 3;
    private AtomicInteger mPersistWifiState = new AtomicInteger(0);
    private AtomicBoolean mAirplaneModeOn = new AtomicBoolean(false);
    private boolean mWifiEnabled;
    private boolean mIsReceiverRegistered = false;
    NetworkInfo mNetworkInfo = new NetworkInfo(1, 0, "WIFI", "");
    private static final int ICON_NETWORKS_AVAILABLE = 17302772;
    private final long NOTIFICATION_REPEAT_DELAY_MS;
    private boolean mNotificationEnabled;
    private NotificationEnabledSettingObserver mNotificationEnabledSettingObserver;
    private long mNotificationRepeatTime;
    private Notification mNotification;
    private boolean mNotificationShown;
    private static final int NUM_SCANS_BEFORE_ACTUALLY_SCANNING = 3;
    private int mNumScansSinceNetworkStateChange;
    private AsyncChannel mWifiStateMachineChannel;
    private List<AsyncChannel> mClients = new ArrayList<AsyncChannel>();
    private AsyncServiceHandler mAsyncServiceHandler;
    WifiStateMachineHandler mWifiStateMachineHandler;
    private final WorkSource mTmpWorkSource = new WorkSource();
    private WifiWatchdogStateMachine mWifiWatchdogStateMachine;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            long idleMillis = Settings.Secure.getLong((ContentResolver)WifiService.this.mContext.getContentResolver(), (String)"wifi_idle_ms", (long)900000L);
            int stayAwakeConditions = Settings.System.getInt((ContentResolver)WifiService.this.mContext.getContentResolver(), (String)"stay_on_while_plugged_in", (int)0);
            if (action.equals("android.intent.action.SCREEN_ON")) {
                WifiService.this.mAlarmManager.cancel(WifiService.this.mIdleIntent);
                WifiService.this.mScreenOff = false;
                WifiService.this.evaluateTrafficStatsPolling();
                WifiService.this.mWifiStateMachine.enableRssiPolling(true);
                if (WifiService.this.mBackgroundScanSupported) {
                    WifiService.this.mWifiStateMachine.enableBackgroundScanCommand(false);
                }
                WifiService.this.mWifiStateMachine.enableAllNetworks();
                WifiService.this.setDeviceIdleAndUpdateWifi(false);
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                WifiService.this.mScreenOff = true;
                WifiService.this.evaluateTrafficStatsPolling();
                WifiService.this.mWifiStateMachine.enableRssiPolling(false);
                if (WifiService.this.mBackgroundScanSupported) {
                    WifiService.this.mWifiStateMachine.enableBackgroundScanCommand(true);
                }
                if (!this.shouldWifiStayAwake(stayAwakeConditions, WifiService.this.mPluggedType)) {
                    if (WifiService.this.mNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTED) {
                        WifiService.this.mAlarmManager.set(0, System.currentTimeMillis() + idleMillis, WifiService.this.mIdleIntent);
                    } else {
                        WifiService.this.setDeviceIdleAndUpdateWifi(true);
                    }
                }
            } else if (action.equals(WifiService.ACTION_DEVICE_IDLE)) {
                WifiService.this.setDeviceIdleAndUpdateWifi(true);
            } else if (action.equals("android.intent.action.BATTERY_CHANGED")) {
                int pluggedType = intent.getIntExtra("plugged", 0);
                if (WifiService.this.mScreenOff && this.shouldWifiStayAwake(stayAwakeConditions, WifiService.this.mPluggedType) && !this.shouldWifiStayAwake(stayAwakeConditions, pluggedType)) {
                    long triggerTime = System.currentTimeMillis() + idleMillis;
                    WifiService.this.mAlarmManager.set(0, triggerTime, WifiService.this.mIdleIntent);
                }
                WifiService.this.mPluggedType = pluggedType;
            } else if (action.equals("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", 0);
                WifiService.this.mWifiStateMachine.sendBluetoothAdapterStateChange(state);
            } else if (action.equals("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED")) {
                WifiService.this.mEmergencyCallbackMode = intent.getBooleanExtra("phoneinECMState", false);
                WifiService.this.updateWifiState();
            }
        }

        private boolean shouldWifiStayAwake(int stayAwakeConditions, int pluggedType) {
            int wifiSleepPolicy = Settings.System.getInt((ContentResolver)WifiService.this.mContext.getContentResolver(), (String)"wifi_sleep_policy", (int)2);
            if (wifiSleepPolicy == 2) {
                return true;
            }
            if (wifiSleepPolicy == 1 && pluggedType != 0) {
                return true;
            }
            return this.shouldDeviceStayAwake(stayAwakeConditions, pluggedType);
        }

        private boolean shouldDeviceStayAwake(int stayAwakeConditions, int pluggedType) {
            return (stayAwakeConditions & pluggedType) != 0;
        }
    };

    WifiService(Context context) {
        this.mContext = context;
        this.mInterfaceName = SystemProperties.get((String)"wifi.interface", (String)"wlan0");
        this.mWifiStateMachine = new WifiStateMachine(this.mContext, this.mInterfaceName);
        this.mWifiStateMachine.enableRssiPolling(true);
        this.mBatteryStats = BatteryStatsService.getService();
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent idleIntent = new Intent(ACTION_DEVICE_IDLE, null);
        this.mIdleIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)idleIntent, (int)0);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                WifiService.this.mAirplaneModeOn.set(WifiService.this.isAirplaneModeOn());
                if (!WifiService.this.mAirplaneModeOn.get() && (WifiService.this.testAndClearWifiSavedState() || WifiService.this.mPersistWifiState.get() == 2)) {
                    WifiService.this.persistWifiState(true);
                }
                WifiService.this.updateWifiState();
            }
        }, new IntentFilter("android.intent.action.AIRPLANE_MODE"));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.SCAN_RESULTS");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                    int wifiState = intent.getIntExtra("wifi_state", 1);
                    WifiService.this.mWifiEnabled = wifiState == 3;
                    WifiService.this.resetNotification();
                } else if (intent.getAction().equals("android.net.wifi.STATE_CHANGE")) {
                    WifiService.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    switch (WifiService.this.mNetworkInfo.getDetailedState()) {
                        case CONNECTED: 
                        case DISCONNECTED: {
                            WifiService.this.evaluateTrafficStatsPolling();
                            WifiService.this.resetNotification();
                        }
                    }
                } else if (intent.getAction().equals("android.net.wifi.SCAN_RESULTS")) {
                    WifiService.this.checkAndSetNotification();
                }
            }
        }, filter);
        HandlerThread wifiThread = new HandlerThread(TAG);
        wifiThread.start();
        this.mAsyncServiceHandler = new AsyncServiceHandler(wifiThread.getLooper());
        this.mWifiStateMachineHandler = new WifiStateMachineHandler(wifiThread.getLooper());
        this.NOTIFICATION_REPEAT_DELAY_MS = (long)Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"wifi_networks_available_repeat_delay", (int)900) * 1000L;
        this.mNotificationEnabledSettingObserver = new NotificationEnabledSettingObserver(new Handler());
        this.mNotificationEnabledSettingObserver.register();
        this.mBackgroundScanSupported = this.mContext.getResources().getBoolean(0x111000D);
    }

    public void checkAndStartWifi() {
        this.mAirplaneModeOn.set(this.isAirplaneModeOn());
        this.mPersistWifiState.set(this.getPersistedWifiState());
        boolean wifiEnabled = this.shouldWifiBeEnabled() || this.testAndClearWifiSavedState();
        Slog.i((String)TAG, (String)("WifiService starting up with Wi-Fi " + (wifiEnabled ? "enabled" : "disabled")));
        this.setWifiEnabled(wifiEnabled);
        this.mWifiWatchdogStateMachine = WifiWatchdogStateMachine.makeWifiWatchdogStateMachine((Context)this.mContext);
    }

    private boolean testAndClearWifiSavedState() {
        ContentResolver cr = this.mContext.getContentResolver();
        int wifiSavedState = 0;
        try {
            wifiSavedState = Settings.Secure.getInt((ContentResolver)cr, (String)"wifi_saved_state");
            if (wifiSavedState == 1) {
                Settings.Secure.putInt((ContentResolver)cr, (String)"wifi_saved_state", (int)0);
            }
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return wifiSavedState == 1;
    }

    private int getPersistedWifiState() {
        ContentResolver cr = this.mContext.getContentResolver();
        try {
            return Settings.Secure.getInt((ContentResolver)cr, (String)"wifi_on");
        }
        catch (Settings.SettingNotFoundException e) {
            Settings.Secure.putInt((ContentResolver)cr, (String)"wifi_on", (int)0);
            return 0;
        }
    }

    private boolean shouldWifiBeEnabled() {
        if (this.mAirplaneModeOn.get()) {
            return this.mPersistWifiState.get() == 2;
        }
        return this.mPersistWifiState.get() != 0;
    }

    private void persistWifiState(boolean enabled) {
        boolean airplane;
        ContentResolver cr = this.mContext.getContentResolver();
        boolean bl = airplane = this.mAirplaneModeOn.get() && this.isAirplaneToggleable();
        if (enabled) {
            if (airplane) {
                this.mPersistWifiState.set(2);
            } else {
                this.mPersistWifiState.set(1);
            }
        } else if (airplane) {
            this.mPersistWifiState.set(3);
        } else {
            this.mPersistWifiState.set(0);
        }
        Settings.Secure.putInt((ContentResolver)cr, (String)"wifi_on", (int)this.mPersistWifiState.get());
    }

    public boolean pingSupplicant() {
        this.enforceAccessPermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncPingSupplicant(this.mWifiStateMachineChannel);
        }
        Slog.e((String)TAG, (String)"mWifiStateMachineChannel is not initialized");
        return false;
    }

    public void startScan(boolean forceActive) {
        this.enforceChangePermission();
        this.mWifiStateMachine.startScan(forceActive);
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE", TAG);
    }

    private void enforceChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIFI_STATE", TAG);
    }

    private void enforceMulticastChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIFI_MULTICAST_STATE", TAG);
    }

    public synchronized boolean setWifiEnabled(boolean enable) {
        this.enforceChangePermission();
        if (enable) {
            this.reportStartWorkSource();
        }
        this.mWifiStateMachine.setWifiEnabled(enable);
        if (enable != this.mWifiEnabled) {
            long ident = Binder.clearCallingIdentity();
            this.persistWifiState(enable);
            Binder.restoreCallingIdentity((long)ident);
        }
        if (enable) {
            if (!this.mIsReceiverRegistered) {
                this.registerForBroadcasts();
                this.mIsReceiverRegistered = true;
            }
        } else if (this.mIsReceiverRegistered) {
            this.mContext.unregisterReceiver(this.mReceiver);
            this.mIsReceiverRegistered = false;
        }
        return true;
    }

    public int getWifiEnabledState() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncGetWifiState();
    }

    public void setWifiApEnabled(WifiConfiguration wifiConfig, boolean enabled) {
        this.enforceChangePermission();
        this.mWifiStateMachine.setWifiApEnabled(wifiConfig, enabled);
    }

    public int getWifiApEnabledState() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncGetWifiApState();
    }

    public WifiConfiguration getWifiApConfiguration() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncGetWifiApConfiguration();
    }

    public void setWifiApConfiguration(WifiConfiguration wifiConfig) {
        this.enforceChangePermission();
        if (wifiConfig == null) {
            return;
        }
        this.mWifiStateMachine.setWifiApConfiguration(wifiConfig);
    }

    public void disconnect() {
        this.enforceChangePermission();
        this.mWifiStateMachine.disconnectCommand();
    }

    public void reconnect() {
        this.enforceChangePermission();
        this.mWifiStateMachine.reconnectCommand();
    }

    public void reassociate() {
        this.enforceChangePermission();
        this.mWifiStateMachine.reassociateCommand();
    }

    public List<WifiConfiguration> getConfiguredNetworks() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncGetConfiguredNetworks();
    }

    public int addOrUpdateNetwork(WifiConfiguration config) {
        this.enforceChangePermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncAddOrUpdateNetwork(this.mWifiStateMachineChannel, config);
        }
        Slog.e((String)TAG, (String)"mWifiStateMachineChannel is not initialized");
        return -1;
    }

    public boolean removeNetwork(int netId) {
        this.enforceChangePermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncRemoveNetwork(this.mWifiStateMachineChannel, netId);
        }
        Slog.e((String)TAG, (String)"mWifiStateMachineChannel is not initialized");
        return false;
    }

    public boolean enableNetwork(int netId, boolean disableOthers) {
        this.enforceChangePermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncEnableNetwork(this.mWifiStateMachineChannel, netId, disableOthers);
        }
        Slog.e((String)TAG, (String)"mWifiStateMachineChannel is not initialized");
        return false;
    }

    public boolean disableNetwork(int netId) {
        this.enforceChangePermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncDisableNetwork(this.mWifiStateMachineChannel, netId);
        }
        Slog.e((String)TAG, (String)"mWifiStateMachineChannel is not initialized");
        return false;
    }

    public WifiInfo getConnectionInfo() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncRequestConnectionInfo();
    }

    public List<ScanResult> getScanResults() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncGetScanResultsList();
    }

    public boolean saveConfiguration() {
        boolean result = true;
        this.enforceChangePermission();
        if (this.mWifiStateMachineChannel != null) {
            return this.mWifiStateMachine.syncSaveConfig(this.mWifiStateMachineChannel);
        }
        Slog.e((String)TAG, (String)"mWifiStateMachineChannel is not initialized");
        return false;
    }

    public void setCountryCode(String countryCode, boolean persist) {
        Slog.i((String)TAG, (String)("WifiService trying to set country code to " + countryCode + " with persist set to " + persist));
        this.enforceChangePermission();
        this.mWifiStateMachine.setCountryCode(countryCode, persist);
    }

    public void setFrequencyBand(int band, boolean persist) {
        this.enforceChangePermission();
        if (!this.isDualBandSupported()) {
            return;
        }
        Slog.i((String)TAG, (String)("WifiService trying to set frequency band to " + band + " with persist set to " + persist));
        this.mWifiStateMachine.setFrequencyBand(band, persist);
    }

    public int getFrequencyBand() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.getFrequencyBand();
    }

    public boolean isDualBandSupported() {
        return this.mContext.getResources().getBoolean(0x111000B);
    }

    public DhcpInfo getDhcpInfo() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.syncGetDhcpInfo();
    }

    public void startWifi() {
        this.enforceChangePermission();
        this.mWifiStateMachine.setDriverStart(true, this.mEmergencyCallbackMode);
        this.mWifiStateMachine.reconnectCommand();
    }

    public void stopWifi() {
        this.enforceChangePermission();
        this.mWifiStateMachine.setDriverStart(false, this.mEmergencyCallbackMode);
    }

    public void addToBlacklist(String bssid) {
        this.enforceChangePermission();
        this.mWifiStateMachine.addToBlacklist(bssid);
    }

    public void clearBlacklist() {
        this.enforceChangePermission();
        this.mWifiStateMachine.clearBlacklist();
    }

    public Messenger getMessenger() {
        this.enforceAccessPermission();
        this.enforceChangePermission();
        return new Messenger((Handler)this.mAsyncServiceHandler);
    }

    public String getConfigFile() {
        this.enforceAccessPermission();
        return this.mWifiStateMachine.getConfigFile();
    }

    private void setDeviceIdleAndUpdateWifi(boolean deviceIdle) {
        this.mDeviceIdle = deviceIdle;
        this.reportStartWorkSource();
        this.updateWifiState();
    }

    private synchronized void reportStartWorkSource() {
        this.mTmpWorkSource.clear();
        if (this.mDeviceIdle) {
            for (int i = 0; i < this.mLocks.mList.size(); ++i) {
                this.mTmpWorkSource.add(((WifiLock)((LockList)this.mLocks).mList.get((int)i)).mWorkSource);
            }
        }
        this.mWifiStateMachine.updateBatteryWorkSource(this.mTmpWorkSource);
    }

    private void updateWifiState() {
        boolean wifiShouldBeStarted;
        boolean lockHeld = this.mLocks.hasLocks();
        int strongestLockMode = 1;
        if (this.mEmergencyCallbackMode) {
            wifiShouldBeStarted = false;
        } else {
            boolean bl = wifiShouldBeStarted = !this.mDeviceIdle || lockHeld;
        }
        if (lockHeld) {
            strongestLockMode = this.mLocks.getStrongestLockMode();
        }
        if (!this.mDeviceIdle && strongestLockMode == 2) {
            strongestLockMode = 1;
        }
        if (this.mAirplaneModeOn.get()) {
            this.mWifiStateMachine.setWifiApEnabled(null, false);
        }
        if (this.shouldWifiBeEnabled()) {
            if (wifiShouldBeStarted) {
                this.reportStartWorkSource();
                this.mWifiStateMachine.setWifiEnabled(true);
                this.mWifiStateMachine.setScanOnlyMode(strongestLockMode == 2);
                this.mWifiStateMachine.setDriverStart(true, this.mEmergencyCallbackMode);
                this.mWifiStateMachine.setHighPerfModeEnabled(strongestLockMode == 3);
            } else {
                this.mWifiStateMachine.setDriverStart(false, this.mEmergencyCallbackMode);
            }
        } else {
            this.mWifiStateMachine.setWifiEnabled(false);
        }
    }

    private void registerForBroadcasts() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
        intentFilter.addAction(ACTION_DEVICE_IDLE);
        intentFilter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        this.mContext.registerReceiver(this.mReceiver, intentFilter);
    }

    private boolean isAirplaneSensitive() {
        String airplaneModeRadios = Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_radios");
        return airplaneModeRadios == null || airplaneModeRadios.contains("wifi");
    }

    private boolean isAirplaneToggleable() {
        String toggleableRadios = Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_toggleable_radios");
        return toggleableRadios != null && toggleableRadios.contains("wifi");
    }

    private boolean isAirplaneModeOn() {
        return this.isAirplaneSensitive() && Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"airplane_mode_on", (int)0) == 1;
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump WifiService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("Wi-Fi is " + this.mWifiStateMachine.syncGetWifiStateByName());
        pw.println("Stay-awake conditions: " + Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"stay_on_while_plugged_in", (int)0));
        pw.println();
        pw.println("Internal state:");
        pw.println(this.mWifiStateMachine);
        pw.println();
        pw.println("Latest scan results:");
        List scanResults = this.mWifiStateMachine.syncGetScanResultsList();
        if (scanResults != null && scanResults.size() != 0) {
            pw.println("  BSSID              Frequency   RSSI  Flags             SSID");
            for (ScanResult r : scanResults) {
                pw.printf("  %17s  %9d  %5d  %-16s  %s%n", r.BSSID, r.frequency, r.level, r.capabilities, r.SSID == null ? "" : r.SSID);
            }
        }
        pw.println();
        pw.println("Locks acquired: " + this.mFullLocksAcquired + " full, " + this.mFullHighPerfLocksAcquired + " full high perf, " + this.mScanLocksAcquired + " scan");
        pw.println("Locks released: " + this.mFullLocksReleased + " full, " + this.mFullHighPerfLocksReleased + " full high perf, " + this.mScanLocksReleased + " scan");
        pw.println();
        pw.println("Locks held:");
        this.mLocks.dump(pw);
        pw.println();
        pw.println("WifiWatchdogStateMachine dump");
        this.mWifiWatchdogStateMachine.dump(pw);
    }

    void enforceWakeSourcePermission(int uid, int pid) {
        if (uid == Process.myUid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_DEVICE_STATS", pid, uid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireWifiLock(IBinder binder, int lockMode, String tag, WorkSource ws) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        if (lockMode != 1 && lockMode != 2 && lockMode != 3) {
            Slog.e((String)TAG, (String)("Illegal argument, lockMode= " + lockMode));
            return false;
        }
        if (ws != null && ws.size() == 0) {
            ws = null;
        }
        if (ws != null) {
            this.enforceWakeSourcePermission(Binder.getCallingUid(), Binder.getCallingPid());
        }
        if (ws == null) {
            ws = new WorkSource(Binder.getCallingUid());
        }
        WifiLock wifiLock = new WifiLock(lockMode, tag, binder, ws);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            return this.acquireWifiLockLocked(wifiLock);
        }
    }

    private void noteAcquireWifiLock(WifiLock wifiLock) throws RemoteException {
        switch (wifiLock.mMode) {
            case 1: 
            case 3: {
                this.mBatteryStats.noteFullWifiLockAcquiredFromSource(wifiLock.mWorkSource);
                break;
            }
            case 2: {
                this.mBatteryStats.noteScanWifiLockAcquiredFromSource(wifiLock.mWorkSource);
            }
        }
    }

    private void noteReleaseWifiLock(WifiLock wifiLock) throws RemoteException {
        switch (wifiLock.mMode) {
            case 1: 
            case 3: {
                this.mBatteryStats.noteFullWifiLockReleasedFromSource(wifiLock.mWorkSource);
                break;
            }
            case 2: {
                this.mBatteryStats.noteScanWifiLockReleasedFromSource(wifiLock.mWorkSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireWifiLockLocked(WifiLock wifiLock) {
        boolean bl;
        this.mLocks.addLock(wifiLock);
        long ident = Binder.clearCallingIdentity();
        try {
            this.noteAcquireWifiLock(wifiLock);
            switch (wifiLock.mMode) {
                case 1: {
                    ++this.mFullLocksAcquired;
                    break;
                }
                case 3: {
                    ++this.mFullHighPerfLocksAcquired;
                    break;
                }
                case 2: {
                    ++this.mScanLocksAcquired;
                }
            }
            this.reportStartWorkSource();
            this.updateWifiState();
            bl = true;
            Object var7_5 = null;
        }
        catch (RemoteException e) {
            boolean bl2;
            try {
                bl2 = false;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
            return bl2;
        }
        Binder.restoreCallingIdentity((long)ident);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateWifiLockWorkSource(IBinder lock, WorkSource ws) {
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        if (ws != null && ws.size() == 0) {
            ws = null;
        }
        if (ws != null) {
            this.enforceWakeSourcePermission(uid, pid);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            try {
                LockList lockList = this.mLocks;
                synchronized (lockList) {
                    int index = this.mLocks.findLockByBinder(lock);
                    if (index < 0) {
                        throw new IllegalArgumentException("Wifi lock not active");
                    }
                    WifiLock wl = (WifiLock)this.mLocks.mList.get(index);
                    this.noteReleaseWifiLock(wl);
                    wl.mWorkSource = ws != null ? new WorkSource(ws) : new WorkSource(uid);
                    this.noteAcquireWifiLock(wl);
                }
            }
            catch (RemoteException e) {
                Object var12_11 = null;
                Binder.restoreCallingIdentity((long)ident);
                return;
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseWifiLock(IBinder lock) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
        LockList lockList = this.mLocks;
        synchronized (lockList) {
            return this.releaseWifiLockLocked(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean releaseWifiLockLocked(IBinder lock) {
        WifiLock wifiLock = this.mLocks.removeLock(lock);
        boolean hadLock = wifiLock != null;
        long ident = Binder.clearCallingIdentity();
        try {
            try {
                if (hadLock) {
                    this.noteReleaseWifiLock(wifiLock);
                    switch (wifiLock.mMode) {
                        case 1: {
                            ++this.mFullLocksReleased;
                            break;
                        }
                        case 3: {
                            ++this.mFullHighPerfLocksReleased;
                            break;
                        }
                        case 2: {
                            ++this.mScanLocksReleased;
                            break;
                        }
                    }
                }
                this.updateWifiState();
            }
            catch (RemoteException e) {
                Object var8_6 = null;
                Binder.restoreCallingIdentity((long)ident);
                return hadLock;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)ident);
        return hadLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeMulticastFiltering() {
        this.enforceMulticastChangePermission();
        List<Multicaster> list = this.mMulticasters;
        synchronized (list) {
            if (this.mMulticasters.size() != 0) {
                return;
            }
            this.mWifiStateMachine.startFilteringMulticastV4Packets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquireMulticastLock(IBinder binder, String tag) {
        this.enforceMulticastChangePermission();
        List<Multicaster> list = this.mMulticasters;
        synchronized (list) {
            ++this.mMulticastEnabled;
            this.mMulticasters.add(new Multicaster(tag, binder));
            this.mWifiStateMachine.stopFilteringMulticastV4Packets();
        }
        int uid = Binder.getCallingUid();
        Long ident = Binder.clearCallingIdentity();
        try {
            try {
                this.mBatteryStats.noteWifiMulticastEnabled(uid);
            }
            catch (RemoteException e) {
                Object var7_7 = null;
                Binder.restoreCallingIdentity((long)ident);
                return;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMulticastLock() {
        this.enforceMulticastChangePermission();
        int uid = Binder.getCallingUid();
        List<Multicaster> list = this.mMulticasters;
        synchronized (list) {
            ++this.mMulticastDisabled;
            int size = this.mMulticasters.size();
            for (int i = size - 1; i >= 0; --i) {
                Multicaster m = this.mMulticasters.get(i);
                if (m == null || m.getUid() != uid) continue;
                this.removeMulticasterLocked(i, uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeMulticasterLocked(int i, int uid) {
        Multicaster removed = this.mMulticasters.remove(i);
        if (removed != null) {
            removed.unlinkDeathRecipient();
        }
        if (this.mMulticasters.size() == 0) {
            this.mWifiStateMachine.startFilteringMulticastV4Packets();
        }
        Long ident = Binder.clearCallingIdentity();
        try {
            try {
                this.mBatteryStats.noteWifiMulticastDisabled(uid);
            }
            catch (RemoteException e) {
                Object var7_6 = null;
                Binder.restoreCallingIdentity((long)ident);
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMulticastEnabled() {
        this.enforceAccessPermission();
        List<Multicaster> list = this.mMulticasters;
        synchronized (list) {
            return this.mMulticasters.size() > 0;
        }
    }

    private void evaluateTrafficStatsPolling() {
        Message msg = this.mNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTED && !this.mScreenOff ? Message.obtain((Handler)this.mAsyncServiceHandler, (int)21, (int)1, (int)0) : Message.obtain((Handler)this.mAsyncServiceHandler, (int)21, (int)0, (int)0);
        msg.sendToTarget();
    }

    private void notifyOnDataActivity() {
        long preTxPkts = this.mTxPkts;
        long preRxPkts = this.mRxPkts;
        int dataActivity = 0;
        this.mTxPkts = TrafficStats.getTxPackets((String)this.mInterfaceName);
        this.mRxPkts = TrafficStats.getRxPackets((String)this.mInterfaceName);
        if (preTxPkts > 0L || preRxPkts > 0L) {
            long sent = this.mTxPkts - preTxPkts;
            long received = this.mRxPkts - preRxPkts;
            if (sent > 0L) {
                dataActivity |= 2;
            }
            if (received > 0L) {
                dataActivity |= 1;
            }
            if (dataActivity != this.mDataActivity && !this.mScreenOff) {
                this.mDataActivity = dataActivity;
                for (AsyncChannel client : this.mClients) {
                    client.sendMessage(1, this.mDataActivity);
                }
            }
        }
    }

    private void checkAndSetNotification() {
        List scanResults;
        if (!this.mNotificationEnabled) {
            return;
        }
        NetworkInfo.State state = this.mNetworkInfo.getState();
        if ((state == NetworkInfo.State.DISCONNECTED || state == NetworkInfo.State.UNKNOWN) && (scanResults = this.mWifiStateMachine.syncGetScanResultsList()) != null) {
            int numOpenNetworks = 0;
            for (int i = scanResults.size() - 1; i >= 0; --i) {
                ScanResult scanResult = (ScanResult)scanResults.get(i);
                if (scanResult.capabilities == null || !scanResult.capabilities.equals("[ESS]")) continue;
                ++numOpenNetworks;
            }
            if (numOpenNetworks > 0) {
                if (++this.mNumScansSinceNetworkStateChange >= 3) {
                    this.setNotificationVisible(true, numOpenNetworks, false, 0);
                }
                return;
            }
        }
        this.setNotificationVisible(false, 0, false, 0);
    }

    private void resetNotification() {
        this.mNotificationRepeatTime = 0L;
        this.mNumScansSinceNetworkStateChange = 0;
        this.setNotificationVisible(false, 0, false, 0);
    }

    private void setNotificationVisible(boolean visible, int numNetworks, boolean force, int delay) {
        if (!(visible || this.mNotificationShown || force)) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (visible) {
            if (System.currentTimeMillis() < this.mNotificationRepeatTime) {
                return;
            }
            if (this.mNotification == null) {
                this.mNotification = new Notification();
                this.mNotification.when = 0L;
                this.mNotification.icon = 17302772;
                this.mNotification.flags = 16;
                this.mNotification.contentIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)new Intent("android.net.wifi.PICK_WIFI_NETWORK"), (int)0);
            }
            CharSequence title = this.mContext.getResources().getQuantityText(0x1130011, numNetworks);
            CharSequence details = this.mContext.getResources().getQuantityText(18022418, numNetworks);
            this.mNotification.tickerText = title;
            this.mNotification.setLatestEventInfo(this.mContext, title, details, this.mNotification.contentIntent);
            this.mNotificationRepeatTime = System.currentTimeMillis() + this.NOTIFICATION_REPEAT_DELAY_MS;
            notificationManager.notify(17302772, this.mNotification);
        } else {
            notificationManager.cancel(17302772);
        }
        this.mNotificationShown = visible;
    }

    private class NotificationEnabledSettingObserver
    extends ContentObserver {
        public NotificationEnabledSettingObserver(Handler handler) {
            super(handler);
        }

        public void register() {
            ContentResolver cr = WifiService.this.mContext.getContentResolver();
            cr.registerContentObserver(Settings.Secure.getUriFor((String)"wifi_networks_available_notification_on"), true, (ContentObserver)this);
            WifiService.this.mNotificationEnabled = this.getValue();
        }

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            WifiService.this.mNotificationEnabled = this.getValue();
            WifiService.this.resetNotification();
        }

        private boolean getValue() {
            return Settings.Secure.getInt((ContentResolver)WifiService.this.mContext.getContentResolver(), (String)"wifi_networks_available_notification_on", (int)1) == 1;
        }
    }

    private class Multicaster
    extends DeathRecipient {
        Multicaster(String tag, IBinder binder) {
            super(Binder.getCallingUid(), tag, binder, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Slog.e((String)WifiService.TAG, (String)"Multicaster binderDied");
            List list = WifiService.this.mMulticasters;
            synchronized (list) {
                int i = WifiService.this.mMulticasters.indexOf(this);
                if (i != -1) {
                    WifiService.this.removeMulticasterLocked(i, this.mMode);
                }
            }
        }

        public String toString() {
            return "Multicaster{" + this.mTag + " binder=" + this.mBinder + "}";
        }

        public int getUid() {
            return this.mMode;
        }
    }

    private abstract class DeathRecipient
    implements IBinder.DeathRecipient {
        String mTag;
        int mMode;
        IBinder mBinder;
        WorkSource mWorkSource;

        DeathRecipient(int mode, String tag, IBinder binder, WorkSource ws) {
            this.mTag = tag;
            this.mMode = mode;
            this.mBinder = binder;
            this.mWorkSource = ws;
            try {
                this.mBinder.linkToDeath((IBinder.DeathRecipient)this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        void unlinkDeathRecipient() {
            this.mBinder.unlinkToDeath((IBinder.DeathRecipient)this, 0);
        }
    }

    private class LockList {
        private List<WifiLock> mList = new ArrayList<WifiLock>();

        private LockList() {
        }

        private synchronized boolean hasLocks() {
            return !this.mList.isEmpty();
        }

        private synchronized int getStrongestLockMode() {
            if (this.mList.isEmpty()) {
                return 1;
            }
            if (WifiService.this.mFullHighPerfLocksAcquired > WifiService.this.mFullHighPerfLocksReleased) {
                return 3;
            }
            if (WifiService.this.mFullLocksAcquired > WifiService.this.mFullLocksReleased) {
                return 1;
            }
            return 2;
        }

        private void addLock(WifiLock lock) {
            if (this.findLockByBinder(lock.mBinder) < 0) {
                this.mList.add(lock);
            }
        }

        private WifiLock removeLock(IBinder binder) {
            int index = this.findLockByBinder(binder);
            if (index >= 0) {
                WifiLock ret = this.mList.remove(index);
                ret.unlinkDeathRecipient();
                return ret;
            }
            return null;
        }

        private int findLockByBinder(IBinder binder) {
            int size = this.mList.size();
            for (int i = size - 1; i >= 0; --i) {
                if (this.mList.get((int)i).mBinder != binder) continue;
                return i;
            }
            return -1;
        }

        private void dump(PrintWriter pw) {
            for (WifiLock l : this.mList) {
                pw.print("    ");
                pw.println(l);
            }
        }
    }

    private class WifiLock
    extends DeathRecipient {
        WifiLock(int lockMode, String tag, IBinder binder, WorkSource ws) {
            super(lockMode, tag, binder, ws);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            LockList lockList = WifiService.this.mLocks;
            synchronized (lockList) {
                WifiService.this.releaseWifiLockLocked(this.mBinder);
            }
        }

        public String toString() {
            return "WifiLock{" + this.mTag + " type=" + this.mMode + " binder=" + this.mBinder + "}";
        }
    }

    private class WifiStateMachineHandler
    extends Handler {
        private AsyncChannel mWsmChannel;

        WifiStateMachineHandler(Looper looper) {
            super(looper);
            this.mWsmChannel = new AsyncChannel();
            this.mWsmChannel.connect(WifiService.this.mContext, (Handler)this, WifiService.this.mWifiStateMachine.getHandler());
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 == 0) {
                        WifiService.this.mWifiStateMachineChannel = this.mWsmChannel;
                        break;
                    }
                    Slog.e((String)WifiService.TAG, (String)("WifiStateMachine connection failure, error=" + msg.arg1));
                    WifiService.this.mWifiStateMachineChannel = null;
                    break;
                }
                case 69636: {
                    Slog.e((String)WifiService.TAG, (String)("WifiStateMachine channel lost, msg.arg1 =" + msg.arg1));
                    WifiService.this.mWifiStateMachineChannel = null;
                    this.mWsmChannel.connect(WifiService.this.mContext, (Handler)this, WifiService.this.mWifiStateMachine.getHandler());
                    break;
                }
                default: {
                    Slog.d((String)WifiService.TAG, (String)("WifiStateMachineHandler.handleMessage ignoring msg=" + msg));
                }
            }
        }
    }

    private class AsyncServiceHandler
    extends Handler {
        AsyncServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 == 0) {
                        Slog.d((String)WifiService.TAG, (String)"New client listening to asynchronous messages");
                        WifiService.this.mClients.add((AsyncChannel)msg.obj);
                        break;
                    }
                    Slog.e((String)WifiService.TAG, (String)("Client connection failure, error=" + msg.arg1));
                    break;
                }
                case 69636: {
                    if (msg.arg1 == 2) {
                        Slog.d((String)WifiService.TAG, (String)"Send failed, client connection lost");
                    } else {
                        Slog.d((String)WifiService.TAG, (String)("Client connection lost with reason: " + msg.arg1));
                    }
                    WifiService.this.mClients.remove((AsyncChannel)msg.obj);
                    break;
                }
                case 69633: {
                    AsyncChannel ac = new AsyncChannel();
                    ac.connect(WifiService.this.mContext, (Handler)this, msg.replyTo);
                    break;
                }
                case 21: {
                    WifiService.this.mEnableTrafficStatsPoll = msg.arg1 == 1;
                    WifiService.this.mTrafficStatsPollToken++;
                    if (!WifiService.this.mEnableTrafficStatsPoll) break;
                    WifiService.this.notifyOnDataActivity();
                    this.sendMessageDelayed(Message.obtain((Handler)this, (int)22, (int)WifiService.this.mTrafficStatsPollToken, (int)0), 1000L);
                    break;
                }
                case 22: {
                    if (msg.arg1 != WifiService.this.mTrafficStatsPollToken) break;
                    WifiService.this.notifyOnDataActivity();
                    this.sendMessageDelayed(Message.obtain((Handler)this, (int)22, (int)WifiService.this.mTrafficStatsPollToken, (int)0), 1000L);
                    break;
                }
                case 1: {
                    if (msg.obj != null) {
                        WifiService.this.mWifiStateMachine.connectNetwork((WifiConfiguration)msg.obj);
                        break;
                    }
                    WifiService.this.mWifiStateMachine.connectNetwork(msg.arg1);
                    break;
                }
                case 3: {
                    WifiService.this.mWifiStateMachine.saveNetwork((WifiConfiguration)msg.obj);
                    break;
                }
                case 2: {
                    WifiService.this.mWifiStateMachine.forgetNetwork(msg.arg1);
                    break;
                }
                case 4: {
                    WifiService.this.mWifiStateMachine.startWps(msg.replyTo, (WpsInfo)msg.obj);
                    break;
                }
                case 5: {
                    WifiService.this.mWifiStateMachine.disableNetwork(msg.replyTo, msg.arg1, msg.arg2);
                    break;
                }
                default: {
                    Slog.d((String)WifiService.TAG, (String)("WifiServicehandler.handleMessage ignoring msg=" + msg));
                }
            }
        }
    }
}

