/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.UEventObserver;
import android.util.Log;
import android.util.Slog;
import java.io.FileNotFoundException;
import java.io.FileReader;

class WiredAccessoryObserver
extends UEventObserver {
    private static final String TAG = WiredAccessoryObserver.class.getSimpleName();
    private static final boolean LOG = true;
    private static final int MAX_AUDIO_PORTS = 3;
    private static final String[][] uEventInfo = new String[][]{{"DEVPATH=/devices/virtual/switch/h2w", "/sys/class/switch/h2w/state", "/sys/class/switch/h2w/name"}, {"DEVPATH=/devices/virtual/switch/usb_audio", "/sys/class/switch/usb_audio/state", "/sys/class/switch/usb_audio/name"}, {"DEVPATH=/devices/virtual/switch/hdmi", "/sys/class/switch/hdmi/state", "/sys/class/switch/hdmi/name"}};
    private static final int BIT_HEADSET = 1;
    private static final int BIT_HEADSET_NO_MIC = 2;
    private static final int BIT_USB_HEADSET_ANLG = 4;
    private static final int BIT_USB_HEADSET_DGTL = 8;
    private static final int BIT_HDMI_AUDIO = 16;
    private static final int SUPPORTED_HEADSETS = 31;
    private static final int HEADSETS_WITH_MIC = 1;
    private int mHeadsetState;
    private int mPrevHeadsetState;
    private String mHeadsetName;
    private int switchState;
    private final Context mContext;
    private final PowerManager.WakeLock mWakeLock;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            WiredAccessoryObserver.this.sendIntents(msg.arg1, msg.arg2, (String)msg.obj);
            WiredAccessoryObserver.this.mWakeLock.release();
        }
    };

    public WiredAccessoryObserver(Context context) {
        this.mContext = context;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "WiredAccessoryObserver");
        this.mWakeLock.setReferenceCounted(false);
        context.registerReceiver((BroadcastReceiver)new BootCompletedReceiver(), new IntentFilter("android.intent.action.BOOT_COMPLETED"), null, null);
    }

    public void onUEvent(UEventObserver.UEvent event) {
        Slog.v((String)TAG, (String)("Headset UEVENT: " + event.toString()));
        try {
            String name = event.get("SWITCH_NAME");
            int state = Integer.parseInt(event.get("SWITCH_STATE"));
            this.updateState(name, state);
        }
        catch (NumberFormatException e) {
            Slog.e((String)TAG, (String)("Could not parse switch state from event " + event));
        }
    }

    private final synchronized void updateState(String name, int state) {
        this.switchState = name.equals("usb_audio") ? this.mHeadsetState & 0x13 | (state == 1 ? 4 : (state == 2 ? 8 : 0)) : (name.equals("hdmi") ? this.mHeadsetState & 0xF | (state == 1 ? 16 : 0) : this.mHeadsetState & 0x1C | (state == 1 ? 1 : (state == 2 ? 2 : 0)));
        this.update(name, this.switchState);
    }

    private final synchronized void init() {
        char[] buffer = new char[1024];
        String newName = this.mHeadsetName;
        int newState = this.mHeadsetState;
        this.mPrevHeadsetState = this.mHeadsetState;
        Slog.v((String)TAG, (String)"init()");
        for (int i = 0; i < 3; ++i) {
            try {
                FileReader file = new FileReader(uEventInfo[i][1]);
                int len = file.read(buffer, 0, 1024);
                file.close();
                newState = Integer.valueOf(new String(buffer, 0, len).trim());
                file = new FileReader(uEventInfo[i][2]);
                len = file.read(buffer, 0, 1024);
                file.close();
                newName = new String(buffer, 0, len).trim();
                if (newState <= 0) continue;
                this.updateState(newName, newState);
                continue;
            }
            catch (FileNotFoundException e) {
                Slog.w((String)TAG, (String)"This kernel does not have wired headset support");
                continue;
            }
            catch (Exception e) {
                Slog.e((String)TAG, (String)"", (Throwable)e);
            }
        }
    }

    private final synchronized void update(String newName, int newState) {
        int headsetState = newState & 0x1F;
        int newOrOld = headsetState | this.mHeadsetState;
        int delay = 0;
        int usb_headset_anlg = headsetState & 4;
        int usb_headset_dgtl = headsetState & 8;
        int h2w_headset = headsetState & 3;
        boolean h2wStateChange = true;
        boolean usbStateChange = true;
        Slog.v((String)TAG, (String)("newState = " + newState + ", headsetState = " + headsetState + "," + "mHeadsetState = " + this.mHeadsetState));
        if (this.mHeadsetState == headsetState || (h2w_headset & h2w_headset - 1) != 0) {
            Log.e((String)TAG, (String)"unsetting h2w flag");
            h2wStateChange = false;
        }
        if (usb_headset_anlg >> 2 == 1 && usb_headset_dgtl >> 3 == 1) {
            Log.e((String)TAG, (String)"unsetting usb flag");
            usbStateChange = false;
        }
        if (!h2wStateChange && !usbStateChange) {
            Log.e((String)TAG, (String)"invalid transition, returning ...");
            return;
        }
        this.mHeadsetName = newName;
        this.mPrevHeadsetState = this.mHeadsetState;
        this.mHeadsetState = headsetState;
        if (headsetState == 0) {
            Intent intent = new Intent("android.media.AUDIO_BECOMING_NOISY");
            this.mContext.sendBroadcast(intent);
            delay = 1000;
        } else if (this.mHandler.hasMessages(0)) {
            delay = 1000;
        }
        this.mWakeLock.acquire();
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(0, this.mHeadsetState, this.mPrevHeadsetState, (Object)this.mHeadsetName), (long)delay);
    }

    private final synchronized void sendIntents(int headsetState, int prevHeadsetState, String headsetName) {
        int allHeadsets = 31;
        int curHeadset = 1;
        while (allHeadsets != 0) {
            if ((curHeadset & allHeadsets) != 0) {
                this.sendIntent(curHeadset, headsetState, prevHeadsetState, headsetName);
                allHeadsets &= ~curHeadset;
            }
            curHeadset <<= 1;
        }
    }

    private final void sendIntent(int headset, int headsetState, int prevHeadsetState, String headsetName) {
        if ((headsetState & headset) != (prevHeadsetState & headset)) {
            Intent intent;
            int state = 0;
            if ((headsetState & headset) != 0) {
                state = 1;
            }
            if (headset == 4 || headset == 8 || headset == 16) {
                if (headset == 4) {
                    intent = new Intent("android.intent.action.USB_ANLG_HEADSET_PLUG");
                    intent.addFlags(0x40000000);
                    intent.putExtra("state", state);
                    intent.putExtra("name", headsetName);
                    ActivityManagerNative.broadcastStickyIntent((Intent)intent, null);
                } else if (headset == 8) {
                    intent = new Intent("android.intent.action.USB_DGTL_HEADSET_PLUG");
                    intent.addFlags(0x40000000);
                    intent.putExtra("state", state);
                    intent.putExtra("name", headsetName);
                    ActivityManagerNative.broadcastStickyIntent((Intent)intent, null);
                } else if (headset == 16) {
                    intent = new Intent("android.intent.action.HDMI_AUDIO_PLUG");
                    intent.addFlags(0x40000000);
                    intent.putExtra("state", state);
                    intent.putExtra("name", headsetName);
                    ActivityManagerNative.broadcastStickyIntent((Intent)intent, null);
                }
                Slog.v((String)TAG, (String)("Intent.ACTION_USB_HEADSET_PLUG: state: " + state + " name: " + headsetName));
            }
            if (headset == 1 || headset == 2) {
                intent = new Intent("android.intent.action.HEADSET_PLUG");
                intent.addFlags(0x40000000);
                int microphone = 0;
                if ((headset & 1) != 0) {
                    microphone = 1;
                }
                intent.putExtra("state", state);
                intent.putExtra("name", headsetName);
                intent.putExtra("microphone", microphone);
                Slog.v((String)TAG, (String)("Intent.ACTION_HEADSET_PLUG: state: " + state + " name: " + headsetName + " mic: " + microphone));
                ActivityManagerNative.broadcastStickyIntent((Intent)intent, null);
            }
        }
    }

    private final class BootCompletedReceiver
    extends BroadcastReceiver {
        private BootCompletedReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            WiredAccessoryObserver.this.init();
            for (int i = 0; i < 3; ++i) {
                WiredAccessoryObserver.this.startObserving(uEventInfo[i][0]);
            }
        }
    }
}

