/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.Context;
import android.view.InputEvent;
import android.view.MotionEvent;
import com.android.server.accessibility.TouchExplorer;
import com.android.server.wm.InputFilter;

public class AccessibilityInputFilter
extends InputFilter {
    private static final String TAG = "AccessibilityInputFilter";
    private static final boolean DEBUG = false;
    private final Context mContext;
    private TouchExplorer mTouchExplorer;
    private int mTouchscreenSourceDeviceId;

    public AccessibilityInputFilter(Context context) {
        super(context.getMainLooper());
        this.mContext = context;
    }

    public void onInstalled() {
        this.mTouchExplorer = new TouchExplorer(this, this.mContext);
        super.onInstalled();
    }

    public void onUninstalled() {
        this.mTouchExplorer.clear();
        super.onUninstalled();
    }

    public void onInputEvent(InputEvent event, int policyFlags) {
        if (event.getSource() == 4098) {
            MotionEvent motionEvent = (MotionEvent)event;
            int deviceId = event.getDeviceId();
            if (this.mTouchscreenSourceDeviceId != deviceId) {
                this.mTouchscreenSourceDeviceId = deviceId;
                this.mTouchExplorer.clear(motionEvent, policyFlags);
            }
            if ((policyFlags & 0x40000000) != 0) {
                this.mTouchExplorer.onMotionEvent(motionEvent, policyFlags);
            } else {
                this.mTouchExplorer.clear(motionEvent, policyFlags);
            }
        } else {
            super.onInputEvent(event, policyFlags);
        }
    }

    public static interface Explorer {
        public void onMotionEvent(MotionEvent var1, int var2);

        public void clear(MotionEvent var1, int var2);

        public void clear();
    }
}

