/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.accessibilityservice.IEventListener;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.view.IWindow;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.HandlerCaller;
import com.android.server.accessibility.AccessibilityInputFilter;
import com.android.server.wm.WindowManagerService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibilityManagerService
extends IAccessibilityManager.Stub
implements HandlerCaller.Callback {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManagerService";
    private static final String FUNCTION_REGISTER_EVENT_LISTENER = "registerEventListener";
    private static int sIdCounter = 0;
    private static final int OWN_PROCESS_ID = Process.myPid();
    private static final int DO_SET_SERVICE_INFO = 10;
    private static int sNextWindowId;
    final HandlerCaller mCaller;
    final Context mContext;
    final Object mLock = new Object();
    final List<Service> mServices = new ArrayList<Service>();
    final List<IAccessibilityManagerClient> mClients = new ArrayList<IAccessibilityManagerClient>();
    final Map<ComponentName, Service> mComponentNameToServiceMap = new HashMap<ComponentName, Service>();
    private final List<AccessibilityServiceInfo> mInstalledServices = new ArrayList<AccessibilityServiceInfo>();
    private final Set<ComponentName> mEnabledServices = new HashSet<ComponentName>();
    private final SparseArray<AccessibilityConnectionWrapper> mWindowIdToInteractionConnectionWrapperMap = new SparseArray();
    private final SparseArray<IBinder> mWindowIdToWindowTokenMap = new SparseArray();
    private final TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
    private PackageManager mPackageManager;
    private int mHandledFeedbackTypes = 0;
    private boolean mIsAccessibilityEnabled;
    private AccessibilityInputFilter mInputFilter;
    private boolean mHasInputFilter;
    private final List<AccessibilityServiceInfo> mEnabledServicesForFeedbackTempList = new ArrayList<AccessibilityServiceInfo>();
    private boolean mIsTouchExplorationEnabled;
    private final WindowManagerService mWindowManagerService;
    private final SecurityPolicy mSecurityPolicy;
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            Service service = (Service)((Object)message.obj);
            int eventType = message.arg1;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.notifyEventListenerLocked(service, eventType);
            }
        }
    };

    public AccessibilityManagerService(Context context) {
        this.mContext = context;
        this.mPackageManager = this.mContext.getPackageManager();
        this.mCaller = new HandlerCaller(context, (HandlerCaller.Callback)this);
        this.mWindowManagerService = (WindowManagerService)ServiceManager.getService((String)"window");
        this.mSecurityPolicy = new SecurityPolicy();
        this.registerPackageChangeAndBootCompletedBroadcastReceiver();
        this.registerSettingsContentObservers();
    }

    private void registerPackageChangeAndBootCompletedBroadcastReceiver() {
        Context context = this.mContext;
        PackageMonitor monitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSomePackagesChanged() {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    AccessibilityManagerService.this.populateAccessibilityServiceListLocked();
                    AccessibilityManagerService.this.manageServicesLocked();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onPackageRemoved(String packageName, int uid) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    Iterator it = AccessibilityManagerService.this.mEnabledServices.iterator();
                    while (it.hasNext()) {
                        ComponentName comp = (ComponentName)it.next();
                        String compPkg = comp.getPackageName();
                        if (!compPkg.equals(packageName)) continue;
                        it.remove();
                        this.updateEnabledAccessibilitySerivcesSettingLocked(AccessibilityManagerService.this.mEnabledServices);
                        return;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    boolean changed = false;
                    Iterator it = AccessibilityManagerService.this.mEnabledServices.iterator();
                    while (it.hasNext()) {
                        ComponentName comp = (ComponentName)it.next();
                        String compPkg = comp.getPackageName();
                        for (String pkg : packages) {
                            if (!compPkg.equals(pkg)) continue;
                            if (!doit) {
                                return true;
                            }
                            it.remove();
                            changed = true;
                        }
                    }
                    if (changed) {
                        this.updateEnabledAccessibilitySerivcesSettingLocked(AccessibilityManagerService.this.mEnabledServices);
                    }
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction() == "android.intent.action.BOOT_COMPLETED") {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        AccessibilityManagerService.this.populateAccessibilityServiceListLocked();
                        AccessibilityManagerService.this.mIsAccessibilityEnabled = Settings.Secure.getInt((ContentResolver)AccessibilityManagerService.this.mContext.getContentResolver(), (String)"accessibility_enabled", (int)0) == 1;
                        AccessibilityManagerService.this.manageServicesLocked();
                        AccessibilityManagerService.this.mIsTouchExplorationEnabled = Settings.Secure.getInt((ContentResolver)AccessibilityManagerService.this.mContext.getContentResolver(), (String)"touch_exploration_enabled", (int)0) == 1;
                        AccessibilityManagerService.this.updateInputFilterLocked();
                        AccessibilityManagerService.this.sendStateToClientsLocked();
                    }
                    return;
                }
                super.onReceive(context, intent);
            }

            private void updateEnabledAccessibilitySerivcesSettingLocked(Set<ComponentName> enabledServices) {
                Iterator<ComponentName> it = enabledServices.iterator();
                StringBuilder str = new StringBuilder();
                while (it.hasNext()) {
                    if (str.length() > 0) {
                        str.append(':');
                    }
                    str.append(it.next().flattenToShortString());
                }
                Settings.Secure.putString((ContentResolver)AccessibilityManagerService.this.mContext.getContentResolver(), (String)"enabled_accessibility_services", (String)str.toString());
            }
        };
        monitor.register(context, true);
        IntentFilter bootFiler = new IntentFilter("android.intent.action.BOOT_COMPLETED");
        this.mContext.registerReceiver((BroadcastReceiver)monitor, bootFiler);
    }

    private void registerSettingsContentObservers() {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        Uri accessibilityEnabledUri = Settings.Secure.getUriFor((String)"accessibility_enabled");
        contentResolver.registerContentObserver(accessibilityEnabledUri, false, new ContentObserver(new Handler()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    AccessibilityManagerService.this.handleAccessibilityEnabledSettingChangedLocked();
                }
            }
        });
        Uri touchExplorationRequestedUri = Settings.Secure.getUriFor((String)"touch_exploration_enabled");
        contentResolver.registerContentObserver(touchExplorationRequestedUri, false, new ContentObserver(new Handler()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    AccessibilityManagerService.this.mIsTouchExplorationEnabled = Settings.Secure.getInt((ContentResolver)AccessibilityManagerService.this.mContext.getContentResolver(), (String)"touch_exploration_enabled", (int)0) == 1;
                    AccessibilityManagerService.this.updateInputFilterLocked();
                    AccessibilityManagerService.this.sendStateToClientsLocked();
                }
            }
        });
        Uri accessibilityServicesUri = Settings.Secure.getUriFor((String)"enabled_accessibility_services");
        contentResolver.registerContentObserver(accessibilityServicesUri, false, new ContentObserver(new Handler()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    AccessibilityManagerService.this.manageServicesLocked();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addClient(IAccessibilityManagerClient client) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            final IAccessibilityManagerClient addedClient = client;
            this.mClients.add(addedClient);
            client.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void binderDied() {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        addedClient.asBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
                        AccessibilityManagerService.this.mClients.remove(addedClient);
                    }
                }
            }, 0);
            return this.getState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendAccessibilityEvent(AccessibilityEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSecurityPolicy.canDispatchAccessibilityEvent(event)) {
                this.mSecurityPolicy.updateRetrievalAllowingWindowAndEventSourceLocked(event);
                this.notifyAccessibilityServicesDelayedLocked(event, false);
                this.notifyAccessibilityServicesDelayedLocked(event, true);
            }
        }
        event.recycle();
        this.mHandledFeedbackTypes = 0;
        return OWN_PROCESS_ID != Binder.getCallingPid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInstalledServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackType) {
        List<AccessibilityServiceInfo> result = this.mEnabledServicesForFeedbackTempList;
        result.clear();
        List<Service> services = this.mServices;
        Object object = this.mLock;
        synchronized (object) {
            while (feedbackType != 0) {
                int feedbackTypeBit = 1 << Integer.numberOfTrailingZeros(feedbackType);
                feedbackType &= ~feedbackTypeBit;
                int serviceCount = services.size();
                for (int i = 0; i < serviceCount; ++i) {
                    Service service = services.get(i);
                    if ((service.mFeedbackType & feedbackTypeBit) == 0) continue;
                    result.add(service.mAccessibilityServiceInfo);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mServices.size();
            for (int i = 0; i < count; ++i) {
                Service service = this.mServices.get(i);
                try {
                    service.mServiceInterface.onInterrupt();
                    continue;
                }
                catch (RemoteException re) {
                    Slog.e((String)LOG_TAG, (String)("Error during sending interrupt request to " + service.mService), (Throwable)re);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMessage(Message message) {
        switch (message.what) {
            case 10: {
                HandlerCaller.SomeArgs arguments = (HandlerCaller.SomeArgs)message.obj;
                AccessibilityServiceInfo info = (AccessibilityServiceInfo)arguments.arg1;
                Service service = (Service)((Object)arguments.arg2);
                Object object = this.mLock;
                synchronized (object) {
                    AccessibilityServiceInfo oldInfo = service.mAccessibilityServiceInfo;
                    if (oldInfo != null) {
                        oldInfo.updateDynamicallyConfigurableProperties(info);
                        service.setDynamicallyConfigurableProperties(oldInfo);
                    } else {
                        service.setDynamicallyConfigurableProperties(info);
                    }
                }
                return;
            }
        }
        Slog.w((String)LOG_TAG, (String)("Unknown message type: " + message.what));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAccessibilityInteractionConnection(IWindow windowToken, IAccessibilityInteractionConnection connection) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            IWindow addedWindowToken = windowToken;
            IAccessibilityInteractionConnection addedConnection = connection;
            int windowId = sNextWindowId++;
            AccessibilityConnectionWrapper wrapper = new AccessibilityConnectionWrapper(windowId, connection);
            wrapper.linkToDeath();
            this.mWindowIdToWindowTokenMap.put(windowId, (Object)addedWindowToken.asBinder());
            this.mWindowIdToInteractionConnectionWrapperMap.put(windowId, (Object)wrapper);
            return windowId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessibilityInteractionConnection(IWindow windowToken) {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mWindowIdToWindowTokenMap.size();
            for (int i = 0; i < count; ++i) {
                if (this.mWindowIdToWindowTokenMap.valueAt(i) != windowToken.asBinder()) continue;
                int windowId = this.mWindowIdToWindowTokenMap.keyAt(i);
                AccessibilityConnectionWrapper wrapper = (AccessibilityConnectionWrapper)this.mWindowIdToInteractionConnectionWrapperMap.get(windowId);
                wrapper.unlinkToDeath();
                this.removeAccessibilityInteractionConnectionLocked(windowId);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(IEventListener listener) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.RETRIEVE_WINDOW_CONTENT", FUNCTION_REGISTER_EVENT_LISTENER);
        ComponentName componentName = new ComponentName("foo.bar", "AutomationAccessibilityService");
        Object object = this.mLock;
        synchronized (object) {
            int runningServiceCount = this.mServices.size();
            for (int i = 0; i < runningServiceCount; ++i) {
                Service runningService = this.mServices.get(i);
                runningService.unbind();
            }
            if (!this.mIsAccessibilityEnabled) {
                this.mIsAccessibilityEnabled = true;
                this.sendStateToClientsLocked();
            }
        }
        AccessibilityServiceInfo accessibilityServiceInfo = new AccessibilityServiceInfo();
        accessibilityServiceInfo.eventTypes = -1;
        accessibilityServiceInfo.feedbackType = 16;
        Service service = new Service(componentName, accessibilityServiceInfo, true);
        service.onServiceConnected(componentName, listener.asBinder());
    }

    private void removeAccessibilityInteractionConnectionLocked(int windowId) {
        this.mWindowIdToWindowTokenMap.remove(windowId);
        this.mWindowIdToInteractionConnectionWrapperMap.remove(windowId);
    }

    private void populateAccessibilityServiceListLocked() {
        this.mInstalledServices.clear();
        List installedServices = this.mPackageManager.queryIntentServices(new Intent("android.accessibilityservice.AccessibilityService"), 132);
        int count = installedServices.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = (ResolveInfo)installedServices.get(i);
            try {
                AccessibilityServiceInfo accessibilityServiceInfo = new AccessibilityServiceInfo(resolveInfo, this.mContext);
                this.mInstalledServices.add(accessibilityServiceInfo);
                continue;
            }
            catch (XmlPullParserException xppe) {
                Slog.e((String)LOG_TAG, (String)"Error while initializing AccessibilityServiceInfo", (Throwable)xppe);
                continue;
            }
            catch (IOException ioe) {
                Slog.e((String)LOG_TAG, (String)"Error while initializing AccessibilityServiceInfo", (Throwable)ioe);
            }
        }
    }

    private void notifyAccessibilityServicesDelayedLocked(AccessibilityEvent event, boolean isDefault) {
        try {
            int count = this.mServices.size();
            for (int i = 0; i < count; ++i) {
                Service service = this.mServices.get(i);
                if (service.mIsDefault != isDefault || !this.canDispathEventLocked(service, event, this.mHandledFeedbackTypes)) continue;
                this.mHandledFeedbackTypes |= service.mFeedbackType;
                this.notifyAccessibilityServiceDelayedLocked(service, event);
            }
        }
        catch (IndexOutOfBoundsException oobe) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAccessibilityServiceDelayedLocked(Service service, AccessibilityEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            int eventType = event.getEventType();
            AccessibilityEvent newEvent = AccessibilityEvent.obtain((AccessibilityEvent)event);
            AccessibilityEvent oldEvent = (AccessibilityEvent)service.mPendingEvents.get(eventType);
            service.mPendingEvents.put(eventType, (Object)newEvent);
            int what = eventType | service.mId << 16;
            if (oldEvent != null) {
                this.mHandler.removeMessages(what);
                oldEvent.recycle();
            }
            Message message = this.mHandler.obtainMessage(what, (Object)service);
            message.arg1 = eventType;
            this.mHandler.sendMessageDelayed(message, service.mNotificationTimeout);
        }
    }

    private void notifyEventListenerLocked(Service service, int eventType) {
        IEventListener listener = service.mServiceInterface;
        if (listener == null) {
            return;
        }
        AccessibilityEvent event = (AccessibilityEvent)service.mPendingEvents.get(eventType);
        if (event == null) {
            return;
        }
        service.mPendingEvents.remove(eventType);
        try {
            if (this.mSecurityPolicy.canRetrieveWindowContent(service)) {
                event.setConnectionId(service.mId);
            } else {
                event.setSource(null);
            }
            event.setSealed(true);
            listener.onAccessibilityEvent(event);
            event.recycle();
        }
        catch (RemoteException re) {
            Slog.e((String)LOG_TAG, (String)("Error during sending " + event + " to " + service.mService), (Throwable)re);
        }
    }

    private void tryAddServiceLocked(Service service) {
        try {
            if (this.mServices.contains((Object)service) || !service.isConfigured()) {
                return;
            }
            service.linkToOwnDeath();
            this.mServices.add(service);
            this.mComponentNameToServiceMap.put(service.mComponentName, service);
            this.updateInputFilterLocked();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private boolean tryRemoveServiceLocked(Service service) {
        boolean removed = this.mServices.remove((Object)service);
        if (!removed) {
            return false;
        }
        this.mComponentNameToServiceMap.remove(service.mComponentName);
        this.mHandler.removeMessages(service.mId);
        service.unlinkToOwnDeath();
        service.dispose();
        this.updateInputFilterLocked();
        return removed;
    }

    private boolean canDispathEventLocked(Service service, AccessibilityEvent event, int handledFeedbackTypes) {
        int feedbackType;
        if (!service.isConfigured()) {
            return false;
        }
        int eventType = event.getEventType();
        if ((service.mEventTypes & eventType) != eventType) {
            return false;
        }
        Set<String> packageNames = service.mPackageNames;
        CharSequence packageName = event.getPackageName();
        return !(!packageNames.isEmpty() && !packageNames.contains(packageName) || (handledFeedbackTypes & (feedbackType = service.mFeedbackType)) == feedbackType && feedbackType != 16);
    }

    private void manageServicesLocked() {
        this.unbindAutomationService();
        this.populateEnabledServicesLocked(this.mEnabledServices);
        int enabledInstalledServicesCount = this.updateServicesStateLocked(this.mInstalledServices, this.mEnabledServices);
        if (this.mIsAccessibilityEnabled && enabledInstalledServicesCount == 0) {
            Settings.Secure.putInt((ContentResolver)this.mContext.getContentResolver(), (String)"accessibility_enabled", (int)0);
        }
    }

    private void unbindAllServicesLocked() {
        List<Service> services = this.mServices;
        int count = services.size();
        for (int i = 0; i < count; ++i) {
            Service service = services.get(i);
            if (!service.unbind()) continue;
            --i;
            --count;
        }
    }

    private void unbindAutomationService() {
        List<Service> runningServices = this.mServices;
        int runningServiceCount = this.mServices.size();
        for (int i = 0; i < runningServiceCount; ++i) {
            Service service = runningServices.get(i);
            if (!service.mIsAutomation) continue;
            service.unbind();
            return;
        }
    }

    private void populateEnabledServicesLocked(Set<ComponentName> enabledServices) {
        enabledServices.clear();
        String servicesValue = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"enabled_accessibility_services");
        if (servicesValue != null) {
            TextUtils.SimpleStringSplitter splitter = this.mStringColonSplitter;
            splitter.setString(servicesValue);
            while (splitter.hasNext()) {
                ComponentName enabledService;
                String str = splitter.next();
                if (str == null || str.length() <= 0 || (enabledService = ComponentName.unflattenFromString((String)str)) == null) continue;
                enabledServices.add(enabledService);
            }
        }
    }

    private int updateServicesStateLocked(List<AccessibilityServiceInfo> installedServices, Set<ComponentName> enabledServices) {
        Map<ComponentName, Service> componentNameToServiceMap = this.mComponentNameToServiceMap;
        boolean isEnabled = this.mIsAccessibilityEnabled;
        int enabledInstalledServices = 0;
        int count = installedServices.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityServiceInfo installedService = installedServices.get(i);
            ComponentName componentName = ComponentName.unflattenFromString((String)installedService.getId());
            Service service = componentNameToServiceMap.get(componentName);
            if (isEnabled) {
                if (enabledServices.contains(componentName)) {
                    if (service == null) {
                        service = new Service(componentName, installedService, false);
                    }
                    service.bind();
                    ++enabledInstalledServices;
                    continue;
                }
                if (service == null) continue;
                service.unbind();
                continue;
            }
            if (service == null) continue;
            service.unbind();
        }
        return enabledInstalledServices;
    }

    private void sendStateToClientsLocked() {
        int state = this.getState();
        int count = this.mClients.size();
        for (int i = 0; i < count; ++i) {
            try {
                this.mClients.get(i).setState(state);
                continue;
            }
            catch (RemoteException re) {
                this.mClients.remove(i);
                --count;
                --i;
            }
        }
    }

    private int getState() {
        int state = 0;
        if (this.mIsAccessibilityEnabled) {
            state |= 1;
        }
        if (this.mIsAccessibilityEnabled && this.mIsTouchExplorationEnabled) {
            state |= 2;
        }
        return state;
    }

    private void updateInputFilterLocked() {
        if (this.mIsAccessibilityEnabled && this.mIsTouchExplorationEnabled) {
            if (!this.mHasInputFilter) {
                this.mHasInputFilter = true;
                if (this.mInputFilter == null) {
                    this.mInputFilter = new AccessibilityInputFilter(this.mContext);
                }
                this.mWindowManagerService.setInputFilter(this.mInputFilter);
            }
            return;
        }
        if (this.mHasInputFilter) {
            this.mHasInputFilter = false;
            this.mWindowManagerService.setInputFilter(null);
        }
    }

    private void handleAccessibilityEnabledSettingChangedLocked() {
        boolean bl = this.mIsAccessibilityEnabled = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"accessibility_enabled", (int)0) == 1;
        if (this.mIsAccessibilityEnabled) {
            this.manageServicesLocked();
        } else {
            this.unbindAllServicesLocked();
        }
        this.updateInputFilterLocked();
        this.sendStateToClientsLocked();
    }

    final class SecurityPolicy {
        private static final int VALID_ACTIONS = 15;
        private static final int RETRIEVAL_ALLOWING_EVENT_TYPES = 14783;
        private static final int RETRIEVAL_ALLOWING_WINDOW_CHANGE_EVENT_TYPES = 416;
        private int mRetrievalAlowingWindowId;

        SecurityPolicy() {
        }

        private boolean canDispatchAccessibilityEvent(AccessibilityEvent event) {
            return event.getEventType() != 2048 || event.getWindowId() == this.mRetrievalAlowingWindowId;
        }

        public void updateRetrievalAllowingWindowAndEventSourceLocked(AccessibilityEvent event) {
            int windowId = event.getWindowId();
            int eventType = event.getEventType();
            if ((eventType & 0x1A0) != 0) {
                this.mRetrievalAlowingWindowId = windowId;
            }
            if ((eventType & 0x39BF) == 0) {
                event.setSource(null);
            }
        }

        public int getRetrievalAllowingWindowLocked() {
            return this.mRetrievalAlowingWindowId;
        }

        public boolean canGetAccessibilityNodeInfoLocked(Service service, int windowId) {
            return this.canRetrieveWindowContent(service) && this.isRetrievalAllowingWindow(windowId);
        }

        public boolean canPerformActionLocked(Service service, int windowId, int action) {
            return this.canRetrieveWindowContent(service) && this.isRetrievalAllowingWindow(windowId) && this.isActionPermitted(action);
        }

        public boolean canRetrieveWindowContent(Service service) {
            return service.mCanRetrieveScreenContent;
        }

        public void enforceCanRetrieveWindowContent(Service service) throws RemoteException {
            if (!this.canRetrieveWindowContent(service)) {
                Slog.e((String)AccessibilityManagerService.LOG_TAG, (String)("Accessibility serivce " + service.mComponentName + " does not " + "declare android:canRetrieveWindowContent."));
                throw new RemoteException();
            }
        }

        private boolean isRetrievalAllowingWindow(int windowId) {
            return this.mRetrievalAlowingWindowId == windowId;
        }

        private boolean isActionPermitted(int action) {
            return (0xF & action) != 0;
        }

        private void enforceCallingPermission(String permission, String function) {
            if (OWN_PROCESS_ID == Binder.getCallingPid()) {
                return;
            }
            int permissionStatus = AccessibilityManagerService.this.mContext.checkCallingPermission(permission);
            if (permissionStatus != 0) {
                throw new SecurityException("You do not have " + permission + " required to call " + function);
            }
        }
    }

    class Service
    extends IAccessibilityServiceConnection.Stub
    implements ServiceConnection,
    IBinder.DeathRecipient {
        int mId = 0;
        AccessibilityServiceInfo mAccessibilityServiceInfo;
        IBinder mService;
        IEventListener mServiceInterface;
        int mEventTypes;
        int mFeedbackType;
        Set<String> mPackageNames = new HashSet<String>();
        boolean mIsDefault;
        long mNotificationTimeout;
        ComponentName mComponentName;
        Intent mIntent;
        boolean mCanRetrieveScreenContent;
        boolean mIsAutomation;
        final Rect mTempBounds = new Rect();
        final SparseArray<AccessibilityEvent> mPendingEvents = new SparseArray();

        public Service(ComponentName componentName, AccessibilityServiceInfo accessibilityServiceInfo, boolean isAutomation) {
            this.mId = sIdCounter++;
            this.mComponentName = componentName;
            this.mAccessibilityServiceInfo = accessibilityServiceInfo;
            this.mIsAutomation = isAutomation;
            if (!isAutomation) {
                this.mCanRetrieveScreenContent = accessibilityServiceInfo.getCanRetrieveWindowContent();
                this.mIntent = new Intent().setComponent(this.mComponentName);
                this.mIntent.putExtra("android.intent.extra.client_label", 17040447);
                this.mIntent.putExtra("android.intent.extra.client_intent", (Parcelable)PendingIntent.getActivity((Context)AccessibilityManagerService.this.mContext, (int)0, (Intent)new Intent("android.settings.ACCESSIBILITY_SETTINGS"), (int)0));
            } else {
                this.mCanRetrieveScreenContent = true;
            }
            this.setDynamicallyConfigurableProperties(accessibilityServiceInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDynamicallyConfigurableProperties(AccessibilityServiceInfo info) {
            this.mEventTypes = info.eventTypes;
            this.mFeedbackType = info.feedbackType;
            String[] packageNames = info.packageNames;
            if (packageNames != null) {
                this.mPackageNames.addAll(Arrays.asList(packageNames));
            }
            this.mNotificationTimeout = info.notificationTimeout;
            this.mIsDefault = (info.flags & 1) != 0;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.tryAddServiceLocked(this);
            }
        }

        public boolean bind() {
            if (!this.mIsAutomation && this.mService == null) {
                return AccessibilityManagerService.this.mContext.bindService(this.mIntent, (ServiceConnection)this, 1);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean unbind() {
            if (this.mService != null) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    AccessibilityManagerService.this.tryRemoveServiceLocked(this);
                }
                if (!this.mIsAutomation) {
                    AccessibilityManagerService.this.mContext.unbindService((ServiceConnection)this);
                }
                return true;
            }
            return false;
        }

        public boolean isConfigured() {
            return this.mEventTypes != 0 && this.mFeedbackType != 0 && this.mService != null;
        }

        public void setServiceInfo(AccessibilityServiceInfo info) {
            AccessibilityManagerService.this.mCaller.obtainMessageOO(10, (Object)info, (Object)this).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder service) {
            this.mService = service;
            this.mServiceInterface = IEventListener.Stub.asInterface((IBinder)service);
            try {
                this.mServiceInterface.setConnection((IAccessibilityServiceConnection)this, this.mId);
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    AccessibilityManagerService.this.tryAddServiceLocked(this);
                }
            }
            catch (RemoteException re) {
                Slog.w((String)AccessibilityManagerService.LOG_TAG, (String)("Error while setting Controller for service: " + service), (Throwable)re);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float findAccessibilityNodeInfoByViewIdInActiveWindow(int viewId, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.mSecurityPolicy.enforceCanRetrieveWindowContent(this);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowContent(this);
                if (!permissionGranted) {
                    return 0.0f;
                }
                connection = this.getConnectionToRetrievalAllowingWindowLocked();
                if (connection == null) {
                    return 0.0f;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            try {
                connection.findAccessibilityNodeInfoByViewId(viewId, interactionId, callback, interrogatingPid, interrogatingTid);
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity((long)identityToken);
            }
            return this.getCompatibilityScale(AccessibilityManagerService.this.mSecurityPolicy.getRetrievalAllowingWindowLocked());
        }

        public float findAccessibilityNodeInfosByViewTextInActiveWindow(String text, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
            return this.findAccessibilityNodeInfosByViewText(text, AccessibilityManagerService.this.mSecurityPolicy.mRetrievalAlowingWindowId, -1, interactionId, callback, threadId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float findAccessibilityNodeInfosByViewText(String text, int accessibilityWindowId, int accessibilityViewId, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.mSecurityPolicy.enforceCanRetrieveWindowContent(this);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, accessibilityWindowId);
                if (!permissionGranted) {
                    return 0.0f;
                }
                connection = this.getConnectionToRetrievalAllowingWindowLocked();
                if (connection == null) {
                    return 0.0f;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            try {
                connection.findAccessibilityNodeInfosByViewText(text, accessibilityViewId, interactionId, callback, interrogatingPid, interrogatingTid);
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity((long)identityToken);
            }
            return this.getCompatibilityScale(accessibilityWindowId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float findAccessibilityNodeInfoByAccessibilityId(int accessibilityWindowId, int accessibilityViewId, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.mSecurityPolicy.enforceCanRetrieveWindowContent(this);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, accessibilityWindowId);
                if (!permissionGranted) {
                    return 0.0f;
                }
                AccessibilityConnectionWrapper wrapper = (AccessibilityConnectionWrapper)AccessibilityManagerService.this.mWindowIdToInteractionConnectionWrapperMap.get(accessibilityWindowId);
                if (wrapper == null) {
                    return 0.0f;
                }
                connection = wrapper.mConnection;
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            try {
                connection.findAccessibilityNodeInfoByAccessibilityId(accessibilityViewId, interactionId, callback, interrogatingPid, interrogatingTid);
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity((long)identityToken);
            }
            return this.getCompatibilityScale(accessibilityWindowId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean performAccessibilityAction(int accessibilityWindowId, int accessibilityViewId, int action, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) {
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canPerformActionLocked(this, accessibilityWindowId, action);
                if (!permissionGranted) {
                    return false;
                }
                AccessibilityConnectionWrapper wrapper = (AccessibilityConnectionWrapper)AccessibilityManagerService.this.mWindowIdToInteractionConnectionWrapperMap.get(accessibilityWindowId);
                if (wrapper == null) {
                    return false;
                }
                connection = wrapper.mConnection;
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            try {
                connection.performAccessibilityAction(accessibilityViewId, action, interactionId, callback, interrogatingPid, interrogatingTid);
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity((long)identityToken);
            }
            return true;
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }

        public void linkToOwnDeath() throws RemoteException {
            this.mService.linkToDeath((IBinder.DeathRecipient)this, 0);
        }

        public void unlinkToOwnDeath() {
            this.mService.unlinkToDeath((IBinder.DeathRecipient)this, 0);
        }

        public void dispose() {
            try {
                this.mServiceInterface.setConnection(null, this.mId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mService = null;
            this.mServiceInterface = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.unlinkToOwnDeath();
                AccessibilityManagerService.this.tryRemoveServiceLocked(this);
                if (this.mIsAutomation) {
                    AccessibilityManagerService.this.handleAccessibilityEnabledSettingChangedLocked();
                }
            }
        }

        private IAccessibilityInteractionConnection getConnectionToRetrievalAllowingWindowLocked() {
            int windowId = AccessibilityManagerService.this.mSecurityPolicy.getRetrievalAllowingWindowLocked();
            AccessibilityConnectionWrapper wrapper = (AccessibilityConnectionWrapper)AccessibilityManagerService.this.mWindowIdToInteractionConnectionWrapperMap.get(windowId);
            return wrapper != null ? wrapper.mConnection : null;
        }

        private float getCompatibilityScale(int windowId) {
            IBinder windowToken = (IBinder)AccessibilityManagerService.this.mWindowIdToWindowTokenMap.get(windowId);
            return AccessibilityManagerService.this.mWindowManagerService.getWindowCompatibilityScale(windowToken);
        }
    }

    private class AccessibilityConnectionWrapper
    implements IBinder.DeathRecipient {
        private final int mWindowId;
        private final IAccessibilityInteractionConnection mConnection;

        public AccessibilityConnectionWrapper(int windowId, IAccessibilityInteractionConnection connection) {
            this.mWindowId = windowId;
            this.mConnection = connection;
        }

        public void linkToDeath() throws RemoteException {
            this.mConnection.asBinder().linkToDeath((IBinder.DeathRecipient)this, 0);
        }

        public void unlinkToDeath() {
            this.mConnection.asBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            this.unlinkToDeath();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.removeAccessibilityInteractionConnectionLocked(this.mWindowId);
            }
        }
    }
}

