/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.Context;
import android.os.Handler;
import android.view.InputEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.android.server.accessibility.AccessibilityInputFilter;
import com.android.server.wm.InputFilter;
import java.util.Arrays;

public class TouchExplorer
implements AccessibilityInputFilter.Explorer {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG_RECEIVED = "TouchExplorer-RECEIVED";
    private static final String LOG_TAG_INJECTED = "TouchExplorer-INJECTED";
    private static final String LOG_TAG_STATE = "TouchExplorer-STATE";
    private static final int STATE_TOUCH_EXPLORING = 1;
    private static final int STATE_DRAGGING = 2;
    private static final int STATE_DELEGATING = 4;
    private static final int INVALID_POINTER_ID = -1;
    private static final long ACTIVATION_TIME_SLOP = 2000L;
    private static final int MAX_POINTER_COUNT = 32;
    private static final float MAX_DRAGGING_ANGLE_COS = 0.52532196f;
    private static final long DELAY_SEND_HOVER_ENTER = 200L;
    private static final int ALL_POINTER_ID_BITS = -1;
    private final int[] mTempPointerIds = new int[32];
    private final int mTouchExplorationTapSlop;
    private final InputFilter mInputFilter;
    private final PointerTracker mPointerTracker;
    private final AccessibilityManager mAccessibilityManager;
    private MotionEvent mLastTouchExploreEvent;
    private int mCurrentState = 1;
    private boolean mTouchExploreGestureInProgress;
    private int mDraggingPointerId;
    private final Handler mHandler;
    private final SendHoverDelayed mSendHoverDelayed;
    private final PerformLongPressDelayed mPerformLongPressDelayed;

    public TouchExplorer(InputFilter inputFilter, Context context) {
        this.mInputFilter = inputFilter;
        this.mTouchExplorationTapSlop = ViewConfiguration.get((Context)context).getScaledTouchExplorationTapSlop();
        this.mPointerTracker = new PointerTracker(context);
        this.mHandler = new Handler(context.getMainLooper());
        this.mSendHoverDelayed = new SendHoverDelayed();
        this.mPerformLongPressDelayed = new PerformLongPressDelayed();
        this.mAccessibilityManager = AccessibilityManager.getInstance((Context)context);
    }

    public void clear(MotionEvent event, int policyFlags) {
        this.sendUpForInjectedDownPointers(event, policyFlags);
        this.clear();
    }

    public void onMotionEvent(MotionEvent event, int policyFlags) {
        this.mPointerTracker.onReceivedMotionEvent(event);
        switch (this.mCurrentState) {
            case 1: {
                this.handleMotionEventStateTouchExploring(event, policyFlags);
                break;
            }
            case 2: {
                this.handleMotionEventStateDragging(event, policyFlags);
                break;
            }
            case 4: {
                this.handleMotionEventStateDelegating(event, policyFlags);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state: " + this.mCurrentState);
            }
        }
    }

    private void handleMotionEventStateTouchExploring(MotionEvent event, int policyFlags) {
        PointerTracker pointerTracker = this.mPointerTracker;
        int activePointerCount = pointerTracker.getActivePointerCount();
        block0 : switch (event.getActionMasked()) {
            case 0: 
            case 5: {
                switch (activePointerCount) {
                    case 0: {
                        throw new IllegalStateException("The must always be one active pointer intouch exploring state!");
                    }
                    case 1: {
                        long lastExploreTime;
                        this.mSendHoverDelayed.remove();
                        this.mPerformLongPressDelayed.remove();
                        int pointerId = pointerTracker.getPrimaryActivePointerId();
                        int pointerIdBits = 1 << pointerId;
                        int lastAction = pointerTracker.getLastInjectedHoverAction();
                        if (lastAction == 10) {
                            this.mSendHoverDelayed.post(event, 9, pointerIdBits, policyFlags, 200L);
                        } else {
                            this.sendMotionEvent(event, 7, pointerIdBits, policyFlags);
                        }
                        if (this.mLastTouchExploreEvent == null) break;
                        if (event.getPointerCount() != this.mLastTouchExploreEvent.getPointerCount()) {
                            this.mLastTouchExploreEvent = null;
                            break;
                        }
                        long pointerDownTime = pointerTracker.getReceivedPointerDownTime(pointerId);
                        long deltaTimeExplore = pointerDownTime - (lastExploreTime = this.mLastTouchExploreEvent.getEventTime());
                        if (deltaTimeExplore > 2000L) break block0;
                        this.mPerformLongPressDelayed.post(event, policyFlags, ViewConfiguration.getLongPressTimeout());
                        break;
                    }
                }
                break;
            }
            case 2: {
                int pointerId = pointerTracker.getPrimaryActivePointerId();
                int pointerIndex = event.findPointerIndex(pointerId);
                int pointerIdBits = 1 << pointerId;
                switch (activePointerCount) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        float moveDelta;
                        float deltaY;
                        float deltaX;
                        if (!this.mTouchExploreGestureInProgress) {
                            deltaX = pointerTracker.getReceivedPointerDownX(pointerId) - event.getX(pointerIndex);
                            double moveDelta2 = Math.hypot(deltaX, deltaY = pointerTracker.getReceivedPointerDownY(pointerId) - event.getY(pointerIndex));
                            if (moveDelta2 > (double)this.mTouchExplorationTapSlop) {
                                this.mTouchExploreGestureInProgress = true;
                                this.sendAccessibilityEvent(512);
                                this.mSendHoverDelayed.forceSendAndRemove();
                                this.mPerformLongPressDelayed.remove();
                                int lastAction = this.mPointerTracker.getLastInjectedHoverAction();
                                if (lastAction == 10) {
                                    this.sendMotionEvent(event, 9, pointerIdBits, policyFlags);
                                }
                                this.sendMotionEvent(event, 7, pointerIdBits, policyFlags);
                            }
                        } else {
                            this.sendMotionEvent(event, 7, pointerIdBits, policyFlags);
                        }
                        if (this.mTouchExploreGestureInProgress || this.mLastTouchExploreEvent == null || !this.mPerformLongPressDelayed.isPenidng() || !((moveDelta = (float)Math.hypot(deltaX = this.mLastTouchExploreEvent.getX(pointerIndex) - event.getX(pointerIndex), deltaY = this.mLastTouchExploreEvent.getY(pointerIndex) - event.getY(pointerIndex))) > (float)this.mTouchExplorationTapSlop)) break block0;
                        this.mLastTouchExploreEvent = null;
                        this.mPerformLongPressDelayed.remove();
                        break;
                    }
                    case 2: {
                        this.mSendHoverDelayed.remove();
                        this.mPerformLongPressDelayed.remove();
                        this.ensureHoverExitSent(event, pointerIdBits, policyFlags);
                        if (this.isDraggingGesture(event)) {
                            this.mCurrentState = 2;
                            if (this.mTouchExploreGestureInProgress) {
                                this.sendAccessibilityEvent(1024);
                                this.mTouchExploreGestureInProgress = false;
                            }
                            this.mLastTouchExploreEvent = null;
                            this.mDraggingPointerId = pointerId;
                            this.sendMotionEvent(event, 0, pointerIdBits, policyFlags);
                            break;
                        }
                        this.mCurrentState = 4;
                        this.mSendHoverDelayed.remove();
                        if (this.mTouchExploreGestureInProgress) {
                            this.sendAccessibilityEvent(1024);
                            this.mTouchExploreGestureInProgress = false;
                        }
                        this.mLastTouchExploreEvent = null;
                        this.sendDownForAllActiveNotInjectedPointers(event, policyFlags);
                        break;
                    }
                    default: {
                        this.mSendHoverDelayed.remove();
                        this.mPerformLongPressDelayed.remove();
                        this.ensureHoverExitSent(event, pointerIdBits, policyFlags);
                        this.mCurrentState = 4;
                        this.mSendHoverDelayed.remove();
                        if (this.mTouchExploreGestureInProgress) {
                            this.sendAccessibilityEvent(1024);
                            this.mTouchExploreGestureInProgress = false;
                        }
                        this.mLastTouchExploreEvent = null;
                        this.sendDownForAllActiveNotInjectedPointers(event, policyFlags);
                        break;
                    }
                }
                break;
            }
            case 1: 
            case 6: {
                int pointerId = pointerTracker.getLastReceivedUpPointerId();
                int pointerIdBits = 1 << pointerId;
                switch (activePointerCount) {
                    case 0: {
                        if (!pointerTracker.wasLastReceivedUpPointerActive()) break;
                        this.mPerformLongPressDelayed.remove();
                        if (this.mTouchExploreGestureInProgress) {
                            this.mTouchExploreGestureInProgress = false;
                            this.mSendHoverDelayed.forceSendAndRemove();
                            this.ensureHoverExitSent(event, pointerIdBits, policyFlags);
                            this.mLastTouchExploreEvent = MotionEvent.obtain((MotionEvent)event);
                            this.sendAccessibilityEvent(1024);
                            break;
                        }
                        if (this.mLastTouchExploreEvent != null) {
                            float deltaY;
                            long exploreTime;
                            long eventTime = pointerTracker.getLastReceivedUpPointerDownTime();
                            long deltaTime = eventTime - (exploreTime = this.mLastTouchExploreEvent.getEventTime());
                            if (deltaTime > 2000L) {
                                this.mSendHoverDelayed.forceSendAndRemove();
                                this.ensureHoverExitSent(event, pointerIdBits, policyFlags);
                                this.mLastTouchExploreEvent = MotionEvent.obtain((MotionEvent)event);
                                break;
                            }
                            int pointerIndex = event.findPointerIndex(pointerId);
                            float deltaX = this.mLastTouchExploreEvent.getX(pointerIndex) - event.getX(pointerIndex);
                            float deltaMove = (float)Math.hypot(deltaX, deltaY = this.mLastTouchExploreEvent.getY(pointerIndex) - event.getY(pointerIndex));
                            if (deltaMove > (float)this.mTouchExplorationTapSlop) {
                                this.mSendHoverDelayed.forceSendAndRemove();
                                this.ensureHoverExitSent(event, pointerIdBits, policyFlags);
                                this.mLastTouchExploreEvent = MotionEvent.obtain((MotionEvent)event);
                                break;
                            }
                            this.mSendHoverDelayed.remove();
                            this.ensureHoverExitSent(event, pointerIdBits, policyFlags);
                            this.sendActionDownAndUp(this.mLastTouchExploreEvent, policyFlags);
                            this.mLastTouchExploreEvent = null;
                            break;
                        }
                        this.mSendHoverDelayed.forceSendAndRemove();
                        this.ensureHoverExitSent(event, pointerIdBits, policyFlags);
                        this.mLastTouchExploreEvent = MotionEvent.obtain((MotionEvent)event);
                    }
                }
                break;
            }
            case 3: {
                this.mSendHoverDelayed.remove();
                this.mPerformLongPressDelayed.remove();
                int pointerId = pointerTracker.getPrimaryActivePointerId();
                int pointerIdBits = 1 << pointerId;
                this.ensureHoverExitSent(event, pointerIdBits, policyFlags);
                this.clear();
            }
        }
    }

    private void handleMotionEventStateDragging(MotionEvent event, int policyFlags) {
        int pointerIdBits = 1 << this.mDraggingPointerId;
        block0 : switch (event.getActionMasked()) {
            case 0: {
                throw new IllegalStateException("Dragging state can be reached only if two pointers are already down");
            }
            case 5: {
                this.mCurrentState = 4;
                this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                this.sendDownForAllActiveNotInjectedPointers(event, policyFlags);
                break;
            }
            case 2: {
                int activePointerCount = this.mPointerTracker.getActivePointerCount();
                switch (activePointerCount) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        if (this.isDraggingGesture(event)) {
                            this.sendMotionEvent(event, 2, pointerIdBits, policyFlags);
                            break block0;
                        }
                        this.mCurrentState = 4;
                        this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                        this.sendDownForAllActiveNotInjectedPointers(event, policyFlags);
                        break block0;
                    }
                }
                this.mCurrentState = 4;
                this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                this.sendDownForAllActiveNotInjectedPointers(event, policyFlags);
                break;
            }
            case 6: {
                int activePointerCount = this.mPointerTracker.getActivePointerCount();
                switch (activePointerCount) {
                    case 1: {
                        this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                        break block0;
                    }
                }
                this.mCurrentState = 1;
                break;
            }
            case 1: {
                this.mCurrentState = 1;
                break;
            }
            case 3: {
                this.clear();
            }
        }
    }

    private void handleMotionEventStateDelegating(MotionEvent event, int policyFlags) {
        switch (event.getActionMasked()) {
            case 0: {
                throw new IllegalStateException("Delegating state can only be reached if there is at least one pointer down!");
            }
            case 1: {
                this.mCurrentState = 1;
                break;
            }
            case 2: {
                int notInjectedCount = this.mPointerTracker.getNotInjectedActivePointerCount();
                if (notInjectedCount <= 0) break;
                MotionEvent prototype = MotionEvent.obtain((MotionEvent)event);
                this.sendDownForAllActiveNotInjectedPointers(prototype, policyFlags);
                break;
            }
            case 6: {
                if (this.mPointerTracker.getActivePointerCount() != 0) break;
                this.mCurrentState = 1;
                break;
            }
            case 3: {
                this.clear();
            }
        }
        this.sendMotionEventStripInactivePointers(event, policyFlags);
    }

    private void sendDownForAllActiveNotInjectedPointers(MotionEvent prototype, int policyFlags) {
        int pointerId;
        int i;
        PointerTracker pointerTracker = this.mPointerTracker;
        int pointerIdBits = 0;
        int pointerCount = prototype.getPointerCount();
        for (i = 0; i < pointerCount; ++i) {
            pointerId = prototype.getPointerId(i);
            if (!pointerTracker.isInjectedPointerDown(pointerId)) continue;
            pointerIdBits |= 1 << pointerId;
        }
        for (i = 0; i < pointerCount; ++i) {
            pointerId = prototype.getPointerId(i);
            if (!pointerTracker.isActivePointer(pointerId) || pointerTracker.isInjectedPointerDown(pointerId)) continue;
            int action = this.computeInjectionAction(0, i);
            this.sendMotionEvent(prototype, action, pointerIdBits |= 1 << pointerId, policyFlags);
        }
    }

    private void ensureHoverExitSent(MotionEvent prototype, int pointerIdBits, int policyFlags) {
        int lastAction = this.mPointerTracker.getLastInjectedHoverAction();
        if (lastAction != 10) {
            this.sendMotionEvent(prototype, 10, pointerIdBits, policyFlags);
        }
    }

    private void sendUpForInjectedDownPointers(MotionEvent prototype, int policyFlags) {
        PointerTracker pointerTracker = this.mPointerTracker;
        int pointerIdBits = 0;
        int pointerCount = prototype.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            int pointerId = prototype.getPointerId(i);
            if (!pointerTracker.isInjectedPointerDown(pointerId)) continue;
            int action = this.computeInjectionAction(1, i);
            this.sendMotionEvent(prototype, action, pointerIdBits |= 1 << pointerId, policyFlags);
        }
    }

    private void sendMotionEventStripInactivePointers(MotionEvent prototype, int policyFlags) {
        PointerTracker pointerTracker = this.mPointerTracker;
        if (prototype.getPointerCount() == pointerTracker.getActivePointerCount()) {
            this.sendMotionEvent(prototype, prototype.getAction(), -1, policyFlags);
            return;
        }
        if (pointerTracker.getActivePointerCount() == 0 && !pointerTracker.wasLastReceivedUpPointerActive()) {
            return;
        }
        int actionMasked = prototype.getActionMasked();
        int actionPointerId = prototype.getPointerId(prototype.getActionIndex());
        if (actionMasked != 2 && !pointerTracker.isActiveOrWasLastActiveUpPointer(actionPointerId)) {
            return;
        }
        int pointerIdBits = 0;
        int pointerCount = prototype.getPointerCount();
        for (int pointerIndex = 0; pointerIndex < pointerCount; ++pointerIndex) {
            int pointerId = prototype.getPointerId(pointerIndex);
            if (!pointerTracker.isActiveOrWasLastActiveUpPointer(pointerId)) continue;
            pointerIdBits |= 1 << pointerId;
        }
        this.sendMotionEvent(prototype, prototype.getAction(), pointerIdBits, policyFlags);
    }

    private void sendActionDownAndUp(MotionEvent prototype, int policyFlags) {
        int pointerId = prototype.getPointerId(prototype.getActionIndex());
        int pointerIdBits = 1 << pointerId;
        this.sendMotionEvent(prototype, 0, pointerIdBits, policyFlags);
        this.sendMotionEvent(prototype, 1, pointerIdBits, policyFlags);
    }

    private void sendMotionEvent(MotionEvent prototype, int action, int pointerIdBits, int policyFlags) {
        prototype.setAction(action);
        MotionEvent event = null;
        event = pointerIdBits == -1 ? prototype : prototype.split(pointerIdBits);
        if (action == 0) {
            event.setDownTime(event.getEventTime());
        } else {
            event.setDownTime(this.mPointerTracker.getLastInjectedDownEventTime());
        }
        this.mPointerTracker.onInjectedMotionEvent(event);
        this.mInputFilter.sendInputEvent((InputEvent)event, policyFlags |= 0x40000000);
        if (event != prototype) {
            event.recycle();
        }
    }

    private int computeInjectionAction(int actionMasked, int pointerIndex) {
        switch (actionMasked) {
            case 0: 
            case 5: {
                PointerTracker pointerTracker = this.mPointerTracker;
                if (pointerTracker.getInjectedPointerDownCount() == 0) {
                    return 0;
                }
                return pointerIndex << 8 | 5;
            }
            case 6: {
                PointerTracker pointerTracker = this.mPointerTracker;
                if (pointerTracker.getInjectedPointerDownCount() == 1) {
                    return 1;
                }
                return pointerIndex << 8 | 6;
            }
        }
        return actionMasked;
    }

    private boolean isDraggingGesture(MotionEvent event) {
        float secondYNormalized;
        PointerTracker pointerTracker = this.mPointerTracker;
        int[] pointerIds = this.mTempPointerIds;
        pointerTracker.populateActivePointerIds(pointerIds);
        int firstPtrIndex = event.findPointerIndex(pointerIds[0]);
        int secondPtrIndex = event.findPointerIndex(pointerIds[1]);
        float firstPtrX = event.getX(firstPtrIndex);
        float firstPtrY = event.getY(firstPtrIndex);
        float secondPtrX = event.getX(secondPtrIndex);
        float secondPtrY = event.getY(secondPtrIndex);
        float firstDeltaX = firstPtrX - pointerTracker.getReceivedPointerDownX(firstPtrIndex);
        float firstDeltaY = firstPtrY - pointerTracker.getReceivedPointerDownY(firstPtrIndex);
        if (firstDeltaX == 0.0f && firstDeltaY == 0.0f) {
            return true;
        }
        float firstMagnitude = (float)Math.sqrt(firstDeltaX * firstDeltaX + firstDeltaY * firstDeltaY);
        float firstXNormalized = firstMagnitude > 0.0f ? firstDeltaX / firstMagnitude : firstDeltaX;
        float firstYNormalized = firstMagnitude > 0.0f ? firstDeltaY / firstMagnitude : firstDeltaY;
        float secondDeltaX = secondPtrX - pointerTracker.getReceivedPointerDownX(secondPtrIndex);
        float secondDeltaY = secondPtrY - pointerTracker.getReceivedPointerDownY(secondPtrIndex);
        if (secondDeltaX == 0.0f && secondDeltaY == 0.0f) {
            return true;
        }
        float secondMagnitude = (float)Math.sqrt(secondDeltaX * secondDeltaX + secondDeltaY * secondDeltaY);
        float secondXNormalized = secondMagnitude > 0.0f ? secondDeltaX / secondMagnitude : secondDeltaX;
        float angleCos = firstXNormalized * secondXNormalized + firstYNormalized * (secondYNormalized = secondMagnitude > 0.0f ? secondDeltaY / secondMagnitude : secondDeltaY);
        return !(angleCos < 0.52532196f);
    }

    private void sendAccessibilityEvent(int eventType) {
        AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
        this.mAccessibilityManager.sendAccessibilityEvent(event);
    }

    public void clear() {
        this.mSendHoverDelayed.remove();
        this.mPerformLongPressDelayed.remove();
        this.mPointerTracker.clear();
        this.mLastTouchExploreEvent = null;
        this.mCurrentState = 1;
        this.mTouchExploreGestureInProgress = false;
        this.mDraggingPointerId = -1;
    }

    private static String getStateSymbolicName(int state) {
        switch (state) {
            case 1: {
                return "STATE_TOUCH_EXPLORING";
            }
            case 2: {
                return "STATE_DRAGGING";
            }
            case 4: {
                return "STATE_DELEGATING";
            }
        }
        throw new IllegalArgumentException("Unknown state: " + state);
    }

    private final class SendHoverDelayed
    implements Runnable {
        private static final String LOG_TAG = "SendHoverEnterOrExitDelayed";
        private MotionEvent mEvent;
        private int mAction;
        private int mPointerIdBits;
        private int mPolicyFlags;

        private SendHoverDelayed() {
        }

        public void post(MotionEvent prototype, int action, int pointerIdBits, int policyFlags, long delay) {
            this.remove();
            this.mEvent = MotionEvent.obtain((MotionEvent)prototype);
            this.mAction = action;
            this.mPointerIdBits = pointerIdBits;
            this.mPolicyFlags = policyFlags;
            TouchExplorer.this.mHandler.postDelayed((Runnable)this, delay);
        }

        public void remove() {
            TouchExplorer.this.mHandler.removeCallbacks((Runnable)this);
            this.clear();
        }

        private boolean isPenidng() {
            return this.mEvent != null;
        }

        private void clear() {
            if (!this.isPenidng()) {
                return;
            }
            this.mEvent.recycle();
            this.mEvent = null;
            this.mAction = 0;
            this.mPointerIdBits = -1;
            this.mPolicyFlags = 0;
        }

        public void forceSendAndRemove() {
            if (this.isPenidng()) {
                this.run();
                this.remove();
            }
        }

        public void run() {
            TouchExplorer.this.sendMotionEvent(this.mEvent, this.mAction, this.mPointerIdBits, this.mPolicyFlags);
            this.clear();
        }
    }

    private final class PerformLongPressDelayed
    implements Runnable {
        private MotionEvent mEvent;
        private int mPolicyFlags;

        private PerformLongPressDelayed() {
        }

        public void post(MotionEvent prototype, int policyFlags, long delay) {
            this.mEvent = MotionEvent.obtain((MotionEvent)prototype);
            this.mPolicyFlags = policyFlags;
            TouchExplorer.this.mHandler.postDelayed((Runnable)this, delay);
        }

        public void remove() {
            if (this.isPenidng()) {
                TouchExplorer.this.mHandler.removeCallbacks((Runnable)this);
                this.clear();
            }
        }

        private boolean isPenidng() {
            return this.mEvent != null;
        }

        public void run() {
            TouchExplorer.this.mCurrentState = 4;
            TouchExplorer.this.mSendHoverDelayed.remove();
            int pointerId = TouchExplorer.this.mPointerTracker.getPrimaryActivePointerId();
            int pointerIdBits = 1 << pointerId;
            TouchExplorer.this.ensureHoverExitSent(this.mEvent, pointerIdBits, this.mPolicyFlags);
            TouchExplorer.this.sendDownForAllActiveNotInjectedPointers(this.mEvent, this.mPolicyFlags);
            TouchExplorer.this.mTouchExploreGestureInProgress = false;
            TouchExplorer.this.mLastTouchExploreEvent = null;
            this.clear();
        }

        private void clear() {
            if (!this.isPenidng()) {
                return;
            }
            this.mEvent.recycle();
            this.mEvent = null;
            this.mPolicyFlags = 0;
        }
    }

    class PointerTracker {
        private static final String LOG_TAG = "PointerTracker";
        private static final int COEFFICIENT_ACTIVE_POINTER = 2;
        private final double mThresholdActivePointer;
        private final float[] mReceivedPointerDownX = new float[32];
        private final float[] mReceivedPointerDownY = new float[32];
        private final long[] mReceivedPointerDownTime = new long[32];
        private int mReceivedPointersDown;
        private int mActivePointers;
        private int mPrimaryActivePointerId;
        private boolean mHasMovingActivePointer;
        private int mInjectedPointersDown;
        private long mLastReceivedUpPointerDownTime;
        private int mLastReceivedUpPointerId;
        private boolean mLastReceivedUpPointerActive;
        private long mLastInjectedDownEventTime;
        private int mLastInjectedHoverEventAction = 10;

        public PointerTracker(Context context) {
            this.mThresholdActivePointer = ViewConfiguration.get((Context)context).getScaledTouchSlop() * 2;
        }

        public void clear() {
            Arrays.fill(this.mReceivedPointerDownX, 0.0f);
            Arrays.fill(this.mReceivedPointerDownY, 0.0f);
            Arrays.fill(this.mReceivedPointerDownTime, 0L);
            this.mReceivedPointersDown = 0;
            this.mActivePointers = 0;
            this.mPrimaryActivePointerId = 0;
            this.mHasMovingActivePointer = false;
            this.mInjectedPointersDown = 0;
            this.mLastReceivedUpPointerDownTime = 0L;
            this.mLastReceivedUpPointerId = 0;
            this.mLastReceivedUpPointerActive = false;
        }

        public void onReceivedMotionEvent(MotionEvent event) {
            int action = event.getActionMasked();
            switch (action) {
                case 0: {
                    this.mInjectedPointersDown = 0;
                    this.handleReceivedPointerDown(event.getActionIndex(), event);
                    break;
                }
                case 5: {
                    this.handleReceivedPointerDown(event.getActionIndex(), event);
                    break;
                }
                case 2: {
                    this.handleReceivedPointerMove(event);
                    break;
                }
                case 1: {
                    this.handleReceivedPointerUp(event.getActionIndex(), event);
                    break;
                }
                case 6: {
                    this.handleReceivedPointerUp(event.getActionIndex(), event);
                }
            }
        }

        public void onInjectedMotionEvent(MotionEvent event) {
            int action = event.getActionMasked();
            switch (action) {
                case 0: {
                    this.handleInjectedPointerDown(event.getActionIndex(), event);
                    this.mLastInjectedDownEventTime = event.getDownTime();
                    break;
                }
                case 5: {
                    this.handleInjectedPointerDown(event.getActionIndex(), event);
                    break;
                }
                case 1: {
                    this.handleInjectedPointerUp(event.getActionIndex(), event);
                    break;
                }
                case 6: {
                    this.handleInjectedPointerUp(event.getActionIndex(), event);
                    break;
                }
                case 7: 
                case 9: 
                case 10: {
                    this.mLastInjectedHoverEventAction = event.getActionMasked();
                }
            }
        }

        public int getReceivedPointerDownCount() {
            return Integer.bitCount(this.mReceivedPointersDown);
        }

        public int getActivePointerCount() {
            return Integer.bitCount(this.mActivePointers);
        }

        public boolean isReceivedPointerDown(int pointerId) {
            int pointerFlag = 1 << pointerId;
            return (this.mReceivedPointersDown & pointerFlag) != 0;
        }

        public boolean isInjectedPointerDown(int pointerId) {
            int pointerFlag = 1 << pointerId;
            return (this.mInjectedPointersDown & pointerFlag) != 0;
        }

        public int getInjectedPointerDownCount() {
            return Integer.bitCount(this.mInjectedPointersDown);
        }

        public boolean isActivePointer(int pointerId) {
            int pointerFlag = 1 << pointerId;
            return (this.mActivePointers & pointerFlag) != 0;
        }

        public float getReceivedPointerDownX(int pointerId) {
            return this.mReceivedPointerDownX[pointerId];
        }

        public float getReceivedPointerDownY(int pointerId) {
            return this.mReceivedPointerDownY[pointerId];
        }

        public long getReceivedPointerDownTime(int pointerId) {
            return this.mReceivedPointerDownTime[pointerId];
        }

        public int getPrimaryActivePointerId() {
            if (this.mPrimaryActivePointerId == -1) {
                this.mPrimaryActivePointerId = this.findPrimaryActivePointer();
            }
            return this.mPrimaryActivePointerId;
        }

        public long getLastReceivedUpPointerDownTime() {
            return this.mLastReceivedUpPointerDownTime;
        }

        public int getLastReceivedUpPointerId() {
            return this.mLastReceivedUpPointerId;
        }

        public boolean wasLastReceivedUpPointerActive() {
            return this.mLastReceivedUpPointerActive;
        }

        public long getLastInjectedDownEventTime() {
            return this.mLastInjectedDownEventTime;
        }

        public int getLastInjectedHoverAction() {
            return this.mLastInjectedHoverEventAction;
        }

        public void populateActivePointerIds(int[] outPointerIds) {
            int index = 0;
            int idBits = this.mActivePointers;
            while (idBits != 0) {
                int id = Integer.numberOfTrailingZeros(idBits);
                idBits &= ~(1 << id);
                outPointerIds[index] = id;
                ++index;
            }
        }

        public int getNotInjectedActivePointerCount() {
            int pointerState = this.mActivePointers & ~this.mInjectedPointersDown;
            return Integer.bitCount(pointerState);
        }

        private boolean isActiveOrWasLastActiveUpPointer(int pointerId) {
            return this.isActivePointer(pointerId) || this.mLastReceivedUpPointerId == pointerId && this.mLastReceivedUpPointerActive;
        }

        private void handleReceivedPointerDown(int pointerIndex, MotionEvent event) {
            int pointerId = event.getPointerId(pointerIndex);
            int pointerFlag = 1 << pointerId;
            this.mLastReceivedUpPointerId = 0;
            this.mLastReceivedUpPointerDownTime = 0L;
            this.mLastReceivedUpPointerActive = false;
            this.mReceivedPointersDown |= pointerFlag;
            this.mReceivedPointerDownX[pointerId] = event.getX(pointerIndex);
            this.mReceivedPointerDownY[pointerId] = event.getY(pointerIndex);
            this.mReceivedPointerDownTime[pointerId] = event.getEventTime();
            if (!this.mHasMovingActivePointer) {
                this.mActivePointers = pointerFlag;
                this.mPrimaryActivePointerId = pointerId;
            } else {
                this.mActivePointers |= pointerFlag;
            }
        }

        private void handleReceivedPointerMove(MotionEvent event) {
            this.detectActivePointers(event);
        }

        private void handleReceivedPointerUp(int pointerIndex, MotionEvent event) {
            int pointerId = event.getPointerId(pointerIndex);
            int pointerFlag = 1 << pointerId;
            this.mLastReceivedUpPointerId = pointerId;
            this.mLastReceivedUpPointerDownTime = this.getReceivedPointerDownTime(pointerId);
            this.mLastReceivedUpPointerActive = this.isActivePointer(pointerId);
            this.mReceivedPointersDown &= ~pointerFlag;
            this.mActivePointers &= ~pointerFlag;
            this.mReceivedPointerDownX[pointerId] = 0.0f;
            this.mReceivedPointerDownY[pointerId] = 0.0f;
            this.mReceivedPointerDownTime[pointerId] = 0L;
            if (this.mActivePointers == 0) {
                this.mHasMovingActivePointer = false;
            }
            if (this.mPrimaryActivePointerId == pointerId) {
                this.mPrimaryActivePointerId = -1;
            }
        }

        private void handleInjectedPointerDown(int pointerIndex, MotionEvent event) {
            int pointerId = event.getPointerId(pointerIndex);
            int pointerFlag = 1 << pointerId;
            this.mInjectedPointersDown |= pointerFlag;
        }

        private void handleInjectedPointerUp(int pointerIndex, MotionEvent event) {
            int pointerId = event.getPointerId(pointerIndex);
            int pointerFlag = 1 << pointerId;
            this.mInjectedPointersDown &= ~pointerFlag;
            if (this.mInjectedPointersDown == 0) {
                this.mLastInjectedDownEventTime = 0L;
            }
        }

        private void detectActivePointers(MotionEvent event) {
            int count = event.getPointerCount();
            for (int i = 0; i < count; ++i) {
                float pointerDeltaMove;
                int pointerId = event.getPointerId(i);
                if (this.mHasMovingActivePointer && this.isActivePointer(pointerId) || !((double)(pointerDeltaMove = this.computePointerDeltaMove(i, event)) > this.mThresholdActivePointer)) continue;
                int pointerFlag = 1 << pointerId;
                this.mActivePointers |= pointerFlag;
                this.mHasMovingActivePointer = true;
            }
        }

        private int findPrimaryActivePointer() {
            int primaryActivePointerId = -1;
            long minDownTime = Long.MAX_VALUE;
            int count = this.mReceivedPointerDownTime.length;
            for (int i = 0; i < count; ++i) {
                long downPointerTime;
                if (!this.isActivePointer(i) || (downPointerTime = this.mReceivedPointerDownTime[i]) >= minDownTime) continue;
                minDownTime = downPointerTime;
                primaryActivePointerId = i;
            }
            return primaryActivePointerId;
        }

        private float computePointerDeltaMove(int pointerIndex, MotionEvent event) {
            int pointerId = event.getPointerId(pointerIndex);
            float deltaX = event.getX(pointerIndex) - this.mReceivedPointerDownX[pointerId];
            float deltaY = event.getY(pointerIndex) - this.mReceivedPointerDownY[pointerId];
            return (float)Math.hypot(deltaX, deltaY);
        }

        public String toString() {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append("=========================");
            builder.append("\nDown pointers #");
            builder.append(this.getReceivedPointerDownCount());
            builder.append(" [ ");
            for (i = 0; i < 32; ++i) {
                if (!this.isReceivedPointerDown(i)) continue;
                builder.append(i);
                builder.append(" ");
            }
            builder.append("]");
            builder.append("\nActive pointers #");
            builder.append(this.getActivePointerCount());
            builder.append(" [ ");
            for (i = 0; i < 32; ++i) {
                if (!this.isActivePointer(i)) continue;
                builder.append(i);
                builder.append(" ");
            }
            builder.append("]");
            builder.append("\nPrimary active pointer id [ ");
            builder.append(this.getPrimaryActivePointerId());
            builder.append(" ]");
            builder.append("\n=========================");
            return builder.toString();
        }
    }
}

