/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AlertDialog;
import android.app.AppGlobals;
import android.app.ApplicationErrorReport;
import android.app.ContextImpl;
import android.app.Dialog;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IActivityWatcher;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.INotificationManager;
import android.app.IProcessObserver;
import android.app.IServiceConnection;
import android.app.IThumbnailReceiver;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.backup.IBackupManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageManager;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PathPermission;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.ProxyProperties;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IPermissionController;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.view.IApplicationToken;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.ProcessStats;
import com.android.server.AttributeCache;
import com.android.server.IntentResolver;
import com.android.server.ProcessMap;
import com.android.server.Watchdog;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.AppBindRecord;
import com.android.server.am.AppErrorDialog;
import com.android.server.am.AppErrorResult;
import com.android.server.am.AppNotRespondingDialog;
import com.android.server.am.AppWaitingForDebuggerDialog;
import com.android.server.am.BackupRecord;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.BatteryStatsService;
import com.android.server.am.BroadcastFilter;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.CompatModeDialog;
import com.android.server.am.CompatModePackages;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.CoreSettingsObserver;
import com.android.server.am.FactoryErrorDialog;
import com.android.server.am.IntentBindRecord;
import com.android.server.am.LaunchWarningWindow;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.PendingThumbnailsRecord;
import com.android.server.am.ProcessList;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ReceiverList;
import com.android.server.am.ServiceRecord;
import com.android.server.am.StrictModeViolationDialog;
import com.android.server.am.TaskRecord;
import com.android.server.am.TransferPipe;
import com.android.server.am.UriPermission;
import com.android.server.am.UriPermissionOwner;
import com.android.server.am.UsageStatsService;
import com.android.server.wm.WindowManagerService;
import dalvik.system.Zygote;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActivityManagerService
extends ActivityManagerNative
implements Watchdog.Monitor,
BatteryStatsImpl.BatteryCallback {
    static final String TAG = "ActivityManager";
    static final boolean DEBUG = false;
    static final boolean localLOGV = false;
    static final boolean DEBUG_SWITCH = false;
    static final boolean DEBUG_TASKS = false;
    static final boolean DEBUG_PAUSE = false;
    static final boolean DEBUG_OOM_ADJ = false;
    static final boolean DEBUG_TRANSITION = false;
    static final boolean DEBUG_BROADCAST = false;
    static final boolean DEBUG_BROADCAST_LIGHT = false;
    static final boolean DEBUG_SERVICE = false;
    static final boolean DEBUG_SERVICE_EXECUTING = false;
    static final boolean DEBUG_VISBILITY = false;
    static final boolean DEBUG_PROCESSES = false;
    static final boolean DEBUG_PROVIDER = false;
    static final boolean DEBUG_URI_PERMISSION = false;
    static final boolean DEBUG_USER_LEAVING = false;
    static final boolean DEBUG_RESULTS = false;
    static final boolean DEBUG_BACKUP = false;
    static final boolean DEBUG_CONFIGURATION = false;
    static final boolean DEBUG_POWER = false;
    static final boolean DEBUG_POWER_QUICK = false;
    static final boolean VALIDATE_TOKENS = false;
    static final boolean SHOW_ACTIVITY_START_TIME = true;
    static final long BATTERY_STATS_TIME = 1800000L;
    static final boolean MONITOR_CPU_USAGE = true;
    static final long MONITOR_CPU_MIN_TIME = 5000L;
    static final long MONITOR_CPU_MAX_TIME = 0xFFFFFFFL;
    static final boolean MONITOR_THREAD_CPU_USAGE = false;
    static final int STOCK_PM_FLAGS = 1024;
    private static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    static final int MAX_RECENT_TASKS = 20;
    static final long APP_SWITCH_DELAY_TIME = 5000L;
    static final int PROC_START_TIMEOUT = 10000;
    static final int PROC_START_TIMEOUT_WITH_WRAPPER = 300000;
    static final int GC_TIMEOUT = 5000;
    static final int GC_MIN_INTERVAL = 60000;
    static final int POWER_CHECK_DELAY = 900000;
    static final int WAKE_LOCK_MIN_CHECK_DURATION = 300000;
    static final int CPU_MIN_CHECK_DURATION = 300000;
    static final int BROADCAST_TIMEOUT = 10000;
    static final int SERVICE_TIMEOUT = 20000;
    static final int SERVICE_RESTART_DURATION = 5000;
    static final int SERVICE_RESET_RUN_DURATION = 60000;
    static final int SERVICE_RESTART_DURATION_FACTOR = 4;
    static final int SERVICE_MIN_RESTART_TIME_BETWEEN = 10000;
    static final int MAX_SERVICE_INACTIVITY = 1800000;
    static final int KEY_DISPATCHING_TIMEOUT = 5000;
    static final int INSTRUMENTATION_KEY_DISPATCHING_TIMEOUT = 60000;
    static final int MY_PID = android.os.Process.myPid();
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    public ActivityStack mMainStack;
    final ArrayList<PendingActivityLaunch> mPendingActivityLaunches = new ArrayList();
    final ArrayList<BroadcastRecord> mParallelBroadcasts = new ArrayList();
    final ArrayList<BroadcastRecord> mOrderedBroadcasts = new ArrayList();
    static final int MAX_BROADCAST_HISTORY = 25;
    final BroadcastRecord[] mBroadcastHistory = new BroadcastRecord[25];
    boolean mBroadcastsScheduled = false;
    ActivityRecord mFocusedActivity = null;
    final ArrayList<TaskRecord> mRecentTasks = new ArrayList();
    final ProcessList mProcessList = new ProcessList();
    final ProcessMap<ProcessRecord> mProcessNames = new ProcessMap();
    ProcessRecord mHeavyWeightProcess = null;
    final ProcessMap<Long> mProcessCrashTimes = new ProcessMap();
    final ProcessMap<Long> mBadProcesses = new ProcessMap();
    final SparseArray<ProcessRecord> mPidsSelfLocked = new SparseArray();
    final SparseArray<ForegroundToken> mForegroundProcesses = new SparseArray();
    final ArrayList<ProcessRecord> mProcessesOnHold = new ArrayList();
    final ArrayList<ProcessRecord> mPersistentStartingProcesses = new ArrayList();
    final ArrayList<ProcessRecord> mRemovedProcesses = new ArrayList();
    final ArrayList<ProcessRecord> mLruProcesses = new ArrayList();
    final ArrayList<ProcessRecord> mProcessesToGc = new ArrayList();
    ProcessRecord mHomeProcess;
    ProcessRecord mPreviousProcess;
    long mPreviousProcessVisibleTime;
    final CompatModePackages mCompatModePackages;
    final HashSet mPendingResultRecords = new HashSet();
    final HashMap<PendingIntentRecord.Key, WeakReference<PendingIntentRecord>> mIntentSenderRecords = new HashMap();
    private final HashSet<Integer> mAlreadyLoggedViolatedStacks = new HashSet();
    private static final int MAX_DUP_SUPPRESSED_STACKS = 5000;
    private final StringBuilder mStrictModeBuffer = new StringBuilder();
    private boolean mPendingBroadcastTimeoutMessage;
    BroadcastRecord mPendingBroadcast = null;
    int mPendingBroadcastRecvIndex;
    final HashMap mRegisteredReceivers = new HashMap();
    final IntentResolver<BroadcastFilter, BroadcastFilter> mReceiverResolver = new IntentResolver<BroadcastFilter, BroadcastFilter>(){

        @Override
        protected boolean allowFilterResult(BroadcastFilter filter, List<BroadcastFilter> dest) {
            IBinder target = filter.receiverList.receiver.asBinder();
            for (int i = dest.size() - 1; i >= 0; --i) {
                if (dest.get((int)i).receiverList.receiver.asBinder() != target) continue;
                return false;
            }
            return true;
        }

        @Override
        protected String packageForFilter(BroadcastFilter filter) {
            return filter.packageName;
        }
    };
    final HashMap<String, ArrayList<Intent>> mStickyBroadcasts = new HashMap();
    final HashMap<ComponentName, ServiceRecord> mServices = new HashMap();
    final HashMap<Intent.FilterComparison, ServiceRecord> mServicesByIntent = new HashMap();
    final HashMap<IBinder, ArrayList<ConnectionRecord>> mServiceConnections = new HashMap();
    final ArrayList<ServiceRecord> mPendingServices = new ArrayList();
    final ArrayList<ServiceRecord> mRestartingServices = new ArrayList();
    final ArrayList<ServiceRecord> mStoppingServices = new ArrayList();
    String mBackupAppName = null;
    BackupRecord mBackupTarget = null;
    final ArrayList mPendingThumbnails = new ArrayList();
    final ArrayList mCancelledThumbnails = new ArrayList();
    final HashMap<String, ContentProviderRecord> mProvidersByName = new HashMap();
    final HashMap<ComponentName, ContentProviderRecord> mProvidersByClass = new HashMap();
    final ArrayList<ContentProviderRecord> mLaunchingProviders = new ArrayList();
    private final SparseArray<HashMap<Uri, UriPermission>> mGrantedUriPermissions = new SparseArray();
    CoreSettingsObserver mCoreSettingsObserver;
    private static ThreadLocal<Identity> sCallerIdentity = new ThreadLocal();
    final BatteryStatsService mBatteryStatsService;
    final UsageStatsService mUsageStatsService;
    Configuration mConfiguration = new Configuration();
    int mConfigurationSeq = 0;
    final int GL_ES_VERSION;
    HashMap<String, IBinder> mAppBindArgs;
    final StringBuilder mStringBuilder = new StringBuilder(256);
    boolean mStartRunning = false;
    ComponentName mTopComponent;
    String mTopAction;
    String mTopData;
    boolean mProcessesReady = false;
    boolean mSystemReady = false;
    boolean mBooting = false;
    boolean mWaitingUpdate = false;
    boolean mDidUpdate = false;
    boolean mOnBattery = false;
    boolean mLaunchWarningShown = false;
    Context mContext;
    int mFactoryTest;
    boolean mCheckedForSetup;
    long mAppSwitchesAllowedTime;
    boolean mDidAppSwitch;
    long mLastPowerCheckRealtime;
    long mLastPowerCheckUptime;
    boolean mSleeping = false;
    boolean mShuttingDown = false;
    int mCurTask = 1;
    int mAdjSeq = 0;
    int mLruSeq = 0;
    int mNumServiceProcs = 0;
    int mNewNumServiceProcs = 0;
    int[] mProcDeaths = new int[20];
    boolean mDidDexOpt;
    String mDebugApp = null;
    boolean mWaitForDebugger = false;
    boolean mDebugTransient = false;
    String mOrigDebugApp = null;
    boolean mOrigWaitForDebugger = false;
    boolean mAlwaysFinishActivities = false;
    IActivityController mController = null;
    String mProfileApp = null;
    ProcessRecord mProfileProc = null;
    String mProfileFile;
    ParcelFileDescriptor mProfileFd;
    int mProfileType = 0;
    boolean mAutoStopProfiler = false;
    final RemoteCallbackList<IActivityWatcher> mWatchers = new RemoteCallbackList();
    final RemoteCallbackList<IProcessObserver> mProcessObservers = new RemoteCallbackList();
    Runnable mRequestPssCallback;
    final ArrayList<ProcessRecord> mRequestPssList = new ArrayList();
    final Thread mProcessStatsThread;
    final ProcessStats mProcessStats = new ProcessStats(false);
    final AtomicLong mLastCpuTime = new AtomicLong(0L);
    final AtomicBoolean mProcessStatsMutexFree = new AtomicBoolean(true);
    long mLastWriteTime = 0L;
    boolean mBooted = false;
    int mProcessLimit = 15;
    int mProcessLimitOverride = -1;
    WindowManagerService mWindowManager;
    static ActivityManagerService mSelf;
    static ActivityThread mSystemThread;
    static final int SHOW_ERROR_MSG = 1;
    static final int SHOW_NOT_RESPONDING_MSG = 2;
    static final int SHOW_FACTORY_ERROR_MSG = 3;
    static final int UPDATE_CONFIGURATION_MSG = 4;
    static final int GC_BACKGROUND_PROCESSES_MSG = 5;
    static final int WAIT_FOR_DEBUGGER_MSG = 6;
    static final int BROADCAST_INTENT_MSG = 7;
    static final int BROADCAST_TIMEOUT_MSG = 8;
    static final int SERVICE_TIMEOUT_MSG = 12;
    static final int UPDATE_TIME_ZONE = 13;
    static final int SHOW_UID_ERROR_MSG = 14;
    static final int IM_FEELING_LUCKY_MSG = 15;
    static final int PROC_START_TIMEOUT_MSG = 20;
    static final int DO_PENDING_ACTIVITY_LAUNCHES_MSG = 21;
    static final int KILL_APPLICATION_MSG = 22;
    static final int FINALIZE_PENDING_INTENT_MSG = 23;
    static final int POST_HEAVY_NOTIFICATION_MSG = 24;
    static final int CANCEL_HEAVY_NOTIFICATION_MSG = 25;
    static final int SHOW_STRICT_MODE_VIOLATION_MSG = 26;
    static final int CHECK_EXCESSIVE_WAKE_LOCKS_MSG = 27;
    static final int CLEAR_DNS_CACHE = 28;
    static final int UPDATE_HTTP_PROXY = 29;
    static final int SHOW_COMPAT_MODE_DIALOG_MSG = 30;
    static final int DISPATCH_FOREGROUND_ACTIVITIES_CHANGED = 31;
    static final int DISPATCH_PROCESS_DIED = 32;
    static final int REPORT_MEM_USAGE = 33;
    AlertDialog mUidAlert;
    CompatModeDialog mCompatModeDialog;
    long mLastMemUsageReportTime = 0L;
    final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    HashMap data = (HashMap)msg.obj;
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        ProcessRecord proc = (ProcessRecord)data.get("app");
                        if (proc != null && proc.crashDialog != null) {
                            Slog.e((String)ActivityManagerService.TAG, (String)("App already has crash dialog: " + proc));
                            return;
                        }
                        AppErrorResult res = (AppErrorResult)data.get("result");
                        if (!ActivityManagerService.this.mSleeping && !ActivityManagerService.this.mShuttingDown) {
                            AppErrorDialog d = new AppErrorDialog(ActivityManagerService.this.mContext, res, proc);
                            d.show();
                            proc.crashDialog = d;
                        } else {
                            res.set(0);
                        }
                    }
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 2: {
                    ActivityManagerService data = ActivityManagerService.this;
                    synchronized (data) {
                        HashMap data2 = (HashMap)msg.obj;
                        ProcessRecord proc = (ProcessRecord)data2.get("app");
                        if (proc != null && proc.anrDialog != null) {
                            Slog.e((String)ActivityManagerService.TAG, (String)("App already has anr dialog: " + proc));
                            return;
                        }
                        Intent intent = new Intent("android.intent.action.ANR");
                        if (!ActivityManagerService.this.mProcessesReady) {
                            intent.addFlags(0x40000000);
                        }
                        ActivityManagerService.this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, false, false, MY_PID, 1000);
                        AppNotRespondingDialog d = new AppNotRespondingDialog(ActivityManagerService.this, ActivityManagerService.this.mContext, proc, (ActivityRecord)data2.get("activity"));
                        d.show();
                        proc.anrDialog = d;
                    }
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 26: {
                    HashMap data = (HashMap)msg.obj;
                    ActivityManagerService data2 = ActivityManagerService.this;
                    synchronized (data2) {
                        ProcessRecord proc = (ProcessRecord)data.get("app");
                        if (proc == null) {
                            Slog.e((String)ActivityManagerService.TAG, (String)"App not found when showing strict mode dialog.");
                            break;
                        }
                        if (proc.crashDialog != null) {
                            Slog.e((String)ActivityManagerService.TAG, (String)("App already has strict mode dialog: " + proc));
                            return;
                        }
                        AppErrorResult res = (AppErrorResult)data.get("result");
                        if (!ActivityManagerService.this.mSleeping && !ActivityManagerService.this.mShuttingDown) {
                            StrictModeViolationDialog d = new StrictModeViolationDialog(ActivityManagerService.this.mContext, res, proc);
                            d.show();
                            proc.crashDialog = d;
                        } else {
                            res.set(0);
                        }
                    }
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 3: {
                    FactoryErrorDialog d = new FactoryErrorDialog(ActivityManagerService.this.mContext, msg.getData().getCharSequence("msg"));
                    d.show();
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 4: {
                    ContentResolver resolver = ActivityManagerService.this.mContext.getContentResolver();
                    Settings.System.putConfiguration((ContentResolver)resolver, (Configuration)((Configuration)msg.obj));
                    break;
                }
                case 5: {
                    ActivityManagerService resolver = ActivityManagerService.this;
                    synchronized (resolver) {
                        ActivityManagerService.this.performAppGcsIfAppropriateLocked();
                        break;
                    }
                }
                case 6: {
                    ActivityManagerService resolver = ActivityManagerService.this;
                    synchronized (resolver) {
                        ProcessRecord app = (ProcessRecord)msg.obj;
                        if (msg.arg1 != 0) {
                            if (!app.waitedForDebugger) {
                                AppWaitingForDebuggerDialog d = new AppWaitingForDebuggerDialog(ActivityManagerService.this, ActivityManagerService.this.mContext, app);
                                app.waitDialog = d;
                                app.waitedForDebugger = true;
                                d.show();
                            }
                        } else if (app.waitDialog != null) {
                            app.waitDialog.dismiss();
                            app.waitDialog = null;
                        }
                        break;
                    }
                }
                case 7: {
                    ActivityManagerService.this.processNextBroadcast(true);
                    break;
                }
                case 8: {
                    ActivityManagerService resolver = ActivityManagerService.this;
                    synchronized (resolver) {
                        ActivityManagerService.this.broadcastTimeoutLocked(true);
                        break;
                    }
                }
                case 12: {
                    if (ActivityManagerService.this.mDidDexOpt) {
                        ActivityManagerService.this.mDidDexOpt = false;
                        Message nmsg = ActivityManagerService.this.mHandler.obtainMessage(12);
                        nmsg.obj = msg.obj;
                        ActivityManagerService.this.mHandler.sendMessageDelayed(nmsg, 20000L);
                        return;
                    }
                    ActivityManagerService.this.serviceTimeout((ProcessRecord)msg.obj);
                    break;
                }
                case 13: {
                    ActivityManagerService nmsg = ActivityManagerService.this;
                    synchronized (nmsg) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.updateTimeZone();
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w((String)ActivityManagerService.TAG, (String)("Failed to update time zone for: " + r.info.processName));
                            }
                        }
                        break;
                    }
                }
                case 28: {
                    ActivityManagerService nmsg = ActivityManagerService.this;
                    synchronized (nmsg) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.clearDnsCache();
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w((String)ActivityManagerService.TAG, (String)("Failed to clear dns cache for: " + r.info.processName));
                            }
                        }
                        break;
                    }
                }
                case 29: {
                    ProxyProperties proxy = (ProxyProperties)msg.obj;
                    String host = "";
                    String port = "";
                    String exclList = "";
                    if (proxy != null) {
                        host = proxy.getHost();
                        port = Integer.toString(proxy.getPort());
                        exclList = proxy.getExclusionList();
                    }
                    ActivityManagerService d = ActivityManagerService.this;
                    synchronized (d) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.setHttpProxy(host, port, exclList);
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w((String)ActivityManagerService.TAG, (String)("Failed to update http proxy for: " + r.info.processName));
                            }
                        }
                        break;
                    }
                }
                case 14: {
                    BaseErrorDialog d = new BaseErrorDialog(ActivityManagerService.this.mContext);
                    d.getWindow().setType(2010);
                    d.setCancelable(false);
                    d.setTitle("System UIDs Inconsistent");
                    d.setMessage("UIDs on the system are inconsistent, you need to wipe your data partition or your device will be unstable.");
                    d.setButton(-1, "I'm Feeling Lucky", ActivityManagerService.this.mHandler.obtainMessage(15));
                    ActivityManagerService.this.mUidAlert = d;
                    d.show();
                    break;
                }
                case 15: {
                    if (ActivityManagerService.this.mUidAlert == null) break;
                    ActivityManagerService.this.mUidAlert.dismiss();
                    ActivityManagerService.this.mUidAlert = null;
                    break;
                }
                case 20: {
                    if (ActivityManagerService.this.mDidDexOpt) {
                        ActivityManagerService.this.mDidDexOpt = false;
                        Message nmsg = ActivityManagerService.this.mHandler.obtainMessage(20);
                        nmsg.obj = msg.obj;
                        ActivityManagerService.this.mHandler.sendMessageDelayed(nmsg, 10000L);
                        return;
                    }
                    ProcessRecord app = (ProcessRecord)msg.obj;
                    ActivityManagerService host = ActivityManagerService.this;
                    synchronized (host) {
                        ActivityManagerService.this.processStartTimedOutLocked(app);
                        break;
                    }
                }
                case 21: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        ActivityManagerService.this.doPendingActivityLaunchesLocked(true);
                        break;
                    }
                }
                case 22: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        int uid = msg.arg1;
                        boolean restart = msg.arg2 == 1;
                        String pkg = (String)msg.obj;
                        ActivityManagerService.this.forceStopPackageLocked(pkg, uid, restart, false, true, false);
                        break;
                    }
                }
                case 23: {
                    ((PendingIntentRecord)((Object)msg.obj)).completeFinalize();
                    break;
                }
                case 24: {
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    ActivityRecord root = (ActivityRecord)msg.obj;
                    ProcessRecord process = root.app;
                    if (process == null) {
                        return;
                    }
                    try {
                        Context context = ActivityManagerService.this.mContext.createPackageContext(process.info.packageName, 0);
                        String text = ActivityManagerService.this.mContext.getString(17040316, new Object[]{context.getApplicationInfo().loadLabel(context.getPackageManager())});
                        Notification notification = new Notification();
                        notification.icon = 17302773;
                        notification.when = 0L;
                        notification.flags = 2;
                        notification.tickerText = text;
                        notification.defaults = 0;
                        notification.sound = null;
                        notification.vibrate = null;
                        notification.setLatestEventInfo(context, (CharSequence)text, ActivityManagerService.this.mContext.getText(17040317), PendingIntent.getActivity((Context)ActivityManagerService.this.mContext, (int)0, (Intent)root.intent, (int)0x10000000));
                        try {
                            int[] outId = new int[1];
                            inm.enqueueNotification("android", 17040316, notification, outId);
                        }
                        catch (RuntimeException e) {
                            Slog.w((String)ActivityManagerService.TAG, (String)"Error showing notification for heavy-weight app", (Throwable)e);
                        }
                        catch (RemoteException e) {
                        }
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.w((String)ActivityManagerService.TAG, (String)"Unable to create context for heavy notification", (Throwable)e);
                    }
                    break;
                }
                case 25: {
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    try {
                        inm.cancelNotification("android", 17040316);
                    }
                    catch (RuntimeException e) {
                        Slog.w((String)ActivityManagerService.TAG, (String)"Error canceling notification for service", (Throwable)e);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 27: {
                    ActivityManagerService inm = ActivityManagerService.this;
                    synchronized (inm) {
                        ActivityManagerService.this.checkExcessivePowerUsageLocked(true);
                        this.removeMessages(27);
                        Message nmsg = this.obtainMessage(27);
                        this.sendMessageDelayed(nmsg, 900000L);
                        break;
                    }
                }
                case 30: {
                    ActivityManagerService inm = ActivityManagerService.this;
                    synchronized (inm) {
                        ActivityRecord ar = (ActivityRecord)msg.obj;
                        if (ActivityManagerService.this.mCompatModeDialog != null) {
                            if (ActivityManagerService.this.mCompatModeDialog.mAppInfo.packageName.equals(ar.info.applicationInfo.packageName)) {
                                return;
                            }
                            ActivityManagerService.this.mCompatModeDialog.dismiss();
                            ActivityManagerService.this.mCompatModeDialog = null;
                        }
                        if (ar != null) {
                            // empty if block
                        }
                        break;
                    }
                }
                case 31: {
                    int pid = msg.arg1;
                    int uid = msg.arg2;
                    boolean foregroundActivities = (Boolean)msg.obj;
                    ActivityManagerService.this.dispatchForegroundActivitiesChanged(pid, uid, foregroundActivities);
                    break;
                }
                case 32: {
                    int pid = msg.arg1;
                    int uid = msg.arg2;
                    ActivityManagerService.this.dispatchProcessDied(pid, uid);
                    break;
                }
                case 33: {
                    boolean isDebuggable = "1".equals(SystemProperties.get((String)ActivityManagerService.SYSTEM_DEBUGGABLE, (String)"0"));
                    if (!isDebuggable) {
                        return;
                    }
                    ActivityManagerService uid = ActivityManagerService.this;
                    synchronized (uid) {
                        long now = SystemClock.uptimeMillis();
                        if (now < ActivityManagerService.this.mLastMemUsageReportTime + 300000L) {
                            return;
                        }
                        ActivityManagerService.this.mLastMemUsageReportTime = now;
                    }
                    Thread thread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            StringBuilder dropBuilder = new StringBuilder(1024);
                            StringBuilder logBuilder = new StringBuilder(1024);
                            StringWriter oomSw = new StringWriter();
                            PrintWriter oomPw = new PrintWriter(oomSw);
                            StringWriter catSw = new StringWriter();
                            PrintWriter catPw = new PrintWriter(catSw);
                            String[] emptyArgs = new String[]{};
                            StringBuilder tag = new StringBuilder(128);
                            StringBuilder stack = new StringBuilder(128);
                            tag.append("Low on memory -- ");
                            ActivityManagerService.this.dumpApplicationMemoryUsage(null, oomPw, "  ", emptyArgs, true, catPw, tag, stack);
                            dropBuilder.append((CharSequence)stack);
                            dropBuilder.append('\n');
                            dropBuilder.append('\n');
                            String oomString = oomSw.toString();
                            dropBuilder.append(oomString);
                            dropBuilder.append('\n');
                            logBuilder.append(oomString);
                            try {
                                String line;
                                Process proc = Runtime.getRuntime().exec(new String[]{"procrank"});
                                InputStreamReader converter = new InputStreamReader(proc.getInputStream());
                                BufferedReader in = new BufferedReader(converter);
                                while ((line = in.readLine()) != null) {
                                    if (line.length() > 0) {
                                        logBuilder.append(line);
                                        logBuilder.append('\n');
                                    }
                                    dropBuilder.append(line);
                                    dropBuilder.append('\n');
                                }
                                converter.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            ActivityManagerService activityManagerService = ActivityManagerService.this;
                            synchronized (activityManagerService) {
                                catPw.println();
                                ActivityManagerService.this.dumpProcessesLocked(null, catPw, emptyArgs, 0, false, null);
                                catPw.println();
                                ActivityManagerService.this.dumpServicesLocked(null, catPw, emptyArgs, 0, false, false, null);
                                catPw.println();
                                ActivityManagerService.this.dumpActivitiesLocked(null, catPw, emptyArgs, 0, false, false, null);
                            }
                            dropBuilder.append(catSw.toString());
                            ActivityManagerService.this.addErrorToDropBox("lowmem", null, "system_server", null, null, tag.toString(), dropBuilder.toString(), null, null);
                            Slog.i((String)ActivityManagerService.TAG, (String)logBuilder.toString());
                            activityManagerService = ActivityManagerService.this;
                            synchronized (activityManagerService) {
                                long now = SystemClock.uptimeMillis();
                                if (ActivityManagerService.this.mLastMemUsageReportTime < now) {
                                    ActivityManagerService.this.mLastMemUsageReportTime = now;
                                }
                            }
                        }
                    };
                    thread.start();
                    break;
                }
            }
        }
    };
    static final int LAST_DONE_VERSION = 10000;
    static final long[] DUMP_MEM_BUCKETS;
    static final int[] DUMP_MEM_OOM_ADJ;
    static final String[] DUMP_MEM_OOM_LABEL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSystemProcess() {
        try {
            ActivityManagerService m = mSelf;
            ServiceManager.addService((String)"activity", (IBinder)m);
            ServiceManager.addService((String)"meminfo", (IBinder)new MemBinder(m));
            ServiceManager.addService((String)"gfxinfo", (IBinder)new GraphicsBinder(m));
            ServiceManager.addService((String)"cpuinfo", (IBinder)new CpuBinder(m));
            ServiceManager.addService((String)"permission", (IBinder)new PermissionController(m));
            ApplicationInfo info = ActivityManagerService.mSelf.mContext.getPackageManager().getApplicationInfo("android", 1024);
            mSystemThread.installSystemApplicationInfo(info);
            ActivityManagerService activityManagerService = mSelf;
            synchronized (activityManagerService) {
                ProcessRecord app = mSelf.newProcessRecordLocked((IApplicationThread)mSystemThread.getApplicationThread(), info, info.processName);
                app.persistent = true;
                app.pid = MY_PID;
                app.maxAdj = -16;
                ActivityManagerService.mSelf.mProcessNames.put(app.processName, app.info.uid, app);
                SparseArray<ProcessRecord> sparseArray = ActivityManagerService.mSelf.mPidsSelfLocked;
                synchronized (sparseArray) {
                    ActivityManagerService.mSelf.mPidsSelfLocked.put(app.pid, (Object)app);
                }
                mSelf.updateLruProcessLocked(app, true, true);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unable to find android system package", e);
        }
    }

    public void setWindowManager(WindowManagerService wm) {
        this.mWindowManager = wm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Context main(int factoryTest) {
        ActivityThread at;
        ActivityManagerService m;
        AThread thr = new AThread();
        thr.start();
        AThread aThread = thr;
        synchronized (aThread) {
            while (thr.mService == null) {
                try {
                    thr.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        mSelf = m = thr.mService;
        mSystemThread = at = ActivityThread.systemMain();
        ContextImpl context = at.getSystemContext();
        context.setTheme(16973931);
        m.mContext = context;
        m.mFactoryTest = factoryTest;
        m.mMainStack = new ActivityStack(m, (Context)context, true);
        m.mBatteryStatsService.publish((Context)context);
        m.mUsageStatsService.publish((Context)context);
        AThread aThread2 = thr;
        synchronized (aThread2) {
            thr.mReady = true;
            thr.notifyAll();
        }
        m.startRunning(null, null, null, null);
        return context;
    }

    public static ActivityManagerService self() {
        return mSelf;
    }

    private ActivityManagerService() {
        Slog.i((String)TAG, (String)("Memory class: " + ActivityManager.staticGetMemoryClass()));
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        systemDir.mkdirs();
        this.mBatteryStatsService = new BatteryStatsService(new File(systemDir, "batterystats.bin").toString());
        this.mBatteryStatsService.getActiveStatistics().readLocked();
        this.mBatteryStatsService.getActiveStatistics().writeAsyncLocked();
        this.mOnBattery = this.mBatteryStatsService.getActiveStatistics().getIsOnBattery();
        this.mBatteryStatsService.getActiveStatistics().setCallback((BatteryStatsImpl.BatteryCallback)this);
        this.mUsageStatsService = new UsageStatsService(new File(systemDir, "usagestats").toString());
        this.GL_ES_VERSION = SystemProperties.getInt((String)"ro.opengles.version", (int)0);
        this.mConfiguration.setToDefaults();
        this.mConfiguration.locale = Locale.getDefault();
        this.mConfiguration.seq = 1;
        this.mConfigurationSeq = 1;
        this.mProcessStats.init();
        this.mCompatModePackages = new CompatModePackages(this, systemDir);
        Watchdog.getInstance().addMonitor(this);
        this.mProcessStatsThread = new Thread("ProcessStats"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            try {
                                3 var1_1 = this;
                                synchronized (var1_1) {
                                    long now = SystemClock.uptimeMillis();
                                    long nextCpuDelay = ActivityManagerService.this.mLastCpuTime.get() + 0xFFFFFFFL - now;
                                    long nextWriteDelay = ActivityManagerService.this.mLastWriteTime + 1800000L - now;
                                    if (nextWriteDelay < nextCpuDelay) {
                                        nextCpuDelay = nextWriteDelay;
                                    }
                                    if (nextCpuDelay > 0L) {
                                        ActivityManagerService.this.mProcessStatsMutexFree.set(true);
                                        this.wait(nextCpuDelay);
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            ActivityManagerService.this.updateCpuStatsNow();
                        }
                    }
                    catch (Exception e) {
                        Slog.e((String)ActivityManagerService.TAG, (String)"Unexpected exception collecting process stats", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
        this.mProcessStatsThread.start();
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.e((String)TAG, (String)"Activity Manager Crash", (Throwable)e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCpuStats() {
        long now = SystemClock.uptimeMillis();
        if (this.mLastCpuTime.get() >= now - 5000L) {
            return;
        }
        if (this.mProcessStatsMutexFree.compareAndSet(true, false)) {
            Thread thread = this.mProcessStatsThread;
            synchronized (thread) {
                this.mProcessStatsThread.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCpuStatsNow() {
        Thread thread = this.mProcessStatsThread;
        synchronized (thread) {
            BatteryStatsImpl bstats;
            this.mProcessStatsMutexFree.set(false);
            long now = SystemClock.uptimeMillis();
            boolean haveNewCpuStats = false;
            if (this.mLastCpuTime.get() < now - 5000L) {
                this.mLastCpuTime.set(now);
                haveNewCpuStats = true;
                this.mProcessStats.update();
                if ("true".equals(SystemProperties.get((String)"events.cpu"))) {
                    int idle;
                    int softIrq;
                    int irq;
                    int iowait;
                    int system;
                    int user = this.mProcessStats.getLastUserTime();
                    int total = user + (system = this.mProcessStats.getLastSystemTime()) + (iowait = this.mProcessStats.getLastIoWaitTime()) + (irq = this.mProcessStats.getLastIrqTime()) + (softIrq = this.mProcessStats.getLastSoftIrqTime()) + (idle = this.mProcessStats.getLastIdleTime());
                    if (total == 0) {
                        total = 1;
                    }
                    EventLog.writeEvent((int)2721, (Object[])new Object[]{(user + system + iowait + irq + softIrq) * 100 / total, user * 100 / total, system * 100 / total, iowait * 100 / total, irq * 100 / total, softIrq * 100 / total});
                }
            }
            long[] cpuSpeedTimes = this.mProcessStats.getLastCpuSpeedTimes();
            BatteryStatsImpl batteryStatsImpl = bstats = this.mBatteryStatsService.getActiveStatistics();
            synchronized (batteryStatsImpl) {
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    if (haveNewCpuStats && this.mOnBattery) {
                        int perc = bstats.startAddingCpuLocked();
                        int totalUTime = 0;
                        int totalSTime = 0;
                        int N = this.mProcessStats.countStats();
                        for (int i = 0; i < N; ++i) {
                            BatteryStatsImpl.Uid.Proc ps;
                            ProcessStats.Stats st = this.mProcessStats.getStats(i);
                            if (!st.working) continue;
                            ProcessRecord pr = (ProcessRecord)this.mPidsSelfLocked.get(st.pid);
                            int otherUTime = st.rel_utime * perc / 100;
                            int otherSTime = st.rel_stime * perc / 100;
                            totalUTime += otherUTime;
                            totalSTime += otherSTime;
                            if (pr != null) {
                                ps = pr.batteryStats;
                                ps.addCpuTimeLocked(st.rel_utime - otherUTime, st.rel_stime - otherSTime);
                                ps.addSpeedStepTimes(cpuSpeedTimes);
                                pr.curCpuTime += (long)((st.rel_utime + st.rel_stime) * 10);
                                continue;
                            }
                            ps = bstats.getProcessStatsLocked(st.name, st.pid);
                            if (ps == null) continue;
                            ps.addCpuTimeLocked(st.rel_utime - otherUTime, st.rel_stime - otherSTime);
                            ps.addSpeedStepTimes(cpuSpeedTimes);
                        }
                        bstats.finishAddingCpuLocked(perc, totalUTime, totalSTime, cpuSpeedTimes);
                    }
                }
                if (this.mLastWriteTime < now - 1800000L) {
                    this.mLastWriteTime = now;
                    this.mBatteryStatsService.getActiveStatistics().writeAsyncLocked();
                }
            }
        }
    }

    public void batteryNeedsCpuUpdate() {
        this.updateCpuStatsNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batteryPowerChanged(boolean onBattery) {
        this.updateCpuStatsNow();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mOnBattery = onBattery;
            }
        }
    }

    private HashMap<String, IBinder> getCommonServicesLocked() {
        if (this.mAppBindArgs == null) {
            this.mAppBindArgs = new HashMap();
            this.mAppBindArgs.put("package", ServiceManager.getService((String)"package"));
            this.mAppBindArgs.put("window", ServiceManager.getService((String)"window"));
            this.mAppBindArgs.put("alarm", ServiceManager.getService((String)"alarm"));
        }
        return this.mAppBindArgs;
    }

    final void setFocusedActivityLocked(ActivityRecord r) {
        if (this.mFocusedActivity != r) {
            this.mFocusedActivity = r;
            if (r != null) {
                this.mWindowManager.setFocusedApp((IBinder)r.appToken, true);
            }
        }
    }

    private final void updateLruProcessInternalLocked(ProcessRecord app, boolean oomAdj, boolean updateActivityTime, int bestPos) {
        int lrui = this.mLruProcesses.indexOf(app);
        if (lrui >= 0) {
            this.mLruProcesses.remove(lrui);
        }
        int i = this.mLruProcesses.size() - 1;
        int skipTop = 0;
        app.lruSeq = this.mLruSeq;
        if (updateActivityTime) {
            app.lastActivityTime = SystemClock.uptimeMillis();
        }
        if (app.activities.size() > 0) {
            app.lruWeight = app.lastActivityTime;
        } else if (app.pubProviders.size() > 0) {
            app.lruWeight = app.lastActivityTime - 15000L;
            skipTop = 2;
        } else {
            app.lruWeight = app.lastActivityTime - 120000L;
            skipTop = 2;
        }
        while (i >= 0) {
            ProcessRecord p = this.mLruProcesses.get(i);
            if (skipTop > 0 && p.setAdj >= ProcessList.HIDDEN_APP_MIN_ADJ) {
                --skipTop;
            }
            if (p.lruWeight <= app.lruWeight || i < bestPos) {
                this.mLruProcesses.add(i + 1, app);
                break;
            }
            --i;
        }
        if (i < 0) {
            this.mLruProcesses.add(0, app);
        }
        if (app.connections.size() > 0) {
            for (ConnectionRecord cr : app.connections) {
                if (cr.binding == null || cr.binding.service == null || cr.binding.service.app == null || cr.binding.service.app.lruSeq == this.mLruSeq) continue;
                this.updateLruProcessInternalLocked(cr.binding.service.app, oomAdj, updateActivityTime, i + 1);
            }
        }
        if (app.conProviders.size() > 0) {
            for (ContentProviderRecord cpr : app.conProviders.keySet()) {
                if (cpr.proc == null || cpr.proc.lruSeq == this.mLruSeq) continue;
                this.updateLruProcessInternalLocked(cpr.proc, oomAdj, updateActivityTime, i + 1);
            }
        }
        if (oomAdj) {
            this.updateOomAdjLocked();
        }
    }

    final void updateLruProcessLocked(ProcessRecord app, boolean oomAdj, boolean updateActivityTime) {
        ++this.mLruSeq;
        this.updateLruProcessInternalLocked(app, oomAdj, updateActivityTime, 0);
    }

    final ProcessRecord getProcessRecordLocked(String processName, int uid) {
        if (uid == 1000) {
            SparseArray<ProcessRecord> procs = this.mProcessNames.getMap().get(processName);
            return procs != null ? (ProcessRecord)procs.valueAt(0) : null;
        }
        ProcessRecord proc = this.mProcessNames.get(processName, uid);
        return proc;
    }

    void ensurePackageDexOpt(String packageName) {
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            if (pm.performDexOpt(packageName)) {
                this.mDidDexOpt = true;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    boolean isNextTransitionForward() {
        int transit = this.mWindowManager.getPendingAppTransition();
        return transit == 4102 || transit == 4104 || transit == 4106;
    }

    final ProcessRecord startProcessLocked(String processName, ApplicationInfo info, boolean knownToBeDead, int intentFlags, String hostingType, ComponentName hostingName, boolean allowWhileBooting) {
        String hostingNameStr;
        ProcessRecord app = this.getProcessRecordLocked(processName, info.uid);
        if (app != null && app.pid > 0) {
            if (!knownToBeDead || app.thread == null) {
                app.addPackage(info.packageName);
                return app;
            }
            this.handleAppDiedLocked(app, true, true);
        }
        String string = hostingNameStr = hostingName != null ? hostingName.flattenToShortString() : null;
        if ((intentFlags & 4) != 0) {
            if (this.mBadProcesses.get(info.processName, info.uid) != null) {
                return null;
            }
        } else {
            this.mProcessCrashTimes.remove(info.processName, info.uid);
            if (this.mBadProcesses.get(info.processName, info.uid) != null) {
                EventLog.writeEvent((int)30016, (Object[])new Object[]{info.uid, info.processName});
                this.mBadProcesses.remove(info.processName, info.uid);
                if (app != null) {
                    app.bad = false;
                }
            }
        }
        if (app == null) {
            app = this.newProcessRecordLocked(null, info, processName);
            this.mProcessNames.put(processName, info.uid, app);
        } else {
            app.addPackage(info.packageName);
        }
        if (!(this.mProcessesReady || this.isAllowedWhileBooting(info) || allowWhileBooting)) {
            if (!this.mProcessesOnHold.contains(app)) {
                this.mProcessesOnHold.add(app);
            }
            return app;
        }
        this.startProcessLocked(app, hostingType, hostingNameStr);
        return app.pid != 0 ? app : null;
    }

    boolean isAllowedWhileBooting(ApplicationInfo ai) {
        return (ai.flags & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startProcessLocked(ProcessRecord app, String hostingType, String hostingNameStr) {
        if (app.pid > 0 && app.pid != MY_PID) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(app.pid);
                this.mHandler.removeMessages(20, (Object)app);
            }
            app.pid = 0;
        }
        this.mProcessesOnHold.remove(app);
        this.updateCpuStats();
        System.arraycopy(this.mProcDeaths, 0, this.mProcDeaths, 1, this.mProcDeaths.length - 1);
        this.mProcDeaths[0] = 0;
        try {
            BatteryStatsImpl bs;
            int uid = app.info.uid;
            int[] gids = null;
            try {
                gids = this.mContext.getPackageManager().getPackageGids(app.info.packageName);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w((String)TAG, (String)"Unable to retrieve gids", (Throwable)e);
            }
            if (this.mFactoryTest != 0) {
                if (this.mFactoryTest == 1 && this.mTopComponent != null && app.processName.equals(this.mTopComponent.getPackageName())) {
                    uid = 0;
                }
                if (this.mFactoryTest == 2 && (app.info.flags & 0x10) != 0) {
                    uid = 0;
                }
            }
            int debugFlags = 0;
            if ((app.info.flags & 2) != 0) {
                debugFlags |= 1;
                debugFlags |= 2;
            }
            if ((app.info.flags & 0x4000) != 0 || Zygote.systemInSafeMode) {
                debugFlags |= 8;
            }
            if ("1".equals(SystemProperties.get((String)"debug.checkjni"))) {
                debugFlags |= 2;
            }
            if ("1".equals(SystemProperties.get((String)"debug.jni.logging"))) {
                debugFlags |= 0x10;
            }
            if ("1".equals(SystemProperties.get((String)"debug.assert"))) {
                debugFlags |= 4;
            }
            Process.ProcessStartResult startResult = android.os.Process.start((String)"android.app.ActivityThread", (String)app.processName, (int)uid, (int)uid, (int[])gids, (int)debugFlags, (int)app.info.targetSdkVersion, null);
            BatteryStatsImpl batteryStatsImpl = bs = app.batteryStats.getBatteryStats();
            synchronized (batteryStatsImpl) {
                if (bs.isOnBattery()) {
                    app.batteryStats.incStartsLocked();
                }
            }
            EventLog.writeEvent((int)30014, (Object[])new Object[]{startResult.pid, uid, app.processName, hostingType, hostingNameStr != null ? hostingNameStr : ""});
            if (app.persistent) {
                Watchdog.getInstance().processStarted(app.processName, startResult.pid);
            }
            StringBuilder buf = this.mStringBuilder;
            buf.setLength(0);
            buf.append("Start proc ");
            buf.append(app.processName);
            buf.append(" for ");
            buf.append(hostingType);
            if (hostingNameStr != null) {
                buf.append(" ");
                buf.append(hostingNameStr);
            }
            buf.append(": pid=");
            buf.append(startResult.pid);
            buf.append(" uid=");
            buf.append(uid);
            buf.append(" gids={");
            if (gids != null) {
                for (int gi = 0; gi < gids.length; ++gi) {
                    if (gi != 0) {
                        buf.append(", ");
                    }
                    buf.append(gids[gi]);
                }
            }
            buf.append("}");
            Slog.i((String)TAG, (String)buf.toString());
            app.pid = startResult.pid;
            app.usingWrapper = startResult.usingWrapper;
            app.removed = false;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.put(startResult.pid, (Object)app);
                Message msg = this.mHandler.obtainMessage(20);
                msg.obj = app;
                this.mHandler.sendMessageDelayed(msg, startResult.usingWrapper ? 300000L : 10000L);
            }
        }
        catch (RuntimeException e) {
            app.pid = 0;
            Slog.e((String)TAG, (String)("Failure starting process " + app.processName), (Throwable)e);
        }
    }

    void updateUsageStats(ActivityRecord resumedComponent, boolean resumed) {
        if (resumed) {
            this.mUsageStatsService.noteResumeComponent(resumedComponent.realActivity);
        } else {
            this.mUsageStatsService.notePauseComponent(resumedComponent.realActivity);
        }
    }

    boolean startHomeActivityLocked() {
        ActivityInfo aInfo;
        if (this.mFactoryTest == 1 && this.mTopAction == null) {
            return false;
        }
        Intent intent = new Intent(this.mTopAction, this.mTopData != null ? Uri.parse((String)this.mTopData) : null);
        intent.setComponent(this.mTopComponent);
        if (this.mFactoryTest != 1) {
            intent.addCategory("android.intent.category.HOME");
        }
        if ((aInfo = intent.resolveActivityInfo(this.mContext.getPackageManager(), 1024)) != null) {
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            ProcessRecord app = this.getProcessRecordLocked(aInfo.processName, aInfo.applicationInfo.uid);
            if (app == null || app.instrumentationClass == null) {
                intent.setFlags(intent.getFlags() | 0x10000000);
                this.mMainStack.startActivityLocked(null, intent, null, null, 0, aInfo, null, null, 0, 0, 0, false, false, null);
            }
        }
        return true;
    }

    void startSetupActivityLocked() {
        if (this.mCheckedForSetup) {
            return;
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        if (this.mFactoryTest != 1 && Settings.Secure.getInt((ContentResolver)resolver, (String)"device_provisioned", (int)0) != 0) {
            this.mCheckedForSetup = true;
            Intent intent = new Intent("android.intent.action.UPGRADE_SETUP");
            List ris = ActivityManagerService.mSelf.mContext.getPackageManager().queryIntentActivities(intent, 128);
            ResolveInfo ri = null;
            for (int i = 0; ris != null && i < ris.size(); ++i) {
                if ((((ResolveInfo)ris.get((int)i)).activityInfo.applicationInfo.flags & 1) == 0) continue;
                ri = (ResolveInfo)ris.get(i);
                break;
            }
            if (ri != null) {
                String vers;
                String string = vers = ri.activityInfo.metaData != null ? ri.activityInfo.metaData.getString("android.SETUP_VERSION") : null;
                if (vers == null && ri.activityInfo.applicationInfo.metaData != null) {
                    vers = ri.activityInfo.applicationInfo.metaData.getString("android.SETUP_VERSION");
                }
                String lastVers = Settings.Secure.getString((ContentResolver)resolver, (String)"last_setup_shown");
                if (vers != null && !vers.equals(lastVers)) {
                    intent.setFlags(0x10000000);
                    intent.setComponent(new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name));
                    this.mMainStack.startActivityLocked(null, intent, null, null, 0, ri.activityInfo, null, null, 0, 0, 0, false, false, null);
                }
            }
        }
    }

    CompatibilityInfo compatibilityInfoForPackageLocked(ApplicationInfo ai) {
        return this.mCompatModePackages.compatibilityInfoForPackageLocked(ai);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFrontActivityScreenCompatMode() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getFrontActivityScreenCompatModeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrontActivityScreenCompatMode(int mode) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setFrontActivityScreenCompatModeLocked(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPackageScreenCompatMode(String packageName) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getPackageScreenCompatModeLocked(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageScreenCompatMode(String packageName, int mode) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setPackageScreenCompatModeLocked(packageName, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPackageAskScreenCompat(String packageName) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getPackageAskCompatModeLocked(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageAskScreenCompat(String packageName, boolean ask) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setPackageAskCompatModeLocked(packageName, ask);
        }
    }

    void reportResumedActivityLocked(ActivityRecord r) {
        int identHash = System.identityHashCode(r);
        this.updateUsageStats(r, true);
        int i = this.mWatchers.beginBroadcast();
        while (i > 0) {
            IActivityWatcher w;
            if ((w = (IActivityWatcher)this.mWatchers.getBroadcastItem(--i)) == null) continue;
            try {
                w.activityResuming(identHash);
            }
            catch (RemoteException e) {}
        }
        this.mWatchers.finishBroadcast();
    }

    private void dispatchForegroundActivitiesChanged(int pid, int uid, boolean foregroundActivities) {
        int i = this.mProcessObservers.beginBroadcast();
        while (i > 0) {
            IProcessObserver observer;
            if ((observer = (IProcessObserver)this.mProcessObservers.getBroadcastItem(--i)) == null) continue;
            try {
                observer.onForegroundActivitiesChanged(pid, uid, foregroundActivities);
            }
            catch (RemoteException e) {}
        }
        this.mProcessObservers.finishBroadcast();
    }

    private void dispatchProcessDied(int pid, int uid) {
        int i = this.mProcessObservers.beginBroadcast();
        while (i > 0) {
            IProcessObserver observer;
            if ((observer = (IProcessObserver)this.mProcessObservers.getBroadcastItem(--i)) == null) continue;
            try {
                observer.onProcessDied(pid, uid);
            }
            catch (RemoteException e) {}
        }
        this.mProcessObservers.finishBroadcast();
    }

    final void doPendingActivityLaunchesLocked(boolean doResume) {
        int N = this.mPendingActivityLaunches.size();
        if (N <= 0) {
            return;
        }
        for (int i = 0; i < N; ++i) {
            PendingActivityLaunch pal = this.mPendingActivityLaunches.get(i);
            this.mMainStack.startActivityUncheckedLocked(pal.r, pal.sourceRecord, pal.grantedUriPermissions, pal.grantedMode, pal.onlyIfNeeded, doResume && i == N - 1);
        }
        this.mPendingActivityLaunches.clear();
    }

    public final int startActivity(IApplicationThread caller, Intent intent, String resolvedType, Uri[] grantedUriPermissions, int grantedMode, IBinder resultTo, String resultWho, int requestCode, boolean onlyIfNeeded, boolean debug, String profileFile, ParcelFileDescriptor profileFd, boolean autoStopProfiler) {
        return this.mMainStack.startActivityMayWait(caller, -1, intent, resolvedType, grantedUriPermissions, grantedMode, resultTo, resultWho, requestCode, onlyIfNeeded, debug, profileFile, profileFd, autoStopProfiler, null, null);
    }

    public final IActivityManager.WaitResult startActivityAndWait(IApplicationThread caller, Intent intent, String resolvedType, Uri[] grantedUriPermissions, int grantedMode, IBinder resultTo, String resultWho, int requestCode, boolean onlyIfNeeded, boolean debug, String profileFile, ParcelFileDescriptor profileFd, boolean autoStopProfiler) {
        IActivityManager.WaitResult res = new IActivityManager.WaitResult();
        this.mMainStack.startActivityMayWait(caller, -1, intent, resolvedType, grantedUriPermissions, grantedMode, resultTo, resultWho, requestCode, onlyIfNeeded, debug, profileFile, profileFd, autoStopProfiler, res, null);
        return res;
    }

    public final int startActivityWithConfig(IApplicationThread caller, Intent intent, String resolvedType, Uri[] grantedUriPermissions, int grantedMode, IBinder resultTo, String resultWho, int requestCode, boolean onlyIfNeeded, boolean debug, Configuration config) {
        return this.mMainStack.startActivityMayWait(caller, -1, intent, resolvedType, grantedUriPermissions, grantedMode, resultTo, resultWho, requestCode, onlyIfNeeded, debug, null, null, false, null, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startActivityIntentSender(IApplicationThread caller, IntentSender intent, Intent fillInIntent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int flagsMask, int flagsValues) {
        if (fillInIntent != null && fillInIntent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        IIntentSender sender = intent.getTarget();
        if (!(sender instanceof PendingIntentRecord)) {
            throw new IllegalArgumentException("Bad PendingIntent object");
        }
        PendingIntentRecord pir = (PendingIntentRecord)sender;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mMainStack.mResumedActivity != null && this.mMainStack.mResumedActivity.info.applicationInfo.uid == Binder.getCallingUid()) {
                this.mAppSwitchesAllowedTime = 0L;
            }
        }
        return pir.sendInner(0, fillInIntent, resolvedType, null, null, resultTo, resultWho, requestCode, flagsMask, flagsValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startNextMatchingActivity(IBinder callingActivity, Intent intent) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mMainStack.isInStackLocked(callingActivity);
            if (r == null) {
                return false;
            }
            if (r.app == null || r.app.thread == null) {
                return false;
            }
            intent = new Intent(intent);
            intent.setDataAndType(r.intent.getData(), r.intent.getType());
            intent.setComponent(null);
            ActivityInfo aInfo = null;
            try {
                List resolves = AppGlobals.getPackageManager().queryIntentActivities(intent, r.resolvedType, 66560);
                int N = resolves != null ? resolves.size() : 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo rInfo = (ResolveInfo)resolves.get(i);
                    if (!rInfo.activityInfo.packageName.equals(r.packageName) || !rInfo.activityInfo.name.equals(r.info.name)) continue;
                    if (++i < N) {
                        aInfo = ((ResolveInfo)resolves.get((int)i)).activityInfo;
                    }
                    break;
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            if (aInfo == null) {
                return false;
            }
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            intent.setFlags(intent.getFlags() & 0xE1FFFFFF);
            boolean wasFinishing = r.finishing;
            r.finishing = true;
            ActivityRecord resultTo = r.resultTo;
            String resultWho = r.resultWho;
            int requestCode = r.requestCode;
            r.resultTo = null;
            if (resultTo != null) {
                resultTo.removeResultsLocked(r, resultWho, requestCode);
            }
            long origId = Binder.clearCallingIdentity();
            int res = this.mMainStack.startActivityLocked(r.app.thread, intent, r.resolvedType, null, 0, aInfo, (IBinder)(resultTo != null ? resultTo.appToken : null), resultWho, requestCode, -1, r.launchedFromUid, false, false, null);
            Binder.restoreCallingIdentity((long)origId);
            r.finishing = wasFinishing;
            return res == 0;
            {
            }
        }
    }

    public final int startActivityInPackage(int uid, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, boolean onlyIfNeeded) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != android.os.Process.myUid()) {
            throw new SecurityException("startActivityInPackage only available to the system");
        }
        return this.mMainStack.startActivityMayWait(null, uid, intent, resolvedType, null, 0, resultTo, resultWho, requestCode, onlyIfNeeded, false, null, null, false, null, null);
    }

    public final int startActivities(IApplicationThread caller, Intent[] intents, String[] resolvedTypes, IBinder resultTo) {
        return this.mMainStack.startActivities(caller, -1, intents, resolvedTypes, resultTo);
    }

    public final int startActivitiesInPackage(int uid, Intent[] intents, String[] resolvedTypes, IBinder resultTo) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != android.os.Process.myUid()) {
            throw new SecurityException("startActivityInPackage only available to the system");
        }
        return this.mMainStack.startActivities(null, uid, intents, resolvedTypes, resultTo);
    }

    final void addRecentTaskLocked(TaskRecord task) {
        int N = this.mRecentTasks.size();
        if (N > 0 && this.mRecentTasks.get(0) == task) {
            return;
        }
        for (int i = 0; i < N; ++i) {
            TaskRecord tr = this.mRecentTasks.get(i);
            if ((task.affinity == null || !task.affinity.equals(tr.affinity)) && (task.intent == null || !task.intent.filterEquals(tr.intent))) continue;
            this.mRecentTasks.remove(i);
            --i;
            --N;
            if (task.intent != null) continue;
            task = tr;
        }
        if (N >= 20) {
            this.mRecentTasks.remove(N - 1);
        }
        this.mRecentTasks.add(0, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestedOrientation(IBinder token, int requestedOrientation) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mMainStack.isInStackLocked(token);
            if (r == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.mWindowManager.setAppOrientation((IApplicationToken)r.appToken, requestedOrientation);
            Configuration config = this.mWindowManager.updateOrientationFromAppTokens(this.mConfiguration, (IBinder)(r.mayFreezeScreenLocked(r.app) ? r.appToken : null));
            if (config != null) {
                r.frozenBeforeDestroy = true;
                if (!this.updateConfigurationLocked(config, r, false, false)) {
                    this.mMainStack.resumeTopActivityLocked(null);
                }
            }
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestedOrientation(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mMainStack.isInStackLocked(token);
            if (r == null) {
                return -1;
            }
            return this.mWindowManager.getAppOrientation((IApplicationToken)r.appToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean finishActivity(IBinder token, int resultCode, Intent resultData) {
        if (resultData != null && resultData.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord next;
            if (this.mController != null && (next = this.mMainStack.topRunningActivityLocked(token, 0)) != null) {
                boolean resumeOK = true;
                try {
                    resumeOK = this.mController.activityResuming(next.packageName);
                }
                catch (RemoteException e) {
                    this.mController = null;
                }
                if (!resumeOK) {
                    return false;
                }
            }
            long origId = Binder.clearCallingIdentity();
            boolean res = this.mMainStack.requestFinishActivityLocked(token, resultCode, resultData, "app-request");
            Binder.restoreCallingIdentity((long)origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishHeavyWeightApp() {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: finishHeavyWeightApp() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w((String)TAG, (String)msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mHeavyWeightProcess == null) {
                return;
            }
            ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>(this.mHeavyWeightProcess.activities);
            for (int i = 0; i < activities.size(); ++i) {
                int index;
                ActivityRecord r = activities.get(i);
                if (r.finishing || (index = this.mMainStack.indexOfTokenLocked((IBinder)r.appToken)) < 0) continue;
                this.mMainStack.finishActivityLocked(r, index, 0, null, "finish-heavy");
            }
            this.mHeavyWeightProcess = null;
            this.mHandler.sendEmptyMessage(25);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crashApplication(int uid, int initialPid, String packageName, String message) {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: crashApplication() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w((String)TAG, (String)msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord proc = null;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                for (int i = 0; i < this.mPidsSelfLocked.size(); ++i) {
                    ProcessRecord p = (ProcessRecord)this.mPidsSelfLocked.valueAt(i);
                    if (p.info.uid != uid) continue;
                    if (p.pid == initialPid) {
                        proc = p;
                        break;
                    }
                    for (String str : p.pkgList) {
                        if (!str.equals(packageName)) continue;
                        proc = p;
                    }
                }
            }
            if (proc == null) {
                Slog.w((String)TAG, (String)("crashApplication: nothing for uid=" + uid + " initialPid=" + initialPid + " packageName=" + packageName));
                return;
            }
            if (proc.thread != null) {
                if (proc.pid == android.os.Process.myPid()) {
                    Log.w((String)TAG, (String)"crashApplication: trying to crash self!");
                    return;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    proc.thread.scheduleCrash(message);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                Binder.restoreCallingIdentity((long)ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishSubActivity(IBinder token, String resultWho, int requestCode) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord self = this.mMainStack.isInStackLocked(token);
            if (self == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            for (int i = this.mMainStack.mHistory.size() - 1; i >= 0; --i) {
                ActivityRecord r = this.mMainStack.mHistory.get(i);
                if (r.resultTo != self || r.requestCode != requestCode || (r.resultWho != null || resultWho != null) && (r.resultWho == null || !r.resultWho.equals(resultWho))) continue;
                this.mMainStack.finishActivityLocked(r, i, 0, null, "request-sub");
            }
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean willActivityBeVisible(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mMainStack.mHistory.size() - 1; i >= 0; --i) {
                ActivityRecord r = this.mMainStack.mHistory.get(i);
                if (r.appToken == token) {
                    return true;
                }
                if (!r.fullscreen || r.finishing) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overridePendingTransition(IBinder token, String packageName, int enterAnim, int exitAnim) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord self = this.mMainStack.isInStackLocked(token);
            if (self == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            if (self.state == ActivityStack.ActivityState.RESUMED || self.state == ActivityStack.ActivityState.PAUSING) {
                this.mWindowManager.overridePendingAppTransition(packageName, enterAnim, exitAnim);
            }
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    private final void handleAppDiedLocked(ProcessRecord app, boolean restarting, boolean allowRestart) {
        this.cleanUpApplicationRecordLocked(app, restarting, allowRestart, -1);
        if (!restarting) {
            this.mLruProcesses.remove(app);
        }
        if (this.mProfileProc == app) {
            this.clearProfilerLocked();
        }
        if (this.mMainStack.mPausingActivity != null && this.mMainStack.mPausingActivity.app == app) {
            this.mMainStack.mPausingActivity = null;
        }
        if (this.mMainStack.mLastPausedActivity != null && this.mMainStack.mLastPausedActivity.app == app) {
            this.mMainStack.mLastPausedActivity = null;
        }
        this.mMainStack.removeHistoryRecordsForAppLocked(app);
        boolean atTop = true;
        boolean hasVisibleActivities = false;
        int i = this.mMainStack.mHistory.size();
        while (i > 0) {
            ActivityRecord r = this.mMainStack.mHistory.get(--i);
            if (r.app == app) {
                if (!r.haveState && !r.stateNotNeeded || r.finishing) {
                    if (!r.finishing) {
                        Slog.w((String)TAG, (String)("Force removing " + r + ": app died, no saved state"));
                        EventLog.writeEvent((int)30001, (Object[])new Object[]{System.identityHashCode(r), r.task.taskId, r.shortComponentName, "proc died without state saved"});
                    }
                    r.makeFinishing();
                    this.mMainStack.mHistory.remove(i);
                    r.takeFromHistory();
                    this.mWindowManager.removeAppToken((IBinder)r.appToken);
                    r.removeUriPermissionsLocked();
                } else {
                    if (r.visible) {
                        hasVisibleActivities = true;
                    }
                    r.app = null;
                    r.nowVisible = false;
                    if (!r.haveState) {
                        r.icicle = null;
                    }
                }
                r.stack.cleanUpActivityLocked(r, true, true);
            }
            atTop = false;
        }
        app.activities.clear();
        if (app.instrumentationClass != null) {
            Slog.w((String)TAG, (String)("Crash of app " + app.processName + " running instrumentation " + app.instrumentationClass));
            Bundle info = new Bundle();
            info.putString("shortMsg", "Process crashed.");
            this.finishInstrumentationLocked(app, 0, info);
        }
        if (!restarting && !this.mMainStack.resumeTopActivityLocked(null) && hasVisibleActivities) {
            this.mMainStack.ensureActivitiesVisibleLocked(null, 0);
        }
    }

    private final int getLRURecordIndexForAppLocked(IApplicationThread thread) {
        IBinder threadBinder = thread.asBinder();
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord rec = this.mLruProcesses.get(i);
            if (rec.thread == null || rec.thread.asBinder() != threadBinder) continue;
            return i;
        }
        return -1;
    }

    final ProcessRecord getRecordForAppLocked(IApplicationThread thread) {
        if (thread == null) {
            return null;
        }
        int appIndex = this.getLRURecordIndexForAppLocked(thread);
        return appIndex >= 0 ? this.mLruProcesses.get(appIndex) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void appDiedLocked(ProcessRecord app, int pid, IApplicationThread thread) {
        BatteryStatsImpl stats;
        this.mProcDeaths[0] = this.mProcDeaths[0] + 1;
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            stats.noteProcessDiedLocked(app.info.uid, pid);
        }
        if (app.pid == pid && app.thread != null && app.thread.asBinder() == thread.asBinder()) {
            if (!app.killedBackground) {
                Slog.i((String)TAG, (String)("Process " + app.processName + " (pid " + pid + ") has died."));
            }
            EventLog.writeEvent((int)30011, (Object[])new Object[]{app.pid, app.processName});
            boolean doLowMem = app.instrumentationClass == null;
            this.handleAppDiedLocked(app, false, true);
            if (doLowMem) {
                boolean haveBg = false;
                for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                    ProcessRecord rec = this.mLruProcesses.get(i);
                    if (rec.thread == null || rec.setAdj < ProcessList.HIDDEN_APP_MIN_ADJ) continue;
                    haveBg = true;
                    break;
                }
                if (!haveBg) {
                    EventLog.writeEvent((int)30017, (int)this.mLruProcesses.size());
                    long now = SystemClock.uptimeMillis();
                    for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                        ProcessRecord rec = this.mLruProcesses.get(i);
                        if (rec == app || rec.thread == null || rec.lastLowMemory + 60000L > now) continue;
                        rec.lastRequestedGc = rec.setAdj <= 3 ? 0L : rec.lastLowMemory;
                        rec.reportLowMemory = true;
                        rec.lastLowMemory = now;
                        this.mProcessesToGc.remove(rec);
                        this.addProcessToGcListLocked(rec);
                    }
                    this.mHandler.sendEmptyMessage(33);
                    this.scheduleAppGcsLocked();
                }
            }
        } else if (app.pid != pid) {
            Slog.i((String)TAG, (String)("Process " + app.processName + " (pid " + pid + ") has died and restarted (pid " + app.pid + ")."));
            EventLog.writeEvent((int)30011, (Object[])new Object[]{app.pid, app.processName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File dumpStackTraces(boolean clearTraces, ArrayList<Integer> firstPids, ProcessStats processStats, SparseArray<Boolean> lastPids) {
        File file;
        String tracesPath = SystemProperties.get((String)"dalvik.vm.stack-trace-file", null);
        if (tracesPath == null || tracesPath.length() == 0) {
            return null;
        }
        File tracesFile = new File(tracesPath);
        try {
            File tracesDir = tracesFile.getParentFile();
            if (!tracesDir.exists()) {
                tracesFile.mkdirs();
            }
            FileUtils.setPermissions((String)tracesDir.getPath(), (int)509, (int)-1, (int)-1);
            if (clearTraces && tracesFile.exists()) {
                tracesFile.delete();
            }
            tracesFile.createNewFile();
            FileUtils.setPermissions((String)tracesFile.getPath(), (int)438, (int)-1, (int)-1);
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)("Unable to prepare ANR traces file: " + tracesPath), (Throwable)e);
            return null;
        }
        FileObserver observer = new FileObserver(tracesPath, 8){

            public synchronized void onEvent(int event, String path) {
                ((Object)((Object)this)).notify();
            }
        };
        try {
            observer.startWatching();
            try {
                int num = firstPids.size();
                for (int i = 0; i < num; ++i) {
                    FileObserver fileObserver = observer;
                    synchronized (fileObserver) {
                        android.os.Process.sendSignal((int)firstPids.get(i), (int)3);
                        observer.wait(200L);
                        continue;
                    }
                }
            }
            catch (InterruptedException e) {
                Log.wtf((String)TAG, (Throwable)e);
            }
            if (processStats != null) {
                processStats.init();
                System.gc();
                processStats.update();
                try {
                    ProcessStats e = processStats;
                    synchronized (e) {
                        processStats.wait(500L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                processStats.update();
                int N = processStats.countWorkingStats();
                int numProcs = 0;
                for (int i = 0; i < N && numProcs < 5; ++i) {
                    ProcessStats.Stats stats = processStats.getWorkingStats(i);
                    if (lastPids.indexOfKey(stats.pid) < 0) continue;
                    ++numProcs;
                    try {
                        FileObserver fileObserver = observer;
                        synchronized (fileObserver) {
                            android.os.Process.sendSignal((int)stats.pid, (int)3);
                            observer.wait(200L);
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        Log.wtf((String)TAG, (Throwable)e);
                    }
                }
            }
            file = tracesFile;
            Object var14_22 = null;
        }
        catch (Throwable throwable) {
            Object var14_23 = null;
            observer.stopWatching();
            throw throwable;
        }
        observer.stopWatching();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void appNotResponding(ProcessRecord app, ActivityRecord activity, ActivityRecord parent, String annotation) {
        ArrayList<Integer> firstPids = new ArrayList<Integer>(5);
        SparseArray lastPids = new SparseArray(20);
        if (this.mController != null) {
            try {
                int res = this.mController.appEarlyNotResponding(app.processName, app.pid, annotation);
                if (res < 0 && app.pid != MY_PID) {
                    android.os.Process.killProcess((int)app.pid);
                }
            }
            catch (RemoteException e) {
                this.mController = null;
            }
        }
        long anrTime = SystemClock.uptimeMillis();
        this.updateCpuStatsNow();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mShuttingDown) {
                Slog.i((String)TAG, (String)("During shutdown skipping ANR: " + app + " " + annotation));
                return;
            }
            if (app.notResponding) {
                Slog.i((String)TAG, (String)("Skipping duplicate ANR: " + app + " " + annotation));
                return;
            }
            if (app.crashing) {
                Slog.i((String)TAG, (String)("Crashing app skipping ANR: " + app + " " + annotation));
                return;
            }
            app.notResponding = true;
            EventLog.writeEvent((int)30008, (Object[])new Object[]{app.pid, app.processName, app.info.flags, annotation});
            firstPids.add(app.pid);
            int parentPid = app.pid;
            if (parent != null && parent.app != null && parent.app.pid > 0) {
                parentPid = parent.app.pid;
            }
            if (parentPid != app.pid) {
                firstPids.add(parentPid);
            }
            if (MY_PID != app.pid && MY_PID != parentPid) {
                firstPids.add(MY_PID);
            }
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                int pid;
                ProcessRecord r = this.mLruProcesses.get(i);
                if (r == null || r.thread == null || (pid = r.pid) <= 0 || pid == app.pid || pid == parentPid || pid == MY_PID) continue;
                if (r.persistent) {
                    firstPids.add(pid);
                    continue;
                }
                lastPids.put(pid, (Object)Boolean.TRUE);
            }
        }
        StringBuilder info = this.mStringBuilder;
        info.setLength(0);
        info.append("ANR in ").append(app.processName);
        if (activity != null && activity.shortComponentName != null) {
            info.append(" (").append(activity.shortComponentName).append(")");
        }
        info.append("\n");
        if (annotation != null) {
            info.append("Reason: ").append(annotation).append("\n");
        }
        if (parent != null && parent != activity) {
            info.append("Parent: ").append(parent.shortComponentName).append("\n");
        }
        ProcessStats processStats = new ProcessStats(true);
        File tracesFile = ActivityManagerService.dumpStackTraces(true, firstPids, processStats, (SparseArray<Boolean>)lastPids);
        String cpuInfo = null;
        this.updateCpuStatsNow();
        Thread pid = this.mProcessStatsThread;
        synchronized (pid) {
            cpuInfo = this.mProcessStats.printCurrentState(anrTime);
        }
        info.append(processStats.printCurrentLoad());
        info.append(cpuInfo);
        info.append(processStats.printCurrentState(anrTime));
        Slog.e((String)TAG, (String)info.toString());
        if (tracesFile == null) {
            android.os.Process.sendSignal((int)app.pid, (int)3);
        }
        this.addErrorToDropBox("anr", app, app.processName, activity, parent, annotation, cpuInfo, tracesFile, null);
        if (this.mController != null) {
            try {
                int res = this.mController.appNotResponding(app.processName, app.pid, info.toString());
                if (res != 0) {
                    if (res < 0 && app.pid != MY_PID) {
                        android.os.Process.killProcess((int)app.pid);
                    }
                    return;
                }
            }
            catch (RemoteException e) {
                this.mController = null;
            }
        }
        boolean showBackground = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"anr_show_background", (int)0) != 0;
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            if (!showBackground && !app.isInterestingToUserLocked() && app.pid != MY_PID) {
                Slog.w((String)TAG, (String)("Killing " + app + ": background ANR"));
                EventLog.writeEvent((int)30023, (Object[])new Object[]{app.pid, app.processName, app.setAdj, "background ANR"});
                android.os.Process.killProcessQuiet((int)app.pid);
                return;
            }
            this.makeAppNotRespondingLocked(app, activity != null ? activity.shortComponentName : null, annotation != null ? "ANR " + annotation : "ANR", info.toString());
            Message msg = Message.obtain();
            HashMap<String, Object> map = new HashMap<String, Object>();
            msg.what = 2;
            msg.obj = map;
            map.put("app", app);
            if (activity != null) {
                map.put("activity", activity);
            }
            this.mHandler.sendMessage(msg);
        }
    }

    final void showLaunchWarningLocked(final ActivityRecord cur, final ActivityRecord next) {
        if (!this.mLaunchWarningShown) {
            this.mLaunchWarningShown = true;
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        final LaunchWarningWindow d = new LaunchWarningWindow(ActivityManagerService.this.mContext, cur, next);
                        d.show();
                        ActivityManagerService.this.mHandler.postDelayed(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                ActivityManagerService activityManagerService = ActivityManagerService.this;
                                synchronized (activityManagerService) {
                                    d.dismiss();
                                    ActivityManagerService.this.mLaunchWarningShown = false;
                                }
                            }
                        }, 4000L);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        long callingId;
        block12: {
            boolean bl;
            block11: {
                int uid = Binder.getCallingUid();
                int pid = Binder.getCallingPid();
                callingId = Binder.clearCallingIdentity();
                try {
                    IPackageManager pm = AppGlobals.getPackageManager();
                    int pkgUid = -1;
                    ActivityManagerService activityManagerService = this;
                    synchronized (activityManagerService) {
                        try {
                            pkgUid = pm.getPackageUid(packageName);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                        if (pkgUid == -1) {
                            Slog.w((String)TAG, (String)("Invalid packageName:" + packageName));
                            bl = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 5, 10] lbl18 : MonitorExitStatement: MONITOREXIT : var9_8
                            Object var13_12 = null;
                            break block11;
                        }
                        if (uid != pkgUid) {
                            if (this.checkComponentPermission("android.permission.CLEAR_APP_USER_DATA", pid, uid, -1, true) != 0) throw new SecurityException(pid + " does not have permission:" + "android.permission.CLEAR_APP_USER_DATA" + " to clear data" + "for process:" + packageName);
                        }
                        this.forceStopPackageLocked(packageName, pkgUid);
                    }
                    try {
                        pm.clearApplicationUserData(packageName, observer);
                        Intent intent = new Intent("android.intent.action.PACKAGE_DATA_CLEARED", Uri.fromParts((String)"package", (String)packageName, null));
                        intent.putExtra("android.intent.extra.UID", pkgUid);
                        this.broadcastIntentInPackage("android", 1000, intent, null, null, 0, null, null, null, false, false);
                    }
                    catch (RemoteException e) {
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    Binder.restoreCallingIdentity((long)callingId);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity((long)callingId);
            return bl;
        }
        Object var13_13 = null;
        Binder.restoreCallingIdentity((long)callingId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void killBackgroundProcesses(String packageName) {
        long callingId;
        block10: {
            block9: {
                if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0 && this.checkCallingPermission("android.permission.RESTART_PACKAGES") != 0) {
                    String msg = "Permission Denial: killBackgroundProcesses() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
                    Slog.w((String)TAG, (String)msg);
                    throw new SecurityException(msg);
                }
                callingId = Binder.clearCallingIdentity();
                try {
                    IPackageManager pm = AppGlobals.getPackageManager();
                    int pkgUid = -1;
                    ActivityManagerService activityManagerService = this;
                    synchronized (activityManagerService) {
                        try {
                            pkgUid = pm.getPackageUid(packageName);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                        if (pkgUid == -1) {
                            Slog.w((String)TAG, (String)("Invalid packageName: " + packageName));
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 8] lbl20 : MonitorExitStatement: MONITOREXIT : var6_6
                            Object var10_8 = null;
                            break block9;
                        }
                        this.killPackageProcessesLocked(packageName, pkgUid, 5, false, true, true, false, "kill background");
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    Binder.restoreCallingIdentity((long)callingId);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity((long)callingId);
            return;
        }
        Object var10_9 = null;
        Binder.restoreCallingIdentity((long)callingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAllBackgroundProcesses() {
        if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0) {
            String msg = "Permission Denial: killAllBackgroundProcesses() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
            Slog.w((String)TAG, (String)msg);
            throw new SecurityException(msg);
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
                for (SparseArray<ProcessRecord> apps : this.mProcessNames.getMap().values()) {
                    int NA = apps.size();
                    for (int ia = 0; ia < NA; ++ia) {
                        ProcessRecord app = (ProcessRecord)apps.valueAt(ia);
                        if (app.persistent) continue;
                        if (app.removed) {
                            procs.add(app);
                            continue;
                        }
                        if (app.setAdj < ProcessList.HIDDEN_APP_MIN_ADJ) continue;
                        app.removed = true;
                        procs.add(app);
                    }
                }
                int N = procs.size();
                for (int i = 0; i < N; ++i) {
                    this.removeProcessLocked((ProcessRecord)procs.get(i), false, true, "kill all background");
                }
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            Binder.restoreCallingIdentity((long)callingId);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)callingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void forceStopPackage(String packageName) {
        long callingId;
        block13: {
            block12: {
                if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
                    String msg = "Permission Denial: forceStopPackage() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
                    Slog.w((String)TAG, (String)msg);
                    throw new SecurityException(msg);
                }
                callingId = Binder.clearCallingIdentity();
                try {
                    IPackageManager pm = AppGlobals.getPackageManager();
                    int pkgUid = -1;
                    ActivityManagerService activityManagerService = this;
                    synchronized (activityManagerService) {
                        try {
                            pkgUid = pm.getPackageUid(packageName);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                        if (pkgUid == -1) {
                            Slog.w((String)TAG, (String)("Invalid packageName: " + packageName));
                            // MONITOREXIT @DISABLED, blocks:[0, 5, 11] lbl20 : MonitorExitStatement: MONITOREXIT : var6_6
                            Object var10_10 = null;
                            break block12;
                        }
                        this.forceStopPackageLocked(packageName, pkgUid);
                        try {
                            pm.setPackageStoppedState(packageName, true);
                        }
                        catch (RemoteException e) {
                        }
                        catch (IllegalArgumentException e) {
                            Slog.w((String)TAG, (String)("Failed trying to unstop package " + packageName + ": " + e));
                        }
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    Binder.restoreCallingIdentity((long)callingId);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity((long)callingId);
            return;
        }
        Object var10_11 = null;
        Binder.restoreCallingIdentity((long)callingId);
    }

    public void killApplicationWithUid(String pkg, int uid) {
        if (pkg == null) {
            return;
        }
        if (uid < 0) {
            Slog.w((String)TAG, (String)("Invalid uid specified for pkg : " + pkg));
            return;
        }
        int callerUid = Binder.getCallingUid();
        if (callerUid != 1000) {
            throw new SecurityException(callerUid + " cannot kill pkg: " + pkg);
        }
        Message msg = this.mHandler.obtainMessage(22);
        msg.arg1 = uid;
        msg.arg2 = 0;
        msg.obj = pkg;
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSystemDialogs(String reason) {
        Intent intent = new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        intent.addFlags(0x40000000);
        if (reason != null) {
            intent.putExtra("reason", reason);
        }
        int uid = Binder.getCallingUid();
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int i = this.mWatchers.beginBroadcast();
            while (i > 0) {
                IActivityWatcher w;
                if ((w = (IActivityWatcher)this.mWatchers.getBroadcastItem(--i)) == null) continue;
                try {
                    w.closingSystemDialogs(reason);
                }
                catch (RemoteException e) {}
            }
            this.mWatchers.finishBroadcast();
            this.mWindowManager.closeSystemDialogs(reason);
            for (i = this.mMainStack.mHistory.size() - 1; i >= 0; --i) {
                ActivityRecord r = this.mMainStack.mHistory.get(i);
                if ((r.info.flags & 0x100) == 0) continue;
                r.stack.finishActivityLocked(r, i, 0, null, "close-sys");
            }
            this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, false, false, -1, uid);
        }
        Binder.restoreCallingIdentity((long)origId);
    }

    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] pids) throws RemoteException {
        Debug.MemoryInfo[] infos = new Debug.MemoryInfo[pids.length];
        for (int i = pids.length - 1; i >= 0; --i) {
            infos[i] = new Debug.MemoryInfo();
            Debug.getMemoryInfo((int)pids[i], (Debug.MemoryInfo)infos[i]);
        }
        return infos;
    }

    public long[] getProcessPss(int[] pids) throws RemoteException {
        long[] pss = new long[pids.length];
        for (int i = pids.length - 1; i >= 0; --i) {
            pss[i] = Debug.getPss((int)pids[i]);
        }
        return pss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killApplicationProcess(String processName, int uid) {
        if (processName == null) {
            return;
        }
        int callerUid = Binder.getCallingUid();
        if (callerUid == 1000) {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ProcessRecord app = this.getProcessRecordLocked(processName, uid);
                if (app != null && app.thread != null) {
                    try {
                        app.thread.scheduleSuicide();
                    }
                    catch (RemoteException e) {}
                } else {
                    Slog.w((String)TAG, (String)("Process/uid not found attempting kill of " + processName + " / " + uid));
                }
            }
        } else {
            throw new SecurityException(callerUid + " cannot kill app process: " + processName);
        }
    }

    private void forceStopPackageLocked(String packageName, int uid) {
        this.forceStopPackageLocked(packageName, uid, false, false, true, false);
        Intent intent = new Intent("android.intent.action.PACKAGE_RESTARTED", Uri.fromParts((String)"package", (String)packageName, null));
        if (!this.mProcessesReady) {
            intent.addFlags(0x40000000);
        }
        intent.putExtra("android.intent.extra.UID", uid);
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, false, false, MY_PID, 1000);
    }

    private final boolean killPackageProcessesLocked(String packageName, int uid, int minOomAdj, boolean callerWillRestart, boolean allowRestart, boolean doit, boolean evenPersistent, String reason) {
        ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
        String procNamePrefix = packageName + ":";
        for (SparseArray<ProcessRecord> apps : this.mProcessNames.getMap().values()) {
            int NA = apps.size();
            for (int ia = 0; ia < NA; ++ia) {
                ProcessRecord app = (ProcessRecord)apps.valueAt(ia);
                if (app.persistent && !evenPersistent) continue;
                if (app.removed) {
                    if (!doit) continue;
                    procs.add(app);
                    continue;
                }
                if ((uid <= 0 || uid == 1000 || app.info.uid != uid) && !app.processName.equals(packageName) && !app.processName.startsWith(procNamePrefix) || app.setAdj < minOomAdj) continue;
                if (!doit) {
                    return true;
                }
                app.removed = true;
                procs.add(app);
            }
        }
        int N = procs.size();
        for (int i = 0; i < N; ++i) {
            this.removeProcessLocked((ProcessRecord)procs.get(i), callerWillRestart, allowRestart, reason);
        }
        return N > 0;
    }

    private final boolean forceStopPackageLocked(String name, int uid, boolean callerWillRestart, boolean purgeCache, boolean doit, boolean evenPersistent) {
        int i;
        if (uid < 0) {
            try {
                uid = AppGlobals.getPackageManager().getPackageUid(name);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (doit) {
            Slog.i((String)TAG, (String)("Force stopping package " + name + " uid=" + uid));
            Iterator<SparseArray<Long>> badApps = this.mProcessCrashTimes.getMap().values().iterator();
            while (badApps.hasNext()) {
                SparseArray<Long> ba = badApps.next();
                if (ba.get(uid) == null) continue;
                badApps.remove();
            }
        }
        boolean didSomething = this.killPackageProcessesLocked(name, uid, -100, callerWillRestart, false, doit, evenPersistent, "force stop");
        TaskRecord lastTask = null;
        for (i = 0; i < this.mMainStack.mHistory.size(); ++i) {
            ActivityRecord r = this.mMainStack.mHistory.get(i);
            boolean samePackage = r.packageName.equals(name);
            if (!samePackage && r.task != lastTask || r.app != null && !evenPersistent && r.app.persistent) continue;
            if (!doit) {
                if (r.finishing) continue;
                return true;
            }
            didSomething = true;
            Slog.i((String)TAG, (String)("  Force finishing activity " + r));
            if (samePackage) {
                if (r.app != null) {
                    r.app.removed = true;
                }
                r.app = null;
            }
            lastTask = r.task;
            if (!r.stack.finishActivityLocked(r, i, 0, null, "force-stop")) continue;
            --i;
        }
        ArrayList<ServiceRecord> services = new ArrayList<ServiceRecord>();
        for (ServiceRecord service : this.mServices.values()) {
            if (!service.packageName.equals(name) || service.app != null && !evenPersistent && service.app.persistent) continue;
            if (!doit) {
                return true;
            }
            didSomething = true;
            Slog.i((String)TAG, (String)("  Force stopping service " + (Object)((Object)service)));
            if (service.app != null) {
                service.app.removed = true;
            }
            service.app = null;
            services.add(service);
        }
        int N = services.size();
        for (i = 0; i < N; ++i) {
            this.bringDownServiceLocked((ServiceRecord)((Object)services.get(i)), true);
        }
        ArrayList<ContentProviderRecord> providers = new ArrayList<ContentProviderRecord>();
        for (ContentProviderRecord provider : this.mProvidersByClass.values()) {
            if (!provider.info.packageName.equals(name) || provider.proc != null && !evenPersistent && provider.proc.persistent) continue;
            if (!doit) {
                return true;
            }
            didSomething = true;
            providers.add(provider);
        }
        N = providers.size();
        for (i = 0; i < N; ++i) {
            this.removeDyingProviderLocked(null, (ContentProviderRecord)((Object)providers.get(i)));
        }
        if (doit) {
            AttributeCache ac;
            if (purgeCache && (ac = AttributeCache.instance()) != null) {
                ac.removePackage(name);
            }
            if (this.mBooted) {
                this.mMainStack.resumeTopActivityLocked(null);
                this.mMainStack.scheduleIdleLocked();
            }
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeProcessLocked(ProcessRecord app, boolean callerWillRestart, boolean allowRestart, String reason) {
        String name = app.processName;
        int uid = app.info.uid;
        this.mProcessNames.remove(name, uid);
        if (this.mHeavyWeightProcess == app) {
            this.mHeavyWeightProcess = null;
            this.mHandler.sendEmptyMessage(25);
        }
        boolean needRestart = false;
        if (app.pid > 0 && app.pid != MY_PID) {
            int pid = app.pid;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(pid);
                this.mHandler.removeMessages(20, (Object)app);
            }
            Slog.i((String)TAG, (String)("Killing proc " + app.toShortString() + ": " + reason));
            this.handleAppDiedLocked(app, true, allowRestart);
            this.mLruProcesses.remove(app);
            android.os.Process.killProcessQuiet((int)pid);
            if (app.persistent) {
                if (!callerWillRestart) {
                    this.addAppLocked(app.info);
                } else {
                    needRestart = true;
                }
            }
        } else {
            this.mRemovedProcesses.add(app);
        }
        return needRestart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processStartTimedOutLocked(ProcessRecord app) {
        int pid = app.pid;
        boolean gone = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            ProcessRecord knownApp = (ProcessRecord)this.mPidsSelfLocked.get(pid);
            if (knownApp != null && knownApp.thread == null) {
                this.mPidsSelfLocked.remove(pid);
                gone = true;
            }
        }
        if (gone) {
            Slog.w((String)TAG, (String)("Process " + app + " failed to attach"));
            EventLog.writeEvent((int)30037, (Object[])new Object[]{pid, app.info.uid, app.processName});
            this.mProcessNames.remove(app.processName, app.info.uid);
            if (this.mHeavyWeightProcess == app) {
                this.mHeavyWeightProcess = null;
                this.mHandler.sendEmptyMessage(25);
            }
            this.checkAppInLaunchingProvidersLocked(app, true);
            for (int i = 0; i < this.mPendingServices.size(); ++i) {
                ServiceRecord sr = this.mPendingServices.get(i);
                if (app.info.uid != sr.appInfo.uid || !app.processName.equals(sr.processName)) continue;
                Slog.w((String)TAG, (String)("Forcing bringing down service: " + (Object)((Object)sr)));
                this.mPendingServices.remove(i);
                --i;
                this.bringDownServiceLocked(sr, true);
            }
            EventLog.writeEvent((int)30023, (Object[])new Object[]{pid, app.processName, app.setAdj, "start timeout"});
            android.os.Process.killProcessQuiet((int)pid);
            if (this.mBackupTarget != null && this.mBackupTarget.app.pid == pid) {
                Slog.w((String)TAG, (String)"Unattached app died before backup, skipping");
                try {
                    IBackupManager bm = IBackupManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"backup"));
                    bm.agentDisconnected(app.info.packageName);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            if (this.mPendingBroadcast != null && this.mPendingBroadcast.curApp.pid == pid) {
                Slog.w((String)TAG, (String)"Unattached app died before broadcast acknowledged, skipping");
                this.mPendingBroadcast.state = 0;
                this.mPendingBroadcast.nextReceiver = this.mPendingBroadcastRecvIndex;
                this.mPendingBroadcast = null;
                this.scheduleBroadcastsLocked();
            }
        } else {
            Slog.w((String)TAG, (String)("Spurious process start timeout - pid not known for " + app));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean attachApplicationLocked(IApplicationThread thread, int pid) {
        List<ProviderInfo> providers;
        ProcessRecord app;
        if (pid != MY_PID && pid >= 0) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                app = (ProcessRecord)this.mPidsSelfLocked.get(pid);
            }
        } else {
            app = null;
        }
        if (app == null) {
            Slog.w((String)TAG, (String)("No pending application record for pid " + pid + " (IApplicationThread " + thread + "); dropping process"));
            EventLog.writeEvent((int)30033, (int)pid);
            if (pid > 0 && pid != MY_PID) {
                android.os.Process.killProcessQuiet((int)pid);
            } else {
                try {
                    thread.scheduleExit();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return false;
        }
        if (app.thread != null) {
            this.handleAppDiedLocked(app, true, true);
        }
        String processName = app.processName;
        try {
            AppDeathRecipient adr = new AppDeathRecipient(app, pid, thread);
            thread.asBinder().linkToDeath((IBinder.DeathRecipient)adr, 0);
            app.deathRecipient = adr;
        }
        catch (RemoteException e) {
            app.resetPackageList();
            this.startProcessLocked(app, "link fail", processName);
            return false;
        }
        EventLog.writeEvent((int)30010, (Object[])new Object[]{app.pid, app.processName});
        app.thread = thread;
        app.setAdj = -100;
        app.curAdj = -100;
        app.curSchedGroup = 0;
        app.setSchedGroup = 1;
        app.forcingToForeground = null;
        app.foregroundServices = false;
        app.hasShownUi = false;
        app.debugging = false;
        this.mHandler.removeMessages(20, (Object)app);
        boolean normalMode = this.mProcessesReady || this.isAllowedWhileBooting(app.info);
        List<ProviderInfo> list = providers = normalMode ? this.generateApplicationProvidersLocked(app) : null;
        if (!normalMode) {
            Slog.i((String)TAG, (String)("Launching preboot mode app: " + app));
        }
        try {
            int testMode = 0;
            if (this.mDebugApp != null && this.mDebugApp.equals(processName)) {
                testMode = this.mWaitForDebugger ? 2 : 1;
                app.debugging = true;
                if (this.mDebugTransient) {
                    this.mDebugApp = this.mOrigDebugApp;
                    this.mWaitForDebugger = this.mOrigWaitForDebugger;
                }
            }
            String profileFile = app.instrumentationProfileFile;
            ParcelFileDescriptor profileFd = null;
            boolean profileAutoStop = false;
            if (this.mProfileApp != null && this.mProfileApp.equals(processName)) {
                this.mProfileProc = app;
                profileFile = this.mProfileFile;
                profileFd = this.mProfileFd;
                profileAutoStop = this.mAutoStopProfiler;
            }
            boolean isRestrictedBackupMode = false;
            if (this.mBackupTarget != null && this.mBackupAppName.equals(processName)) {
                isRestrictedBackupMode = this.mBackupTarget.backupMode == 2 || this.mBackupTarget.backupMode == 3 || this.mBackupTarget.backupMode == 1;
            }
            this.ensurePackageDexOpt(app.instrumentationInfo != null ? app.instrumentationInfo.packageName : app.info.packageName);
            if (app.instrumentationClass != null) {
                this.ensurePackageDexOpt(app.instrumentationClass.getPackageName());
            }
            ApplicationInfo appInfo = app.instrumentationInfo != null ? app.instrumentationInfo : app.info;
            app.compat = this.compatibilityInfoForPackageLocked(appInfo);
            if (profileFd != null) {
                profileFd = profileFd.dup();
            }
            thread.bindApplication(processName, appInfo, providers, app.instrumentationClass, profileFile, profileFd, profileAutoStop, app.instrumentationArguments, app.instrumentationWatcher, testMode, isRestrictedBackupMode || !normalMode, app.persistent, new Configuration(this.mConfiguration), app.compat, this.getCommonServicesLocked(), this.mCoreSettingsObserver.getCoreSettingsLocked());
            this.updateLruProcessLocked(app, false, true);
            app.lastRequestedGc = app.lastLowMemory = SystemClock.uptimeMillis();
        }
        catch (Exception e) {
            Slog.w((String)TAG, (String)"Exception thrown during bind!", (Throwable)e);
            app.resetPackageList();
            app.unlinkDeathRecipient();
            this.startProcessLocked(app, "bind fail", processName);
            return false;
        }
        this.mPersistentStartingProcesses.remove(app);
        this.mProcessesOnHold.remove(app);
        boolean badApp = false;
        boolean didSomething = false;
        ActivityRecord hr = this.mMainStack.topRunningActivityLocked(null);
        if (hr != null && normalMode) {
            if (hr.app == null && app.info.uid == hr.info.applicationInfo.uid && processName.equals(hr.processName)) {
                try {
                    if (this.mMainStack.realStartActivityLocked(hr, app, true, true)) {
                        didSomething = true;
                    }
                }
                catch (Exception e) {
                    Slog.w((String)TAG, (String)("Exception in new application when starting activity " + hr.intent.getComponent().flattenToShortString()), (Throwable)e);
                    badApp = true;
                }
            } else {
                this.mMainStack.ensureActivitiesVisibleLocked(hr, null, processName, 0);
            }
        }
        if (!badApp && this.mPendingServices.size() > 0) {
            ServiceRecord sr = null;
            try {
                for (int i = 0; i < this.mPendingServices.size(); ++i) {
                    sr = this.mPendingServices.get(i);
                    if (app.info.uid != sr.appInfo.uid || !processName.equals(sr.processName)) continue;
                    this.mPendingServices.remove(i);
                    --i;
                    this.realStartServiceLocked(sr, app);
                    didSomething = true;
                }
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)("Exception in new application when starting service " + sr.shortName), (Throwable)e);
                badApp = true;
            }
        }
        BroadcastRecord br = this.mPendingBroadcast;
        if (!badApp && br != null && br.curApp == app) {
            try {
                this.mPendingBroadcast = null;
                this.processCurBroadcastLocked(br, app);
                didSomething = true;
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)("Exception in new application when starting receiver " + br.curComponent.flattenToShortString()), (Throwable)e);
                badApp = true;
                this.logBroadcastReceiverDiscardLocked(br);
                this.finishReceiverLocked(br.receiver, br.resultCode, br.resultData, br.resultExtras, br.resultAbort, true);
                this.scheduleBroadcastsLocked();
                br.state = 0;
            }
        }
        if (!badApp && this.mBackupTarget != null && this.mBackupTarget.appInfo.uid == app.info.uid) {
            this.ensurePackageDexOpt(this.mBackupTarget.appInfo.packageName);
            try {
                thread.scheduleCreateBackupAgent(this.mBackupTarget.appInfo, this.compatibilityInfoForPackageLocked(this.mBackupTarget.appInfo), this.mBackupTarget.backupMode);
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)"Exception scheduling backup agent creation: ");
                e.printStackTrace();
            }
        }
        if (badApp) {
            this.handleAppDiedLocked(app, false, true);
            return false;
        }
        if (!didSomething) {
            this.updateOomAdjLocked();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void attachApplication(IApplicationThread thread) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingPid = Binder.getCallingPid();
            long origId = Binder.clearCallingIdentity();
            this.attachApplicationLocked(thread, callingPid);
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activityIdle(IBinder token, Configuration config, boolean stopProfiling) {
        long origId = Binder.clearCallingIdentity();
        ActivityRecord r = this.mMainStack.activityIdleInternal(token, false, config);
        if (stopProfiling) {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (this.mProfileProc == r.app && this.mProfileFd != null) {
                    try {
                        this.mProfileFd.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.clearProfilerLocked();
                }
            }
        }
        Binder.restoreCallingIdentity((long)origId);
    }

    void enableScreenAfterBoot() {
        EventLog.writeEvent((int)3050, (long)SystemClock.uptimeMillis());
        this.mWindowManager.enableScreenAfterBoot();
    }

    public void showBootMessage(CharSequence msg, boolean always) {
        this.mWindowManager.showBootMessage(msg, always);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissKeyguardOnNextActivity() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mMainStack.dismissKeyguardOnNextActivityLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finishBooting() {
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        pkgFilter.addDataScheme("package");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                String[] pkgs = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                if (pkgs != null) {
                    for (String pkg : pkgs) {
                        ActivityManagerService activityManagerService = ActivityManagerService.this;
                        synchronized (activityManagerService) {
                            if (ActivityManagerService.this.forceStopPackageLocked(pkg, -1, false, false, false, false)) {
                                this.setResultCode(-1);
                                return;
                            }
                        }
                    }
                }
            }
        }, pkgFilter);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int NP = this.mProcessesOnHold.size();
            if (NP > 0) {
                ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>(this.mProcessesOnHold);
                for (int ip = 0; ip < NP; ++ip) {
                    this.startProcessLocked(procs.get(ip), "on-hold", null);
                }
            }
            if (this.mFactoryTest != 1) {
                Message nmsg = this.mHandler.obtainMessage(27);
                this.mHandler.sendMessageDelayed(nmsg, 900000L);
                SystemProperties.set((String)"sys.boot_completed", (String)"1");
                this.broadcastIntentLocked(null, null, new Intent("android.intent.action.BOOT_COMPLETED", null), null, null, 0, null, null, "android.permission.RECEIVE_BOOT_COMPLETED", false, false, MY_PID, 1000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureBootCompleted() {
        boolean enableScreen;
        boolean booting;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            booting = this.mBooting;
            this.mBooting = false;
            enableScreen = !this.mBooted;
            this.mBooted = true;
        }
        if (booting) {
            this.finishBooting();
        }
        if (enableScreen) {
            this.enableScreenAfterBoot();
        }
    }

    public final void activityPaused(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        this.mMainStack.activityPaused(token, false);
        Binder.restoreCallingIdentity((long)origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activityStopped(IBinder token, Bundle icicle, Bitmap thumbnail, CharSequence description) {
        if (icicle != null && icicle.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        ActivityRecord r = null;
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            r = this.mMainStack.isInStackLocked(token);
            if (r != null) {
                r.stack.activityStoppedLocked(r, icicle, thumbnail, description);
            }
        }
        if (r != null) {
            this.sendPendingThumbnail(r, null, null, null, false);
        }
        this.trimApplications();
        Binder.restoreCallingIdentity((long)origId);
    }

    public final void activityDestroyed(IBinder token) {
        this.mMainStack.activityDestroyed(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCallingPackage(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getCallingRecordLocked(token);
            return r != null && r.app != null ? r.info.packageName : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentName getCallingActivity(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getCallingRecordLocked(token);
            return r != null ? r.intent.getComponent() : null;
        }
    }

    private ActivityRecord getCallingRecordLocked(IBinder token) {
        ActivityRecord r = this.mMainStack.isInStackLocked(token);
        if (r == null) {
            return null;
        }
        return r.resultTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentName getActivityClassForToken(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mMainStack.isInStackLocked(token);
            if (r == null) {
                return null;
            }
            return r.intent.getComponent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPackageForToken(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mMainStack.isInStackLocked(token);
            if (r == null) {
                return null;
            }
            return r.packageName;
        }
    }

    public IIntentSender getIntentSender(int type, String packageName, IBinder token, String resultWho, int requestCode, Intent[] intents, String[] resolvedTypes, int flags) {
        if (intents != null) {
            if (intents.length < 1) {
                throw new IllegalArgumentException("Intents array length must be >= 1");
            }
            for (int i = 0; i < intents.length; ++i) {
                Intent intent = intents[i];
                if (intent == null) continue;
                if (intent.hasFileDescriptors()) {
                    throw new IllegalArgumentException("File descriptors passed in Intent");
                }
                if (type == 1 && (intent.getFlags() & 0x8000000) != 0) {
                    throw new IllegalArgumentException("Can't use FLAG_RECEIVER_BOOT_UPGRADE here");
                }
                intents[i] = new Intent(intent);
            }
            if (resolvedTypes != null && resolvedTypes.length != intents.length) {
                throw new IllegalArgumentException("Intent array length does not match resolvedTypes length");
            }
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingUid = Binder.getCallingUid();
            try {
                int uid;
                if (callingUid != 0 && callingUid != 1000 && (uid = AppGlobals.getPackageManager().getPackageUid(packageName)) != Binder.getCallingUid()) {
                    String msg = "Permission Denial: getIntentSender() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + ", (need uid=" + uid + ")" + " is not allowed to send as package " + packageName;
                    Slog.w((String)TAG, (String)msg);
                    throw new SecurityException(msg);
                }
                return this.getIntentSenderLocked(type, packageName, callingUid, token, resultWho, requestCode, intents, resolvedTypes, flags);
            }
            catch (RemoteException e) {
                throw new SecurityException(e);
            }
        }
    }

    IIntentSender getIntentSenderLocked(int type, String packageName, int callingUid, IBinder token, String resultWho, int requestCode, Intent[] intents, String[] resolvedTypes, int flags) {
        PendingIntentRecord rec;
        ActivityRecord activity = null;
        if (type == 3) {
            activity = this.mMainStack.isInStackLocked(token);
            if (activity == null) {
                return null;
            }
            if (activity.finishing) {
                return null;
            }
        }
        boolean noCreate = (flags & 0x20000000) != 0;
        boolean cancelCurrent = (flags & 0x10000000) != 0;
        boolean updateCurrent = (flags & 0x8000000) != 0;
        PendingIntentRecord.Key key = new PendingIntentRecord.Key(type, packageName, activity, resultWho, requestCode, intents, resolvedTypes, flags &= 0xC7FFFFFF);
        WeakReference<PendingIntentRecord> ref = this.mIntentSenderRecords.get(key);
        PendingIntentRecord pendingIntentRecord = rec = ref != null ? (PendingIntentRecord)((Object)ref.get()) : null;
        if (rec != null) {
            if (!cancelCurrent) {
                if (updateCurrent) {
                    if (rec.key.requestIntent != null) {
                        rec.key.requestIntent.replaceExtras(intents != null ? intents[0] : null);
                    }
                    if (intents != null) {
                        intents[intents.length - 1] = rec.key.requestIntent;
                        rec.key.allIntents = intents;
                        rec.key.allResolvedTypes = resolvedTypes;
                    } else {
                        rec.key.allIntents = null;
                        rec.key.allResolvedTypes = null;
                    }
                }
                return rec;
            }
            rec.canceled = true;
            this.mIntentSenderRecords.remove(key);
        }
        if (noCreate) {
            return rec;
        }
        rec = new PendingIntentRecord(this, key, callingUid);
        this.mIntentSenderRecords.put(key, rec.ref);
        if (type == 3) {
            if (activity.pendingResults == null) {
                activity.pendingResults = new HashSet();
            }
            activity.pendingResults.add(rec.ref);
        }
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelIntentSender(IIntentSender sender) {
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            PendingIntentRecord rec = (PendingIntentRecord)sender;
            try {
                int uid = AppGlobals.getPackageManager().getPackageUid(rec.key.packageName);
                if (uid != Binder.getCallingUid()) {
                    String msg = "Permission Denial: cancelIntentSender() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " is not allowed to cancel packges " + rec.key.packageName;
                    Slog.w((String)TAG, (String)msg);
                    throw new SecurityException(msg);
                }
            }
            catch (RemoteException e) {
                throw new SecurityException(e);
            }
            this.cancelIntentSenderLocked(rec, true);
        }
    }

    void cancelIntentSenderLocked(PendingIntentRecord rec, boolean cleanActivity) {
        rec.canceled = true;
        this.mIntentSenderRecords.remove(rec.key);
        if (cleanActivity && rec.key.activity != null) {
            rec.key.activity.pendingResults.remove(rec.ref);
        }
    }

    public String getPackageForIntentSender(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.packageName;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public boolean isIntentSenderTargetedToPackage(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return false;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            if (res.key.allIntents == null) {
                return false;
            }
            for (int i = 0; i < res.key.allIntents.length; ++i) {
                Intent intent = res.key.allIntents[i];
                if (intent.getPackage() == null || intent.getComponent() == null) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessLimit(int max) {
        this.enforceCallingPermission("android.permission.SET_PROCESS_LIMIT", "setProcessLimit()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessLimit = max < 0 ? 15 : max;
            this.mProcessLimitOverride = max;
        }
        this.trimApplications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProcessLimit() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mProcessLimitOverride;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void foregroundTokenDied(ForegroundToken token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                ForegroundToken cur = (ForegroundToken)this.mForegroundProcesses.get(token.pid);
                if (cur != token) {
                    return;
                }
                this.mForegroundProcesses.remove(token.pid);
                ProcessRecord pr = (ProcessRecord)this.mPidsSelfLocked.get(token.pid);
                if (pr == null) {
                    return;
                }
                pr.forcingToForeground = null;
                pr.foregroundServices = false;
            }
            this.updateOomAdjLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessForeground(IBinder token, int pid, boolean isForeground) {
        this.enforceCallingPermission("android.permission.SET_PROCESS_LIMIT", "setProcessForeground()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean changed = false;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                ProcessRecord pr = (ProcessRecord)this.mPidsSelfLocked.get(pid);
                if (pr == null) {
                    Slog.w((String)TAG, (String)("setProcessForeground called on unknown pid: " + pid));
                    return;
                }
                ForegroundToken oldToken = (ForegroundToken)this.mForegroundProcesses.get(pid);
                if (oldToken != null) {
                    oldToken.token.unlinkToDeath((IBinder.DeathRecipient)oldToken, 0);
                    this.mForegroundProcesses.remove(pid);
                    pr.forcingToForeground = null;
                    changed = true;
                }
                if (isForeground && token != null) {
                    ForegroundToken newToken = new ForegroundToken(){

                        public void binderDied() {
                            ActivityManagerService.this.foregroundTokenDied(this);
                        }
                    };
                    newToken.pid = pid;
                    newToken.token = token;
                    try {
                        token.linkToDeath((IBinder.DeathRecipient)newToken, 0);
                        this.mForegroundProcesses.put(pid, (Object)newToken);
                        pr.forcingToForeground = token;
                        changed = true;
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
            if (changed) {
                this.updateOomAdjLocked();
            }
        }
    }

    int checkComponentPermission(String permission, int pid, int uid, int owningUid, boolean exported) {
        Identity tlsIdentity = sCallerIdentity.get();
        if (tlsIdentity != null) {
            Slog.d((String)TAG, (String)("checkComponentPermission() adjusting {pid,uid} to {" + tlsIdentity.pid + "," + tlsIdentity.uid + "}"));
            uid = tlsIdentity.uid;
            pid = tlsIdentity.pid;
        }
        if (uid == 0 || uid == 1000 || pid == MY_PID) {
            return 0;
        }
        if (owningUid >= 0 && uid == owningUid) {
            return 0;
        }
        if (!exported) {
            Slog.w((String)TAG, (String)("Permission denied: checkComponentPermission() owningUid=" + owningUid));
            return -1;
        }
        if (permission == null) {
            return 0;
        }
        try {
            return AppGlobals.getPackageManager().checkUidPermission(permission, uid);
        }
        catch (RemoteException e) {
            Slog.e((String)TAG, (String)"PackageManager is dead?!?", (Throwable)e);
            return -1;
        }
    }

    public int checkPermission(String permission, int pid, int uid) {
        if (permission == null) {
            return -1;
        }
        return this.checkComponentPermission(permission, pid, uid, -1, true);
    }

    int checkCallingPermission(String permission) {
        return this.checkPermission(permission, Binder.getCallingPid(), Binder.getCallingUid());
    }

    void enforceCallingPermission(String permission, String func) {
        if (this.checkCallingPermission(permission) == 0) {
            return;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission;
        Slog.w((String)TAG, (String)msg);
        throw new SecurityException(msg);
    }

    private final boolean checkHoldingPermissionsLocked(IPackageManager pm, ProviderInfo pi, Uri uri, int uid, int modeFlags) {
        boolean readPerm = (modeFlags & 1) == 0;
        boolean writePerm = (modeFlags & 2) == 0;
        try {
            PathPermission[] pps;
            boolean prv;
            boolean bl = prv = !pi.exported && pi.applicationInfo.uid != uid;
            if (!readPerm && (!prv && pi.readPermission == null || pm.checkUidPermission(pi.readPermission, uid) == 0)) {
                readPerm = true;
            }
            if (!writePerm && (!prv && pi.writePermission == null || pm.checkUidPermission(pi.writePermission, uid) == 0)) {
                writePerm = true;
            }
            if (!((pps = pi.pathPermissions) == null || readPerm && writePerm)) {
                String path = uri.getPath();
                int i = pps.length;
                while (!(i <= 0 || readPerm && writePerm)) {
                    String ppwperm;
                    String pprperm;
                    PathPermission pp = pps[--i];
                    if (!readPerm && (pprperm = pp.getReadPermission()) != null && pp.match(path) && pm.checkUidPermission(pprperm, uid) == 0) {
                        readPerm = true;
                    }
                    if (writePerm || (ppwperm = pp.getWritePermission()) == null || !pp.match(path) || pm.checkUidPermission(ppwperm, uid) != 0) continue;
                    writePerm = true;
                }
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return readPerm && writePerm;
    }

    private final boolean checkUriPermissionLocked(Uri uri, int uid, int modeFlags) {
        if (uid == 0) {
            return true;
        }
        HashMap perms = (HashMap)this.mGrantedUriPermissions.get(uid);
        if (perms == null) {
            return false;
        }
        UriPermission perm = (UriPermission)perms.get(uri);
        if (perm == null) {
            return false;
        }
        return (modeFlags & perm.modeFlags) == modeFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags) {
        Identity tlsIdentity = sCallerIdentity.get();
        if (tlsIdentity != null) {
            uid = tlsIdentity.uid;
            pid = tlsIdentity.pid;
        }
        if (pid == MY_PID) {
            return 0;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.checkUriPermissionLocked(uri, uid, modeFlags) ? 0 : -1;
        }
    }

    int checkGrantUriPermissionLocked(int callingUid, String targetPkg, Uri uri, int modeFlags) {
        int targetUid;
        ProviderInfo pi;
        IPackageManager pm;
        block23: {
            if ((modeFlags &= 3) == 0) {
                return -1;
            }
            if (targetPkg != null) {
                // empty if block
            }
            pm = AppGlobals.getPackageManager();
            if (!"content".equals(uri.getScheme())) {
                return -1;
            }
            String name = uri.getAuthority();
            pi = null;
            ContentProviderRecord cpr = this.mProvidersByName.get(name);
            if (cpr != null) {
                pi = cpr.info;
            } else {
                try {
                    pi = pm.resolveContentProvider(name, 2048);
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
            if (pi == null) {
                Slog.w((String)TAG, (String)("No content provider found for permission check: " + uri.toSafeString()));
                return -1;
            }
            if (targetPkg != null) {
                try {
                    targetUid = pm.getPackageUid(targetPkg);
                    if (targetUid < 0) {
                        return -1;
                    }
                    break block23;
                }
                catch (RemoteException ex) {
                    return -1;
                }
            }
            targetUid = -1;
        }
        if (targetUid >= 0) {
            if (this.checkHoldingPermissionsLocked(pm, pi, uri, targetUid, modeFlags)) {
                return -1;
            }
        } else {
            boolean allowed = pi.exported;
            if ((modeFlags & 1) != 0 && pi.readPermission != null) {
                allowed = false;
            }
            if ((modeFlags & 2) != 0 && pi.writePermission != null) {
                allowed = false;
            }
            if (allowed) {
                return -1;
            }
        }
        if (!pi.grantUriPermissions) {
            throw new SecurityException("Provider " + pi.packageName + "/" + pi.name + " does not allow granting of Uri permissions (uri " + uri + ")");
        }
        if (pi.uriPermissionPatterns != null) {
            int N = pi.uriPermissionPatterns.length;
            boolean allowed = false;
            for (int i = 0; i < N; ++i) {
                if (pi.uriPermissionPatterns[i] == null || !pi.uriPermissionPatterns[i].match(uri.getPath())) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                throw new SecurityException("Provider " + pi.packageName + "/" + pi.name + " does not allow granting of permission to path of Uri " + uri);
            }
        }
        if (callingUid != android.os.Process.myUid() && !this.checkHoldingPermissionsLocked(pm, pi, uri, callingUid, modeFlags) && !this.checkUriPermissionLocked(uri, callingUid, modeFlags)) {
            throw new SecurityException("Uid " + callingUid + " does not have permission to uri " + uri);
        }
        return targetUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkGrantUriPermission(int callingUid, String targetPkg, Uri uri, int modeFlags) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.checkGrantUriPermissionLocked(callingUid, targetPkg, uri, modeFlags);
        }
    }

    void grantUriPermissionUncheckedLocked(int targetUid, String targetPkg, Uri uri, int modeFlags, UriPermissionOwner owner) {
        UriPermission perm;
        if ((modeFlags &= 3) == 0) {
            return;
        }
        HashMap<Uri, UriPermission> targetUris = (HashMap<Uri, UriPermission>)this.mGrantedUriPermissions.get(targetUid);
        if (targetUris == null) {
            targetUris = new HashMap<Uri, UriPermission>();
            this.mGrantedUriPermissions.put(targetUid, targetUris);
        }
        if ((perm = (UriPermission)targetUris.get(uri)) == null) {
            perm = new UriPermission(targetUid, uri);
            targetUris.put(uri, perm);
        }
        perm.modeFlags |= modeFlags;
        if (owner == null) {
            perm.globalModeFlags |= modeFlags;
        } else {
            if ((modeFlags & 1) != 0) {
                perm.readOwners.add(owner);
                owner.addReadPermission(perm);
            }
            if ((modeFlags & 2) != 0) {
                perm.writeOwners.add(owner);
                owner.addWritePermission(perm);
            }
        }
    }

    void grantUriPermissionLocked(int callingUid, String targetPkg, Uri uri, int modeFlags, UriPermissionOwner owner) {
        if (targetPkg == null) {
            throw new NullPointerException("targetPkg");
        }
        int targetUid = this.checkGrantUriPermissionLocked(callingUid, targetPkg, uri, modeFlags);
        if (targetUid < 0) {
            return;
        }
        this.grantUriPermissionUncheckedLocked(targetUid, targetPkg, uri, modeFlags, owner);
    }

    int checkGrantUriPermissionFromIntentLocked(int callingUid, String targetPkg, Intent intent) {
        if (targetPkg == null) {
            throw new NullPointerException("targetPkg");
        }
        if (intent == null) {
            return -1;
        }
        Uri data = intent.getData();
        if (data == null) {
            return -1;
        }
        return this.checkGrantUriPermissionLocked(callingUid, targetPkg, data, intent.getFlags());
    }

    void grantUriPermissionUncheckedFromIntentLocked(int targetUid, String targetPkg, Intent intent, UriPermissionOwner owner) {
        this.grantUriPermissionUncheckedLocked(targetUid, targetPkg, intent.getData(), intent.getFlags(), owner);
    }

    void grantUriPermissionFromIntentLocked(int callingUid, String targetPkg, Intent intent, UriPermissionOwner owner) {
        int targetUid = this.checkGrantUriPermissionFromIntentLocked(callingUid, targetPkg, intent);
        if (targetUid < 0) {
            return;
        }
        this.grantUriPermissionUncheckedFromIntentLocked(targetUid, targetPkg, intent, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantUriPermission(IApplicationThread caller, String targetPkg, Uri uri, int modeFlags) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " when granting permission to uri " + uri);
            }
            if (targetPkg == null) {
                throw new IllegalArgumentException("null target");
            }
            if (uri == null) {
                throw new IllegalArgumentException("null uri");
            }
            this.grantUriPermissionLocked(r.info.uid, targetPkg, uri, modeFlags, null);
        }
    }

    void removeUriPermissionIfNeededLocked(UriPermission perm) {
        HashMap perms;
        if ((perm.modeFlags & 3) == 0 && (perms = (HashMap)this.mGrantedUriPermissions.get(perm.uid)) != null) {
            perms.remove(perm.uri);
            if (perms.size() == 0) {
                this.mGrantedUriPermissions.remove(perm.uid);
            }
        }
    }

    private void revokeUriPermissionLocked(int callingUid, Uri uri, int modeFlags) {
        if ((modeFlags &= 3) == 0) {
            return;
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        String authority = uri.getAuthority();
        ProviderInfo pi = null;
        ContentProviderRecord cpr = this.mProvidersByName.get(authority);
        if (cpr != null) {
            pi = cpr.info;
        } else {
            try {
                pi = pm.resolveContentProvider(authority, 2048);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        if (pi == null) {
            Slog.w((String)TAG, (String)("No content provider found for permission revoke: " + uri.toSafeString()));
            return;
        }
        if (!this.checkHoldingPermissionsLocked(pm, pi, uri, callingUid, modeFlags)) {
            throw new SecurityException("Uid " + callingUid + " does not have permission to uri " + uri);
        }
        List SEGMENTS = uri.getPathSegments();
        if (SEGMENTS != null) {
            int NS = SEGMENTS.size();
            int N = this.mGrantedUriPermissions.size();
            for (int i = 0; i < N; ++i) {
                HashMap perms = (HashMap)this.mGrantedUriPermissions.valueAt(i);
                Iterator it = perms.values().iterator();
                block3: while (it.hasNext()) {
                    List targetSegments;
                    UriPermission perm = (UriPermission)it.next();
                    Uri targetUri = perm.uri;
                    if (!authority.equals(targetUri.getAuthority()) || (targetSegments = targetUri.getPathSegments()) == null || targetSegments.size() < NS) continue;
                    for (int j = 0; j < NS; ++j) {
                        if (!((String)SEGMENTS.get(j)).equals(targetSegments.get(j))) continue block3;
                    }
                    perm.clearModes(modeFlags);
                    if (perm.modeFlags != 0) continue;
                    it.remove();
                }
                if (perms.size() != 0) continue;
                this.mGrantedUriPermissions.remove(this.mGrantedUriPermissions.keyAt(i));
                --N;
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeUriPermission(IApplicationThread caller, Uri uri, int modeFlags) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " when revoking permission to uri " + uri);
            }
            if (uri == null) {
                Slog.w((String)TAG, (String)"revokeUriPermission: null uri");
                return;
            }
            if ((modeFlags &= 3) == 0) {
                return;
            }
            IPackageManager pm = AppGlobals.getPackageManager();
            String authority = uri.getAuthority();
            ProviderInfo pi = null;
            ContentProviderRecord cpr = this.mProvidersByName.get(authority);
            if (cpr != null) {
                pi = cpr.info;
            } else {
                try {
                    pi = pm.resolveContentProvider(authority, 2048);
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
            if (pi == null) {
                Slog.w((String)TAG, (String)("No content provider found for permission revoke: " + uri.toSafeString()));
                return;
            }
            this.revokeUriPermissionLocked(r.info.uid, uri, modeFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinder newUriPermissionOwner(String name) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = new UriPermissionOwner(this, name);
            return owner.getExternalTokenLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantUriPermissionFromOwner(IBinder token, int fromUid, String targetPkg, Uri uri, int modeFlags) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = UriPermissionOwner.fromExternalToken(token);
            if (owner == null) {
                throw new IllegalArgumentException("Unknown owner: " + token);
            }
            if (fromUid != Binder.getCallingUid() && Binder.getCallingUid() != android.os.Process.myUid()) {
                throw new SecurityException("nice try");
            }
            if (targetPkg == null) {
                throw new IllegalArgumentException("null target");
            }
            if (uri == null) {
                throw new IllegalArgumentException("null uri");
            }
            this.grantUriPermissionLocked(fromUid, targetPkg, uri, modeFlags, owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeUriPermissionFromOwner(IBinder token, Uri uri, int mode) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = UriPermissionOwner.fromExternalToken(token);
            if (owner == null) {
                throw new IllegalArgumentException("Unknown owner: " + token);
            }
            if (uri == null) {
                owner.removeUriPermissionsLocked(mode);
            } else {
                owner.removeUriPermissionLocked(uri, mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showWaitingForDebugger(IApplicationThread who, boolean waiting) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app;
            ProcessRecord processRecord = app = who != null ? this.getRecordForAppLocked(who) : null;
            if (app == null) {
                return;
            }
            Message msg = Message.obtain();
            msg.what = 6;
            msg.obj = app;
            msg.arg1 = waiting ? 1 : 0;
            this.mHandler.sendMessage(msg);
        }
    }

    public void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        long homeAppMem = this.mProcessList.getMemLevel(6);
        long hiddenAppMem = this.mProcessList.getMemLevel(ProcessList.HIDDEN_APP_MIN_ADJ);
        outInfo.availMem = android.os.Process.getFreeMemory();
        outInfo.threshold = homeAppMem;
        outInfo.lowMemory = outInfo.availMem < homeAppMem + (hiddenAppMem - homeAppMem) / 2L;
        outInfo.hiddenAppThreshold = hiddenAppMem;
        outInfo.secondaryServerThreshold = this.mProcessList.getMemLevel(5);
        outInfo.visibleAppThreshold = this.mProcessList.getMemLevel(1);
        outInfo.foregroundAppThreshold = this.mProcessList.getMemLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTasks(int maxNum, int flags, IThumbnailReceiver receiver) {
        ArrayList<ActivityManager.RunningTaskInfo> list = new ArrayList<ActivityManager.RunningTaskInfo>();
        PendingThumbnailsRecord pending = null;
        IApplicationThread topThumbnail = null;
        ActivityRecord topRecord = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.checkCallingPermission("android.permission.GET_TASKS") != 0) {
                if (receiver != null) {
                    try {
                        receiver.finished();
                    }
                    catch (RemoteException ex) {
                        // empty catch block
                    }
                }
                String msg = "Permission Denial: getTasks() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.GET_TASKS";
                Slog.w((String)TAG, (String)msg);
                throw new SecurityException(msg);
            }
            int pos = this.mMainStack.mHistory.size() - 1;
            ActivityRecord next = pos >= 0 ? this.mMainStack.mHistory.get(pos) : null;
            ActivityRecord top = null;
            TaskRecord curTask = null;
            int numActivities = 0;
            int numRunning = 0;
            while (pos >= 0 && maxNum > 0) {
                ActivityRecord r = next;
                ActivityRecord activityRecord = next = --pos >= 0 ? this.mMainStack.mHistory.get(pos) : null;
                if (top == null || top.state == ActivityStack.ActivityState.INITIALIZING && top.task == r.task) {
                    top = r;
                    curTask = r.task;
                    numRunning = 0;
                    numActivities = 0;
                }
                ++numActivities;
                if (r.app != null && r.app.thread != null) {
                    ++numRunning;
                }
                if (next != null && next.task == curTask) continue;
                ActivityManager.RunningTaskInfo ci = new ActivityManager.RunningTaskInfo();
                ci.id = curTask.taskId;
                ci.baseActivity = r.intent.getComponent();
                ci.topActivity = top.intent.getComponent();
                if (top.thumbHolder != null) {
                    ci.description = top.thumbHolder.lastDescription;
                }
                ci.numActivities = numActivities;
                ci.numRunning = numRunning;
                if (ci.thumbnail == null && receiver != null) {
                    if (top.state == ActivityStack.ActivityState.RESUMED || top.state == ActivityStack.ActivityState.PAUSING) {
                        if (top.idle && top.app != null && top.app.thread != null) {
                            topRecord = top;
                            topThumbnail = top.app.thread;
                        } else {
                            top.thumbnailNeeded = true;
                        }
                    }
                    if (pending == null) {
                        pending = new PendingThumbnailsRecord(receiver);
                    }
                    pending.pendingRecords.add(top);
                }
                list.add(ci);
                --maxNum;
                top = null;
            }
            if (pending != null) {
                this.mPendingThumbnails.add(pending);
            }
        }
        if (topThumbnail != null) {
            try {
                topThumbnail.requestThumbnail((IBinder)topRecord.appToken);
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)"Exception thrown when requesting thumbnail", (Throwable)e);
                this.sendPendingThumbnail(null, (IBinder)topRecord.appToken, null, null, true);
            }
        }
        if (pending == null && receiver != null) {
            try {
                receiver.finished();
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityManager.RecentTaskInfo> getRecentTasks(int maxNum, int flags) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.enforceCallingPermission("android.permission.GET_TASKS", "getRecentTasks()");
            IPackageManager pm = AppGlobals.getPackageManager();
            int N = this.mRecentTasks.size();
            ArrayList<ActivityManager.RecentTaskInfo> res = new ArrayList<ActivityManager.RecentTaskInfo>(maxNum < N ? maxNum : N);
            for (int i = 0; i < N && maxNum > 0; ++i) {
                TaskRecord tr = this.mRecentTasks.get(i);
                if (i != 0 && (flags & 1) == 0 && tr.intent != null && (tr.intent.getFlags() & 0x800000) != 0) continue;
                ActivityManager.RecentTaskInfo rti = new ActivityManager.RecentTaskInfo();
                rti.id = tr.numActivities > 0 ? tr.taskId : -1;
                rti.persistentId = tr.taskId;
                rti.baseIntent = new Intent(tr.intent != null ? tr.intent : tr.affinityIntent);
                rti.origActivity = tr.origActivity;
                rti.description = tr.lastDescription;
                if ((flags & 2) != 0) {
                    try {
                        if (rti.origActivity != null ? pm.getActivityInfo(rti.origActivity, 0) == null : rti.baseIntent != null && pm.queryIntentActivities(rti.baseIntent, null, 0) == null) {
                            continue;
                        }
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                res.add(rti);
                --maxNum;
            }
            return res;
        }
    }

    private TaskRecord taskForIdLocked(int id) {
        int N = this.mRecentTasks.size();
        for (int i = 0; i < N; ++i) {
            TaskRecord tr = this.mRecentTasks.get(i);
            if (tr.taskId != id) continue;
            return tr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityManager.TaskThumbnails getTaskThumbnails(int id) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.enforceCallingPermission("android.permission.READ_FRAME_BUFFER", "getTaskThumbnails()");
            TaskRecord tr = this.taskForIdLocked(id);
            if (tr != null) {
                return this.mMainStack.getTaskThumbnailsLocked(tr);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeSubTask(int taskId, int subTaskIndex) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean bl;
            this.enforceCallingPermission("android.permission.REMOVE_TASKS", "removeSubTask()");
            long ident = Binder.clearCallingIdentity();
            try {
                bl = this.mMainStack.removeTaskActivitiesLocked(taskId, subTaskIndex) != null;
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
            return bl;
        }
    }

    private void cleanUpRemovedTaskLocked(ActivityRecord root, boolean killProcesses) {
        TaskRecord tr = root.task;
        Intent baseIntent = new Intent(tr.intent != null ? tr.intent : tr.affinityIntent);
        ComponentName component = baseIntent.getComponent();
        if (component == null) {
            Slog.w((String)TAG, (String)("Now component for base intent of task: " + tr));
            return;
        }
        ArrayList<ServiceRecord> services = new ArrayList<ServiceRecord>();
        for (ServiceRecord sr : this.mServices.values()) {
            if (!sr.packageName.equals(component.getPackageName())) continue;
            services.add(sr);
        }
        for (int i = 0; i < services.size(); ++i) {
            ServiceRecord sr;
            sr = (ServiceRecord)((Object)services.get(i));
            if (!sr.startRequested) continue;
            if ((sr.serviceInfo.flags & 1) != 0) {
                Slog.i((String)TAG, (String)("Stopping service " + sr.shortName + ": remove task"));
                this.stopServiceLocked(sr);
                continue;
            }
            sr.pendingStarts.add(new ServiceRecord.StartItem(sr, true, sr.makeNextStartId(), baseIntent, -1));
            if (sr.app == null || sr.app.thread == null) continue;
            this.sendServiceArgsLocked(sr, false);
        }
        if (killProcesses) {
            int i;
            ArrayList<Object> procs = new ArrayList<Object>();
            SparseArray<ProcessRecord> appProcs = this.mProcessNames.getMap().get(component.getPackageName());
            if (appProcs != null) {
                for (i = 0; i < appProcs.size(); ++i) {
                    procs.add(appProcs.valueAt(i));
                }
            }
            for (i = 0; i < procs.size(); ++i) {
                ProcessRecord pr = (ProcessRecord)procs.get(i);
                if (pr.setSchedGroup == 1) {
                    Slog.i((String)TAG, (String)("Killing " + pr.toShortString() + ": remove task"));
                    EventLog.writeEvent((int)30023, (Object[])new Object[]{pr.pid, pr.processName, pr.setAdj, "remove task"});
                    android.os.Process.killProcessQuiet((int)pr.pid);
                    continue;
                }
                pr.waitingToKill = "remove task";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeTask(int taskId, int flags) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident;
            block9: {
                boolean bl;
                block8: {
                    this.enforceCallingPermission("android.permission.REMOVE_TASKS", "removeTask()");
                    ident = Binder.clearCallingIdentity();
                    try {
                        int i;
                        ActivityRecord r = this.mMainStack.removeTaskActivitiesLocked(taskId, -1);
                        if (r != null) {
                            this.mRecentTasks.remove(r.task);
                            this.cleanUpRemovedTaskLocked(r, (flags & 1) != 0);
                            bl = true;
                            Object var11_8 = null;
                            break block8;
                        }
                        TaskRecord tr = null;
                        for (i = 0; i < this.mRecentTasks.size(); ++i) {
                            TaskRecord t = this.mRecentTasks.get(i);
                            if (t.taskId != taskId) continue;
                            tr = t;
                            break;
                        }
                        if (tr == null) break block9;
                        if (tr.numActivities <= 0) {
                            this.mRecentTasks.remove(i);
                            break block9;
                        } else {
                            Slog.w((String)TAG, (String)("removeTask: task " + taskId + " does not have activities to remove, " + " but numActivities=" + tr.numActivities + ": " + tr));
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var11_10 = null;
                        Binder.restoreCallingIdentity((long)ident);
                        throw throwable;
                    }
                }
                Binder.restoreCallingIdentity((long)ident);
                return bl;
            }
            Object var11_9 = null;
            Binder.restoreCallingIdentity((long)ident);
            return false;
        }
    }

    private final int findAffinityTaskTopLocked(int startIndex, String affinity) {
        int j;
        TaskRecord startTask;
        TaskRecord jt = startTask = this.mMainStack.mHistory.get((int)startIndex).task;
        for (j = startIndex - 1; j >= 0; --j) {
            ActivityRecord r = this.mMainStack.mHistory.get(j);
            if (r.task == jt) continue;
            jt = r.task;
            if (!affinity.equals(jt.affinity)) continue;
            return j;
        }
        int N = this.mMainStack.mHistory.size();
        jt = startTask;
        for (j = startIndex + 1; j < N; ++j) {
            ActivityRecord r = this.mMainStack.mHistory.get(j);
            if (r.task == jt) continue;
            if (affinity.equals(jt.affinity)) {
                return j;
            }
            jt = r.task;
        }
        if (affinity.equals(this.mMainStack.mHistory.get((int)(N - 1)).task.affinity)) {
            return N - 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveTaskToFront(int task, int flags) {
        this.enforceCallingPermission("android.permission.REORDER_TASKS", "moveTaskToFront()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId;
            block13: {
                block12: {
                    block11: {
                        if (!this.checkAppSwitchAllowedLocked(Binder.getCallingPid(), Binder.getCallingUid(), "Task to front")) {
                            return;
                        }
                        origId = Binder.clearCallingIdentity();
                        try {
                            TaskRecord tr = this.taskForIdLocked(task);
                            if (tr != null) {
                                if ((flags & 2) == 0) {
                                    this.mMainStack.mUserLeaving = true;
                                }
                                if ((flags & 1) != 0) {
                                    this.mMainStack.moveHomeToFrontLocked();
                                }
                                this.mMainStack.moveTaskToFrontLocked(tr, null);
                                Object var10_6 = null;
                                break block11;
                            }
                            for (int i = this.mMainStack.mHistory.size() - 1; i >= 0; --i) {
                                ActivityRecord hr = this.mMainStack.mHistory.get(i);
                                if (hr.task.taskId != task) continue;
                                if ((flags & 2) == 0) {
                                    this.mMainStack.mUserLeaving = true;
                                }
                                if ((flags & 1) != 0) {
                                    this.mMainStack.moveHomeToFrontLocked();
                                }
                                this.mMainStack.moveTaskToFrontLocked(hr.task, null);
                                break block12;
                            }
                            break block13;
                        }
                        catch (Throwable throwable) {
                            Object var10_9 = null;
                            Binder.restoreCallingIdentity((long)origId);
                            throw throwable;
                        }
                    }
                    Binder.restoreCallingIdentity((long)origId);
                    return;
                }
                Object var10_7 = null;
                Binder.restoreCallingIdentity((long)origId);
                return;
            }
            Object var10_8 = null;
            Binder.restoreCallingIdentity((long)origId);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTaskToBack(int task) {
        this.enforceCallingPermission("android.permission.REORDER_TASKS", "moveTaskToBack()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mMainStack.mResumedActivity != null && this.mMainStack.mResumedActivity.task.taskId == task && !this.checkAppSwitchAllowedLocked(Binder.getCallingPid(), Binder.getCallingUid(), "Task to back")) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.mMainStack.moveTaskToBackLocked(task, null);
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            int taskId = this.getTaskForActivityLocked(token, !nonRoot);
            if (taskId >= 0) {
                return this.mMainStack.moveTaskToBackLocked(taskId, null);
            }
            Binder.restoreCallingIdentity((long)origId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTaskBackwards(int task) {
        this.enforceCallingPermission("android.permission.REORDER_TASKS", "moveTaskBackwards()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.checkAppSwitchAllowedLocked(Binder.getCallingPid(), Binder.getCallingUid(), "Task backwards")) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.moveTaskBackwardsLocked(task);
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    private final void moveTaskBackwardsLocked(int task) {
        Slog.e((String)TAG, (String)"moveTaskBackwards not yet implemented!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskForActivity(IBinder token, boolean onlyRoot) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.getTaskForActivityLocked(token, onlyRoot);
        }
    }

    int getTaskForActivityLocked(IBinder token, boolean onlyRoot) {
        int N = this.mMainStack.mHistory.size();
        TaskRecord lastTask = null;
        for (int i = 0; i < N; ++i) {
            ActivityRecord r = this.mMainStack.mHistory.get(i);
            if (r.appToken == token) {
                if (!onlyRoot || lastTask != r.task) {
                    return r.task.taskId;
                }
                return -1;
            }
            lastTask = r.task;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishOtherInstances(IBinder token, ComponentName className) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            int N = this.mMainStack.mHistory.size();
            TaskRecord lastTask = null;
            for (int i = 0; i < N; ++i) {
                ActivityRecord r = this.mMainStack.mHistory.get(i);
                if (r.realActivity.equals((Object)className) && r.appToken != token && lastTask != r.task && r.stack.finishActivityLocked(r, i, 0, null, "others")) {
                    --i;
                    --N;
                }
                lastTask = r.task;
            }
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    public void reportThumbnail(IBinder token, Bitmap thumbnail, CharSequence description) {
        long origId = Binder.clearCallingIdentity();
        this.sendPendingThumbnail(null, token, thumbnail, description, true);
        Binder.restoreCallingIdentity((long)origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendPendingThumbnail(ActivityRecord r, IBinder token, Bitmap thumbnail, CharSequence description, boolean always) {
        TaskRecord task = null;
        ArrayList<PendingThumbnailsRecord> receivers = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (r == null && (r = this.mMainStack.isInStackLocked(token)) == null) {
                return;
            }
            if (thumbnail == null && r.thumbHolder != null) {
                thumbnail = r.thumbHolder.lastThumbnail;
                description = r.thumbHolder.lastDescription;
            }
            if (thumbnail == null && !always) {
                return;
            }
            task = r.task;
            int N = this.mPendingThumbnails.size();
            int i = 0;
            while (i < N) {
                PendingThumbnailsRecord pr = (PendingThumbnailsRecord)this.mPendingThumbnails.get(i);
                if (pr.pendingRecords.remove(r)) {
                    if (receivers == null) {
                        receivers = new ArrayList<PendingThumbnailsRecord>();
                    }
                    receivers.add(pr);
                    if (pr.pendingRecords.size() == 0) {
                        pr.finished = true;
                        this.mPendingThumbnails.remove(i);
                        --N;
                        continue;
                    }
                }
                ++i;
            }
        }
        if (receivers != null) {
            int N = receivers.size();
            for (int i = 0; i < N; ++i) {
                try {
                    PendingThumbnailsRecord pr = (PendingThumbnailsRecord)receivers.get(i);
                    pr.receiver.newThumbnail(task != null ? task.taskId : -1, thumbnail, description);
                    if (!pr.finished) continue;
                    pr.receiver.finished();
                    continue;
                }
                catch (Exception e) {
                    Slog.w((String)TAG, (String)"Exception thrown when sending thumbnail", (Throwable)e);
                }
            }
        }
    }

    private final List<ProviderInfo> generateApplicationProvidersLocked(ProcessRecord app) {
        List providers = null;
        try {
            providers = AppGlobals.getPackageManager().queryContentProviders(app.processName, app.info.uid, 3072);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        if (providers != null) {
            int N = providers.size();
            for (int i = 0; i < N; ++i) {
                ProviderInfo cpi = (ProviderInfo)providers.get(i);
                ComponentName comp = new ComponentName(cpi.packageName, cpi.name);
                ContentProviderRecord cpr = this.mProvidersByClass.get(comp);
                if (cpr == null) {
                    cpr = new ContentProviderRecord(cpi, app.info, comp);
                    this.mProvidersByClass.put(comp, cpr);
                }
                app.pubProviders.put(cpi.name, cpr);
                app.addPackage(cpi.applicationInfo.packageName);
                this.ensurePackageDexOpt(cpi.applicationInfo.packageName);
            }
        }
        return providers;
    }

    private final String checkContentProviderPermissionLocked(ProviderInfo cpi, ProcessRecord r) {
        HashMap perms;
        int callingUid;
        int callingPid = r != null ? r.pid : Binder.getCallingPid();
        int n = callingUid = r != null ? r.info.uid : Binder.getCallingUid();
        if (this.checkComponentPermission(cpi.readPermission, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
            return null;
        }
        if (this.checkComponentPermission(cpi.writePermission, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
            return null;
        }
        PathPermission[] pps = cpi.pathPermissions;
        if (pps != null) {
            int i = pps.length;
            while (i > 0) {
                PathPermission pp;
                if (this.checkComponentPermission((pp = pps[--i]).getReadPermission(), callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
                    return null;
                }
                if (this.checkComponentPermission(pp.getWritePermission(), callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) != 0) continue;
                return null;
            }
        }
        if ((perms = (HashMap)this.mGrantedUriPermissions.get(callingUid)) != null) {
            for (Map.Entry uri : perms.entrySet()) {
                if (!((Uri)uri.getKey()).getAuthority().equals(cpi.authority)) continue;
                return null;
            }
        }
        String msg = !cpi.exported ? "Permission Denial: opening provider " + cpi.name + " from " + (r != null ? r : "(null)") + " (pid=" + callingPid + ", uid=" + callingUid + ") that is not exported from uid " + cpi.applicationInfo.uid : "Permission Denial: opening provider " + cpi.name + " from " + (r != null ? r : "(null)") + " (pid=" + callingPid + ", uid=" + callingUid + ") requires " + cpi.readPermission + " or " + cpi.writePermission;
        Slog.w((String)TAG, (String)msg);
        return msg;
    }

    boolean incProviderCount(ProcessRecord r, ContentProviderRecord cpr) {
        if (r != null) {
            Integer cnt = r.conProviders.get((Object)cpr);
            if (cnt == null) {
                cpr.clients.add(r);
                r.conProviders.put(cpr, new Integer(1));
                return true;
            }
            r.conProviders.put(cpr, new Integer(cnt + 1));
        } else {
            ++cpr.externals;
        }
        return false;
    }

    boolean decProviderCount(ProcessRecord r, ContentProviderRecord cpr) {
        if (r != null) {
            Integer cnt = r.conProviders.get((Object)cpr);
            if (cnt == null || cnt <= 1) {
                cpr.clients.remove(r);
                r.conProviders.remove((Object)cpr);
                return true;
            }
            r.conProviders.put(cpr, new Integer(cnt - 1));
        } else {
            ++cpr.externals;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final IActivityManager.ContentProviderHolder getContentProviderImpl(IApplicationThread caller, String name) {
        ContentProviderRecord cpr;
        ProviderInfo cpi = null;
        Object object = this;
        synchronized (object) {
            String msg;
            boolean providerRunning;
            ProcessRecord r = null;
            if (caller != null && (r = this.getRecordForAppLocked(caller)) == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when getting content provider " + name);
            }
            cpr = this.mProvidersByName.get(name);
            boolean bl = providerRunning = cpr != null;
            if (providerRunning) {
                boolean success;
                cpi = cpr.info;
                msg = this.checkContentProviderPermissionLocked(cpi, r);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                if (r != null && cpr.canRunHere(r)) {
                    if (cpr.provider == null) return cpr;
                    return new ContentProviderRecord(cpr);
                }
                long origId = Binder.clearCallingIdentity();
                boolean countChanged = this.incProviderCount(r, cpr);
                if (countChanged && cpr.proc != null && r.setAdj <= 2) {
                    this.updateLruProcessLocked(cpr.proc, false, true);
                }
                if (cpr.proc != null && !(success = this.updateOomAdjLocked(cpr.proc))) {
                    Slog.i((String)TAG, (String)("Existing provider " + cpr.name.flattenToShortString() + " is crashing; detaching " + r));
                    boolean lastRef = this.decProviderCount(r, cpr);
                    this.appDiedLocked(cpr.proc, cpr.proc.pid, cpr.proc.thread);
                    if (!lastRef) {
                        return null;
                    }
                    providerRunning = false;
                }
                Binder.restoreCallingIdentity((long)origId);
            }
            if (!providerRunning) {
                int i;
                boolean firstClass;
                try {
                    cpi = AppGlobals.getPackageManager().resolveContentProvider(name, 3072);
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
                if (cpi == null) {
                    return null;
                }
                msg = this.checkContentProviderPermissionLocked(cpi, r);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                if (!(this.mProcessesReady || this.mDidUpdate || this.mWaitingUpdate || cpi.processName.equals("system"))) {
                    throw new IllegalArgumentException("Attempt to launch content provider before system ready");
                }
                ComponentName comp = new ComponentName(cpi.packageName, cpi.name);
                cpr = this.mProvidersByClass.get(comp);
                boolean bl2 = firstClass = cpr == null;
                if (firstClass) {
                    try {
                        ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(cpi.applicationInfo.packageName, 1024);
                        if (ai == null) {
                            Slog.w((String)TAG, (String)("No package info for content provider " + cpi.name));
                            return null;
                        }
                        cpr = new ContentProviderRecord(cpi, ai, comp);
                    }
                    catch (RemoteException ex) {
                        // empty catch block
                    }
                }
                if (r != null && cpr.canRunHere(r)) {
                    return cpr;
                }
                int N = this.mLaunchingProviders.size();
                for (i = 0; i < N && this.mLaunchingProviders.get(i) != cpr; ++i) {
                }
                if (i >= N) {
                    long origId;
                    block36: {
                        IActivityManager.ContentProviderHolder contentProviderHolder;
                        block35: {
                            origId = Binder.clearCallingIdentity();
                            try {
                                try {
                                    AppGlobals.getPackageManager().setPackageStoppedState(cpr.appInfo.packageName, false);
                                }
                                catch (RemoteException e) {
                                }
                                catch (IllegalArgumentException e) {
                                    Slog.w((String)TAG, (String)("Failed trying to unstop package " + cpr.appInfo.packageName + ": " + e));
                                }
                                ProcessRecord proc = this.startProcessLocked(cpi.processName, cpr.appInfo, false, 0, "content provider", new ComponentName(cpi.applicationInfo.packageName, cpi.name), false);
                                if (proc == null) {
                                    Slog.w((String)TAG, (String)("Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": process is bad"));
                                    contentProviderHolder = null;
                                    Object var18_24 = null;
                                    break block35;
                                }
                                cpr.launchingApp = proc;
                                this.mLaunchingProviders.add(cpr);
                                break block36;
                            }
                            catch (Throwable throwable) {
                                Object var18_26 = null;
                                Binder.restoreCallingIdentity((long)origId);
                                throw throwable;
                            }
                        }
                        Binder.restoreCallingIdentity((long)origId);
                        return contentProviderHolder;
                    }
                    Object var18_25 = null;
                    Binder.restoreCallingIdentity((long)origId);
                }
                if (firstClass) {
                    this.mProvidersByClass.put(comp, cpr);
                }
                this.mProvidersByName.put(name, cpr);
                this.incProviderCount(r, cpr);
            }
        }
        object = cpr;
        synchronized (object) {
            while (cpr.provider == null) {
                if (cpr.launchingApp == null) {
                    Slog.w((String)TAG, (String)("Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": launching app became null"));
                    EventLog.writeEvent((int)30036, (Object[])new Object[]{cpi.applicationInfo.packageName, cpi.applicationInfo.uid, name});
                    return null;
                }
                try {
                    ((Object)((Object)cpr)).wait();
                }
                catch (InterruptedException ex) {}
            }
            return cpr;
        }
    }

    public final IActivityManager.ContentProviderHolder getContentProvider(IApplicationThread caller, String name) {
        if (caller == null) {
            String msg = "null IApplicationThread when getting content provider " + name;
            Slog.w((String)TAG, (String)msg);
            throw new SecurityException(msg);
        }
        return this.getContentProviderImpl(caller, name);
    }

    private IActivityManager.ContentProviderHolder getContentProviderExternal(String name) {
        return this.getContentProviderImpl(null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContentProvider(IApplicationThread caller, String name) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ContentProviderRecord cpr = this.mProvidersByName.get(name);
            if (cpr == null) {
                return;
            }
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " when removing content provider " + name);
            }
            ComponentName comp = new ComponentName(cpr.info.packageName, cpr.info.name);
            ContentProviderRecord localCpr = this.mProvidersByClass.get(comp);
            if (localCpr.proc == r) {
                Slog.w((String)TAG, (String)("removeContentProvider called on local provider: " + cpr.info.name + " in process " + r.processName));
                return;
            }
            if (this.decProviderCount(r, localCpr)) {
                this.updateOomAdjLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContentProviderExternal(String name) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ContentProviderRecord cpr = this.mProvidersByName.get(name);
            if (cpr == null) {
                return;
            }
            ComponentName comp = new ComponentName(cpr.info.packageName, cpr.info.name);
            ContentProviderRecord localCpr = this.mProvidersByClass.get(comp);
            --localCpr.externals;
            if (localCpr.externals < 0) {
                Slog.e((String)TAG, (String)("Externals < 0 for content provider " + (Object)((Object)localCpr)));
            }
            this.updateOomAdjLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void publishContentProviders(IApplicationThread caller, List<IActivityManager.ContentProviderHolder> providers) {
        if (providers == null) {
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when publishing content providers");
            }
            long origId = Binder.clearCallingIdentity();
            int N = providers.size();
            for (int i = 0; i < N; ++i) {
                ContentProviderRecord dst;
                IActivityManager.ContentProviderHolder src = providers.get(i);
                if (src == null || src.info == null || src.provider == null || (dst = r.pubProviders.get(src.info.name)) == null) continue;
                ComponentName comp = new ComponentName(dst.info.packageName, dst.info.name);
                this.mProvidersByClass.put(comp, dst);
                String[] names = dst.info.authority.split(";");
                for (int j = 0; j < names.length; ++j) {
                    this.mProvidersByName.put(names[j], dst);
                }
                int NL = this.mLaunchingProviders.size();
                for (int j = 0; j < NL; ++j) {
                    if (this.mLaunchingProviders.get(j) != dst) continue;
                    this.mLaunchingProviders.remove(j);
                    --j;
                    --NL;
                }
                ContentProviderRecord contentProviderRecord = dst;
                synchronized (contentProviderRecord) {
                    dst.provider = src.provider;
                    dst.proc = r;
                    ((Object)((Object)dst)).notifyAll();
                }
                this.updateOomAdjLocked(r);
            }
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void installSystemProviders() {
        List<ProviderInfo> providers;
        ActivityManagerService activityManagerService = mSelf;
        synchronized (activityManagerService) {
            ProcessRecord app = ActivityManagerService.mSelf.mProcessNames.get("system", 1000);
            providers = mSelf.generateApplicationProvidersLocked(app);
            if (providers != null) {
                for (int i = providers.size() - 1; i >= 0; --i) {
                    ProviderInfo pi = providers.get(i);
                    if ((pi.applicationInfo.flags & 1) != 0) continue;
                    Slog.w((String)TAG, (String)("Not installing system proc provider " + pi.name + ": not system .apk"));
                    providers.remove(i);
                }
            }
        }
        if (providers != null) {
            mSystemThread.installSystemProviders(providers);
        }
        ActivityManagerService.mSelf.mCoreSettingsObserver = new CoreSettingsObserver(mSelf);
        ActivityManagerService.mSelf.mUsageStatsService.monitorPackages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getProviderMimeType(Uri uri) {
        IActivityManager.ContentProviderHolder holder;
        long ident;
        String name;
        block10: {
            String string;
            name = uri.getAuthority();
            ident = Binder.clearCallingIdentity();
            holder = null;
            try {
                try {
                    holder = this.getContentProviderExternal(name);
                    if (holder == null) break block10;
                    string = holder.provider.getType(uri);
                    Object var9_7 = null;
                    if (holder != null) {
                        this.removeContentProviderExternal(name);
                    }
                }
                catch (RemoteException e) {
                    Log.w((String)TAG, (String)("Content provider dead retrieving " + uri), (Throwable)e);
                    String string2 = null;
                    Object var9_9 = null;
                    if (holder != null) {
                        this.removeContentProviderExternal(name);
                    }
                    Binder.restoreCallingIdentity((long)ident);
                    return string2;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (holder != null) {
                    this.removeContentProviderExternal(name);
                }
                Binder.restoreCallingIdentity((long)ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity((long)ident);
            return string;
        }
        Object var9_8 = null;
        if (holder != null) {
            this.removeContentProviderExternal(name);
        }
        Binder.restoreCallingIdentity((long)ident);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ProcessRecord newProcessRecordLocked(IApplicationThread thread, ApplicationInfo info, String customProcess) {
        BatteryStatsImpl stats;
        String proc = customProcess != null ? customProcess : info.processName;
        BatteryStatsImpl.Uid.Proc ps = null;
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            ps = stats.getProcessStatsLocked(info.uid, proc);
        }
        return new ProcessRecord(ps, thread, info, proc);
    }

    final ProcessRecord addAppLocked(ApplicationInfo info) {
        ProcessRecord app = this.getProcessRecordLocked(info.processName, info.uid);
        if (app == null) {
            app = this.newProcessRecordLocked(null, info, null);
            this.mProcessNames.put(info.processName, info.uid, app);
            this.updateLruProcessLocked(app, true, true);
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(info.packageName, false);
        }
        catch (RemoteException e) {
        }
        catch (IllegalArgumentException e) {
            Slog.w((String)TAG, (String)("Failed trying to unstop package " + info.packageName + ": " + e));
        }
        if ((info.flags & 9) == 9) {
            app.persistent = true;
            app.maxAdj = -12;
        }
        if (app.thread == null && this.mPersistentStartingProcesses.indexOf(app) < 0) {
            this.mPersistentStartingProcesses.add(app);
            this.startProcessLocked(app, "added application", app.processName);
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unhandledBack() {
        this.enforceCallingPermission("android.permission.FORCE_BACK", "unhandledBack()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int count = this.mMainStack.mHistory.size();
            if (count > 1) {
                long origId = Binder.clearCallingIdentity();
                this.mMainStack.finishActivityLocked(this.mMainStack.mHistory.get(count - 1), count - 1, 0, null, "unhandled-back");
                Binder.restoreCallingIdentity((long)origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor openContentUri(Uri uri) throws RemoteException {
        String name = uri.getAuthority();
        IActivityManager.ContentProviderHolder cph = this.getContentProviderExternal(name);
        ParcelFileDescriptor pfd = null;
        if (cph != null) {
            sCallerIdentity.set(new Identity(Binder.getCallingPid(), Binder.getCallingUid()));
            try {
                try {
                    pfd = cph.provider.openFile(uri, "r");
                }
                catch (FileNotFoundException e) {
                    Object var7_6 = null;
                    sCallerIdentity.remove();
                }
                Object var7_5 = null;
                sCallerIdentity.remove();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                sCallerIdentity.remove();
                throw throwable;
            }
            this.removeContentProviderExternal(name);
        } else {
            Slog.d((String)TAG, (String)("Failed to get provider for authority '" + name + "'"));
        }
        return pfd;
    }

    public boolean isSleeping() {
        return this.mSleeping || this.mShuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goingToSleep() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mSleeping = true;
            this.mWindowManager.setEventDispatching(false);
            this.mMainStack.stopIfSleepingLocked();
            this.checkExcessivePowerUsageLocked(false);
            this.mHandler.removeMessages(27);
            Message nmsg = this.mHandler.obtainMessage(27);
            this.mHandler.sendMessageDelayed(nmsg, 900000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(int timeout) {
        if (this.checkCallingPermission("android.permission.SHUTDOWN") != 0) {
            throw new SecurityException("Requires permission android.permission.SHUTDOWN");
        }
        boolean timedout = false;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mShuttingDown = true;
            this.mWindowManager.setEventDispatching(false);
            if (this.mMainStack.mResumedActivity != null) {
                this.mMainStack.stopIfSleepingLocked();
                long endTime = System.currentTimeMillis() + (long)timeout;
                while (this.mMainStack.mResumedActivity != null || this.mMainStack.mPausingActivity != null) {
                    long delay = endTime - System.currentTimeMillis();
                    if (delay <= 0L) {
                        Slog.w((String)TAG, (String)"Activity manager shutdown timed out");
                        timedout = true;
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        this.mUsageStatsService.shutdown();
        this.mBatteryStatsService.shutdown();
        return timedout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activitySlept(IBinder token) {
        ActivityRecord r = null;
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            r = this.mMainStack.isInStackLocked(token);
            if (r != null) {
                this.mMainStack.activitySleptLocked(r);
            }
        }
        Binder.restoreCallingIdentity((long)origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakingUp() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mWindowManager.setEventDispatching(true);
            this.mSleeping = false;
            this.mMainStack.awakeFromSleepingLocked();
            this.mMainStack.resumeTopActivityLocked(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAppSwitches() {
        if (this.checkCallingPermission("android.permission.STOP_APP_SWITCHES") != 0) {
            throw new SecurityException("Requires permission android.permission.STOP_APP_SWITCHES");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAppSwitchesAllowedTime = SystemClock.uptimeMillis() + 5000L;
            this.mDidAppSwitch = false;
            this.mHandler.removeMessages(21);
            Message msg = this.mHandler.obtainMessage(21);
            this.mHandler.sendMessageDelayed(msg, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAppSwitches() {
        if (this.checkCallingPermission("android.permission.STOP_APP_SWITCHES") != 0) {
            throw new SecurityException("Requires permission android.permission.STOP_APP_SWITCHES");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAppSwitchesAllowedTime = 0L;
        }
    }

    boolean checkAppSwitchAllowedLocked(int callingPid, int callingUid, String name) {
        if (this.mAppSwitchesAllowedTime < SystemClock.uptimeMillis()) {
            return true;
        }
        int perm = this.checkComponentPermission("android.permission.STOP_APP_SWITCHES", callingPid, callingUid, -1, true);
        if (perm == 0) {
            return true;
        }
        Slog.w((String)TAG, (String)(name + " request from " + callingUid + " stopped"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDebugApp(String packageName, boolean waitForDebugger, boolean persistent) {
        this.enforceCallingPermission("android.permission.SET_DEBUG_APP", "setDebugApp()");
        if (persistent) {
            ContentResolver resolver = this.mContext.getContentResolver();
            Settings.System.putString((ContentResolver)resolver, (String)"debug_app", (String)packageName);
            Settings.System.putInt((ContentResolver)resolver, (String)"wait_for_debugger", (int)(waitForDebugger ? 1 : 0));
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!persistent) {
                this.mOrigDebugApp = this.mDebugApp;
                this.mOrigWaitForDebugger = this.mWaitForDebugger;
            }
            this.mDebugApp = packageName;
            this.mWaitForDebugger = waitForDebugger;
            boolean bl = this.mDebugTransient = !persistent;
            if (packageName != null) {
                long origId = Binder.clearCallingIdentity();
                this.forceStopPackageLocked(packageName, -1, false, false, true, true);
                Binder.restoreCallingIdentity((long)origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProfileApp(ApplicationInfo app, String processName, String profileFile, ParcelFileDescriptor profileFd, boolean autoStopProfiler) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean isDebuggable = "1".equals(SystemProperties.get((String)SYSTEM_DEBUGGABLE, (String)"0"));
            if (!isDebuggable && (app.flags & 2) == 0) {
                throw new SecurityException("Process not debuggable: " + app.packageName);
            }
            this.mProfileApp = processName;
            this.mProfileFile = profileFile;
            if (this.mProfileFd != null) {
                try {
                    this.mProfileFd.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.mProfileFd = null;
            }
            this.mProfileFd = profileFd;
            this.mProfileType = 0;
            this.mAutoStopProfiler = autoStopProfiler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlwaysFinish(boolean enabled) {
        this.enforceCallingPermission("android.permission.SET_ALWAYS_FINISH", "setAlwaysFinish()");
        Settings.System.putInt((ContentResolver)this.mContext.getContentResolver(), (String)"always_finish_activities", (int)(enabled ? 1 : 0));
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAlwaysFinishActivities = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivityController(IActivityController controller) {
        this.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "setActivityController()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mController = controller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserAMonkey() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mController != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActivityWatcher(IActivityWatcher watcher) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mWatchers.register((IInterface)watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterActivityWatcher(IActivityWatcher watcher) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mWatchers.unregister((IInterface)watcher);
        }
    }

    public void registerProcessObserver(IProcessObserver observer) {
        this.mProcessObservers.register((IInterface)observer);
    }

    public void unregisterProcessObserver(IProcessObserver observer) {
        this.mProcessObservers.unregister((IInterface)observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImmersive(IBinder token, boolean immersive) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mMainStack.isInStackLocked(token);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            r.immersive = immersive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImmersive(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mMainStack.isInStackLocked(token);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            return r.immersive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTopActivityImmersive() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mMainStack.topRunningActivityLocked(null);
            return r != null ? r.immersive : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterSafeMode() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.mSystemReady) {
                try {
                    AppGlobals.getPackageManager().enterSafeMode();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    public final void showSafeModeOverlay() {
        View v = LayoutInflater.from((Context)this.mContext).inflate(17367168, null);
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.type = 2015;
        lp.width = -2;
        lp.height = -2;
        lp.gravity = 83;
        lp.format = v.getBackground().getOpacity();
        lp.flags = 24;
        ((WindowManager)this.mContext.getSystemService("window")).addView(v, (ViewGroup.LayoutParams)lp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWakeupAlarm(IIntentSender sender) {
        BatteryStatsImpl stats;
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            if (this.mBatteryStatsService.isOnBattery()) {
                this.mBatteryStatsService.enforceCallingPermission();
                PendingIntentRecord rec = (PendingIntentRecord)sender;
                int MY_UID = Binder.getCallingUid();
                int uid = rec.uid == MY_UID ? 1000 : rec.uid;
                BatteryStatsImpl.Uid.Pkg pkg = stats.getPackageStatsLocked(uid, rec.key.packageName);
                pkg.incWakeupsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean killPids(int[] pids, String pReason, boolean secure) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killPids only available to the system");
        }
        String reason = pReason == null ? "Unknown" : pReason;
        boolean killed = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            ProcessRecord proc;
            int i;
            int[] types = new int[pids.length];
            int worstType = 0;
            for (i = 0; i < pids.length; ++i) {
                int type;
                proc = (ProcessRecord)this.mPidsSelfLocked.get(pids[i]);
                if (proc == null) continue;
                types[i] = type = proc.setAdj;
                if (type <= worstType) continue;
                worstType = type;
            }
            if (worstType < 15 && worstType > ProcessList.HIDDEN_APP_MIN_ADJ) {
                worstType = ProcessList.HIDDEN_APP_MIN_ADJ;
            }
            if (!secure && worstType < 5) {
                worstType = 5;
            }
            Slog.w((String)TAG, (String)("Killing processes " + reason + " at adjustment " + worstType));
            for (i = 0; i < pids.length; ++i) {
                int adj;
                proc = (ProcessRecord)this.mPidsSelfLocked.get(pids[i]);
                if (proc == null || (adj = proc.setAdj) < worstType || proc.killedBackground) continue;
                Slog.w((String)TAG, (String)("Killing " + proc + " (adj " + adj + "): " + reason));
                EventLog.writeEvent((int)30023, (Object[])new Object[]{proc.pid, proc.processName, adj, reason});
                killed = true;
                proc.killedBackground = true;
                android.os.Process.killProcessQuiet((int)pids[i]);
            }
        }
        return killed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startRunning(String pkg, String cls, String action, String data) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mStartRunning) {
                return;
            }
            this.mStartRunning = true;
            this.mTopComponent = pkg != null && cls != null ? new ComponentName(pkg, cls) : null;
            this.mTopAction = action != null ? action : "android.intent.action.MAIN";
            this.mTopData = data;
            if (!this.mSystemReady) {
                return;
            }
        }
        this.systemReady(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveSettings() {
        ContentResolver resolver = this.mContext.getContentResolver();
        String debugApp = Settings.System.getString((ContentResolver)resolver, (String)"debug_app");
        boolean waitForDebugger = Settings.System.getInt((ContentResolver)resolver, (String)"wait_for_debugger", (int)0) != 0;
        boolean alwaysFinishActivities = Settings.System.getInt((ContentResolver)resolver, (String)"always_finish_activities", (int)0) != 0;
        Configuration configuration = new Configuration();
        Settings.System.getConfiguration((ContentResolver)resolver, (Configuration)configuration);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mDebugApp = this.mOrigDebugApp = debugApp;
            this.mWaitForDebugger = this.mOrigWaitForDebugger = waitForDebugger;
            this.mAlwaysFinishActivities = alwaysFinishActivities;
            this.updateConfigurationLocked(configuration, null, false, true);
        }
    }

    public boolean testIsSystemReady() {
        return this.mSystemReady;
    }

    private static File getCalledPreBootReceiversFile() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File fname = new File(systemDir, "called_pre_boots.dat");
        return fname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList<ComponentName> readLastDonePreBootReceivers() {
        ArrayList<ComponentName> lastDoneReceivers = new ArrayList<ComponentName>();
        File file = ActivityManagerService.getCalledPreBootReceiversFile();
        FileInputStream fis = null;
        fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(fis, 2048));
        int fvers = dis.readInt();
        if (fvers == 10000) {
            String vers = dis.readUTF();
            String codename = dis.readUTF();
            String build = dis.readUTF();
            if (Build.VERSION.RELEASE.equals(vers) && Build.VERSION.CODENAME.equals(codename) && Build.VERSION.INCREMENTAL.equals(build)) {
                for (int num = dis.readInt(); num > 0; --num) {
                    String pkg = dis.readUTF();
                    String cls = dis.readUTF();
                    lastDoneReceivers.add(new ComponentName(pkg, cls));
                }
            }
        }
        Object var12_13 = null;
        if (fis == null) return lastDoneReceivers;
        try {
            fis.close();
            return lastDoneReceivers;
        }
        catch (IOException e2) {}
        return lastDoneReceivers;
        {
            catch (FileNotFoundException e) {
                Object var12_14 = null;
                if (fis == null) return lastDoneReceivers;
                try {
                    fis.close();
                    return lastDoneReceivers;
                }
                catch (IOException e2) {}
                return lastDoneReceivers;
            }
            catch (IOException e) {
                Slog.w((String)TAG, (String)"Failure reading last done pre-boot receivers", (Throwable)e);
                Object var12_15 = null;
                if (fis == null) return lastDoneReceivers;
                try {
                    fis.close();
                    return lastDoneReceivers;
                }
                catch (IOException e2) {}
                return lastDoneReceivers;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void writeLastDonePreBootReceivers(ArrayList<ComponentName> list) {
        block12: {
            File file = ActivityManagerService.getCalledPreBootReceiversFile();
            FileOutputStream fos = null;
            FilterOutputStream dos = null;
            try {
                Slog.i((String)TAG, (String)"Writing new set of last done pre-boot receivers...");
                fos = new FileOutputStream(file);
                dos = new DataOutputStream(new BufferedOutputStream(fos, 2048));
                ((DataOutputStream)dos).writeInt(10000);
                ((DataOutputStream)dos).writeUTF(Build.VERSION.RELEASE);
                ((DataOutputStream)dos).writeUTF(Build.VERSION.CODENAME);
                ((DataOutputStream)dos).writeUTF(Build.VERSION.INCREMENTAL);
                ((DataOutputStream)dos).writeInt(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    ((DataOutputStream)dos).writeUTF(list.get(i).getPackageName());
                    ((DataOutputStream)dos).writeUTF(list.get(i).getClassName());
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                FileUtils.sync(fos);
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                throw throwable;
            }
            FileUtils.sync((FileOutputStream)fos);
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            break block12;
            {
                catch (IOException e) {
                    Slog.w((String)TAG, (String)"Failure writing last done pre-boot receivers", (Throwable)e);
                    file.delete();
                    Object var6_7 = null;
                    FileUtils.sync((FileOutputStream)fos);
                    if (dos != null) {
                        try {
                            dos.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(final Runnable goingCallback) {
        ProcessRecord proc;
        int i;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mSystemReady) {
                if (goingCallback != null) {
                    goingCallback.run();
                }
                return;
            }
            if (!this.mDidUpdate) {
                if (this.mWaitingUpdate) {
                    return;
                }
                Intent intent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
                List ris = null;
                try {
                    ris = AppGlobals.getPackageManager().queryIntentReceivers(intent, null, 0);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                if (ris != null) {
                    ComponentName comp;
                    ActivityInfo ai;
                    int i2;
                    for (int i3 = ris.size() - 1; i3 >= 0; --i3) {
                        if ((((ResolveInfo)ris.get((int)i3)).activityInfo.applicationInfo.flags & 1) != 0) continue;
                        ris.remove(i3);
                    }
                    intent.addFlags(0x8000000);
                    ArrayList<ComponentName> lastDoneReceivers = ActivityManagerService.readLastDonePreBootReceivers();
                    final ArrayList<ComponentName> doneReceivers = new ArrayList<ComponentName>();
                    for (i2 = 0; i2 < ris.size(); ++i2) {
                        ai = ((ResolveInfo)ris.get((int)i2)).activityInfo;
                        comp = new ComponentName(ai.packageName, ai.name);
                        if (!lastDoneReceivers.contains(comp)) continue;
                        ris.remove(i2);
                        --i2;
                    }
                    for (i2 = 0; i2 < ris.size(); ++i2) {
                        ai = ((ResolveInfo)ris.get((int)i2)).activityInfo;
                        comp = new ComponentName(ai.packageName, ai.name);
                        doneReceivers.add(comp);
                        intent.setComponent(comp);
                        IIntentReceiver.Stub finisher = null;
                        if (i2 == ris.size() - 1) {
                            finisher = new IIntentReceiver.Stub(){

                                public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky) {
                                    ActivityManagerService.this.mHandler.post(new Runnable(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void run() {
                                            ActivityManagerService activityManagerService = ActivityManagerService.this;
                                            synchronized (activityManagerService) {
                                                ActivityManagerService.this.mDidUpdate = true;
                                            }
                                            ActivityManagerService.writeLastDonePreBootReceivers(doneReceivers);
                                            ActivityManagerService.this.showBootMessage(ActivityManagerService.this.mContext.getText(17040315), false);
                                            ActivityManagerService.this.systemReady(goingCallback);
                                        }
                                    });
                                }
                            };
                        }
                        Slog.i((String)TAG, (String)("Sending system update to: " + intent.getComponent()));
                        this.broadcastIntentLocked(null, null, intent, null, (IIntentReceiver)finisher, 0, null, null, null, true, false, MY_PID, 1000);
                        if (finisher == null) continue;
                        this.mWaitingUpdate = true;
                    }
                }
                if (this.mWaitingUpdate) {
                    return;
                }
                this.mDidUpdate = true;
            }
            this.mSystemReady = true;
            if (!this.mStartRunning) {
                return;
            }
        }
        ArrayList<ProcessRecord> procsToKill = null;
        Object object = this.mPidsSelfLocked;
        synchronized (object) {
            for (i = this.mPidsSelfLocked.size() - 1; i >= 0; --i) {
                proc = (ProcessRecord)this.mPidsSelfLocked.valueAt(i);
                if (this.isAllowedWhileBooting(proc.info)) continue;
                if (procsToKill == null) {
                    procsToKill = new ArrayList<ProcessRecord>();
                }
                procsToKill.add(proc);
            }
        }
        object = this;
        synchronized (object) {
            if (procsToKill != null) {
                for (i = procsToKill.size() - 1; i >= 0; --i) {
                    proc = (ProcessRecord)procsToKill.get(i);
                    Slog.i((String)TAG, (String)("Removing system update proc: " + proc));
                    this.removeProcessLocked(proc, true, false, "system update done");
                }
            }
            this.mProcessesReady = true;
        }
        Slog.i((String)TAG, (String)"System now ready");
        EventLog.writeEvent((int)3040, (long)SystemClock.uptimeMillis());
        object = this;
        synchronized (object) {
            if (this.mFactoryTest == 1) {
                ResolveInfo ri = this.mContext.getPackageManager().resolveActivity(new Intent("android.intent.action.FACTORY_TEST"), 1024);
                CharSequence errorMsg = null;
                if (ri != null) {
                    ActivityInfo ai = ri.activityInfo;
                    ApplicationInfo app = ai.applicationInfo;
                    if ((app.flags & 1) != 0) {
                        this.mTopAction = "android.intent.action.FACTORY_TEST";
                        this.mTopData = null;
                        this.mTopComponent = new ComponentName(app.packageName, ai.name);
                    } else {
                        errorMsg = this.mContext.getResources().getText(17040150);
                    }
                } else {
                    errorMsg = this.mContext.getResources().getText(17040151);
                }
                if (errorMsg != null) {
                    this.mTopAction = null;
                    this.mTopData = null;
                    this.mTopComponent = null;
                    Message msg = Message.obtain();
                    msg.what = 3;
                    msg.getData().putCharSequence("msg", errorMsg);
                    this.mHandler.sendMessage(msg);
                }
            }
        }
        this.retrieveSettings();
        if (goingCallback != null) {
            goingCallback.run();
        }
        object = this;
        synchronized (object) {
            if (this.mFactoryTest != 1) {
                try {
                    List apps = AppGlobals.getPackageManager().getPersistentApplications(1024);
                    if (apps != null) {
                        int N = apps.size();
                        for (int i4 = 0; i4 < N; ++i4) {
                            ApplicationInfo info = (ApplicationInfo)apps.get(i4);
                            if (info == null || info.packageName.equals("android")) continue;
                            this.addAppLocked(info);
                        }
                    }
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
            this.mBooting = true;
            try {
                if (AppGlobals.getPackageManager().hasSystemUidErrors()) {
                    Message msg = Message.obtain();
                    msg.what = 14;
                    this.mHandler.sendMessage(msg);
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            this.mMainStack.resumeTopActivityLocked(null);
        }
    }

    private boolean makeAppCrashingLocked(ProcessRecord app, String shortMsg, String longMsg, String stackTrace) {
        app.crashing = true;
        app.crashingReport = this.generateProcessError(app, 1, null, shortMsg, longMsg, stackTrace);
        this.startAppProblemLocked(app);
        app.stopFreezingAllLocked();
        return this.handleAppCrashLocked(app);
    }

    private void makeAppNotRespondingLocked(ProcessRecord app, String activity, String shortMsg, String longMsg) {
        app.notResponding = true;
        app.notRespondingReport = this.generateProcessError(app, 2, activity, shortMsg, longMsg, null);
        this.startAppProblemLocked(app);
        app.stopFreezingAllLocked();
    }

    private ActivityManager.ProcessErrorStateInfo generateProcessError(ProcessRecord app, int condition, String activity, String shortMsg, String longMsg, String stackTrace) {
        ActivityManager.ProcessErrorStateInfo report = new ActivityManager.ProcessErrorStateInfo();
        report.condition = condition;
        report.processName = app.processName;
        report.pid = app.pid;
        report.uid = app.info.uid;
        report.tag = activity;
        report.shortMsg = shortMsg;
        report.longMsg = longMsg;
        report.stackTrace = stackTrace;
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void killAppAtUsersRequest(ProcessRecord app, Dialog fromDialog) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            app.crashing = false;
            app.crashingReport = null;
            app.notResponding = false;
            app.notRespondingReport = null;
            if (app.anrDialog == fromDialog) {
                app.anrDialog = null;
            }
            if (app.waitDialog == fromDialog) {
                app.waitDialog = null;
            }
            if (app.pid > 0 && app.pid != MY_PID) {
                this.handleAppCrashLocked(app);
                Slog.i((String)TAG, (String)("Killing " + app + ": user's request"));
                EventLog.writeEvent((int)30023, (Object[])new Object[]{app.pid, app.processName, app.setAdj, "user's request after error"});
                android.os.Process.killProcessQuiet((int)app.pid);
            }
        }
    }

    private boolean handleAppCrashLocked(ProcessRecord app) {
        long now = SystemClock.uptimeMillis();
        Long crashTime = this.mProcessCrashTimes.get(app.info.processName, app.info.uid);
        if (crashTime != null && now < crashTime + 60000L) {
            Slog.w((String)TAG, (String)("Process " + app.info.processName + " has crashed too many times: killing!"));
            EventLog.writeEvent((int)30032, (Object[])new Object[]{app.info.processName, app.info.uid});
            for (int i = this.mMainStack.mHistory.size() - 1; i >= 0; --i) {
                ActivityRecord r = this.mMainStack.mHistory.get(i);
                if (r.app != app) continue;
                Slog.w((String)TAG, (String)("  Force finishing activity " + r.intent.getComponent().flattenToShortString()));
                r.stack.finishActivityLocked(r, i, 0, null, "crashed");
            }
            if (!app.persistent) {
                EventLog.writeEvent((int)30015, (Object[])new Object[]{app.info.uid, app.info.processName});
                this.mBadProcesses.put(app.info.processName, app.info.uid, now);
                app.bad = true;
                this.mProcessCrashTimes.remove(app.info.processName, app.info.uid);
                app.removed = true;
                this.removeProcessLocked(app, false, false, "crash");
                this.mMainStack.resumeTopActivityLocked(null);
                return false;
            }
            this.mMainStack.resumeTopActivityLocked(null);
        } else {
            ActivityRecord r = this.mMainStack.topRunningActivityLocked(null);
            if (r.app == app) {
                Slog.w((String)TAG, (String)("  Force finishing activity " + r.intent.getComponent().flattenToShortString()));
                int index = this.mMainStack.indexOfActivityLocked(r);
                r.stack.finishActivityLocked(r, index, 0, null, "crashed");
                if (--index >= 0) {
                    r = this.mMainStack.mHistory.get(index);
                    if (!(r.state != ActivityStack.ActivityState.RESUMED && r.state != ActivityStack.ActivityState.PAUSING && r.state != ActivityStack.ActivityState.PAUSED || r.isHomeActivity && this.mHomeProcess == r.app)) {
                        Slog.w((String)TAG, (String)("  Force finishing activity " + r.intent.getComponent().flattenToShortString()));
                        r.stack.finishActivityLocked(r, index, 0, null, "crashed");
                    }
                }
            }
        }
        if (app.services.size() != 0) {
            for (ServiceRecord sr : app.services) {
                ++sr.crashCount;
            }
        }
        if (app == this.mHomeProcess && this.mHomeProcess.activities.size() > 0 && (this.mHomeProcess.info.flags & 1) == 0) {
            for (ActivityRecord r : this.mHomeProcess.activities) {
                if (!r.isHomeActivity) continue;
                Log.i((String)TAG, (String)("Clearing package preferred activities from " + r.packageName));
                try {
                    ActivityThread.getPackageManager().clearPackagePreferredActivities(r.packageName);
                }
                catch (RemoteException c) {}
            }
        }
        this.mProcessCrashTimes.put(app.info.processName, app.info.uid, now);
        return true;
    }

    void startAppProblemLocked(ProcessRecord app) {
        app.errorReportReceiver = ApplicationErrorReport.getErrorReportReceiver((Context)this.mContext, (String)app.info.packageName, (int)app.info.flags);
        this.skipCurrentReceiverLocked(app);
    }

    void skipCurrentReceiverLocked(ProcessRecord app) {
        boolean reschedule = false;
        BroadcastRecord r = app.curReceiver;
        if (r != null) {
            this.logBroadcastReceiverDiscardLocked(r);
            this.finishReceiverLocked(r.receiver, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, true);
            reschedule = true;
        }
        if ((r = this.mPendingBroadcast) != null && r.curApp == app) {
            this.logBroadcastReceiverDiscardLocked(r);
            this.finishReceiverLocked(r.receiver, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, true);
            reschedule = true;
        }
        if (reschedule) {
            this.scheduleBroadcastsLocked();
        }
    }

    public void handleApplicationCrash(IBinder app, ApplicationErrorReport.CrashInfo crashInfo) {
        ProcessRecord r = this.findAppProcess(app, "Crash");
        String processName = app == null ? "system_server" : (r == null ? "unknown" : r.processName);
        EventLog.writeEvent((int)30039, (Object[])new Object[]{Binder.getCallingPid(), processName, r == null ? -1 : r.info.flags, crashInfo.exceptionClassName, crashInfo.exceptionMessage, crashInfo.throwFileName, crashInfo.throwLineNumber});
        this.addErrorToDropBox("crash", r, processName, null, null, null, null, null, crashInfo);
        this.crashApplication(r, crashInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleApplicationStrictModeViolation(IBinder app, int violationMask, StrictMode.ViolationInfo info) {
        ProcessRecord r = this.findAppProcess(app, "StrictMode");
        if (r == null) {
            return;
        }
        if ((violationMask & 0x80) != 0) {
            Integer stackFingerprint = info.hashCode();
            boolean logIt = true;
            HashSet<Integer> hashSet = this.mAlreadyLoggedViolatedStacks;
            synchronized (hashSet) {
                if (this.mAlreadyLoggedViolatedStacks.contains(stackFingerprint)) {
                    logIt = false;
                } else {
                    if (this.mAlreadyLoggedViolatedStacks.size() >= 5000) {
                        this.mAlreadyLoggedViolatedStacks.clear();
                    }
                    this.mAlreadyLoggedViolatedStacks.add(stackFingerprint);
                }
            }
            if (logIt) {
                this.logStrictModeViolationToDropBox(r, info);
            }
        }
        if ((violationMask & 0x20) != 0) {
            AppErrorResult result = new AppErrorResult();
            ActivityManagerService logIt = this;
            synchronized (logIt) {
                long origId = Binder.clearCallingIdentity();
                Message msg = Message.obtain();
                msg.what = 26;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("result", result);
                data.put("app", r);
                data.put("violationMask", violationMask);
                data.put("info", info);
                msg.obj = data;
                this.mHandler.sendMessage(msg);
                Binder.restoreCallingIdentity((long)origId);
            }
            int res = result.get();
            Slog.w((String)TAG, (String)("handleApplicationStrictModeViolation; res=" + res));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStrictModeViolationToDropBox(ProcessRecord process, StrictMode.ViolationInfo info) {
        boolean needsFlush;
        boolean bufferWasEmpty;
        StringBuilder sb;
        if (info == null) {
            return;
        }
        boolean isSystemApp = process == null || (process.info.flags & 0x81) != 0;
        String processName = process == null ? "unknown" : process.processName;
        final String dropboxTag = isSystemApp ? "system_app_strictmode" : "data_app_strictmode";
        final DropBoxManager dbox = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (dbox == null || !dbox.isTagEnabled(dropboxTag)) {
            return;
        }
        StringBuilder stringBuilder = sb = isSystemApp ? this.mStrictModeBuffer : new StringBuilder(1024);
        synchronized (stringBuilder) {
            bufferWasEmpty = sb.length() == 0;
            this.appendDropBoxProcessHeaders(process, processName, sb);
            sb.append("Build: ").append(Build.FINGERPRINT).append("\n");
            sb.append("System-App: ").append(isSystemApp).append("\n");
            sb.append("Uptime-Millis: ").append(info.violationUptimeMillis).append("\n");
            if (info.violationNumThisLoop != 0) {
                sb.append("Loop-Violation-Number: ").append(info.violationNumThisLoop).append("\n");
            }
            if (info.numAnimationsRunning != 0) {
                sb.append("Animations-Running: ").append(info.numAnimationsRunning).append("\n");
            }
            if (info.broadcastIntentAction != null) {
                sb.append("Broadcast-Intent-Action: ").append(info.broadcastIntentAction).append("\n");
            }
            if (info.durationMillis != -1) {
                sb.append("Duration-Millis: ").append(info.durationMillis).append("\n");
            }
            if (info.numInstances != -1L) {
                sb.append("Instance-Count: ").append(info.numInstances).append("\n");
            }
            if (info.tags != null) {
                for (String tag : info.tags) {
                    sb.append("Span-Tag: ").append(tag).append("\n");
                }
            }
            sb.append("\n");
            if (info.crashInfo != null && info.crashInfo.stackTrace != null) {
                sb.append(info.crashInfo.stackTrace);
            }
            sb.append("\n");
            needsFlush = sb.length() > 65536;
        }
        if (!isSystemApp || needsFlush) {
            new Thread("Error dump: " + dropboxTag){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String report;
                    StringBuilder stringBuilder = sb;
                    synchronized (stringBuilder) {
                        report = sb.toString();
                        sb.delete(0, sb.length());
                        sb.trimToSize();
                    }
                    if (report.length() != 0) {
                        dbox.addText(dropboxTag, report);
                    }
                }
            }.start();
            return;
        }
        if (!bufferWasEmpty) {
            return;
        }
        new Thread("Error dump: " + dropboxTag){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String errorReport;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                StringBuilder stringBuilder = ActivityManagerService.this.mStrictModeBuffer;
                synchronized (stringBuilder) {
                    errorReport = ActivityManagerService.this.mStrictModeBuffer.toString();
                    if (errorReport.length() == 0) {
                        return;
                    }
                    ActivityManagerService.this.mStrictModeBuffer.delete(0, ActivityManagerService.this.mStrictModeBuffer.length());
                    ActivityManagerService.this.mStrictModeBuffer.trimToSize();
                }
                dbox.addText(dropboxTag, errorReport);
            }
        }.start();
    }

    public boolean handleApplicationWtf(IBinder app, String tag, ApplicationErrorReport.CrashInfo crashInfo) {
        ProcessRecord r = this.findAppProcess(app, "WTF");
        String processName = app == null ? "system_server" : (r == null ? "unknown" : r.processName);
        EventLog.writeEvent((int)30040, (Object[])new Object[]{Binder.getCallingPid(), processName, r == null ? -1 : r.info.flags, tag, crashInfo.exceptionMessage});
        this.addErrorToDropBox("wtf", r, processName, null, null, tag, null, null, crashInfo);
        if (r != null && r.pid != android.os.Process.myPid() && Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"wtf_is_fatal", (int)0) != 0) {
            this.crashApplication(r, crashInfo);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessRecord findAppProcess(IBinder app, String reason) {
        if (app == null) {
            return null;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (SparseArray<ProcessRecord> apps : this.mProcessNames.getMap().values()) {
                int NA = apps.size();
                for (int ia = 0; ia < NA; ++ia) {
                    ProcessRecord p = (ProcessRecord)apps.valueAt(ia);
                    if (p.thread == null || p.thread.asBinder() != app) continue;
                    return p;
                }
            }
            Slog.w((String)TAG, (String)("Can't find mystery application for " + reason + " from pid=" + Binder.getCallingPid() + " uid=" + Binder.getCallingUid() + ": " + app));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendDropBoxProcessHeaders(ProcessRecord process, String processName, StringBuilder sb) {
        if (process == null) {
            sb.append("Process: ").append(processName).append("\n");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            sb.append("Process: ").append(processName).append("\n");
            int flags = process.info.flags;
            IPackageManager pm = AppGlobals.getPackageManager();
            sb.append("Flags: 0x").append(Integer.toString(flags, 16)).append("\n");
            for (String pkg : process.pkgList) {
                sb.append("Package: ").append(pkg);
                try {
                    PackageInfo pi = pm.getPackageInfo(pkg, 0);
                    if (pi != null) {
                        sb.append(" v").append(pi.versionCode);
                        if (pi.versionName != null) {
                            sb.append(" (").append(pi.versionName).append(")");
                        }
                    }
                }
                catch (RemoteException e) {
                    Slog.e((String)TAG, (String)("Error getting package info: " + pkg), (Throwable)e);
                }
                sb.append("\n");
            }
        }
    }

    private static String processClass(ProcessRecord process) {
        if (process == null || process.pid == MY_PID) {
            return "system_server";
        }
        if ((process.info.flags & 1) != 0) {
            return "system_app";
        }
        return "data_app";
    }

    public void addErrorToDropBox(String eventType, ProcessRecord process, String processName, ActivityRecord activity, ActivityRecord parent, String subject, final String report, final File logFile, final ApplicationErrorReport.CrashInfo crashInfo) {
        final String dropboxTag = ActivityManagerService.processClass(process) + "_" + eventType;
        final DropBoxManager dbox = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (dbox == null || !dbox.isTagEnabled(dropboxTag)) {
            return;
        }
        final StringBuilder sb = new StringBuilder(1024);
        this.appendDropBoxProcessHeaders(process, processName, sb);
        if (activity != null) {
            sb.append("Activity: ").append(activity.shortComponentName).append("\n");
        }
        if (parent != null && parent.app != null && parent.app.pid != process.pid) {
            sb.append("Parent-Process: ").append(parent.app.processName).append("\n");
        }
        if (parent != null && parent != activity) {
            sb.append("Parent-Activity: ").append(parent.shortComponentName).append("\n");
        }
        if (subject != null) {
            sb.append("Subject: ").append(subject).append("\n");
        }
        sb.append("Build: ").append(Build.FINGERPRINT).append("\n");
        if (Debug.isDebuggerConnected()) {
            sb.append("Debugger: Connected\n");
        }
        sb.append("\n");
        Thread worker = new Thread("Error dump: " + dropboxTag){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block20: {
                    if (report != null) {
                        sb.append(report);
                    }
                    if (logFile != null) {
                        try {
                            sb.append(FileUtils.readTextFile((File)logFile, (int)131072, (String)"\n\n[[TRUNCATED]]"));
                        }
                        catch (IOException e) {
                            Slog.e((String)"ActivityManager", (String)("Error reading " + logFile), (Throwable)e);
                        }
                    }
                    if (crashInfo != null && crashInfo.stackTrace != null) {
                        sb.append(crashInfo.stackTrace);
                    }
                    setting = "logcat_for_" + dropboxTag;
                    lines = Settings.Secure.getInt((ContentResolver)ActivityManagerService.this.mContext.getContentResolver(), (String)setting, (int)0);
                    if (lines > 0) {
                        sb.append("\n");
                        input = null;
                        try {
                            try {
                                logcat = new ProcessBuilder(new String[]{"/system/bin/logcat", "-v", "time", "-b", "events", "-b", "system", "-b", "main", "-t", String.valueOf(lines)}).redirectErrorStream(true).start();
                                try {
                                    logcat.getOutputStream().close();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                try {
                                    logcat.getErrorStream().close();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                input = new InputStreamReader(logcat.getInputStream());
                                buf = new char[8192];
                                while ((num = input.read(buf)) > 0) {
                                    sb.append(buf, 0, num);
                                }
                                var8_12 = null;
                                if (input == null) break block20;
                            }
                            catch (IOException e) {
                                Slog.e((String)"ActivityManager", (String)"Error running logcat", (Throwable)e);
                                var8_13 = null;
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e) {}
                                }
                                break block20;
                            }
                        }
                        catch (Throwable var7_18) {
                            var8_14 = null;
                            if (input == null) throw var7_18;
                            ** try [egrp 5[TRYBLOCK] [7 : 360->367)] { 
lbl59:
                            // 1 sources

                            input.close();
                            throw var7_18;
lbl61:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            throw var7_18;
                        }
                        try {}
                        catch (IOException e) {}
                        input.close();
                    }
                }
                dbox.addText(dropboxTag, sb.toString());
            }
        };
        if (process == null || process.pid == MY_PID) {
            worker.run();
        } else {
            worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crashApplication(ProcessRecord r, ApplicationErrorReport.CrashInfo crashInfo) {
        long timeMillis = System.currentTimeMillis();
        String shortMsg = crashInfo.exceptionClassName;
        String longMsg = crashInfo.exceptionMessage;
        String stackTrace = crashInfo.stackTrace;
        if (shortMsg != null && longMsg != null) {
            longMsg = shortMsg + ": " + longMsg;
        } else if (shortMsg != null) {
            longMsg = shortMsg;
        }
        AppErrorResult result = new AppErrorResult();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mController != null) {
                try {
                    int pid;
                    String name = r != null ? r.processName : null;
                    int n = pid = r != null ? r.pid : Binder.getCallingPid();
                    if (!this.mController.appCrashed(name, pid, shortMsg, longMsg, timeMillis, crashInfo.stackTrace)) {
                        Slog.w((String)TAG, (String)("Force-killing crashed app " + name + " at watcher's request"));
                        android.os.Process.killProcess((int)pid);
                        return;
                    }
                }
                catch (RemoteException e) {
                    this.mController = null;
                }
            }
            long origId = Binder.clearCallingIdentity();
            if (r != null && r.instrumentationClass != null) {
                Slog.w((String)TAG, (String)("Error in app " + r.processName + " running instrumentation " + r.instrumentationClass + ":"));
                if (shortMsg != null) {
                    Slog.w((String)TAG, (String)("  " + shortMsg));
                }
                if (longMsg != null) {
                    Slog.w((String)TAG, (String)("  " + longMsg));
                }
                Bundle info = new Bundle();
                info.putString("shortMsg", shortMsg);
                info.putString("longMsg", longMsg);
                this.finishInstrumentationLocked(r, 0, info);
                Binder.restoreCallingIdentity((long)origId);
                return;
            }
            if (r == null || !this.makeAppCrashingLocked(r, shortMsg, longMsg, stackTrace)) {
                Binder.restoreCallingIdentity((long)origId);
                return;
            }
            Message msg = Message.obtain();
            msg.what = 1;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("result", result);
            data.put("app", r);
            msg.obj = data;
            this.mHandler.sendMessage(msg);
            Binder.restoreCallingIdentity((long)origId);
        }
        int res = result.get();
        Intent appErrorIntent = null;
        ActivityManagerService pid = this;
        synchronized (pid) {
            if (r != null) {
                this.mProcessCrashTimes.put(r.info.processName, r.info.uid, SystemClock.uptimeMillis());
            }
            if (res == 1) {
                appErrorIntent = this.createAppErrorIntentLocked(r, timeMillis, crashInfo);
            }
        }
        if (appErrorIntent != null) {
            try {
                this.mContext.startActivity(appErrorIntent);
            }
            catch (ActivityNotFoundException e) {
                Slog.w((String)TAG, (String)"bug report receiver dissappeared", (Throwable)e);
            }
        }
    }

    Intent createAppErrorIntentLocked(ProcessRecord r, long timeMillis, ApplicationErrorReport.CrashInfo crashInfo) {
        ApplicationErrorReport report = this.createAppErrorReportLocked(r, timeMillis, crashInfo);
        if (report == null) {
            return null;
        }
        Intent result = new Intent("android.intent.action.APP_ERROR");
        result.setComponent(r.errorReportReceiver);
        result.putExtra("android.intent.extra.BUG_REPORT", (Parcelable)report);
        result.addFlags(0x10000000);
        return result;
    }

    private ApplicationErrorReport createAppErrorReportLocked(ProcessRecord r, long timeMillis, ApplicationErrorReport.CrashInfo crashInfo) {
        if (r.errorReportReceiver == null) {
            return null;
        }
        if (!r.crashing && !r.notResponding) {
            return null;
        }
        ApplicationErrorReport report = new ApplicationErrorReport();
        report.packageName = r.info.packageName;
        report.installerPackageName = r.errorReportReceiver.getPackageName();
        report.processName = r.processName;
        report.time = timeMillis;
        boolean bl = report.systemApp = (r.info.flags & 1) != 0;
        if (r.crashing) {
            report.type = 1;
            report.crashInfo = crashInfo;
        } else if (r.notResponding) {
            report.type = 2;
            report.anrInfo = new ApplicationErrorReport.AnrInfo();
            report.anrInfo.activity = r.notRespondingReport.tag;
            report.anrInfo.cause = r.notRespondingReport.shortMsg;
            report.anrInfo.info = r.notRespondingReport.longMsg;
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityManager.ProcessErrorStateInfo> getProcessesInErrorState() {
        ArrayList<ActivityManager.ProcessErrorStateInfo> errList = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (app.thread == null || !app.crashing && !app.notResponding) continue;
                ActivityManager.ProcessErrorStateInfo report = null;
                if (app.crashing) {
                    report = app.crashingReport;
                } else if (app.notResponding) {
                    report = app.notRespondingReport;
                }
                if (report != null) {
                    if (errList == null) {
                        errList = new ArrayList<ActivityManager.ProcessErrorStateInfo>(1);
                    }
                    errList.add(report);
                    continue;
                }
                Slog.w((String)TAG, (String)("Missing app error report, app = " + app.processName + " crashing = " + app.crashing + " notResponding = " + app.notResponding));
            }
        }
        return errList;
    }

    static int oomAdjToImportance(int adj, ActivityManager.RunningAppProcessInfo currApp) {
        if (adj >= ProcessList.HIDDEN_APP_MIN_ADJ) {
            if (currApp != null) {
                currApp.lru = adj - ProcessList.HIDDEN_APP_MIN_ADJ + 1;
            }
            return 400;
        }
        if (adj >= 8) {
            return 300;
        }
        if (adj >= 6) {
            if (currApp != null) {
                currApp.lru = 0;
            }
            return 400;
        }
        if (adj >= 5) {
            return 300;
        }
        if (adj >= 3) {
            return 170;
        }
        if (adj >= 2) {
            return 130;
        }
        if (adj >= 1) {
            return 200;
        }
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        ArrayList<ActivityManager.RunningAppProcessInfo> runList = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (app.thread == null || app.crashing || app.notResponding) continue;
                ActivityManager.RunningAppProcessInfo currApp = new ActivityManager.RunningAppProcessInfo(app.processName, app.pid, app.getPackageList());
                currApp.uid = app.info.uid;
                if (this.mHeavyWeightProcess == app) {
                    currApp.flags |= 1;
                }
                if (app.persistent) {
                    currApp.flags |= 2;
                }
                int adj = app.curAdj;
                currApp.importance = ActivityManagerService.oomAdjToImportance(adj, currApp);
                currApp.importanceReasonCode = app.adjTypeCode;
                if (app.adjSource instanceof ProcessRecord) {
                    currApp.importanceReasonPid = ((ProcessRecord)app.adjSource).pid;
                    currApp.importanceReasonImportance = ActivityManagerService.oomAdjToImportance(app.adjSourceOom, null);
                } else if (app.adjSource instanceof ActivityRecord) {
                    ActivityRecord r = (ActivityRecord)app.adjSource;
                    if (r.app != null) {
                        currApp.importanceReasonPid = r.app.pid;
                    }
                }
                if (app.adjTarget instanceof ComponentName) {
                    currApp.importanceReasonComponent = (ComponentName)app.adjTarget;
                }
                if (runList == null) {
                    runList = new ArrayList<ActivityManager.RunningAppProcessInfo>();
                }
                runList.add(currApp);
            }
        }
        return runList;
    }

    public List<ApplicationInfo> getRunningExternalApplications() {
        List<ActivityManager.RunningAppProcessInfo> runningApps = this.getRunningAppProcesses();
        ArrayList<ApplicationInfo> retList = new ArrayList<ApplicationInfo>();
        if (runningApps != null && runningApps.size() > 0) {
            HashSet<String> extList = new HashSet<String>();
            for (ActivityManager.RunningAppProcessInfo app : runningApps) {
                if (app.pkgList == null) continue;
                for (String pkg : app.pkgList) {
                    extList.add(pkg);
                }
            }
            IPackageManager pm = AppGlobals.getPackageManager();
            for (String pkg : extList) {
                try {
                    ApplicationInfo info = pm.getApplicationInfo(pkg, 0);
                    if ((info.flags & 0x40000) == 0) continue;
                    retList.add(info);
                }
                catch (RemoteException e) {}
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.checkCallingPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ActivityManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        boolean dumpAll = false;
        boolean dumpClient = false;
        String dumpPackage = null;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpAll = true;
                continue;
            }
            if ("-c".equals(opt)) {
                dumpClient = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("Activity manager dump options:");
                pw.println("  [-a] [-c] [-h] [cmd] ...");
                pw.println("  cmd may be one of:");
                pw.println("    a[ctivities]: activity stack state");
                pw.println("    b[roadcasts] [PACKAGE_NAME]: broadcast state");
                pw.println("    i[ntents] [PACKAGE_NAME]: pending intent state");
                pw.println("    p[rocesses] [PACKAGE_NAME]: process state");
                pw.println("    o[om]: out of memory management");
                pw.println("    prov[iders] [COMP_SPEC ...]: content provider state");
                pw.println("    s[ervices] [COMP_SPEC ...]: service state");
                pw.println("    service [COMP_SPEC]: service client-side state");
                pw.println("    package [PACKAGE_NAME]: all state related to given package");
                pw.println("    all: dump all activities");
                pw.println("    top: dump the top activity");
                pw.println("  cmd may also be a COMP_SPEC to dump activities.");
                pw.println("  COMP_SPEC may be a component name (com.foo/.myApp),");
                pw.println("    a partial substring in a component name, a");
                pw.println("    hex object identifier.");
                pw.println("  -a: include all available server state.");
                pw.println("  -c: include client state.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("activities".equals(cmd) || "a".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpActivitiesLocked(fd, pw, args, opti, true, dumpClient, null);
                }
                return;
            }
            if ("broadcasts".equals(cmd) || "b".equals(cmd)) {
                String name;
                if (opti >= args.length) {
                    name = null;
                    String[] newArgs = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    String[] newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpBroadcastsLocked(fd, pw, args, opti, true, name);
                }
                return;
            }
            if ("intents".equals(cmd) || "i".equals(cmd)) {
                String name;
                if (opti >= args.length) {
                    name = null;
                    String[] newArgs = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    String[] newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpPendingIntentsLocked(fd, pw, args, opti, true, name);
                }
                return;
            }
            if ("processes".equals(cmd) || "p".equals(cmd)) {
                String name;
                if (opti >= args.length) {
                    name = null;
                    String[] newArgs = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    String[] newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpProcessesLocked(fd, pw, args, opti, true, name);
                }
                return;
            }
            if ("oom".equals(cmd) || "o".equals(cmd)) {
                ActivityManagerService newArgs = this;
                synchronized (newArgs) {
                    this.dumpOomLocked(fd, pw, args, opti, true);
                }
                return;
            }
            if ("providers".equals(cmd) || "prov".equals(cmd)) {
                ActivityManagerService newArgs = this;
                synchronized (newArgs) {
                    this.dumpProvidersLocked(fd, pw, args, opti, true, null);
                }
                return;
            }
            if ("service".equals(cmd)) {
                String[] newArgs;
                String name;
                if (opti >= args.length) {
                    name = null;
                    newArgs = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                if (!this.dumpService(fd, pw, name, newArgs, 0, dumpAll)) {
                    pw.println("No services match: " + name);
                    pw.println("Use -h for help.");
                }
                return;
            }
            if ("package".equals(cmd)) {
                if (opti >= args.length) {
                    pw.println("package: no package name specified");
                    pw.println("Use -h for help.");
                    return;
                }
                dumpPackage = args[opti];
                String[] newArgs = new String[args.length - ++opti];
                if (args.length > 2) {
                    System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                }
                args = newArgs;
                opti = 0;
            } else {
                if ("services".equals(cmd) || "s".equals(cmd)) {
                    ActivityManagerService newArgs = this;
                    synchronized (newArgs) {
                        this.dumpServicesLocked(fd, pw, args, opti, true, dumpClient, null);
                    }
                    return;
                }
                if (!this.dumpActivity(fd, pw, cmd, args, opti, dumpAll)) {
                    pw.println("Bad activity command, or no activities match: " + cmd);
                    pw.println("Use -h for help.");
                }
                return;
            }
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean needSep = this.dumpPendingIntentsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            if (needSep) {
                pw.println(" ");
            }
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            if (needSep = this.dumpBroadcastsLocked(fd, pw, args, opti, dumpAll, dumpPackage)) {
                pw.println(" ");
            }
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            if (needSep = this.dumpProvidersLocked(fd, pw, args, opti, dumpAll, dumpPackage)) {
                pw.println(" ");
            }
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            if (needSep = this.dumpServicesLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage)) {
                pw.println(" ");
            }
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            if (needSep = this.dumpActivitiesLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage)) {
                pw.println(" ");
            }
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpProcessesLocked(fd, pw, args, opti, dumpAll, dumpPackage);
        }
    }

    boolean dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        pw.println("ACTIVITY MANAGER ACTIVITIES (dumpsys activity activities)");
        pw.println("  Main stack:");
        ActivityManagerService.dumpHistoryList(fd, pw, this.mMainStack.mHistory, "  ", "Hist", true, !dumpAll, dumpClient, dumpPackage);
        pw.println(" ");
        pw.println("  Running activities (most recent first):");
        ActivityManagerService.dumpHistoryList(fd, pw, this.mMainStack.mLRUActivities, "  ", "Run", false, !dumpAll, false, dumpPackage);
        if (this.mMainStack.mWaitingVisibleActivities.size() > 0) {
            pw.println(" ");
            pw.println("  Activities waiting for another to become visible:");
            ActivityManagerService.dumpHistoryList(fd, pw, this.mMainStack.mWaitingVisibleActivities, "  ", "Wait", false, !dumpAll, false, dumpPackage);
        }
        if (this.mMainStack.mStoppingActivities.size() > 0) {
            pw.println(" ");
            pw.println("  Activities waiting to stop:");
            ActivityManagerService.dumpHistoryList(fd, pw, this.mMainStack.mStoppingActivities, "  ", "Stop", false, !dumpAll, false, dumpPackage);
        }
        if (this.mMainStack.mGoingToSleepActivities.size() > 0) {
            pw.println(" ");
            pw.println("  Activities waiting to sleep:");
            ActivityManagerService.dumpHistoryList(fd, pw, this.mMainStack.mGoingToSleepActivities, "  ", "Sleep", false, !dumpAll, false, dumpPackage);
        }
        if (this.mMainStack.mFinishingActivities.size() > 0) {
            pw.println(" ");
            pw.println("  Activities waiting to finish:");
            ActivityManagerService.dumpHistoryList(fd, pw, this.mMainStack.mFinishingActivities, "  ", "Fin", false, !dumpAll, false, dumpPackage);
        }
        pw.println(" ");
        if (this.mMainStack.mPausingActivity != null) {
            pw.println("  mPausingActivity: " + this.mMainStack.mPausingActivity);
        }
        pw.println("  mResumedActivity: " + this.mMainStack.mResumedActivity);
        pw.println("  mFocusedActivity: " + this.mFocusedActivity);
        if (dumpAll) {
            pw.println("  mLastPausedActivity: " + this.mMainStack.mLastPausedActivity);
            pw.println("  mSleepTimeout: " + this.mMainStack.mSleepTimeout);
            pw.println("  mDismissKeyguardOnNextActivity: " + this.mMainStack.mDismissKeyguardOnNextActivity);
        }
        if (this.mRecentTasks.size() > 0) {
            pw.println();
            pw.println("  Recent tasks:");
            int N = this.mRecentTasks.size();
            for (int i = 0; i < N; ++i) {
                TaskRecord tr = this.mRecentTasks.get(i);
                if (dumpPackage != null && (tr.realActivity == null || !dumpPackage.equals(tr.realActivity))) continue;
                pw.print("  * Recent #");
                pw.print(i);
                pw.print(": ");
                pw.println(tr);
                if (!dumpAll) continue;
                this.mRecentTasks.get(i).dump(pw, "    ");
            }
        }
        if (dumpAll) {
            pw.println(" ");
            pw.println("  mCurTask: " + this.mCurTask);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dumpProcessesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        int i;
        Iterator<SparseArray<ProcessRecord>> i$;
        boolean needSep = false;
        int numPers = 0;
        pw.println("ACTIVITY MANAGER RUNNING PROCESSES (dumpsys activity processes)");
        if (dumpAll) {
            for (SparseArray<ProcessRecord> procs : this.mProcessNames.getMap().values()) {
                int NA = procs.size();
                for (int ia = 0; ia < NA; ++ia) {
                    ProcessRecord r = (ProcessRecord)procs.valueAt(ia);
                    if (dumpPackage != null && !dumpPackage.equals(r.info.packageName)) continue;
                    if (!needSep) {
                        pw.println("  All known processes:");
                        needSep = true;
                    }
                    pw.print(r.persistent ? "  *PERS*" : "  *APP*");
                    pw.print(" UID ");
                    pw.print(procs.keyAt(ia));
                    pw.print(" ");
                    pw.println(r);
                    r.dump(pw, "    ");
                    if (!r.persistent) continue;
                    ++numPers;
                }
            }
        }
        if (this.mLruProcesses.size() > 0) {
            if (needSep) {
                pw.println(" ");
            }
            needSep = true;
            pw.println("  Process LRU list (sorted by oom_adj):");
            ActivityManagerService.dumpProcessOomList(pw, this, this.mLruProcesses, "    ", "Proc", "PERS", false, dumpPackage);
            needSep = true;
        }
        if (dumpAll) {
            i$ = this.mPidsSelfLocked;
            synchronized (i$) {
                boolean printed = false;
                for (i = 0; i < this.mPidsSelfLocked.size(); ++i) {
                    ProcessRecord r = (ProcessRecord)this.mPidsSelfLocked.valueAt(i);
                    if (dumpPackage != null && !dumpPackage.equals(r.info.packageName)) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println(" ");
                        }
                        needSep = true;
                        pw.println("  PID mappings:");
                        printed = true;
                    }
                    pw.print("    PID #");
                    pw.print(this.mPidsSelfLocked.keyAt(i));
                    pw.print(": ");
                    pw.println(this.mPidsSelfLocked.valueAt(i));
                }
            }
        }
        if (this.mForegroundProcesses.size() > 0) {
            i$ = this.mPidsSelfLocked;
            synchronized (i$) {
                boolean printed = false;
                for (i = 0; i < this.mForegroundProcesses.size(); ++i) {
                    ProcessRecord r = (ProcessRecord)this.mPidsSelfLocked.get(((ForegroundToken)this.mForegroundProcesses.valueAt((int)i)).pid);
                    if (dumpPackage != null && (r == null || !dumpPackage.equals(r.info.packageName))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println(" ");
                        }
                        needSep = true;
                        pw.println("  Foreground Processes:");
                        printed = true;
                    }
                    pw.print("    PID #");
                    pw.print(this.mForegroundProcesses.keyAt(i));
                    pw.print(": ");
                    pw.println(this.mForegroundProcesses.valueAt(i));
                }
            }
        }
        if (this.mPersistentStartingProcesses.size() > 0) {
            if (needSep) {
                pw.println(" ");
            }
            needSep = true;
            pw.println("  Persisent processes that are starting:");
            ActivityManagerService.dumpProcessList(pw, this, this.mPersistentStartingProcesses, "    ", "Starting Norm", "Restarting PERS", dumpPackage);
        }
        if (this.mRemovedProcesses.size() > 0) {
            if (needSep) {
                pw.println(" ");
            }
            needSep = true;
            pw.println("  Processes that are being removed:");
            ActivityManagerService.dumpProcessList(pw, this, this.mRemovedProcesses, "    ", "Removed Norm", "Removed PERS", dumpPackage);
        }
        if (this.mProcessesOnHold.size() > 0) {
            if (needSep) {
                pw.println(" ");
            }
            needSep = true;
            pw.println("  Processes that are on old until the system is ready:");
            ActivityManagerService.dumpProcessList(pw, this, this.mProcessesOnHold, "    ", "OnHold Norm", "OnHold PERS", dumpPackage);
        }
        needSep = this.dumpProcessesToGc(fd, pw, args, opti, needSep, dumpAll, dumpPackage);
        if (this.mProcessCrashTimes.getMap().size() > 0) {
            boolean printed = false;
            long now = SystemClock.uptimeMillis();
            for (Map.Entry<String, SparseArray<Long>> procs : this.mProcessCrashTimes.getMap().entrySet()) {
                String pname = procs.getKey();
                SparseArray<Long> uids = procs.getValue();
                int N = uids.size();
                for (int i2 = 0; i2 < N; ++i2) {
                    int puid = uids.keyAt(i2);
                    ProcessRecord r = this.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !dumpPackage.equals(r.info.packageName))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println(" ");
                        }
                        needSep = true;
                        pw.println("  Time since processes crashed:");
                        printed = true;
                    }
                    pw.print("    Process ");
                    pw.print(pname);
                    pw.print(" uid ");
                    pw.print(puid);
                    pw.print(": last crashed ");
                    pw.print(now - (Long)uids.valueAt(i2));
                    pw.println(" ms ago");
                }
            }
        }
        if (this.mBadProcesses.getMap().size() > 0) {
            boolean printed = false;
            for (Map.Entry<String, SparseArray<Long>> procs : this.mBadProcesses.getMap().entrySet()) {
                String pname = procs.getKey();
                SparseArray<Long> uids = procs.getValue();
                int N = uids.size();
                for (int i3 = 0; i3 < N; ++i3) {
                    int puid = uids.keyAt(i3);
                    ProcessRecord r = this.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !dumpPackage.equals(r.info.packageName))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println(" ");
                        }
                        needSep = true;
                        pw.println("  Bad processes:");
                    }
                    pw.print("    Bad process ");
                    pw.print(pname);
                    pw.print(" uid ");
                    pw.print(puid);
                    pw.print(": crashed at time ");
                    pw.println(uids.valueAt(i3));
                }
            }
        }
        pw.println();
        pw.println("  mHomeProcess: " + this.mHomeProcess);
        pw.println("  mPreviousProcess: " + this.mPreviousProcess);
        if (dumpAll) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("  mPreviousProcessVisibleTime: ");
            TimeUtils.formatDuration((long)this.mPreviousProcessVisibleTime, (StringBuilder)sb);
            pw.println(sb);
        }
        if (this.mHeavyWeightProcess != null) {
            pw.println("  mHeavyWeightProcess: " + this.mHeavyWeightProcess);
        }
        pw.println("  mConfiguration: " + this.mConfiguration);
        if (dumpAll) {
            pw.println("  mConfigWillChange: " + this.mMainStack.mConfigWillChange);
            if (this.mCompatModePackages.getPackages().size() > 0) {
                boolean printed = false;
                for (Map.Entry<String, Integer> entry : this.mCompatModePackages.getPackages().entrySet()) {
                    String pkg = entry.getKey();
                    int mode = entry.getValue();
                    if (dumpPackage != null && !dumpPackage.equals(pkg)) continue;
                    if (!printed) {
                        pw.println("  mScreenCompatPackages:");
                        printed = true;
                    }
                    pw.print("    ");
                    pw.print(pkg);
                    pw.print(": ");
                    pw.print(mode);
                    pw.println();
                }
            }
        }
        pw.println("  mSleeping=" + this.mSleeping + " mShuttingDown=" + this.mShuttingDown);
        if (this.mDebugApp != null || this.mOrigDebugApp != null || this.mDebugTransient || this.mOrigWaitForDebugger) {
            pw.println("  mDebugApp=" + this.mDebugApp + "/orig=" + this.mOrigDebugApp + " mDebugTransient=" + this.mDebugTransient + " mOrigWaitForDebugger=" + this.mOrigWaitForDebugger);
        }
        if (this.mProfileApp != null || this.mProfileProc != null || this.mProfileFile != null || this.mProfileFd != null) {
            pw.println("  mProfileApp=" + this.mProfileApp + " mProfileProc=" + this.mProfileProc);
            pw.println("  mProfileFile=" + this.mProfileFile + " mProfileFd=" + this.mProfileFd);
            pw.println("  mProfileType=" + this.mProfileType + " mAutoStopProfiler=" + this.mAutoStopProfiler);
        }
        if (this.mAlwaysFinishActivities || this.mController != null) {
            pw.println("  mAlwaysFinishActivities=" + this.mAlwaysFinishActivities + " mController=" + this.mController);
        }
        if (dumpAll) {
            pw.println("  Total persistent processes: " + numPers);
            pw.println("  mStartRunning=" + this.mStartRunning + " mProcessesReady=" + this.mProcessesReady + " mSystemReady=" + this.mSystemReady);
            pw.println("  mBooting=" + this.mBooting + " mBooted=" + this.mBooted + " mFactoryTest=" + this.mFactoryTest);
            pw.print("  mLastPowerCheckRealtime=");
            TimeUtils.formatDuration((long)this.mLastPowerCheckRealtime, (PrintWriter)pw);
            pw.println("");
            pw.print("  mLastPowerCheckUptime=");
            TimeUtils.formatDuration((long)this.mLastPowerCheckUptime, (PrintWriter)pw);
            pw.println("");
            pw.println("  mGoingToSleep=" + this.mMainStack.mGoingToSleep);
            pw.println("  mLaunchingActivity=" + this.mMainStack.mLaunchingActivity);
            pw.println("  mAdjSeq=" + this.mAdjSeq + " mLruSeq=" + this.mLruSeq);
            pw.println("  mNumServiceProcs=" + this.mNumServiceProcs + " mNewNumServiceProcs=" + this.mNewNumServiceProcs);
        }
        return true;
    }

    boolean dumpProcessesToGc(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean needSep, boolean dumpAll, String dumpPackage) {
        if (this.mProcessesToGc.size() > 0) {
            boolean printed = false;
            long now = SystemClock.uptimeMillis();
            for (int i = 0; i < this.mProcessesToGc.size(); ++i) {
                ProcessRecord proc = this.mProcessesToGc.get(i);
                if (dumpPackage != null && !dumpPackage.equals(proc.info.packageName)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println(" ");
                    }
                    needSep = true;
                    pw.println("  Processes that are waiting to GC:");
                    printed = true;
                }
                pw.print("    Process ");
                pw.println(proc);
                pw.print("      lowMem=");
                pw.print(proc.reportLowMemory);
                pw.print(", last gced=");
                pw.print(now - proc.lastRequestedGc);
                pw.print(" ms ago, last lowMem=");
                pw.print(now - proc.lastLowMemory);
                pw.println(" ms ago");
            }
        }
        return needSep;
    }

    boolean dumpOomLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll) {
        boolean needSep = false;
        if (this.mLruProcesses.size() > 0) {
            if (needSep) {
                pw.println(" ");
            }
            needSep = true;
            pw.println("  OOM levels:");
            pw.print("    SYSTEM_ADJ: ");
            pw.println(-16);
            pw.print("    PERSISTENT_PROC_ADJ: ");
            pw.println(-12);
            pw.print("    FOREGROUND_APP_ADJ: ");
            pw.println(0);
            pw.print("    VISIBLE_APP_ADJ: ");
            pw.println(1);
            pw.print("    PERCEPTIBLE_APP_ADJ: ");
            pw.println(2);
            pw.print("    HEAVY_WEIGHT_APP_ADJ: ");
            pw.println(3);
            pw.print("    BACKUP_APP_ADJ: ");
            pw.println(4);
            pw.print("    SERVICE_ADJ: ");
            pw.println(5);
            pw.print("    HOME_APP_ADJ: ");
            pw.println(6);
            pw.print("    PREVIOUS_APP_ADJ: ");
            pw.println(7);
            pw.print("    SERVICE_B_ADJ: ");
            pw.println(8);
            pw.print("    HIDDEN_APP_MIN_ADJ: ");
            pw.println(ProcessList.HIDDEN_APP_MIN_ADJ);
            pw.print("    HIDDEN_APP_MAX_ADJ: ");
            pw.println(15);
            if (needSep) {
                pw.println(" ");
            }
            needSep = true;
            pw.println("  Process OOM control:");
            ActivityManagerService.dumpProcessOomList(pw, this, this.mLruProcesses, "    ", "Proc", "PERS", true, null);
            needSep = true;
        }
        needSep = this.dumpProcessesToGc(fd, pw, args, opti, needSep, dumpAll, null);
        pw.println();
        pw.println("  mHomeProcess: " + this.mHomeProcess);
        pw.println("  mPreviousProcess: " + this.mPreviousProcess);
        if (this.mHeavyWeightProcess != null) {
            pw.println("  mHeavyWeightProcess: " + this.mHeavyWeightProcess);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dumpService(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        ArrayList<ServiceRecord> services = new ArrayList<ServiceRecord>();
        if ("all".equals(name)) {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                for (ServiceRecord r1 : this.mServices.values()) {
                    services.add(r1);
                }
            }
        }
        ComponentName componentName = name != null ? ComponentName.unflattenFromString((String)name) : null;
        int objectId = 0;
        if (componentName == null) {
            try {
                objectId = Integer.parseInt(name, 16);
                name = null;
                componentName = null;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (ServiceRecord r1 : this.mServices.values()) {
                if (componentName != null) {
                    if (!r1.name.equals((Object)componentName)) continue;
                    services.add(r1);
                    continue;
                }
                if (name != null) {
                    if (!r1.name.flattenToString().contains(name)) continue;
                    services.add(r1);
                    continue;
                }
                if (System.identityHashCode((Object)r1) != objectId) continue;
                services.add(r1);
            }
        }
        if (services.size() <= 0) {
            return false;
        }
        boolean needSep = false;
        for (int i = 0; i < services.size(); ++i) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            this.dumpService("", fd, pw, (ServiceRecord)((Object)services.get(i)), args, dumpAll);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpService(String prefix, FileDescriptor fd, PrintWriter pw, ServiceRecord r, String[] args, boolean dumpAll) {
        String innerPrefix = prefix + "  ";
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            pw.print(prefix);
            pw.print("SERVICE ");
            pw.print(r.shortName);
            pw.print(" ");
            pw.print(Integer.toHexString(System.identityHashCode((Object)r)));
            pw.print(" pid=");
            if (r.app != null) {
                pw.println(r.app.pid);
            } else {
                pw.println("(not running)");
            }
            if (dumpAll) {
                r.dump(pw, innerPrefix);
            }
        }
        if (r.app != null && r.app.thread != null) {
            pw.print(prefix);
            pw.println("  Client:");
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpService(tp.getWriteFd().getFileDescriptor(), (IBinder)r, args);
                    tp.setBufferPrefix(prefix + "    ");
                    tp.go(fd);
                    Object var11_12 = null;
                    tp.kill();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    tp.kill();
                    throw throwable;
                }
            }
            catch (IOException e) {
                pw.println(prefix + "    Failure while dumping the service: " + e);
            }
            catch (RemoteException e) {
                pw.println(prefix + "    Got a RemoteException while dumping the service");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dumpActivity(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        ActivityManagerService activityManagerService;
        ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>();
        if ("all".equals(name)) {
            activityManagerService = this;
            synchronized (activityManagerService) {
                for (ActivityRecord r1 : this.mMainStack.mHistory) {
                    activities.add(r1);
                }
            }
        }
        if ("top".equals(name)) {
            activityManagerService = this;
            synchronized (activityManagerService) {
                int N = this.mMainStack.mHistory.size();
                if (N > 0) {
                    activities.add(this.mMainStack.mHistory.get(N - 1));
                }
            }
        }
        ItemMatcher matcher = new ItemMatcher();
        matcher.build(name);
        ActivityManagerService N = this;
        synchronized (N) {
            for (ActivityRecord r1 : this.mMainStack.mHistory) {
                if (!matcher.match(r1, r1.intent.getComponent())) continue;
                activities.add(r1);
            }
        }
        if (activities.size() <= 0) {
            return false;
        }
        String[] newArgs = new String[args.length - opti];
        if (args.length > 2) {
            System.arraycopy(args, opti, newArgs, 0, args.length - opti);
        }
        TaskRecord lastTask = null;
        boolean needSep = false;
        for (int i = activities.size() - 1; i >= 0; --i) {
            ActivityRecord r = (ActivityRecord)activities.get(i);
            if (needSep) {
                pw.println();
            }
            needSep = true;
            ActivityManagerService activityManagerService2 = this;
            synchronized (activityManagerService2) {
                if (lastTask != r.task) {
                    lastTask = r.task;
                    pw.print("TASK ");
                    pw.print(lastTask.affinity);
                    pw.print(" id=");
                    pw.println(lastTask.taskId);
                    if (dumpAll) {
                        lastTask.dump(pw, "  ");
                    }
                }
            }
            this.dumpActivity("  ", fd, pw, (ActivityRecord)activities.get(i), newArgs, dumpAll);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpActivity(String prefix, FileDescriptor fd, PrintWriter pw, ActivityRecord r, String[] args, boolean dumpAll) {
        String innerPrefix = prefix + "  ";
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            pw.print(prefix);
            pw.print("ACTIVITY ");
            pw.print(r.shortComponentName);
            pw.print(" ");
            pw.print(Integer.toHexString(System.identityHashCode(r)));
            pw.print(" pid=");
            if (r.app != null) {
                pw.println(r.app.pid);
            } else {
                pw.println("(not running)");
            }
            if (dumpAll) {
                r.dump(pw, innerPrefix);
            }
        }
        if (r.app != null && r.app.thread != null) {
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpActivity(tp.getWriteFd().getFileDescriptor(), (IBinder)r.appToken, innerPrefix, args);
                    tp.go(fd);
                    Object var11_12 = null;
                    tp.kill();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    tp.kill();
                    throw throwable;
                }
            }
            catch (IOException e) {
                pw.println(innerPrefix + "Failure while dumping the activity: " + e);
            }
            catch (RemoteException e) {
                pw.println(innerPrefix + "Got a RemoteException while dumping the activity");
            }
        }
    }

    boolean dumpBroadcastsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        Object r2;
        boolean printed;
        boolean needSep = false;
        pw.println("ACTIVITY MANAGER BROADCAST STATE (dumpsys activity broadcasts)");
        if (dumpAll) {
            if (this.mRegisteredReceivers.size() > 0) {
                printed = false;
                for (Object r2 : this.mRegisteredReceivers.values()) {
                    if (dumpPackage != null && (((ReceiverList)r2).app == null || !dumpPackage.equals(((ReceiverList)r2).app.info.packageName))) continue;
                    if (!printed) {
                        pw.println("  Registered Receivers:");
                        needSep = true;
                        printed = true;
                    }
                    pw.print("  * ");
                    pw.println(r2);
                    ((ReceiverList)r2).dump(pw, "    ");
                }
            }
            if (this.mReceiverResolver.dump(pw, needSep ? "\n  Receiver Resolver Table:" : "  Receiver Resolver Table:", "    ", dumpPackage, false)) {
                needSep = true;
            }
        }
        if (this.mParallelBroadcasts.size() > 0 || this.mOrderedBroadcasts.size() > 0 || this.mPendingBroadcast != null) {
            BroadcastRecord br;
            int i;
            printed = false;
            for (i = this.mParallelBroadcasts.size() - 1; i >= 0; --i) {
                br = this.mParallelBroadcasts.get(i);
                if (dumpPackage != null && !dumpPackage.equals(br.callerPackage)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Active broadcasts:");
                }
                pw.println("  Broadcast #" + i + ":");
                br.dump(pw, "    ");
            }
            printed = false;
            for (i = this.mOrderedBroadcasts.size() - 1; i >= 0; --i) {
                br = this.mOrderedBroadcasts.get(i);
                if (dumpPackage != null && !dumpPackage.equals(br.callerPackage)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Active ordered broadcasts:");
                }
                pw.println("  Ordered Broadcast #" + i + ":");
                this.mOrderedBroadcasts.get(i).dump(pw, "    ");
            }
            if (dumpPackage == null || this.mPendingBroadcast != null && dumpPackage.equals(this.mPendingBroadcast.callerPackage)) {
                if (needSep) {
                    pw.println();
                }
                pw.println("  Pending broadcast:");
                if (this.mPendingBroadcast != null) {
                    this.mPendingBroadcast.dump(pw, "    ");
                } else {
                    pw.println("    (null)");
                }
                needSep = true;
            }
        }
        printed = false;
        for (int i = 0; i < 25 && (r2 = this.mBroadcastHistory[i]) != null; ++i) {
            if (dumpPackage != null && !dumpPackage.equals(((BroadcastRecord)((Object)r2)).callerPackage)) continue;
            if (!printed) {
                if (needSep) {
                    pw.println();
                }
                needSep = true;
                pw.println("  Historical broadcasts:");
                printed = true;
            }
            if (dumpAll) {
                pw.print("  Historical Broadcast #");
                pw.print(i);
                pw.println(":");
                ((BroadcastRecord)((Object)r2)).dump(pw, "    ");
                continue;
            }
            if (i >= 50) {
                pw.println("  ...");
                break;
            }
            pw.print("  #");
            pw.print(i);
            pw.print(": ");
            pw.println(r2);
        }
        needSep = true;
        if (this.mStickyBroadcasts != null && dumpPackage == null) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            pw.println("  Sticky broadcasts:");
            StringBuilder sb = new StringBuilder(128);
            for (Map.Entry<String, ArrayList<Intent>> ent : this.mStickyBroadcasts.entrySet()) {
                pw.print("  * Sticky action ");
                pw.print(ent.getKey());
                if (dumpAll) {
                    pw.println(":");
                    ArrayList<Intent> intents = ent.getValue();
                    int N = intents.size();
                    for (int i = 0; i < N; ++i) {
                        sb.setLength(0);
                        sb.append("    Intent: ");
                        intents.get(i).toShortString(sb, false, true, false);
                        pw.println(sb.toString());
                        Bundle bundle = intents.get(i).getExtras();
                        if (bundle == null) continue;
                        pw.print("      ");
                        pw.println(bundle.toString());
                    }
                    continue;
                }
                pw.println("");
            }
            needSep = true;
        }
        if (dumpAll) {
            pw.println();
            pw.println("  mBroadcastsScheduled=" + this.mBroadcastsScheduled);
            pw.println("  mHandler:");
            this.mHandler.dump((Printer)new PrintWriterPrinter(pw), "    ");
            needSep = true;
        }
        return needSep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dumpServicesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        boolean printed;
        boolean needSep = false;
        ItemMatcher matcher = new ItemMatcher();
        matcher.build(args, opti);
        pw.println("ACTIVITY MANAGER SERVICES (dumpsys activity services)");
        if (this.mServices.size() > 0) {
            printed = false;
            long nowReal = SystemClock.elapsedRealtime();
            Iterator<ServiceRecord> it = this.mServices.values().iterator();
            needSep = false;
            while (it.hasNext()) {
                ServiceRecord r2 = it.next();
                if (!matcher.match((Object)r2, r2.name) || dumpPackage != null && !dumpPackage.equals(r2.appInfo.packageName)) continue;
                if (!printed) {
                    pw.println("  Active services:");
                    printed = true;
                }
                if (needSep) {
                    pw.println();
                }
                pw.print("  * ");
                pw.println((Object)r2);
                if (dumpAll) {
                    r2.dump(pw, "    ");
                    needSep = true;
                } else {
                    pw.print("    app=");
                    pw.println(r2.app);
                    pw.print("    created=");
                    TimeUtils.formatDuration((long)r2.createTime, (long)nowReal, (PrintWriter)pw);
                    pw.print(" started=");
                    pw.print(r2.startRequested);
                    pw.print(" connections=");
                    pw.println(r2.connections.size());
                    if (r2.connections.size() > 0) {
                        pw.println("    Connections:");
                        for (ArrayList<ConnectionRecord> clist : r2.connections.values()) {
                            for (int i = 0; i < clist.size(); ++i) {
                                ConnectionRecord conn = clist.get(i);
                                pw.print("      ");
                                pw.print(conn.binding.intent.intent.getIntent().toShortString(false, false, false));
                                pw.print(" -> ");
                                ProcessRecord proc = conn.binding.client;
                                pw.println(proc != null ? proc.toShortString() : "null");
                            }
                        }
                    }
                }
                if (!dumpClient || r2.app == null || r2.app.thread == null) continue;
                pw.println("    Client:");
                pw.flush();
                try {
                    Object var21_26;
                    TransferPipe tp = new TransferPipe();
                    try {
                        r2.app.thread.dumpService(tp.getWriteFd().getFileDescriptor(), (IBinder)r2, args);
                        tp.setBufferPrefix("      ");
                        tp.go(fd, 2000L);
                        var21_26 = null;
                        tp.kill();
                    }
                    catch (Throwable throwable) {
                        var21_26 = null;
                        tp.kill();
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    pw.println("      Failure while dumping the service: " + e);
                }
                catch (RemoteException e) {
                    pw.println("      Got a RemoteException while dumping the service");
                }
                needSep = true;
            }
            needSep = printed;
        }
        if (this.mPendingServices.size() > 0) {
            printed = false;
            for (int i = 0; i < this.mPendingServices.size(); ++i) {
                ServiceRecord serviceRecord = this.mPendingServices.get(i);
                if (!matcher.match((Object)serviceRecord, serviceRecord.name) || dumpPackage != null && !dumpPackage.equals(serviceRecord.appInfo.packageName)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println(" ");
                    }
                    needSep = true;
                    pw.println("  Pending services:");
                    printed = true;
                }
                pw.print("  * Pending ");
                pw.println((Object)serviceRecord);
                serviceRecord.dump(pw, "    ");
            }
            needSep = true;
        }
        if (this.mRestartingServices.size() > 0) {
            printed = false;
            for (int i = 0; i < this.mRestartingServices.size(); ++i) {
                ServiceRecord serviceRecord = this.mRestartingServices.get(i);
                if (!matcher.match((Object)serviceRecord, serviceRecord.name) || dumpPackage != null && !dumpPackage.equals(serviceRecord.appInfo.packageName)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println(" ");
                    }
                    needSep = true;
                    pw.println("  Restarting services:");
                    printed = true;
                }
                pw.print("  * Restarting ");
                pw.println((Object)serviceRecord);
                serviceRecord.dump(pw, "    ");
            }
            needSep = true;
        }
        if (this.mStoppingServices.size() > 0) {
            printed = false;
            for (int i = 0; i < this.mStoppingServices.size(); ++i) {
                ServiceRecord serviceRecord = this.mStoppingServices.get(i);
                if (!matcher.match((Object)serviceRecord, serviceRecord.name) || dumpPackage != null && !dumpPackage.equals(serviceRecord.appInfo.packageName)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println(" ");
                    }
                    needSep = true;
                    pw.println("  Stopping services:");
                    printed = true;
                }
                pw.print("  * Stopping ");
                pw.println((Object)serviceRecord);
                serviceRecord.dump(pw, "    ");
            }
            needSep = true;
        }
        if (dumpAll && this.mServiceConnections.size() > 0) {
            printed = false;
            for (ArrayList<ConnectionRecord> arrayList : this.mServiceConnections.values()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ConnectionRecord cr = arrayList.get(i);
                    if (!matcher.match((Object)cr.binding.service, cr.binding.service.name) || dumpPackage != null && (cr.binding.client == null || !dumpPackage.equals(cr.binding.client.info.packageName))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println(" ");
                        }
                        needSep = true;
                        pw.println("  Connection bindings to services:");
                        printed = true;
                    }
                    pw.print("  * ");
                    pw.println(cr);
                    cr.dump(pw, "    ");
                }
            }
            needSep = true;
        }
        return needSep;
    }

    boolean dumpProvidersLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        ContentProviderRecord r;
        boolean printed;
        boolean needSep = false;
        ItemMatcher matcher = new ItemMatcher();
        matcher.build(args, opti);
        pw.println("ACTIVITY MANAGER CONTENT PROVIDERS (dumpsys activity providers)");
        if (this.mProvidersByClass.size() > 0) {
            printed = false;
            for (Map.Entry<ComponentName, ContentProviderRecord> entry : this.mProvidersByClass.entrySet()) {
                r = entry.getValue();
                ComponentName comp = entry.getKey();
                String cls = comp.getClassName();
                int end = cls.lastIndexOf(46);
                if (end > 0 && end < cls.length() - 2) {
                    cls = cls.substring(end + 1);
                }
                if (!matcher.match((Object)r, comp) || dumpPackage != null && !dumpPackage.equals(comp.getPackageName())) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println(" ");
                    }
                    needSep = true;
                    pw.println("  Published content providers (by class):");
                    printed = true;
                }
                pw.print("  * ");
                pw.print(cls);
                pw.print(" (");
                pw.print(comp.flattenToShortString());
                pw.println(")");
                if (dumpAll) {
                    r.dump(pw, "      ");
                    continue;
                }
                if (r.proc != null) {
                    pw.print("      ");
                    pw.println(r.proc);
                } else {
                    pw.println();
                }
                if (r.clients.size() <= 0) continue;
                pw.println("      Clients:");
                for (ProcessRecord cproc : r.clients) {
                    pw.print("        - ");
                    pw.println(cproc);
                }
            }
        }
        if (dumpAll && this.mProvidersByName.size() > 0) {
            printed = false;
            for (Map.Entry<Object, ContentProviderRecord> entry : this.mProvidersByName.entrySet()) {
                r = entry.getValue();
                if (!matcher.match((Object)r, r.name) || dumpPackage != null && !dumpPackage.equals(r.name.getPackageName())) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println(" ");
                    }
                    needSep = true;
                    pw.println("  Authority to provider mappings:");
                    printed = true;
                }
                pw.print("  ");
                pw.print((String)entry.getKey());
                pw.println(":");
                pw.print("    ");
                pw.println((Object)r);
            }
        }
        if (this.mLaunchingProviders.size() > 0) {
            printed = false;
            for (int i = this.mLaunchingProviders.size() - 1; i >= 0; --i) {
                ContentProviderRecord contentProviderRecord = this.mLaunchingProviders.get(i);
                if (dumpPackage != null && !dumpPackage.equals(contentProviderRecord.name.getPackageName())) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println(" ");
                    }
                    needSep = true;
                    pw.println("  Launching content providers:");
                    printed = true;
                }
                pw.print("  Launching #");
                pw.print(i);
                pw.print(": ");
                pw.println((Object)contentProviderRecord);
            }
        }
        if (this.mGrantedUriPermissions.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            pw.println("Granted Uri Permissions:");
            for (int i = 0; i < this.mGrantedUriPermissions.size(); ++i) {
                int uid = this.mGrantedUriPermissions.keyAt(i);
                HashMap hashMap = (HashMap)this.mGrantedUriPermissions.valueAt(i);
                pw.print("  * UID ");
                pw.print(uid);
                pw.println(" holds:");
                for (UriPermission perm : hashMap.values()) {
                    pw.print("    ");
                    pw.println(perm);
                    if (!dumpAll) continue;
                    perm.dump(pw, "      ");
                }
            }
            needSep = true;
        }
        return needSep;
    }

    boolean dumpPendingIntentsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean needSep = false;
        if (this.mIntentSenderRecords.size() > 0) {
            boolean printed = false;
            for (WeakReference<PendingIntentRecord> ref : this.mIntentSenderRecords.values()) {
                PendingIntentRecord rec;
                PendingIntentRecord pendingIntentRecord = rec = ref != null ? (PendingIntentRecord)((Object)ref.get()) : null;
                if (dumpPackage != null && (rec == null || !dumpPackage.equals(rec.key.packageName))) continue;
                if (!printed) {
                    pw.println("ACTIVITY MANAGER PENDING INTENTS (dumpsys activity intents)");
                    printed = true;
                }
                needSep = true;
                if (rec != null) {
                    pw.print("  * ");
                    pw.println((Object)rec);
                    if (!dumpAll) continue;
                    rec.dump(pw, "    ");
                    continue;
                }
                pw.print("  * ");
                pw.println(ref);
            }
        }
        return needSep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void dumpHistoryList(FileDescriptor fd, PrintWriter pw, List list, String prefix, String label, boolean complete, boolean brief, boolean client, String dumpPackage) {
        TaskRecord lastTask = null;
        boolean needNL = false;
        String innerPrefix = prefix + "      ";
        String[] args = new String[]{};
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean full;
            ActivityRecord r = (ActivityRecord)list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.packageName)) continue;
            boolean bl = full = !brief && (complete || !r.isInHistory());
            if (needNL) {
                pw.println(" ");
                needNL = false;
            }
            if (lastTask != r.task) {
                lastTask = r.task;
                pw.print(prefix);
                pw.print(full ? "* " : "  ");
                pw.println(lastTask);
                if (full) {
                    lastTask.dump(pw, prefix + "  ");
                } else if (complete && lastTask.intent != null) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(lastTask.intent.toInsecureString());
                }
            }
            pw.print(prefix);
            pw.print(full ? "  * " : "    ");
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(r);
            if (full) {
                r.dump(pw, innerPrefix);
            } else if (complete) {
                pw.print(innerPrefix);
                pw.println(r.intent.toInsecureString());
                if (r.app != null) {
                    pw.print(innerPrefix);
                    pw.println(r.app);
                }
            }
            if (!client || r.app == null || r.app.thread == null) continue;
            pw.flush();
            try {
                Object var18_19;
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpActivity(tp.getWriteFd().getFileDescriptor(), (IBinder)r.appToken, innerPrefix, args);
                    tp.go(fd, 2000L);
                    var18_19 = null;
                    tp.kill();
                }
                catch (Throwable throwable) {
                    var18_19 = null;
                    tp.kill();
                    throw throwable;
                }
            }
            catch (IOException e) {
                pw.println(innerPrefix + "Failure while dumping the activity: " + e);
            }
            catch (RemoteException e) {
                pw.println(innerPrefix + "Got a RemoteException while dumping the activity");
            }
            needNL = true;
        }
    }

    private static String buildOomTag(String prefix, String space, int val, int base) {
        if (val == base) {
            if (space == null) {
                return prefix;
            }
            return prefix + "  ";
        }
        return prefix + "+" + Integer.toString(val - base);
    }

    private static final int dumpProcessList(PrintWriter pw, ActivityManagerService service, List list, String prefix, String normalLabel, String persistentLabel, String dumpPackage) {
        int N;
        int numPers = 0;
        for (int i = N = list.size() - 1; i >= 0; --i) {
            ProcessRecord r = (ProcessRecord)list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.info.packageName)) continue;
            pw.println(String.format("%s%s #%2d: %s", prefix, r.persistent ? persistentLabel : normalLabel, i, r.toString()));
            if (!r.persistent) continue;
            ++numPers;
        }
        return numPers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean dumpProcessOomList(PrintWriter pw, ActivityManagerService service, List<ProcessRecord> origList, String prefix, String normalLabel, String persistentLabel, boolean inclDetails, String dumpPackage) {
        ArrayList<Pair> list = new ArrayList<Pair>(origList.size());
        for (int i = 0; i < origList.size(); ++i) {
            ProcessRecord r = origList.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.info.packageName)) continue;
            list.add(new Pair((Object)origList.get(i), (Object)i));
        }
        if (list.size() <= 0) {
            return false;
        }
        Comparator<Pair<ProcessRecord, Integer>> comparator = new Comparator<Pair<ProcessRecord, Integer>>(){

            @Override
            public int compare(Pair<ProcessRecord, Integer> object1, Pair<ProcessRecord, Integer> object2) {
                if (((ProcessRecord)object1.first).setAdj != ((ProcessRecord)object2.first).setAdj) {
                    return ((ProcessRecord)object1.first).setAdj > ((ProcessRecord)object2.first).setAdj ? -1 : 1;
                }
                if (((Integer)object1.second).intValue() != ((Integer)object2.second).intValue()) {
                    return (Integer)object1.second > (Integer)object2.second ? -1 : 1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
        long curRealtime = SystemClock.elapsedRealtime();
        long realtimeSince = curRealtime - service.mLastPowerCheckRealtime;
        long curUptime = SystemClock.uptimeMillis();
        long uptimeSince = curUptime - service.mLastPowerCheckUptime;
        for (int i = list.size() - 1; i >= 0; --i) {
            String schedGroup;
            ProcessRecord r = (ProcessRecord)((Pair)list.get((int)i)).first;
            String oomAdj = r.setAdj >= ProcessList.HIDDEN_APP_MIN_ADJ ? ActivityManagerService.buildOomTag("bak", "  ", r.setAdj, ProcessList.HIDDEN_APP_MIN_ADJ) : (r.setAdj >= 8 ? ActivityManagerService.buildOomTag("svcb ", null, r.setAdj, 8) : (r.setAdj >= 7 ? ActivityManagerService.buildOomTag("prev ", null, r.setAdj, 7) : (r.setAdj >= 6 ? ActivityManagerService.buildOomTag("home ", null, r.setAdj, 6) : (r.setAdj >= 5 ? ActivityManagerService.buildOomTag("svc  ", null, r.setAdj, 5) : (r.setAdj >= 4 ? ActivityManagerService.buildOomTag("bkup ", null, r.setAdj, 4) : (r.setAdj >= 3 ? ActivityManagerService.buildOomTag("hvy  ", null, r.setAdj, 3) : (r.setAdj >= 2 ? ActivityManagerService.buildOomTag("prcp ", null, r.setAdj, 2) : (r.setAdj >= 1 ? ActivityManagerService.buildOomTag("vis  ", null, r.setAdj, 1) : (r.setAdj >= 0 ? ActivityManagerService.buildOomTag("fore ", null, r.setAdj, 0) : (r.setAdj >= -12 ? ActivityManagerService.buildOomTag("pers ", null, r.setAdj, -12) : (r.setAdj >= -16 ? ActivityManagerService.buildOomTag("sys  ", null, r.setAdj, -16) : Integer.toString(r.setAdj))))))))))));
            switch (r.setSchedGroup) {
                case 1: {
                    schedGroup = "B";
                    break;
                }
                case 0: {
                    schedGroup = "F";
                    break;
                }
                default: {
                    schedGroup = Integer.toString(r.setSchedGroup);
                }
            }
            String foreground = r.foregroundActivities ? "A" : (r.foregroundServices ? "S" : " ");
            pw.println(String.format("%s%s #%2d: adj=%s/%s%s trm=%2d %s (%s)", prefix, r.persistent ? persistentLabel : normalLabel, origList.size() - 1 - (Integer)((Pair)list.get((int)i)).second, oomAdj, schedGroup, foreground, r.trimMemoryLevel, r.toShortString(), r.adjType));
            if (r.adjSource != null || r.adjTarget != null) {
                pw.print(prefix);
                pw.print("    ");
                if (r.adjTarget instanceof ComponentName) {
                    pw.print(((ComponentName)r.adjTarget).flattenToShortString());
                } else if (r.adjTarget != null) {
                    pw.print(r.adjTarget.toString());
                } else {
                    pw.print("{null}");
                }
                pw.print("<=");
                if (r.adjSource instanceof ProcessRecord) {
                    pw.print("Proc{");
                    pw.print(((ProcessRecord)r.adjSource).toShortString());
                    pw.println("}");
                } else if (r.adjSource != null) {
                    pw.println(r.adjSource.toString());
                } else {
                    pw.println("{null}");
                }
            }
            if (!inclDetails) continue;
            pw.print(prefix);
            pw.print("    ");
            pw.print("oom: max=");
            pw.print(r.maxAdj);
            pw.print(" hidden=");
            pw.print(r.hiddenAdj);
            pw.print(" curRaw=");
            pw.print(r.curRawAdj);
            pw.print(" setRaw=");
            pw.print(r.setRawAdj);
            pw.print(" cur=");
            pw.print(r.curAdj);
            pw.print(" set=");
            pw.println(r.setAdj);
            pw.print(prefix);
            pw.print("    ");
            pw.print("keeping=");
            pw.print(r.keeping);
            pw.print(" hidden=");
            pw.print(r.hidden);
            pw.print(" empty=");
            pw.print(r.empty);
            pw.print(" hasAboveClient=");
            pw.println(r.hasAboveClient);
            if (r.keeping) continue;
            if (r.lastWakeTime != 0L) {
                long wtime;
                BatteryStatsImpl stats;
                BatteryStatsImpl batteryStatsImpl = stats = service.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    wtime = stats.getProcessWakeTime(r.info.uid, r.pid, curRealtime);
                }
                long timeUsed = wtime - r.lastWakeTime;
                pw.print(prefix);
                pw.print("    ");
                pw.print("keep awake over ");
                TimeUtils.formatDuration((long)realtimeSince, (PrintWriter)pw);
                pw.print(" used ");
                TimeUtils.formatDuration((long)timeUsed, (PrintWriter)pw);
                pw.print(" (");
                pw.print(timeUsed * 100L / realtimeSince);
                pw.println("%)");
            }
            if (r.lastCpuTime == 0L) continue;
            long timeUsed = r.curCpuTime - r.lastCpuTime;
            pw.print(prefix);
            pw.print("    ");
            pw.print("run cpu over ");
            TimeUtils.formatDuration((long)uptimeSince, (PrintWriter)pw);
            pw.print(" used ");
            TimeUtils.formatDuration((long)timeUsed, (PrintWriter)pw);
            pw.print(" (");
            pw.print(timeUsed * 100L / uptimeSince);
            pw.println("%)");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<ProcessRecord> collectProcesses(PrintWriter pw, int start, String[] args) {
        ArrayList<ProcessRecord> procs;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (args != null && args.length > start && args[start].charAt(0) != '-') {
                procs = new ArrayList();
                int pid = -1;
                try {
                    pid = Integer.parseInt(args[start]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                    ProcessRecord proc = this.mLruProcesses.get(i);
                    if (proc.pid == pid) {
                        procs.add(proc);
                        continue;
                    }
                    if (!proc.processName.equals(args[start])) continue;
                    procs.add(proc);
                }
                if (procs.size() <= 0) {
                    pw.println("No process found for: " + args[start]);
                    return null;
                }
            } else {
                procs = new ArrayList<ProcessRecord>(this.mLruProcesses);
            }
        }
        return procs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpGraphicsHardwareUsage(FileDescriptor fd, PrintWriter pw, String[] args) {
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, 0, args);
        if (procs == null) {
            return;
        }
        long uptime = SystemClock.uptimeMillis();
        long realtime = SystemClock.elapsedRealtime();
        pw.println("Applications Graphics Acceleration Info:");
        pw.println("Uptime: " + uptime + " Realtime: " + realtime);
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessRecord r = procs.get(i);
            if (r.thread == null) continue;
            pw.println("\n** Graphics info for pid " + r.pid + " [" + r.processName + "] **");
            pw.flush();
            try {
                Object var13_12;
                TransferPipe tp = new TransferPipe();
                try {
                    r.thread.dumpGfxInfo(tp.getWriteFd().getFileDescriptor(), args);
                    tp.go(fd);
                    var13_12 = null;
                    tp.kill();
                    continue;
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    tp.kill();
                    throw throwable;
                }
            }
            catch (IOException e) {
                pw.println("Failure while dumping the app: " + r);
                pw.flush();
                continue;
            }
            catch (RemoteException e) {
                pw.println("Got a RemoteException while dumping the app " + r);
                pw.flush();
            }
        }
    }

    static final void dumpMemItems(PrintWriter pw, String prefix, ArrayList<MemItem> items, boolean sort) {
        if (sort) {
            Collections.sort(items, new Comparator<MemItem>(){

                @Override
                public int compare(MemItem lhs, MemItem rhs) {
                    if (lhs.pss < rhs.pss) {
                        return 1;
                    }
                    if (lhs.pss > rhs.pss) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        for (int i = 0; i < items.size(); ++i) {
            MemItem mi = items.get(i);
            pw.print(prefix);
            pw.printf("%7d kB: ", mi.pss);
            pw.println(mi.label);
            if (mi.subitems == null) continue;
            ActivityManagerService.dumpMemItems(pw, prefix + "           ", mi.subitems, true);
        }
    }

    static final void appendMemBucket(StringBuilder out, long memKB, String label, boolean stackLike) {
        int start = label.lastIndexOf(46);
        start = start >= 0 ? ++start : 0;
        int end = label.length();
        for (int i = 0; i < DUMP_MEM_BUCKETS.length; ++i) {
            if (DUMP_MEM_BUCKETS[i] < memKB) continue;
            long bucket = DUMP_MEM_BUCKETS[i] / 1024L;
            out.append(bucket);
            out.append(stackLike ? "MB." : "MB ");
            out.append(label, start, end);
            return;
        }
        out.append(memKB / 1024L);
        out.append(stackLike ? "MB." : "MB ");
        out.append(label, start, end);
    }

    final void dumpApplicationMemoryUsage(FileDescriptor fd, PrintWriter pw, String prefix, String[] args, boolean brief, PrintWriter categoryPw, StringBuilder outTag, StringBuilder outStack) {
        String opt;
        int opti;
        boolean dumpAll = false;
        boolean oomOnly = false;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpAll = true;
                continue;
            }
            if ("--oom".equals(opt)) {
                oomOnly = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("meminfo dump options: [-a] [--oom] [process]");
                pw.println("  -a: include all available information for each process.");
                pw.println("  --oom: only show processes organized by oom adj.");
                pw.println("If [process] is specified it can be the name or ");
                pw.println("pid of a specific process to dump.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, opti, args);
        if (procs == null) {
            return;
        }
        boolean isCheckinRequest = ActivityManagerService.scanArgs(args, "--checkin");
        long uptime = SystemClock.uptimeMillis();
        long realtime = SystemClock.elapsedRealtime();
        if (procs.size() == 1 || isCheckinRequest) {
            dumpAll = true;
        }
        if (isCheckinRequest) {
            pw.println(uptime + "," + realtime);
            pw.flush();
        } else {
            pw.println("Applications Memory Usage (kB):");
            pw.println("Uptime: " + uptime + " Realtime: " + realtime);
        }
        String[] innerArgs = new String[args.length - opti];
        System.arraycopy(args, opti, innerArgs, 0, args.length - opti);
        ArrayList<MemItem> procMems = new ArrayList<MemItem>();
        long nativePss = 0L;
        long dalvikPss = 0L;
        long otherPss = 0L;
        long[] miscPss = new long[9];
        long[] oomPss = new long[DUMP_MEM_OOM_LABEL.length];
        ArrayList[] oomProcs = new ArrayList[DUMP_MEM_OOM_LABEL.length];
        long totalPss = 0L;
        block3: for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessRecord r = procs.get(i);
            if (r.thread == null) continue;
            if (!isCheckinRequest && dumpAll) {
                pw.println("\n** MEMINFO in pid " + r.pid + " [" + r.processName + "] **");
                pw.flush();
            }
            Debug.MemoryInfo mi = null;
            if (dumpAll) {
                try {
                    mi = r.thread.dumpMemInfo(fd, isCheckinRequest, dumpAll, innerArgs);
                }
                catch (RemoteException e) {
                    if (!isCheckinRequest) {
                        pw.println("Got RemoteException!");
                        pw.flush();
                    }
                }
            } else {
                mi = new Debug.MemoryInfo();
                Debug.getMemoryInfo((int)r.pid, (Debug.MemoryInfo)mi);
            }
            if (isCheckinRequest || mi == null) continue;
            long myTotalPss = mi.getTotalPss();
            totalPss += myTotalPss;
            MemItem pssItem = new MemItem(r.processName + " (pid " + r.pid + ")", r.processName, myTotalPss, 0);
            procMems.add(pssItem);
            nativePss += (long)mi.nativePss;
            dalvikPss += (long)mi.dalvikPss;
            otherPss += (long)mi.otherPss;
            int j = 0;
            while (j < 9) {
                long mem = mi.getOtherPss(j);
                int n = j++;
                miscPss[n] = miscPss[n] + mem;
                otherPss -= mem;
            }
            for (int oomIndex = 0; oomIndex < oomPss.length; ++oomIndex) {
                if (r.setAdj > DUMP_MEM_OOM_ADJ[oomIndex] && oomIndex != oomPss.length - 1) continue;
                int n = oomIndex;
                oomPss[n] = oomPss[n] + myTotalPss;
                if (oomProcs[oomIndex] == null) {
                    oomProcs[oomIndex] = new ArrayList();
                }
                oomProcs[oomIndex].add(pssItem);
                continue block3;
            }
        }
        if (!isCheckinRequest && procs.size() > 1) {
            ArrayList<MemItem> catMems = new ArrayList<MemItem>();
            catMems.add(new MemItem("Native", "Native", nativePss, -1));
            catMems.add(new MemItem("Dalvik", "Dalvik", dalvikPss, -2));
            catMems.add(new MemItem("Unknown", "Unknown", otherPss, -3));
            for (int j = 0; j < 9; ++j) {
                String label = Debug.MemoryInfo.getOtherLabel((int)j);
                catMems.add(new MemItem(label, label, miscPss[j], j));
            }
            ArrayList<MemItem> oomMems = new ArrayList<MemItem>();
            for (int j = 0; j < oomPss.length; ++j) {
                if (oomPss[j] == 0L) continue;
                String label = DUMP_MEM_OOM_LABEL[j];
                MemItem item = new MemItem(label, label, oomPss[j], DUMP_MEM_OOM_ADJ[j]);
                item.subitems = oomProcs[j];
                oomMems.add(item);
            }
            if (outTag != null || outStack != null) {
                if (outTag != null) {
                    ActivityManagerService.appendMemBucket(outTag, totalPss, "total", false);
                }
                if (outStack != null) {
                    ActivityManagerService.appendMemBucket(outStack, totalPss, "total", true);
                }
                boolean firstLine = true;
                for (int i = 0; i < oomMems.size(); ++i) {
                    MemItem miCat = oomMems.get(i);
                    if (miCat.subitems == null || miCat.subitems.size() < 1 || miCat.id >= 5 && miCat.id != 6 && miCat.id != 7) continue;
                    if (outTag != null && miCat.id <= 0) {
                        outTag.append(" / ");
                    }
                    if (outStack != null) {
                        if (miCat.id >= 0) {
                            if (firstLine) {
                                outStack.append(":");
                                firstLine = false;
                            }
                            outStack.append("\n\t at ");
                        } else {
                            outStack.append("$");
                        }
                    }
                    for (int j = 0; j < miCat.subitems.size(); ++j) {
                        MemItem mi = miCat.subitems.get(j);
                        if (j > 0) {
                            if (outTag != null) {
                                outTag.append(" ");
                            }
                            if (outStack != null) {
                                outStack.append("$");
                            }
                        }
                        if (outTag != null && miCat.id <= 0) {
                            ActivityManagerService.appendMemBucket(outTag, mi.pss, mi.shortLabel, false);
                        }
                        if (outStack == null) continue;
                        ActivityManagerService.appendMemBucket(outStack, mi.pss, mi.shortLabel, true);
                    }
                    if (outStack == null || miCat.id < 0) continue;
                    outStack.append("(");
                    for (int k = 0; k < DUMP_MEM_OOM_ADJ.length; ++k) {
                        if (DUMP_MEM_OOM_ADJ[k] != miCat.id) continue;
                        outStack.append(DUMP_MEM_OOM_LABEL[k]);
                        outStack.append(":");
                        outStack.append(DUMP_MEM_OOM_ADJ[k]);
                    }
                    outStack.append(")");
                }
            }
            if (!brief && !oomOnly) {
                pw.println();
                pw.println("Total PSS by process:");
                ActivityManagerService.dumpMemItems(pw, "  ", procMems, true);
                pw.println();
            }
            pw.println("Total PSS by OOM adjustment:");
            ActivityManagerService.dumpMemItems(pw, "  ", oomMems, false);
            if (!oomOnly) {
                PrintWriter out = categoryPw != null ? categoryPw : pw;
                out.println();
                out.println("Total PSS by category:");
                ActivityManagerService.dumpMemItems(out, "  ", catMems, true);
            }
            pw.println();
            pw.print("Total PSS: ");
            pw.print(totalPss);
            pw.println(" kB");
        }
    }

    private static boolean scanArgs(String[] args, String value) {
        if (args != null) {
            for (String arg : args) {
                if (!value.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void killServicesLocked(ProcessRecord app, boolean allowRestart) {
        if (app.connections.size() > 0) {
            for (ConnectionRecord r : app.connections) {
                this.removeConnectionLocked(r, app, null);
            }
        }
        app.connections.clear();
        if (app.services.size() != 0) {
            for (ServiceRecord sr : app.services) {
                boolean hasClients;
                BatteryStatsImpl batteryStatsImpl = sr.stats.getBatteryStats();
                synchronized (batteryStatsImpl) {
                    sr.stats.stopLaunchedLocked();
                }
                sr.app = null;
                sr.executeNesting = 0;
                if (this.mStoppingServices.remove((Object)sr)) {
                    // empty if block
                }
                boolean bl = hasClients = sr.bindings.size() > 0;
                if (hasClients) {
                    for (IntentBindRecord b : sr.bindings.values()) {
                        b.binder = null;
                        b.hasBound = false;
                        b.received = false;
                        b.requested = false;
                    }
                }
                if (sr.crashCount >= 2 && (sr.serviceInfo.applicationInfo.flags & 8) == 0) {
                    Slog.w((String)TAG, (String)("Service crashed " + sr.crashCount + " times, stopping: " + (Object)((Object)sr)));
                    EventLog.writeEvent((int)30034, (Object[])new Object[]{sr.crashCount, sr.shortName, app.pid});
                    this.bringDownServiceLocked(sr, true);
                    continue;
                }
                if (!allowRestart) {
                    this.bringDownServiceLocked(sr, true);
                    continue;
                }
                boolean canceled = this.scheduleServiceRestartLocked(sr, true);
                if (!sr.startRequested || !sr.stopIfKilled && !canceled || sr.pendingStarts.size() != 0) continue;
                sr.startRequested = false;
                if (hasClients) continue;
                this.bringDownServiceLocked(sr, true);
            }
            if (!allowRestart) {
                app.services.clear();
            }
        }
        int i = this.mStoppingServices.size();
        while (i > 0) {
            ServiceRecord sr;
            sr = this.mStoppingServices.get(--i);
            if (sr.app != app) continue;
            this.mStoppingServices.remove(i);
        }
        app.executingServices.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDyingProviderLocked(ProcessRecord proc, ContentProviderRecord cpr) {
        ContentProviderRecord contentProviderRecord = cpr;
        synchronized (contentProviderRecord) {
            cpr.launchingApp = null;
            ((Object)((Object)cpr)).notifyAll();
        }
        this.mProvidersByClass.remove(cpr.name);
        String[] names = cpr.info.authority.split(";");
        for (int j = 0; j < names.length; ++j) {
            this.mProvidersByName.remove(names[j]);
        }
        for (ProcessRecord capp : cpr.clients) {
            if (capp.persistent || capp.thread == null || capp.pid == 0 || capp.pid == MY_PID) continue;
            Slog.i((String)TAG, (String)("Kill " + capp.processName + " (pid " + capp.pid + "): provider " + cpr.info.name + " in dying process " + (proc != null ? proc.processName : "??")));
            EventLog.writeEvent((int)30023, (Object[])new Object[]{capp.pid, capp.processName, capp.setAdj, "dying provider " + cpr.name.toShortString()});
            android.os.Process.killProcessQuiet((int)capp.pid);
        }
        this.mLaunchingProviders.remove((Object)cpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanUpApplicationRecordLocked(ProcessRecord app, boolean restarting, boolean allowRestart, int index) {
        if (index >= 0) {
            this.mLruProcesses.remove(index);
        }
        this.mProcessesToGc.remove(app);
        if (app.crashDialog != null) {
            app.crashDialog.dismiss();
            app.crashDialog = null;
        }
        if (app.anrDialog != null) {
            app.anrDialog.dismiss();
            app.anrDialog = null;
        }
        if (app.waitDialog != null) {
            app.waitDialog.dismiss();
            app.waitDialog = null;
        }
        app.crashing = false;
        app.notResponding = false;
        app.resetPackageList();
        app.unlinkDeathRecipient();
        app.thread = null;
        app.forcingToForeground = null;
        app.foregroundServices = false;
        app.foregroundActivities = false;
        app.hasShownUi = false;
        app.hasAboveClient = false;
        this.killServicesLocked(app, allowRestart);
        boolean restart = false;
        int NL = this.mLaunchingProviders.size();
        if (!app.pubProviders.isEmpty()) {
            for (ContentProviderRecord cpr : app.pubProviders.values()) {
                int i;
                cpr.provider = null;
                cpr.proc = null;
                if (!app.bad && allowRestart) {
                    for (i = 0; i < NL; ++i) {
                        if (this.mLaunchingProviders.get(i) != cpr) continue;
                        restart = true;
                        break;
                    }
                } else {
                    i = NL;
                }
                if (i < NL) continue;
                this.removeDyingProviderLocked(app, cpr);
                NL = this.mLaunchingProviders.size();
            }
            app.pubProviders.clear();
        }
        if (this.checkAppInLaunchingProvidersLocked(app, false)) {
            restart = true;
        }
        if (!app.conProviders.isEmpty()) {
            for (ContentProviderRecord cpr : app.conProviders.keySet()) {
                cpr.clients.remove(app);
            }
            app.conProviders.clear();
        }
        this.skipCurrentReceiverLocked(app);
        if (app.receivers.size() > 0) {
            Iterator<Object> it = app.receivers.iterator();
            while (it.hasNext()) {
                this.removeReceiverLocked((ReceiverList)it.next());
            }
            app.receivers.clear();
        }
        if (this.mBackupTarget != null && app.pid == this.mBackupTarget.app.pid) {
            try {
                IBackupManager bm = IBackupManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"backup"));
                bm.agentDisconnected(app.info.packageName);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        this.mHandler.obtainMessage(32, app.pid, app.info.uid, null).sendToTarget();
        if (restarting) {
            return;
        }
        if (!app.persistent) {
            this.mProcessNames.remove(app.processName, app.info.uid);
            if (this.mHeavyWeightProcess == app) {
                this.mHeavyWeightProcess = null;
                this.mHandler.sendEmptyMessage(25);
            }
        } else if (!app.removed && this.mPersistentStartingProcesses.indexOf(app) < 0) {
            this.mPersistentStartingProcesses.add(app);
            restart = true;
        }
        this.mProcessesOnHold.remove(app);
        if (app == this.mHomeProcess) {
            this.mHomeProcess = null;
        }
        if (app == this.mPreviousProcess) {
            this.mPreviousProcess = null;
        }
        if (restart) {
            this.mProcessNames.put(app.processName, app.info.uid, app);
            this.startProcessLocked(app, "restart", app.processName);
        } else if (app.pid > 0 && app.pid != MY_PID) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(app.pid);
                this.mHandler.removeMessages(20, (Object)app);
            }
            app.setPid(0);
        }
    }

    boolean checkAppInLaunchingProvidersLocked(ProcessRecord app, boolean alwaysBad) {
        int NL = this.mLaunchingProviders.size();
        boolean restart = false;
        for (int i = 0; i < NL; ++i) {
            ContentProviderRecord cpr = this.mLaunchingProviders.get(i);
            if (cpr.launchingApp != app) continue;
            if (!alwaysBad && !app.bad) {
                restart = true;
                continue;
            }
            this.removeDyingProviderLocked(app, cpr);
            NL = this.mLaunchingProviders.size();
        }
        return restart;
    }

    ActivityManager.RunningServiceInfo makeRunningServiceInfoLocked(ServiceRecord r) {
        ActivityManager.RunningServiceInfo info = new ActivityManager.RunningServiceInfo();
        info.service = r.name;
        if (r.app != null) {
            info.pid = r.app.pid;
        }
        info.uid = r.appInfo.uid;
        info.process = r.processName;
        info.foreground = r.isForeground;
        info.activeSince = r.createTime;
        info.started = r.startRequested;
        info.clientCount = r.connections.size();
        info.crashCount = r.crashCount;
        info.lastActivityTime = r.lastActivity;
        if (r.isForeground) {
            info.flags |= 2;
        }
        if (r.startRequested) {
            info.flags |= 1;
        }
        if (r.app != null && r.app.pid == MY_PID) {
            info.flags |= 4;
        }
        if (r.app != null && r.app.persistent) {
            info.flags |= 8;
        }
        for (ArrayList<ConnectionRecord> connl : r.connections.values()) {
            for (int i = 0; i < connl.size(); ++i) {
                ConnectionRecord conn = connl.get(i);
                if (conn.clientLabel == 0) continue;
                info.clientPackage = conn.binding.client.info.packageName;
                info.clientLabel = conn.clientLabel;
                return info;
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityManager.RunningServiceInfo> getServices(int maxNum, int flags) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ArrayList<ActivityManager.RunningServiceInfo> res = new ArrayList<ActivityManager.RunningServiceInfo>();
            if (this.mServices.size() > 0) {
                Iterator<ServiceRecord> it = this.mServices.values().iterator();
                while (it.hasNext() && res.size() < maxNum) {
                    res.add(this.makeRunningServiceInfoLocked(it.next()));
                }
            }
            for (int i = 0; i < this.mRestartingServices.size() && res.size() < maxNum; ++i) {
                ServiceRecord r = this.mRestartingServices.get(i);
                ActivityManager.RunningServiceInfo info = this.makeRunningServiceInfoLocked(r);
                info.restarting = r.nextRestartTime;
                res.add(info);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingIntent getRunningServiceControlPanel(ComponentName name) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ServiceRecord r = this.mServices.get(name);
            if (r != null) {
                for (ArrayList<ConnectionRecord> conn : r.connections.values()) {
                    for (int i = 0; i < conn.size(); ++i) {
                        if (conn.get((int)i).clientIntent == null) continue;
                        return conn.get((int)i).clientIntent;
                    }
                }
            }
        }
        return null;
    }

    private final ServiceRecord findServiceLocked(ComponentName name, IBinder token) {
        ServiceRecord r = this.mServices.get(name);
        return r == token ? r : null;
    }

    private ServiceLookupResult findServiceLocked(Intent service, String resolvedType) {
        ServiceRecord r = null;
        if (service.getComponent() != null) {
            r = this.mServices.get(service.getComponent());
        }
        if (r == null) {
            Intent.FilterComparison filter = new Intent.FilterComparison(service);
            r = this.mServicesByIntent.get(filter);
        }
        if (r == null) {
            try {
                ServiceInfo sInfo;
                ResolveInfo rInfo = AppGlobals.getPackageManager().resolveService(service, resolvedType, 0);
                ServiceInfo serviceInfo = sInfo = rInfo != null ? rInfo.serviceInfo : null;
                if (sInfo == null) {
                    return null;
                }
                ComponentName name = new ComponentName(sInfo.applicationInfo.packageName, sInfo.name);
                r = this.mServices.get(name);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        if (r != null) {
            int callingUid;
            int callingPid = Binder.getCallingPid();
            if (this.checkComponentPermission(r.permission, callingPid, callingUid = Binder.getCallingUid(), r.appInfo.uid, r.exported) != 0) {
                if (!r.exported) {
                    Slog.w((String)TAG, (String)("Permission Denial: Accessing service " + r.name + " from pid=" + callingPid + ", uid=" + callingUid + " that is not exported from uid " + r.appInfo.uid));
                    return new ServiceLookupResult(null, "not exported from uid " + r.appInfo.uid);
                }
                Slog.w((String)TAG, (String)("Permission Denial: Accessing service " + r.name + " from pid=" + callingPid + ", uid=" + callingUid + " requires " + r.permission));
                return new ServiceLookupResult(null, r.permission);
            }
            return new ServiceLookupResult(r, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceLookupResult retrieveServiceLocked(Intent service, String resolvedType, int callingPid, int callingUid) {
        ServiceRecord r;
        block12: {
            Intent.FilterComparison filter;
            r = null;
            if (service.getComponent() != null) {
                r = this.mServices.get(service.getComponent());
            }
            if ((r = this.mServicesByIntent.get(filter = new Intent.FilterComparison(service))) == null) {
                try {
                    BatteryStatsImpl stats;
                    ServiceInfo sInfo;
                    ResolveInfo rInfo = AppGlobals.getPackageManager().resolveService(service, resolvedType, 1024);
                    ServiceInfo serviceInfo = sInfo = rInfo != null ? rInfo.serviceInfo : null;
                    if (sInfo == null) {
                        Slog.w((String)TAG, (String)("Unable to start service " + service + ": not found"));
                        return null;
                    }
                    ComponentName name = new ComponentName(sInfo.applicationInfo.packageName, sInfo.name);
                    r = this.mServices.get(name);
                    if (r != null) break block12;
                    filter = new Intent.FilterComparison(service.cloneFilter());
                    ServiceRestarter res = new ServiceRestarter();
                    BatteryStatsImpl.Uid.Pkg.Serv ss = null;
                    BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
                    synchronized (batteryStatsImpl) {
                        ss = stats.getServiceStatsLocked(sInfo.applicationInfo.uid, sInfo.packageName, sInfo.name);
                    }
                    r = new ServiceRecord(this, ss, name, filter, sInfo, res);
                    res.setService(r);
                    this.mServices.put(name, r);
                    this.mServicesByIntent.put(filter, r);
                    int N = this.mPendingServices.size();
                    for (int i = 0; i < N; ++i) {
                        ServiceRecord pr = this.mPendingServices.get(i);
                        if (!pr.name.equals((Object)name)) continue;
                        this.mPendingServices.remove(i);
                        --i;
                        --N;
                    }
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
        }
        if (r != null) {
            if (this.checkComponentPermission(r.permission, callingPid, callingUid, r.appInfo.uid, r.exported) != 0) {
                if (!r.exported) {
                    Slog.w((String)TAG, (String)("Permission Denial: Accessing service " + r.name + " from pid=" + callingPid + ", uid=" + callingUid + " that is not exported from uid " + r.appInfo.uid));
                    return new ServiceLookupResult(null, "not exported from uid " + r.appInfo.uid);
                }
                Slog.w((String)TAG, (String)("Permission Denial: Accessing service " + r.name + " from pid=" + callingPid + ", uid=" + callingUid + " requires " + r.permission));
                return new ServiceLookupResult(null, r.permission);
            }
            return new ServiceLookupResult(r, null);
        }
        return null;
    }

    private final void bumpServiceExecutingLocked(ServiceRecord r, String why) {
        long now = SystemClock.uptimeMillis();
        if (r.executeNesting == 0 && r.app != null) {
            if (r.app.executingServices.size() == 0) {
                Message msg = this.mHandler.obtainMessage(12);
                msg.obj = r.app;
                this.mHandler.sendMessageAtTime(msg, now + 20000L);
            }
            r.app.executingServices.add(r);
        }
        ++r.executeNesting;
        r.executingStart = now;
    }

    private final void sendServiceArgsLocked(ServiceRecord r, boolean oomAdjusted) {
        int N = r.pendingStarts.size();
        if (N == 0) {
            return;
        }
        while (r.pendingStarts.size() > 0) {
            try {
                ServiceRecord.StartItem si = r.pendingStarts.remove(0);
                if (si.intent == null && N > 1) continue;
                si.deliveredTime = SystemClock.uptimeMillis();
                r.deliveredStarts.add(si);
                ++si.deliveryCount;
                if (si.targetPermissionUid >= 0 && si.intent != null) {
                    this.grantUriPermissionUncheckedFromIntentLocked(si.targetPermissionUid, r.packageName, si.intent, si.getUriPermissionsLocked());
                }
                this.bumpServiceExecutingLocked(r, "start");
                if (!oomAdjusted) {
                    oomAdjusted = true;
                    this.updateOomAdjLocked(r.app);
                }
                int flags = 0;
                if (si.deliveryCount > 0) {
                    flags |= 2;
                }
                if (si.doneExecutingCount > 0) {
                    flags |= 1;
                }
                r.app.thread.scheduleServiceArgs((IBinder)r, si.taskRemoved, si.id, flags, si.intent);
            }
            catch (RemoteException e) {
                break;
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)"Unexpected exception", (Throwable)e);
                break;
            }
        }
    }

    private final boolean requestServiceBindingLocked(ServiceRecord r, IntentBindRecord i, boolean rebind) {
        if (r.app == null || r.app.thread == null) {
            return false;
        }
        if ((!i.requested || rebind) && i.apps.size() > 0) {
            try {
                this.bumpServiceExecutingLocked(r, "bind");
                r.app.thread.scheduleBindService((IBinder)r, i.intent.getIntent(), rebind);
                if (!rebind) {
                    i.requested = true;
                }
                i.hasBound = true;
                i.doRebind = false;
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return true;
    }

    private final void requestServiceBindingsLocked(ServiceRecord r) {
        for (IntentBindRecord i : r.bindings.values()) {
            if (!this.requestServiceBindingLocked(r, i, false)) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void realStartServiceLocked(ServiceRecord r, ProcessRecord app) throws RemoteException {
        block8: {
            if (app.thread == null) {
                throw new RemoteException();
            }
            r.app = app;
            r.restartTime = r.lastActivity = SystemClock.uptimeMillis();
            app.services.add(r);
            this.bumpServiceExecutingLocked(r, "create");
            this.updateLruProcessLocked(app, true, true);
            boolean created = false;
            try {
                this.mStringBuilder.setLength(0);
                r.intent.getIntent().toShortString(this.mStringBuilder, true, false, true);
                EventLog.writeEvent((int)30030, (Object[])new Object[]{System.identityHashCode((Object)r), r.shortName, this.mStringBuilder.toString(), r.app.pid});
                BatteryStatsImpl batteryStatsImpl = r.stats.getBatteryStats();
                synchronized (batteryStatsImpl) {
                    r.stats.startLaunchedLocked();
                }
                this.ensurePackageDexOpt(r.serviceInfo.packageName);
                app.thread.scheduleCreateService((IBinder)r, r.serviceInfo, this.compatibilityInfoForPackageLocked(r.serviceInfo.applicationInfo));
                r.postNotification();
                created = true;
                Object var7_6 = null;
                if (created) break block8;
                app.services.remove((Object)r);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (!created) {
                    app.services.remove((Object)r);
                    this.scheduleServiceRestartLocked(r, false);
                }
                throw throwable;
            }
            this.scheduleServiceRestartLocked(r, false);
            {
            }
        }
        this.requestServiceBindingsLocked(r);
        if (r.startRequested && r.callStart && r.pendingStarts.size() == 0) {
            r.pendingStarts.add(new ServiceRecord.StartItem(r, false, r.makeNextStartId(), null, -1));
        }
        this.sendServiceArgsLocked(r, true);
    }

    private final boolean scheduleServiceRestartLocked(ServiceRecord r, boolean allowCancel) {
        boolean repeat;
        int N;
        boolean canceled = false;
        long now = SystemClock.uptimeMillis();
        long minDuration = 5000L;
        long resetTime = 60000L;
        if ((r.serviceInfo.applicationInfo.flags & 8) != 0) {
            minDuration /= 4L;
        }
        if ((N = r.deliveredStarts.size()) > 0) {
            for (int i = N - 1; i >= 0; --i) {
                ServiceRecord.StartItem si = r.deliveredStarts.get(i);
                si.removeUriPermissionsLocked();
                if (si.intent == null) continue;
                if (!allowCancel || si.deliveryCount < 3 && si.doneExecutingCount < 6) {
                    r.pendingStarts.add(0, si);
                    long dur = SystemClock.uptimeMillis() - si.deliveredTime;
                    if (minDuration < (dur *= 2L)) {
                        minDuration = dur;
                    }
                    if (resetTime >= dur) continue;
                    resetTime = dur;
                    continue;
                }
                Slog.w((String)TAG, (String)("Canceling start item " + si.intent + " in service " + r.name));
                canceled = true;
            }
            r.deliveredStarts.clear();
        }
        ++r.totalRestartCount;
        if (r.restartDelay == 0L) {
            ++r.restartCount;
            r.restartDelay = minDuration;
        } else if (now > r.restartTime + resetTime) {
            r.restartCount = 1;
            r.restartDelay = minDuration;
        } else if ((r.serviceInfo.applicationInfo.flags & 8) != 0) {
            r.restartDelay += minDuration / 2L;
        } else {
            r.restartDelay *= 4L;
            if (r.restartDelay < minDuration) {
                r.restartDelay = minDuration;
            }
        }
        r.nextRestartTime = now + r.restartDelay;
        block1: do {
            repeat = false;
            for (int i = this.mRestartingServices.size() - 1; i >= 0; --i) {
                ServiceRecord r2 = this.mRestartingServices.get(i);
                if (r2 == r || r.nextRestartTime < r2.nextRestartTime - 10000L || r.nextRestartTime >= r2.nextRestartTime + 10000L) continue;
                r.nextRestartTime = r2.nextRestartTime + 10000L;
                r.restartDelay = r.nextRestartTime - now;
                repeat = true;
                continue block1;
            }
        } while (repeat);
        if (!this.mRestartingServices.contains((Object)r)) {
            this.mRestartingServices.add(r);
        }
        r.cancelNotification();
        this.mHandler.removeCallbacks(r.restarter);
        this.mHandler.postAtTime(r.restarter, r.nextRestartTime);
        r.nextRestartTime = SystemClock.uptimeMillis() + r.restartDelay;
        Slog.w((String)TAG, (String)("Scheduling restart of crashed service " + r.shortName + " in " + r.restartDelay + "ms"));
        EventLog.writeEvent((int)30035, (Object[])new Object[]{r.shortName, r.restartDelay});
        return canceled;
    }

    final void performServiceRestartLocked(ServiceRecord r) {
        if (!this.mRestartingServices.contains((Object)r)) {
            return;
        }
        this.bringUpServiceLocked(r, r.intent.getIntent().getFlags(), true);
    }

    private final boolean unscheduleServiceRestartLocked(ServiceRecord r) {
        if (r.restartDelay == 0L) {
            return false;
        }
        r.resetRestartCounter();
        this.mRestartingServices.remove((Object)r);
        this.mHandler.removeCallbacks(r.restarter);
        return true;
    }

    private final boolean bringUpServiceLocked(ServiceRecord r, int intentFlags, boolean whileRestarting) {
        if (r.app != null && r.app.thread != null) {
            this.sendServiceArgsLocked(r, false);
            return true;
        }
        if (!whileRestarting && r.restartDelay > 0L) {
            return true;
        }
        this.mRestartingServices.remove((Object)r);
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(r.packageName, false);
        }
        catch (RemoteException e) {
        }
        catch (IllegalArgumentException e) {
            Slog.w((String)TAG, (String)("Failed trying to unstop package " + r.packageName + ": " + e));
        }
        String appName = r.processName;
        ProcessRecord app = this.getProcessRecordLocked(appName, r.appInfo.uid);
        if (app != null && app.thread != null) {
            try {
                app.addPackage(r.appInfo.packageName);
                this.realStartServiceLocked(r, app);
                return true;
            }
            catch (RemoteException e) {
                Slog.w((String)TAG, (String)("Exception when starting service " + r.shortName), (Throwable)e);
            }
        }
        if (this.startProcessLocked(appName, r.appInfo, true, intentFlags, "service", r.name, false) == null) {
            Slog.w((String)TAG, (String)("Unable to launch app " + r.appInfo.packageName + "/" + r.appInfo.uid + " for service " + r.intent.getIntent() + ": process is bad"));
            this.bringDownServiceLocked(r, true);
            return false;
        }
        if (!this.mPendingServices.contains((Object)r)) {
            this.mPendingServices.add(r);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void bringDownServiceLocked(ServiceRecord r, boolean force) {
        if (!force && r.startRequested) {
            return;
        }
        if (r.connections.size() > 0) {
            int i;
            if (!force) {
                for (ArrayList<ConnectionRecord> cr : r.connections.values()) {
                    for (i = 0; i < cr.size(); ++i) {
                        if ((cr.get((int)i).flags & 1) == 0) continue;
                        return;
                    }
                }
            }
            for (ArrayList<ConnectionRecord> c : r.connections.values()) {
                for (i = 0; i < c.size(); ++i) {
                    ConnectionRecord cr = c.get(i);
                    cr.serviceDead = true;
                    try {
                        cr.conn.connected(r.name, null);
                        continue;
                    }
                    catch (Exception e) {
                        Slog.w((String)TAG, (String)("Failure disconnecting service " + r.name + " to connection " + c.get((int)i).conn.asBinder() + " (in " + c.get((int)i).binding.client.processName + ")"), (Throwable)e);
                    }
                }
            }
        }
        if (r.bindings.size() > 0 && r.app != null && r.app.thread != null) {
            for (IntentBindRecord ibr : r.bindings.values()) {
                if (r.app == null || r.app.thread == null || !ibr.hasBound) continue;
                try {
                    this.bumpServiceExecutingLocked(r, "bring down unbind");
                    this.updateOomAdjLocked(r.app);
                    ibr.hasBound = false;
                    r.app.thread.scheduleUnbindService((IBinder)r, ibr.intent.getIntent());
                }
                catch (Exception e) {
                    Slog.w((String)TAG, (String)("Exception when unbinding service " + r.shortName), (Throwable)e);
                    this.serviceDoneExecutingLocked(r, true);
                }
            }
        }
        EventLog.writeEvent((int)30031, (Object[])new Object[]{System.identityHashCode((Object)r), r.shortName, r.app != null ? r.app.pid : -1});
        this.mServices.remove(r.name);
        this.mServicesByIntent.remove(r.intent);
        r.totalRestartCount = 0;
        this.unscheduleServiceRestartLocked(r);
        int N = this.mPendingServices.size();
        for (int i = 0; i < N; ++i) {
            if (this.mPendingServices.get(i) != r) continue;
            this.mPendingServices.remove(i);
            --i;
            --N;
        }
        r.cancelNotification();
        r.isForeground = false;
        r.foregroundId = 0;
        r.foregroundNoti = null;
        r.clearDeliveredStartsLocked();
        r.pendingStarts.clear();
        if (r.app != null) {
            BatteryStatsImpl i = r.stats.getBatteryStats();
            synchronized (i) {
                r.stats.stopLaunchedLocked();
            }
            r.app.services.remove((Object)r);
            if (r.app.thread != null) {
                try {
                    this.bumpServiceExecutingLocked(r, "stop");
                    this.mStoppingServices.add(r);
                    this.updateOomAdjLocked(r.app);
                    r.app.thread.scheduleStopService((IBinder)r);
                }
                catch (Exception e) {
                    Slog.w((String)TAG, (String)("Exception when stopping service " + r.shortName), (Throwable)e);
                    this.serviceDoneExecutingLocked(r, true);
                }
                this.updateServiceForegroundLocked(r.app, false);
            }
        }
        if (r.bindings.size() > 0) {
            r.bindings.clear();
        }
        if (r.restarter instanceof ServiceRestarter) {
            ((ServiceRestarter)r.restarter).setService(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName startServiceLocked(IApplicationThread caller, Intent service, String resolvedType, int callingPid, int callingUid) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord callerApp;
            if (caller != null && (callerApp = this.getRecordForAppLocked(caller)) == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when starting service " + service);
            }
            ServiceLookupResult res = this.retrieveServiceLocked(service, resolvedType, callingPid, callingUid);
            if (res == null) {
                return null;
            }
            if (res.record == null) {
                return new ComponentName("!", res.permission != null ? res.permission : "private to package");
            }
            ServiceRecord r = res.record;
            int targetPermissionUid = this.checkGrantUriPermissionFromIntentLocked(callingUid, r.packageName, service);
            if (this.unscheduleServiceRestartLocked(r)) {
                // empty if block
            }
            r.startRequested = true;
            r.callStart = false;
            r.pendingStarts.add(new ServiceRecord.StartItem(r, false, r.makeNextStartId(), service, targetPermissionUid));
            r.lastActivity = SystemClock.uptimeMillis();
            BatteryStatsImpl batteryStatsImpl = r.stats.getBatteryStats();
            synchronized (batteryStatsImpl) {
                r.stats.startRunningLocked();
            }
            if (!this.bringUpServiceLocked(r, service.getFlags(), false)) {
                return new ComponentName("!", "Service process is bad");
            }
            return r.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentName startService(IApplicationThread caller, Intent service, String resolvedType) {
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingPid = Binder.getCallingPid();
            int callingUid = Binder.getCallingUid();
            long origId = Binder.clearCallingIdentity();
            ComponentName res = this.startServiceLocked(caller, service, resolvedType, callingPid, callingUid);
            Binder.restoreCallingIdentity((long)origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName startServiceInPackage(int uid, Intent service, String resolvedType) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            ComponentName res = this.startServiceLocked(null, service, resolvedType, -1, uid);
            Binder.restoreCallingIdentity((long)origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServiceLocked(ServiceRecord service) {
        BatteryStatsImpl batteryStatsImpl = service.stats.getBatteryStats();
        synchronized (batteryStatsImpl) {
            service.stats.stopRunningLocked();
        }
        service.startRequested = false;
        service.callStart = false;
        this.bringDownServiceLocked(service, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopService(IApplicationThread caller, Intent service, String resolvedType) {
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord callerApp = this.getRecordForAppLocked(caller);
            if (caller != null && callerApp == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when stopping service " + service);
            }
            ServiceLookupResult r = this.findServiceLocked(service, resolvedType);
            if (r != null) {
                if (r.record != null) {
                    long origId = Binder.clearCallingIdentity();
                    try {
                        this.stopServiceLocked(r.record);
                        Object var10_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        Binder.restoreCallingIdentity((long)origId);
                        throw throwable;
                    }
                    Binder.restoreCallingIdentity((long)origId);
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinder peekService(Intent service, String resolvedType) {
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        IBinder ret = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ServiceLookupResult r = this.findServiceLocked(service, resolvedType);
            if (r != null) {
                if (r.record == null) {
                    throw new SecurityException("Permission Denial: Accessing service " + r.record.name + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + r.permission);
                }
                IntentBindRecord ib = r.record.bindings.get(r.record.intent);
                if (ib != null) {
                    ret = ib.binder;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopServiceToken(ComponentName className, IBinder token, int startId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ServiceRecord r = this.findServiceLocked(className, token);
            if (r != null) {
                ServiceRecord.StartItem si;
                if (startId >= 0) {
                    si = r.findDeliveredStart(startId, false);
                    if (si != null) {
                        while (r.deliveredStarts.size() > 0) {
                            ServiceRecord.StartItem cur = r.deliveredStarts.remove(0);
                            cur.removeUriPermissionsLocked();
                            if (cur != si) continue;
                            break;
                        }
                    }
                    if (r.getLastStartId() != startId) {
                        return false;
                    }
                    if (r.deliveredStarts.size() > 0) {
                        Slog.w((String)TAG, (String)("stopServiceToken startId " + startId + " is last, but have " + r.deliveredStarts.size() + " remaining args"));
                    }
                }
                si = r.stats.getBatteryStats();
                synchronized (si) {
                    r.stats.stopRunningLocked();
                    r.startRequested = false;
                    r.callStart = false;
                }
                long origId = Binder.clearCallingIdentity();
                this.bringDownServiceLocked(r, false);
                Binder.restoreCallingIdentity((long)origId);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceForeground(ComponentName className, IBinder token, int id, Notification notification, boolean removeNotification) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ServiceRecord r = this.findServiceLocked(className, token);
                if (r != null) {
                    if (id != 0) {
                        if (notification == null) {
                            throw new IllegalArgumentException("null notification");
                        }
                        if (r.foregroundId != id) {
                            r.cancelNotification();
                            r.foregroundId = id;
                        }
                        notification.flags |= 0x40;
                        r.foregroundNoti = notification;
                        r.isForeground = true;
                        r.postNotification();
                        if (r.app != null) {
                            this.updateServiceForegroundLocked(r.app, true);
                        }
                    } else {
                        if (r.isForeground) {
                            r.isForeground = false;
                            if (r.app != null) {
                                this.updateLruProcessLocked(r.app, false, true);
                                this.updateServiceForegroundLocked(r.app, true);
                            }
                        }
                        if (removeNotification) {
                            r.cancelNotification();
                            r.foregroundId = 0;
                            r.foregroundNoti = null;
                        }
                    }
                }
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            Binder.restoreCallingIdentity((long)origId);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)origId);
    }

    public void updateServiceForegroundLocked(ProcessRecord proc, boolean oomAdj) {
        boolean anyForeground = false;
        for (ServiceRecord sr : proc.services) {
            if (!sr.isForeground) continue;
            anyForeground = true;
            break;
        }
        if (anyForeground != proc.foregroundServices) {
            proc.foregroundServices = anyForeground;
            if (oomAdj) {
                this.updateOomAdjLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bindService(IApplicationThread caller, IBinder token, Intent service, String resolvedType, IServiceConnection connection, int flags) {
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ServiceLookupResult res;
            ProcessRecord callerApp = this.getRecordForAppLocked(caller);
            if (callerApp == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when binding service " + service);
            }
            ActivityRecord activity = null;
            if (token != null && (activity = this.mMainStack.isInStackLocked(token)) == null) {
                Slog.w((String)TAG, (String)("Binding with unknown activity: " + token));
                return 0;
            }
            int clientLabel = 0;
            PendingIntent clientIntent = null;
            if (callerApp.info.uid == 1000) {
                try {
                    clientIntent = (PendingIntent)service.getParcelableExtra("android.intent.extra.client_intent");
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                if (clientIntent != null && (clientLabel = service.getIntExtra("android.intent.extra.client_label", 0)) != 0) {
                    service = service.cloneFilter();
                }
            }
            if ((res = this.retrieveServiceLocked(service, resolvedType, Binder.getCallingPid(), Binder.getCallingUid())) == null) {
                return 0;
            }
            if (res.record == null) {
                return -1;
            }
            ServiceRecord s = res.record;
            long origId = Binder.clearCallingIdentity();
            if (this.unscheduleServiceRestartLocked(s)) {
                // empty if block
            }
            AppBindRecord b = s.retrieveAppBindingLocked(service, callerApp);
            ConnectionRecord c = new ConnectionRecord(b, activity, connection, flags, clientLabel, clientIntent);
            IBinder binder = connection.asBinder();
            ArrayList<ConnectionRecord> clist = s.connections.get(binder);
            if (clist == null) {
                clist = new ArrayList();
                s.connections.put(binder, clist);
            }
            clist.add(c);
            b.connections.add(c);
            if (activity != null) {
                if (activity.connections == null) {
                    activity.connections = new HashSet();
                }
                activity.connections.add(c);
            }
            b.client.connections.add(c);
            if ((c.flags & 8) != 0) {
                b.client.hasAboveClient = true;
            }
            if ((clist = this.mServiceConnections.get(binder)) == null) {
                clist = new ArrayList();
                this.mServiceConnections.put(binder, clist);
            }
            clist.add(c);
            if ((flags & 1) != 0) {
                s.lastActivity = SystemClock.uptimeMillis();
                if (!this.bringUpServiceLocked(s, service.getFlags(), false)) {
                    return 0;
                }
            }
            if (s.app != null) {
                this.updateOomAdjLocked(s.app);
            }
            if (s.app != null && b.intent.received) {
                try {
                    c.conn.connected(s.name, b.intent.binder);
                }
                catch (Exception e) {
                    Slog.w((String)TAG, (String)("Failure sending service " + s.shortName + " to connection " + c.conn.asBinder() + " (in " + c.binding.client.processName + ")"), (Throwable)e);
                }
                if (b.intent.apps.size() == 1 && b.intent.doRebind) {
                    this.requestServiceBindingLocked(s, b.intent, true);
                }
            } else if (!b.intent.requested) {
                this.requestServiceBindingLocked(s, b.intent, false);
            }
            Binder.restoreCallingIdentity((long)origId);
        }
        return 1;
    }

    void removeConnectionLocked(ConnectionRecord c, ProcessRecord skipApp, ActivityRecord skipAct) {
        IBinder binder = c.conn.asBinder();
        AppBindRecord b = c.binding;
        ServiceRecord s = b.service;
        ArrayList<ConnectionRecord> clist = s.connections.get(binder);
        if (clist != null) {
            clist.remove(c);
            if (clist.size() == 0) {
                s.connections.remove(binder);
            }
        }
        b.connections.remove(c);
        if (c.activity != null && c.activity != skipAct && c.activity.connections != null) {
            c.activity.connections.remove(c);
        }
        if (b.client != skipApp) {
            b.client.connections.remove(c);
            if ((c.flags & 8) != 0) {
                b.client.updateHasAboveClientLocked();
            }
        }
        if ((clist = this.mServiceConnections.get(binder)) != null) {
            clist.remove(c);
            if (clist.size() == 0) {
                this.mServiceConnections.remove(binder);
            }
        }
        if (b.connections.size() == 0) {
            b.intent.apps.remove(b.client);
        }
        if (!c.serviceDead) {
            if (s.app != null && s.app.thread != null && b.intent.apps.size() == 0 && b.intent.hasBound) {
                try {
                    this.bumpServiceExecutingLocked(s, "unbind");
                    this.updateOomAdjLocked(s.app);
                    b.intent.hasBound = false;
                    b.intent.doRebind = false;
                    s.app.thread.scheduleUnbindService((IBinder)s, b.intent.intent.getIntent());
                }
                catch (Exception e) {
                    Slog.w((String)TAG, (String)("Exception when unbinding service " + s.shortName), (Throwable)e);
                    this.serviceDoneExecutingLocked(s, true);
                }
            }
            if ((c.flags & 1) != 0) {
                this.bringDownServiceLocked(s, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbindService(IServiceConnection connection) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            IBinder binder = connection.asBinder();
            ArrayList<ConnectionRecord> clist = this.mServiceConnections.get(binder);
            if (clist == null) {
                Slog.w((String)TAG, (String)("Unbind failed: could not find connection for " + connection.asBinder()));
                return false;
            }
            long origId = Binder.clearCallingIdentity();
            while (clist.size() > 0) {
                ConnectionRecord r = clist.get(0);
                this.removeConnectionLocked(r, null, null);
                if (r.binding.service.app == null) continue;
                this.updateOomAdjLocked(r.binding.service.app);
            }
            Binder.restoreCallingIdentity((long)origId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishService(IBinder token, Intent intent, IBinder service) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!(token instanceof ServiceRecord)) {
                throw new IllegalArgumentException("Invalid service token");
            }
            ServiceRecord r = (ServiceRecord)token;
            long origId = Binder.clearCallingIdentity();
            if (r != null) {
                Intent.FilterComparison filter = new Intent.FilterComparison(intent);
                IntentBindRecord b = r.bindings.get(filter);
                if (b != null && !b.received) {
                    b.binder = service;
                    b.requested = true;
                    b.received = true;
                    if (r.connections.size() > 0) {
                        for (ArrayList<ConnectionRecord> clist : r.connections.values()) {
                            for (int i = 0; i < clist.size(); ++i) {
                                ConnectionRecord c = clist.get(i);
                                if (!filter.equals((Object)c.binding.intent.intent)) continue;
                                try {
                                    c.conn.connected(r.name, service);
                                    continue;
                                }
                                catch (Exception e) {
                                    Slog.w((String)TAG, (String)("Failure sending service " + r.name + " to connection " + c.conn.asBinder() + " (in " + c.binding.client.processName + ")"), (Throwable)e);
                                }
                            }
                        }
                    }
                }
                this.serviceDoneExecutingLocked(r, this.mStoppingServices.contains((Object)r));
                Binder.restoreCallingIdentity((long)origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindFinished(IBinder token, Intent intent, boolean doRebind) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!(token instanceof ServiceRecord)) {
                throw new IllegalArgumentException("Invalid service token");
            }
            ServiceRecord r = (ServiceRecord)token;
            long origId = Binder.clearCallingIdentity();
            if (r != null) {
                Intent.FilterComparison filter = new Intent.FilterComparison(intent);
                IntentBindRecord b = r.bindings.get(filter);
                boolean inStopping = this.mStoppingServices.contains((Object)r);
                if (b != null) {
                    if (b.apps.size() > 0 && !inStopping) {
                        this.requestServiceBindingLocked(r, b, true);
                    } else {
                        b.doRebind = true;
                    }
                }
                this.serviceDoneExecutingLocked(r, inStopping);
                Binder.restoreCallingIdentity((long)origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceDoneExecuting(IBinder token, int type, int startId, int res) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!(token instanceof ServiceRecord)) {
                throw new IllegalArgumentException("Invalid service token");
            }
            ServiceRecord r = (ServiceRecord)token;
            boolean inStopping = this.mStoppingServices.contains(token);
            if (r != null) {
                if (r != token) {
                    Slog.w((String)TAG, (String)("Done executing service " + r.name + " with incorrect token: given " + token + ", expected " + (Object)((Object)r)));
                    return;
                }
                if (type == 1) {
                    r.callStart = true;
                    switch (res) {
                        case 0: 
                        case 1: {
                            r.findDeliveredStart(startId, true);
                            r.stopIfKilled = false;
                            break;
                        }
                        case 2: {
                            r.findDeliveredStart(startId, true);
                            if (r.getLastStartId() != startId) break;
                            r.stopIfKilled = true;
                            break;
                        }
                        case 3: {
                            ServiceRecord.StartItem si = r.findDeliveredStart(startId, false);
                            if (si == null) break;
                            si.deliveryCount = 0;
                            ++si.doneExecutingCount;
                            r.stopIfKilled = true;
                            break;
                        }
                        case 1000: {
                            r.findDeliveredStart(startId, true);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown service start result: " + res);
                        }
                    }
                    if (res == 0) {
                        r.callStart = false;
                    }
                }
                long origId = Binder.clearCallingIdentity();
                this.serviceDoneExecutingLocked(r, inStopping);
                Binder.restoreCallingIdentity((long)origId);
            } else {
                Slog.w((String)TAG, (String)("Done executing unknown service from pid " + Binder.getCallingPid()));
            }
        }
    }

    public void serviceDoneExecutingLocked(ServiceRecord r, boolean inStopping) {
        --r.executeNesting;
        if (r.executeNesting <= 0 && r.app != null) {
            r.app.executingServices.remove((Object)r);
            if (r.app.executingServices.size() == 0) {
                this.mHandler.removeMessages(12, (Object)r.app);
            }
            if (inStopping) {
                this.mStoppingServices.remove((Object)r);
                r.bindings.clear();
            }
            this.updateOomAdjLocked(r.app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serviceTimeout(ProcessRecord proc) {
        String anrMessage = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (proc.executingServices.size() == 0 || proc.thread == null) {
                return;
            }
            long maxTime = SystemClock.uptimeMillis() - 20000L;
            Iterator<ServiceRecord> it = proc.executingServices.iterator();
            ServiceRecord timeout = null;
            long nextTime = 0L;
            while (it.hasNext()) {
                ServiceRecord sr = it.next();
                if (sr.executingStart < maxTime) {
                    timeout = sr;
                    break;
                }
                if (sr.executingStart <= nextTime) continue;
                nextTime = sr.executingStart;
            }
            if (timeout != null && this.mLruProcesses.contains(proc)) {
                Slog.w((String)TAG, (String)("Timeout executing service: " + (Object)((Object)timeout)));
                anrMessage = "Executing service " + timeout.shortName;
            } else {
                Message msg = this.mHandler.obtainMessage(12);
                msg.obj = proc;
                this.mHandler.sendMessageAtTime(msg, nextTime + 20000L);
            }
        }
        if (anrMessage != null) {
            this.appNotResponding(proc, null, null, anrMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bindBackupAgent(ApplicationInfo app, int backupMode) {
        this.enforceCallingPermission("android.permission.BACKUP", "startBackupAgent");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            BatteryStatsImpl stats;
            BatteryStatsImpl.Uid.Pkg.Serv ss = null;
            BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
            synchronized (batteryStatsImpl) {
                ss = stats.getServiceStatsLocked(app.uid, app.packageName, app.name);
            }
            try {
                AppGlobals.getPackageManager().setPackageStoppedState(app.packageName, false);
            }
            catch (RemoteException e) {
            }
            catch (IllegalArgumentException e) {
                Slog.w((String)TAG, (String)("Failed trying to unstop package " + app.packageName + ": " + e));
            }
            BackupRecord r = new BackupRecord(ss, app, backupMode);
            ComponentName hostingName = backupMode == 0 ? new ComponentName(app.packageName, app.backupAgentName) : new ComponentName("android", "FullBackupAgent");
            ProcessRecord proc = this.startProcessLocked(app.processName, app, false, 0, "backup", hostingName, false);
            if (proc == null) {
                Slog.e((String)TAG, (String)("Unable to start backup agent process " + r));
                return false;
            }
            r.app = proc;
            this.mBackupTarget = r;
            this.mBackupAppName = app.packageName;
            this.updateOomAdjLocked(proc);
            if (proc.thread != null) {
                try {
                    proc.thread.scheduleCreateBackupAgent(app, this.compatibilityInfoForPackageLocked(app), backupMode);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void backupAgentCreated(String agentPackageName, IBinder agent) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!agentPackageName.equals(this.mBackupAppName)) {
                Slog.e((String)TAG, (String)("Backup agent created for " + agentPackageName + " but not requested!"));
                return;
            }
        }
        long oldIdent = Binder.clearCallingIdentity();
        try {
            try {
                IBackupManager bm = IBackupManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"backup"));
                bm.agentConnected(agentPackageName, agent);
            }
            catch (RemoteException e) {
                Object var7_9 = null;
                Binder.restoreCallingIdentity((long)oldIdent);
                return;
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)"Exception trying to deliver BackupAgent binding: ");
                e.printStackTrace();
                Object var7_10 = null;
                Binder.restoreCallingIdentity((long)oldIdent);
                return;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            Binder.restoreCallingIdentity((long)oldIdent);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)oldIdent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindBackupAgent(ApplicationInfo appInfo) {
        if (appInfo == null) {
            Slog.w((String)TAG, (String)"unbind backup agent for null app");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mBackupAppName == null) {
                Slog.w((String)TAG, (String)"Unbinding backup agent with no active backup");
                return;
            }
            if (!this.mBackupAppName.equals(appInfo.packageName)) {
                Slog.e((String)TAG, (String)("Unbind of " + appInfo + " but is not the current backup target"));
                return;
            }
            ProcessRecord proc = this.mBackupTarget.app;
            this.mBackupTarget = null;
            this.mBackupAppName = null;
            this.updateOomAdjLocked(proc);
            if (proc.thread != null) {
                try {
                    proc.thread.scheduleDestroyBackupAgent(appInfo, this.compatibilityInfoForPackageLocked(appInfo));
                }
                catch (Exception e) {
                    Slog.e((String)TAG, (String)"Exception when unbinding backup agent:");
                    e.printStackTrace();
                }
            }
        }
    }

    private final List getStickiesLocked(String action, IntentFilter filter, List cur) {
        ContentResolver resolver = this.mContext.getContentResolver();
        ArrayList<Intent> list = this.mStickyBroadcasts.get(action);
        if (list == null) {
            return cur;
        }
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            Intent intent = list.get(i);
            if (filter.match(resolver, intent, true, TAG) < 0) continue;
            if (cur == null) {
                cur = new ArrayList<Intent>();
            }
            cur.add(intent);
        }
        return cur;
    }

    private final void scheduleBroadcastsLocked() {
        if (this.mBroadcastsScheduled) {
            return;
        }
        this.mHandler.sendEmptyMessage(7);
        this.mBroadcastsScheduled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent registerReceiver(IApplicationThread caller, String callerPackage, IIntentReceiver receiver, IntentFilter filter, String permission) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            Intent sticky;
            ProcessRecord callerApp = null;
            if (caller != null) {
                callerApp = this.getRecordForAppLocked(caller);
                if (callerApp == null) {
                    throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when registering receiver " + receiver);
                }
                if (callerApp.info.uid != 1000 && !callerApp.pkgList.contains(callerPackage)) {
                    throw new SecurityException("Given caller package " + callerPackage + " is not running in process " + callerApp);
                }
            } else {
                callerPackage = null;
            }
            List allSticky = null;
            Iterator actions = filter.actionsIterator();
            if (actions != null) {
                while (actions.hasNext()) {
                    String action = (String)actions.next();
                    allSticky = this.getStickiesLocked(action, filter, allSticky);
                }
            } else {
                allSticky = this.getStickiesLocked(null, filter, allSticky);
            }
            Intent intent = sticky = allSticky != null ? (Intent)allSticky.get(0) : null;
            if (receiver == null) {
                return sticky;
            }
            ReceiverList rl = (ReceiverList)this.mRegisteredReceivers.get(receiver.asBinder());
            if (rl == null) {
                rl = new ReceiverList(this, callerApp, Binder.getCallingPid(), Binder.getCallingUid(), receiver);
                if (rl.app != null) {
                    rl.app.receivers.add(rl);
                } else {
                    try {
                        receiver.asBinder().linkToDeath((IBinder.DeathRecipient)rl, 0);
                    }
                    catch (RemoteException e) {
                        return sticky;
                    }
                    rl.linkedToDeath = true;
                }
                this.mRegisteredReceivers.put(receiver.asBinder(), rl);
            }
            BroadcastFilter bf = new BroadcastFilter(filter, rl, callerPackage, permission);
            rl.add(bf);
            if (!bf.debugCheck()) {
                Slog.w((String)TAG, (String)"==> For Dynamic broadast");
            }
            this.mReceiverResolver.addFilter(bf);
            if (allSticky != null) {
                ArrayList<BroadcastFilter> receivers = new ArrayList<BroadcastFilter>();
                receivers.add(bf);
                int N = allSticky.size();
                for (int i = 0; i < N; ++i) {
                    Intent intent2 = (Intent)allSticky.get(i);
                    BroadcastRecord r = new BroadcastRecord(intent2, null, null, -1, -1, null, receivers, null, 0, null, null, false, true, true);
                    if (this.mParallelBroadcasts.size() == 0) {
                        this.scheduleBroadcastsLocked();
                    }
                    this.mParallelBroadcasts.add(r);
                }
            }
            return sticky;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterReceiver(IIntentReceiver receiver) {
        boolean doNext = false;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ReceiverList rl = (ReceiverList)this.mRegisteredReceivers.get(receiver.asBinder());
            if (rl != null) {
                if (rl.curBroadcast != null) {
                    BroadcastRecord r = rl.curBroadcast;
                    doNext = this.finishReceiverLocked(receiver.asBinder(), r.resultCode, r.resultData, r.resultExtras, r.resultAbort, true);
                }
                if (rl.app != null) {
                    rl.app.receivers.remove(rl);
                }
                this.removeReceiverLocked(rl);
                if (rl.linkedToDeath) {
                    rl.linkedToDeath = false;
                    rl.receiver.asBinder().unlinkToDeath((IBinder.DeathRecipient)rl, 0);
                }
            }
        }
        if (!doNext) {
            return;
        }
        long origId = Binder.clearCallingIdentity();
        this.processNextBroadcast(false);
        this.trimApplications();
        Binder.restoreCallingIdentity((long)origId);
    }

    void removeReceiverLocked(ReceiverList rl) {
        this.mRegisteredReceivers.remove(rl.receiver.asBinder());
        int N = rl.size();
        for (int i = 0; i < N; ++i) {
            this.mReceiverResolver.removeFilter((BroadcastFilter)((IntentFilter)rl.get(i)));
        }
    }

    private final void sendPackageBroadcastLocked(int cmd, String[] packages) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord r = this.mLruProcesses.get(i);
            if (r.thread == null) continue;
            try {
                r.thread.dispatchPackageBroadcast(cmd, packages);
                continue;
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int broadcastIntentLocked(ProcessRecord callerApp, String callerPackage, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle map, String requiredPermission, boolean ordered, boolean sticky, int callingPid, int callingUid) {
        int NR;
        List<BroadcastFilter> registeredReceivers;
        ArrayList<Object> receivers;
        block51: {
            String msg;
            Object list;
            block54: {
                String ssp;
                Uri data;
                block52: {
                    String ssp2;
                    block55: {
                        block53: {
                            int uid;
                            intent = new Intent(intent);
                            intent.addFlags(16);
                            if (resultTo != null && !ordered) {
                                Slog.w((String)TAG, (String)("Broadcast " + intent + " not ordered but result callback requested!"));
                            }
                            boolean uidRemoved = "android.intent.action.UID_REMOVED".equals(intent.getAction());
                            if (!"android.intent.action.PACKAGE_REMOVED".equals(intent.getAction()) && !"android.intent.action.PACKAGE_CHANGED".equals(intent.getAction()) && !"android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(intent.getAction()) && !uidRemoved) break block52;
                            if (this.checkComponentPermission("android.permission.BROADCAST_PACKAGE_REMOVED", callingPid, callingUid, -1, true) != 0) {
                                String msg2 = "Permission Denial: " + intent.getAction() + " broadcast from " + callerPackage + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + "android.permission.BROADCAST_PACKAGE_REMOVED";
                                Slog.w((String)TAG, (String)msg2);
                                throw new SecurityException(msg2);
                            }
                            if (!uidRemoved) break block53;
                            Bundle intentExtras = intent.getExtras();
                            int n = uid = intentExtras != null ? intentExtras.getInt("android.intent.extra.UID") : -1;
                            if (uid >= 0) {
                                BatteryStatsImpl bs;
                                BatteryStatsImpl batteryStatsImpl = bs = this.mBatteryStatsService.getActiveStatistics();
                                synchronized (batteryStatsImpl) {
                                    bs.removeUidStatsLocked(uid);
                                }
                            }
                            break block54;
                        }
                        if (!"android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(intent.getAction())) break block55;
                        list = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                        if (list != null && ((String[])list).length > 0) {
                            for (String pkg : list) {
                                this.forceStopPackageLocked(pkg, -1, false, true, true, false);
                            }
                            this.sendPackageBroadcastLocked(1, (String[])list);
                        }
                        break block54;
                    }
                    data = intent.getData();
                    if (data != null && (ssp2 = data.getSchemeSpecificPart()) != null) {
                        if (!intent.getBooleanExtra("android.intent.extra.DONT_KILL_APP", false)) {
                            this.forceStopPackageLocked(ssp2, intent.getIntExtra("android.intent.extra.UID", -1), false, true, true, false);
                        }
                        if ("android.intent.action.PACKAGE_REMOVED".equals(intent.getAction())) {
                            this.sendPackageBroadcastLocked(0, new String[]{ssp2});
                        }
                    }
                    break block54;
                }
                if ("android.intent.action.PACKAGE_ADDED".equals(intent.getAction()) && (data = intent.getData()) != null && (ssp = data.getSchemeSpecificPart()) != null) {
                    this.mCompatModePackages.handlePackageAddedLocked(ssp, intent.getBooleanExtra("android.intent.extra.REPLACING", false));
                }
            }
            if ("android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction())) {
                this.mHandler.sendEmptyMessage(13);
            }
            if ("android.intent.action.CLEAR_DNS_CACHE".equals(intent.getAction())) {
                this.mHandler.sendEmptyMessage(28);
            }
            if ("android.intent.action.PROXY_CHANGE".equals(intent.getAction())) {
                ProxyProperties proxy = (ProxyProperties)intent.getParcelableExtra("proxy");
                this.mHandler.sendMessage(this.mHandler.obtainMessage(29, (Object)proxy));
            }
            if (!(callingUid == 1000 || callingUid == 1001 || callingUid == 2000 || callingUid == 0 || callerApp != null && callerApp.persistent)) {
                try {
                    if (AppGlobals.getPackageManager().isProtectedBroadcast(intent.getAction())) {
                        msg = "Permission Denial: not allowed to send broadcast " + intent.getAction() + " from pid=" + callingPid + ", uid=" + callingUid;
                        Slog.w((String)TAG, (String)msg);
                        throw new SecurityException(msg);
                    }
                }
                catch (RemoteException e) {
                    Slog.w((String)TAG, (String)"Remote exception", (Throwable)e);
                    return 0;
                }
            }
            if (sticky) {
                int i;
                if (this.checkPermission("android.permission.BROADCAST_STICKY", callingPid, callingUid) != 0) {
                    msg = "Permission Denial: broadcastIntent() requesting a sticky broadcast from pid=" + callingPid + ", uid=" + callingUid + " requires " + "android.permission.BROADCAST_STICKY";
                    Slog.w((String)TAG, (String)msg);
                    throw new SecurityException(msg);
                }
                if (requiredPermission != null) {
                    Slog.w((String)TAG, (String)("Can't broadcast sticky intent " + intent + " and enforce permission " + requiredPermission));
                    return -1;
                }
                if (intent.getComponent() != null) {
                    throw new SecurityException("Sticky broadcasts can't target a specific component");
                }
                list = this.mStickyBroadcasts.get(intent.getAction());
                if (list == null) {
                    list = new ArrayList();
                    this.mStickyBroadcasts.put(intent.getAction(), (ArrayList<Intent>)list);
                }
                int N = ((ArrayList)list).size();
                for (i = 0; i < N; ++i) {
                    if (!intent.filterEquals((Intent)((ArrayList)list).get(i))) continue;
                    ((ArrayList)list).set(i, new Intent(intent));
                    break;
                }
                if (i >= N) {
                    ((ArrayList)list).add(new Intent(intent));
                }
            }
            receivers = null;
            registeredReceivers = null;
            try {
                if (intent.getComponent() != null) {
                    ActivityInfo ai = AppGlobals.getPackageManager().getReceiverInfo(intent.getComponent(), 1024);
                    if (ai != null) {
                        receivers = new ArrayList<Object>();
                        ResolveInfo ri = new ResolveInfo();
                        ri.activityInfo = ai;
                        receivers.add(ri);
                    }
                    break block51;
                }
                if ((intent.getFlags() & 0x40000000) == 0) {
                    receivers = AppGlobals.getPackageManager().queryIntentReceivers(intent, resolvedType, 1024);
                }
                registeredReceivers = this.mReceiverResolver.queryIntent(intent, resolvedType, false);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        boolean replacePending = (intent.getFlags() & 0x20000000) != 0;
        int n = NR = registeredReceivers != null ? registeredReceivers.size() : 0;
        if (!ordered && NR > 0) {
            BroadcastRecord r = new BroadcastRecord(intent, callerApp, callerPackage, callingPid, callingUid, requiredPermission, registeredReceivers, resultTo, resultCode, resultData, map, ordered, sticky, false);
            boolean replaced = false;
            if (replacePending) {
                for (int i = this.mParallelBroadcasts.size() - 1; i >= 0; --i) {
                    if (!intent.filterEquals(this.mParallelBroadcasts.get((int)i).intent)) continue;
                    this.mParallelBroadcasts.set(i, r);
                    replaced = true;
                    break;
                }
            }
            if (!replaced) {
                this.mParallelBroadcasts.add(r);
                this.scheduleBroadcastsLocked();
            }
            registeredReceivers = null;
            NR = 0;
        }
        int ir = 0;
        if (receivers != null) {
            String[] skipPackages = null;
            if ("android.intent.action.PACKAGE_ADDED".equals(intent.getAction()) || "android.intent.action.PACKAGE_RESTARTED".equals(intent.getAction()) || "android.intent.action.PACKAGE_DATA_CLEARED".equals(intent.getAction())) {
                String pkgName;
                Uri data = intent.getData();
                if (data != null && (pkgName = data.getSchemeSpecificPart()) != null) {
                    skipPackages = new String[]{pkgName};
                }
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(intent.getAction())) {
                skipPackages = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            }
            if (skipPackages != null && skipPackages.length > 0) {
                for (String skipPackage : skipPackages) {
                    if (skipPackage == null) continue;
                    int NT = receivers.size();
                    for (int it = 0; it < NT; ++it) {
                        ResolveInfo curt = (ResolveInfo)receivers.get(it);
                        if (!curt.activityInfo.packageName.equals(skipPackage)) continue;
                        receivers.remove(it);
                        --it;
                        --NT;
                    }
                }
            }
            int NT = receivers != null ? receivers.size() : 0;
            int it = 0;
            ResolveInfo curt = null;
            BroadcastFilter curr = null;
            while (it < NT && ir < NR) {
                if (curt == null) {
                    curt = (ResolveInfo)receivers.get(it);
                }
                if (curr == null) {
                    curr = registeredReceivers.get(ir);
                }
                if (curr.getPriority() >= curt.priority) {
                    receivers.add(it, (Object)curr);
                    ++ir;
                    curr = null;
                    ++it;
                    ++NT;
                    continue;
                }
                ++it;
                curt = null;
            }
        }
        while (ir < NR) {
            if (receivers == null) {
                receivers = new ArrayList();
            }
            receivers.add((Object)registeredReceivers.get(ir));
            ++ir;
        }
        if (receivers == null || receivers.size() <= 0) {
            if (resultTo == null) return 0;
        }
        BroadcastRecord r = new BroadcastRecord(intent, callerApp, callerPackage, callingPid, callingUid, requiredPermission, receivers, resultTo, resultCode, resultData, map, ordered, sticky, false);
        boolean replaced = false;
        if (replacePending) {
            for (int i = this.mOrderedBroadcasts.size() - 1; i > 0; --i) {
                if (!intent.filterEquals(this.mOrderedBroadcasts.get((int)i).intent)) continue;
                this.mOrderedBroadcasts.set(i, r);
                return 0;
            }
        }
        if (replaced) return 0;
        this.mOrderedBroadcasts.add(r);
        this.scheduleBroadcastsLocked();
        return 0;
    }

    final Intent verifyBroadcastLocked(Intent intent) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        int flags = intent.getFlags();
        if (!this.mProcessesReady) {
            if ((flags & 0x10000000) != 0) {
                intent = new Intent(intent);
                intent.addFlags(0x40000000);
            } else if ((flags & 0x40000000) == 0) {
                Slog.e((String)TAG, (String)("Attempt to launch receivers of broadcast intent " + intent + " before boot completion"));
                throw new IllegalStateException("Cannot broadcast before boot completed");
            }
        }
        if ((flags & 0x8000000) != 0) {
            throw new IllegalArgumentException("Can't use FLAG_RECEIVER_BOOT_UPGRADE here");
        }
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int broadcastIntent(IApplicationThread caller, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle map, String requiredPermission, boolean serialized, boolean sticky) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            intent = this.verifyBroadcastLocked(intent);
            ProcessRecord callerApp = this.getRecordForAppLocked(caller);
            int callingPid = Binder.getCallingPid();
            int callingUid = Binder.getCallingUid();
            long origId = Binder.clearCallingIdentity();
            int res = this.broadcastIntentLocked(callerApp, callerApp != null ? callerApp.info.packageName : null, intent, resolvedType, resultTo, resultCode, resultData, map, requiredPermission, serialized, sticky, callingPid, callingUid);
            Binder.restoreCallingIdentity((long)origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int broadcastIntentInPackage(String packageName, int uid, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle map, String requiredPermission, boolean serialized, boolean sticky) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            intent = this.verifyBroadcastLocked(intent);
            long origId = Binder.clearCallingIdentity();
            int res = this.broadcastIntentLocked(null, packageName, intent, resolvedType, resultTo, resultCode, resultData, map, requiredPermission, serialized, sticky, -1, uid);
            Binder.restoreCallingIdentity((long)origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unbroadcastIntent(IApplicationThread caller, Intent intent) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.checkCallingPermission("android.permission.BROADCAST_STICKY") != 0) {
                String msg = "Permission Denial: unbroadcastIntent() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.BROADCAST_STICKY";
                Slog.w((String)TAG, (String)msg);
                throw new SecurityException(msg);
            }
            ArrayList<Intent> list = this.mStickyBroadcasts.get(intent.getAction());
            if (list != null) {
                int N = list.size();
                for (int i = 0; i < N; ++i) {
                    if (!intent.filterEquals(list.get(i))) continue;
                    list.remove(i);
                    break;
                }
            }
        }
    }

    private final boolean finishReceiverLocked(IBinder receiver, int resultCode, String resultData, Bundle resultExtras, boolean resultAbort, boolean explicit) {
        if (this.mOrderedBroadcasts.size() == 0) {
            if (explicit) {
                Slog.w((String)TAG, (String)"finishReceiver called but no pending broadcasts");
            }
            return false;
        }
        BroadcastRecord r = this.mOrderedBroadcasts.get(0);
        if (r.receiver == null) {
            if (explicit) {
                Slog.w((String)TAG, (String)"finishReceiver called but none active");
            }
            return false;
        }
        if (r.receiver != receiver) {
            Slog.w((String)TAG, (String)"finishReceiver called but active receiver is different");
            return false;
        }
        int state = r.state;
        r.state = 0;
        if (state == 0 && explicit) {
            Slog.w((String)TAG, (String)"finishReceiver called but state is IDLE");
        }
        r.receiver = null;
        r.intent.setComponent(null);
        if (r.curApp != null) {
            r.curApp.curReceiver = null;
        }
        if (r.curFilter != null) {
            r.curFilter.receiverList.curBroadcast = null;
        }
        r.curFilter = null;
        r.curApp = null;
        r.curComponent = null;
        r.curReceiver = null;
        this.mPendingBroadcast = null;
        r.resultCode = resultCode;
        r.resultData = resultData;
        r.resultExtras = resultExtras;
        r.resultAbort = resultAbort;
        return state == 1 || state == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishReceiver(IBinder who, int resultCode, String resultData, Bundle resultExtras, boolean resultAbort) {
        boolean doNext;
        if (resultExtras != null && resultExtras.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            doNext = this.finishReceiverLocked(who, resultCode, resultData, resultExtras, resultAbort, true);
        }
        if (doNext) {
            this.processNextBroadcast(false);
        }
        this.trimApplications();
        Binder.restoreCallingIdentity((long)origId);
    }

    private final void logBroadcastReceiverDiscardLocked(BroadcastRecord r) {
        if (r.nextReceiver > 0) {
            Object curReceiver = r.receivers.get(r.nextReceiver - 1);
            if (curReceiver instanceof BroadcastFilter) {
                BroadcastFilter bf = (BroadcastFilter)((Object)curReceiver);
                EventLog.writeEvent((int)30024, (Object[])new Object[]{System.identityHashCode((Object)r), r.intent.getAction(), r.nextReceiver - 1, System.identityHashCode((Object)bf)});
            } else {
                EventLog.writeEvent((int)30025, (Object[])new Object[]{System.identityHashCode((Object)r), r.intent.getAction(), r.nextReceiver - 1, ((ResolveInfo)curReceiver).toString()});
            }
        } else {
            Slog.w((String)TAG, (String)("Discarding broadcast before first receiver is invoked: " + (Object)((Object)r)));
            EventLog.writeEvent((int)30025, (Object[])new Object[]{System.identityHashCode((Object)r), r.intent.getAction(), r.nextReceiver, "NONE"});
        }
    }

    private final void setBroadcastTimeoutLocked(long timeoutTime) {
        if (!this.mPendingBroadcastTimeoutMessage) {
            Message msg = this.mHandler.obtainMessage(8);
            this.mHandler.sendMessageAtTime(msg, timeoutTime);
            this.mPendingBroadcastTimeoutMessage = true;
        }
    }

    private final void cancelBroadcastTimeoutLocked() {
        if (this.mPendingBroadcastTimeoutMessage) {
            this.mHandler.removeMessages(8);
            this.mPendingBroadcastTimeoutMessage = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void broadcastTimeoutLocked(boolean fromMsg) {
        if (fromMsg) {
            this.mPendingBroadcastTimeoutMessage = false;
        }
        if (this.mOrderedBroadcasts.size() == 0) {
            return;
        }
        long now = SystemClock.uptimeMillis();
        BroadcastRecord r = this.mOrderedBroadcasts.get(0);
        if (fromMsg) {
            if (this.mDidDexOpt) {
                this.mDidDexOpt = false;
                long timeoutTime = SystemClock.uptimeMillis() + 10000L;
                this.setBroadcastTimeoutLocked(timeoutTime);
                return;
            }
            if (!this.mProcessesReady) {
                return;
            }
            long timeoutTime = r.receiverTime + 10000L;
            if (timeoutTime > now) {
                this.setBroadcastTimeoutLocked(timeoutTime);
                return;
            }
        }
        Slog.w((String)TAG, (String)("Timeout of broadcast " + (Object)((Object)r) + " - receiver=" + r.receiver + ", started " + (now - r.receiverTime) + "ms ago"));
        r.receiverTime = now;
        ++r.anrCount;
        if (r.nextReceiver <= 0) {
            Slog.w((String)TAG, (String)"Timeout on receiver with nextReceiver <= 0");
            return;
        }
        ProcessRecord app = null;
        String anrMessage = null;
        Object curReceiver = r.receivers.get(r.nextReceiver - 1);
        Slog.w((String)TAG, (String)("Receiver during timeout: " + curReceiver));
        this.logBroadcastReceiverDiscardLocked(r);
        if (curReceiver instanceof BroadcastFilter) {
            BroadcastFilter bf = (BroadcastFilter)((Object)curReceiver);
            if (bf.receiverList.pid != 0 && bf.receiverList.pid != MY_PID) {
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    app = (ProcessRecord)this.mPidsSelfLocked.get(bf.receiverList.pid);
                }
            }
        } else {
            app = r.curApp;
        }
        if (app != null) {
            anrMessage = "Broadcast of " + r.intent.toString();
        }
        if (this.mPendingBroadcast == r) {
            this.mPendingBroadcast = null;
        }
        this.finishReceiverLocked(r.receiver, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, true);
        this.scheduleBroadcastsLocked();
        if (anrMessage != null) {
            this.mHandler.post((Runnable)new AppNotResponding(app, anrMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processCurBroadcastLocked(BroadcastRecord r, ProcessRecord app) throws RemoteException {
        if (app.thread == null) {
            throw new RemoteException();
        }
        r.receiver = app.thread.asBinder();
        r.curApp = app;
        app.curReceiver = r;
        this.updateLruProcessLocked(app, true, true);
        r.intent.setComponent(r.curComponent);
        boolean started = false;
        try {
            this.ensurePackageDexOpt(r.intent.getComponent().getPackageName());
            app.thread.scheduleReceiver(new Intent(r.intent), r.curReceiver, this.compatibilityInfoForPackageLocked(r.curReceiver.applicationInfo), r.resultCode, r.resultData, r.resultExtras, r.ordered);
            started = true;
            Object var5_4 = null;
            if (!started) {
                r.receiver = null;
                r.curApp = null;
                app.curReceiver = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!started) {
                r.receiver = null;
                r.curApp = null;
                app.curReceiver = null;
            }
            throw throwable;
        }
    }

    static void performReceiveLocked(ProcessRecord app, IIntentReceiver receiver, Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky) throws RemoteException {
        if (app != null && app.thread != null) {
            app.thread.scheduleRegisteredReceiver(receiver, intent, resultCode, data, extras, ordered, sticky);
        } else {
            receiver.performReceive(intent, resultCode, data, extras, ordered, sticky);
        }
    }

    private final void deliverToRegisteredReceiverLocked(BroadcastRecord r, BroadcastFilter filter, boolean ordered) {
        block8: {
            int perm;
            boolean skip = false;
            if (filter.requiredPermission != null && (perm = this.checkComponentPermission(filter.requiredPermission, r.callingPid, r.callingUid, -1, true)) != 0) {
                Slog.w((String)TAG, (String)("Permission Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " requires " + filter.requiredPermission + " due to registered receiver " + (Object)((Object)filter)));
                skip = true;
            }
            if (r.requiredPermission != null && (perm = this.checkComponentPermission(r.requiredPermission, filter.receiverList.pid, filter.receiverList.uid, -1, true)) != 0) {
                Slog.w((String)TAG, (String)("Permission Denial: receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ")" + " requires " + r.requiredPermission + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")"));
                skip = true;
            }
            if (!skip) {
                if (ordered) {
                    r.receiver = filter.receiverList.receiver.asBinder();
                    r.curFilter = filter;
                    filter.receiverList.curBroadcast = r;
                    r.state = 2;
                    if (filter.receiverList.app != null) {
                        r.curApp = filter.receiverList.app;
                        filter.receiverList.app.curReceiver = r;
                        this.updateOomAdjLocked();
                    }
                }
                try {
                    ActivityManagerService.performReceiveLocked(filter.receiverList.app, filter.receiverList.receiver, new Intent(r.intent), r.resultCode, r.resultData, r.resultExtras, r.ordered, r.initialSticky);
                    if (ordered) {
                        r.state = 3;
                    }
                }
                catch (RemoteException e) {
                    Slog.w((String)TAG, (String)("Failure sending broadcast " + r.intent), (Throwable)e);
                    if (!ordered) break block8;
                    r.receiver = null;
                    r.curFilter = null;
                    filter.receiverList.curBroadcast = null;
                    if (filter.receiverList.app == null) break block8;
                    filter.receiverList.app.curReceiver = null;
                }
            }
        }
    }

    private final void addBroadcastToHistoryLocked(BroadcastRecord r) {
        if (r.callingUid < 0) {
            return;
        }
        System.arraycopy(this.mBroadcastHistory, 0, this.mBroadcastHistory, 1, 24);
        r.finishTime = SystemClock.uptimeMillis();
        this.mBroadcastHistory[0] = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processNextBroadcast(boolean fromMsg) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            Object nextReceiver;
            BroadcastRecord r;
            this.updateCpuStats();
            if (fromMsg) {
                this.mBroadcastsScheduled = false;
            }
            while (this.mParallelBroadcasts.size() > 0) {
                r = this.mParallelBroadcasts.remove(0);
                r.dispatchTime = SystemClock.uptimeMillis();
                r.dispatchClockTime = System.currentTimeMillis();
                int N = r.receivers.size();
                for (int i = 0; i < N; ++i) {
                    Object target = r.receivers.get(i);
                    this.deliverToRegisteredReceiverLocked(r, (BroadcastFilter)((Object)target), false);
                }
                this.addBroadcastToHistoryLocked(r);
            }
            if (this.mPendingBroadcast != null) {
                boolean isDead;
                SparseArray<ProcessRecord> i = this.mPidsSelfLocked;
                synchronized (i) {
                    isDead = this.mPidsSelfLocked.get(this.mPendingBroadcast.curApp.pid) == null;
                }
                if (!isDead) {
                    return;
                }
                Slog.w((String)TAG, (String)("pending app " + this.mPendingBroadcast.curApp + " died before responding to broadcast"));
                this.mPendingBroadcast.state = 0;
                this.mPendingBroadcast.nextReceiver = this.mPendingBroadcastRecvIndex;
                this.mPendingBroadcast = null;
            }
            boolean looped = false;
            do {
                int numReceivers;
                if (this.mOrderedBroadcasts.size() == 0) {
                    this.scheduleAppGcsLocked();
                    if (looped) {
                        this.updateOomAdjLocked();
                    }
                    return;
                }
                r = this.mOrderedBroadcasts.get(0);
                boolean forceReceive = false;
                int n = numReceivers = r.receivers != null ? r.receivers.size() : 0;
                if (this.mProcessesReady && r.dispatchTime > 0L) {
                    long now = SystemClock.uptimeMillis();
                    if (numReceivers > 0 && now > r.dispatchTime + (long)(20000 * numReceivers)) {
                        Slog.w((String)TAG, (String)("Hung broadcast discarded after timeout failure: now=" + now + " dispatchTime=" + r.dispatchTime + " startTime=" + r.receiverTime + " intent=" + r.intent + " numReceivers=" + numReceivers + " nextReceiver=" + r.nextReceiver + " state=" + r.state));
                        this.broadcastTimeoutLocked(false);
                        forceReceive = true;
                        r.state = 0;
                    }
                }
                if (r.state != 0) {
                    return;
                }
                if (r.receivers != null && r.nextReceiver < numReceivers && !r.resultAbort && !forceReceive) continue;
                if (r.resultTo != null) {
                    try {
                        ActivityManagerService.performReceiveLocked(r.callerApp, r.resultTo, new Intent(r.intent), r.resultCode, r.resultData, r.resultExtras, false, false);
                        r.resultTo = null;
                    }
                    catch (RemoteException e) {
                        Slog.w((String)TAG, (String)("Failure sending broadcast result of " + r.intent), (Throwable)e);
                    }
                }
                this.cancelBroadcastTimeoutLocked();
                this.addBroadcastToHistoryLocked(r);
                this.mOrderedBroadcasts.remove(0);
                r = null;
                looped = true;
            } while (r == null);
            int recIdx = r.nextReceiver++;
            r.receiverTime = SystemClock.uptimeMillis();
            if (recIdx == 0) {
                r.dispatchTime = r.receiverTime;
                r.dispatchClockTime = System.currentTimeMillis();
            }
            if (!this.mPendingBroadcastTimeoutMessage) {
                long timeoutTime = r.receiverTime + 10000L;
                this.setBroadcastTimeoutLocked(timeoutTime);
            }
            if ((nextReceiver = r.receivers.get(recIdx)) instanceof BroadcastFilter) {
                BroadcastFilter filter = (BroadcastFilter)((Object)nextReceiver);
                this.deliverToRegisteredReceiverLocked(r, filter, r.ordered);
                if (r.receiver == null || !r.ordered) {
                    r.state = 0;
                    this.scheduleBroadcastsLocked();
                }
                return;
            }
            ResolveInfo info = (ResolveInfo)nextReceiver;
            boolean skip = false;
            int perm = this.checkComponentPermission(info.activityInfo.permission, r.callingPid, r.callingUid, info.activityInfo.applicationInfo.uid, info.activityInfo.exported);
            if (perm != 0) {
                if (!info.activityInfo.exported) {
                    Slog.w((String)TAG, (String)("Permission Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " is not exported from uid " + info.activityInfo.applicationInfo.uid + " due to receiver " + info.activityInfo.packageName + "/" + info.activityInfo.name));
                } else {
                    Slog.w((String)TAG, (String)("Permission Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " requires " + info.activityInfo.permission + " due to receiver " + info.activityInfo.packageName + "/" + info.activityInfo.name));
                }
                skip = true;
            }
            if (info.activityInfo.applicationInfo.uid != 1000 && r.requiredPermission != null) {
                try {
                    perm = AppGlobals.getPackageManager().checkPermission(r.requiredPermission, info.activityInfo.applicationInfo.packageName);
                }
                catch (RemoteException e) {
                    perm = -1;
                }
                if (perm != 0) {
                    Slog.w((String)TAG, (String)("Permission Denial: receiving " + r.intent + " to " + info.activityInfo.applicationInfo.packageName + " requires " + r.requiredPermission + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")"));
                    skip = true;
                }
            }
            if (r.curApp != null && r.curApp.crashing) {
                skip = true;
            }
            if (skip) {
                r.receiver = null;
                r.curFilter = null;
                r.state = 0;
                this.scheduleBroadcastsLocked();
                return;
            }
            r.state = 1;
            String targetProcess = info.activityInfo.processName;
            r.curComponent = new ComponentName(info.activityInfo.applicationInfo.packageName, info.activityInfo.name);
            r.curReceiver = info.activityInfo;
            try {
                AppGlobals.getPackageManager().setPackageStoppedState(r.curComponent.getPackageName(), false);
            }
            catch (RemoteException e) {
            }
            catch (IllegalArgumentException e) {
                Slog.w((String)TAG, (String)("Failed trying to unstop package " + r.curComponent.getPackageName() + ": " + e));
            }
            ProcessRecord app = this.getProcessRecordLocked(targetProcess, info.activityInfo.applicationInfo.uid);
            if (app != null && app.thread != null) {
                try {
                    app.addPackage(info.activityInfo.packageName);
                    this.processCurBroadcastLocked(r, app);
                    return;
                }
                catch (RemoteException e) {
                    Slog.w((String)TAG, (String)("Exception when sending broadcast to " + r.curComponent), (Throwable)e);
                }
            }
            if ((r.curApp = this.startProcessLocked(targetProcess, info.activityInfo.applicationInfo, true, r.intent.getFlags() | 4, "broadcast", r.curComponent, (r.intent.getFlags() & 0x8000000) != 0)) == null) {
                Slog.w((String)TAG, (String)("Unable to launch app " + info.activityInfo.applicationInfo.packageName + "/" + info.activityInfo.applicationInfo.uid + " for broadcast " + r.intent + ": process is bad"));
                this.logBroadcastReceiverDiscardLocked(r);
                this.finishReceiverLocked(r.receiver, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, true);
                this.scheduleBroadcastsLocked();
                r.state = 0;
                return;
            }
            this.mPendingBroadcast = r;
            this.mPendingBroadcastRecvIndex = recIdx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startInstrumentation(ComponentName className, String profileFile, int flags, Bundle arguments, IInstrumentationWatcher watcher) {
        if (arguments != null && arguments.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            InstrumentationInfo ii = null;
            ApplicationInfo ai = null;
            try {
                ii = this.mContext.getPackageManager().getInstrumentationInfo(className, 1024);
                ai = this.mContext.getPackageManager().getApplicationInfo(ii.targetPackage, 1024);
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
            if (ii == null) {
                this.reportStartInstrumentationFailure(watcher, className, "Unable to find instrumentation info for: " + className);
                return false;
            }
            if (ai == null) {
                this.reportStartInstrumentationFailure(watcher, className, "Unable to find instrumentation target package: " + ii.targetPackage);
                return false;
            }
            int match = this.mContext.getPackageManager().checkSignatures(ii.targetPackage, ii.packageName);
            if (match < 0 && match != -1) {
                String msg = "Permission Denial: starting instrumentation " + className + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingPid() + " not allowed because package " + ii.packageName + " does not have a signature matching the target " + ii.targetPackage;
                this.reportStartInstrumentationFailure(watcher, className, msg);
                throw new SecurityException(msg);
            }
            long origId = Binder.clearCallingIdentity();
            this.forceStopPackageLocked(ii.targetPackage, -1, true, false, true, true);
            ProcessRecord app = this.addAppLocked(ai);
            app.instrumentationClass = className;
            app.instrumentationInfo = ai;
            app.instrumentationProfileFile = profileFile;
            app.instrumentationArguments = arguments;
            app.instrumentationWatcher = watcher;
            app.instrumentationResultClass = className;
            Binder.restoreCallingIdentity((long)origId);
        }
        return true;
    }

    private void reportStartInstrumentationFailure(IInstrumentationWatcher watcher, ComponentName cn, String report) {
        Slog.w((String)TAG, (String)report);
        try {
            if (watcher != null) {
                Bundle results = new Bundle();
                results.putString("id", "ActivityManagerService");
                results.putString("Error", report);
                watcher.instrumentationStatus(cn, -1, results);
            }
        }
        catch (RemoteException e) {
            Slog.w((String)TAG, (Throwable)e);
        }
    }

    void finishInstrumentationLocked(ProcessRecord app, int resultCode, Bundle results) {
        if (app.instrumentationWatcher != null) {
            try {
                app.instrumentationWatcher.instrumentationFinished(app.instrumentationClass, resultCode, results);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        app.instrumentationWatcher = null;
        app.instrumentationClass = null;
        app.instrumentationInfo = null;
        app.instrumentationProfileFile = null;
        app.instrumentationArguments = null;
        this.forceStopPackageLocked(app.processName, -1, false, false, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishInstrumentation(IApplicationThread target, int resultCode, Bundle results) {
        if (results != null && results.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app = this.getRecordForAppLocked(target);
            if (app == null) {
                Slog.w((String)TAG, (String)("finishInstrumentation: no app for " + target));
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.finishInstrumentationLocked(app, resultCode, results);
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationInfo getDeviceConfigurationInfo() {
        ConfigurationInfo config = new ConfigurationInfo();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            config.reqTouchScreen = this.mConfiguration.touchscreen;
            config.reqKeyboardType = this.mConfiguration.keyboard;
            config.reqNavigation = this.mConfiguration.navigation;
            if (this.mConfiguration.navigation == 2 || this.mConfiguration.navigation == 3) {
                config.reqInputFeatures |= 2;
            }
            if (this.mConfiguration.keyboard != 0 && this.mConfiguration.keyboard != 1) {
                config.reqInputFeatures |= 1;
            }
            config.reqGlEsVersion = this.GL_ES_VERSION;
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration() {
        Configuration ci;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ci = new Configuration(this.mConfiguration);
        }
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePersistentConfiguration(Configuration values) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
        this.enforceCallingPermission("android.permission.WRITE_SETTINGS", "updateConfiguration()");
        if (values == null) {
            throw new NullPointerException("Configuration must not be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            this.updateConfigurationLocked(values, null, true, false);
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(Configuration values) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (values == null && this.mWindowManager != null) {
                values = this.mWindowManager.computeNewConfiguration();
            }
            if (this.mWindowManager != null) {
                this.mProcessList.applyDisplaySize(this.mWindowManager);
            }
            long origId = Binder.clearCallingIdentity();
            if (values != null) {
                Settings.System.clearConfiguration((Configuration)values);
            }
            this.updateConfigurationLocked(values, null, false, false);
            Binder.restoreCallingIdentity((long)origId);
        }
    }

    public boolean updateConfigurationLocked(Configuration values, ActivityRecord starting, boolean persistent, boolean initLocale) {
        Configuration newConfig;
        int changes = 0;
        boolean kept = true;
        if (values != null && (changes = (newConfig = new Configuration(this.mConfiguration)).updateFrom(values)) != 0) {
            EventLog.writeEvent((int)2719, (int)changes);
            if (values.locale != null && !initLocale) {
                this.saveLocaleLocked(values.locale, !values.locale.equals(this.mConfiguration.locale), values.userSetLocale);
            }
            ++this.mConfigurationSeq;
            if (this.mConfigurationSeq <= 0) {
                this.mConfigurationSeq = 1;
            }
            newConfig.seq = this.mConfigurationSeq;
            this.mConfiguration = newConfig;
            Slog.i((String)TAG, (String)("Config changed: " + newConfig));
            Configuration configCopy = new Configuration(this.mConfiguration);
            AttributeCache ac = AttributeCache.instance();
            if (ac != null) {
                ac.updateConfiguration(configCopy);
            }
            mSystemThread.applyConfigurationToResources(configCopy);
            if (persistent && Settings.System.hasInterestingConfigurationChanges((int)changes)) {
                Message msg = this.mHandler.obtainMessage(4);
                msg.obj = new Configuration(configCopy);
                this.mHandler.sendMessage(msg);
            }
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                try {
                    if (app.thread == null) continue;
                    app.thread.scheduleConfigurationChanged(configCopy);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Intent intent = new Intent("android.intent.action.CONFIGURATION_CHANGED");
            intent.addFlags(0x60000000);
            this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, false, false, MY_PID, 1000);
            if ((changes & 4) != 0) {
                this.broadcastIntentLocked(null, null, new Intent("android.intent.action.LOCALE_CHANGED"), null, null, 0, null, null, null, false, false, MY_PID, 1000);
            }
        }
        if (changes != 0 && starting == null) {
            starting = this.mMainStack.topRunningActivityLocked(null);
        }
        if (starting != null) {
            kept = this.mMainStack.ensureActivityConfigurationLocked(starting, changes);
            this.mMainStack.ensureActivitiesVisibleLocked(starting, changes);
        }
        if (values != null && this.mWindowManager != null) {
            this.mWindowManager.setNewConfiguration(this.mConfiguration);
        }
        return kept;
    }

    private void saveLocaleLocked(Locale l, boolean isDiff, boolean isPersist) {
        if (isDiff) {
            SystemProperties.set((String)"user.language", (String)l.getLanguage());
            SystemProperties.set((String)"user.region", (String)l.getCountry());
        }
        if (isPersist) {
            SystemProperties.set((String)"persist.sys.language", (String)l.getLanguage());
            SystemProperties.set((String)"persist.sys.country", (String)l.getCountry());
            SystemProperties.set((String)"persist.sys.localevar", (String)l.getVariant());
        }
    }

    private final int computeOomAdjLocked(ProcessRecord app, int hiddenAdj, ProcessRecord TOP_APP, boolean recursed, boolean doingAll) {
        int schedGroup;
        int adj;
        if (this.mAdjSeq == app.adjSeq) {
            if (!recursed && app.hidden) {
                app.curAdj = app.curRawAdj = hiddenAdj;
            }
            return app.curRawAdj;
        }
        if (app.thread == null) {
            app.adjSeq = this.mAdjSeq;
            app.curSchedGroup = 1;
            app.curAdj = 15;
            return 15;
        }
        app.adjTypeCode = 0;
        app.adjSource = null;
        app.adjTarget = null;
        app.empty = false;
        app.hidden = false;
        int activitiesSize = app.activities.size();
        if (app.maxAdj <= 0) {
            app.adjType = "fixed";
            app.adjSeq = this.mAdjSeq;
            app.curRawAdj = app.maxAdj;
            app.foregroundActivities = false;
            app.keeping = true;
            app.curSchedGroup = 0;
            app.systemNoUi = true;
            if (app == TOP_APP) {
                app.systemNoUi = false;
            } else if (activitiesSize > 0) {
                for (int j = 0; j < activitiesSize; ++j) {
                    ActivityRecord r = app.activities.get(j);
                    if (!r.visible) continue;
                    app.systemNoUi = false;
                    break;
                }
            }
            app.curAdj = app.maxAdj;
            return app.curAdj;
        }
        boolean hadForegroundActivities = app.foregroundActivities;
        app.foregroundActivities = false;
        app.keeping = false;
        app.systemNoUi = false;
        if (app == TOP_APP) {
            adj = 0;
            schedGroup = 0;
            app.adjType = "top-activity";
            app.foregroundActivities = true;
        } else if (app.instrumentationClass != null) {
            adj = 0;
            schedGroup = 0;
            app.adjType = "instrumentation";
        } else if (app.curReceiver != null || this.mPendingBroadcast != null && this.mPendingBroadcast.curApp == app) {
            adj = 0;
            schedGroup = 0;
            app.adjType = "broadcast";
        } else if (app.executingServices.size() > 0) {
            adj = 0;
            schedGroup = 0;
            app.adjType = "exec-service";
        } else if (activitiesSize > 0) {
            adj = hiddenAdj;
            schedGroup = 1;
            app.hidden = true;
            app.adjType = "bg-activities";
        } else {
            adj = hiddenAdj;
            schedGroup = 1;
            app.hidden = true;
            app.empty = true;
            app.adjType = "bg-empty";
        }
        if (!app.foregroundActivities && activitiesSize > 0) {
            for (int j = 0; j < activitiesSize; ++j) {
                ActivityRecord r = app.activities.get(j);
                if (r.visible) {
                    if (adj > 1) {
                        adj = 1;
                        app.adjType = "visible";
                    }
                    schedGroup = 0;
                    app.hidden = false;
                    app.foregroundActivities = true;
                    break;
                }
                if (r.state != ActivityStack.ActivityState.PAUSING && r.state != ActivityStack.ActivityState.PAUSED && r.state != ActivityStack.ActivityState.STOPPING) continue;
                if (adj > 2) {
                    adj = 2;
                    app.adjType = "stopping";
                }
                app.hidden = false;
                app.foregroundActivities = true;
            }
        }
        if (adj > 2) {
            if (app.foregroundServices) {
                adj = 2;
                app.hidden = false;
                app.adjType = "foreground-service";
                schedGroup = 0;
            } else if (app.forcingToForeground != null) {
                adj = 2;
                app.hidden = false;
                app.adjType = "force-foreground";
                app.adjSource = app.forcingToForeground;
                schedGroup = 0;
            }
        }
        if (adj > 3 && app == this.mHeavyWeightProcess) {
            adj = 3;
            schedGroup = 1;
            app.hidden = false;
            app.adjType = "heavy";
        }
        if (adj > 6 && app == this.mHomeProcess) {
            adj = 6;
            schedGroup = 1;
            app.hidden = false;
            app.adjType = "home";
        }
        if (adj > 7 && app == this.mPreviousProcess && app.activities.size() > 0) {
            adj = 7;
            schedGroup = 1;
            app.hidden = false;
            app.adjType = "previous";
        }
        app.adjSeq = this.mAdjSeq;
        app.curRawAdj = adj;
        if (this.mBackupTarget != null && app == this.mBackupTarget.app && adj > 4) {
            adj = 4;
            app.adjType = "backup";
            app.hidden = false;
        }
        if (app.services.size() != 0 && (adj > 0 || schedGroup == 1)) {
            long now = SystemClock.uptimeMillis();
            Iterator<ServiceRecord> jt = app.services.iterator();
            while (jt.hasNext() && adj > 0) {
                ServiceRecord s = jt.next();
                if (s.startRequested) {
                    if (app.hasShownUi && app != this.mHomeProcess) {
                        if (adj > 5) {
                            app.adjType = "started-bg-ui-services";
                        }
                    } else {
                        if (now < s.lastActivity + 1800000L && adj > 5) {
                            adj = 5;
                            app.adjType = "started-services";
                            app.hidden = false;
                        }
                        if (adj > 5) {
                            app.adjType = "started-bg-services";
                        }
                    }
                    app.keeping = true;
                }
                if (s.connections.size() <= 0 || adj <= 0 && schedGroup != true) continue;
                Iterator<ArrayList<ConnectionRecord>> kt = s.connections.values().iterator();
                while (kt.hasNext() && adj > 0) {
                    ArrayList<ConnectionRecord> clist = kt.next();
                    for (int i = 0; i < clist.size() && adj > 0; ++i) {
                        ActivityRecord a;
                        ConnectionRecord cr = clist.get(i);
                        if (cr.binding.client == app) continue;
                        if ((cr.flags & 0x20) == 0) {
                            ProcessRecord client = cr.binding.client;
                            int clientAdj = adj;
                            int myHiddenAdj = hiddenAdj;
                            if (myHiddenAdj > client.hiddenAdj) {
                                myHiddenAdj = client.hiddenAdj >= 1 ? client.hiddenAdj : 1;
                            }
                            clientAdj = this.computeOomAdjLocked(client, myHiddenAdj, TOP_APP, true, doingAll);
                            String adjType = null;
                            if ((cr.flags & 0x10) != 0) {
                                if (app.hasShownUi && app != this.mHomeProcess) {
                                    if (adj > clientAdj) {
                                        adjType = "bound-bg-ui-services";
                                    }
                                    app.hidden = false;
                                    clientAdj = adj;
                                } else if (now >= s.lastActivity + 1800000L) {
                                    if (adj > clientAdj) {
                                        adjType = "bound-bg-services";
                                    }
                                    clientAdj = adj;
                                }
                            }
                            if (adj > clientAdj) {
                                if (app.hasShownUi && app != this.mHomeProcess && clientAdj > 2) {
                                    adjType = "bound-bg-ui-services";
                                } else {
                                    if ((cr.flags & 0x48) != 0) {
                                        adj = clientAdj;
                                    } else if ((cr.flags & 0x40000000) != 0 && clientAdj < 2 && adj > 2) {
                                        adj = 2;
                                    } else if (clientAdj > 1) {
                                        adj = clientAdj;
                                    } else {
                                        app.pendingUiClean = true;
                                        if (adj > 1) {
                                            adj = 1;
                                        }
                                    }
                                    if (!client.hidden) {
                                        app.hidden = false;
                                    }
                                    if (client.keeping) {
                                        app.keeping = true;
                                    }
                                    adjType = "service";
                                }
                            }
                            if (adjType != null) {
                                app.adjType = adjType;
                                app.adjTypeCode = 2;
                                app.adjSource = cr.binding.client;
                                app.adjSourceOom = clientAdj;
                                app.adjTarget = s.name;
                            }
                            if ((cr.flags & 4) == 0 && client.curSchedGroup == 0) {
                                schedGroup = 0;
                            }
                        }
                        if ((cr.flags & 0x80) == 0 || (a = cr.activity) == null || adj <= 0 || !a.visible && a.state != ActivityStack.ActivityState.RESUMED && a.state != ActivityStack.ActivityState.PAUSING) continue;
                        adj = 0;
                        if ((cr.flags & 4) == 0) {
                            schedGroup = 0;
                        }
                        app.hidden = false;
                        app.adjType = "service";
                        app.adjTypeCode = 2;
                        app.adjSource = a;
                        app.adjSourceOom = adj;
                        app.adjTarget = s.name;
                    }
                }
            }
            if (adj > hiddenAdj) {
                adj = hiddenAdj;
                app.hidden = false;
                app.adjType = "bg-services";
            }
        }
        if (app.pubProviders.size() != 0 && (adj > 0 || schedGroup == 1)) {
            Iterator<ContentProviderRecord> jt = app.pubProviders.values().iterator();
            while (jt.hasNext() && (adj > 0 || schedGroup == 1)) {
                ContentProviderRecord cpr = jt.next();
                if (cpr.clients.size() != 0) {
                    Iterator<ProcessRecord> kt = cpr.clients.iterator();
                    while (kt.hasNext() && adj > 0) {
                        int clientAdj;
                        ProcessRecord client = kt.next();
                        if (client == app) continue;
                        int myHiddenAdj = hiddenAdj;
                        if (myHiddenAdj > client.hiddenAdj) {
                            myHiddenAdj = client.hiddenAdj > 0 ? client.hiddenAdj : 0;
                        }
                        if (adj > (clientAdj = this.computeOomAdjLocked(client, myHiddenAdj, TOP_APP, true, doingAll))) {
                            if (app.hasShownUi && app != this.mHomeProcess && clientAdj > 2) {
                                app.adjType = "bg-ui-provider";
                            } else {
                                adj = clientAdj > 0 ? clientAdj : 0;
                                app.adjType = "provider";
                            }
                            if (!client.hidden) {
                                app.hidden = false;
                            }
                            if (client.keeping) {
                                app.keeping = true;
                            }
                            app.adjTypeCode = 1;
                            app.adjSource = client;
                            app.adjSourceOom = clientAdj;
                            app.adjTarget = cpr.name;
                        }
                        if (client.curSchedGroup != 0) continue;
                        schedGroup = 0;
                    }
                }
                if (cpr.externals == 0 || adj <= 0) continue;
                adj = 0;
                schedGroup = 0;
                app.hidden = false;
                app.keeping = true;
                app.adjType = "provider";
                app.adjTarget = cpr.name;
            }
        }
        app.curRawAdj = adj;
        if (adj > app.maxAdj) {
            adj = app.maxAdj;
            if (app.maxAdj <= 2) {
                schedGroup = 0;
            }
        }
        if (adj < ProcessList.HIDDEN_APP_MIN_ADJ) {
            app.keeping = true;
        }
        if (app.hasAboveClient && adj >= 0) {
            if (adj < 1) {
                adj = 1;
            } else if (adj < 2) {
                adj = 2;
            } else if (adj < ProcessList.HIDDEN_APP_MIN_ADJ) {
                adj = ProcessList.HIDDEN_APP_MIN_ADJ;
            } else if (adj < 15) {
                ++adj;
            }
        }
        if (adj == 5) {
            if (doingAll) {
                app.serviceb = this.mNewNumServiceProcs > this.mNumServiceProcs / 3;
                ++this.mNewNumServiceProcs;
            }
            if (app.serviceb) {
                adj = 8;
            }
        } else {
            app.serviceb = false;
        }
        app.curAdj = adj;
        app.curSchedGroup = schedGroup;
        if (hadForegroundActivities != app.foregroundActivities) {
            this.mHandler.obtainMessage(31, app.pid, app.info.uid, (Object)app.foregroundActivities).sendToTarget();
        }
        return app.curRawAdj;
    }

    final void performAppGcLocked(ProcessRecord app) {
        try {
            app.lastRequestedGc = SystemClock.uptimeMillis();
            if (app.thread != null) {
                if (app.reportLowMemory) {
                    app.reportLowMemory = false;
                    app.thread.scheduleLowMemory();
                } else {
                    app.thread.processInBackground();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean canGcNowLocked() {
        return this.mParallelBroadcasts.size() == 0 && this.mOrderedBroadcasts.size() == 0 && (this.mSleeping || this.mMainStack.mResumedActivity != null && this.mMainStack.mResumedActivity.idle);
    }

    final void performAppGcsLocked() {
        int N = this.mProcessesToGc.size();
        if (N <= 0) {
            return;
        }
        if (this.canGcNowLocked()) {
            while (this.mProcessesToGc.size() > 0) {
                ProcessRecord proc = this.mProcessesToGc.remove(0);
                if (proc.curRawAdj <= 2 && !proc.reportLowMemory) continue;
                if (proc.lastRequestedGc + 60000L <= SystemClock.uptimeMillis()) {
                    this.performAppGcLocked(proc);
                    this.scheduleAppGcsLocked();
                    return;
                }
                this.addProcessToGcListLocked(proc);
                break;
            }
            this.scheduleAppGcsLocked();
        }
    }

    final void performAppGcsIfAppropriateLocked() {
        if (this.canGcNowLocked()) {
            this.performAppGcsLocked();
            return;
        }
        this.scheduleAppGcsLocked();
    }

    final void scheduleAppGcsLocked() {
        this.mHandler.removeMessages(5);
        if (this.mProcessesToGc.size() > 0) {
            ProcessRecord proc = this.mProcessesToGc.get(0);
            Message msg = this.mHandler.obtainMessage(5);
            long when = proc.lastRequestedGc + 60000L;
            long now = SystemClock.uptimeMillis();
            if (when < now + 5000L) {
                when = now + 5000L;
            }
            this.mHandler.sendMessageAtTime(msg, when);
        }
    }

    final void addProcessToGcListLocked(ProcessRecord proc) {
        boolean added = false;
        for (int i = this.mProcessesToGc.size() - 1; i >= 0; --i) {
            if (this.mProcessesToGc.get((int)i).lastRequestedGc >= proc.lastRequestedGc) continue;
            added = true;
            this.mProcessesToGc.add(i + 1, proc);
            break;
        }
        if (!added) {
            this.mProcessesToGc.add(0, proc);
        }
    }

    final void scheduleAppGcLocked(ProcessRecord app) {
        long now = SystemClock.uptimeMillis();
        if (app.lastRequestedGc + 60000L > now) {
            return;
        }
        if (!this.mProcessesToGc.contains(app)) {
            this.addProcessToGcListLocked(app);
            this.scheduleAppGcsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkExcessivePowerUsageLocked(boolean doKills) {
        this.updateCpuStatsNow();
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        boolean doWakeKills = doKills;
        boolean doCpuKills = doKills;
        if (this.mLastPowerCheckRealtime == 0L) {
            doWakeKills = false;
        }
        if (this.mLastPowerCheckUptime == 0L) {
            doCpuKills = false;
        }
        if (stats.isScreenOn()) {
            doWakeKills = false;
        }
        long curRealtime = SystemClock.elapsedRealtime();
        long realtimeSince = curRealtime - this.mLastPowerCheckRealtime;
        long curUptime = SystemClock.uptimeMillis();
        long uptimeSince = curUptime - this.mLastPowerCheckUptime;
        this.mLastPowerCheckRealtime = curRealtime;
        this.mLastPowerCheckUptime = curUptime;
        if (realtimeSince < 300000L) {
            doWakeKills = false;
        }
        if (uptimeSince < 300000L) {
            doCpuKills = false;
        }
        int i = this.mLruProcesses.size();
        while (i > 0) {
            BatteryStatsImpl batteryStatsImpl;
            long wtime;
            ProcessRecord app = this.mLruProcesses.get(--i);
            if (app.keeping) continue;
            BatteryStatsImpl batteryStatsImpl2 = stats;
            synchronized (batteryStatsImpl2) {
                wtime = stats.getProcessWakeTime(app.info.uid, app.pid, curRealtime);
            }
            long wtimeUsed = wtime - app.lastWakeTime;
            long cputimeUsed = app.curCpuTime - app.lastCpuTime;
            if (doWakeKills && realtimeSince > 0L && wtimeUsed * 100L / realtimeSince >= 50L) {
                batteryStatsImpl = stats;
                synchronized (batteryStatsImpl) {
                    stats.reportExcessiveWakeLocked(app.info.uid, app.processName, realtimeSince, wtimeUsed);
                }
                Slog.w((String)TAG, (String)("Excessive wake lock in " + app.processName + " (pid " + app.pid + "): held " + wtimeUsed + " during " + realtimeSince));
                EventLog.writeEvent((int)30023, (Object[])new Object[]{app.pid, app.processName, app.setAdj, "excessive wake lock"});
                android.os.Process.killProcessQuiet((int)app.pid);
                continue;
            }
            if (doCpuKills && uptimeSince > 0L && cputimeUsed * 100L / uptimeSince >= 50L) {
                batteryStatsImpl = stats;
                synchronized (batteryStatsImpl) {
                    stats.reportExcessiveCpuLocked(app.info.uid, app.processName, uptimeSince, cputimeUsed);
                }
                Slog.w((String)TAG, (String)("Excessive CPU in " + app.processName + " (pid " + app.pid + "): used " + cputimeUsed + " during " + uptimeSince));
                EventLog.writeEvent((int)30023, (Object[])new Object[]{app.pid, app.processName, app.setAdj, "excessive cpu"});
                android.os.Process.killProcessQuiet((int)app.pid);
                continue;
            }
            app.lastWakeTime = wtime;
            app.lastCpuTime = app.curCpuTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean updateOomAdjLocked(ProcessRecord app, int hiddenAdj, ProcessRecord TOP_APP, boolean doingAll) {
        app.hiddenAdj = hiddenAdj;
        if (app.thread == null) {
            return false;
        }
        boolean wasKeeping = app.keeping;
        boolean success = true;
        this.computeOomAdjLocked(app, hiddenAdj, TOP_APP, false, doingAll);
        if (app.curRawAdj != app.setRawAdj) {
            if (wasKeeping && !app.keeping) {
                BatteryStatsImpl stats;
                BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    app.lastWakeTime = stats.getProcessWakeTime(app.info.uid, app.pid, SystemClock.elapsedRealtime());
                }
                app.lastCpuTime = app.curCpuTime;
            }
            app.setRawAdj = app.curRawAdj;
        }
        if (app.curAdj != app.setAdj) {
            if (android.os.Process.setOomAdj((int)app.pid, (int)app.curAdj)) {
                app.setAdj = app.curAdj;
            } else {
                success = false;
                Slog.w((String)TAG, (String)("Failed setting oom adj of " + app + " to " + app.curAdj));
            }
        }
        if (app.setSchedGroup == app.curSchedGroup) return success;
        app.setSchedGroup = app.curSchedGroup;
        if (app.waitingToKill != null && app.setSchedGroup == 1) {
            Slog.i((String)TAG, (String)("Killing " + app.toShortString() + ": " + app.waitingToKill));
            EventLog.writeEvent((int)30023, (Object[])new Object[]{app.pid, app.processName, app.setAdj, app.waitingToKill});
            android.os.Process.killProcessQuiet((int)app.pid);
            return false;
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            try {
                android.os.Process.setProcessGroup((int)app.pid, (int)app.curSchedGroup);
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)("Failed setting process group of " + app.pid + " to " + app.curSchedGroup));
                e.printStackTrace();
                Object var11_11 = null;
                Binder.restoreCallingIdentity((long)oldId);
                return success;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Binder.restoreCallingIdentity((long)oldId);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)oldId);
        return success;
    }

    private final ActivityRecord resumedAppLocked() {
        ActivityRecord resumedActivity = this.mMainStack.mResumedActivity;
        if (!(resumedActivity != null && resumedActivity.app != null || (resumedActivity = this.mMainStack.mPausingActivity) != null && resumedActivity.app != null)) {
            resumedActivity = this.mMainStack.topRunningActivityLocked(null);
        }
        return resumedActivity;
    }

    private final boolean updateOomAdjLocked(ProcessRecord app) {
        boolean nowHidden;
        ActivityRecord TOP_ACT = this.resumedAppLocked();
        ProcessRecord TOP_APP = TOP_ACT != null ? TOP_ACT.app : null;
        int curAdj = app.curAdj;
        boolean wasHidden = curAdj >= ProcessList.HIDDEN_APP_MIN_ADJ && curAdj <= 15;
        ++this.mAdjSeq;
        boolean success = this.updateOomAdjLocked(app, app.hiddenAdj, TOP_APP, false);
        boolean bl = nowHidden = app.curAdj >= ProcessList.HIDDEN_APP_MIN_ADJ && app.curAdj <= 15;
        if (nowHidden != wasHidden) {
            this.updateOomAdjLocked();
        }
        return success;
    }

    final void updateOomAdjLocked() {
        ActivityRecord TOP_ACT = this.resumedAppLocked();
        ProcessRecord TOP_APP = TOP_ACT != null ? TOP_ACT.app : null;
        ++this.mAdjSeq;
        this.mNewNumServiceProcs = 0;
        int numSlots = 15 - ProcessList.HIDDEN_APP_MIN_ADJ + 1;
        int factor = (this.mLruProcesses.size() - 4) / numSlots;
        if (factor < 1) {
            factor = 1;
        }
        int step = 0;
        int numHidden = 0;
        int i = this.mLruProcesses.size();
        int curHiddenAdj = ProcessList.HIDDEN_APP_MIN_ADJ;
        while (i > 0) {
            ProcessRecord app = this.mLruProcesses.get(--i);
            this.updateOomAdjLocked(app, curHiddenAdj, TOP_APP, true);
            if (curHiddenAdj < 15 && app.curAdj == curHiddenAdj && ++step >= factor) {
                step = 0;
                ++curHiddenAdj;
            }
            if (app.killedBackground || app.curAdj < ProcessList.HIDDEN_APP_MIN_ADJ || ++numHidden <= this.mProcessLimit) continue;
            Slog.i((String)TAG, (String)("No longer want " + app.processName + " (pid " + app.pid + "): hidden #" + numHidden));
            EventLog.writeEvent((int)30023, (Object[])new Object[]{app.pid, app.processName, app.setAdj, "too many background"});
            app.killedBackground = true;
            android.os.Process.killProcessQuiet((int)app.pid);
        }
        this.mNumServiceProcs = this.mNewNumServiceProcs;
        if (numHidden <= 7) {
            int N = this.mLruProcesses.size();
            factor = numHidden / 3;
            int minFactor = 2;
            if (this.mHomeProcess != null) {
                ++minFactor;
            }
            if (this.mPreviousProcess != null) {
                ++minFactor;
            }
            if (factor < minFactor) {
                factor = minFactor;
            }
            step = 0;
            int curLevel = 80;
            for (i = 0; i < N; ++i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (app.curAdj >= 6 && app.curAdj != 8 && !app.killedBackground) {
                    if (app.trimMemoryLevel < curLevel && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(curLevel);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = curLevel;
                    if (++step < factor) continue;
                    switch (curLevel) {
                        case 80: {
                            curLevel = 60;
                            break;
                        }
                        case 60: {
                            curLevel = 40;
                        }
                    }
                    continue;
                }
                if (app.curAdj == 3) {
                    if (app.trimMemoryLevel < 40 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(40);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = 40;
                    continue;
                }
                if ((app.curAdj > 1 || app.systemNoUi) && app.pendingUiClean) {
                    if (app.trimMemoryLevel < 20 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(20);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = 20;
                    app.pendingUiClean = false;
                    continue;
                }
                app.trimMemoryLevel = 0;
            }
        } else {
            int N = this.mLruProcesses.size();
            for (i = 0; i < N; ++i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if ((app.curAdj > 1 || app.systemNoUi) && app.pendingUiClean) {
                    if (app.trimMemoryLevel < 20 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(20);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = 20;
                    app.pendingUiClean = false;
                    continue;
                }
                app.trimMemoryLevel = 0;
            }
        }
        if (this.mAlwaysFinishActivities) {
            this.mMainStack.destroyActivitiesLocked(null, false, "always-finish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void trimApplications() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mRemovedProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mRemovedProcesses.get(i);
                if (app.activities.size() != 0 || app.curReceiver != null || app.services.size() != 0) continue;
                Slog.i((String)TAG, (String)("Exiting empty application process " + app.processName + " (" + (app.thread != null ? app.thread.asBinder() : null) + ")\n"));
                if (app.pid > 0 && app.pid != MY_PID) {
                    EventLog.writeEvent((int)30023, (Object[])new Object[]{app.pid, app.processName, app.setAdj, "empty"});
                    android.os.Process.killProcessQuiet((int)app.pid);
                } else {
                    try {
                        app.thread.scheduleExit();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.cleanUpApplicationRecordLocked(app, false, true, -1);
                this.mRemovedProcesses.remove(i);
                if (!app.persistent || !app.persistent) continue;
                this.addAppLocked(app.info);
            }
            this.updateOomAdjLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalPersistentProcesses(int sig) throws RemoteException {
        if (sig != 10) {
            throw new SecurityException("Only SIGNAL_USR1 is allowed");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.checkCallingPermission("android.permission.SIGNAL_PERSISTENT_PROCESSES") != 0) {
                throw new SecurityException("Requires permission android.permission.SIGNAL_PERSISTENT_PROCESSES");
            }
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord r = this.mLruProcesses.get(i);
                if (r.thread == null || !r.persistent) continue;
                android.os.Process.sendSignal((int)r.pid, (int)sig);
            }
        }
    }

    private void stopProfilerLocked(ProcessRecord proc, String path, int profileType) {
        if (proc == null || proc == this.mProfileProc) {
            proc = this.mProfileProc;
            path = this.mProfileFile;
            profileType = this.mProfileType;
            this.clearProfilerLocked();
        }
        if (proc == null) {
            return;
        }
        try {
            proc.thread.profilerControl(false, path, null, profileType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Process disappeared");
        }
    }

    private void clearProfilerLocked() {
        if (this.mProfileFd != null) {
            try {
                this.mProfileFd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mProfileApp = null;
        this.mProfileProc = null;
        this.mProfileFile = null;
        this.mProfileType = 0;
        this.mAutoStopProfiler = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean profileControl(String process, boolean start, String path, ParcelFileDescriptor fd, int profileType) throws RemoteException {
        try {
            try {
                boolean bl;
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                        throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                    }
                    if (start && fd == null) {
                        throw new IllegalArgumentException("null fd");
                    }
                    ProcessRecord proc = null;
                    if (process != null) {
                        HashMap<String, SparseArray<ProcessRecord>> all;
                        SparseArray<ProcessRecord> procs;
                        try {
                            int pid = Integer.parseInt(process);
                            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                            synchronized (sparseArray) {
                                proc = (ProcessRecord)this.mPidsSelfLocked.get(pid);
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (proc == null && (procs = (all = this.mProcessNames.getMap()).get(process)) != null && procs.size() > 0) {
                            proc = (ProcessRecord)procs.valueAt(0);
                        }
                    }
                    if (start) {
                        if (proc == null) throw new IllegalArgumentException("Unknown process: " + process);
                        if (proc.thread == null) {
                            throw new IllegalArgumentException("Unknown process: " + process);
                        }
                    }
                    if (start) {
                        this.stopProfilerLocked(null, null, 0);
                        this.setProfileApp(proc.info, proc.processName, path, fd, false);
                        this.mProfileProc = proc;
                        this.mProfileType = profileType;
                        try {
                            fd = fd.dup();
                        }
                        catch (IOException e) {
                            fd = null;
                        }
                        proc.thread.profilerControl(start, path, fd, profileType);
                        fd = null;
                        this.mProfileFd = null;
                    } else {
                        this.stopProfilerLocked(proc, path, profileType);
                        if (fd != null) {
                            try {
                                fd.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                    bl = true;
                }
                Object var13_16 = null;
                if (fd == null) return bl;
                try {
                    fd.close();
                    return bl;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return bl;
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Process disappeared");
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (fd == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            fd.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dumpHeap(String process, boolean managed, String path, ParcelFileDescriptor fd) throws RemoteException {
        try {
            try {
                boolean bl;
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    HashMap<String, SparseArray<ProcessRecord>> all;
                    SparseArray<ProcessRecord> procs;
                    if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                        throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                    }
                    if (fd == null) {
                        throw new IllegalArgumentException("null fd");
                    }
                    ProcessRecord proc = null;
                    try {
                        int pid = Integer.parseInt(process);
                        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                        synchronized (sparseArray) {
                            proc = (ProcessRecord)this.mPidsSelfLocked.get(pid);
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (proc == null && (procs = (all = this.mProcessNames.getMap()).get(process)) != null && procs.size() > 0) {
                        proc = (ProcessRecord)procs.valueAt(0);
                    }
                    if (proc == null) throw new IllegalArgumentException("Unknown process: " + process);
                    if (proc.thread == null) {
                        throw new IllegalArgumentException("Unknown process: " + process);
                    }
                    boolean isDebuggable = "1".equals(SystemProperties.get((String)SYSTEM_DEBUGGABLE, (String)"0"));
                    if (!isDebuggable && (proc.info.flags & 2) == 0) {
                        throw new SecurityException("Process not debuggable: " + proc);
                    }
                    proc.thread.dumpHeap(managed, path, fd);
                    fd = null;
                    bl = true;
                }
                Object var12_13 = null;
                if (fd == null) return bl;
                try {
                    fd.close();
                    return bl;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return bl;
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Process disappeared");
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (fd == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            fd.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
        }
    }

    public void onCoreSettingsChange(Bundle settings) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord processRecord = this.mLruProcesses.get(i);
            try {
                if (processRecord.thread == null) continue;
                processRecord.thread.setCoreSettings(settings);
                continue;
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
    }

    public boolean switchUser(int userid) {
        return true;
    }

    static {
        DUMP_MEM_BUCKETS = new long[]{5120L, 7168L, 10240L, 15360L, 20480L, 30720L, 40960L, 81920L, 122880L, 163840L, 204800L, 256000L, 307200L, 358400L, 409600L, 512000L, 614400L, 819200L, 0x100000L, 0x200000L, 0x500000L, 0xA00000L, 0x1400000L};
        DUMP_MEM_OOM_ADJ = new int[]{-16, -12, 0, 1, 2, 3, 4, 5, 6, 7, 8, 15};
        DUMP_MEM_OOM_LABEL = new String[]{"System", "Persistent", "Foreground", "Visible", "Perceptible", "Heavy Weight", "Backup", "A Services", "Home", "Previous", "B Services", "Background"};
    }

    private class ServiceRestarter
    implements Runnable {
        private ServiceRecord mService;

        private ServiceRestarter() {
        }

        void setService(ServiceRecord service) {
            this.mService = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.performServiceRestartLocked(this.mService);
            }
        }
    }

    private final class ServiceLookupResult {
        final ServiceRecord record;
        final String permission;

        ServiceLookupResult(ServiceRecord _record, String _permission) {
            this.record = _record;
            this.permission = _permission;
        }
    }

    static final class MemItem {
        final String label;
        final String shortLabel;
        final long pss;
        final int id;
        ArrayList<MemItem> subitems;

        public MemItem(String _label, String _shortLabel, long _pss, int _id) {
            this.label = _label;
            this.shortLabel = _shortLabel;
            this.pss = _pss;
            this.id = _id;
        }
    }

    static class ItemMatcher {
        ArrayList<ComponentName> components;
        ArrayList<String> strings;
        ArrayList<Integer> objects;
        boolean all = true;

        ItemMatcher() {
        }

        void build(String name) {
            ComponentName componentName = ComponentName.unflattenFromString((String)name);
            if (componentName != null) {
                if (this.components == null) {
                    this.components = new ArrayList();
                }
                this.components.add(componentName);
                this.all = false;
            } else {
                int objectId = 0;
                try {
                    objectId = Integer.parseInt(name, 16);
                    if (this.objects == null) {
                        this.objects = new ArrayList();
                    }
                    this.objects.add(objectId);
                    this.all = false;
                }
                catch (RuntimeException e) {
                    if (this.strings == null) {
                        this.strings = new ArrayList();
                    }
                    this.strings.add(name);
                    this.all = false;
                }
            }
        }

        int build(String[] args, int opti) {
            while (opti < args.length) {
                String name = args[opti];
                if ("--".equals(name)) {
                    return opti + 1;
                }
                this.build(name);
                ++opti;
            }
            return opti;
        }

        boolean match(Object object, ComponentName comp) {
            int i;
            if (this.all) {
                return true;
            }
            if (this.components != null) {
                for (i = 0; i < this.components.size(); ++i) {
                    if (!this.components.get(i).equals((Object)comp)) continue;
                    return true;
                }
            }
            if (this.objects != null) {
                for (i = 0; i < this.objects.size(); ++i) {
                    if (System.identityHashCode(object) != this.objects.get(i)) continue;
                    return true;
                }
            }
            if (this.strings != null) {
                String flat = comp.flattenToString();
                for (int i2 = 0; i2 < this.strings.size(); ++i2) {
                    if (!flat.contains(this.strings.get(i2))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class PermissionController
    extends IPermissionController.Stub {
        ActivityManagerService mActivityManagerService;

        PermissionController(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        public boolean checkPermission(String permission, int pid, int uid) {
            return this.mActivityManagerService.checkPermission(permission, pid, uid) == 0;
        }
    }

    private final class AppNotResponding
    implements Runnable {
        private final ProcessRecord mApp;
        private final String mAnnotation;

        public AppNotResponding(ProcessRecord app, String annotation) {
            this.mApp = app;
            this.mAnnotation = annotation;
        }

        public void run() {
            ActivityManagerService.this.appNotResponding(this.mApp, null, null, this.mAnnotation);
        }
    }

    static class CpuBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        CpuBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump cpuinfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            Thread thread = this.mActivityManagerService.mProcessStatsThread;
            synchronized (thread) {
                pw.print(this.mActivityManagerService.mProcessStats.printCurrentLoad());
                pw.print(this.mActivityManagerService.mProcessStats.printCurrentState(SystemClock.uptimeMillis()));
            }
        }
    }

    static class GraphicsBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        GraphicsBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump gfxinfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            this.mActivityManagerService.dumpGraphicsHardwareUsage(fd, pw, args);
        }
    }

    static class MemBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        MemBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump meminfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            this.mActivityManagerService.dumpApplicationMemoryUsage(fd, pw, "  ", args, false, null, null, null);
        }
    }

    static class AThread
    extends Thread {
        ActivityManagerService mService;
        boolean mReady = false;

        public AThread() {
            super(ActivityManagerService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            android.os.Process.setThreadPriority((int)-2);
            android.os.Process.setCanSelfBackground((boolean)false);
            ActivityManagerService m = new ActivityManagerService();
            AThread aThread = this;
            synchronized (aThread) {
                this.mService = m;
                this.notifyAll();
            }
            aThread = this;
            synchronized (aThread) {
                while (!this.mReady) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (StrictMode.conditionallyEnableDebugLogging()) {
                Slog.i((String)ActivityManagerService.TAG, (String)"Enabled StrictMode logging for AThread's Looper");
            }
            Looper.loop();
        }
    }

    private final class AppDeathRecipient
    implements IBinder.DeathRecipient {
        final ProcessRecord mApp;
        final int mPid;
        final IApplicationThread mAppThread;

        AppDeathRecipient(ProcessRecord app, int pid, IApplicationThread thread) {
            this.mApp = app;
            this.mPid = pid;
            this.mAppThread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.appDiedLocked(this.mApp, this.mPid, this.mAppThread);
            }
        }
    }

    private class Identity {
        public int pid;
        public int uid;

        Identity(int _pid, int _uid) {
            this.pid = _pid;
            this.uid = _uid;
        }
    }

    abstract class ForegroundToken
    implements IBinder.DeathRecipient {
        int pid;
        IBinder token;

        ForegroundToken() {
        }
    }

    static class PendingActivityLaunch {
        ActivityRecord r;
        ActivityRecord sourceRecord;
        Uri[] grantedUriPermissions;
        int grantedMode;
        boolean onlyIfNeeded;

        PendingActivityLaunch() {
        }
    }
}

