/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.TimeUtils;
import android.view.IApplicationToken;
import com.android.internal.R;
import com.android.server.AttributeCache;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityResult;
import com.android.server.am.ActivityStack;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskRecord;
import com.android.server.am.ThumbnailHolder;
import com.android.server.am.UriPermissionOwner;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;

final class ActivityRecord {
    final ActivityManagerService service;
    final ActivityStack stack;
    final IApplicationToken.Stub appToken;
    final ActivityInfo info;
    final int launchedFromUid;
    final Intent intent;
    final ComponentName realActivity;
    final String shortComponentName;
    final String resolvedType;
    final String packageName;
    final String processName;
    final String taskAffinity;
    final boolean stateNotNeeded;
    final boolean fullscreen;
    final boolean noDisplay;
    final boolean componentSpecified;
    final boolean isHomeActivity;
    final String baseDir;
    final String resDir;
    final String dataDir;
    CharSequence nonLocalizedLabel;
    int labelRes;
    int icon;
    int theme;
    int realTheme;
    int windowFlags;
    TaskRecord task;
    ThumbnailHolder thumbHolder;
    long launchTime;
    long startTime;
    long lastVisibleTime;
    long cpuTimeAtResume;
    Configuration configuration;
    CompatibilityInfo compat;
    ActivityRecord resultTo;
    final String resultWho;
    final int requestCode;
    ArrayList results;
    HashSet<WeakReference<PendingIntentRecord>> pendingResults;
    ArrayList newIntents;
    HashSet<ConnectionRecord> connections;
    UriPermissionOwner uriPermissions;
    ProcessRecord app;
    ActivityStack.ActivityState state;
    Bundle icicle;
    boolean frontOfTask;
    boolean launchFailed;
    boolean haveState;
    boolean stopped;
    boolean delayedResume;
    boolean finishing;
    boolean configDestroy;
    int configChangeFlags;
    boolean keysPaused;
    int launchMode;
    boolean visible;
    boolean sleeping;
    boolean waitingVisible;
    boolean nowVisible;
    boolean thumbnailNeeded;
    boolean idle;
    boolean hasBeenLaunched;
    boolean frozenBeforeDestroy;
    boolean immersive;
    boolean forceNewConfig;
    String stringName;
    private boolean inHistory;

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("packageName=");
        pw.print(this.packageName);
        pw.print(" processName=");
        pw.println(this.processName);
        pw.print(prefix);
        pw.print("launchedFromUid=");
        pw.print(this.launchedFromUid);
        pw.print(" app=");
        pw.println(this.app);
        pw.print(prefix);
        pw.println(this.intent.toInsecureString());
        pw.print(prefix);
        pw.print("frontOfTask=");
        pw.print(this.frontOfTask);
        pw.print(" task=");
        pw.println(this.task);
        pw.print(prefix);
        pw.print("taskAffinity=");
        pw.println(this.taskAffinity);
        pw.print(prefix);
        pw.print("realActivity=");
        pw.println(this.realActivity.flattenToShortString());
        pw.print(prefix);
        pw.print("base=");
        pw.print(this.baseDir);
        if (!this.resDir.equals(this.baseDir)) {
            pw.print(" res=");
        }
        pw.print(this.resDir);
        pw.print(" data=");
        pw.println(this.dataDir);
        pw.print(prefix);
        pw.print("labelRes=0x");
        pw.print(Integer.toHexString(this.labelRes));
        pw.print(" icon=0x");
        pw.print(Integer.toHexString(this.icon));
        pw.print(" theme=0x");
        pw.println(Integer.toHexString(this.theme));
        pw.print(prefix);
        pw.print("stateNotNeeded=");
        pw.print(this.stateNotNeeded);
        pw.print(" componentSpecified=");
        pw.print(this.componentSpecified);
        pw.print(" isHomeActivity=");
        pw.println(this.isHomeActivity);
        pw.print(prefix);
        pw.print("config=");
        pw.println(this.configuration);
        pw.print(prefix);
        pw.print("compat=");
        pw.println(this.compat);
        if (this.resultTo != null || this.resultWho != null) {
            pw.print(prefix);
            pw.print("resultTo=");
            pw.print(this.resultTo);
            pw.print(" resultWho=");
            pw.print(this.resultWho);
            pw.print(" resultCode=");
            pw.println(this.requestCode);
        }
        if (this.results != null) {
            pw.print(prefix);
            pw.print("results=");
            pw.println(this.results);
        }
        if (this.pendingResults != null) {
            pw.print(prefix);
            pw.print("pendingResults=");
            pw.println(this.pendingResults);
        }
        if (this.uriPermissions != null) {
            if (this.uriPermissions.readUriPermissions != null) {
                pw.print(prefix);
                pw.print("readUriPermissions=");
                pw.println(this.uriPermissions.readUriPermissions);
            }
            if (this.uriPermissions.writeUriPermissions != null) {
                pw.print(prefix);
                pw.print("writeUriPermissions=");
                pw.println(this.uriPermissions.writeUriPermissions);
            }
        }
        pw.print(prefix);
        pw.print("launchFailed=");
        pw.print(this.launchFailed);
        pw.print(" haveState=");
        pw.print(this.haveState);
        pw.print(" icicle=");
        pw.println(this.icicle);
        pw.print(prefix);
        pw.print("state=");
        pw.print((Object)this.state);
        pw.print(" stopped=");
        pw.print(this.stopped);
        pw.print(" delayedResume=");
        pw.print(this.delayedResume);
        pw.print(" finishing=");
        pw.println(this.finishing);
        pw.print(prefix);
        pw.print("keysPaused=");
        pw.print(this.keysPaused);
        pw.print(" inHistory=");
        pw.print(this.inHistory);
        pw.print(" visible=");
        pw.print(this.visible);
        pw.print(" sleeping=");
        pw.print(this.sleeping);
        pw.print(" idle=");
        pw.println(this.idle);
        pw.print(prefix);
        pw.print("fullscreen=");
        pw.print(this.fullscreen);
        pw.print(" noDisplay=");
        pw.print(this.noDisplay);
        pw.print(" immersive=");
        pw.print(this.immersive);
        pw.print(" launchMode=");
        pw.println(this.launchMode);
        pw.print(prefix);
        pw.print("frozenBeforeDestroy=");
        pw.print(this.frozenBeforeDestroy);
        pw.print(" thumbnailNeeded=");
        pw.print(this.thumbnailNeeded);
        pw.print(" forceNewConfig=");
        pw.println(this.forceNewConfig);
        pw.print(prefix);
        pw.print("thumbHolder=");
        pw.println(this.thumbHolder);
        if (this.launchTime != 0L || this.startTime != 0L) {
            pw.print(prefix);
            pw.print("launchTime=");
            TimeUtils.formatDuration((long)this.launchTime, (PrintWriter)pw);
            pw.print(" startTime=");
            TimeUtils.formatDuration((long)this.startTime, (PrintWriter)pw);
            pw.println("");
        }
        if (this.lastVisibleTime != 0L) {
            pw.print(prefix);
            pw.print("lastVisibleTime=");
            TimeUtils.formatDuration((long)this.lastVisibleTime, (PrintWriter)pw);
            pw.println("");
        }
        if (this.waitingVisible || this.nowVisible) {
            pw.print(prefix);
            pw.print("waitingVisible=");
            pw.print(this.waitingVisible);
            pw.print(" nowVisible=");
            pw.println(this.nowVisible);
        }
        if (this.configDestroy || this.configChangeFlags != 0) {
            pw.print(prefix);
            pw.print("configDestroy=");
            pw.print(this.configDestroy);
            pw.print(" configChangeFlags=");
            pw.println(Integer.toHexString(this.configChangeFlags));
        }
        if (this.connections != null) {
            pw.print(prefix);
            pw.print("connections=");
            pw.println(this.connections);
        }
    }

    static ActivityRecord forToken(IBinder token) {
        try {
            return token != null ? (ActivityRecord)((Token)token).weakActivity.get() : null;
        }
        catch (ClassCastException e) {
            Slog.w((String)"ActivityManager", (String)("Bad activity token: " + token), (Throwable)e);
            return null;
        }
    }

    ActivityRecord(ActivityManagerService _service, ActivityStack _stack, ProcessRecord _caller, int _launchedFromUid, Intent _intent, String _resolvedType, ActivityInfo aInfo, Configuration _configuration, ActivityRecord _resultTo, String _resultWho, int _reqCode, boolean _componentSpecified) {
        this.service = _service;
        this.stack = _stack;
        this.appToken = new Token(this);
        this.info = aInfo;
        this.launchedFromUid = _launchedFromUid;
        this.intent = _intent;
        this.shortComponentName = _intent.getComponent().flattenToShortString();
        this.resolvedType = _resolvedType;
        this.componentSpecified = _componentSpecified;
        this.configuration = _configuration;
        this.resultTo = _resultTo;
        this.resultWho = _resultWho;
        this.requestCode = _reqCode;
        this.state = ActivityStack.ActivityState.INITIALIZING;
        this.frontOfTask = false;
        this.launchFailed = false;
        this.haveState = false;
        this.stopped = false;
        this.delayedResume = false;
        this.finishing = false;
        this.configDestroy = false;
        this.keysPaused = false;
        this.inHistory = false;
        this.visible = true;
        this.waitingVisible = false;
        this.nowVisible = false;
        this.thumbnailNeeded = false;
        this.idle = false;
        this.hasBeenLaunched = false;
        if (aInfo != null) {
            this.realActivity = aInfo.targetActivity == null || aInfo.launchMode == 0 || aInfo.launchMode == 1 ? _intent.getComponent() : new ComponentName(aInfo.packageName, aInfo.targetActivity);
            this.taskAffinity = aInfo.taskAffinity;
            this.stateNotNeeded = (aInfo.flags & 0x10) != 0;
            this.baseDir = aInfo.applicationInfo.sourceDir;
            this.resDir = aInfo.applicationInfo.publicSourceDir;
            this.dataDir = aInfo.applicationInfo.dataDir;
            this.nonLocalizedLabel = aInfo.nonLocalizedLabel;
            this.labelRes = aInfo.labelRes;
            if (this.nonLocalizedLabel == null && this.labelRes == 0) {
                ApplicationInfo app = aInfo.applicationInfo;
                this.nonLocalizedLabel = app.nonLocalizedLabel;
                this.labelRes = app.labelRes;
            }
            this.icon = aInfo.getIconResource();
            this.realTheme = this.theme = aInfo.getThemeResource();
            if (this.realTheme == 0) {
                int n = this.realTheme = aInfo.applicationInfo.targetSdkVersion < 11 ? 16973829 : 16973931;
            }
            if ((aInfo.flags & 0x200) != 0) {
                this.windowFlags |= 0x1000000;
            }
            this.processName = (aInfo.flags & 1) != 0 && _caller != null && (aInfo.applicationInfo.uid == 1000 || aInfo.applicationInfo.uid == _caller.info.uid) ? _caller.processName : aInfo.processName;
            if (this.intent != null && (aInfo.flags & 0x20) != 0) {
                this.intent.addFlags(0x800000);
            }
            this.packageName = aInfo.applicationInfo.packageName;
            this.launchMode = aInfo.launchMode;
            AttributeCache.Entry ent = AttributeCache.instance().get(this.packageName, this.realTheme, R.styleable.Window);
            this.fullscreen = ent != null && !ent.array.getBoolean(4, false) && !ent.array.getBoolean(5, false);
            boolean bl = this.noDisplay = ent != null && ent.array.getBoolean(10, false);
            this.isHomeActivity = !_componentSpecified || _launchedFromUid == Process.myUid() || _launchedFromUid == 0 ? "android.intent.action.MAIN".equals(_intent.getAction()) && _intent.hasCategory("android.intent.category.HOME") && _intent.getCategories().size() == 1 && _intent.getData() == null && _intent.getType() == null && (this.intent.getFlags() & 0x10000000) != 0 && !"android".equals(this.realActivity.getClassName()) : false;
            this.immersive = (aInfo.flags & 0x400) != 0;
        } else {
            this.realActivity = null;
            this.taskAffinity = null;
            this.stateNotNeeded = false;
            this.baseDir = null;
            this.resDir = null;
            this.dataDir = null;
            this.processName = null;
            this.packageName = null;
            this.fullscreen = true;
            this.noDisplay = false;
            this.isHomeActivity = false;
            this.immersive = false;
        }
    }

    void setTask(TaskRecord newTask, ThumbnailHolder newThumbHolder, boolean isRoot) {
        if (this.inHistory && !this.finishing) {
            if (this.task != null) {
                --this.task.numActivities;
            }
            if (newTask != null) {
                ++newTask.numActivities;
            }
        }
        if (newThumbHolder == null) {
            newThumbHolder = newTask;
        }
        this.task = newTask;
        if (!isRoot && (this.intent.getFlags() & 0x80000) != 0) {
            if (this.thumbHolder == null) {
                this.thumbHolder = new ThumbnailHolder();
            }
        } else {
            this.thumbHolder = newThumbHolder;
        }
    }

    void putInHistory() {
        if (!this.inHistory) {
            this.inHistory = true;
            if (this.task != null && !this.finishing) {
                ++this.task.numActivities;
            }
        }
    }

    void takeFromHistory() {
        if (this.inHistory) {
            this.inHistory = false;
            if (this.task != null && !this.finishing) {
                --this.task.numActivities;
            }
        }
    }

    boolean isInHistory() {
        return this.inHistory;
    }

    void makeFinishing() {
        if (!this.finishing) {
            this.finishing = true;
            if (this.task != null && this.inHistory) {
                --this.task.numActivities;
            }
        }
    }

    UriPermissionOwner getUriPermissionsLocked() {
        if (this.uriPermissions == null) {
            this.uriPermissions = new UriPermissionOwner(this.service, this);
        }
        return this.uriPermissions;
    }

    void addResultLocked(ActivityRecord from, String resultWho, int requestCode, int resultCode, Intent resultData) {
        ActivityResult r = new ActivityResult(from, resultWho, requestCode, resultCode, resultData);
        if (this.results == null) {
            this.results = new ArrayList();
        }
        this.results.add(r);
    }

    void removeResultsLocked(ActivityRecord from, String resultWho, int requestCode) {
        if (this.results != null) {
            for (int i = this.results.size() - 1; i >= 0; --i) {
                ActivityResult r = (ActivityResult)((Object)this.results.get(i));
                if (r.mFrom != from || (r.mResultWho != null ? !r.mResultWho.equals(resultWho) : resultWho != null) || r.mRequestCode != requestCode) continue;
                this.results.remove(i);
            }
        }
    }

    void addNewIntentLocked(Intent intent) {
        if (this.newIntents == null) {
            this.newIntents = new ArrayList();
        }
        this.newIntents.add(intent);
    }

    final void deliverNewIntentLocked(int callingUid, Intent intent) {
        boolean sent = false;
        if (this.state == ActivityStack.ActivityState.RESUMED && this.app != null && this.app.thread != null) {
            try {
                ArrayList<Intent> ar = new ArrayList<Intent>();
                intent = new Intent(intent);
                ar.add(intent);
                this.service.grantUriPermissionFromIntentLocked(callingUid, this.packageName, intent, this.getUriPermissionsLocked());
                this.app.thread.scheduleNewIntent(ar, (IBinder)this.appToken);
                sent = true;
            }
            catch (RemoteException e) {
                Slog.w((String)"ActivityManager", (String)("Exception thrown sending new intent to " + this), (Throwable)e);
            }
            catch (NullPointerException e) {
                Slog.w((String)"ActivityManager", (String)("Exception thrown sending new intent to " + this), (Throwable)e);
            }
        }
        if (!sent) {
            this.addNewIntentLocked(new Intent(intent));
        }
    }

    void removeUriPermissionsLocked() {
        if (this.uriPermissions != null) {
            this.uriPermissions.removeUriPermissionsLocked();
            this.uriPermissions = null;
        }
    }

    void pauseKeyDispatchingLocked() {
        if (!this.keysPaused) {
            this.keysPaused = true;
            this.service.mWindowManager.pauseKeyDispatching((IBinder)this.appToken);
        }
    }

    void resumeKeyDispatchingLocked() {
        if (this.keysPaused) {
            this.keysPaused = false;
            this.service.mWindowManager.resumeKeyDispatching((IBinder)this.appToken);
        }
    }

    void updateThumbnail(Bitmap newThumbnail, CharSequence description) {
        if ((this.intent.getFlags() & 0x80000) != 0) {
            // empty if block
        }
        if (this.thumbHolder != null) {
            if (newThumbnail != null) {
                this.thumbHolder.lastThumbnail = newThumbnail;
            }
            this.thumbHolder.lastDescription = description;
        }
    }

    void clearThumbnail() {
        if (this.thumbHolder != null) {
            this.thumbHolder.lastThumbnail = null;
            this.thumbHolder.lastDescription = null;
        }
    }

    public boolean mayFreezeScreenLocked(ProcessRecord app) {
        return app != null && !app.crashing && !app.notResponding;
    }

    public void startFreezingScreenLocked(ProcessRecord app, int configChanges) {
        if (this.mayFreezeScreenLocked(app)) {
            this.service.mWindowManager.startAppFreezingScreen((IBinder)this.appToken, configChanges);
        }
    }

    public void stopFreezingScreenLocked(boolean force) {
        if (force || this.frozenBeforeDestroy) {
            this.frozenBeforeDestroy = false;
            this.service.mWindowManager.stopAppFreezingScreen((IBinder)this.appToken, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowsDrawn() {
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            if (this.launchTime != 0L) {
                long curTime = SystemClock.uptimeMillis();
                long thisTime = curTime - this.launchTime;
                long totalTime = this.stack.mInitialStartTime != 0L ? curTime - this.stack.mInitialStartTime : thisTime;
                EventLog.writeEvent((int)30009, (Object[])new Object[]{System.identityHashCode(this), this.shortComponentName, thisTime, totalTime});
                StringBuilder sb = this.service.mStringBuilder;
                sb.setLength(0);
                sb.append("Displayed ");
                sb.append(this.shortComponentName);
                sb.append(": ");
                TimeUtils.formatDuration((long)thisTime, (StringBuilder)sb);
                if (thisTime != totalTime) {
                    sb.append(" (total ");
                    TimeUtils.formatDuration((long)totalTime, (StringBuilder)sb);
                    sb.append(")");
                }
                Log.i((String)"ActivityManager", (String)sb.toString());
                this.stack.reportActivityLaunchedLocked(false, this, thisTime, totalTime);
                if (totalTime > 0L) {
                    this.service.mUsageStatsService.noteLaunchTime(this.realActivity, (int)totalTime);
                }
                this.launchTime = 0L;
                this.stack.mInitialStartTime = 0L;
            }
            this.startTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowsVisible() {
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            this.stack.reportActivityVisibleLocked(this);
            if (!this.nowVisible) {
                this.nowVisible = true;
                this.lastVisibleTime = SystemClock.uptimeMillis();
                if (!this.idle) {
                    this.stack.processStoppingActivitiesLocked(false);
                } else {
                    int N = this.stack.mWaitingVisibleActivities.size();
                    if (N > 0) {
                        for (int i = 0; i < N; ++i) {
                            ActivityRecord r = this.stack.mWaitingVisibleActivities.get(i);
                            r.waitingVisible = false;
                        }
                        this.stack.mWaitingVisibleActivities.clear();
                        Message msg = Message.obtain();
                        msg.what = 11;
                        this.stack.mHandler.sendMessage(msg);
                    }
                }
                this.service.scheduleAppGcsLocked();
            }
        }
    }

    public void windowsGone() {
        this.nowVisible = false;
    }

    private ActivityRecord getWaitingHistoryRecordLocked() {
        ActivityRecord r = this;
        if (r.waitingVisible) {
            r = this.stack.mResumedActivity;
            if (r == null) {
                r = this.stack.mPausingActivity;
            }
            if (r == null) {
                r = this;
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean keyDispatchingTimedOut() {
        ActivityRecord r;
        ProcessRecord anrApp = null;
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            r = this.getWaitingHistoryRecordLocked();
            if (r != null && r.app != null) {
                if (r.app.debugging) {
                    return false;
                }
                if (this.service.mDidDexOpt) {
                    this.service.mDidDexOpt = false;
                    return false;
                }
                if (r.app.instrumentationClass == null) {
                    anrApp = r.app;
                } else {
                    Bundle info = new Bundle();
                    info.putString("shortMsg", "keyDispatchingTimedOut");
                    info.putString("longMsg", "Timed out while dispatching key event");
                    this.service.finishInstrumentationLocked(r.app, 0, info);
                }
            }
        }
        if (anrApp != null) {
            this.service.appNotResponding(anrApp, r, this, "keyDispatchingTimedOut");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getKeyDispatchingTimeout() {
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getWaitingHistoryRecordLocked();
            if (r != null && r.app != null && (r.app.instrumentationClass != null || r.app.usingWrapper)) {
                return 60000L;
            }
            return 5000L;
        }
    }

    public boolean isInterestingToUserLocked() {
        return this.visible || this.nowVisible || this.state == ActivityStack.ActivityState.PAUSING || this.state == ActivityStack.ActivityState.RESUMED;
    }

    public void setSleeping(boolean _sleeping) {
        if (this.sleeping == _sleeping) {
            return;
        }
        if (this.app != null && this.app.thread != null) {
            try {
                this.app.thread.scheduleSleeping((IBinder)this.appToken, _sleeping);
                if (this.sleeping && !this.stack.mGoingToSleepActivities.contains(this)) {
                    this.stack.mGoingToSleepActivities.add(this);
                }
                this.sleeping = _sleeping;
            }
            catch (RemoteException e) {
                Slog.w((String)"ActivityManager", (String)("Exception thrown when sleeping: " + this.intent.getComponent()), (Throwable)e);
            }
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ActivityRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        sb.append(this.intent.getComponent().flattenToShortString());
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    static class Token
    extends IApplicationToken.Stub {
        final WeakReference<ActivityRecord> weakActivity;

        Token(ActivityRecord activity) {
            this.weakActivity = new WeakReference<ActivityRecord>(activity);
        }

        public void windowsDrawn() throws RemoteException {
            ActivityRecord activity = (ActivityRecord)this.weakActivity.get();
            if (activity != null) {
                activity.windowsDrawn();
            }
        }

        public void windowsVisible() throws RemoteException {
            ActivityRecord activity = (ActivityRecord)this.weakActivity.get();
            if (activity != null) {
                activity.windowsVisible();
            }
        }

        public void windowsGone() throws RemoteException {
            ActivityRecord activity = (ActivityRecord)this.weakActivity.get();
            if (activity != null) {
                activity.windowsGone();
            }
        }

        public boolean keyDispatchingTimedOut() throws RemoteException {
            ActivityRecord activity = (ActivityRecord)this.weakActivity.get();
            if (activity != null) {
                return activity.keyDispatchingTimedOut();
            }
            return false;
        }

        public long getKeyDispatchingTimeout() throws RemoteException {
            ActivityRecord activity = (ActivityRecord)this.weakActivity.get();
            if (activity != null) {
                return activity.getKeyDispatchingTimeout();
            }
            return 0L;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Token{");
            sb.append(Integer.toHexString(System.identityHashCode((Object)this)));
            sb.append(' ');
            sb.append(this.weakActivity.get());
            sb.append('}');
            return sb.toString();
        }
    }
}

