/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.IThumbnailRetriever;
import android.app.ResultInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.view.IApplicationToken;
import com.android.internal.app.HeavyWeightSwitcherActivity;
import com.android.internal.os.BatteryStatsImpl;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskAccessInfo;
import com.android.server.am.TaskRecord;
import com.android.server.am.ThumbnailHolder;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ActivityStack {
    static final String TAG = "ActivityManager";
    static final boolean localLOGV = false;
    static final boolean DEBUG_SWITCH = false;
    static final boolean DEBUG_PAUSE = false;
    static final boolean DEBUG_VISBILITY = false;
    static final boolean DEBUG_USER_LEAVING = false;
    static final boolean DEBUG_TRANSITION = false;
    static final boolean DEBUG_RESULTS = false;
    static final boolean DEBUG_CONFIGURATION = false;
    static final boolean DEBUG_TASKS = false;
    static final boolean DEBUG_STATES = false;
    static final boolean DEBUG_ADD_REMOVE = false;
    static final boolean DEBUG_SAVED_STATE = false;
    static final boolean VALIDATE_TOKENS = false;
    static final int IDLE_TIMEOUT = 10000;
    static final int PAUSE_TIMEOUT = 500;
    static final int SLEEP_TIMEOUT = 5000;
    static final int LAUNCH_TIMEOUT = 10000;
    static final int DESTROY_TIMEOUT = 10000;
    static final long ACTIVITY_INACTIVE_RESET_TIME = 0L;
    static final long START_WARN_TIME = 5000L;
    static final boolean SHOW_APP_STARTING_PREVIEW = true;
    final ActivityManagerService mService;
    final boolean mMainStack;
    final Context mContext;
    final ArrayList<ActivityRecord> mHistory = new ArrayList();
    final ArrayList<IBinder> mValidateAppTokens = new ArrayList();
    final ArrayList<ActivityRecord> mLRUActivities = new ArrayList();
    final ArrayList<ActivityRecord> mWaitingVisibleActivities = new ArrayList();
    final ArrayList<ActivityRecord> mStoppingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mGoingToSleepActivities = new ArrayList();
    final ArrayList<ActivityRecord> mNoAnimActivities = new ArrayList();
    final ArrayList<ActivityRecord> mFinishingActivities = new ArrayList();
    final ArrayList<IActivityManager.WaitResult> mWaitingActivityLaunched = new ArrayList();
    final ArrayList<IActivityManager.WaitResult> mWaitingActivityVisible = new ArrayList();
    final PowerManager.WakeLock mGoingToSleep;
    final PowerManager.WakeLock mLaunchingActivity;
    ActivityRecord mPausingActivity = null;
    ActivityRecord mLastPausedActivity = null;
    ActivityRecord mResumedActivity = null;
    ActivityRecord mLastStartedActivity = null;
    boolean mConfigWillChange;
    boolean mUserLeaving = false;
    long mInitialStartTime = 0L;
    boolean mSleepTimeout = false;
    boolean mDismissKeyguardOnNextActivity = false;
    int mThumbnailWidth = -1;
    int mThumbnailHeight = -1;
    static final int SLEEP_TIMEOUT_MSG = 8;
    static final int PAUSE_TIMEOUT_MSG = 9;
    static final int IDLE_TIMEOUT_MSG = 10;
    static final int IDLE_NOW_MSG = 11;
    static final int LAUNCH_TIMEOUT_MSG = 16;
    static final int DESTROY_TIMEOUT_MSG = 17;
    static final int RESUME_TOP_ACTIVITY_MSG = 19;
    final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 8: {
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        if (ActivityStack.this.mService.isSleeping()) {
                            Slog.w((String)ActivityStack.TAG, (String)"Sleep timeout!  Sleeping now.");
                            ActivityStack.this.mSleepTimeout = true;
                            ActivityStack.this.checkReadyForSleepLocked();
                        }
                        break;
                    }
                }
                case 9: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w((String)ActivityStack.TAG, (String)("Activity pause timeout for " + r));
                    ActivityStack.this.activityPaused((IBinder)(r != null ? r.appToken : null), true);
                    break;
                }
                case 10: {
                    if (ActivityStack.this.mService.mDidDexOpt) {
                        ActivityStack.this.mService.mDidDexOpt = false;
                        Message nmsg = ActivityStack.this.mHandler.obtainMessage(10);
                        nmsg.obj = msg.obj;
                        ActivityStack.this.mHandler.sendMessageDelayed(nmsg, 10000L);
                        return;
                    }
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w((String)ActivityStack.TAG, (String)("Activity idle timeout for " + r));
                    ActivityStack.this.activityIdleInternal((IBinder)(r != null ? r.appToken : null), true, null);
                    break;
                }
                case 17: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w((String)ActivityStack.TAG, (String)("Activity destroy timeout for " + r));
                    ActivityStack.this.activityDestroyed((IBinder)(r != null ? r.appToken : null));
                    break;
                }
                case 11: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    ActivityStack.this.activityIdleInternal((IBinder)(r != null ? r.appToken : null), false, null);
                    break;
                }
                case 16: {
                    if (ActivityStack.this.mService.mDidDexOpt) {
                        ActivityStack.this.mService.mDidDexOpt = false;
                        Message nmsg = ActivityStack.this.mHandler.obtainMessage(16);
                        ActivityStack.this.mHandler.sendMessageDelayed(nmsg, 10000L);
                        return;
                    }
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        if (ActivityStack.this.mLaunchingActivity.isHeld()) {
                            Slog.w((String)ActivityStack.TAG, (String)"Launch timeout has expired, giving up wake lock!");
                            ActivityStack.this.mLaunchingActivity.release();
                        }
                        break;
                    }
                }
                case 19: {
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        ActivityStack.this.resumeTopActivityLocked(null);
                        break;
                    }
                }
            }
        }
    };
    private static final int FINISH_IMMEDIATELY = 0;
    private static final int FINISH_AFTER_PAUSE = 1;
    private static final int FINISH_AFTER_VISIBLE = 2;

    ActivityStack(ActivityManagerService service, Context context, boolean mainStack) {
        this.mService = service;
        this.mContext = context;
        this.mMainStack = mainStack;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mGoingToSleep = pm.newWakeLock(1, "ActivityManager-Sleep");
        this.mLaunchingActivity = pm.newWakeLock(1, "ActivityManager-Launch");
        this.mLaunchingActivity.setReferenceCounted(false);
    }

    final ActivityRecord topRunningActivityLocked(ActivityRecord notTop) {
        for (int i = this.mHistory.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mHistory.get(i);
            if (r.finishing || r == notTop) continue;
            return r;
        }
        return null;
    }

    final ActivityRecord topRunningNonDelayedActivityLocked(ActivityRecord notTop) {
        for (int i = this.mHistory.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mHistory.get(i);
            if (r.finishing || r.delayedResume || r == notTop) continue;
            return r;
        }
        return null;
    }

    final ActivityRecord topRunningActivityLocked(IBinder token, int taskId) {
        for (int i = this.mHistory.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mHistory.get(i);
            if (r.finishing || token == r.appToken || taskId == r.task.taskId) continue;
            return r;
        }
        return null;
    }

    final int indexOfTokenLocked(IBinder token) {
        return this.mHistory.indexOf(ActivityRecord.forToken(token));
    }

    final int indexOfActivityLocked(ActivityRecord r) {
        return this.mHistory.indexOf(r);
    }

    final ActivityRecord isInStackLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forToken(token);
        if (this.mHistory.contains(r)) {
            return r;
        }
        return null;
    }

    private final boolean updateLRUListLocked(ActivityRecord r) {
        boolean hadit = this.mLRUActivities.remove(r);
        this.mLRUActivities.add(r);
        return hadit;
    }

    private ActivityRecord findTaskLocked(Intent intent, ActivityInfo info) {
        ComponentName cls = intent.getComponent();
        if (info.targetActivity != null) {
            cls = new ComponentName(info.packageName, info.targetActivity);
        }
        TaskRecord cp = null;
        int N = this.mHistory.size();
        for (int i = N - 1; i >= 0; --i) {
            ActivityRecord r = this.mHistory.get(i);
            if (r.finishing || r.task == cp || r.launchMode == 3) continue;
            cp = r.task;
            if (r.task.affinity != null) {
                if (!r.task.affinity.equals(info.taskAffinity)) continue;
                return r;
            }
            if (r.task.intent != null && r.task.intent.getComponent().equals((Object)cls)) {
                return r;
            }
            if (r.task.affinityIntent == null || !r.task.affinityIntent.getComponent().equals((Object)cls)) continue;
            return r;
        }
        return null;
    }

    private ActivityRecord findActivityLocked(Intent intent, ActivityInfo info) {
        ComponentName cls = intent.getComponent();
        if (info.targetActivity != null) {
            cls = new ComponentName(info.packageName, info.targetActivity);
        }
        int N = this.mHistory.size();
        for (int i = N - 1; i >= 0; --i) {
            ActivityRecord r = this.mHistory.get(i);
            if (r.finishing || !r.intent.getComponent().equals((Object)cls)) continue;
            return r;
        }
        return null;
    }

    final void showAskCompatModeDialogLocked(ActivityRecord r) {
        Message msg = Message.obtain();
        msg.what = 30;
        msg.obj = r.task.askedCompatMode ? null : r;
        this.mService.mHandler.sendMessage(msg);
    }

    final boolean realStartActivityLocked(ActivityRecord r, ProcessRecord app, boolean andResume, boolean checkConfig) throws RemoteException {
        r.startFreezingScreenLocked(app, 0);
        this.mService.mWindowManager.setAppVisibility((IBinder)r.appToken, true);
        if (checkConfig) {
            Configuration config = this.mService.mWindowManager.updateOrientationFromAppTokens(this.mService.mConfiguration, (IBinder)(r.mayFreezeScreenLocked(app) ? r.appToken : null));
            this.mService.updateConfigurationLocked(config, r, false, false);
        }
        r.app = app;
        app.waitingToKill = null;
        int idx = app.activities.indexOf(r);
        if (idx < 0) {
            app.activities.add(r);
        }
        this.mService.updateLruProcessLocked(app, true, true);
        try {
            if (app.thread == null) {
                throw new RemoteException();
            }
            ArrayList results = null;
            ArrayList newIntents = null;
            if (andResume) {
                results = r.results;
                newIntents = r.newIntents;
            }
            if (andResume) {
                EventLog.writeEvent((int)30006, (Object[])new Object[]{System.identityHashCode(r), r.task.taskId, r.shortComponentName});
            }
            if (r.isHomeActivity) {
                this.mService.mHomeProcess = app;
            }
            this.mService.ensurePackageDexOpt(r.intent.getComponent().getPackageName());
            r.sleeping = false;
            r.forceNewConfig = false;
            this.showAskCompatModeDialogLocked(r);
            r.compat = this.mService.compatibilityInfoForPackageLocked(r.info.applicationInfo);
            String profileFile = null;
            ParcelFileDescriptor profileFd = null;
            boolean profileAutoStop = false;
            if (this.mService.mProfileApp != null && this.mService.mProfileApp.equals(app.processName) && (this.mService.mProfileProc == null || this.mService.mProfileProc == app)) {
                this.mService.mProfileProc = app;
                profileFile = this.mService.mProfileFile;
                profileFd = this.mService.mProfileFd;
                profileAutoStop = this.mService.mAutoStopProfiler;
            }
            app.hasShownUi = true;
            app.pendingUiClean = true;
            if (profileFd != null) {
                try {
                    profileFd = profileFd.dup();
                }
                catch (IOException e) {
                    profileFd = null;
                }
            }
            app.thread.scheduleLaunchActivity(new Intent(r.intent), (IBinder)r.appToken, System.identityHashCode(r), r.info, new Configuration(this.mService.mConfiguration), r.compat, r.icicle, (List)results, (List)newIntents, !andResume, this.mService.isNextTransitionForward(), profileFile, profileFd, profileAutoStop);
            if ((app.info.flags & 0x10000000) != 0 && app.processName.equals(app.info.packageName)) {
                if (this.mService.mHeavyWeightProcess != null && this.mService.mHeavyWeightProcess != app) {
                    Log.w((String)TAG, (String)("Starting new heavy weight process " + app + " when already running " + this.mService.mHeavyWeightProcess));
                }
                this.mService.mHeavyWeightProcess = app;
                Message msg = this.mService.mHandler.obtainMessage(24);
                msg.obj = r;
                this.mService.mHandler.sendMessage(msg);
            }
        }
        catch (RemoteException e) {
            if (r.launchFailed) {
                Slog.e((String)TAG, (String)("Second failure launching " + r.intent.getComponent().flattenToShortString() + ", giving up"), (Throwable)e);
                this.mService.appDiedLocked(app, app.pid, app.thread);
                this.requestFinishActivityLocked((IBinder)r.appToken, 0, null, "2nd-crash");
                return false;
            }
            app.activities.remove(r);
            throw e;
        }
        r.launchFailed = false;
        if (this.updateLRUListLocked(r)) {
            Slog.w((String)TAG, (String)("Activity " + r + " being launched, but already in LRU list"));
        }
        if (andResume) {
            r.state = ActivityState.RESUMED;
            r.stopped = false;
            this.mResumedActivity = r;
            r.task.touchActiveTime();
            if (this.mMainStack) {
                this.mService.addRecentTaskLocked(r.task);
            }
            this.completeResumeLocked(r);
            this.checkReadyForSleepLocked();
            r.icicle = null;
            r.haveState = false;
        } else {
            r.state = ActivityState.STOPPED;
            r.stopped = true;
        }
        if (this.mMainStack) {
            this.mService.startSetupActivityLocked();
        }
        return true;
    }

    private final void startSpecificActivityLocked(ActivityRecord r, boolean andResume, boolean checkConfig) {
        ProcessRecord app = this.mService.getProcessRecordLocked(r.processName, r.info.applicationInfo.uid);
        if (r.launchTime == 0L) {
            r.launchTime = SystemClock.uptimeMillis();
            if (this.mInitialStartTime == 0L) {
                this.mInitialStartTime = r.launchTime;
            }
        } else if (this.mInitialStartTime == 0L) {
            this.mInitialStartTime = SystemClock.uptimeMillis();
        }
        if (app != null && app.thread != null) {
            try {
                app.addPackage(r.info.packageName);
                this.realStartActivityLocked(r, app, andResume, checkConfig);
                return;
            }
            catch (RemoteException e) {
                Slog.w((String)TAG, (String)("Exception when starting activity " + r.intent.getComponent().flattenToShortString()), (Throwable)e);
            }
        }
        this.mService.startProcessLocked(r.processName, r.info.applicationInfo, true, 0, "activity", r.intent.getComponent(), false);
    }

    void stopIfSleepingLocked() {
        if (this.mService.isSleeping()) {
            if (!this.mGoingToSleep.isHeld()) {
                this.mGoingToSleep.acquire();
                if (this.mLaunchingActivity.isHeld()) {
                    this.mLaunchingActivity.release();
                    this.mService.mHandler.removeMessages(16);
                }
            }
            this.mHandler.removeMessages(8);
            Message msg = this.mHandler.obtainMessage(8);
            this.mHandler.sendMessageDelayed(msg, 5000L);
            this.checkReadyForSleepLocked();
        }
    }

    void awakeFromSleepingLocked() {
        this.mHandler.removeMessages(8);
        this.mSleepTimeout = false;
        if (this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.release();
        }
        for (int i = this.mHistory.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mHistory.get(i);
            r.setSleeping(false);
        }
        this.mGoingToSleepActivities.clear();
    }

    void activitySleptLocked(ActivityRecord r) {
        this.mGoingToSleepActivities.remove(r);
        this.checkReadyForSleepLocked();
    }

    void checkReadyForSleepLocked() {
        if (!this.mService.isSleeping()) {
            return;
        }
        if (!this.mSleepTimeout) {
            if (this.mResumedActivity != null) {
                this.startPausingLocked(false, true);
                return;
            }
            if (this.mPausingActivity != null) {
                return;
            }
            if (this.mStoppingActivities.size() > 0) {
                this.scheduleIdleLocked();
                return;
            }
            this.ensureActivitiesVisibleLocked(null, 0);
            for (int i = this.mHistory.size() - 1; i >= 0; --i) {
                ActivityRecord r = this.mHistory.get(i);
                if (r.state != ActivityState.STOPPING && r.state != ActivityState.STOPPED) continue;
                r.setSleeping(true);
            }
            if (this.mGoingToSleepActivities.size() > 0) {
                return;
            }
        }
        this.mHandler.removeMessages(8);
        if (this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.release();
        }
        if (this.mService.mShuttingDown) {
            this.mService.notifyAll();
        }
    }

    public final Bitmap screenshotActivities(ActivityRecord who) {
        if (who.noDisplay) {
            return null;
        }
        Resources res = this.mService.mContext.getResources();
        int w = this.mThumbnailWidth;
        int h = this.mThumbnailHeight;
        if (w < 0) {
            this.mThumbnailWidth = w = res.getDimensionPixelSize(17104898);
            this.mThumbnailHeight = h = res.getDimensionPixelSize(0x1050001);
        }
        if (w > 0) {
            return this.mService.mWindowManager.screenshotApplications((IBinder)who.appToken, w, h);
        }
        return null;
    }

    private final void startPausingLocked(boolean userLeaving, boolean uiSleeping) {
        Message msg;
        ActivityRecord prev;
        if (this.mPausingActivity != null) {
            RuntimeException e = new RuntimeException();
            Slog.e((String)TAG, (String)("Trying to pause when pause is already pending for " + this.mPausingActivity), (Throwable)e);
        }
        if ((prev = this.mResumedActivity) == null) {
            RuntimeException e = new RuntimeException();
            Slog.e((String)TAG, (String)"Trying to pause when nothing is resumed", (Throwable)e);
            this.resumeTopActivityLocked(null);
            return;
        }
        this.mResumedActivity = null;
        this.mPausingActivity = prev;
        this.mLastPausedActivity = prev;
        prev.state = ActivityState.PAUSING;
        prev.task.touchActiveTime();
        prev.updateThumbnail(this.screenshotActivities(prev), null);
        this.mService.updateCpuStats();
        if (prev.app != null && prev.app.thread != null) {
            try {
                EventLog.writeEvent((int)30013, (Object[])new Object[]{System.identityHashCode(prev), prev.shortComponentName});
                prev.app.thread.schedulePauseActivity((IBinder)prev.appToken, prev.finishing, userLeaving, prev.configChangeFlags);
                if (this.mMainStack) {
                    this.mService.updateUsageStats(prev, false);
                }
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)"Exception thrown during pause", (Throwable)e);
                this.mPausingActivity = null;
                this.mLastPausedActivity = null;
            }
        } else {
            this.mPausingActivity = null;
            this.mLastPausedActivity = null;
        }
        if (!this.mService.mSleeping && !this.mService.mShuttingDown) {
            this.mLaunchingActivity.acquire();
            if (!this.mHandler.hasMessages(16)) {
                msg = this.mHandler.obtainMessage(16);
                this.mHandler.sendMessageDelayed(msg, 10000L);
            }
        }
        if (this.mPausingActivity != null) {
            if (!uiSleeping) {
                prev.pauseKeyDispatchingLocked();
            }
            msg = this.mHandler.obtainMessage(9);
            msg.obj = prev;
            this.mHandler.sendMessageDelayed(msg, 500L);
        } else {
            this.resumeTopActivityLocked(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activityPaused(IBinder token, boolean timeout) {
        ActivityRecord r = null;
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            int index = this.indexOfTokenLocked(token);
            if (index >= 0) {
                r = this.mHistory.get(index);
                this.mHandler.removeMessages(9, (Object)r);
                if (this.mPausingActivity == r) {
                    r.state = ActivityState.PAUSED;
                    this.completePauseLocked();
                } else {
                    EventLog.writeEvent((int)30012, (Object[])new Object[]{System.identityHashCode(r), r.shortComponentName, this.mPausingActivity != null ? this.mPausingActivity.shortComponentName : "(none)"});
                }
            }
        }
    }

    final void activityStoppedLocked(ActivityRecord r, Bundle icicle, Bitmap thumbnail, CharSequence description) {
        r.icicle = icicle;
        r.haveState = true;
        r.updateThumbnail(thumbnail, description);
        r.stopped = true;
        r.state = ActivityState.STOPPED;
        if (!r.finishing) {
            if (r.configDestroy) {
                this.destroyActivityLocked(r, true, false, "stop-config");
                this.resumeTopActivityLocked(null);
            } else {
                ProcessRecord fgApp = null;
                if (this.mResumedActivity != null) {
                    fgApp = this.mResumedActivity.app;
                } else if (this.mPausingActivity != null) {
                    fgApp = this.mPausingActivity.app;
                }
                if (r.app != null && fgApp != null && r.app != fgApp && r.lastVisibleTime > this.mService.mPreviousProcessVisibleTime && r.app != this.mService.mHomeProcess) {
                    this.mService.mPreviousProcess = r.app;
                    this.mService.mPreviousProcessVisibleTime = r.lastVisibleTime;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completePauseLocked() {
        ActivityRecord prev = this.mPausingActivity;
        if (prev != null) {
            if (prev.finishing) {
                prev = this.finishCurrentActivityLocked(prev, 2);
            } else if (prev.app != null) {
                if (prev.waitingVisible) {
                    prev.waitingVisible = false;
                    this.mWaitingVisibleActivities.remove(prev);
                }
                if (prev.configDestroy) {
                    this.destroyActivityLocked(prev, true, false, "pause-config");
                } else {
                    this.mStoppingActivities.add(prev);
                    if (this.mStoppingActivities.size() > 3) {
                        this.scheduleIdleLocked();
                    } else {
                        this.checkReadyForSleepLocked();
                    }
                }
            } else {
                prev = null;
            }
            this.mPausingActivity = null;
        }
        if (!this.mService.isSleeping()) {
            this.resumeTopActivityLocked(prev);
        } else {
            this.checkReadyForSleepLocked();
        }
        if (prev != null) {
            prev.resumeKeyDispatchingLocked();
        }
        if (prev.app != null && prev.cpuTimeAtResume > 0L && this.mService.mBatteryStatsService.isOnBattery()) {
            long diff = 0L;
            Thread thread = this.mService.mProcessStatsThread;
            synchronized (thread) {
                diff = this.mService.mProcessStats.getCpuTimeForPid(prev.app.pid) - prev.cpuTimeAtResume;
            }
            if (diff > 0L) {
                BatteryStatsImpl bsi;
                BatteryStatsImpl batteryStatsImpl = bsi = this.mService.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    BatteryStatsImpl.Uid.Proc ps = bsi.getProcessStatsLocked(prev.info.applicationInfo.uid, prev.info.packageName);
                    if (ps != null) {
                        ps.addForegroundTimeLocked(diff);
                    }
                }
            }
        }
        prev.cpuTimeAtResume = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completeResumeLocked(ActivityRecord next) {
        next.idle = false;
        next.results = null;
        next.newIntents = null;
        Message msg = this.mHandler.obtainMessage(10);
        msg.obj = next;
        this.mHandler.sendMessageDelayed(msg, 10000L);
        if (this.mMainStack) {
            this.mService.reportResumedActivityLocked(next);
        }
        next.clearThumbnail();
        if (this.mMainStack) {
            this.mService.setFocusedActivityLocked(next);
        }
        next.resumeKeyDispatchingLocked();
        this.ensureActivitiesVisibleLocked(null, 0);
        this.mService.mWindowManager.executeAppTransition();
        this.mNoAnimActivities.clear();
        if (next.app != null) {
            Thread thread = this.mService.mProcessStatsThread;
            synchronized (thread) {
                next.cpuTimeAtResume = this.mService.mProcessStats.getCpuTimeForPid(next.app.pid);
            }
        } else {
            next.cpuTimeAtResume = 0L;
        }
    }

    final void ensureActivitiesVisibleLocked(ActivityRecord top, ActivityRecord starting, String onlyThisProcess, int configChanges) {
        ActivityRecord r;
        int count = this.mHistory.size();
        int i = count - 1;
        while (this.mHistory.get(i) != top) {
            --i;
        }
        boolean behindFullscreen = false;
        while (i >= 0) {
            r = this.mHistory.get(i);
            if (!r.finishing) {
                boolean doThisProcess;
                boolean bl = doThisProcess = onlyThisProcess == null || onlyThisProcess.equals(r.processName);
                if (r != starting && doThisProcess) {
                    this.ensureActivityConfigurationLocked(r, 0);
                }
                if (r.app == null || r.app.thread == null) {
                    if (onlyThisProcess == null || onlyThisProcess.equals(r.processName)) {
                        if (r != starting) {
                            r.startFreezingScreenLocked(r.app, configChanges);
                        }
                        if (!r.visible) {
                            this.mService.mWindowManager.setAppVisibility((IBinder)r.appToken, true);
                        }
                        if (r != starting) {
                            this.startSpecificActivityLocked(r, false, false);
                        }
                    }
                } else if (r.visible) {
                    r.stopFreezingScreenLocked(false);
                } else if (onlyThisProcess == null) {
                    r.visible = true;
                    if (r.state != ActivityState.RESUMED && r != starting) {
                        try {
                            this.mService.mWindowManager.setAppVisibility((IBinder)r.appToken, true);
                            r.sleeping = false;
                            r.app.pendingUiClean = true;
                            r.app.thread.scheduleWindowVisibility((IBinder)r.appToken, true);
                            r.stopFreezingScreenLocked(false);
                        }
                        catch (Exception e) {
                            Slog.w((String)TAG, (String)("Exception thrown making visibile: " + r.intent.getComponent()), (Throwable)e);
                        }
                    }
                }
                configChanges |= r.configChangeFlags;
                if (r.fullscreen) {
                    behindFullscreen = true;
                    --i;
                    break;
                }
            }
            --i;
        }
        while (i >= 0) {
            r = this.mHistory.get(i);
            if (!r.finishing) {
                if (behindFullscreen) {
                    if (r.visible) {
                        r.visible = false;
                        try {
                            this.mService.mWindowManager.setAppVisibility((IBinder)r.appToken, false);
                            if ((r.state == ActivityState.STOPPING || r.state == ActivityState.STOPPED) && r.app != null && r.app.thread != null) {
                                r.app.thread.scheduleWindowVisibility((IBinder)r.appToken, false);
                            }
                        }
                        catch (Exception e) {
                            Slog.w((String)TAG, (String)("Exception thrown making hidden: " + r.intent.getComponent()), (Throwable)e);
                        }
                    }
                } else if (r.fullscreen) {
                    behindFullscreen = true;
                }
            }
            --i;
        }
    }

    final void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges) {
        ActivityRecord r = this.topRunningActivityLocked(null);
        if (r != null) {
            this.ensureActivitiesVisibleLocked(r, starting, null, configChanges);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean resumeTopActivityLocked(ActivityRecord prev) {
        ActivityRecord next = this.topRunningActivityLocked(null);
        boolean userLeaving = this.mUserLeaving;
        this.mUserLeaving = false;
        if (next == null && this.mMainStack) {
            return this.mService.startHomeActivityLocked();
        }
        next.delayedResume = false;
        if (this.mResumedActivity == next && next.state == ActivityState.RESUMED) {
            this.mService.mWindowManager.executeAppTransition();
            this.mNoAnimActivities.clear();
            return false;
        }
        if ((this.mService.mSleeping || this.mService.mShuttingDown) && this.mLastPausedActivity == next && next.state == ActivityState.PAUSED) {
            this.mService.mWindowManager.executeAppTransition();
            this.mNoAnimActivities.clear();
            return false;
        }
        this.mStoppingActivities.remove(next);
        this.mGoingToSleepActivities.remove(next);
        next.sleeping = false;
        this.mWaitingVisibleActivities.remove(next);
        if (this.mPausingActivity != null) {
            return false;
        }
        if (this.mResumedActivity != null) {
            this.startPausingLocked(userLeaving, false);
            return true;
        }
        if (prev != null && prev != next) {
            if (!prev.waitingVisible && next != null && !next.nowVisible) {
                prev.waitingVisible = true;
                this.mWaitingVisibleActivities.add(prev);
            } else if (prev.finishing) {
                this.mService.mWindowManager.setAppVisibility((IBinder)prev.appToken, false);
            }
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(next.packageName, false);
        }
        catch (RemoteException e1) {
        }
        catch (IllegalArgumentException e) {
            Slog.w((String)TAG, (String)("Failed trying to unstop package " + next.packageName + ": " + e));
        }
        if (prev != null) {
            if (prev.finishing) {
                if (this.mNoAnimActivities.contains(prev)) {
                    this.mService.mWindowManager.prepareAppTransition(0, false);
                } else {
                    this.mService.mWindowManager.prepareAppTransition(prev.task == next.task ? 8199 : 8201, false);
                }
                this.mService.mWindowManager.setAppWillBeHidden((IBinder)prev.appToken);
                this.mService.mWindowManager.setAppVisibility((IBinder)prev.appToken, false);
            } else if (this.mNoAnimActivities.contains(next)) {
                this.mService.mWindowManager.prepareAppTransition(0, false);
            } else {
                this.mService.mWindowManager.prepareAppTransition(prev.task == next.task ? 4102 : 4104, false);
            }
        } else if (this.mHistory.size() > 1) {
            if (this.mNoAnimActivities.contains(next)) {
                this.mService.mWindowManager.prepareAppTransition(0, false);
            } else {
                this.mService.mWindowManager.prepareAppTransition(4102, false);
            }
        }
        if (next.app != null && next.app.thread != null) {
            this.mService.mWindowManager.setAppVisibility((IBinder)next.appToken, true);
            ActivityRecord lastResumedActivity = this.mResumedActivity;
            ActivityState lastState = next.state;
            this.mService.updateCpuStats();
            next.state = ActivityState.RESUMED;
            this.mResumedActivity = next;
            next.task.touchActiveTime();
            if (this.mMainStack) {
                this.mService.addRecentTaskLocked(next.task);
            }
            this.mService.updateLruProcessLocked(next.app, true, true);
            this.updateLRUListLocked(next);
            boolean updated = false;
            if (this.mMainStack) {
                ActivityManagerService activityManagerService = this.mService;
                synchronized (activityManagerService) {
                    Configuration config = this.mService.mWindowManager.updateOrientationFromAppTokens(this.mService.mConfiguration, (IBinder)(next.mayFreezeScreenLocked(next.app) ? next.appToken : null));
                    if (config != null) {
                        next.frozenBeforeDestroy = true;
                    }
                    updated = this.mService.updateConfigurationLocked(config, next, false, false);
                }
            }
            if (!updated) {
                ActivityRecord nextNext = this.topRunningActivityLocked(null);
                if (nextNext != next) {
                    this.mHandler.sendEmptyMessage(19);
                }
                if (this.mMainStack) {
                    this.mService.setFocusedActivityLocked(next);
                }
                this.ensureActivitiesVisibleLocked(null, 0);
                this.mService.mWindowManager.executeAppTransition();
                this.mNoAnimActivities.clear();
                return true;
            }
            try {
                ArrayList a = next.results;
                if (a != null) {
                    int N = a.size();
                    if (!next.finishing && N > 0) {
                        next.app.thread.scheduleSendResult((IBinder)next.appToken, (List)a);
                    }
                }
                if (next.newIntents != null) {
                    next.app.thread.scheduleNewIntent((List)next.newIntents, (IBinder)next.appToken);
                }
                EventLog.writeEvent((int)30007, (Object[])new Object[]{System.identityHashCode(next), next.task.taskId, next.shortComponentName});
                next.sleeping = false;
                this.showAskCompatModeDialogLocked(next);
                next.app.pendingUiClean = true;
                next.app.thread.scheduleResumeActivity((IBinder)next.appToken, this.mService.isNextTransitionForward());
                this.checkReadyForSleepLocked();
            }
            catch (Exception e) {
                next.state = lastState;
                this.mResumedActivity = lastResumedActivity;
                Slog.i((String)TAG, (String)("Restarting because process died: " + next));
                if (!next.hasBeenLaunched) {
                    next.hasBeenLaunched = true;
                } else if (this.mMainStack) {
                    this.mService.mWindowManager.setAppStartingWindow((IBinder)next.appToken, next.packageName, next.theme, this.mService.compatibilityInfoForPackageLocked(next.info.applicationInfo), next.nonLocalizedLabel, next.labelRes, next.icon, next.windowFlags, null, true);
                }
                this.startSpecificActivityLocked(next, true, false);
                return true;
            }
            try {
                next.visible = true;
                this.completeResumeLocked(next);
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)("Exception thrown during resume of " + next), (Throwable)e);
                this.requestFinishActivityLocked((IBinder)next.appToken, 0, null, "resume-exception");
                return true;
            }
            next.icicle = null;
            next.haveState = false;
            next.stopped = false;
        } else {
            if (!next.hasBeenLaunched) {
                next.hasBeenLaunched = true;
            } else {
                this.mService.mWindowManager.setAppStartingWindow((IBinder)next.appToken, next.packageName, next.theme, this.mService.compatibilityInfoForPackageLocked(next.info.applicationInfo), next.nonLocalizedLabel, next.labelRes, next.icon, next.windowFlags, null, true);
            }
            this.startSpecificActivityLocked(next, true, true);
        }
        return true;
    }

    private final void startActivityLocked(ActivityRecord r, boolean newTask, boolean doResume, boolean keepCurTransition) {
        int NH = this.mHistory.size();
        int addPos = -1;
        if (!newTask) {
            boolean startIt = true;
            for (int i = NH - 1; i >= 0; --i) {
                ActivityRecord p = this.mHistory.get(i);
                if (p.finishing) continue;
                if (p.task == r.task) {
                    addPos = i + 1;
                    if (startIt) break;
                    this.mHistory.add(addPos, r);
                    r.putInHistory();
                    this.mService.mWindowManager.addAppToken(addPos, (IApplicationToken)r.appToken, r.task.taskId, r.info.screenOrientation, r.fullscreen);
                    return;
                }
                if (!p.fullscreen) continue;
                startIt = false;
            }
        }
        if (addPos < 0) {
            addPos = NH;
        }
        if (addPos < NH) {
            this.mUserLeaving = false;
        }
        this.mHistory.add(addPos, r);
        r.putInHistory();
        r.frontOfTask = newTask;
        if (NH > 0) {
            boolean showStartingIcon = newTask;
            ProcessRecord proc = r.app;
            if (proc == null) {
                proc = this.mService.mProcessNames.get(r.processName, r.info.applicationInfo.uid);
            }
            if (proc == null || proc.thread == null) {
                showStartingIcon = true;
            }
            if ((r.intent.getFlags() & 0x10000) != 0) {
                this.mService.mWindowManager.prepareAppTransition(0, keepCurTransition);
                this.mNoAnimActivities.add(r);
            } else if ((r.intent.getFlags() & 0x80000) != 0) {
                this.mService.mWindowManager.prepareAppTransition(4104, keepCurTransition);
                this.mNoAnimActivities.remove(r);
            } else {
                this.mService.mWindowManager.prepareAppTransition(newTask ? 4104 : 4102, keepCurTransition);
                this.mNoAnimActivities.remove(r);
            }
            this.mService.mWindowManager.addAppToken(addPos, (IApplicationToken)r.appToken, r.task.taskId, r.info.screenOrientation, r.fullscreen);
            boolean doShow = true;
            if (newTask && (r.intent.getFlags() & 0x200000) != 0) {
                this.resetTaskIfNeededLocked(r, r);
                boolean bl = doShow = this.topRunningNonDelayedActivityLocked(null) == r;
            }
            if (doShow) {
                ActivityRecord prev = this.mResumedActivity;
                if (prev != null) {
                    if (prev.task != r.task) {
                        prev = null;
                    } else if (prev.nowVisible) {
                        prev = null;
                    }
                }
                this.mService.mWindowManager.setAppStartingWindow((IBinder)r.appToken, r.packageName, r.theme, this.mService.compatibilityInfoForPackageLocked(r.info.applicationInfo), r.nonLocalizedLabel, r.labelRes, r.icon, r.windowFlags, (IBinder)(prev != null ? prev.appToken : null), showStartingIcon);
            }
        } else {
            this.mService.mWindowManager.addAppToken(addPos, (IApplicationToken)r.appToken, r.task.taskId, r.info.screenOrientation, r.fullscreen);
        }
        if (doResume) {
            this.resumeTopActivityLocked(null);
        }
    }

    final void validateAppTokensLocked() {
        this.mValidateAppTokens.clear();
        this.mValidateAppTokens.ensureCapacity(this.mHistory.size());
        for (int i = 0; i < this.mHistory.size(); ++i) {
            this.mValidateAppTokens.add((IBinder)this.mHistory.get((int)i).appToken);
        }
        this.mService.mWindowManager.validateAppTokens(this.mValidateAppTokens);
    }

    private final ActivityRecord resetTaskIfNeededLocked(ActivityRecord taskTop, ActivityRecord newActivity) {
        boolean forceReset = (newActivity.info.flags & 4) != 0;
        TaskRecord task = taskTop.task;
        ActivityRecord target = null;
        int targetI = 0;
        int taskTopI = -1;
        int replyChainEnd = -1;
        int lastReparentPos = -1;
        for (int i = this.mHistory.size() - 1; i >= -1; --i) {
            boolean allowTaskReparenting;
            ActivityRecord below;
            ActivityRecord activityRecord = below = i >= 0 ? this.mHistory.get(i) : null;
            if (below != null && below.finishing) continue;
            if (target == null) {
                target = below;
                targetI = i;
                replyChainEnd = -1;
                continue;
            }
            int flags = target.info.flags;
            boolean finishOnTaskLaunch = (flags & 2) != 0;
            boolean bl = allowTaskReparenting = (flags & 0x40) != 0;
            if (target.task == task) {
                if (taskTopI < 0) {
                    taskTopI = targetI;
                }
                if (below != null && below.task == task) {
                    boolean clearWhenTaskReset;
                    boolean bl2 = clearWhenTaskReset = (target.intent.getFlags() & 0x80000) != 0;
                    if (!finishOnTaskLaunch && !clearWhenTaskReset && target.resultTo != null) {
                        if (replyChainEnd < 0) {
                            replyChainEnd = targetI;
                        }
                    } else if (!finishOnTaskLaunch && !clearWhenTaskReset && allowTaskReparenting && target.taskAffinity != null && !target.taskAffinity.equals(task.affinity)) {
                        ActivityRecord p = this.mHistory.get(0);
                        if (target.taskAffinity != null && target.taskAffinity.equals(p.task.affinity)) {
                            target.setTask(p.task, p.thumbHolder, false);
                        } else {
                            ++this.mService.mCurTask;
                            if (this.mService.mCurTask <= 0) {
                                this.mService.mCurTask = 1;
                            }
                            target.setTask(new TaskRecord(this.mService.mCurTask, target.info, null), null, false);
                            target.task.affinityIntent = target.intent;
                        }
                        this.mService.mWindowManager.setAppGroupId((IBinder)target.appToken, task.taskId);
                        if (replyChainEnd < 0) {
                            replyChainEnd = targetI;
                        }
                        int dstPos = 0;
                        ThumbnailHolder curThumbHolder = target.thumbHolder;
                        for (int srcPos = targetI; srcPos <= replyChainEnd; ++srcPos) {
                            p = this.mHistory.get(srcPos);
                            if (p.finishing) continue;
                            p.setTask(target.task, curThumbHolder, false);
                            curThumbHolder = p.thumbHolder;
                            this.mHistory.remove(srcPos);
                            this.mHistory.add(dstPos, p);
                            this.mService.mWindowManager.moveAppToken(dstPos, (IBinder)p.appToken);
                            this.mService.mWindowManager.setAppGroupId((IBinder)p.appToken, p.task.taskId);
                            ++dstPos;
                            ++i;
                        }
                        if (taskTop == p) {
                            taskTop = below;
                        }
                        if (taskTopI == replyChainEnd) {
                            taskTopI = -1;
                        }
                        replyChainEnd = -1;
                    } else if (forceReset || finishOnTaskLaunch || clearWhenTaskReset) {
                        if (clearWhenTaskReset) {
                            for (replyChainEnd = targetI + 1; replyChainEnd < this.mHistory.size() && this.mHistory.get((int)replyChainEnd).task == task; ++replyChainEnd) {
                            }
                            --replyChainEnd;
                        } else if (replyChainEnd < 0) {
                            replyChainEnd = targetI;
                        }
                        ActivityRecord p = null;
                        for (int srcPos = targetI; srcPos <= replyChainEnd; ++srcPos) {
                            p = this.mHistory.get(srcPos);
                            if (p.finishing || !this.finishActivityLocked(p, srcPos, 0, null, "reset")) continue;
                            --replyChainEnd;
                            --srcPos;
                        }
                        if (taskTop == p) {
                            taskTop = below;
                        }
                        if (taskTopI == replyChainEnd) {
                            taskTopI = -1;
                        }
                        replyChainEnd = -1;
                    } else {
                        replyChainEnd = -1;
                    }
                } else {
                    replyChainEnd = -1;
                }
            } else if (target.resultTo != null && (below == null || below.task == target.task)) {
                if (replyChainEnd < 0) {
                    replyChainEnd = targetI;
                }
            } else if (taskTopI >= 0 && allowTaskReparenting && task.affinity != null && task.affinity.equals(target.taskAffinity)) {
                if (forceReset || finishOnTaskLaunch) {
                    if (replyChainEnd < 0) {
                        replyChainEnd = targetI;
                    }
                    ActivityRecord p = null;
                    for (int srcPos = targetI; srcPos <= replyChainEnd; ++srcPos) {
                        p = this.mHistory.get(srcPos);
                        if (p.finishing || !this.finishActivityLocked(p, srcPos, 0, null, "reset")) continue;
                        --taskTopI;
                        --lastReparentPos;
                        --replyChainEnd;
                        --srcPos;
                    }
                    replyChainEnd = -1;
                } else {
                    if (replyChainEnd < 0) {
                        replyChainEnd = targetI;
                    }
                    for (int srcPos = replyChainEnd; srcPos >= targetI; --srcPos) {
                        ActivityRecord p = this.mHistory.get(srcPos);
                        if (p.finishing) continue;
                        if (lastReparentPos < 0) {
                            lastReparentPos = taskTopI;
                            taskTop = p;
                        } else {
                            --lastReparentPos;
                        }
                        this.mHistory.remove(srcPos);
                        p.setTask(task, null, false);
                        this.mHistory.add(lastReparentPos, p);
                        this.mService.mWindowManager.moveAppToken(lastReparentPos, (IBinder)p.appToken);
                        this.mService.mWindowManager.setAppGroupId((IBinder)p.appToken, p.task.taskId);
                    }
                    replyChainEnd = -1;
                    if (target.info.launchMode == 1) {
                        for (int j = lastReparentPos - 1; j >= 0; --j) {
                            ActivityRecord p = this.mHistory.get(j);
                            if (p.finishing || !p.intent.getComponent().equals((Object)target.intent.getComponent()) || !this.finishActivityLocked(p, j, 0, null, "replace")) continue;
                            --taskTopI;
                            --lastReparentPos;
                        }
                    }
                }
            } else if (below != null && below.task != target.task) {
                replyChainEnd = -1;
            }
            target = below;
            targetI = i;
        }
        return taskTop;
    }

    private final ActivityRecord performClearTaskLocked(int taskId, ActivityRecord newR, int launchFlags) {
        ActivityRecord r;
        int i = this.mHistory.size();
        while (i > 0) {
            r = this.mHistory.get(--i);
            if (r.task.taskId != taskId) continue;
            ++i;
            break;
        }
        while (i > 0) {
            r = this.mHistory.get(--i);
            if (r.finishing) continue;
            if (r.task.taskId != taskId) {
                return null;
            }
            if (!r.realActivity.equals((Object)newR.realActivity)) continue;
            ActivityRecord ret = r;
            while (i < this.mHistory.size() - 1) {
                r = this.mHistory.get(++i);
                if (r.task.taskId != taskId) break;
                if (r.finishing || !this.finishActivityLocked(r, i, 0, null, "clear")) continue;
                --i;
            }
            if (ret.launchMode == 0 && (launchFlags & 0x20000000) == 0 && !ret.finishing) {
                int index = this.indexOfTokenLocked((IBinder)ret.appToken);
                if (index >= 0) {
                    this.finishActivityLocked(ret, index, 0, null, "clear");
                }
                return null;
            }
            return ret;
        }
        return null;
    }

    private final void performClearTaskAtIndexLocked(int taskId, int i) {
        while (i < this.mHistory.size()) {
            ActivityRecord r = this.mHistory.get(i);
            if (r.task.taskId != taskId) {
                return;
            }
            if (r.finishing) {
                ++i;
                continue;
            }
            if (this.finishActivityLocked(r, i, 0, null, "clear")) continue;
            ++i;
        }
    }

    private final void performClearTaskLocked(int taskId) {
        ActivityRecord r;
        int i = this.mHistory.size();
        while (i > 0) {
            r = this.mHistory.get(--i);
            if (r.task.taskId != taskId) continue;
            ++i;
            break;
        }
        while (i > 0) {
            r = this.mHistory.get(--i);
            if (r.finishing || r.task.taskId == taskId) continue;
            this.performClearTaskAtIndexLocked(taskId, i + 1);
            return;
        }
    }

    private final int findActivityInHistoryLocked(ActivityRecord r, int task) {
        int i = this.mHistory.size();
        while (i > 0) {
            ActivityRecord candidate = this.mHistory.get(--i);
            if (candidate.task.taskId != task) break;
            if (!candidate.realActivity.equals((Object)r.realActivity)) continue;
            return i;
        }
        return -1;
    }

    private final ActivityRecord moveActivityToFrontLocked(int where) {
        ActivityRecord newTop = this.mHistory.remove(where);
        int top = this.mHistory.size();
        ActivityRecord oldTop = this.mHistory.get(top - 1);
        this.mHistory.add(top, newTop);
        oldTop.frontOfTask = false;
        newTop.frontOfTask = true;
        return newTop;
    }

    final int startActivityLocked(IApplicationThread caller, Intent intent, String resolvedType, Uri[] grantedUriPermissions, int grantedMode, ActivityInfo aInfo, IBinder resultTo, String resultWho, int requestCode, int callingPid, int callingUid, boolean onlyIfNeeded, boolean componentSpecified, ActivityRecord[] outActivity) {
        int launchFlags;
        int index;
        int err = 0;
        ProcessRecord callerApp = null;
        if (caller != null) {
            callerApp = this.mService.getRecordForAppLocked(caller);
            if (callerApp != null) {
                callingPid = callerApp.pid;
                callingUid = callerApp.info.uid;
            } else {
                Slog.w((String)TAG, (String)("Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString()));
                err = -4;
            }
        }
        if (err == 0) {
            Slog.i((String)TAG, (String)("START {" + intent.toShortString(true, true, true) + "} from pid " + (callerApp != null ? callerApp.pid : callingPid)));
        }
        ActivityRecord sourceRecord = null;
        ActivityRecord resultRecord = null;
        if (resultTo != null && (index = this.indexOfTokenLocked(resultTo)) >= 0) {
            sourceRecord = this.mHistory.get(index);
            if (requestCode >= 0 && !sourceRecord.finishing) {
                resultRecord = sourceRecord;
            }
        }
        if (((launchFlags = intent.getFlags()) & 0x2000000) != 0 && sourceRecord != null) {
            if (requestCode >= 0) {
                return -3;
            }
            resultRecord = sourceRecord.resultTo;
            resultWho = sourceRecord.resultWho;
            requestCode = sourceRecord.requestCode;
            sourceRecord.resultTo = null;
            if (resultRecord != null) {
                resultRecord.removeResultsLocked(sourceRecord, resultWho, requestCode);
            }
        }
        if (err == 0 && intent.getComponent() == null) {
            err = -1;
        }
        if (err == 0 && aInfo == null) {
            err = -2;
        }
        if (err != 0) {
            if (resultRecord != null) {
                this.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            this.mDismissKeyguardOnNextActivity = false;
            return err;
        }
        int perm = this.mService.checkComponentPermission(aInfo.permission, callingPid, callingUid, aInfo.applicationInfo.uid, aInfo.exported);
        if (perm != 0) {
            if (resultRecord != null) {
                this.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            this.mDismissKeyguardOnNextActivity = false;
            String msg = !aInfo.exported ? "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " not exported from uid " + aInfo.applicationInfo.uid : "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + aInfo.permission;
            Slog.w((String)TAG, (String)msg);
            throw new SecurityException(msg);
        }
        if (this.mMainStack && this.mService.mController != null) {
            boolean abort = false;
            try {
                Intent watchIntent = intent.cloneFilter();
                abort = !this.mService.mController.activityStarting(watchIntent, aInfo.applicationInfo.packageName);
            }
            catch (RemoteException e) {
                this.mService.mController = null;
            }
            if (abort) {
                if (resultRecord != null) {
                    this.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
                }
                this.mDismissKeyguardOnNextActivity = false;
                return 0;
            }
        }
        ActivityRecord r = new ActivityRecord(this.mService, this, callerApp, callingUid, intent, resolvedType, aInfo, this.mService.mConfiguration, resultRecord, resultWho, requestCode, componentSpecified);
        if (outActivity != null) {
            outActivity[0] = r;
        }
        if (this.mMainStack) {
            if (!(this.mResumedActivity != null && this.mResumedActivity.info.applicationInfo.uid == callingUid || this.mService.checkAppSwitchAllowedLocked(callingPid, callingUid, "Activity start"))) {
                ActivityManagerService.PendingActivityLaunch pal = new ActivityManagerService.PendingActivityLaunch();
                pal.r = r;
                pal.sourceRecord = sourceRecord;
                pal.grantedUriPermissions = grantedUriPermissions;
                pal.grantedMode = grantedMode;
                pal.onlyIfNeeded = onlyIfNeeded;
                this.mService.mPendingActivityLaunches.add(pal);
                this.mDismissKeyguardOnNextActivity = false;
                return 4;
            }
            if (this.mService.mDidAppSwitch) {
                this.mService.mAppSwitchesAllowedTime = 0L;
            } else {
                this.mService.mDidAppSwitch = true;
            }
            this.mService.doPendingActivityLaunchesLocked(false);
        }
        err = this.startActivityUncheckedLocked(r, sourceRecord, grantedUriPermissions, grantedMode, onlyIfNeeded, true);
        if (this.mDismissKeyguardOnNextActivity && this.mPausingActivity == null) {
            this.mDismissKeyguardOnNextActivity = false;
            this.mService.mWindowManager.dismissKeyguard();
        }
        return err;
    }

    final void moveHomeToFrontFromLaunchLocked(int launchFlags) {
        if ((launchFlags & 0x10004000) == 0x10004000) {
            this.moveHomeToFrontLocked();
        }
    }

    final int startActivityUncheckedLocked(ActivityRecord r, ActivityRecord sourceRecord, Uri[] grantedUriPermissions, int grantedMode, boolean onlyIfNeeded, boolean doResume) {
        ActivityRecord notTop;
        Intent intent = r.intent;
        int callingUid = r.launchedFromUid;
        int launchFlags = intent.getFlags();
        boolean bl = this.mUserLeaving = (launchFlags & 0x40000) == 0;
        if (!doResume) {
            r.delayedResume = true;
        }
        ActivityRecord activityRecord = notTop = (launchFlags & 0x1000000) != 0 ? r : null;
        if (onlyIfNeeded) {
            ActivityRecord checkedCaller = sourceRecord;
            if (checkedCaller == null) {
                checkedCaller = this.topRunningNonDelayedActivityLocked(notTop);
            }
            if (!checkedCaller.realActivity.equals((Object)r.realActivity)) {
                onlyIfNeeded = false;
            }
        }
        if (sourceRecord == null) {
            if ((launchFlags & 0x10000000) == 0) {
                Slog.w((String)TAG, (String)("startActivity called from non-Activity context; forcing Intent.FLAG_ACTIVITY_NEW_TASK for: " + intent));
                launchFlags |= 0x10000000;
            }
        } else if (sourceRecord.launchMode == 3) {
            launchFlags |= 0x10000000;
        } else if (r.launchMode == 3 || r.launchMode == 2) {
            launchFlags |= 0x10000000;
        }
        if (r.resultTo != null && (launchFlags & 0x10000000) != 0) {
            Slog.w((String)TAG, (String)"Activity is launching as a new task, so cancelling activity result.");
            this.sendActivityResultLocked(-1, r.resultTo, r.resultWho, r.requestCode, 0, null);
            r.resultTo = null;
        }
        boolean addingToTask = false;
        TaskRecord reuseTask = null;
        if (((launchFlags & 0x10000000) != 0 && (launchFlags & 0x8000000) == 0 || r.launchMode == 2 || r.launchMode == 3) && r.resultTo == null) {
            ActivityRecord taskTop;
            ActivityRecord activityRecord2 = taskTop = r.launchMode != 3 ? this.findTaskLocked(intent, r.info) : this.findActivityLocked(intent, r.info);
            if (taskTop != null) {
                ActivityRecord curTop;
                if (taskTop.task.intent == null) {
                    taskTop.task.setIntent(intent, r.info);
                }
                if ((curTop = this.topRunningNonDelayedActivityLocked(notTop)) != null && curTop.task != taskTop.task) {
                    boolean callerAtFront;
                    r.intent.addFlags(0x400000);
                    boolean bl2 = callerAtFront = sourceRecord == null || curTop.task == sourceRecord.task;
                    if (callerAtFront) {
                        this.moveHomeToFrontFromLaunchLocked(launchFlags);
                        this.moveTaskToFrontLocked(taskTop.task, r);
                    }
                }
                if ((launchFlags & 0x200000) != 0) {
                    taskTop = this.resetTaskIfNeededLocked(taskTop, r);
                }
                if (onlyIfNeeded) {
                    if (doResume) {
                        this.resumeTopActivityLocked(null);
                    }
                    return 1;
                }
                if ((launchFlags & 0x10008000) == 0x10008000) {
                    reuseTask = taskTop.task;
                    this.performClearTaskLocked(taskTop.task.taskId);
                    reuseTask.setIntent(r.intent, r.info);
                } else if ((launchFlags & 0x4000000) != 0 || r.launchMode == 2 || r.launchMode == 3) {
                    ActivityRecord top = this.performClearTaskLocked(taskTop.task.taskId, r, launchFlags);
                    if (top != null) {
                        if (top.frontOfTask) {
                            top.task.setIntent(r.intent, r.info);
                        }
                        this.logStartActivity(30003, r, top.task);
                        top.deliverNewIntentLocked(callingUid, r.intent);
                    } else {
                        addingToTask = true;
                        sourceRecord = taskTop;
                    }
                } else if (r.realActivity.equals((Object)taskTop.task.realActivity)) {
                    if ((launchFlags & 0x20000000) != 0 && taskTop.realActivity.equals((Object)r.realActivity)) {
                        this.logStartActivity(30003, r, taskTop.task);
                        if (taskTop.frontOfTask) {
                            taskTop.task.setIntent(r.intent, r.info);
                        }
                        taskTop.deliverNewIntentLocked(callingUid, r.intent);
                    } else if (!r.intent.filterEquals(taskTop.task.intent)) {
                        addingToTask = true;
                        sourceRecord = taskTop;
                    }
                } else if ((launchFlags & 0x200000) == 0) {
                    addingToTask = true;
                    sourceRecord = taskTop;
                } else if (!taskTop.task.rootWasReset) {
                    taskTop.task.setIntent(r.intent, r.info);
                }
                if (!addingToTask && reuseTask == null) {
                    if (doResume) {
                        this.resumeTopActivityLocked(null);
                    }
                    return 2;
                }
            }
        }
        if (r.packageName != null) {
            ActivityRecord top = this.topRunningNonDelayedActivityLocked(notTop);
            if (top != null && r.resultTo == null && top.realActivity.equals((Object)r.realActivity) && top.app != null && top.app.thread != null && ((launchFlags & 0x20000000) != 0 || r.launchMode == 1 || r.launchMode == 2)) {
                this.logStartActivity(30003, top, top.task);
                if (doResume) {
                    this.resumeTopActivityLocked(null);
                }
                if (onlyIfNeeded) {
                    return 1;
                }
                top.deliverNewIntentLocked(callingUid, r.intent);
                return 3;
            }
        } else {
            if (r.resultTo != null) {
                this.sendActivityResultLocked(-1, r.resultTo, r.resultWho, r.requestCode, 0, null);
            }
            return -2;
        }
        boolean newTask = false;
        boolean keepCurTransition = false;
        if (r.resultTo == null && !addingToTask && (launchFlags & 0x10000000) != 0) {
            if (reuseTask == null) {
                ++this.mService.mCurTask;
                if (this.mService.mCurTask <= 0) {
                    this.mService.mCurTask = 1;
                }
                r.setTask(new TaskRecord(this.mService.mCurTask, r.info, intent), null, true);
            } else {
                r.setTask(reuseTask, reuseTask, true);
            }
            newTask = true;
            this.moveHomeToFrontFromLaunchLocked(launchFlags);
        } else if (sourceRecord != null) {
            int where;
            if (!addingToTask && (launchFlags & 0x4000000) != 0) {
                ActivityRecord top = this.performClearTaskLocked(sourceRecord.task.taskId, r, launchFlags);
                keepCurTransition = true;
                if (top != null) {
                    this.logStartActivity(30003, r, top.task);
                    top.deliverNewIntentLocked(callingUid, r.intent);
                    if (doResume) {
                        this.resumeTopActivityLocked(null);
                    }
                    return 3;
                }
            } else if (!addingToTask && (launchFlags & 0x20000) != 0 && (where = this.findActivityInHistoryLocked(r, sourceRecord.task.taskId)) >= 0) {
                ActivityRecord top = this.moveActivityToFrontLocked(where);
                this.logStartActivity(30003, r, top.task);
                top.deliverNewIntentLocked(callingUid, r.intent);
                if (doResume) {
                    this.resumeTopActivityLocked(null);
                }
                return 3;
            }
            r.setTask(sourceRecord.task, sourceRecord.thumbHolder, false);
        } else {
            int N = this.mHistory.size();
            ActivityRecord prev = N > 0 ? this.mHistory.get(N - 1) : null;
            r.setTask(prev != null ? prev.task : new TaskRecord(this.mService.mCurTask, r.info, intent), null, true);
        }
        if (grantedUriPermissions != null && callingUid > 0) {
            for (int i = 0; i < grantedUriPermissions.length; ++i) {
                this.mService.grantUriPermissionLocked(callingUid, r.packageName, grantedUriPermissions[i], grantedMode, r.getUriPermissionsLocked());
            }
        }
        this.mService.grantUriPermissionFromIntentLocked(callingUid, r.packageName, intent, r.getUriPermissionsLocked());
        if (newTask) {
            EventLog.writeEvent((int)30004, (int)r.task.taskId);
        }
        this.logStartActivity(30005, r, r.task);
        this.startActivityLocked(r, newTask, doResume, keepCurTransition);
        return 0;
    }

    ActivityInfo resolveActivity(Intent intent, String resolvedType, boolean debug, String profileFile, ParcelFileDescriptor profileFd, boolean autoStopProfiler) {
        ActivityInfo aInfo;
        try {
            ResolveInfo rInfo = AppGlobals.getPackageManager().resolveIntent(intent, resolvedType, 66560);
            aInfo = rInfo != null ? rInfo.activityInfo : null;
        }
        catch (RemoteException e) {
            aInfo = null;
        }
        if (aInfo != null) {
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            if (debug && !aInfo.processName.equals("system")) {
                this.mService.setDebugApp(aInfo.processName, true, false);
            }
            if (profileFile != null && !aInfo.processName.equals("system")) {
                this.mService.setProfileApp(aInfo.applicationInfo, aInfo.processName, profileFile, profileFd, autoStopProfiler);
            }
        }
        return aInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivityMayWait(IApplicationThread caller, int callingUid, Intent intent, String resolvedType, Uri[] grantedUriPermissions, int grantedMode, IBinder resultTo, String resultWho, int requestCode, boolean onlyIfNeeded, boolean debug, String profileFile, ParcelFileDescriptor profileFd, boolean autoStopProfiler, IActivityManager.WaitResult outResult, Configuration config) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        boolean componentSpecified = intent.getComponent() != null;
        intent = new Intent(intent);
        ActivityInfo aInfo = this.resolveActivity(intent, resolvedType, debug, profileFile, profileFd, autoStopProfiler);
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            int callingPid;
            if (callingUid >= 0) {
                callingPid = -1;
            } else if (caller == null) {
                callingPid = Binder.getCallingPid();
                callingUid = Binder.getCallingUid();
            } else {
                callingUid = -1;
                callingPid = -1;
            }
            this.mConfigWillChange = config != null && this.mService.mConfiguration.diff(config) != 0;
            long origId = Binder.clearCallingIdentity();
            if (this.mMainStack && aInfo != null && (aInfo.applicationInfo.flags & 0x10000000) != 0 && aInfo.processName.equals(aInfo.applicationInfo.packageName) && this.mService.mHeavyWeightProcess != null && (this.mService.mHeavyWeightProcess.info.uid != aInfo.applicationInfo.uid || !this.mService.mHeavyWeightProcess.processName.equals(aInfo.processName))) {
                int realCallingPid = callingPid;
                int realCallingUid = callingUid;
                if (caller != null) {
                    ProcessRecord callerApp = this.mService.getRecordForAppLocked(caller);
                    if (callerApp != null) {
                        realCallingPid = callerApp.pid;
                        realCallingUid = callerApp.info.uid;
                    } else {
                        Slog.w((String)TAG, (String)("Unable to find app for caller " + caller + " (pid=" + realCallingPid + ") when starting: " + intent.toString()));
                        return -4;
                    }
                }
                IIntentSender target = this.mService.getIntentSenderLocked(2, "android", realCallingUid, null, null, 0, new Intent[]{intent}, new String[]{resolvedType}, 0x50000000);
                Intent newIntent = new Intent();
                if (requestCode >= 0) {
                    newIntent.putExtra("has_result", true);
                }
                newIntent.putExtra("intent", (Parcelable)new IntentSender(target));
                if (this.mService.mHeavyWeightProcess.activities.size() > 0) {
                    ActivityRecord hist = this.mService.mHeavyWeightProcess.activities.get(0);
                    newIntent.putExtra("cur_app", hist.packageName);
                    newIntent.putExtra("cur_task", hist.task.taskId);
                }
                newIntent.putExtra("new_app", aInfo.packageName);
                newIntent.setFlags(intent.getFlags());
                newIntent.setClassName("android", HeavyWeightSwitcherActivity.class.getName());
                intent = newIntent;
                resolvedType = null;
                caller = null;
                callingUid = Binder.getCallingUid();
                callingPid = Binder.getCallingPid();
                componentSpecified = true;
                try {
                    ResolveInfo rInfo = AppGlobals.getPackageManager().resolveIntent(intent, null, 66560);
                    aInfo = rInfo != null ? rInfo.activityInfo : null;
                }
                catch (RemoteException e) {
                    aInfo = null;
                }
            }
            int res = this.startActivityLocked(caller, intent, resolvedType, grantedUriPermissions, grantedMode, aInfo, resultTo, resultWho, requestCode, callingPid, callingUid, onlyIfNeeded, componentSpecified, null);
            if (this.mConfigWillChange && this.mMainStack) {
                this.mService.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
                this.mConfigWillChange = false;
                this.mService.updateConfigurationLocked(config, null, false, false);
            }
            Binder.restoreCallingIdentity((long)origId);
            if (outResult != null) {
                outResult.result = res;
                if (res == 0) {
                    this.mWaitingActivityLaunched.add(outResult);
                    do {
                        try {
                            this.mService.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    } while (!outResult.timeout && outResult.who == null);
                } else if (res == 2) {
                    ActivityRecord r = this.topRunningActivityLocked(null);
                    if (r.nowVisible) {
                        outResult.timeout = false;
                        outResult.who = new ComponentName(r.info.packageName, r.info.name);
                        outResult.totalTime = 0L;
                        outResult.thisTime = 0L;
                    } else {
                        outResult.thisTime = SystemClock.uptimeMillis();
                        this.mWaitingActivityVisible.add(outResult);
                        do {
                            try {
                                this.mService.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        } while (!outResult.timeout && outResult.who == null);
                    }
                }
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivities(IApplicationThread caller, int callingUid, Intent[] intents, String[] resolvedTypes, IBinder resultTo) {
        int callingPid;
        if (intents == null) {
            throw new NullPointerException("intents is null");
        }
        if (resolvedTypes == null) {
            throw new NullPointerException("resolvedTypes is null");
        }
        if (intents.length != resolvedTypes.length) {
            throw new IllegalArgumentException("intents are length different than resolvedTypes");
        }
        ActivityRecord[] outActivity = new ActivityRecord[1];
        if (callingUid >= 0) {
            callingPid = -1;
        } else if (caller == null) {
            callingPid = Binder.getCallingPid();
            callingUid = Binder.getCallingUid();
        } else {
            callingUid = -1;
            callingPid = -1;
        }
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                for (int i = 0; i < intents.length; ++i) {
                    Intent intent = intents[i];
                    if (intent == null) continue;
                    if (intent != null && intent.hasFileDescriptors()) {
                        throw new IllegalArgumentException("File descriptors passed in Intent");
                    }
                    boolean componentSpecified = intent.getComponent() != null;
                    intent = new Intent(intent);
                    ActivityInfo aInfo = this.resolveActivity(intent, resolvedTypes[i], false, null, null, false);
                    if (this.mMainStack && aInfo != null && (aInfo.applicationInfo.flags & 0x10000000) != 0) {
                        throw new IllegalArgumentException("FLAG_CANT_SAVE_STATE not supported here");
                    }
                    int res = this.startActivityLocked(caller, intent, resolvedTypes[i], null, 0, aInfo, resultTo, null, -1, callingPid, callingUid, false, componentSpecified, outActivity);
                    if (res < 0) {
                        int n = res;
                        return n;
                    }
                    resultTo = outActivity[0] != null ? outActivity[0].appToken : null;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)origId);
        }
        {
            return 0;
        }
    }

    void reportActivityLaunchedLocked(boolean timeout, ActivityRecord r, long thisTime, long totalTime) {
        for (int i = this.mWaitingActivityLaunched.size() - 1; i >= 0; --i) {
            IActivityManager.WaitResult w = this.mWaitingActivityLaunched.get(i);
            w.timeout = timeout;
            if (r != null) {
                w.who = new ComponentName(r.info.packageName, r.info.name);
            }
            w.thisTime = thisTime;
            w.totalTime = totalTime;
        }
        this.mService.notifyAll();
    }

    void reportActivityVisibleLocked(ActivityRecord r) {
        for (int i = this.mWaitingActivityVisible.size() - 1; i >= 0; --i) {
            IActivityManager.WaitResult w = this.mWaitingActivityVisible.get(i);
            w.timeout = false;
            if (r != null) {
                w.who = new ComponentName(r.info.packageName, r.info.name);
            }
            w.thisTime = w.totalTime = SystemClock.uptimeMillis() - w.thisTime;
        }
        this.mService.notifyAll();
        if (this.mDismissKeyguardOnNextActivity) {
            this.mDismissKeyguardOnNextActivity = false;
            this.mService.mWindowManager.dismissKeyguard();
        }
    }

    void sendActivityResultLocked(int callingUid, ActivityRecord r, String resultWho, int requestCode, int resultCode, Intent data) {
        if (callingUid > 0) {
            this.mService.grantUriPermissionFromIntentLocked(callingUid, r.packageName, data, r.getUriPermissionsLocked());
        }
        if (this.mResumedActivity == r && r.app != null && r.app.thread != null) {
            try {
                ArrayList<ResultInfo> list = new ArrayList<ResultInfo>();
                list.add(new ResultInfo(resultWho, requestCode, resultCode, data));
                r.app.thread.scheduleSendResult((IBinder)r.appToken, list);
                return;
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)("Exception thrown sending result to " + r), (Throwable)e);
            }
        }
        r.addResultLocked(null, resultWho, requestCode, resultCode, data);
    }

    private final void stopActivityLocked(ActivityRecord r) {
        block9: {
            if ((r.intent.getFlags() & 0x40000000) != 0 || (r.info.flags & 0x80) != 0) {
                if (!r.finishing) {
                    this.requestFinishActivityLocked((IBinder)r.appToken, 0, null, "no-history");
                }
            } else if (r.app != null && r.app.thread != null) {
                if (this.mMainStack && this.mService.mFocusedActivity == r) {
                    this.mService.setFocusedActivityLocked(this.topRunningActivityLocked(null));
                }
                r.resumeKeyDispatchingLocked();
                try {
                    r.stopped = false;
                    r.state = ActivityState.STOPPING;
                    if (!r.visible) {
                        this.mService.mWindowManager.setAppVisibility((IBinder)r.appToken, false);
                    }
                    r.app.thread.scheduleStopActivity((IBinder)r.appToken, r.visible, r.configChangeFlags);
                    if (this.mService.isSleeping()) {
                        r.setSleeping(true);
                    }
                }
                catch (Exception e) {
                    Slog.w((String)TAG, (String)"Exception thrown during pause", (Throwable)e);
                    r.stopped = true;
                    r.state = ActivityState.STOPPED;
                    if (!r.configDestroy) break block9;
                    this.destroyActivityLocked(r, true, false, "stop-except");
                }
            }
        }
    }

    final ArrayList<ActivityRecord> processStoppingActivitiesLocked(boolean remove) {
        int N = this.mStoppingActivities.size();
        if (N <= 0) {
            return null;
        }
        ArrayList<ActivityRecord> stops = null;
        boolean nowVisible = this.mResumedActivity != null && this.mResumedActivity.nowVisible && !this.mResumedActivity.waitingVisible;
        for (int i = 0; i < N; ++i) {
            ActivityRecord s = this.mStoppingActivities.get(i);
            if (s.waitingVisible && nowVisible) {
                this.mWaitingVisibleActivities.remove(s);
                s.waitingVisible = false;
                if (s.finishing) {
                    this.mService.mWindowManager.setAppVisibility((IBinder)s.appToken, false);
                }
            }
            if (s.waitingVisible && !this.mService.isSleeping() || !remove) continue;
            if (stops == null) {
                stops = new ArrayList<ActivityRecord>();
            }
            stops.add(s);
            this.mStoppingActivities.remove(i);
            --N;
            --i;
        }
        return stops;
    }

    final void scheduleIdleLocked() {
        Message msg = Message.obtain();
        msg.what = 11;
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ActivityRecord activityIdleInternal(IBinder token, boolean fromTimeout, Configuration config) {
        int i;
        ActivityRecord r;
        ActivityRecord res = null;
        ArrayList<ActivityRecord> stops = null;
        ArrayList<ActivityRecord> finishes = null;
        ArrayList thumbnails = null;
        int NS = 0;
        int NF = 0;
        int NT = 0;
        IApplicationThread sendThumbnail = null;
        boolean booting = false;
        boolean enableScreen = false;
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            int index;
            r = ActivityRecord.forToken(token);
            if (r != null) {
                this.mHandler.removeMessages(10, (Object)r);
            }
            if ((index = this.indexOfActivityLocked(r)) >= 0) {
                res = r;
                if (fromTimeout) {
                    this.reportActivityLaunchedLocked(fromTimeout, r, -1L, -1L);
                }
                if (config != null) {
                    r.configuration = config;
                }
                if (this.mResumedActivity == r && this.mLaunchingActivity.isHeld()) {
                    this.mHandler.removeMessages(16);
                    this.mLaunchingActivity.release();
                }
                r.idle = true;
                this.mService.scheduleAppGcsLocked();
                if (r.thumbnailNeeded && r.app != null && r.app.thread != null) {
                    sendThumbnail = r.app.thread;
                    r.thumbnailNeeded = false;
                }
                this.ensureActivitiesVisibleLocked(null, 0);
                if (this.mMainStack && !this.mService.mBooted) {
                    this.mService.mBooted = true;
                    enableScreen = true;
                }
            } else if (fromTimeout) {
                this.reportActivityLaunchedLocked(fromTimeout, null, -1L, -1L);
            }
            NS = (stops = this.processStoppingActivitiesLocked(true)) != null ? stops.size() : 0;
            NF = this.mFinishingActivities.size();
            if (NF > 0) {
                finishes = new ArrayList<ActivityRecord>(this.mFinishingActivities);
                this.mFinishingActivities.clear();
            }
            if ((NT = this.mService.mCancelledThumbnails.size()) > 0) {
                thumbnails = new ArrayList(this.mService.mCancelledThumbnails);
                this.mService.mCancelledThumbnails.clear();
            }
            if (this.mMainStack) {
                booting = this.mService.mBooting;
                this.mService.mBooting = false;
            }
        }
        if (sendThumbnail != null) {
            try {
                sendThumbnail.requestThumbnail(token);
            }
            catch (Exception e) {
                Slog.w((String)TAG, (String)"Exception thrown when requesting thumbnail", (Throwable)e);
                this.mService.sendPendingThumbnail(null, token, null, null, true);
            }
        }
        for (i = 0; i < NS; ++i) {
            r = stops.get(i);
            ActivityManagerService activityManagerService2 = this.mService;
            synchronized (activityManagerService2) {
                if (r.finishing) {
                    this.finishCurrentActivityLocked(r, 0);
                } else {
                    this.stopActivityLocked(r);
                }
                continue;
            }
        }
        for (i = 0; i < NF; ++i) {
            r = finishes.get(i);
            ActivityManagerService activityManagerService3 = this.mService;
            synchronized (activityManagerService3) {
                this.destroyActivityLocked(r, true, false, "finish-idle");
                continue;
            }
        }
        for (i = 0; i < NT; ++i) {
            r = (ActivityRecord)thumbnails.get(i);
            this.mService.sendPendingThumbnail(r, null, null, null, true);
        }
        if (booting) {
            this.mService.finishBooting();
        }
        this.mService.trimApplications();
        if (enableScreen) {
            this.mService.enableScreenAfterBoot();
        }
        return res;
    }

    final boolean requestFinishActivityLocked(IBinder token, int resultCode, Intent resultData, String reason) {
        int index = this.indexOfTokenLocked(token);
        if (index < 0) {
            return false;
        }
        ActivityRecord r = this.mHistory.get(index);
        this.finishActivityLocked(r, index, resultCode, resultData, reason);
        return true;
    }

    final boolean finishActivityLocked(ActivityRecord r, int index, int resultCode, Intent resultData, String reason) {
        ActivityRecord resultTo;
        if (r.finishing) {
            Slog.w((String)TAG, (String)("Duplicate finish request for " + r));
            return false;
        }
        r.makeFinishing();
        EventLog.writeEvent((int)30001, (Object[])new Object[]{System.identityHashCode(r), r.task.taskId, r.shortComponentName, reason});
        if (index < this.mHistory.size() - 1) {
            ActivityRecord next = this.mHistory.get(index + 1);
            if (next.task == r.task) {
                if (r.frontOfTask) {
                    next.frontOfTask = true;
                }
                if ((r.intent.getFlags() & 0x80000) != 0) {
                    next.intent.addFlags(524288);
                }
            }
        }
        r.pauseKeyDispatchingLocked();
        if (this.mMainStack && this.mService.mFocusedActivity == r) {
            this.mService.setFocusedActivityLocked(this.topRunningActivityLocked(null));
        }
        if ((resultTo = r.resultTo) != null) {
            if (r.info.applicationInfo.uid > 0) {
                this.mService.grantUriPermissionFromIntentLocked(r.info.applicationInfo.uid, resultTo.packageName, resultData, resultTo.getUriPermissionsLocked());
            }
            resultTo.addResultLocked(r, r.resultWho, r.requestCode, resultCode, resultData);
            r.resultTo = null;
        }
        r.results = null;
        r.pendingResults = null;
        r.newIntents = null;
        r.icicle = null;
        if (this.mService.mPendingThumbnails.size() > 0) {
            this.mService.mCancelledThumbnails.add(r);
        }
        if (this.mResumedActivity == r) {
            boolean endTask = index <= 0 || this.mHistory.get((int)(index - 1)).task != r.task;
            this.mService.mWindowManager.prepareAppTransition(endTask ? 8201 : 8199, false);
            this.mService.mWindowManager.setAppVisibility((IBinder)r.appToken, false);
            if (this.mPausingActivity == null) {
                this.startPausingLocked(false, false);
            }
        } else if (r.state != ActivityState.PAUSING) {
            return this.finishCurrentActivityLocked(r, index, 1) == null;
        }
        return false;
    }

    private final ActivityRecord finishCurrentActivityLocked(ActivityRecord r, int mode) {
        int index = this.indexOfActivityLocked(r);
        if (index < 0) {
            return null;
        }
        return this.finishCurrentActivityLocked(r, index, mode);
    }

    private final ActivityRecord finishCurrentActivityLocked(ActivityRecord r, int index, int mode) {
        if (mode == 2 && r.nowVisible) {
            if (!this.mStoppingActivities.contains(r)) {
                this.mStoppingActivities.add(r);
                if (this.mStoppingActivities.size() > 3) {
                    this.scheduleIdleLocked();
                } else {
                    this.checkReadyForSleepLocked();
                }
            }
            r.state = ActivityState.STOPPING;
            this.mService.updateOomAdjLocked();
            return r;
        }
        this.mStoppingActivities.remove(r);
        this.mGoingToSleepActivities.remove(r);
        this.mWaitingVisibleActivities.remove(r);
        if (this.mResumedActivity == r) {
            this.mResumedActivity = null;
        }
        ActivityState prevState = r.state;
        r.state = ActivityState.FINISHING;
        if (mode == 0 || prevState == ActivityState.STOPPED || prevState == ActivityState.INITIALIZING) {
            return this.destroyActivityLocked(r, true, true, "finish-imm") ? null : r;
        }
        this.mFinishingActivities.add(r);
        this.resumeTopActivityLocked(null);
        return r;
    }

    final void cleanUpActivityLocked(ActivityRecord r, boolean cleanServices, boolean setState) {
        if (this.mResumedActivity == r) {
            this.mResumedActivity = null;
        }
        if (this.mService.mFocusedActivity == r) {
            this.mService.mFocusedActivity = null;
        }
        r.configDestroy = false;
        r.frozenBeforeDestroy = false;
        if (setState) {
            r.state = ActivityState.DESTROYED;
        }
        this.mFinishingActivities.remove(r);
        this.mWaitingVisibleActivities.remove(r);
        if (r.finishing && r.pendingResults != null) {
            for (WeakReference<PendingIntentRecord> apr : r.pendingResults) {
                PendingIntentRecord rec = (PendingIntentRecord)((Object)apr.get());
                if (rec == null) continue;
                this.mService.cancelIntentSenderLocked(rec, false);
            }
            r.pendingResults = null;
        }
        if (cleanServices) {
            this.cleanUpActivityServicesLocked(r);
        }
        if (this.mService.mPendingThumbnails.size() > 0) {
            this.mService.mCancelledThumbnails.add(r);
        }
        this.mHandler.removeMessages(9, (Object)r);
        this.mHandler.removeMessages(10, (Object)r);
        this.mHandler.removeMessages(17, (Object)r);
    }

    private final void removeActivityFromHistoryLocked(ActivityRecord r) {
        if (r.state != ActivityState.DESTROYED) {
            r.makeFinishing();
            this.mHistory.remove(r);
            r.takeFromHistory();
            r.state = ActivityState.DESTROYED;
            this.mService.mWindowManager.removeAppToken((IBinder)r.appToken);
            this.cleanUpActivityServicesLocked(r);
            r.removeUriPermissionsLocked();
        }
    }

    final void cleanUpActivityServicesLocked(ActivityRecord r) {
        if (r.connections != null) {
            for (ConnectionRecord c : r.connections) {
                this.mService.removeConnectionLocked(c, null, r);
            }
            r.connections = null;
        }
    }

    final void destroyActivitiesLocked(ProcessRecord owner, boolean oomAdj, String reason) {
        for (int i = this.mHistory.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mHistory.get(i);
            if (owner != null && r.app != owner || r.app == null || !r.haveState || r.visible || !r.stopped || r.finishing || r.state == ActivityState.DESTROYING || r.state == ActivityState.DESTROYED) continue;
            this.destroyActivityLocked(r, true, oomAdj, "trim");
        }
    }

    final boolean destroyActivityLocked(ActivityRecord r, boolean removeFromApp, boolean oomAdj, String reason) {
        boolean hadApp;
        EventLog.writeEvent((int)30018, (Object[])new Object[]{System.identityHashCode(r), r.task.taskId, r.shortComponentName, reason});
        boolean removedFromHistory = false;
        this.cleanUpActivityLocked(r, false, false);
        boolean bl = hadApp = r.app != null;
        if (hadApp) {
            boolean skipDestroy;
            block13: {
                if (removeFromApp) {
                    int idx = r.app.activities.indexOf(r);
                    if (idx >= 0) {
                        r.app.activities.remove(idx);
                    }
                    if (this.mService.mHeavyWeightProcess == r.app && r.app.activities.size() <= 0) {
                        this.mService.mHeavyWeightProcess = null;
                        this.mService.mHandler.sendEmptyMessage(25);
                    }
                    if (r.app.activities.size() == 0) {
                        this.mService.updateLruProcessLocked(r.app, oomAdj, false);
                    }
                }
                skipDestroy = false;
                try {
                    r.app.thread.scheduleDestroyActivity((IBinder)r.appToken, r.finishing, r.configChangeFlags);
                }
                catch (Exception e) {
                    if (!r.finishing) break block13;
                    this.removeActivityFromHistoryLocked(r);
                    removedFromHistory = true;
                    skipDestroy = true;
                }
            }
            r.app = null;
            r.nowVisible = false;
            if (r.finishing && !skipDestroy) {
                r.state = ActivityState.DESTROYING;
                Message msg = this.mHandler.obtainMessage(17);
                msg.obj = r;
                this.mHandler.sendMessageDelayed(msg, 10000L);
            } else {
                r.state = ActivityState.DESTROYED;
            }
        } else if (r.finishing) {
            this.removeActivityFromHistoryLocked(r);
            removedFromHistory = true;
        } else {
            r.state = ActivityState.DESTROYED;
        }
        r.configChangeFlags = 0;
        if (!this.mLRUActivities.remove(r) && hadApp) {
            Slog.w((String)TAG, (String)("Activity " + r + " being finished, but not in LRU list"));
        }
        return removedFromHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activityDestroyed(IBinder token) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            int index;
            ActivityRecord r = ActivityRecord.forToken(token);
            if (r != null) {
                this.mHandler.removeMessages(17, (Object)r);
            }
            if ((index = this.indexOfActivityLocked(r)) >= 0 && r.state == ActivityState.DESTROYING) {
                long origId = Binder.clearCallingIdentity();
                this.removeActivityFromHistoryLocked(r);
                Binder.restoreCallingIdentity((long)origId);
            }
        }
    }

    private static void removeHistoryRecordsForAppLocked(ArrayList list, ProcessRecord app) {
        int i = list.size();
        while (i > 0) {
            ActivityRecord r = (ActivityRecord)list.get(--i);
            if (r.app != app) continue;
            list.remove(i);
        }
    }

    void removeHistoryRecordsForAppLocked(ProcessRecord app) {
        ActivityStack.removeHistoryRecordsForAppLocked(this.mLRUActivities, app);
        ActivityStack.removeHistoryRecordsForAppLocked(this.mStoppingActivities, app);
        ActivityStack.removeHistoryRecordsForAppLocked(this.mGoingToSleepActivities, app);
        ActivityStack.removeHistoryRecordsForAppLocked(this.mWaitingVisibleActivities, app);
        ActivityStack.removeHistoryRecordsForAppLocked(this.mFinishingActivities, app);
    }

    final void moveHomeToFrontLocked() {
        TaskRecord homeTask = null;
        for (int i = this.mHistory.size() - 1; i >= 0; --i) {
            ActivityRecord hr = this.mHistory.get(i);
            if (!hr.isHomeActivity) continue;
            homeTask = hr.task;
            break;
        }
        if (homeTask != null) {
            this.moveTaskToFrontLocked(homeTask, null);
        }
    }

    final void moveTaskToFrontLocked(TaskRecord tr, ActivityRecord reason) {
        ActivityRecord r;
        int task = tr.taskId;
        int top = this.mHistory.size() - 1;
        if (top < 0 || this.mHistory.get((int)top).task.taskId == task) {
            return;
        }
        ArrayList<IBinder> moved = new ArrayList<IBinder>();
        for (int pos = top = this.mHistory.size() - 1; pos >= 0; --pos) {
            r = this.mHistory.get(pos);
            if (r.task.taskId != task) continue;
            this.mHistory.remove(pos);
            this.mHistory.add(top, r);
            moved.add(0, (IBinder)r.appToken);
            --top;
        }
        if (reason != null && (reason.intent.getFlags() & 0x10000) != 0) {
            this.mService.mWindowManager.prepareAppTransition(0, false);
            r = this.topRunningActivityLocked(null);
            if (r != null) {
                this.mNoAnimActivities.add(r);
            }
        } else {
            this.mService.mWindowManager.prepareAppTransition(4106, false);
        }
        this.mService.mWindowManager.moveAppTokensToTop(moved);
        this.finishTaskMoveLocked(task);
        EventLog.writeEvent((int)30002, (int)task);
    }

    private final void finishTaskMoveLocked(int task) {
        this.resumeTopActivityLocked(null);
    }

    final boolean moveTaskToBackLocked(int task, ActivityRecord reason) {
        ActivityRecord r;
        Slog.i((String)TAG, (String)("moveTaskToBack: " + task));
        if (this.mMainStack && this.mService.mController != null) {
            ActivityRecord next = this.topRunningActivityLocked(null, task);
            if (next == null) {
                next = this.topRunningActivityLocked(null, 0);
            }
            if (next != null) {
                boolean moveOK = true;
                try {
                    moveOK = this.mService.mController.activityResuming(next.packageName);
                }
                catch (RemoteException e) {
                    this.mService.mController = null;
                }
                if (!moveOK) {
                    return false;
                }
            }
        }
        ArrayList<IBinder> moved = new ArrayList<IBinder>();
        int N = this.mHistory.size();
        int bottom = 0;
        for (int pos = 0; pos < N; ++pos) {
            r = this.mHistory.get(pos);
            if (r.task.taskId != task) continue;
            this.mHistory.remove(pos);
            this.mHistory.add(bottom, r);
            moved.add((IBinder)r.appToken);
            ++bottom;
        }
        if (reason != null && (reason.intent.getFlags() & 0x10000) != 0) {
            this.mService.mWindowManager.prepareAppTransition(0, false);
            r = this.topRunningActivityLocked(null);
            if (r != null) {
                this.mNoAnimActivities.add(r);
            }
        } else {
            this.mService.mWindowManager.prepareAppTransition(8203, false);
        }
        this.mService.mWindowManager.moveAppTokensToBottom(moved);
        this.finishTaskMoveLocked(task);
        return true;
    }

    public ActivityManager.TaskThumbnails getTaskThumbnailsLocked(TaskRecord tr) {
        TaskAccessInfo info = this.getTaskAccessInfoLocked(tr.taskId, true);
        ActivityRecord resumed = this.mResumedActivity;
        info.mainThumbnail = resumed != null && resumed.thumbHolder == tr ? resumed.stack.screenshotActivities(resumed) : tr.lastThumbnail;
        return info;
    }

    public ActivityRecord removeTaskActivitiesLocked(int taskId, int subTaskIndex) {
        TaskAccessInfo info = this.getTaskAccessInfoLocked(taskId, false);
        if (info.root == null) {
            Slog.w((String)TAG, (String)("removeTaskLocked: unknown taskId " + taskId));
            return null;
        }
        if (subTaskIndex < 0) {
            this.performClearTaskAtIndexLocked(taskId, info.rootIndex);
            return info.root;
        }
        if (subTaskIndex >= info.subtasks.size()) {
            Slog.w((String)TAG, (String)("removeTaskLocked: unknown subTaskIndex " + subTaskIndex));
            return null;
        }
        TaskAccessInfo.SubTask subtask = info.subtasks.get(subTaskIndex);
        this.performClearTaskAtIndexLocked(taskId, subtask.index);
        return subtask.activity;
    }

    public TaskAccessInfo getTaskAccessInfoLocked(int taskId, boolean inclThumbs) {
        int j;
        ActivityRecord resumed = this.mResumedActivity;
        final TaskAccessInfo thumbs = new TaskAccessInfo();
        int NA = this.mHistory.size();
        ThumbnailHolder holder = null;
        for (j = 0; j < NA; ++j) {
            ActivityRecord ar = this.mHistory.get(j);
            if (ar.finishing || ar.task.taskId != taskId) continue;
            holder = ar.thumbHolder;
            break;
        }
        if (j >= NA) {
            return thumbs;
        }
        thumbs.root = this.mHistory.get(j);
        thumbs.rootIndex = j;
        ArrayList<TaskAccessInfo.SubTask> subtasks = new ArrayList<TaskAccessInfo.SubTask>();
        thumbs.subtasks = subtasks;
        ActivityRecord lastActivity = null;
        while (j < NA) {
            ActivityRecord ar = this.mHistory.get(j);
            ++j;
            if (ar.finishing) continue;
            if (ar.task.taskId != taskId) break;
            lastActivity = ar;
            if (ar.thumbHolder == holder || holder == null) continue;
            ++thumbs.numSubThumbbails;
            holder = ar.thumbHolder;
            TaskAccessInfo.SubTask sub = new TaskAccessInfo.SubTask();
            sub.thumbnail = holder.lastThumbnail;
            sub.activity = ar;
            sub.index = j - 1;
            subtasks.add(sub);
        }
        if (lastActivity != null && subtasks.size() > 0 && resumed == lastActivity) {
            TaskAccessInfo.SubTask sub = (TaskAccessInfo.SubTask)subtasks.get(subtasks.size() - 1);
            sub.thumbnail = lastActivity.stack.screenshotActivities(lastActivity);
        }
        if (thumbs.numSubThumbbails > 0) {
            thumbs.retriever = new IThumbnailRetriever.Stub(){

                public Bitmap getThumbnail(int index) {
                    if (index < 0 || index >= thumbs.subtasks.size()) {
                        return null;
                    }
                    return thumbs.subtasks.get((int)index).thumbnail;
                }
            };
        }
        return thumbs;
    }

    private final void logStartActivity(int tag, ActivityRecord r, TaskRecord task) {
        EventLog.writeEvent((int)tag, (Object[])new Object[]{System.identityHashCode(r), task.taskId, r.shortComponentName, r.intent.getAction(), r.intent.getType(), r.intent.getDataString(), r.intent.getFlags()});
    }

    final boolean ensureActivityConfigurationLocked(ActivityRecord r, int globalChanges) {
        if (this.mConfigWillChange) {
            return true;
        }
        Configuration newConfig = this.mService.mConfiguration;
        if (r.configuration == newConfig && !r.forceNewConfig) {
            return true;
        }
        if (r.finishing) {
            r.stopFreezingScreenLocked(false);
            return true;
        }
        Configuration oldConfig = r.configuration;
        r.configuration = newConfig;
        int changes = oldConfig.diff(newConfig);
        if (changes == 0 && !r.forceNewConfig) {
            return true;
        }
        if (r.app == null || r.app.thread == null) {
            r.stopFreezingScreenLocked(false);
            r.forceNewConfig = false;
            return true;
        }
        if ((changes & ~r.info.getRealConfigChanged()) != 0 || r.forceNewConfig) {
            r.configChangeFlags |= changes;
            r.startFreezingScreenLocked(r.app, globalChanges);
            r.forceNewConfig = false;
            if (r.app == null || r.app.thread == null) {
                this.destroyActivityLocked(r, true, false, "config");
            } else {
                if (r.state == ActivityState.PAUSING) {
                    r.configDestroy = true;
                    return true;
                }
                if (r.state == ActivityState.RESUMED) {
                    this.relaunchActivityLocked(r, r.configChangeFlags, true);
                    r.configChangeFlags = 0;
                } else {
                    this.relaunchActivityLocked(r, r.configChangeFlags, false);
                    r.configChangeFlags = 0;
                }
            }
            return false;
        }
        if (r.app != null && r.app.thread != null) {
            try {
                r.app.thread.scheduleActivityConfigurationChanged((IBinder)r.appToken);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        r.stopFreezingScreenLocked(false);
        return true;
    }

    private final boolean relaunchActivityLocked(ActivityRecord r, int changes, boolean andResume) {
        ArrayList results = null;
        ArrayList newIntents = null;
        if (andResume) {
            results = r.results;
            newIntents = r.newIntents;
        }
        EventLog.writeEvent((int)(andResume ? 30019 : 30020), (Object[])new Object[]{System.identityHashCode(r), r.task.taskId, r.shortComponentName});
        r.startFreezingScreenLocked(r.app, 0);
        try {
            r.forceNewConfig = false;
            r.app.thread.scheduleRelaunchActivity((IBinder)r.appToken, (List)results, (List)newIntents, changes, !andResume, new Configuration(this.mService.mConfiguration));
        }
        catch (RemoteException e) {
            return false;
        }
        if (andResume) {
            r.results = null;
            r.newIntents = null;
            if (this.mMainStack) {
                this.mService.reportResumedActivityLocked(r);
            }
        }
        return true;
    }

    public void dismissKeyguardOnNextActivityLocked() {
        this.mDismissKeyguardOnNextActivity = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ActivityState {
        INITIALIZING,
        RESUMED,
        PAUSING,
        PAUSED,
        STOPPING,
        STOPPED,
        FINISHING,
        DESTROYING,
        DESTROYED;

    }
}

