/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import com.android.server.am.ConnectionRecord;
import com.android.server.am.IntentBindRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ServiceRecord;
import java.io.PrintWriter;
import java.util.HashSet;

class AppBindRecord {
    final ServiceRecord service;
    final IntentBindRecord intent;
    final ProcessRecord client;
    final HashSet<ConnectionRecord> connections = new HashSet();

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "service=" + (Object)((Object)this.service));
        pw.println(prefix + "client=" + this.client);
        this.dumpInIntentBind(pw, prefix);
    }

    void dumpInIntentBind(PrintWriter pw, String prefix) {
        if (this.connections.size() > 0) {
            pw.println(prefix + "Per-process Connections:");
            for (ConnectionRecord c : this.connections) {
                pw.println(prefix + "  " + c);
            }
        }
    }

    AppBindRecord(ServiceRecord _service, IntentBindRecord _intent, ProcessRecord _client) {
        this.service = _service;
        this.intent = _intent;
        this.client = _client;
    }

    public String toString() {
        return "AppBindRecord{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.service.shortName + ":" + this.client.processName + "}";
    }
}

