/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.Dialog;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.ProcessRecord;

class AppWaitingForDebuggerDialog
extends BaseErrorDialog {
    final ActivityManagerService mService;
    final ProcessRecord mProc;
    private CharSequence mAppName;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AppWaitingForDebuggerDialog.this.mService.killAppAtUsersRequest(AppWaitingForDebuggerDialog.this.mProc, (Dialog)AppWaitingForDebuggerDialog.this);
                }
            }
        }
    };

    public AppWaitingForDebuggerDialog(ActivityManagerService service, Context context, ProcessRecord app) {
        super(context);
        this.mService = service;
        this.mProc = app;
        this.mAppName = context.getPackageManager().getApplicationLabel(app.info);
        this.setCancelable(false);
        StringBuilder text = new StringBuilder();
        if (this.mAppName != null && this.mAppName.length() > 0) {
            text.append("Application ");
            text.append(this.mAppName);
            text.append(" (process ");
            text.append(app.processName);
            text.append(")");
        } else {
            text.append("Process ");
            text.append(app.processName);
        }
        text.append(" is waiting for the debugger to attach.");
        this.setMessage(text.toString());
        this.setButton(-1, "Force Close", this.mHandler.obtainMessage(1, (Object)app));
        this.setTitle("Waiting For Debugger");
        this.getWindow().setTitle((CharSequence)("Waiting For Debugger: " + app.info.processName));
    }

    public void onStop() {
    }
}

