/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Process;
import android.os.ServiceManager;
import android.os.WorkSource;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.util.Slog;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.PowerProfile;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;

public final class BatteryStatsService
extends IBatteryStats.Stub {
    static IBatteryStats sService;
    final BatteryStatsImpl mStats;
    Context mContext;
    private boolean mBluetoothPendingStats;
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            BatteryStatsService.this.mBluetoothHeadset = (BluetoothHeadset)proxy;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsService.this.mStats;
            synchronized (batteryStatsImpl) {
                if (BatteryStatsService.this.mBluetoothPendingStats) {
                    BatteryStatsService.this.mStats.noteBluetoothOnLocked();
                    BatteryStatsService.this.mStats.setBtHeadset(BatteryStatsService.this.mBluetoothHeadset);
                    BatteryStatsService.this.mBluetoothPendingStats = false;
                }
            }
        }

        public void onServiceDisconnected(int profile) {
            BatteryStatsService.this.mBluetoothHeadset = null;
        }
    };

    BatteryStatsService(String filename) {
        this.mStats = new BatteryStatsImpl(filename);
    }

    public void publish(Context context) {
        this.mContext = context;
        ServiceManager.addService((String)"batteryinfo", (IBinder)this.asBinder());
        this.mStats.setNumSpeedSteps(new PowerProfile(this.mContext).getNumSpeedSteps());
        this.mStats.setRadioScanningTimeout((long)this.mContext.getResources().getInteger(17694726) * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Slog.w((String)"BatteryStats", (String)"Writing battery stats before shutdown...");
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.shutdownLocked();
        }
    }

    public static IBatteryStats getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService((String)"batteryinfo");
        sService = BatteryStatsService.asInterface((IBinder)b);
        return sService;
    }

    public BatteryStatsImpl getActiveStatistics() {
        return this.mStats;
    }

    public byte[] getStatistics() {
        this.mContext.enforceCallingPermission("android.permission.BATTERY_STATS", null);
        Parcel out = Parcel.obtain();
        this.mStats.writeToParcel(out, 0);
        byte[] data = out.marshall();
        out.recycle();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStartWakelock(int uid, int pid, String name, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartWakeLocked(uid, pid, name, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStopWakelock(int uid, int pid, String name, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopWakeLocked(uid, pid, name, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStartWakelockFromSource(WorkSource ws, int pid, String name, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartWakeFromSourceLocked(ws, pid, name, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStopWakelockFromSource(WorkSource ws, int pid, String name, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopWakeFromSourceLocked(ws, pid, name, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStartSensor(int uid, int sensor) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartSensorLocked(uid, sensor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStopSensor(int uid, int sensor) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopSensorLocked(uid, sensor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStartGps(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartGpsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStopGps(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopGpsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteScreenOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScreenOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteScreenBrightness(int brightness) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScreenBrightnessLocked(brightness);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteScreenOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScreenOffLocked();
        }
    }

    public void noteInputEvent() {
        this.enforceCallingPermission();
        this.mStats.noteInputEventAtomic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteUserActivity(int uid, int event) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteUserActivityLocked(uid, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePhoneOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePhoneOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePhoneSignalStrength(SignalStrength signalStrength) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneSignalStrengthLocked(signalStrength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePhoneDataConnectionState(int dataType, boolean hasData) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneDataConnectionStateLocked(dataType, hasData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePhoneState(int state) {
        this.enforceCallingPermission();
        int simState = TelephonyManager.getDefault().getSimState();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneStateLocked(state, simState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWifiOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWifiOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStartAudio(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAudioOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStopAudio(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAudioOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStartVideo(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVideoOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStopVideo(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVideoOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWifiRunning(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRunningLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWifiRunningChanged(WorkSource oldWs, WorkSource newWs) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRunningChangedLocked(oldWs, newWs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWifiStopped(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiStoppedLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteBluetoothOn() {
        this.enforceCallingPermission();
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
        }
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            if (this.mBluetoothHeadset != null) {
                this.mStats.noteBluetoothOnLocked();
                this.mStats.setBtHeadset(this.mBluetoothHeadset);
            } else {
                this.mBluetoothPendingStats = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteBluetoothOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mBluetoothPendingStats = false;
            this.mStats.noteBluetoothOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteFullWifiLockAcquired(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockAcquiredLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteFullWifiLockReleased(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockReleasedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteScanWifiLockAcquired(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScanWifiLockAcquiredLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteScanWifiLockReleased(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScanWifiLockReleasedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWifiMulticastEnabled(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastEnabledLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWifiMulticastDisabled(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastDisabledLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteFullWifiLockAcquiredFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockAcquiredFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteFullWifiLockReleasedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockReleasedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteScanWifiLockAcquiredFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScanWifiLockAcquiredFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteScanWifiLockReleasedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScanWifiLockReleasedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWifiMulticastEnabledFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastEnabledFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteWifiMulticastDisabledFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastDisabledFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteNetworkInterfaceType(String iface, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteNetworkInterfaceTypeLocked(iface, type);
        }
    }

    public boolean isOnBattery() {
        return this.mStats.isOnBattery();
    }

    public void setBatteryState(int status, int health, int plugType, int level, int temp, int volt) {
        this.enforceCallingPermission();
        this.mStats.setBatteryState(status, health, plugType, level, temp, volt);
    }

    public long getAwakeTimeBattery() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        return this.mStats.getAwakeTimeBattery();
    }

    public long getAwakeTimePlugged() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        return this.mStats.getAwakeTimePlugged();
    }

    public void enforceCallingPermission() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private void dumpHelp(PrintWriter pw) {
        pw.println("Battery stats (batteryinfo) dump options:");
        pw.println("  [--checkin] [--reset] [--write] [-h]");
        pw.println("  --checkin: format output for a checkin report.");
        pw.println("  --reset: reset the stats, clearing all current data.");
        pw.println("  --write: force write current collected stats to disk.");
        pw.println("  -h: print this help text.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump BatteryStats from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        boolean isCheckin = false;
        boolean noOutput = false;
        if (args != null) {
            for (String arg : args) {
                BatteryStatsImpl batteryStatsImpl;
                if ("--checkin".equals(arg)) {
                    isCheckin = true;
                    continue;
                }
                if ("--reset".equals(arg)) {
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.resetAllStatsLocked();
                        pw.println("Battery stats reset.");
                        noOutput = true;
                        continue;
                    }
                }
                if ("--write".equals(arg)) {
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.writeSyncLocked();
                        pw.println("Battery stats written.");
                        noOutput = true;
                        continue;
                    }
                }
                if ("-h".equals(arg)) {
                    this.dumpHelp(pw);
                    return;
                }
                if ("-a".equals(arg)) continue;
                pw.println("Unknown option: " + arg);
                this.dumpHelp(pw);
            }
        }
        if (noOutput) {
            return;
        }
        if (isCheckin) {
            List apps = this.mContext.getPackageManager().getInstalledApplications(0);
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.dumpCheckinLocked(pw, args, apps);
            }
        }
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.dumpLocked(pw);
        }
    }
}

