/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.PrintWriterPrinter;
import android.util.Printer;
import android.util.TimeUtils;
import com.android.server.am.BroadcastFilter;
import com.android.server.am.ProcessRecord;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;

class BroadcastRecord
extends Binder {
    final Intent intent;
    final ProcessRecord callerApp;
    final String callerPackage;
    final int callingPid;
    final int callingUid;
    final boolean ordered;
    final boolean sticky;
    final boolean initialSticky;
    final String requiredPermission;
    final List receivers;
    IIntentReceiver resultTo;
    long dispatchTime;
    long dispatchClockTime;
    long receiverTime;
    long finishTime;
    int resultCode;
    String resultData;
    Bundle resultExtras;
    boolean resultAbort;
    int nextReceiver;
    IBinder receiver;
    int state;
    int anrCount;
    static final int IDLE = 0;
    static final int APP_RECEIVE = 1;
    static final int CALL_IN_RECEIVE = 2;
    static final int CALL_DONE_RECEIVE = 3;
    BroadcastFilter curFilter;
    ProcessRecord curApp;
    ComponentName curComponent;
    ActivityInfo curReceiver;

    void dump(PrintWriter pw, String prefix) {
        Bundle bundle;
        long now = SystemClock.uptimeMillis();
        pw.print(prefix);
        pw.println((Object)this);
        pw.print(prefix);
        pw.println(this.intent);
        if (this.sticky && (bundle = this.intent.getExtras()) != null) {
            pw.print(prefix);
            pw.print("extras: ");
            pw.println(bundle.toString());
        }
        pw.print(prefix);
        pw.print("caller=");
        pw.print(this.callerPackage);
        pw.print(" ");
        pw.print(this.callerApp != null ? this.callerApp.toShortString() : "null");
        pw.print(" pid=");
        pw.print(this.callingPid);
        pw.print(" uid=");
        pw.println(this.callingUid);
        if (this.requiredPermission != null) {
            pw.print(prefix);
            pw.print("requiredPermission=");
            pw.println(this.requiredPermission);
        }
        pw.print(prefix);
        pw.print("dispatchClockTime=");
        pw.println(new Date(this.dispatchClockTime));
        pw.print(prefix);
        pw.print("dispatchTime=");
        TimeUtils.formatDuration((long)this.dispatchTime, (long)now, (PrintWriter)pw);
        if (this.finishTime != 0L) {
            pw.print(" finishTime=");
            TimeUtils.formatDuration((long)this.finishTime, (long)now, (PrintWriter)pw);
        } else {
            pw.print(" receiverTime=");
            TimeUtils.formatDuration((long)this.receiverTime, (long)now, (PrintWriter)pw);
        }
        pw.println("");
        if (this.anrCount != 0) {
            pw.print(prefix);
            pw.print("anrCount=");
            pw.println(this.anrCount);
        }
        if (this.resultTo != null || this.resultCode != -1 || this.resultData != null) {
            pw.print(prefix);
            pw.print("resultTo=");
            pw.print(this.resultTo);
            pw.print(" resultCode=");
            pw.print(this.resultCode);
            pw.print(" resultData=");
            pw.println(this.resultData);
        }
        if (this.resultExtras != null) {
            pw.print(prefix);
            pw.print("resultExtras=");
            pw.println(this.resultExtras);
        }
        if (this.resultAbort || this.ordered || this.sticky || this.initialSticky) {
            pw.print(prefix);
            pw.print("resultAbort=");
            pw.print(this.resultAbort);
            pw.print(" ordered=");
            pw.print(this.ordered);
            pw.print(" sticky=");
            pw.print(this.sticky);
            pw.print(" initialSticky=");
            pw.println(this.initialSticky);
        }
        if (this.nextReceiver != 0 || this.receiver != null) {
            pw.print(prefix);
            pw.print("nextReceiver=");
            pw.print(this.nextReceiver);
            pw.print(" receiver=");
            pw.println(this.receiver);
        }
        if (this.curFilter != null) {
            pw.print(prefix);
            pw.print("curFilter=");
            pw.println((Object)this.curFilter);
        }
        if (this.curReceiver != null) {
            pw.print(prefix);
            pw.print("curReceiver=");
            pw.println(this.curReceiver);
        }
        if (this.curApp != null) {
            pw.print(prefix);
            pw.print("curApp=");
            pw.println(this.curApp);
            pw.print(prefix);
            pw.print("curComponent=");
            pw.println(this.curComponent != null ? this.curComponent.toShortString() : "--");
            if (this.curReceiver != null && this.curReceiver.applicationInfo != null) {
                pw.print(prefix);
                pw.print("curSourceDir=");
                pw.println(this.curReceiver.applicationInfo.sourceDir);
            }
        }
        String stateStr = " (?)";
        switch (this.state) {
            case 0: {
                stateStr = " (IDLE)";
                break;
            }
            case 1: {
                stateStr = " (APP_RECEIVE)";
                break;
            }
            case 2: {
                stateStr = " (CALL_IN_RECEIVE)";
                break;
            }
            case 3: {
                stateStr = " (CALL_DONE_RECEIVE)";
            }
        }
        pw.print(prefix);
        pw.print("state=");
        pw.print(this.state);
        pw.println(stateStr);
        int N = this.receivers != null ? this.receivers.size() : 0;
        String p2 = prefix + "  ";
        PrintWriterPrinter printer = new PrintWriterPrinter(pw);
        for (int i = 0; i < N; ++i) {
            Object o = this.receivers.get(i);
            pw.print(prefix);
            pw.print("Receiver #");
            pw.print(i);
            pw.print(": ");
            pw.println(o);
            if (o instanceof BroadcastFilter) {
                ((BroadcastFilter)((Object)o)).dumpBrief(pw, p2);
                continue;
            }
            if (!(o instanceof ResolveInfo)) continue;
            ((ResolveInfo)o).dump((Printer)printer, p2);
        }
    }

    BroadcastRecord(Intent _intent, ProcessRecord _callerApp, String _callerPackage, int _callingPid, int _callingUid, String _requiredPermission, List _receivers, IIntentReceiver _resultTo, int _resultCode, String _resultData, Bundle _resultExtras, boolean _serialized, boolean _sticky, boolean _initialSticky) {
        this.intent = _intent;
        this.callerApp = _callerApp;
        this.callerPackage = _callerPackage;
        this.callingPid = _callingPid;
        this.callingUid = _callingUid;
        this.requiredPermission = _requiredPermission;
        this.receivers = _receivers;
        this.resultTo = _resultTo;
        this.resultCode = _resultCode;
        this.resultData = _resultData;
        this.resultExtras = _resultExtras;
        this.ordered = _serialized;
        this.sticky = _sticky;
        this.initialSticky = _initialSticky;
        this.nextReceiver = 0;
        this.state = 0;
    }

    public String toString() {
        return "BroadcastRecord{" + Integer.toHexString(System.identityHashCode((Object)this)) + " " + this.intent.getAction() + "}";
    }
}

