/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.AppGlobals;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.res.CompatibilityInfo;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.os.AtomicFile;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ProcessRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatModePackages {
    private final String TAG = "ActivityManager";
    private final boolean DEBUG_CONFIGURATION = false;
    private final ActivityManagerService mService;
    private final AtomicFile mFile;
    public static final int COMPAT_FLAG_DONT_ASK = 1;
    public static final int COMPAT_FLAG_ENABLED = 2;
    private final HashMap<String, Integer> mPackages;
    private static final int MSG_WRITE = 1;
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompatModePackages(ActivityManagerService service, File systemDir) {
        block22: {
            this.TAG = "ActivityManager";
            this.DEBUG_CONFIGURATION = false;
            this.mPackages = new HashMap();
            this.mHandler = new Handler(){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            CompatModePackages.this.saveCompatModes();
                            break;
                        }
                        default: {
                            super.handleMessage(msg);
                        }
                    }
                }
            };
            this.mService = service;
            this.mFile = new AtomicFile(new File(systemDir, "packages-compat.xml"));
            FileInputStream fis = null;
            try {
                fis = this.mFile.openRead();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput((InputStream)fis, null);
                int eventType = parser.getEventType();
                while (eventType != 2) {
                    eventType = parser.next();
                }
                String tagName = parser.getName();
                if (!"compat-packages".equals(tagName)) break block22;
                eventType = parser.next();
                do {
                    String pkg;
                    if (eventType != 2) continue;
                    tagName = parser.getName();
                    if (parser.getDepth() != 2 || !"pkg".equals(tagName) || (pkg = parser.getAttributeValue(null, "name")) == null) continue;
                    String mode = parser.getAttributeValue(null, "mode");
                    int modeInt = 0;
                    if (mode != null) {
                        try {
                            modeInt = Integer.parseInt(mode);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    this.mPackages.put(pkg, modeInt);
                } while ((eventType = parser.next()) != 1);
            }
            catch (XmlPullParserException e) {
                Slog.w((String)"ActivityManager", (String)"Error reading compat-packages", (Throwable)e);
            }
            catch (IOException e) {
                if (fis != null) {
                    Slog.w((String)"ActivityManager", (String)"Error reading compat-packages", (Throwable)e);
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e1) {}
                }
            }
        }
    }

    public HashMap<String, Integer> getPackages() {
        return this.mPackages;
    }

    private int getPackageFlags(String packageName) {
        Integer flags = this.mPackages.get(packageName);
        return flags != null ? flags : 0;
    }

    public void handlePackageAddedLocked(String packageName, boolean updated) {
        boolean mayCompat;
        ApplicationInfo ai = null;
        try {
            ai = AppGlobals.getPackageManager().getApplicationInfo(packageName, 0);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (ai == null) {
            return;
        }
        CompatibilityInfo ci = this.compatibilityInfoForPackageLocked(ai);
        boolean bl = mayCompat = !ci.alwaysSupportsScreen() && !ci.neverSupportsScreen();
        if (updated && !mayCompat && this.mPackages.containsKey(packageName)) {
            this.mPackages.remove(packageName);
            this.mHandler.removeMessages(1);
            Message msg = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(msg, 10000L);
        }
    }

    public CompatibilityInfo compatibilityInfoForPackageLocked(ApplicationInfo ai) {
        CompatibilityInfo ci = new CompatibilityInfo(ai, this.mService.mConfiguration.screenLayout, this.mService.mConfiguration.smallestScreenWidthDp, (this.getPackageFlags(ai.packageName) & 2) != 0);
        return ci;
    }

    public int computeCompatModeLocked(ApplicationInfo ai) {
        boolean enabled = (this.getPackageFlags(ai.packageName) & 2) != 0;
        CompatibilityInfo info = new CompatibilityInfo(ai, this.mService.mConfiguration.screenLayout, this.mService.mConfiguration.smallestScreenWidthDp, enabled);
        if (info.alwaysSupportsScreen()) {
            return -2;
        }
        if (info.neverSupportsScreen()) {
            return -1;
        }
        return enabled ? 1 : 0;
    }

    public boolean getFrontActivityAskCompatModeLocked() {
        ActivityRecord r = this.mService.mMainStack.topRunningActivityLocked(null);
        if (r == null) {
            return false;
        }
        return this.getPackageAskCompatModeLocked(r.packageName);
    }

    public boolean getPackageAskCompatModeLocked(String packageName) {
        return (this.getPackageFlags(packageName) & 1) == 0;
    }

    public void setFrontActivityAskCompatModeLocked(boolean ask) {
        ActivityRecord r = this.mService.mMainStack.topRunningActivityLocked(null);
        if (r != null) {
            this.setPackageAskCompatModeLocked(r.packageName, ask);
        }
    }

    public void setPackageAskCompatModeLocked(String packageName, boolean ask) {
        int newFlags;
        int curFlags = this.getPackageFlags(packageName);
        int n = newFlags = ask ? curFlags & 0xFFFFFFFE : curFlags | 1;
        if (curFlags != newFlags) {
            if (newFlags != 0) {
                this.mPackages.put(packageName, newFlags);
            } else {
                this.mPackages.remove(packageName);
            }
            this.mHandler.removeMessages(1);
            Message msg = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(msg, 10000L);
        }
    }

    public int getFrontActivityScreenCompatModeLocked() {
        ActivityRecord r = this.mService.mMainStack.topRunningActivityLocked(null);
        if (r == null) {
            return -3;
        }
        return this.computeCompatModeLocked(r.info.applicationInfo);
    }

    public void setFrontActivityScreenCompatModeLocked(int mode) {
        ActivityRecord r = this.mService.mMainStack.topRunningActivityLocked(null);
        if (r == null) {
            Slog.w((String)"ActivityManager", (String)"setFrontActivityScreenCompatMode failed: no top activity");
            return;
        }
        this.setPackageScreenCompatModeLocked(r.info.applicationInfo, mode);
    }

    public int getPackageScreenCompatModeLocked(String packageName) {
        ApplicationInfo ai = null;
        try {
            ai = AppGlobals.getPackageManager().getApplicationInfo(packageName, 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (ai == null) {
            return -3;
        }
        return this.computeCompatModeLocked(ai);
    }

    public void setPackageScreenCompatModeLocked(String packageName, int mode) {
        ApplicationInfo ai = null;
        try {
            ai = AppGlobals.getPackageManager().getApplicationInfo(packageName, 0);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (ai == null) {
            Slog.w((String)"ActivityManager", (String)("setPackageScreenCompatMode failed: unknown package " + packageName));
            return;
        }
        this.setPackageScreenCompatModeLocked(ai, mode);
    }

    private void setPackageScreenCompatModeLocked(ApplicationInfo ai, int mode) {
        boolean enable;
        String packageName = ai.packageName;
        int curFlags = this.getPackageFlags(packageName);
        switch (mode) {
            case 0: {
                enable = false;
                break;
            }
            case 1: {
                enable = true;
                break;
            }
            case 2: {
                enable = (curFlags & 2) == 0;
                break;
            }
            default: {
                Slog.w((String)"ActivityManager", (String)("Unknown screen compat mode req #" + mode + "; ignoring"));
                return;
            }
        }
        int newFlags = curFlags;
        newFlags = enable ? (newFlags |= 2) : (newFlags &= 0xFFFFFFFD);
        CompatibilityInfo ci = this.compatibilityInfoForPackageLocked(ai);
        if (ci.alwaysSupportsScreen()) {
            Slog.w((String)"ActivityManager", (String)("Ignoring compat mode change of " + packageName + "; compatibility never needed"));
            newFlags = 0;
        }
        if (ci.neverSupportsScreen()) {
            Slog.w((String)"ActivityManager", (String)("Ignoring compat mode change of " + packageName + "; compatibility always needed"));
            newFlags = 0;
        }
        if (newFlags != curFlags) {
            int i;
            if (newFlags != 0) {
                this.mPackages.put(packageName, newFlags);
            } else {
                this.mPackages.remove(packageName);
            }
            ci = this.compatibilityInfoForPackageLocked(ai);
            this.mHandler.removeMessages(1);
            Message msg = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(msg, 10000L);
            ActivityRecord starting = this.mService.mMainStack.topRunningActivityLocked(null);
            for (i = this.mService.mMainStack.mHistory.size() - 1; i >= 0; --i) {
                ActivityRecord a = this.mService.mMainStack.mHistory.get(i);
                if (!a.info.packageName.equals(packageName)) continue;
                a.forceNewConfig = true;
                if (starting == null || a != starting || !a.visible) continue;
                a.startFreezingScreenLocked(starting.app, 256);
            }
            for (i = this.mService.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mService.mLruProcesses.get(i);
                if (!app.pkgList.contains(packageName)) continue;
                try {
                    if (app.thread == null) continue;
                    app.thread.updatePackageCompatibilityInfo(packageName, ci);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (starting != null) {
                this.mService.mMainStack.ensureActivityConfigurationLocked(starting, 0);
                this.mService.mMainStack.ensureActivitiesVisibleLocked(starting, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveCompatModes() {
        block8: {
            HashMap<String, Integer> pkgs;
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                pkgs = new HashMap<String, Integer>(this.mPackages);
            }
            FileOutputStream fos = null;
            try {
                fos = this.mFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput((OutputStream)fos, "utf-8");
                out.startDocument(null, Boolean.valueOf(true));
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "compat-packages");
                IPackageManager pm = AppGlobals.getPackageManager();
                int screenLayout = this.mService.mConfiguration.screenLayout;
                int smallestScreenWidthDp = this.mService.mConfiguration.smallestScreenWidthDp;
                for (Map.Entry<String, Integer> entry : pkgs.entrySet()) {
                    CompatibilityInfo info;
                    String pkg = entry.getKey();
                    int mode = entry.getValue();
                    if (mode == 0) continue;
                    ApplicationInfo ai = null;
                    try {
                        ai = pm.getApplicationInfo(pkg, 0);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    if (ai == null || (info = new CompatibilityInfo(ai, screenLayout, smallestScreenWidthDp, false)).alwaysSupportsScreen() || info.neverSupportsScreen()) continue;
                    out.startTag(null, "pkg");
                    out.attribute(null, "name", pkg);
                    out.attribute(null, "mode", Integer.toString(mode));
                    out.endTag(null, "pkg");
                }
                out.endTag(null, "compat-packages");
                out.endDocument();
                this.mFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Slog.w((String)"ActivityManager", (String)"Error writing compat packages", (Throwable)e1);
                if (fos == null) break block8;
                this.mFile.failWrite(fos);
            }
        }
    }
}

