/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.IServiceConnection;
import android.app.PendingIntent;
import com.android.server.am.ActivityRecord;
import com.android.server.am.AppBindRecord;
import java.io.PrintWriter;

class ConnectionRecord {
    final AppBindRecord binding;
    final ActivityRecord activity;
    final IServiceConnection conn;
    final int flags;
    final int clientLabel;
    final PendingIntent clientIntent;
    String stringName;
    boolean serviceDead;

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "binding=" + this.binding);
        if (this.activity != null) {
            pw.println(prefix + "activity=" + this.activity);
        }
        pw.println(prefix + "conn=" + this.conn.asBinder() + " flags=0x" + Integer.toHexString(this.flags));
    }

    ConnectionRecord(AppBindRecord _binding, ActivityRecord _activity, IServiceConnection _conn, int _flags, int _clientLabel, PendingIntent _clientIntent) {
        this.binding = _binding;
        this.activity = _activity;
        this.conn = _conn;
        this.flags = _flags;
        this.clientLabel = _clientLabel;
        this.clientIntent = _clientIntent;
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ConnectionRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        if (this.serviceDead) {
            sb.append("DEAD ");
        }
        sb.append(this.binding.service.shortName);
        sb.append(":@");
        sb.append(Integer.toHexString(System.identityHashCode(this.conn.asBinder())));
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }
}

