/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.IActivityManager;
import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.content.pm.ProviderInfo;
import com.android.server.am.ProcessRecord;
import java.io.PrintWriter;
import java.util.HashSet;

class ContentProviderRecord
extends IActivityManager.ContentProviderHolder {
    final HashSet<ProcessRecord> clients = new HashSet();
    final int uid;
    final ApplicationInfo appInfo;
    final ComponentName name;
    int externals;
    ProcessRecord proc;
    ProcessRecord launchingApp;
    String stringName;

    public ContentProviderRecord(ProviderInfo _info, ApplicationInfo ai, ComponentName _name) {
        super(_info);
        this.uid = ai.uid;
        this.appInfo = ai;
        this.name = _name;
        this.noReleaseNeeded = this.uid == 0 || this.uid == 1000;
    }

    public ContentProviderRecord(ContentProviderRecord cpr) {
        super(cpr.info);
        this.uid = cpr.uid;
        this.appInfo = cpr.appInfo;
        this.name = cpr.name;
        this.noReleaseNeeded = cpr.noReleaseNeeded;
    }

    public boolean canRunHere(ProcessRecord app) {
        return !(!this.info.multiprocess && !this.info.processName.equals(app.processName) || this.uid != 1000 && this.uid != app.info.uid);
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("package=");
        pw.print(this.info.applicationInfo.packageName);
        pw.print(" process=");
        pw.println(this.info.processName);
        pw.print(prefix);
        pw.print("proc=");
        pw.println(this.proc);
        if (this.launchingApp != null) {
            pw.print(prefix);
            pw.print("launchingApp=");
            pw.println(this.launchingApp);
        }
        pw.print(prefix);
        pw.print("uid=");
        pw.print(this.uid);
        pw.print(" provider=");
        pw.println(this.provider);
        pw.print(prefix);
        pw.print("name=");
        pw.println(this.info.authority);
        if (this.info.isSyncable || this.info.multiprocess || this.info.initOrder != 0) {
            pw.print(prefix);
            pw.print("isSyncable=");
            pw.print(this.info.isSyncable);
            pw.print("multiprocess=");
            pw.print(this.info.multiprocess);
            pw.print(" initOrder=");
            pw.println(this.info.initOrder);
        }
        if (this.externals != 0) {
            pw.print(prefix);
            pw.print("externals=");
            pw.println(this.externals);
        }
        if (this.clients.size() > 0) {
            pw.print(prefix);
            pw.println("Clients:");
            for (ProcessRecord cproc : this.clients) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(cproc.toShortString());
            }
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ContentProviderRecord{");
        sb.append(Integer.toHexString(System.identityHashCode((Object)this)));
        sb.append(' ');
        sb.append(this.info.name);
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }
}

