/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.util.Slog;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

class DeviceMonitor {
    private static final String LOG_TAG = DeviceMonitor.class.getName();
    private static final int SAMPLE_COUNT = 10;
    private static final int INTERVAL = 1000;
    private static final int MAX_FILES = 30;
    private final byte[] buffer = new byte[1024];
    private boolean running = false;
    private static final File PROC = new File("/proc");
    private static final File BASE = new File("/data/anr/");
    private static final File[] PATHS;
    private static DeviceMonitor instance;

    private DeviceMonitor() {
        new Thread(){

            public void run() {
                DeviceMonitor.this.monitor();
            }
        }.start();
    }

    private void monitor() {
        while (true) {
            this.waitForStart();
            this.purge();
            for (int i = 0; i < 10; ++i) {
                try {
                    this.dump();
                }
                catch (IOException e) {
                    Slog.w((String)LOG_TAG, (String)"Dump failed.", (Throwable)e);
                }
                this.pause();
            }
            this.stop();
        }
    }

    private void purge() {
        Object[] files = BASE.listFiles();
        int count = files.length - 30;
        if (count > 0) {
            Arrays.sort(files);
            for (int i = 0; i < count; ++i) {
                if (((File)files[i]).delete()) continue;
                Slog.w((String)LOG_TAG, (String)("Couldn't delete " + files[i] + "."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() throws IOException {
        FileOutputStream out = new FileOutputStream(new File(BASE, String.valueOf(System.currentTimeMillis())));
        try {
            for (File processDirectory : PROC.listFiles()) {
                if (!DeviceMonitor.isProcessDirectory(processDirectory)) continue;
                this.dump(new File(processDirectory, "stat"), out);
            }
            for (File file : PATHS) {
                this.dump(file, out);
            }
        }
        finally {
            DeviceMonitor.closeQuietly(out);
        }
    }

    private static boolean isProcessDirectory(File file) {
        try {
            Integer.parseInt(file.getName());
            return file.isDirectory();
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(File from, OutputStream out) throws IOException {
        DeviceMonitor.writeHeader(from, out);
        FileInputStream in = null;
        try {
            int count;
            in = new FileInputStream(from);
            while ((count = in.read(this.buffer)) != -1) {
                out.write(this.buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            DeviceMonitor.closeQuietly(in);
            throw throwable;
        }
        DeviceMonitor.closeQuietly(in);
    }

    private static void writeHeader(File file, OutputStream out) throws IOException {
        String header = "*** " + file.toString() + "\n";
        out.write(header.getBytes());
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            Slog.w((String)LOG_TAG, (Throwable)e);
        }
    }

    private void pause() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void stop() {
        this.running = false;
    }

    private synchronized void waitForStart() {
        while (!this.running) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void startMonitoring() {
        if (!this.running) {
            this.running = true;
            this.notifyAll();
        }
    }

    static void start() {
        instance.startMonitoring();
    }

    static {
        if (!BASE.isDirectory() && !BASE.mkdirs()) {
            throw new AssertionError((Object)("Couldn't create " + BASE + "."));
        }
        PATHS = new File[]{new File(PROC, "zoneinfo"), new File(PROC, "interrupts"), new File(PROC, "meminfo"), new File(PROC, "slabinfo")};
        instance = new DeviceMonitor();
    }
}

