/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.util.EventLog;

public class EventLogTags {
    public static final int CONFIGURATION_CHANGED = 2719;
    public static final int CPU = 2721;
    public static final int BOOT_PROGRESS_AMS_READY = 3040;
    public static final int BOOT_PROGRESS_ENABLE_SCREEN = 3050;
    public static final int AM_FINISH_ACTIVITY = 30001;
    public static final int AM_TASK_TO_FRONT = 30002;
    public static final int AM_NEW_INTENT = 30003;
    public static final int AM_CREATE_TASK = 30004;
    public static final int AM_CREATE_ACTIVITY = 30005;
    public static final int AM_RESTART_ACTIVITY = 30006;
    public static final int AM_RESUME_ACTIVITY = 30007;
    public static final int AM_ANR = 30008;
    public static final int ACTIVITY_LAUNCH_TIME = 30009;
    public static final int AM_PROC_BOUND = 30010;
    public static final int AM_PROC_DIED = 30011;
    public static final int AM_FAILED_TO_PAUSE = 30012;
    public static final int AM_PAUSE_ACTIVITY = 30013;
    public static final int AM_PROC_START = 30014;
    public static final int AM_PROC_BAD = 30015;
    public static final int AM_PROC_GOOD = 30016;
    public static final int AM_LOW_MEMORY = 30017;
    public static final int AM_DESTROY_ACTIVITY = 30018;
    public static final int AM_RELAUNCH_RESUME_ACTIVITY = 30019;
    public static final int AM_RELAUNCH_ACTIVITY = 30020;
    public static final int AM_ON_PAUSED_CALLED = 30021;
    public static final int AM_ON_RESUME_CALLED = 30022;
    public static final int AM_KILL = 30023;
    public static final int AM_BROADCAST_DISCARD_FILTER = 30024;
    public static final int AM_BROADCAST_DISCARD_APP = 30025;
    public static final int AM_CREATE_SERVICE = 30030;
    public static final int AM_DESTROY_SERVICE = 30031;
    public static final int AM_PROCESS_CRASHED_TOO_MUCH = 30032;
    public static final int AM_DROP_PROCESS = 30033;
    public static final int AM_SERVICE_CRASHED_TOO_MUCH = 30034;
    public static final int AM_SCHEDULE_SERVICE_RESTART = 30035;
    public static final int AM_PROVIDER_LOST_PROCESS = 30036;
    public static final int AM_PROCESS_START_TIMEOUT = 30037;
    public static final int AM_CRASH = 30039;
    public static final int AM_WTF = 30040;

    private EventLogTags() {
    }

    public static void writeConfigurationChanged(int configMask) {
        EventLog.writeEvent((int)2719, (int)configMask);
    }

    public static void writeCpu(int total, int user, int system, int iowait, int irq, int softirq) {
        EventLog.writeEvent((int)2721, (Object[])new Object[]{total, user, system, iowait, irq, softirq});
    }

    public static void writeBootProgressAmsReady(long time) {
        EventLog.writeEvent((int)3040, (long)time);
    }

    public static void writeBootProgressEnableScreen(long time) {
        EventLog.writeEvent((int)3050, (long)time);
    }

    public static void writeAmFinishActivity(int token, int taskId, String componentName, String reason) {
        EventLog.writeEvent((int)30001, (Object[])new Object[]{token, taskId, componentName, reason});
    }

    public static void writeAmTaskToFront(int task) {
        EventLog.writeEvent((int)30002, (int)task);
    }

    public static void writeAmNewIntent(int token, int taskId, String componentName, String action, String mimeType, String uri, int flags) {
        EventLog.writeEvent((int)30003, (Object[])new Object[]{token, taskId, componentName, action, mimeType, uri, flags});
    }

    public static void writeAmCreateTask(int taskId) {
        EventLog.writeEvent((int)30004, (int)taskId);
    }

    public static void writeAmCreateActivity(int token, int taskId, String componentName, String action, String mimeType, String uri, int flags) {
        EventLog.writeEvent((int)30005, (Object[])new Object[]{token, taskId, componentName, action, mimeType, uri, flags});
    }

    public static void writeAmRestartActivity(int token, int taskId, String componentName) {
        EventLog.writeEvent((int)30006, (Object[])new Object[]{token, taskId, componentName});
    }

    public static void writeAmResumeActivity(int token, int taskId, String componentName) {
        EventLog.writeEvent((int)30007, (Object[])new Object[]{token, taskId, componentName});
    }

    public static void writeAmAnr(int pid, String packageName, int flags, String reason) {
        EventLog.writeEvent((int)30008, (Object[])new Object[]{pid, packageName, flags, reason});
    }

    public static void writeActivityLaunchTime(int token, String componentName, long time) {
        EventLog.writeEvent((int)30009, (Object[])new Object[]{token, componentName, time});
    }

    public static void writeAmProcBound(int pid, String processName) {
        EventLog.writeEvent((int)30010, (Object[])new Object[]{pid, processName});
    }

    public static void writeAmProcDied(int pid, String processName) {
        EventLog.writeEvent((int)30011, (Object[])new Object[]{pid, processName});
    }

    public static void writeAmFailedToPause(int token, String wantingToPause, String currentlyPausing) {
        EventLog.writeEvent((int)30012, (Object[])new Object[]{token, wantingToPause, currentlyPausing});
    }

    public static void writeAmPauseActivity(int token, String componentName) {
        EventLog.writeEvent((int)30013, (Object[])new Object[]{token, componentName});
    }

    public static void writeAmProcStart(int pid, int uid, String processName, String type, String component) {
        EventLog.writeEvent((int)30014, (Object[])new Object[]{pid, uid, processName, type, component});
    }

    public static void writeAmProcBad(int uid, String processName) {
        EventLog.writeEvent((int)30015, (Object[])new Object[]{uid, processName});
    }

    public static void writeAmProcGood(int uid, String processName) {
        EventLog.writeEvent((int)30016, (Object[])new Object[]{uid, processName});
    }

    public static void writeAmLowMemory(int numProcesses) {
        EventLog.writeEvent((int)30017, (int)numProcesses);
    }

    public static void writeAmDestroyActivity(int token, int taskId, String componentName, String reason) {
        EventLog.writeEvent((int)30018, (Object[])new Object[]{token, taskId, componentName, reason});
    }

    public static void writeAmRelaunchResumeActivity(int token, int taskId, String componentName) {
        EventLog.writeEvent((int)30019, (Object[])new Object[]{token, taskId, componentName});
    }

    public static void writeAmRelaunchActivity(int token, int taskId, String componentName) {
        EventLog.writeEvent((int)30020, (Object[])new Object[]{token, taskId, componentName});
    }

    public static void writeAmOnPausedCalled(String componentName) {
        EventLog.writeEvent((int)30021, (String)componentName);
    }

    public static void writeAmOnResumeCalled(String componentName) {
        EventLog.writeEvent((int)30022, (String)componentName);
    }

    public static void writeAmKill(int pid, String processName, int oomadj, String reason) {
        EventLog.writeEvent((int)30023, (Object[])new Object[]{pid, processName, oomadj, reason});
    }

    public static void writeAmBroadcastDiscardFilter(int broadcast, String action, int receiverNumber, int broadcastfilter) {
        EventLog.writeEvent((int)30024, (Object[])new Object[]{broadcast, action, receiverNumber, broadcastfilter});
    }

    public static void writeAmBroadcastDiscardApp(int broadcast, String action, int receiverNumber, String app) {
        EventLog.writeEvent((int)30025, (Object[])new Object[]{broadcast, action, receiverNumber, app});
    }

    public static void writeAmCreateService(int serviceRecord, String name, String intent, int pid) {
        EventLog.writeEvent((int)30030, (Object[])new Object[]{serviceRecord, name, intent, pid});
    }

    public static void writeAmDestroyService(int serviceRecord, String name, int pid) {
        EventLog.writeEvent((int)30031, (Object[])new Object[]{serviceRecord, name, pid});
    }

    public static void writeAmProcessCrashedTooMuch(String name, int pid) {
        EventLog.writeEvent((int)30032, (Object[])new Object[]{name, pid});
    }

    public static void writeAmDropProcess(int pid) {
        EventLog.writeEvent((int)30033, (int)pid);
    }

    public static void writeAmServiceCrashedTooMuch(int crashCount, String componentName, int pid) {
        EventLog.writeEvent((int)30034, (Object[])new Object[]{crashCount, componentName, pid});
    }

    public static void writeAmScheduleServiceRestart(String componentName, long time) {
        EventLog.writeEvent((int)30035, (Object[])new Object[]{componentName, time});
    }

    public static void writeAmProviderLostProcess(String packageName, int uid, String name) {
        EventLog.writeEvent((int)30036, (Object[])new Object[]{packageName, uid, name});
    }

    public static void writeAmProcessStartTimeout(int pid, int uid, String processName) {
        EventLog.writeEvent((int)30037, (Object[])new Object[]{pid, uid, processName});
    }

    public static void writeAmCrash(int pid, String processName, int flags, String exception, String message, String file, int line) {
        EventLog.writeEvent((int)30039, (Object[])new Object[]{pid, processName, flags, exception, message, file, line});
    }

    public static void writeAmWtf(int pid, String processName, int flags, String tag, String message) {
        EventLog.writeEvent((int)30040, (Object[])new Object[]{pid, processName, flags, tag, message});
    }
}

