/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Intent;
import android.os.IBinder;
import com.android.server.am.AppBindRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ServiceRecord;
import java.io.PrintWriter;
import java.util.HashMap;

class IntentBindRecord {
    final ServiceRecord service;
    final Intent.FilterComparison intent;
    final HashMap<ProcessRecord, AppBindRecord> apps = new HashMap();
    IBinder binder;
    boolean requested;
    boolean received;
    boolean hasBound;
    boolean doRebind;
    String stringName;

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("service=");
        pw.println((Object)this.service);
        this.dumpInService(pw, prefix);
    }

    void dumpInService(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("intent={");
        pw.print(this.intent.getIntent().toShortString(false, true, false));
        pw.println('}');
        pw.print(prefix);
        pw.print("binder=");
        pw.println(this.binder);
        pw.print(prefix);
        pw.print("requested=");
        pw.print(this.requested);
        pw.print(" received=");
        pw.print(this.received);
        pw.print(" hasBound=");
        pw.print(this.hasBound);
        pw.print(" doRebind=");
        pw.println(this.doRebind);
        if (this.apps.size() > 0) {
            for (AppBindRecord a : this.apps.values()) {
                pw.print(prefix);
                pw.print("* Client AppBindRecord{");
                pw.print(Integer.toHexString(System.identityHashCode(a)));
                pw.print(' ');
                pw.print(a.client);
                pw.println('}');
                a.dumpInIntentBind(pw, prefix + "  ");
            }
        }
    }

    IntentBindRecord(ServiceRecord _service, Intent.FilterComparison _intent) {
        this.service = _service;
        this.intent = _intent;
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("IntentBindRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        sb.append(this.service.shortName);
        sb.append(':');
        if (this.intent != null) {
            this.intent.getIntent().toShortString(sb, false, false, false);
        }
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }
}

