/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.graphics.Point;
import android.util.Slog;
import com.android.internal.util.MemInfoReader;
import com.android.server.wm.WindowManagerService;
import java.io.FileOutputStream;
import java.io.IOException;

class ProcessList {
    static final int MIN_CRASH_INTERVAL = 60000;
    static final int HIDDEN_APP_MAX_ADJ = 15;
    static int HIDDEN_APP_MIN_ADJ = 9;
    static final int SERVICE_B_ADJ = 8;
    static final int PREVIOUS_APP_ADJ = 7;
    static final int HOME_APP_ADJ = 6;
    static final int SERVICE_ADJ = 5;
    static final int BACKUP_APP_ADJ = 4;
    static final int HEAVY_WEIGHT_APP_ADJ = 3;
    static final int PERCEPTIBLE_APP_ADJ = 2;
    static final int VISIBLE_APP_ADJ = 1;
    static final int FOREGROUND_APP_ADJ = 0;
    static final int PERSISTENT_PROC_ADJ = -12;
    static final int SYSTEM_ADJ = -16;
    static final int PAGE_SIZE = 4096;
    static final int MIN_HIDDEN_APPS = 2;
    static final int MAX_HIDDEN_APPS = 15;
    static final long CONTENT_APP_IDLE_OFFSET = 15000L;
    static final long EMPTY_APP_IDLE_OFFSET = 120000L;
    private final int[] mOomAdj = new int[]{0, 1, 2, 4, HIDDEN_APP_MIN_ADJ, 15};
    private final long[] mOomMinFreeLow = new long[]{8192L, 12288L, 16384L, 24576L, 28672L, 32768L};
    private final long[] mOomMinFreeHigh = new long[]{32768L, 40960L, 49152L, 57344L, 65536L, 81920L};
    private final long[] mOomMinFree = new long[this.mOomAdj.length];
    private final long mTotalMemMb;
    private boolean mHaveDisplaySize;

    ProcessList() {
        MemInfoReader minfo = new MemInfoReader();
        minfo.readMemInfo();
        this.mTotalMemMb = minfo.getTotalSize() / 0x100000L;
        this.updateOomLevels(0, 0, false);
    }

    void applyDisplaySize(WindowManagerService wm) {
        if (!this.mHaveDisplaySize) {
            Point p = new Point();
            wm.getInitialDisplaySize(p);
            if (p.x != 0 && p.y != 0) {
                this.updateOomLevels(p.x, p.y, true);
                this.mHaveDisplaySize = true;
            }
        }
    }

    private void updateOomLevels(int displayWidth, int displayHeight, boolean write) {
        float scale;
        float scaleMem = (float)(this.mTotalMemMb - 300L) / 400.0f;
        int minSize = 153600;
        int maxSize = 1024000;
        float scaleDisp = ((float)(displayWidth * displayHeight) - (float)minSize) / (float)(maxSize - minSize);
        StringBuilder adjString = new StringBuilder();
        StringBuilder memString = new StringBuilder();
        float f = scale = scaleMem > scaleDisp ? scaleMem : scaleDisp;
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 1.0f) {
            scale = 1.0f;
        }
        for (int i = 0; i < this.mOomAdj.length; ++i) {
            long low = this.mOomMinFreeLow[i];
            long high = this.mOomMinFreeHigh[i];
            this.mOomMinFree[i] = (long)((float)low + (float)(high - low) * scale);
            if (i > 0) {
                adjString.append(',');
                memString.append(',');
            }
            adjString.append(this.mOomAdj[i]);
            memString.append(this.mOomMinFree[i] * 1024L / 4096L);
        }
        if (write) {
            this.writeFile("/sys/module/lowmemorykiller/parameters/adj", adjString.toString());
            this.writeFile("/sys/module/lowmemorykiller/parameters/minfree", memString.toString());
        }
    }

    long getMemLevel(int adjustment) {
        for (int i = 0; i < this.mOomAdj.length; ++i) {
            if (adjustment > this.mOomAdj[i]) continue;
            return this.mOomMinFree[i] * 1024L;
        }
        return this.mOomMinFree[this.mOomAdj.length - 1] * 1024L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String path, String data) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(data.getBytes());
        }
        catch (IOException e) {
            Slog.w((String)"ActivityManager", (String)("Unable to write " + path));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

