/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.Dialog;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.content.res.CompatibilityInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.PrintWriterPrinter;
import android.util.Printer;
import android.util.TimeUtils;
import com.android.internal.os.BatteryStatsImpl;
import com.android.server.am.ActivityRecord;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.ProcessList;
import com.android.server.am.ReceiverList;
import com.android.server.am.ServiceRecord;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

class ProcessRecord {
    final BatteryStatsImpl.Uid.Proc batteryStats;
    final ApplicationInfo info;
    final String processName;
    final HashSet<String> pkgList = new HashSet();
    IApplicationThread thread;
    int pid;
    boolean starting;
    long lastActivityTime;
    long lruWeight;
    int maxAdj;
    int hiddenAdj;
    int curRawAdj;
    int setRawAdj;
    int curAdj;
    int setAdj;
    int curSchedGroup;
    int setSchedGroup;
    int trimMemoryLevel;
    boolean serviceb;
    boolean keeping;
    boolean setIsForeground;
    boolean foregroundServices;
    boolean foregroundActivities;
    boolean systemNoUi;
    boolean hasShownUi;
    boolean pendingUiClean;
    boolean hasAboveClient;
    boolean bad;
    boolean killedBackground;
    String waitingToKill;
    IBinder forcingToForeground;
    int adjSeq;
    int lruSeq;
    CompatibilityInfo compat;
    IBinder.DeathRecipient deathRecipient;
    ComponentName instrumentationClass;
    ApplicationInfo instrumentationInfo;
    String instrumentationProfileFile;
    IInstrumentationWatcher instrumentationWatcher;
    Bundle instrumentationArguments;
    ComponentName instrumentationResultClass;
    boolean usingWrapper;
    BroadcastRecord curReceiver;
    long lastWakeTime;
    long lastCpuTime;
    long curCpuTime;
    long lastRequestedGc;
    long lastLowMemory;
    boolean reportLowMemory;
    boolean empty;
    boolean hidden;
    int lastPss;
    String adjType;
    int adjTypeCode;
    Object adjSource;
    int adjSourceOom;
    Object adjTarget;
    final ArrayList<ActivityRecord> activities = new ArrayList();
    final HashSet<ServiceRecord> services = new HashSet();
    final HashSet<ServiceRecord> executingServices = new HashSet();
    final HashSet<ConnectionRecord> connections = new HashSet();
    final HashSet<ReceiverList> receivers = new HashSet();
    final HashMap<String, ContentProviderRecord> pubProviders = new HashMap();
    final HashMap<ContentProviderRecord, Integer> conProviders = new HashMap();
    boolean persistent;
    boolean crashing;
    Dialog crashDialog;
    boolean notResponding;
    Dialog anrDialog;
    boolean removed;
    boolean debugging;
    boolean waitedForDebugger;
    Dialog waitDialog;
    String shortStringName;
    String stringName;
    ActivityManager.ProcessErrorStateInfo crashingReport;
    ActivityManager.ProcessErrorStateInfo notRespondingReport;
    ComponentName errorReportReceiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(PrintWriter pw, String prefix) {
        long now = SystemClock.uptimeMillis();
        if (this.info.className != null) {
            pw.print(prefix);
            pw.print("class=");
            pw.println(this.info.className);
        }
        if (this.info.manageSpaceActivityName != null) {
            pw.print(prefix);
            pw.print("manageSpaceActivityName=");
            pw.println(this.info.manageSpaceActivityName);
        }
        pw.print(prefix);
        pw.print("dir=");
        pw.print(this.info.sourceDir);
        pw.print(" publicDir=");
        pw.print(this.info.publicSourceDir);
        pw.print(" data=");
        pw.println(this.info.dataDir);
        pw.print(prefix);
        pw.print("packageList=");
        pw.println(this.pkgList);
        pw.print(prefix);
        pw.print("compat=");
        pw.println(this.compat);
        if (this.instrumentationClass != null || this.instrumentationProfileFile != null || this.instrumentationArguments != null) {
            pw.print(prefix);
            pw.print("instrumentationClass=");
            pw.print(this.instrumentationClass);
            pw.print(" instrumentationProfileFile=");
            pw.println(this.instrumentationProfileFile);
            pw.print(prefix);
            pw.print("instrumentationArguments=");
            pw.println(this.instrumentationArguments);
            pw.print(prefix);
            pw.print("instrumentationInfo=");
            pw.println(this.instrumentationInfo);
            if (this.instrumentationInfo != null) {
                this.instrumentationInfo.dump((Printer)new PrintWriterPrinter(pw), prefix + "  ");
            }
        }
        pw.print(prefix);
        pw.print("thread=");
        pw.print(this.thread);
        pw.print(" curReceiver=");
        pw.println((Object)this.curReceiver);
        pw.print(prefix);
        pw.print("pid=");
        pw.print(this.pid);
        pw.print(" starting=");
        pw.print(this.starting);
        pw.print(" lastPss=");
        pw.println(this.lastPss);
        pw.print(prefix);
        pw.print("lastActivityTime=");
        TimeUtils.formatDuration((long)this.lastActivityTime, (long)now, (PrintWriter)pw);
        pw.print(" lruWeight=");
        pw.print(this.lruWeight);
        pw.print(" serviceb=");
        pw.print(this.serviceb);
        pw.print(" keeping=");
        pw.print(this.keeping);
        pw.print(" hidden=");
        pw.print(this.hidden);
        pw.print(" empty=");
        pw.println(this.empty);
        pw.print(prefix);
        pw.print("oom: max=");
        pw.print(this.maxAdj);
        pw.print(" hidden=");
        pw.print(this.hiddenAdj);
        pw.print(" curRaw=");
        pw.print(this.curRawAdj);
        pw.print(" setRaw=");
        pw.print(this.setRawAdj);
        pw.print(" cur=");
        pw.print(this.curAdj);
        pw.print(" set=");
        pw.println(this.setAdj);
        pw.print(prefix);
        pw.print("curSchedGroup=");
        pw.print(this.curSchedGroup);
        pw.print(" setSchedGroup=");
        pw.print(this.setSchedGroup);
        pw.print(" systemNoUi=");
        pw.print(this.systemNoUi);
        pw.print(" trimMemoryLevel=");
        pw.println(this.trimMemoryLevel);
        pw.print(prefix);
        pw.print("hasShownUi=");
        pw.print(this.hasShownUi);
        pw.print(" pendingUiClean=");
        pw.print(this.pendingUiClean);
        pw.print(" hasAboveClient=");
        pw.println(this.hasAboveClient);
        pw.print(prefix);
        pw.print("setIsForeground=");
        pw.print(this.setIsForeground);
        pw.print(" foregroundServices=");
        pw.print(this.foregroundServices);
        pw.print(" forcingToForeground=");
        pw.println(this.forcingToForeground);
        pw.print(prefix);
        pw.print("persistent=");
        pw.print(this.persistent);
        pw.print(" removed=");
        pw.println(this.removed);
        pw.print(prefix);
        pw.print("adjSeq=");
        pw.print(this.adjSeq);
        pw.print(" lruSeq=");
        pw.println(this.lruSeq);
        if (!this.keeping) {
            long wtime;
            BatteryStatsImpl batteryStatsImpl = this.batteryStats.getBatteryStats();
            synchronized (batteryStatsImpl) {
                wtime = this.batteryStats.getBatteryStats().getProcessWakeTime(this.info.uid, this.pid, SystemClock.elapsedRealtime());
            }
            long timeUsed = wtime - this.lastWakeTime;
            pw.print(prefix);
            pw.print("lastWakeTime=");
            pw.print(this.lastWakeTime);
            pw.print(" time used=");
            TimeUtils.formatDuration((long)timeUsed, (PrintWriter)pw);
            pw.println("");
            pw.print(prefix);
            pw.print("lastCpuTime=");
            pw.print(this.lastCpuTime);
            pw.print(" time used=");
            TimeUtils.formatDuration((long)(this.curCpuTime - this.lastCpuTime), (PrintWriter)pw);
            pw.println("");
        }
        pw.print(prefix);
        pw.print("lastRequestedGc=");
        TimeUtils.formatDuration((long)this.lastRequestedGc, (long)now, (PrintWriter)pw);
        pw.print(" lastLowMemory=");
        TimeUtils.formatDuration((long)this.lastLowMemory, (long)now, (PrintWriter)pw);
        pw.print(" reportLowMemory=");
        pw.println(this.reportLowMemory);
        if (this.killedBackground || this.waitingToKill != null) {
            pw.print(prefix);
            pw.print("killedBackground=");
            pw.print(this.killedBackground);
            pw.print(" waitingToKill=");
            pw.println(this.waitingToKill);
        }
        if (this.debugging || this.crashing || this.crashDialog != null || this.notResponding || this.anrDialog != null || this.bad) {
            pw.print(prefix);
            pw.print("debugging=");
            pw.print(this.debugging);
            pw.print(" crashing=");
            pw.print(this.crashing);
            pw.print(" ");
            pw.print(this.crashDialog);
            pw.print(" notResponding=");
            pw.print(this.notResponding);
            pw.print(" ");
            pw.print(this.anrDialog);
            pw.print(" bad=");
            pw.print(this.bad);
            if (this.errorReportReceiver != null) {
                pw.print(" errorReportReceiver=");
                pw.print(this.errorReportReceiver.flattenToShortString());
            }
            pw.println();
        }
        if (this.activities.size() > 0) {
            pw.print(prefix);
            pw.print("activities=");
            pw.println(this.activities);
        }
        if (this.services.size() > 0) {
            pw.print(prefix);
            pw.print("services=");
            pw.println(this.services);
        }
        if (this.executingServices.size() > 0) {
            pw.print(prefix);
            pw.print("executingServices=");
            pw.println(this.executingServices);
        }
        if (this.connections.size() > 0) {
            pw.print(prefix);
            pw.print("connections=");
            pw.println(this.connections);
        }
        if (this.pubProviders.size() > 0) {
            pw.print(prefix);
            pw.print("pubProviders=");
            pw.println(this.pubProviders);
        }
        if (this.conProviders.size() > 0) {
            pw.print(prefix);
            pw.print("conProviders=");
            pw.println(this.conProviders);
        }
        if (this.receivers.size() > 0) {
            pw.print(prefix);
            pw.print("receivers=");
            pw.println(this.receivers);
        }
    }

    ProcessRecord(BatteryStatsImpl.Uid.Proc _batteryStats, IApplicationThread _thread, ApplicationInfo _info, String _processName) {
        this.batteryStats = _batteryStats;
        this.info = _info;
        this.processName = _processName;
        this.pkgList.add(_info.packageName);
        this.thread = _thread;
        this.maxAdj = 15;
        this.hiddenAdj = ProcessList.HIDDEN_APP_MIN_ADJ;
        this.setRawAdj = -100;
        this.curRawAdj = -100;
        this.setAdj = -100;
        this.curAdj = -100;
        this.persistent = false;
        this.removed = false;
    }

    public void setPid(int _pid) {
        this.pid = _pid;
        this.shortStringName = null;
        this.stringName = null;
    }

    public boolean isInterestingToUserLocked() {
        int size = this.activities.size();
        for (int i = 0; i < size; ++i) {
            ActivityRecord r = this.activities.get(i);
            if (!r.isInterestingToUserLocked()) continue;
            return true;
        }
        return false;
    }

    public void stopFreezingAllLocked() {
        int i = this.activities.size();
        while (i > 0) {
            this.activities.get(--i).stopFreezingScreenLocked(true);
        }
    }

    public void unlinkDeathRecipient() {
        if (this.deathRecipient != null && this.thread != null) {
            this.thread.asBinder().unlinkToDeath(this.deathRecipient, 0);
        }
        this.deathRecipient = null;
    }

    void updateHasAboveClientLocked() {
        this.hasAboveClient = false;
        if (this.connections.size() > 0) {
            for (ConnectionRecord cr : this.connections) {
                if ((cr.flags & 8) == 0) continue;
                this.hasAboveClient = true;
                break;
            }
        }
    }

    public String toShortString() {
        if (this.shortStringName != null) {
            return this.shortStringName;
        }
        StringBuilder sb = new StringBuilder(128);
        this.toShortString(sb);
        this.shortStringName = sb.toString();
        return this.shortStringName;
    }

    void toShortString(StringBuilder sb) {
        sb.append(this.pid);
        sb.append(':');
        sb.append(this.processName);
        sb.append('/');
        sb.append(this.info.uid);
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ProcessRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        this.toShortString(sb);
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    public boolean addPackage(String pkg) {
        if (!this.pkgList.contains(pkg)) {
            this.pkgList.add(pkg);
            return true;
        }
        return false;
    }

    public void resetPackageList() {
        this.pkgList.clear();
        this.pkgList.add(this.info.packageName);
    }

    public String[] getPackageList() {
        int size = this.pkgList.size();
        if (size == 0) {
            return null;
        }
        String[] list = new String[size];
        this.pkgList.toArray(list);
        return list;
    }
}

