/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.os.BatteryStatsImpl;
import com.android.server.NotificationManagerService;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.AppBindRecord;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.IntentBindRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.UriPermissionOwner;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceRecord
extends Binder {
    static final int MAX_DELIVERY_COUNT = 3;
    static final int MAX_DONE_EXECUTING_COUNT = 6;
    final ActivityManagerService ams;
    final BatteryStatsImpl.Uid.Pkg.Serv stats;
    final ComponentName name;
    final String shortName;
    final Intent.FilterComparison intent;
    final ServiceInfo serviceInfo;
    final ApplicationInfo appInfo;
    final String packageName;
    final String processName;
    final String permission;
    final String baseDir;
    final String resDir;
    final String dataDir;
    final boolean exported;
    final Runnable restarter;
    final long createTime;
    final HashMap<Intent.FilterComparison, IntentBindRecord> bindings = new HashMap();
    final HashMap<IBinder, ArrayList<ConnectionRecord>> connections = new HashMap();
    ProcessRecord app;
    boolean isForeground;
    int foregroundId;
    Notification foregroundNoti;
    long lastActivity;
    boolean startRequested;
    boolean stopIfKilled;
    boolean callStart;
    int executeNesting;
    long executingStart;
    int crashCount;
    int totalRestartCount;
    int restartCount;
    long restartDelay;
    long restartTime;
    long nextRestartTime;
    String stringName;
    private int lastStartId;
    final ArrayList<StartItem> deliveredStarts = new ArrayList();
    final ArrayList<StartItem> pendingStarts = new ArrayList();

    void dumpStartList(PrintWriter pw, String prefix, List<StartItem> list, long now) {
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            StartItem si = list.get(i);
            pw.print(prefix);
            pw.print("#");
            pw.print(i);
            pw.print(" id=");
            pw.print(si.id);
            if (now != 0L) {
                pw.print(" dur=");
                TimeUtils.formatDuration((long)si.deliveredTime, (long)now, (PrintWriter)pw);
            }
            if (si.deliveryCount != 0) {
                pw.print(" dc=");
                pw.print(si.deliveryCount);
            }
            if (si.doneExecutingCount != 0) {
                pw.print(" dxc=");
                pw.print(si.doneExecutingCount);
            }
            pw.println("");
            pw.print(prefix);
            pw.print("  intent=");
            if (si.intent != null) {
                pw.println(si.intent.toString());
            } else {
                pw.println("null");
            }
            if (si.targetPermissionUid >= 0) {
                pw.print(prefix);
                pw.print("  targetPermissionUid=");
                pw.println(si.targetPermissionUid);
            }
            if (si.uriPermissions == null) continue;
            if (si.uriPermissions.readUriPermissions != null) {
                pw.print(prefix);
                pw.print("  readUriPermissions=");
                pw.println(si.uriPermissions.readUriPermissions);
            }
            if (si.uriPermissions.writeUriPermissions == null) continue;
            pw.print(prefix);
            pw.print("  writeUriPermissions=");
            pw.println(si.uriPermissions.writeUriPermissions);
        }
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("intent={");
        pw.print(this.intent.getIntent().toShortString(false, true, false));
        pw.println('}');
        pw.print(prefix);
        pw.print("packageName=");
        pw.println(this.packageName);
        pw.print(prefix);
        pw.print("processName=");
        pw.println(this.processName);
        if (this.permission != null) {
            pw.print(prefix);
            pw.print("permission=");
            pw.println(this.permission);
        }
        long now = SystemClock.uptimeMillis();
        long nowReal = SystemClock.elapsedRealtime();
        pw.print(prefix);
        pw.print("baseDir=");
        pw.println(this.baseDir);
        if (!this.resDir.equals(this.baseDir)) {
            pw.print(prefix);
            pw.print("resDir=");
            pw.println(this.resDir);
        }
        pw.print(prefix);
        pw.print("dataDir=");
        pw.println(this.dataDir);
        pw.print(prefix);
        pw.print("app=");
        pw.println(this.app);
        if (this.isForeground || this.foregroundId != 0) {
            pw.print(prefix);
            pw.print("isForeground=");
            pw.print(this.isForeground);
            pw.print(" foregroundId=");
            pw.print(this.foregroundId);
            pw.print(" foregroundNoti=");
            pw.println(this.foregroundNoti);
        }
        pw.print(prefix);
        pw.print("createTime=");
        TimeUtils.formatDuration((long)this.createTime, (long)nowReal, (PrintWriter)pw);
        pw.print(" lastActivity=");
        TimeUtils.formatDuration((long)this.lastActivity, (long)now, (PrintWriter)pw);
        pw.println("");
        pw.print(prefix);
        pw.print("executingStart=");
        TimeUtils.formatDuration((long)this.executingStart, (long)now, (PrintWriter)pw);
        pw.print(" restartTime=");
        TimeUtils.formatDuration((long)this.restartTime, (long)now, (PrintWriter)pw);
        pw.println("");
        if (this.startRequested || this.lastStartId != 0) {
            pw.print(prefix);
            pw.print("startRequested=");
            pw.print(this.startRequested);
            pw.print(" stopIfKilled=");
            pw.print(this.stopIfKilled);
            pw.print(" callStart=");
            pw.print(this.callStart);
            pw.print(" lastStartId=");
            pw.println(this.lastStartId);
        }
        if (this.executeNesting != 0 || this.crashCount != 0 || this.restartCount != 0 || this.restartDelay != 0L || this.nextRestartTime != 0L) {
            pw.print(prefix);
            pw.print("executeNesting=");
            pw.print(this.executeNesting);
            pw.print(" restartCount=");
            pw.print(this.restartCount);
            pw.print(" restartDelay=");
            TimeUtils.formatDuration((long)this.restartDelay, (long)now, (PrintWriter)pw);
            pw.print(" nextRestartTime=");
            TimeUtils.formatDuration((long)this.nextRestartTime, (long)now, (PrintWriter)pw);
            pw.print(" crashCount=");
            pw.println(this.crashCount);
        }
        if (this.deliveredStarts.size() > 0) {
            pw.print(prefix);
            pw.println("Delivered Starts:");
            this.dumpStartList(pw, prefix, this.deliveredStarts, now);
        }
        if (this.pendingStarts.size() > 0) {
            pw.print(prefix);
            pw.println("Pending Starts:");
            this.dumpStartList(pw, prefix, this.pendingStarts, 0L);
        }
        if (this.bindings.size() > 0) {
            Iterator<Object> it = this.bindings.values().iterator();
            pw.print(prefix);
            pw.println("Bindings:");
            while (it.hasNext()) {
                IntentBindRecord intentBindRecord = it.next();
                pw.print(prefix);
                pw.print("* IntentBindRecord{");
                pw.print(Integer.toHexString(System.identityHashCode(intentBindRecord)));
                pw.println("}:");
                intentBindRecord.dumpInService(pw, prefix + "  ");
            }
        }
        if (this.connections.size() > 0) {
            pw.print(prefix);
            pw.println("All Connections:");
            for (ArrayList arrayList : this.connections.values()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(arrayList.get(i));
                }
            }
        }
    }

    ServiceRecord(ActivityManagerService ams, BatteryStatsImpl.Uid.Pkg.Serv servStats, ComponentName name, Intent.FilterComparison intent, ServiceInfo sInfo, Runnable restarter) {
        this.ams = ams;
        this.stats = servStats;
        this.name = name;
        this.shortName = name.flattenToShortString();
        this.intent = intent;
        this.serviceInfo = sInfo;
        this.appInfo = sInfo.applicationInfo;
        this.packageName = sInfo.applicationInfo.packageName;
        this.processName = sInfo.processName;
        this.permission = sInfo.permission;
        this.baseDir = sInfo.applicationInfo.sourceDir;
        this.resDir = sInfo.applicationInfo.publicSourceDir;
        this.dataDir = sInfo.applicationInfo.dataDir;
        this.exported = sInfo.exported;
        this.restarter = restarter;
        this.createTime = SystemClock.elapsedRealtime();
        this.lastActivity = SystemClock.uptimeMillis();
    }

    public AppBindRecord retrieveAppBindingLocked(Intent intent, ProcessRecord app) {
        AppBindRecord a;
        Intent.FilterComparison filter = new Intent.FilterComparison(intent);
        IntentBindRecord i = this.bindings.get(filter);
        if (i == null) {
            i = new IntentBindRecord(this, filter);
            this.bindings.put(filter, i);
        }
        if ((a = i.apps.get(app)) != null) {
            return a;
        }
        a = new AppBindRecord(this, i, app);
        i.apps.put(app, a);
        return a;
    }

    public void resetRestartCounter() {
        this.restartCount = 0;
        this.restartDelay = 0L;
        this.restartTime = 0L;
    }

    public StartItem findDeliveredStart(int id, boolean remove) {
        int N = this.deliveredStarts.size();
        for (int i = 0; i < N; ++i) {
            StartItem si = this.deliveredStarts.get(i);
            if (si.id != id) continue;
            if (remove) {
                this.deliveredStarts.remove(i);
            }
            return si;
        }
        return null;
    }

    public int getLastStartId() {
        return this.lastStartId;
    }

    public int makeNextStartId() {
        ++this.lastStartId;
        if (this.lastStartId < 1) {
            this.lastStartId = 1;
        }
        return this.lastStartId;
    }

    public void postNotification() {
        final int appUid = this.appInfo.uid;
        final int appPid = this.app.pid;
        if (this.foregroundId != 0 && this.foregroundNoti != null) {
            final String localPackageName = this.packageName;
            final int localForegroundId = this.foregroundId;
            final Notification localForegroundNoti = this.foregroundNoti;
            this.ams.mHandler.post(new Runnable(){

                public void run() {
                    NotificationManagerService nm = (NotificationManagerService)NotificationManager.getService();
                    if (nm == null) {
                        return;
                    }
                    try {
                        int[] outId = new int[1];
                        nm.enqueueNotificationInternal(localPackageName, appUid, appPid, null, localForegroundId, localForegroundNoti, outId);
                    }
                    catch (RuntimeException e) {
                        Slog.w((String)"ActivityManager", (String)"Error showing notification for service", (Throwable)e);
                        ServiceRecord.this.ams.setServiceForeground(ServiceRecord.this.name, (IBinder)ServiceRecord.this, 0, null, true);
                        ServiceRecord.this.ams.crashApplication(appUid, appPid, localPackageName, "Bad notification for startForeground: " + e);
                    }
                }
            });
        }
    }

    public void cancelNotification() {
        if (this.foregroundId != 0) {
            final String localPackageName = this.packageName;
            final int localForegroundId = this.foregroundId;
            this.ams.mHandler.post(new Runnable(){

                public void run() {
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    try {
                        inm.cancelNotification(localPackageName, localForegroundId);
                    }
                    catch (RuntimeException e) {
                        Slog.w((String)"ActivityManager", (String)"Error canceling notification for service", (Throwable)e);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void clearDeliveredStartsLocked() {
        for (int i = this.deliveredStarts.size() - 1; i >= 0; --i) {
            this.deliveredStarts.get(i).removeUriPermissionsLocked();
        }
        this.deliveredStarts.clear();
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ServiceRecord{").append(Integer.toHexString(System.identityHashCode((Object)this))).append(' ').append(this.shortName).append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    static class StartItem {
        final ServiceRecord sr;
        final boolean taskRemoved;
        final int id;
        final Intent intent;
        final int targetPermissionUid;
        long deliveredTime;
        int deliveryCount;
        int doneExecutingCount;
        UriPermissionOwner uriPermissions;
        String stringName;

        StartItem(ServiceRecord _sr, boolean _taskRemoved, int _id, Intent _intent, int _targetPermissionUid) {
            this.sr = _sr;
            this.taskRemoved = _taskRemoved;
            this.id = _id;
            this.intent = _intent;
            this.targetPermissionUid = _targetPermissionUid;
        }

        UriPermissionOwner getUriPermissionsLocked() {
            if (this.uriPermissions == null) {
                this.uriPermissions = new UriPermissionOwner(this.sr.ams, this);
            }
            return this.uriPermissions;
        }

        void removeUriPermissionsLocked() {
            if (this.uriPermissions != null) {
                this.uriPermissions.removeUriPermissionsLocked();
                this.uriPermissions = null;
            }
        }

        public String toString() {
            if (this.stringName != null) {
                return this.stringName;
            }
            StringBuilder sb = new StringBuilder(128);
            sb.append("ServiceRecord{").append(Integer.toHexString(System.identityHashCode((Object)this.sr))).append(' ').append(this.sr.shortName).append(" StartItem ").append(Integer.toHexString(System.identityHashCode(this))).append(" id=").append(this.id).append('}');
            this.stringName = sb.toString();
            return this.stringName;
        }
    }
}

