/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import com.android.server.am.AppErrorResult;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.ProcessRecord;

class StrictModeViolationDialog
extends BaseErrorDialog {
    private static final String TAG = "StrictModeViolationDialog";
    private final AppErrorResult mResult;
    private final ProcessRecord mProc;
    static final int ACTION_OK = 0;
    static final int ACTION_OK_AND_REPORT = 1;
    static final long DISMISS_TIMEOUT = 60000L;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            ProcessRecord processRecord = StrictModeViolationDialog.this.mProc;
            synchronized (processRecord) {
                if (StrictModeViolationDialog.this.mProc != null && ((StrictModeViolationDialog)StrictModeViolationDialog.this).mProc.crashDialog == StrictModeViolationDialog.this) {
                    ((StrictModeViolationDialog)StrictModeViolationDialog.this).mProc.crashDialog = null;
                }
            }
            StrictModeViolationDialog.this.mResult.set(msg.what);
            StrictModeViolationDialog.this.dismiss();
        }
    };

    public StrictModeViolationDialog(Context context, AppErrorResult result, ProcessRecord app) {
        super(context);
        CharSequence name;
        Resources res = context.getResources();
        this.mProc = app;
        this.mResult = result;
        if (app.pkgList.size() == 1 && (name = context.getPackageManager().getApplicationLabel(app.info)) != null) {
            this.setMessage(res.getString(17040310, new Object[]{name.toString(), app.info.processName}));
        } else {
            name = app.processName;
            this.setMessage(res.getString(17040311, new Object[]{name.toString()}));
        }
        this.setCancelable(false);
        this.setButton(-1, res.getText(17040393), this.mHandler.obtainMessage(0));
        if (app.errorReportReceiver != null) {
            this.setButton(-2, res.getText(17040302), this.mHandler.obtainMessage(1));
        }
        this.setTitle(res.getText(17040293));
        this.getWindow().addFlags(0x40000000);
        this.getWindow().setTitle((CharSequence)("Strict Mode Violation: " + app.info.processName));
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(0), 60000L);
    }
}

