/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.SystemClock;
import com.android.server.am.ThumbnailHolder;
import java.io.PrintWriter;

class TaskRecord
extends ThumbnailHolder {
    final int taskId;
    final String affinity;
    Intent intent;
    Intent affinityIntent;
    ComponentName origActivity;
    ComponentName realActivity;
    int numActivities;
    long lastActiveTime;
    boolean rootWasReset;
    boolean askedCompatMode;
    String stringName;

    TaskRecord(int _taskId, ActivityInfo info, Intent _intent) {
        this.taskId = _taskId;
        this.affinity = info.taskAffinity;
        this.setIntent(_intent, info);
    }

    void touchActiveTime() {
        this.lastActiveTime = SystemClock.elapsedRealtime();
    }

    long getInactiveDuration() {
        return SystemClock.elapsedRealtime() - this.lastActiveTime;
    }

    void setIntent(Intent _intent, ActivityInfo info) {
        this.stringName = null;
        if (info.targetActivity == null) {
            if (_intent != null && _intent.getSelector() != null) {
                _intent = new Intent(_intent);
                _intent.setSelector(null);
            }
            this.intent = _intent;
            this.realActivity = _intent != null ? _intent.getComponent() : null;
            this.origActivity = null;
        } else {
            ComponentName targetComponent = new ComponentName(info.packageName, info.targetActivity);
            if (_intent != null) {
                Intent targetIntent = new Intent(_intent);
                targetIntent.setComponent(targetComponent);
                targetIntent.setSelector(null);
                this.intent = targetIntent;
                this.realActivity = targetComponent;
                this.origActivity = _intent.getComponent();
            } else {
                this.intent = null;
                this.realActivity = targetComponent;
                this.origActivity = new ComponentName(info.packageName, info.name);
            }
        }
        if (this.intent != null && (this.intent.getFlags() & 0x200000) != 0) {
            this.rootWasReset = true;
        }
    }

    void dump(PrintWriter pw, String prefix) {
        StringBuilder sb;
        if (this.numActivities != 0 || this.rootWasReset) {
            pw.print(prefix);
            pw.print("numActivities=");
            pw.print(this.numActivities);
            pw.print(" rootWasReset=");
            pw.println(this.rootWasReset);
        }
        if (this.affinity != null) {
            pw.print(prefix);
            pw.print("affinity=");
            pw.println(this.affinity);
        }
        if (this.intent != null) {
            sb = new StringBuilder(128);
            sb.append(prefix);
            sb.append("intent={");
            this.intent.toShortString(sb, false, true, false);
            sb.append('}');
            pw.println(sb.toString());
        }
        if (this.affinityIntent != null) {
            sb = new StringBuilder(128);
            sb.append(prefix);
            sb.append("affinityIntent={");
            this.affinityIntent.toShortString(sb, false, true, false);
            sb.append('}');
            pw.println(sb.toString());
        }
        if (this.origActivity != null) {
            pw.print(prefix);
            pw.print("origActivity=");
            pw.println(this.origActivity.flattenToShortString());
        }
        if (this.realActivity != null) {
            pw.print(prefix);
            pw.print("realActivity=");
            pw.println(this.realActivity.flattenToShortString());
        }
        if (!this.askedCompatMode) {
            pw.print(prefix);
            pw.print("askedCompatMode=");
            pw.println(this.askedCompatMode);
        }
        pw.print(prefix);
        pw.print("lastThumbnail=");
        pw.print(this.lastThumbnail);
        pw.print(" lastDescription=");
        pw.println(this.lastDescription);
        pw.print(prefix);
        pw.print("lastActiveTime=");
        pw.print(this.lastActiveTime);
        pw.print(" (inactive for ");
        pw.print(this.getInactiveDuration() / 1000L);
        pw.println("s)");
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("TaskRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" #");
        sb.append(this.taskId);
        if (this.affinity != null) {
            sb.append(" A ");
            sb.append(this.affinity);
        } else if (this.intent != null) {
            sb.append(" I ");
            sb.append(this.intent.getComponent().flattenToShortString());
        } else if (this.affinityIntent != null) {
            sb.append(" aI ");
            sb.append(this.affinityIntent.getComponent().flattenToShortString());
        } else {
            sb.append(" ??");
        }
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }
}

