/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.net.Uri;
import com.android.server.am.UriPermissionOwner;
import java.io.PrintWriter;
import java.util.HashSet;

class UriPermission {
    final int uid;
    final Uri uri;
    int modeFlags = 0;
    int globalModeFlags = 0;
    final HashSet<UriPermissionOwner> readOwners = new HashSet();
    final HashSet<UriPermissionOwner> writeOwners = new HashSet();
    String stringName;

    UriPermission(int _uid, Uri _uri) {
        this.uid = _uid;
        this.uri = _uri;
    }

    void clearModes(int modeFlagsToClear) {
        if ((modeFlagsToClear & 1) != 0) {
            this.globalModeFlags &= 0xFFFFFFFE;
            this.modeFlags &= 0xFFFFFFFE;
            if (this.readOwners.size() > 0) {
                for (UriPermissionOwner r : this.readOwners) {
                    r.removeReadPermission(this);
                }
                this.readOwners.clear();
            }
        }
        if ((modeFlagsToClear & 2) != 0) {
            this.globalModeFlags &= 0xFFFFFFFD;
            this.modeFlags &= 0xFFFFFFFD;
            if (this.readOwners.size() > 0) {
                for (UriPermissionOwner r : this.writeOwners) {
                    r.removeWritePermission(this);
                }
                this.readOwners.clear();
            }
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("UriPermission{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        sb.append(this.uri);
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("modeFlags=0x");
        pw.print(Integer.toHexString(this.modeFlags));
        pw.print(" uid=");
        pw.print(this.uid);
        pw.print(" globalModeFlags=0x");
        pw.println(Integer.toHexString(this.globalModeFlags));
        if (this.readOwners.size() != 0) {
            pw.print(prefix);
            pw.println("readOwners:");
            for (UriPermissionOwner owner : this.readOwners) {
                pw.print(prefix);
                pw.print("  * ");
                pw.println(owner);
            }
        }
        if (this.writeOwners.size() != 0) {
            pw.print(prefix);
            pw.println("writeOwners:");
            for (UriPermissionOwner owner : this.writeOwners) {
                pw.print(prefix);
                pw.print("  * ");
                pw.println(owner);
            }
        }
    }
}

